# SPDX-License-Identifier: Apache-2.0
# Copyright 2013-2021 The Meson development team

__all__ = [
    'InterpreterObject',
    'MesonInterpreterObject',
    'ObjectHolder',
    'IterableObject',
    'MutableInterpreterObject',
    'ContextManagerObject',

    'MesonOperator',

    'Disabler',
    'is_disabled',

    'InterpreterException',
    'InvalidCode',
    'InvalidArguments',
    'SubdirDoneRequest',
    'ContinueRequest',
    'BreakRequest',

    'default_resolve_key',
    'flatten',
    'resolve_second_level_holders',
    'stringifyUserArguments',

    'noPosargs',
    'noKwargs',
    'stringArgs',
    'noArgsFlattening',
    'noSecondLevelHolderResolving',
    'unholder_return',
    'disablerIfNotFound',
    'permittedKwargs',
    'typed_operator',
    'typed_pos_args',
    'ContainerTypeInfo',
    'KwargInfo',
    'typed_kwargs',
    'FeatureCheckBase',
    'FeatureNew',
    'FeatureDeprecated',
    'FeatureBroken',
    'FeatureNewKwargs',
    'FeatureDeprecatedKwargs',

    'InterpreterBase',

    'SubProject',

    'TV_func',
    'TYPE_elementary',
    'TYPE_var',
    'TYPE_nvar',
    'TYPE_kwargs',
    'TYPE_nkwargs',
    'TYPE_key_resolver',
    'TYPE_HoldableTypes',

    'HoldableTypes',
]

from .baseobjects import (
    InterpreterObject,
    MesonInterpreterObject,
    ObjectHolder,
    IterableObject,
    MutableInterpreterObject,
    ContextManagerObject,

    TV_func,
    TYPE_elementary,
    TYPE_var,
    TYPE_nvar,
    TYPE_kwargs,
    TYPE_nkwargs,
    TYPE_key_resolver,
    TYPE_HoldableTypes,

    SubProject,

    HoldableTypes,
)

from .decorators import (
    noPosargs,
    noKwargs,
    stringArgs,
    noArgsFlattening,
    noSecondLevelHolderResolving,
    unholder_return,
    disablerIfNotFound,
    permittedKwargs,
    typed_pos_args,
    ContainerTypeInfo,
    KwargInfo,
    typed_operator,
    typed_kwargs,
    FeatureCheckBase,
    FeatureNew,
    FeatureDeprecated,
    FeatureBroken,
    FeatureNewKwargs,
    FeatureDeprecatedKwargs,
)

from .exceptions import (
    InterpreterException,
    InvalidCode,
    InvalidArguments,
    SubdirDoneRequest,
    ContinueRequest,
    BreakRequest,
)

from .disabler import Disabler, is_disabled
from .helpers import (
    default_resolve_key,
    flatten,
    resolve_second_level_holders,
    stringifyUserArguments,
)
from .interpreterbase import InterpreterBase
from .operator import MesonOperator
