/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.gradle.api.attributes.plugin.GradlePluginApiVersion;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.exception.AbstractResolutionFailureException;
import org.gradle.internal.component.resolution.failure.exception.VariantSelectionException;
import org.gradle.internal.component.resolution.failure.type.IncompatibleGraphVariantFailure;
import org.gradle.internal.component.resolution.failure.type.IncompatibleResolutionFailure;
import org.gradle.util.GradleVersion;

public abstract class NewerGradleNeededByPluginFailureDescriber
extends AbstractResolutionFailureDescriber<IncompatibleGraphVariantFailure> {
    private static final String GRADLE_VERSION_TOO_OLD_TEMPLATE = "Plugin %s requires at least Gradle %s. This build uses %s.";
    private static final String NEEDS_NEWER_GRADLE_SECTION = "sub:updating-gradle";
    private final GradleVersion currentGradleVersion = GradleVersion.current();

    @Override
    public boolean canDescribeFailure(IncompatibleGraphVariantFailure failure) {
        return this.allCandidatesIncompatibleDueToGradleVersionTooLow(failure);
    }

    @Override
    public AbstractResolutionFailureException describeFailure(IncompatibleGraphVariantFailure failure, Optional<AttributesSchemaInternal> schema) {
        GradleVersion minGradleApiVersionSupportedByPlugin = this.findMinGradleVersionSupportedByPlugin((List<ResolutionCandidateAssessor.AssessedCandidate>)failure.getCandidates());
        String message = this.buildPluginNeedsNewerGradleVersionFailureMsg(failure.getRequestedName(), minGradleApiVersionSupportedByPlugin);
        List<String> resolutions = this.buildResolutions(this.suggestUpdateGradle(minGradleApiVersionSupportedByPlugin), this.suggestDowngradePlugin(failure.getRequestedName()));
        return new VariantSelectionException(message, failure, resolutions);
    }

    private boolean allCandidatesIncompatibleDueToGradleVersionTooLow(IncompatibleResolutionFailure failure) {
        boolean requestingPluginApi = failure.getRequestedAttributes().contains(GradlePluginApiVersion.GRADLE_PLUGIN_API_VERSION_ATTRIBUTE);
        boolean allIncompatibleDueToGradleVersion = failure.getCandidates().stream().allMatch(candidate -> candidate.getIncompatibleAttributes().stream().anyMatch(this::isGradlePluginApiAttribute));
        return requestingPluginApi && allIncompatibleDueToGradleVersion;
    }

    private GradleVersion findMinGradleVersionSupportedByPlugin(List<ResolutionCandidateAssessor.AssessedCandidate> candidates) {
        return candidates.stream().map(this::findMinGradleVersionSupportedByPlugin).filter(Optional::isPresent).map(Optional::get).min(Comparator.comparing(GradleVersion::getVersion)).orElseThrow(IllegalStateException::new);
    }

    private Optional<GradleVersion> findMinGradleVersionSupportedByPlugin(ResolutionCandidateAssessor.AssessedCandidate candidate) {
        return candidate.getIncompatibleAttributes().stream().filter(this::isGradlePluginApiAttribute).map(apiVersionAttribute -> GradleVersion.version((String)String.valueOf(apiVersionAttribute.getProvided()))).min(Comparator.comparing(GradleVersion::getVersion));
    }

    private boolean isGradlePluginApiAttribute(ResolutionCandidateAssessor.AssessedAttribute<?> attribute) {
        return attribute.getAttribute().getName().equals(GradlePluginApiVersion.GRADLE_PLUGIN_API_VERSION_ATTRIBUTE.getName());
    }

    private String buildPluginNeedsNewerGradleVersionFailureMsg(String pluginId, GradleVersion minRequiredGradleVersion) {
        return String.format(GRADLE_VERSION_TOO_OLD_TEMPLATE, pluginId, minRequiredGradleVersion.getVersion(), this.currentGradleVersion);
    }

    private String suggestUpdateGradle(GradleVersion minRequiredGradleVersion) {
        return "Upgrade to at least Gradle " + minRequiredGradleVersion.getVersion() + ". See the instructions at " + this.getDocumentationRegistry().getDocumentationFor("upgrading_version_8", "sub:updating-gradle.");
    }

    private String suggestDowngradePlugin(String pluginId) {
        return "Downgrade plugin " + pluginId + " to an older version compatible with " + this.currentGradleVersion + ".";
    }
}

