/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import javax.inject.Inject;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.dsl.CapabilityNotationParserFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitutions;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionRules;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.ModuleSelectorNotationConverter;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.StartParameterResolutionOverride;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.CapabilitiesResolutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultCapabilitiesResolution;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultResolutionStrategy;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.notations.ComponentIdentifierParserFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.Factory;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.vcs.internal.VcsMappingsStore;

public class ResolutionStrategyFactory
implements Factory<ResolutionStrategyInternal> {
    private final BuildState currentBuild;
    private final Instantiator instantiator;
    private final DependencySubstitutionRules globalDependencySubstitutionRules;
    private final VcsMappingsStore vcsMappingsStore;
    private final AttributesFactory attributesFactory;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final ComponentSelectorConverter componentSelectorConverter;
    private final DependencyLockingProvider dependencyLockingProvider;
    private final ModuleSelectorNotationConverter moduleSelectorNotationParser;
    private final ObjectFactory objectFactory;
    private final StartParameterResolutionOverride startParameterResolutionOverride;
    private final NotationParser<Object, Capability> capabilityNotationParser;
    private final NotationParser<Object, ComponentIdentifier> componentIdentifierNotationParser;

    @Inject
    public ResolutionStrategyFactory(BuildState currentBuild, Instantiator instantiator, DependencySubstitutionRules globalDependencySubstitutionRules, VcsMappingsStore vcsMappingsStore, AttributesFactory attributesFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ComponentSelectorConverter componentSelectorConverter, DependencyLockingProvider dependencyLockingProvider, ModuleSelectorNotationConverter moduleSelectorNotationParser, ObjectFactory objectFactory, StartParameterResolutionOverride startParameterResolutionOverride) {
        this.currentBuild = currentBuild;
        this.instantiator = instantiator;
        this.globalDependencySubstitutionRules = globalDependencySubstitutionRules;
        this.vcsMappingsStore = vcsMappingsStore;
        this.attributesFactory = attributesFactory;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.componentSelectorConverter = componentSelectorConverter;
        this.dependencyLockingProvider = dependencyLockingProvider;
        this.moduleSelectorNotationParser = moduleSelectorNotationParser;
        this.objectFactory = objectFactory;
        this.startParameterResolutionOverride = startParameterResolutionOverride;
        this.capabilityNotationParser = new CapabilityNotationParserFactory(false).create();
        this.componentIdentifierNotationParser = new ComponentIdentifierParserFactory().create();
    }

    public ResolutionStrategyInternal create() {
        CapabilitiesResolutionInternal capabilitiesResolutionInternal = (CapabilitiesResolutionInternal)this.instantiator.newInstance(DefaultCapabilitiesResolution.class, new Object[]{this.capabilityNotationParser, this.componentIdentifierNotationParser});
        DefaultDependencySubstitutions dependencySubstitutions = DefaultDependencySubstitutions.forResolutionStrategy(this.currentBuild, this.moduleSelectorNotationParser, this.instantiator, this.objectFactory, this.attributesFactory, this.capabilityNotationParser);
        ResolutionStrategyInternal resolutionStrategyInternal = (ResolutionStrategyInternal)this.instantiator.newInstance(DefaultResolutionStrategy.class, new Object[]{this.globalDependencySubstitutionRules, this.vcsMappingsStore, dependencySubstitutions, this.moduleIdentifierFactory, this.componentSelectorConverter, this.dependencyLockingProvider, capabilitiesResolutionInternal, this.objectFactory});
        this.startParameterResolutionOverride.applyToCachePolicy(resolutionStrategyInternal.getCachePolicy());
        return resolutionStrategyInternal;
    }
}

