/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.internal.file.EmptyFileCollection;
import org.gradle.api.internal.file.EmptyFileTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.FileCollectionObservationListener;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Global.class, Scope.BuildTree.class, Scope.Build.class, Scope.Project.class})
public interface FileCollectionFactory {
    public FileCollectionFactory withResolver(PathToFileResolver var1);

    public FileCollectionFactory forChildScope(FileCollectionObservationListener var1);

    public FileCollectionFactory forChildScope(PathToFileResolver var1, TaskDependencyFactory var2, PropertyHost var3);

    public FileCollectionInternal create(MinimalFileSet var1);

    public FileCollectionInternal create(TaskDependency var1, MinimalFileSet var2);

    public FileCollectionInternal create(MinimalFileSet var1, Consumer<? super TaskDependencyResolveContext> var2);

    public static FileCollectionInternal empty(String displayName) {
        if ("file collection".equals(displayName)) {
            return FileCollectionFactory.empty();
        }
        return new EmptyFileCollection(displayName);
    }

    public static FileCollectionInternal empty() {
        return EmptyFileCollection.INSTANCE;
    }

    public FileCollectionInternal fixed(File ... var1);

    public FileCollectionInternal fixed(Collection<File> var1);

    public FileCollectionInternal fixed(String var1, File ... var2);

    public FileCollectionInternal fixed(String var1, Collection<File> var2);

    public FileCollectionInternal resolving(String var1, Object var2);

    public FileCollectionInternal resolvingLeniently(String var1, Object var2);

    public FileCollectionInternal resolving(Object var1);

    public FileCollectionInternal resolvingLeniently(Object var1);

    public ConfigurableFileCollection configurableFiles(String var1);

    public ConfigurableFileCollection configurableFiles();

    public ConfigurableFileTree fileTree();

    public FileTreeInternal generated(Factory<File> var1, String var2, Action<File> var3, Action<OutputStream> var4);

    public FileTreeInternal treeOf(List<? extends FileTreeInternal> var1);

    public FileTreeInternal treeOf(MinimalFileTree var1);

    public static FileTreeInternal emptyTree() {
        return EmptyFileTree.INSTANCE;
    }

    public static FileTreeInternal emptyTree(String displayName) {
        if ("file tree".equals(displayName)) {
            return FileCollectionFactory.emptyTree();
        }
        return new EmptyFileTree(displayName);
    }
}

