/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.Action;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.CppProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.ScriptBlockBuilder;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;

public class CppLibraryProjectInitDescriptor
extends CppProjectInitDescriptor {
    public CppLibraryProjectInitDescriptor(TemplateOperationFactory templateOperationFactory, DocumentationRegistry documentationRegistry) {
        super(templateOperationFactory, documentationRegistry);
    }

    @Override
    public String getId() {
        return "cpp-library";
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.LIBRARY;
    }

    @Override
    protected TemplateOperation sourceTemplateOperation(InitSettings settings) {
        return this.fromCppTemplate("cpplibrary/hello.cpp.template", settings, "main", "cpp");
    }

    @Override
    protected TemplateOperation headerTemplateOperation(InitSettings settings) {
        return this.fromCppTemplate("cpplibrary/hello.h.template", settings.getProjectName() + ".h", settings, "main", "public");
    }

    @Override
    protected TemplateOperation testTemplateOperation(InitSettings settings) {
        return this.fromCppTemplate("cpplibrary/hello_test.cpp.template", settings, "test", "cpp");
    }

    @Override
    protected void configureBuildScript(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        buildScriptBuilder.plugin("Apply the cpp-library plugin to add support for building C++ libraries", "cpp-library").plugin("Apply the cpp-unit-test plugin to add support for building and running C++ test executables", "cpp-unit-test").block(null, "library", (Action<? super ScriptBlockBuilder>)((Action)b -> b.methodInvocation("Set the target operating system and architecture for this library", "targetMachines.add", buildScriptBuilder.propertyExpression(this.getHostTargetMachineDefinition()))));
    }
}

