/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenImmutableAttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.capabilities.CapabilityInternal;
import org.gradle.internal.component.external.model.AbstractStatelessDerivationStrategy;
import org.gradle.internal.component.external.model.DefaultConfigurationMetadata;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ShadowedImmutableCapability;
import org.gradle.internal.component.external.model.maven.DefaultMavenModuleResolveMetadata;
import org.gradle.internal.component.model.ModuleConfigurationMetadata;

public class JavaEcosystemVariantDerivationStrategy
extends AbstractStatelessDerivationStrategy {
    private static final JavaEcosystemVariantDerivationStrategy INSTANCE = new JavaEcosystemVariantDerivationStrategy();

    private JavaEcosystemVariantDerivationStrategy() {
    }

    public static JavaEcosystemVariantDerivationStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean derivesVariants() {
        return true;
    }

    @Override
    public ImmutableList<? extends ModuleConfigurationMetadata> derive(ModuleComponentResolveMetadata metadata) {
        if (metadata instanceof DefaultMavenModuleResolveMetadata) {
            DefaultMavenModuleResolveMetadata md = (DefaultMavenModuleResolveMetadata)metadata;
            ImmutableAttributes attributes = md.getAttributes();
            MavenImmutableAttributesFactory attributesFactory = (MavenImmutableAttributesFactory)md.getAttributesFactory();
            DefaultConfigurationMetadata compileConfiguration = (DefaultConfigurationMetadata)md.getConfiguration("compile");
            DefaultConfigurationMetadata runtimeConfiguration = (DefaultConfigurationMetadata)md.getConfiguration("runtime");
            ModuleComponentIdentifier componentId = md.getId();
            ImmutableCapabilities shadowedPlatformCapability = JavaEcosystemVariantDerivationStrategy.buildShadowPlatformCapability(componentId, false);
            ImmutableCapabilities shadowedEnforcedPlatformCapability = JavaEcosystemVariantDerivationStrategy.buildShadowPlatformCapability(componentId, true);
            return ImmutableList.of((Object)JavaEcosystemVariantDerivationStrategy.libraryCompileScope(compileConfiguration, attributes, attributesFactory), (Object)JavaEcosystemVariantDerivationStrategy.libraryRuntimeScope(runtimeConfiguration, attributes, attributesFactory), (Object)JavaEcosystemVariantDerivationStrategy.libraryWithSourcesVariant(runtimeConfiguration, attributes, attributesFactory, metadata), (Object)JavaEcosystemVariantDerivationStrategy.libraryWithJavadocVariant(runtimeConfiguration, attributes, attributesFactory, metadata), (Object)JavaEcosystemVariantDerivationStrategy.platformWithUsageAttribute(compileConfiguration, attributes, attributesFactory, "java-api", false, shadowedPlatformCapability), (Object)JavaEcosystemVariantDerivationStrategy.platformWithUsageAttribute(runtimeConfiguration, attributes, attributesFactory, "java-runtime", false, shadowedPlatformCapability), (Object)JavaEcosystemVariantDerivationStrategy.platformWithUsageAttribute(compileConfiguration, attributes, attributesFactory, "java-api", true, shadowedEnforcedPlatformCapability), (Object)JavaEcosystemVariantDerivationStrategy.platformWithUsageAttribute(runtimeConfiguration, attributes, attributesFactory, "java-runtime", true, shadowedEnforcedPlatformCapability));
        }
        return null;
    }

    private static DefaultConfigurationMetadata libraryWithSourcesVariant(DefaultConfigurationMetadata runtimeConfiguration, ImmutableAttributes originAttributes, MavenImmutableAttributesFactory attributesFactory, ModuleComponentResolveMetadata metadata) {
        return runtimeConfiguration.mutate().withName("sources").withAttributes(attributesFactory.sourcesVariant(originAttributes)).withArtifacts((ImmutableList<? extends ModuleComponentArtifactMetadata>)ImmutableList.of((Object)metadata.optionalArtifact("jar", "jar", "sources"))).withoutConstraints().build();
    }

    private static ModuleConfigurationMetadata libraryWithJavadocVariant(DefaultConfigurationMetadata runtimeConfiguration, ImmutableAttributes originAttributes, MavenImmutableAttributesFactory attributesFactory, ModuleComponentResolveMetadata metadata) {
        return runtimeConfiguration.mutate().withName("javadoc").withAttributes(attributesFactory.javadocVariant(originAttributes)).withArtifacts((ImmutableList<? extends ModuleComponentArtifactMetadata>)ImmutableList.of((Object)metadata.optionalArtifact("jar", "jar", "javadoc"))).withoutConstraints().build();
    }

    private static ImmutableCapabilities buildShadowPlatformCapability(ModuleComponentIdentifier componentId, boolean enforced) {
        return ImmutableCapabilities.of((Capability)new ShadowedImmutableCapability((CapabilityInternal)new DefaultImmutableCapability(componentId.getGroup(), componentId.getModule(), componentId.getVersion()), enforced ? "-derived-enforced-platform" : "-derived-platform"));
    }

    private static ModuleConfigurationMetadata libraryCompileScope(DefaultConfigurationMetadata conf, ImmutableAttributes originAttributes, MavenImmutableAttributesFactory attributesFactory) {
        ImmutableAttributes attributes = attributesFactory.compileScope(originAttributes);
        return conf.mutate().withAttributes(attributes).withoutConstraints().build();
    }

    private static ModuleConfigurationMetadata libraryRuntimeScope(DefaultConfigurationMetadata conf, ImmutableAttributes originAttributes, MavenImmutableAttributesFactory attributesFactory) {
        ImmutableAttributes attributes = attributesFactory.runtimeScope(originAttributes);
        return conf.mutate().withAttributes(attributes).withoutConstraints().build();
    }

    private static ModuleConfigurationMetadata platformWithUsageAttribute(DefaultConfigurationMetadata conf, ImmutableAttributes originAttributes, MavenImmutableAttributesFactory attributesFactory, String usage, boolean enforcedPlatform, ImmutableCapabilities shadowedPlatformCapability) {
        ImmutableAttributes attributes = attributesFactory.platformWithUsage(originAttributes, usage, enforcedPlatform);
        String prefix = enforcedPlatform ? "enforced-platform-" : "platform-";
        DefaultConfigurationMetadata.Builder builder = conf.mutate().withName(prefix + conf.getName()).withAttributes(attributes).withConstraintsOnly().withCapabilities(shadowedPlatformCapability);
        if (enforcedPlatform) {
            builder = builder.withForcedDependencies();
        }
        return builder.build();
    }
}

