# 0.0.19

**Version:** 0.0.19
**Published:** 2023-06-04T16:21:59Z

## Release Notes

🎊 Delighted to unveil the fresh release of Rust coreutils! This iteration offers an array of enhancements and novel functionalities. Key updates include enhancements to the GNU test suite compatibility, and finessed operations in a variety of utilities such as cksum, chmod, chroot, comm, cp, cut, and a multitude of others.
We're making strides towards a production-ready toolset.


## GNU test suite compatibility

Many utils have gotten minor changes to improve GNU compatibility. Below is a summary of the progress. See https://github.com/uutils/coreutils-tracking/ for more details

| result | 0.0.18 | 0.0.19 | change |
|--------|-------:|-------:|-------:|
| pass   |    340 |    365 |   +25 |
| skip   |     50 |     49 |    -1 |
| fail   |    210 |    186 |   -24 |
| error  |      2 |      2 |     0 |

![GNU testsuite evolution](https://github.com/uutils/coreutils-tracking/blob/main/gnu-results.png?raw=true)


## Detailed changes

### global
* GNU/coreutils: update reference to 9.3 by @cakebaker in https://github.com/uutils/coreutils/pull/4754
* New release by @sylvestre in https://github.com/uutils/coreutils/pull/4926
* be more consistent in the help. use follow for deference options by @sylvestre in https://github.com/uutils/coreutils/pull/4739
* Remove some unnecessary "extern crate" statements by @cakebaker in https://github.com/uutils/coreutils/pull/4721
* tests: remove all "extern crate" statements by @cakebaker in https://github.com/uutils/coreutils/pull/4722
* coreutils: fixed panic when multi-call binary has funny name by @BartMassey in https://github.com/uutils/coreutils/pull/4366


### b2sum

* B2sum: add -l/--length option by @spineki in https://github.com/uutils/coreutils/pull/4729

### basenc
* basenc: add help texts for options by @cakebaker in https://github.com/uutils/coreutils/pull/4850

### chgrp
* fix help message in chgrp by @m11o in https://github.com/uutils/coreutils/pull/4824

### chown
* fix #4767: `chown -v 0 nf` isn't showing a message  by @djedi23 in https://github.com/uutils/coreutils/pull/4768
* fix #4615: chown isnt showing a message by @djedi23 in https://github.com/uutils/coreutils/pull/4758

### cksum
* cksum: remove "-a="s from markdown file by @cakebaker in https://github.com/uutils/coreutils/pull/4814
* cksum: split test function into two by @cakebaker in https://github.com/uutils/coreutils/pull/4854
* cksum: fix output of --algorithm by @cakebaker in https://github.com/uutils/coreutils/pull/4856
* cksum: implement --untagged by @cakebaker in https://github.com/uutils/coreutils/pull/4860


### cp

* cp: add support POSIXLY_CORRECT=1 when dealing with dangling links by @sylvestre in https://github.com/uutils/coreutils/pull/4812
* cp: fix cp -f f loop when loop is a symlink loop by @sylvestre in https://github.com/uutils/coreutils/pull/4820
* cp: fix "after help" output by @cakebaker in https://github.com/uutils/coreutils/pull/4828
* cp: preserve permission on -p --parents by @shinhs0506 in https://github.com/uutils/coreutils/pull/4853
* cp: preserve permissions on -r -p --parents by @shinhs0506 in https://github.com/uutils/coreutils/pull/4859
* cp: Accept --preserve=link by @sylvestre in https://github.com/uutils/coreutils/pull/4910
* cp: -i prompts in the right place and other improv by @sylvestre in https://github.com/uutils/coreutils/pull/4925
* cp: replace assert!(false) with panic!() by @cakebaker in https://github.com/uutils/coreutils/pull/4930
* cp: makes --preserve requires = by @granquet in https://github.com/uutils/coreutils/pull/4928
* Add support for `cp --debug` by @sylvestre in https://github.com/uutils/coreutils/pull/4909

### date
* date -d supports - 1 year ago, 2 second, etc by @sylvestre in https://github.com/uutils/coreutils/pull/4790
* Improve the date md page by @sylvestre in https://github.com/uutils/coreutils/pull/4789
* date: fix error message when opening file by @leon3s in https://github.com/uutils/coreutils/pull/4544
* date: bring back the test by @sylvestre in https://github.com/uutils/coreutils/pull/4889
* date: Catch format string that is not supported by chrono by @jaggededgedjustice in https://github.com/uutils/coreutils/pull/4244


### dd

* dd: fix some clippy warnings 'variable does not need to be mutable' by @sylvestre in https://github.com/uutils/coreutils/pull/4842
* dd: fix "unused imports" warning in tests by @cakebaker in https://github.com/uutils/coreutils/pull/4843
* dd: support the [io]flag=nocache option by @jfinkels in https://github.com/uutils/coreutils/pull/4432

### dircolors

* dircolors: trigger an error when used on / by @sylvestre in https://github.com/uutils/coreutils/pull/4672

### du

* du: add support of --dereference-args & minor changes by @sylvestre in https://github.com/uutils/coreutils/pull/4723
* du: fix clippy warning in test by @cakebaker in https://github.com/uutils/coreutils/pull/4765

### factor

* factor: fix unused import in test by @cakebaker in https://github.com/uutils/coreutils/pull/4711
* factor: remove unnecessary "extern crate" in test by @cakebaker in https://github.com/uutils/coreutils/pull/4712
* Add flush after calculating factor by @vikiminki in https://github.com/uutils/coreutils/pull/4776
* factor: add -h/--exponents option by @Ideflop in https://github.com/uutils/coreutils/pull/4710

### fmt
* fmt: cleanup tests by @cakebaker in https://github.com/uutils/coreutils/pull/4753

### hashsum
* fix: Correctly detect format when using md5sum with check flag by @kamilogorek in https://github.com/uutils/coreutils/pull/4645

### head
* `head`: use `OsStringExt::from_vec` instead of `std::from_utf8_unchecked` by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4923

### ls

* Improve the readibility of ls code by @sylvestre in https://github.com/uutils/coreutils/pull/4733
* Use `expected_result` in test_ls to avoid spurious failures by @sunfishcode in https://github.com/uutils/coreutils/pull/4784
* ls: device number for BSDs and solarishOS by @SteveLauC in https://github.com/uutils/coreutils/pull/4841
* ls: when facing an invalid utf-8, don't panic by @sylvestre in https://github.com/uutils/coreutils/pull/4861
* [tests/ls] Support user names containing dots by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/4798

### mkdir

* mkdir: set correct permissions on dirs created by -p by @shinhs0506 in https://github.com/uutils/coreutils/pull/4876
* Mkdir: explicit umask and sequential tests by @shinhs0506 in https://github.com/uutils/coreutils/pull/4896

### mktemp
* mktemp: fix PrefixContainsDirSeparator verification by @ZauJulio in https://github.com/uutils/coreutils/pull/4379
* mktemp -t foo.XXXX should create in TMPDIR by @sylvestre in https://github.com/uutils/coreutils/pull/4832
* mktemp: two small test refactorings by @cakebaker in https://github.com/uutils/coreutils/pull/4877
* mktemp: prioritize TMPDIR over -p when using -t by @cakebaker in https://github.com/uutils/coreutils/pull/4878

### more

* more: support PageDown/PageUp keys by @cakebaker in https://github.com/uutils/coreutils/pull/4873
* more: add arguments print over and clean print by @Ideflop in https://github.com/uutils/coreutils/pull/4872
* more: remove empty "else"-branches in tests by @cakebaker in https://github.com/uutils/coreutils/pull/4880
* fix(#4886) more: panics if file is not readable by @Ludmuterol in https://github.com/uutils/coreutils/pull/4888
* more: implement argument -s / --squeeze by @Ideflop in https://github.com/uutils/coreutils/pull/4903
* more: implement arguments -n/--lines and --number by @Ideflop in https://github.com/uutils/coreutils/pull/4914

### mv
* mv: adapt -n behavior to GNU mv 9.3 by @cakebaker in https://github.com/uutils/coreutils/pull/4782
* mv: show no error if overwriting is declined in interactive mode by @cakebaker in https://github.com/uutils/coreutils/pull/4773
* mv: add 'renamed " in the beginning of the message when verbose flag is set by @shinhs0506 in https://github.com/uutils/coreutils/pull/4787
* mv: check if --target is a directory by @shinhs0506 in https://github.com/uutils/coreutils/pull/4794
* mv: validate --target arg by @cakebaker in https://github.com/uutils/coreutils/pull/4802
* mv, cp: add support for --update=none,all,older by @shinhs0506 in https://github.com/uutils/coreutils/pull/4796
* fix tests/mv/i-5.sh by @shinhs0506 in https://github.com/uutils/coreutils/pull/4823
* mv: if more than one of -i, -f, -n is specified, only the final one takes effect by @cakebaker in https://github.com/uutils/coreutils/pull/4826
* mv: 'mv source hardlink' should fail by @sylvestre in https://github.com/uutils/coreutils/pull/4831
* mv: add missing semicolons to tests by @cakebaker in https://github.com/uutils/coreutils/pull/4891
* mv: Show 'skipped' when a file isn't overwriten by @sylvestre in https://github.com/uutils/coreutils/pull/4905

### nice
* Avoid spurious failures in the presence of non-zero default nice by @sunfishcode in https://github.com/uutils/coreutils/pull/4783

### paste
* paste: handle list ending with unescaped backslash by @cakebaker in https://github.com/uutils/coreutils/pull/3661

### pwd
* pwd: Allow -P flag precedence over POSIXLY_CORRECT by @tracym in https://github.com/uutils/coreutils/pull/4937

### rm
* gnu: adjust tests/rm/inaccessible.sh error message by @sylvestre in https://github.com/uutils/coreutils/pull/4809
* rm: support non-UTF-8 paths by @jeddenlea in https://github.com/uutils/coreutils/pull/4871
* fix rm/interactive-always.sh by @shinhs0506 in https://github.com/uutils/coreutils/pull/4890

### shred
* shred: add support for octal and hex size by @shinhs0506 in https://github.com/uutils/coreutils/pull/4918

### tail

* tail/args: Fix parsing when -F is used together with --retry or --follow by @Joining7943 in https://github.com/uutils/coreutils/pull/4734
* 'tail': Change static global variables to const by @Joining7943 in https://github.com/uutils/coreutils/pull/4777

### touch

* To provide dates like "yesterday, tomorrow, etc",  Use the humantime_to_duration crate by @sylvestre in https://github.com/uutils/coreutils/pull/4778
* touch: add support for --ref and --date together by @Xalfer in https://github.com/uutils/coreutils/pull/4717
* touch: remove unnecessary "extern crate"s by @cakebaker in https://github.com/uutils/coreutils/pull/4718
* touch: improve support for dangling link by @sylvestre in https://github.com/uutils/coreutils/pull/4769

### uniq
* uniq: non-UTF-8 file names and fewer copies by @jeddenlea in https://github.com/uutils/coreutils/pull/4911

### wc

* wc: use concat! to improve readability of tests by @cakebaker in https://github.com/uutils/coreutils/pull/4707
* test,wc: use vars directly in format! strings by @cakebaker in https://github.com/uutils/coreutils/pull/4760
* wc: streaming --files0-from and other improvements by @jeddenlea in https://github.com/uutils/coreutils/pull/4696

### whoami
* tests/whoami: add windows test for issue #4614 by @garydev10 in https://github.com/uutils/coreutils/pull/4901

### yes
* yes: support non-UTF-8 args by @jeddenlea in https://github.com/uutils/coreutils/pull/4862

### uucore

* uucore: remove commented out imports by @cakebaker in https://github.com/uutils/coreutils/pull/4720
* Fix a warning in upstream code on Rust nightly. by @sunfishcode in https://github.com/uutils/coreutils/pull/4781

## Code quality
* Fix incorrect comment & remove irrelevant comment by @cakebaker in https://github.com/uutils/coreutils/pull/4738
* fix some clippy warnings in tests by @sylvestre in https://github.com/uutils/coreutils/pull/4759
* Reduce cognitive complexity: just move some of the contents in functions by @sylvestre in https://github.com/uutils/coreutils/pull/4743
* Lower the clippy cognitive complexity & fix lines_filter_map_ok  by @sylvestre in https://github.com/uutils/coreutils/pull/4834
* Fix some semicolon_if_nothing_returned by @sylvestre in https://github.com/uutils/coreutils/pull/4839

## CI/CD improvements

* `ci`: Run tests with nextest by @Joining7943 in https://github.com/uutils/coreutils/pull/4740
* Use the full path for the ignore list by @sylvestre in https://github.com/uutils/coreutils/pull/4728
* CICD: fix full path for the ignore list by @cakebaker in https://github.com/uutils/coreutils/pull/4730
* CI: compute individual binary sizes by @miles170 in https://github.com/uutils/coreutils/pull/4694
* ci: Fix usages of rust-cache to produce more cache hits by @Joining7943 in https://github.com/uutils/coreutils/pull/4742
* ci/android: speed up build and test by @Joining7943 in https://github.com/uutils/coreutils/pull/4745
* build-gnu.sh: always update PATH in Makefile by @cakebaker in https://github.com/uutils/coreutils/pull/4791
* android: use cargo test instead of nextest by @sylvestre in https://github.com/uutils/coreutils/pull/4801
* CI: warn if the size of the binary increases by more than 5% by @miles170 in https://github.com/uutils/coreutils/pull/4693
* `ci/gnu tests`: fix Swatinem/rust-cache to use correct workspace by @Joining7943 in https://github.com/uutils/coreutils/pull/4766
* `ci`: Improve and speed up setup steps using github actions by @Joining7943 in https://github.com/uutils/coreutils/pull/4771
* android: try to use nextest again by @sylvestre in https://github.com/uutils/coreutils/pull/4835
* remaining-gnu-error.py: split SKIP & ERROR by @sylvestre in https://github.com/uutils/coreutils/pull/4863
* Document why tests are skipped by @sylvestre in https://github.com/uutils/coreutils/pull/4864

## Doc improvements
* docs: add extension (short options with args) by @cakebaker in https://github.com/uutils/coreutils/pull/4851
* doc: show a warning when no tldr example by @sylvestre in https://github.com/uutils/coreutils/pull/4847
* uudoc: fix clippy warnings by @cakebaker in https://github.com/uutils/coreutils/pull/4761
* docs: document fmt in GNU extensions by @cakebaker in https://github.com/uutils/coreutils/pull/4748
* pinky: move help strings to markdown file by @m11o in https://github.com/uutils/coreutils/pull/4701
* true: move help strings to markdown file by @piotrkwiecinski in https://github.com/uutils/coreutils/pull/4703
* unexpand: move help strings to markdown file by @piotrkwiecinski in https://github.com/uutils/coreutils/pull/4704
* printf: move help strings to markdown file by @m11o in https://github.com/uutils/coreutils/pull/4705
* uudoc, uucore_procs: move markdown parsing to HelpParser by @cakebaker in https://github.com/uutils/coreutils/pull/4398
* readlink: move help strings to markdown file by @m11o in https://github.com/uutils/coreutils/pull/4770
* runcon: move help strings to markdown file by @m11o in https://github.com/uutils/coreutils/pull/4774
* seq: move help strings to markdown file by @m11o in https://github.com/uutils/coreutils/pull/4779
* split: move help strings to markdown file by @m11o in https://github.com/uutils/coreutils/pull/4785
* stdbuf: move help strings to markdown file by @m11o in https://github.com/uutils/coreutils/pull/4792
* stty: move help strings to markdown file by @m11o in https://github.com/uutils/coreutils/pull/4797
* sum: move help strings to markdown file by @m11o in https://github.com/uutils/coreutils/pull/4799
* sync: move help strings to markdown file by @m11o in https://github.com/uutils/coreutils/pull/4800
* timeout: move help strings to markdown file by @m11o in https://github.com/uutils/coreutils/pull/4806
* tr: move help string to markdown file by @iambasanta in https://github.com/uutils/coreutils/pull/4805
* sort: Move help strings to markdown file by @iambasanta in https://github.com/uutils/coreutils/pull/4808
* test: move help strings to markdown file by @m11o in https://github.com/uutils/coreutils/pull/4816
* tsort: move help strings to markdown file by @m11o in https://github.com/uutils/coreutils/pull/4829
* tty: move help strings to markdown file by @m11o in https://github.com/uutils/coreutils/pull/4837

## New Contributors
* @m11o made their first contribution in https://github.com/uutils/coreutils/pull/4701
* @Xalfer made their first contribution in https://github.com/uutils/coreutils/pull/4717
* @spineki made their first contribution in https://github.com/uutils/coreutils/pull/4729
* @Ideflop made their first contribution in https://github.com/uutils/coreutils/pull/4710
* @publicmatt made their first contribution in https://github.com/uutils/coreutils/pull/4460
* @vikiminki made their first contribution in https://github.com/uutils/coreutils/pull/4776
* @sunfishcode made their first contribution in https://github.com/uutils/coreutils/pull/4781
* @shinhs0506 made their first contribution in https://github.com/uutils/coreutils/pull/4787
* @ZauJulio made their first contribution in https://github.com/uutils/coreutils/pull/4379
* @BartMassey made their first contribution in https://github.com/uutils/coreutils/pull/4366
* @iambasanta made their first contribution in https://github.com/uutils/coreutils/pull/4805
* @jeddenlea made their first contribution in https://github.com/uutils/coreutils/pull/4862
* @Ludmuterol made their first contribution in https://github.com/uutils/coreutils/pull/4888
* @garydev10 made their first contribution in https://github.com/uutils/coreutils/pull/4901
* @granquet made their first contribution in https://github.com/uutils/coreutils/pull/4928
* @tracym made their first contribution in https://github.com/uutils/coreutils/pull/4937


## Dependencies
* remove utf8 dependency. by @publicmatt in https://github.com/uutils/coreutils/pull/4460
* Bump fundu to 0.5.1 and fix tests by @cakebaker in https://github.com/uutils/coreutils/pull/4813
* Remove unused "num_cpus" dependency by @cakebaker in https://github.com/uutils/coreutils/pull/4898
* Bump crates to phase out windows-sys 0.42.0 by @cakebaker in https://github.com/uutils/coreutils/pull/4908
* Bump windows-targets to 0.42.2 and add it with its dependencies to deny.toml by @cakebaker in https://github.com/uutils/coreutils/pull/4915
* update to platform-info 2.0.1 by @sylvestre in https://github.com/uutils/coreutils/pull/4897
* Bump crossbeam(-channel, -epoch, -utils) crates by @cakebaker in https://github.com/uutils/coreutils/pull/4894
* Bump rustix crates by @cakebaker in https://github.com/uutils/coreutils/pull/4899
* Bump io-lifetimes and remove it from the skip list in deny.toml by @cakebaker in https://github.com/uutils/coreutils/pull/4920
* Bump notify to 5.2.0 and disable tests on android by @cakebaker in https://github.com/uutils/coreutils/pull/4904
* chore(deps): update davidanson/markdownlint-cli2-action action to v10 by @renovate in https://github.com/uutils/coreutils/pull/4788
* fix(deps): update rust crate libc to 0.2.141 by @renovate in https://github.com/uutils/coreutils/pull/4706
* chore(deps): update rust crate hex-literal to 0.4.1 by @renovate in https://github.com/uutils/coreutils/pull/4709
* chore(deps): update rust crate sha3 to 0.10.7 by @renovate in https://github.com/uutils/coreutils/pull/4732
* chore(deps): update rust crate lscolors to 0.14.0 by @renovate in https://github.com/uutils/coreutils/pull/4735
* fix(deps): update rust crate dunce to 1.0.4 by @renovate in https://github.com/uutils/coreutils/pull/4751
* fix(deps): update rust crate libc to 0.2.142 by @renovate in https://github.com/uutils/coreutils/pull/4755
* chore(deps): update rust crate regex to 1.8.1 by @renovate in https://github.com/uutils/coreutils/pull/4757
* chore(deps): update rust crate humantime_to_duration to 0.1.3 by @renovate in https://github.com/uutils/coreutils/pull/4786
* chore(deps): update rust crate notify to v6 by @renovate in https://github.com/uutils/coreutils/pull/4870
* chore(deps): update rust crate regex to 1.8.3 by @renovate in https://github.com/uutils/coreutils/pull/4900
* chore(deps): update rust crate redox_syscall to 0.3 by @renovate in https://github.com/uutils/coreutils/pull/4670
* chore(deps): update rust crate tempfile to 3.5.0 by @renovate in https://github.com/uutils/coreutils/pull/4679
* chore(deps): update rust crate chrono to ^0.4.25 by @renovate in https://github.com/uutils/coreutils/pull/4912
* chore(deps): update rust crate once_cell to 1.17.2 by @renovate in https://github.com/uutils/coreutils/pull/4913
* chore(deps): update rust crate clap to 4.3 by @renovate in https://github.com/uutils/coreutils/pull/4881
* chore(deps): update rust crate is-terminal to 0.4.7 by @renovate in https://github.com/uutils/coreutils/pull/4716
* chore(deps): update rust crate terminal_size to 0.2.6 by @renovate in https://github.com/uutils/coreutils/pull/4702
* fix(deps): update rust crate dns-lookup to v2 by @renovate in https://github.com/uutils/coreutils/pull/4803
* fix(deps): update rust crate windows-sys to 0.48.0 by @renovate in https://github.com/uutils/coreutils/pull/4698
* chore(deps): update rust crate ctrlc to 3.3 by @renovate in https://github.com/uutils/coreutils/pull/4907
* chore(deps): update rust crate chrono to ^0.4.26 by @renovate in https://github.com/uutils/coreutils/pull/4922
* chore(deps): update rust crate ctrlc to 3.4 by @renovate in https://github.com/uutils/coreutils/pull/4921
* fix(deps): update rust crate libc to 0.2.143 by @renovate in https://github.com/uutils/coreutils/pull/4840
* chore(deps): update rust crate zip to 0.6.5 by @renovate in https://github.com/uutils/coreutils/pull/4838
* chore(deps): update rust crate sha3 to 0.10.8 by @renovate in https://github.com/uutils/coreutils/pull/4830
* fix(deps): update rust crate libc to 0.2.144 by @renovate in https://github.com/uutils/coreutils/pull/4848
* fix(deps): update rust crate memmap2 to 0.6 by @renovate in https://github.com/uutils/coreutils/pull/4852
* chore(deps): update rust crate humantime_to_duration to 0.2.1 by @renovate in https://github.com/uutils/coreutils/pull/4858
* chore(deps): update rust crate humantime_to_duration to 0.2.0 by @renovate in https://github.com/uutils/coreutils/pull/4857
* chore(deps): update rust crate zip to 0.6.6 by @renovate in https://github.com/uutils/coreutils/pull/4865
* chore(deps): update rust crate sm3 to 0.4.2 by @renovate in https://github.com/uutils/coreutils/pull/4866
* chore(deps): update rust crate clap_complete to 4.3 by @renovate in https://github.com/uutils/coreutils/pull/4882
* fix(deps): update rust crate data-encoding to 2.4 by @renovate in https://github.com/uutils/coreutils/pull/4883
* fix(deps): update rust crate data-encoding-macro to 0.1.13 by @renovate in https://github.com/uutils/coreutils/pull/4884
* chore(deps): update rust crate digest to 0.10.7 by @renovate in https://github.com/uutils/coreutils/pull/4885
* chore(deps): update rust crate bstr to 1.5 by @renovate in https://github.com/uutils/coreutils/pull/4887
* chore(deps): update rust crate regex to 1.8.2 by @renovate in https://github.com/uutils/coreutils/pull/4893


**Full Changelog**: https://github.com/uutils/coreutils/compare/0.0.18...0.0.19
