; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=arm64-apple-ios -mattr=+sve -o - %s | FileCheck %s
; RUN: llc -mtriple=aarch64_be-unknown-linux -mattr=+sve -o - %s | FileCheck --check-prefix=CHECK-BE %s
; RUN: llc -mtriple=arm64-apple-ios -mattr=+global-isel -mattr=+sve -o - %s | FileCheck %s
; RUN: llc -mtriple=aarch64_be-unknown-linux -mattr=+global-isel -mattr=+sve -o - %s | FileCheck --check-prefix=CHECK-BE %s

define void @zext_of_concat(ptr %a, ptr %b, ptr %c, ptr %d) nounwind {
; CHECK-LABEL: zext_of_concat:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ldr d1, [x1]
; CHECK-NEXT:    add.2s v0, v0, v1
; CHECK-NEXT:    ldr q1, [x2]
; CHECK-NEXT:    ushll.2d v0, v0, #0
; CHECK-NEXT:    add.4s v0, v0, v1
; CHECK-NEXT:    str q0, [x2]
; CHECK-NEXT:    ret
;
; CHECK-BE-LABEL: zext_of_concat:
; CHECK-BE:       // %bb.0:
; CHECK-BE-NEXT:    ld1 { v0.2s }, [x0]
; CHECK-BE-NEXT:    ld1 { v1.2s }, [x1]
; CHECK-BE-NEXT:    add v0.2s, v0.2s, v1.2s
; CHECK-BE-NEXT:    movi v1.2d, #0000000000000000
; CHECK-BE-NEXT:    zip1 v0.4s, v0.4s, v0.4s
; CHECK-BE-NEXT:    trn2 v0.4s, v0.4s, v1.4s
; CHECK-BE-NEXT:    ld1 { v1.4s }, [x2]
; CHECK-BE-NEXT:    add v0.4s, v0.4s, v1.4s
; CHECK-BE-NEXT:    st1 { v0.4s }, [x2]
; CHECK-BE-NEXT:    ret
  %i0.a = load <2 x i32>, ptr %a
  %i0.b = load <2 x i32>, ptr %b
  %i0 = add <2 x i32> %i0.a, %i0.b
  %i1 = shufflevector <2 x i32> %i0, <2 x i32> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %i2 = shufflevector <4 x i32> %i1, <4 x i32> zeroinitializer, <4 x i32> <i32 0, i32 5, i32 1, i32 7>
  %i3 = load <4 x i32>, ptr %c
  %i4 = add <4 x i32> %i2, %i3
  store <4 x i32> %i4, ptr %c
  ret void
}

define void @zext_of_concat_extrause(ptr %a, ptr %b, ptr %c, ptr %d, ptr %e) nounwind {
; CHECK-LABEL: zext_of_concat_extrause:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ldr d0, [x1]
; CHECK-NEXT:    ldr d1, [x0]
; CHECK-NEXT:    add.2s v0, v1, v0
; CHECK-NEXT:    movi.2d v1, #0000000000000000
; CHECK-NEXT:    mov.d v0[1], v0[0]
; CHECK-NEXT:    zip1.4s v1, v0, v1
; CHECK-NEXT:    str q0, [x4]
; CHECK-NEXT:    ldr q0, [x2]
; CHECK-NEXT:    add.4s v0, v1, v0
; CHECK-NEXT:    str q0, [x2]
; CHECK-NEXT:    ret
;
; CHECK-BE-LABEL: zext_of_concat_extrause:
; CHECK-BE:       // %bb.0:
; CHECK-BE-NEXT:    ld1 { v0.2s }, [x1]
; CHECK-BE-NEXT:    ld1 { v1.2s }, [x0]
; CHECK-BE-NEXT:    movi v2.2d, #0000000000000000
; CHECK-BE-NEXT:    add v0.2s, v1.2s, v0.2s
; CHECK-BE-NEXT:    mov v0.d[1], v0.d[0]
; CHECK-BE-NEXT:    zip1 v1.4s, v0.4s, v0.4s
; CHECK-BE-NEXT:    st1 { v0.4s }, [x4]
; CHECK-BE-NEXT:    trn2 v0.4s, v1.4s, v2.4s
; CHECK-BE-NEXT:    ld1 { v1.4s }, [x2]
; CHECK-BE-NEXT:    add v0.4s, v0.4s, v1.4s
; CHECK-BE-NEXT:    st1 { v0.4s }, [x2]
; CHECK-BE-NEXT:    ret
  %i0.a = load <2 x i32>, ptr %a
  %i0.b = load <2 x i32>, ptr %b
  %i0 = add <2 x i32> %i0.a, %i0.b
  %i1 = shufflevector <2 x i32> %i0, <2 x i32> %i0, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  store <4 x i32> %i1, ptr %e
  %i2 = shufflevector <4 x i32> %i1, <4 x i32> zeroinitializer, <4 x i32> <i32 0, i32 5, i32 1, i32 7>
  %i3 = load <4 x i32>, ptr %c
  %i4 = add <4 x i32> %i2, %i3
  store <4 x i32> %i4, ptr %c
  ret void
}

define void @aext_of_concat(ptr %a, ptr %b, ptr %c, ptr %d) nounwind {
; CHECK-LABEL: aext_of_concat:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ldr d1, [x1]
; CHECK-NEXT:    add.2s v0, v0, v1
; CHECK-NEXT:    ldr q1, [x2]
; CHECK-NEXT:    ushll.2d v0, v0, #0
; CHECK-NEXT:    add.4s v0, v0, v1
; CHECK-NEXT:    str q0, [x2]
; CHECK-NEXT:    ret
;
; CHECK-BE-LABEL: aext_of_concat:
; CHECK-BE:       // %bb.0:
; CHECK-BE-NEXT:    ld1 { v0.2s }, [x0]
; CHECK-BE-NEXT:    ld1 { v1.2s }, [x1]
; CHECK-BE-NEXT:    add v0.2s, v0.2s, v1.2s
; CHECK-BE-NEXT:    ld1 { v1.4s }, [x2]
; CHECK-BE-NEXT:    zip1 v0.4s, v0.4s, v0.4s
; CHECK-BE-NEXT:    add v0.4s, v0.4s, v1.4s
; CHECK-BE-NEXT:    st1 { v0.4s }, [x2]
; CHECK-BE-NEXT:    ret
  %i0.a = load <2 x i32>, ptr %a
  %i0.b = load <2 x i32>, ptr %b
  %i0 = add <2 x i32> %i0.a, %i0.b
  %i1 = shufflevector <2 x i32> %i0, <2 x i32> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %i2 = shufflevector <4 x i32> %i1, <4 x i32> poison, <4 x i32> <i32 0, i32 undef, i32 1, i32 undef>
  %i3 = load <4 x i32>, ptr %c
  %i4 = add <4 x i32> %i2, %i3
  store <4 x i32> %i4, ptr %c
  ret void
}

define void @aext_of_concat_extrause(ptr %a, ptr %b, ptr %c, ptr %d, ptr %e) nounwind {
; CHECK-LABEL: aext_of_concat_extrause:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ldr d0, [x1]
; CHECK-NEXT:    ldr d1, [x0]
; CHECK-NEXT:    add.2s v0, v1, v0
; CHECK-NEXT:    mov.16b v1, v0
; CHECK-NEXT:    mov.d v1[1], v0[0]
; CHECK-NEXT:    zip1.4s v0, v0, v0
; CHECK-NEXT:    str q1, [x4]
; CHECK-NEXT:    ldr q1, [x2]
; CHECK-NEXT:    add.4s v0, v0, v1
; CHECK-NEXT:    str q0, [x2]
; CHECK-NEXT:    ret
;
; CHECK-BE-LABEL: aext_of_concat_extrause:
; CHECK-BE:       // %bb.0:
; CHECK-BE-NEXT:    ld1 { v0.2s }, [x1]
; CHECK-BE-NEXT:    ld1 { v1.2s }, [x0]
; CHECK-BE-NEXT:    add v0.2s, v1.2s, v0.2s
; CHECK-BE-NEXT:    mov v1.16b, v0.16b
; CHECK-BE-NEXT:    mov v1.d[1], v0.d[0]
; CHECK-BE-NEXT:    zip1 v0.4s, v0.4s, v0.4s
; CHECK-BE-NEXT:    st1 { v1.4s }, [x4]
; CHECK-BE-NEXT:    ld1 { v1.4s }, [x2]
; CHECK-BE-NEXT:    add v0.4s, v0.4s, v1.4s
; CHECK-BE-NEXT:    st1 { v0.4s }, [x2]
; CHECK-BE-NEXT:    ret
  %i0.a = load <2 x i32>, ptr %a
  %i0.b = load <2 x i32>, ptr %b
  %i0 = add <2 x i32> %i0.a, %i0.b
  %i1 = shufflevector <2 x i32> %i0, <2 x i32> %i0, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  store <4 x i32> %i1, ptr %e
  %i2 = shufflevector <4 x i32> %i1, <4 x i32> zeroinitializer, <4 x i32> <i32 0, i32 undef, i32 1, i32 undef>
  %i3 = load <4 x i32>, ptr %c
  %i4 = add <4 x i32> %i2, %i3
  store <4 x i32> %i4, ptr %c
  ret void
}
