; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+m -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV32I
; RUN: llc -mtriple=riscv32 -mattr=+m,+zba -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV32ZBA

define signext i16 @sh1add(i64 %0, ptr %1) {
; RV32I-LABEL: sh1add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 1
; RV32I-NEXT:    add a0, a2, a0
; RV32I-NEXT:    lh a0, 0(a0)
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: sh1add:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh1add a0, a0, a2
; RV32ZBA-NEXT:    lh a0, 0(a0)
; RV32ZBA-NEXT:    ret
  %3 = getelementptr inbounds i16, ptr %1, i64 %0
  %4 = load i16, ptr %3
  ret i16 %4
}

define i32 @sh2add(i64 %0, ptr %1) {
; RV32I-LABEL: sh2add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 2
; RV32I-NEXT:    add a0, a2, a0
; RV32I-NEXT:    lw a0, 0(a0)
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: sh2add:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh2add a0, a0, a2
; RV32ZBA-NEXT:    lw a0, 0(a0)
; RV32ZBA-NEXT:    ret
  %3 = getelementptr inbounds i32, ptr %1, i64 %0
  %4 = load i32, ptr %3
  ret i32 %4
}

define i64 @sh3add(i64 %0, ptr %1) {
; RV32I-LABEL: sh3add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 3
; RV32I-NEXT:    add a2, a2, a0
; RV32I-NEXT:    lw a0, 0(a2)
; RV32I-NEXT:    lw a1, 4(a2)
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: sh3add:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh3add a1, a0, a2
; RV32ZBA-NEXT:    lw a0, 0(a1)
; RV32ZBA-NEXT:    lw a1, 4(a1)
; RV32ZBA-NEXT:    ret
  %3 = getelementptr inbounds i64, ptr %1, i64 %0
  %4 = load i64, ptr %3
  ret i64 %4
}

define i32 @addmul6(i32 %a, i32 %b) {
; RV32I-LABEL: addmul6:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a0, a0, 3
; RV32I-NEXT:    sub a0, a0, a2
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: addmul6:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh1add a0, a0, a0
; RV32ZBA-NEXT:    sh1add a0, a0, a1
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 6
  %d = add i32 %c, %b
  ret i32 %d
}

define i32 @addmul10(i32 %a, i32 %b) {
; RV32I-LABEL: addmul10:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a2, 10
; RV32I-NEXT:    mul a0, a0, a2
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: addmul10:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh2add a0, a0, a0
; RV32ZBA-NEXT:    sh1add a0, a0, a1
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 10
  %d = add i32 %c, %b
  ret i32 %d
}

define i32 @addmul12(i32 %a, i32 %b) {
; RV32I-LABEL: addmul12:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    slli a0, a0, 4
; RV32I-NEXT:    sub a0, a0, a2
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: addmul12:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh1add a0, a0, a0
; RV32ZBA-NEXT:    sh2add a0, a0, a1
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 12
  %d = add i32 %c, %b
  ret i32 %d
}

define i32 @addmul18(i32 %a, i32 %b) {
; RV32I-LABEL: addmul18:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a2, 18
; RV32I-NEXT:    mul a0, a0, a2
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: addmul18:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh3add a0, a0, a0
; RV32ZBA-NEXT:    sh1add a0, a0, a1
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 18
  %d = add i32 %c, %b
  ret i32 %d
}

define i32 @addmul20(i32 %a, i32 %b) {
; RV32I-LABEL: addmul20:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a2, 20
; RV32I-NEXT:    mul a0, a0, a2
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: addmul20:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh2add a0, a0, a0
; RV32ZBA-NEXT:    sh2add a0, a0, a1
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 20
  %d = add i32 %c, %b
  ret i32 %d
}

define i32 @addmul24(i32 %a, i32 %b) {
; RV32I-LABEL: addmul24:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 3
; RV32I-NEXT:    slli a0, a0, 5
; RV32I-NEXT:    sub a0, a0, a2
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: addmul24:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh1add a0, a0, a0
; RV32ZBA-NEXT:    sh3add a0, a0, a1
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 24
  %d = add i32 %c, %b
  ret i32 %d
}

define i32 @addmul36(i32 %a, i32 %b) {
; RV32I-LABEL: addmul36:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a2, 36
; RV32I-NEXT:    mul a0, a0, a2
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: addmul36:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh3add a0, a0, a0
; RV32ZBA-NEXT:    sh2add a0, a0, a1
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 36
  %d = add i32 %c, %b
  ret i32 %d
}

define i32 @addmul40(i32 %a, i32 %b) {
; RV32I-LABEL: addmul40:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a2, 40
; RV32I-NEXT:    mul a0, a0, a2
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: addmul40:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh2add a0, a0, a0
; RV32ZBA-NEXT:    sh3add a0, a0, a1
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 40
  %d = add i32 %c, %b
  ret i32 %d
}

define i32 @addmul72(i32 %a, i32 %b) {
; RV32I-LABEL: addmul72:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a2, 72
; RV32I-NEXT:    mul a0, a0, a2
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: addmul72:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh3add a0, a0, a0
; RV32ZBA-NEXT:    sh3add a0, a0, a1
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 72
  %d = add i32 %c, %b
  ret i32 %d
}

define i32 @mul96(i32 %a) {
; RV32I-LABEL: mul96:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 5
; RV32I-NEXT:    slli a0, a0, 7
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul96:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh1add a0, a0, a0
; RV32ZBA-NEXT:    slli a0, a0, 5
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 96
  ret i32 %c
}

define i32 @mul160(i32 %a) {
; RV32I-LABEL: mul160:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 160
; RV32I-NEXT:    mul a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul160:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh2add a0, a0, a0
; RV32ZBA-NEXT:    slli a0, a0, 5
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 160
  ret i32 %c
}

define i32 @mul288(i32 %a) {
; RV32I-LABEL: mul288:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 288
; RV32I-NEXT:    mul a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul288:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh3add a0, a0, a0
; RV32ZBA-NEXT:    slli a0, a0, 5
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 288
  ret i32 %c
}

define i32 @mul258(i32 %a) {
; RV32I-LABEL: mul258:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 258
; RV32I-NEXT:    mul a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul258:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    slli a1, a0, 8
; RV32ZBA-NEXT:    sh1add a0, a0, a1
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 258
  ret i32 %c
}

define i32 @mul260(i32 %a) {
; RV32I-LABEL: mul260:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 260
; RV32I-NEXT:    mul a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul260:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    slli a1, a0, 8
; RV32ZBA-NEXT:    sh2add a0, a0, a1
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 260
  ret i32 %c
}

define i32 @mul264(i32 %a) {
; RV32I-LABEL: mul264:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 264
; RV32I-NEXT:    mul a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul264:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    slli a1, a0, 8
; RV32ZBA-NEXT:    sh3add a0, a0, a1
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 264
  ret i32 %c
}

define i32 @mul11(i32 %a) {
; RV32I-LABEL: mul11:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 11
; RV32I-NEXT:    mul a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul11:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh2add a1, a0, a0
; RV32ZBA-NEXT:    sh1add a0, a1, a0
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 11
  ret i32 %c
}

define i32 @mul19(i32 %a) {
; RV32I-LABEL: mul19:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 19
; RV32I-NEXT:    mul a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul19:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh3add a1, a0, a0
; RV32ZBA-NEXT:    sh1add a0, a1, a0
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 19
  ret i32 %c
}

define i32 @mul13(i32 %a) {
; RV32I-LABEL: mul13:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 13
; RV32I-NEXT:    mul a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul13:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh1add a1, a0, a0
; RV32ZBA-NEXT:    sh2add a0, a1, a0
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 13
  ret i32 %c
}

define i32 @mul21(i32 %a) {
; RV32I-LABEL: mul21:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 21
; RV32I-NEXT:    mul a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul21:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh2add a1, a0, a0
; RV32ZBA-NEXT:    sh2add a0, a1, a0
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 21
  ret i32 %c
}

define i32 @mul37(i32 %a) {
; RV32I-LABEL: mul37:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 37
; RV32I-NEXT:    mul a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul37:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh3add a1, a0, a0
; RV32ZBA-NEXT:    sh2add a0, a1, a0
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 37
  ret i32 %c
}

define i32 @mul25(i32 %a) {
; RV32I-LABEL: mul25:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 25
; RV32I-NEXT:    mul a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul25:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh2add a0, a0, a0
; RV32ZBA-NEXT:    sh2add a0, a0, a0
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 25
  ret i32 %c
}

define i32 @mul41(i32 %a) {
; RV32I-LABEL: mul41:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 41
; RV32I-NEXT:    mul a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul41:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh2add a1, a0, a0
; RV32ZBA-NEXT:    sh3add a0, a1, a0
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 41
  ret i32 %c
}

define i32 @mul73(i32 %a) {
; RV32I-LABEL: mul73:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 73
; RV32I-NEXT:    mul a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul73:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh3add a1, a0, a0
; RV32ZBA-NEXT:    sh3add a0, a1, a0
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 73
  ret i32 %c
}

define i32 @mul27(i32 %a) {
; RV32I-LABEL: mul27:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 27
; RV32I-NEXT:    mul a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul27:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh1add a0, a0, a0
; RV32ZBA-NEXT:    sh3add a0, a0, a0
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 27
  ret i32 %c
}

define i32 @mul45(i32 %a) {
; RV32I-LABEL: mul45:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 45
; RV32I-NEXT:    mul a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul45:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh2add a0, a0, a0
; RV32ZBA-NEXT:    sh3add a0, a0, a0
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 45
  ret i32 %c
}

define i32 @mul81(i32 %a) {
; RV32I-LABEL: mul81:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 81
; RV32I-NEXT:    mul a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul81:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh3add a0, a0, a0
; RV32ZBA-NEXT:    sh3add a0, a0, a0
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 81
  ret i32 %c
}

define i32 @mul4098(i32 %a) {
; RV32I-LABEL: mul4098:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    slli a0, a0, 12
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul4098:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    slli a1, a0, 12
; RV32ZBA-NEXT:    sh1add a0, a0, a1
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 4098
  ret i32 %c
}

define i32 @mul4100(i32 %a) {
; RV32I-LABEL: mul4100:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    slli a0, a0, 12
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul4100:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    slli a1, a0, 12
; RV32ZBA-NEXT:    sh2add a0, a0, a1
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 4100
  ret i32 %c
}

define i32 @mul4104(i32 %a) {
; RV32I-LABEL: mul4104:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 3
; RV32I-NEXT:    slli a0, a0, 12
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul4104:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    slli a1, a0, 12
; RV32ZBA-NEXT:    sh3add a0, a0, a1
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, 4104
  ret i32 %c
}

define i32 @add4104(i32 %a) {
; RV32I-LABEL: add4104:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 1
; RV32I-NEXT:    addi a1, a1, 8
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: add4104:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    li a1, 1026
; RV32ZBA-NEXT:    sh2add a0, a1, a0
; RV32ZBA-NEXT:    ret
  %c = add i32 %a, 4104
  ret i32 %c
}

define i32 @add8208(i32 %a) {
; RV32I-LABEL: add8208:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 2
; RV32I-NEXT:    addi a1, a1, 16
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: add8208:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    li a1, 1026
; RV32ZBA-NEXT:    sh3add a0, a1, a0
; RV32ZBA-NEXT:    ret
  %c = add i32 %a, 8208
  ret i32 %c
}

define i32 @add8192(i32 %a) {
; CHECK-LABEL: add8192:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a1, 2
; CHECK-NEXT:    add a0, a0, a1
; CHECK-NEXT:    ret
  %c = add i32 %a, 8192
  ret i32 %c
}

define i32 @addshl_5_6(i32 %a, i32 %b) {
; RV32I-LABEL: addshl_5_6:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 5
; RV32I-NEXT:    slli a1, a1, 6
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: addshl_5_6:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh1add a0, a1, a0
; RV32ZBA-NEXT:    slli a0, a0, 5
; RV32ZBA-NEXT:    ret
  %c = shl i32 %a, 5
  %d = shl i32 %b, 6
  %e = add i32 %c, %d
  ret i32 %e
}

define i32 @addshl_5_7(i32 %a, i32 %b) {
; RV32I-LABEL: addshl_5_7:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 5
; RV32I-NEXT:    slli a1, a1, 7
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: addshl_5_7:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh2add a0, a1, a0
; RV32ZBA-NEXT:    slli a0, a0, 5
; RV32ZBA-NEXT:    ret
  %c = shl i32 %a, 5
  %d = shl i32 %b, 7
  %e = add i32 %c, %d
  ret i32 %e
}

define i32 @addshl_5_8(i32 %a, i32 %b) {
; RV32I-LABEL: addshl_5_8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 5
; RV32I-NEXT:    slli a1, a1, 8
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: addshl_5_8:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh3add a0, a1, a0
; RV32ZBA-NEXT:    slli a0, a0, 5
; RV32ZBA-NEXT:    ret
  %c = shl i32 %a, 5
  %d = shl i32 %b, 8
  %e = add i32 %c, %d
  ret i32 %e
}

define i32 @srli_1_sh2add(ptr %0, i32 %1) {
; RV32I-LABEL: srli_1_sh2add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a1, 1
; RV32I-NEXT:    andi a1, a1, -4
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lw a0, 0(a0)
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: srli_1_sh2add:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    srli a1, a1, 1
; RV32ZBA-NEXT:    sh2add a0, a1, a0
; RV32ZBA-NEXT:    lw a0, 0(a0)
; RV32ZBA-NEXT:    ret
  %3 = lshr i32 %1, 1
  %4 = getelementptr inbounds i32, ptr %0, i32 %3
  %5 = load i32, ptr %4, align 4
  ret i32 %5
}

define i64 @srli_2_sh3add(ptr %0, i32 %1) {
; RV32I-LABEL: srli_2_sh3add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a1, 1
; RV32I-NEXT:    andi a1, a1, -8
; RV32I-NEXT:    add a1, a0, a1
; RV32I-NEXT:    lw a0, 0(a1)
; RV32I-NEXT:    lw a1, 4(a1)
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: srli_2_sh3add:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    srli a1, a1, 2
; RV32ZBA-NEXT:    sh3add a1, a1, a0
; RV32ZBA-NEXT:    lw a0, 0(a1)
; RV32ZBA-NEXT:    lw a1, 4(a1)
; RV32ZBA-NEXT:    ret
  %3 = lshr i32 %1, 2
  %4 = getelementptr inbounds i64, ptr %0, i32 %3
  %5 = load i64, ptr %4, align 8
  ret i64 %5
}

define signext i16 @srli_2_sh1add(ptr %0, i32 %1) {
; RV32I-LABEL: srli_2_sh1add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    andi a1, a1, -2
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lh a0, 0(a0)
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: srli_2_sh1add:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    srli a1, a1, 2
; RV32ZBA-NEXT:    sh1add a0, a1, a0
; RV32ZBA-NEXT:    lh a0, 0(a0)
; RV32ZBA-NEXT:    ret
  %3 = lshr i32 %1, 2
  %4 = getelementptr inbounds i16, ptr %0, i32 %3
  %5 = load i16, ptr %4, align 2
  ret i16 %5
}

define i32 @srli_3_sh2add(ptr %0, i32 %1) {
; RV32I-LABEL: srli_3_sh2add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    andi a1, a1, -4
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lw a0, 0(a0)
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: srli_3_sh2add:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    srli a1, a1, 3
; RV32ZBA-NEXT:    sh2add a0, a1, a0
; RV32ZBA-NEXT:    lw a0, 0(a0)
; RV32ZBA-NEXT:    ret
  %3 = lshr i32 %1, 3
  %4 = getelementptr inbounds i32, ptr %0, i32 %3
  %5 = load i32, ptr %4, align 4
  ret i32 %5
}

define i64 @srli_4_sh3add(ptr %0, i32 %1) {
; RV32I-LABEL: srli_4_sh3add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    andi a1, a1, -8
; RV32I-NEXT:    add a1, a0, a1
; RV32I-NEXT:    lw a0, 0(a1)
; RV32I-NEXT:    lw a1, 4(a1)
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: srli_4_sh3add:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    srli a1, a1, 4
; RV32ZBA-NEXT:    sh3add a1, a1, a0
; RV32ZBA-NEXT:    lw a0, 0(a1)
; RV32ZBA-NEXT:    lw a1, 4(a1)
; RV32ZBA-NEXT:    ret
  %3 = lshr i32 %1, 4
  %4 = getelementptr inbounds i64, ptr %0, i32 %3
  %5 = load i64, ptr %4, align 8
  ret i64 %5
}

define i32 @mul_neg1(i32 %a) {
; CHECK-LABEL: mul_neg1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    neg a0, a0
; CHECK-NEXT:    ret
  %c = mul i32 %a, -1
  ret i32 %c
}

define i32 @mul_neg2(i32 %a) {
; CHECK-LABEL: mul_neg2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    neg a0, a0
; CHECK-NEXT:    ret
  %c = mul i32 %a, -2
  ret i32 %c
}

define i32 @mul_neg3(i32 %a) {
; RV32I-LABEL: mul_neg3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    neg a0, a0
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul_neg3:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh1add a0, a0, a0
; RV32ZBA-NEXT:    neg a0, a0
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, -3
  ret i32 %c
}

define i32 @mul_neg4(i32 %a) {
; CHECK-LABEL: mul_neg4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    neg a0, a0
; CHECK-NEXT:    ret
  %c = mul i32 %a, -4
  ret i32 %c
}

define i32 @mul_neg5(i32 %a) {
; RV32I-LABEL: mul_neg5:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    neg a0, a0
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBA-LABEL: mul_neg5:
; RV32ZBA:       # %bb.0:
; RV32ZBA-NEXT:    sh2add a0, a0, a0
; RV32ZBA-NEXT:    neg a0, a0
; RV32ZBA-NEXT:    ret
  %c = mul i32 %a, -5
  ret i32 %c
}

define i32 @mul_neg6(i32 %a) {
; CHECK-LABEL: mul_neg6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, -6
; CHECK-NEXT:    mul a0, a0, a1
; CHECK-NEXT:    ret
  %c = mul i32 %a, -6
  ret i32 %c
}

define i32 @mul_neg7(i32 %a) {
; CHECK-LABEL: mul_neg7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a1, a0, 3
; CHECK-NEXT:    sub a0, a0, a1
; CHECK-NEXT:    ret
  %c = mul i32 %a, -7
  ret i32 %c
}

define i32 @mul_neg8(i32 %a) {
; CHECK-LABEL: mul_neg8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    neg a0, a0
; CHECK-NEXT:    ret
  %c = mul i32 %a, -8
  ret i32 %c
}
