function __fish_tmuxp_ls
    tmuxp ls 2>/dev/null
end

complete -c tmuxp -f
complete -c tmuxp -s h -l help -d Help
complete -c tmuxp -s V -l version -d Version
complete -c tmuxp -l log-level -x -a "debug info warning error critical" -d "Log level"
complete -c tmuxp -n __fish_use_subcommand -a load -d "Load tmuxp workspace"
complete -c tmuxp -n __fish_use_subcommand -a shell -d "Launch python shell"
complete -c tmuxp -n __fish_use_subcommand -a import -d "Import workspace"
complete -c tmuxp -n __fish_use_subcommand -a convert -d "Convert workspace"
complete -c tmuxp -n __fish_use_subcommand -a debug-info -d "Print diagnostics"
complete -c tmuxp -n __fish_use_subcommand -a ls -d "List workspaces"
complete -c tmuxp -n __fish_use_subcommand -a edit -d "Edit workspace"
complete -c tmuxp -n __fish_use_subcommand -a freeze -d "Freeze session to worskpace"
complete -c tmuxp -n "__fish_seen_subcommand_from load" -a "(__fish_tmuxp_ls)"
complete -c tmuxp -n "__fish_seen_subcommand_from load" -s L -r -F -d "Passthru to tmux -L"
complete -c tmuxp -n "__fish_seen_subcommand_from load" -s S -r -F -d "Passthru to tmux -S"
complete -c tmuxp -n "__fish_seen_subcommand_from load" -s f -r -F -d "Passthru to tmux -f"
complete -c tmuxp -n "__fish_seen_subcommand_from load" -s s -r -d "Session name"
complete -c tmuxp -n "__fish_seen_subcommand_from load" -s d -d "Detached session"
complete -c tmuxp -n "__fish_seen_subcommand_from load" -s a -r -d "Attach current windows to session"
complete -c tmuxp -n "__fish_seen_subcommand_from load" -s y -l yes -d "Always answer yes"
complete -c tmuxp -n "__fish_seen_subcommand_from load" -s 2 -d "Assume 256 color support"
complete -c tmuxp -n "__fish_seen_subcommand_from load" -s 8 -d "Assume 88 color support"
complete -c tmuxp -n "__fish_seen_subcommand_from load" -l log-file -r -F -d "Log file path"
complete -c tmuxp -n "__fish_seen_subcommand_from import" -a "teamocil tmuxinator"
complete -c tmuxp -n "__fish_seen_subcommand_from convert" -s y -l yes -d "Always answer yes"
complete -c tmuxp -n "__fish_seen_subcommand_from convert" -r -F
complete -c tmuxp -n "__fish_seen_subcommand_from edit" -a "(__fish_tmuxp_ls)"
complete -c tmuxp -n "__fish_seen_subcommand_from freeze" -s L -r -F -d "Passthru to tmux -L"
complete -c tmuxp -n "__fish_seen_subcommand_from freeze" -s S -r -F -d "Passthru to tmux -S"
complete -c tmuxp -n "__fish_seen_subcommand_from freeze" -s f -l worskpace-format -x -a "json yaml" -d "File format"
complete -c tmuxp -n "__fish_seen_subcommand_from freeze" -s o -l save-to -r -F -d "Output file"
complete -c tmuxp -n "__fish_seen_subcommand_from freeze" -s y -l yes -d "Always answer yes"
complete -c tmuxp -n "__fish_seen_subcommand_from freeze" -s q -l quiet -d "Do not prompt for confirmation"
complete -c tmuxp -n "__fish_seen_subcommand_from freeze" -l force -d "Overwrite existing file"
complete -c tmuxp -n "__fish_seen_subcommand_from shell" -s L -r -F -d "Passthru to tmux -L"
complete -c tmuxp -n "__fish_seen_subcommand_from shell" -s S -r -F -d "Passthru to tmux -S"
complete -c tmuxp -n "__fish_seen_subcommand_from shell" -s c -r -d "Run code and exit"
complete -c tmuxp -n "__fish_seen_subcommand_from shell" -l best -d "Use best shell available"
complete -c tmuxp -n "__fish_seen_subcommand_from shell" -l pdb -d "Use pdb"
complete -c tmuxp -n "__fish_seen_subcommand_from shell" -l code -d "Use code.interact()"
complete -c tmuxp -n "__fish_seen_subcommand_from shell" -l ptipython -d "Use ptpython+ipython"
complete -c tmuxp -n "__fish_seen_subcommand_from shell" -l ptpython -d "Use ptpython"
complete -c tmuxp -n "__fish_seen_subcommand_from shell" -l ipython -d "Use ipython"
complete -c tmuxp -n "__fish_seen_subcommand_from shell" -l bpython -d "Use bpython"
complete -c tmuxp -n "__fish_seen_subcommand_from shell" -l use-pythonrc -d "Load ~/.pythonrc.py"
complete -c tmuxp -n "__fish_seen_subcommand_from shell" -l no-startup -d "Do not load ~/.pythonrc.py"
complete -c tmuxp -n "__fish_seen_subcommand_from shell" -l use-vi-mode -d "Use vi input mode"
complete -c tmuxp -n "__fish_seen_subcommand_from shell" -l no-vi-mode -d "Do not use vi input mode"
