/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureBase;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;

public class MethodSignatureBackedByPsiMethod
extends MethodSignatureBase {
    private final PsiMethod myMethod;
    private final boolean myIsRaw;
    private final String myName;

    protected MethodSignatureBackedByPsiMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, boolean isRaw, PsiType @NotNull [] parameterTypes, PsiTypeParameter @NotNull [] methodTypeParameters) {
        if (method == null) {
            MethodSignatureBackedByPsiMethod.$$$reportNull$$$0(0);
        }
        if (substitutor2 == null) {
            MethodSignatureBackedByPsiMethod.$$$reportNull$$$0(1);
        }
        if (parameterTypes == null) {
            MethodSignatureBackedByPsiMethod.$$$reportNull$$$0(2);
        }
        if (methodTypeParameters == null) {
            MethodSignatureBackedByPsiMethod.$$$reportNull$$$0(3);
        }
        super(substitutor2, parameterTypes, methodTypeParameters);
        this.myIsRaw = isRaw;
        this.myMethod = method;
        this.myName = method.getName();
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            MethodSignatureBackedByPsiMethod.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Override
    public boolean isRaw() {
        return this.myIsRaw;
    }

    @Override
    public boolean isConstructor() {
        return this.myMethod.isConstructor();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MethodSignatureBackedByPsiMethod && ((MethodSignatureBackedByPsiMethod)o).myMethod == this.myMethod) {
            return true;
        }
        return super.equals(o);
    }

    @NotNull
    public PsiMethod getMethod() {
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            MethodSignatureBackedByPsiMethod.$$$reportNull$$$0(5);
        }
        return psiMethod;
    }

    @NotNull
    public static MethodSignatureBackedByPsiMethod create(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2) {
        if (method == null) {
            MethodSignatureBackedByPsiMethod.$$$reportNull$$$0(6);
        }
        if (substitutor2 == null) {
            MethodSignatureBackedByPsiMethod.$$$reportNull$$$0(7);
        }
        return MethodSignatureBackedByPsiMethod.create(method, substitutor2, PsiUtil.isRawSubstitutor(method, substitutor2));
    }

    @NotNull
    public static MethodSignatureBackedByPsiMethod create(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, boolean isRaw) {
        if (method == null) {
            MethodSignatureBackedByPsiMethod.$$$reportNull$$$0(8);
        }
        if (substitutor2 == null) {
            MethodSignatureBackedByPsiMethod.$$$reportNull$$$0(9);
        }
        PsiTypeParameter[] methodTypeParameters = method.getTypeParameters();
        if (isRaw) {
            substitutor2 = JavaPsiFacade.getElementFactory(method.getProject()).createRawSubstitutor(substitutor2, methodTypeParameters);
            methodTypeParameters = PsiTypeParameter.EMPTY_ARRAY;
        }
        try {
            substitutor2.ensureValid();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            throw PluginException.createByClass(e, method.getClass());
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        PsiType[] parameterTypes = PsiType.createArray(parameters2.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            PsiParameter parameter = parameters2[i];
            PsiType type2 = parameter.getType();
            parameterTypes[i] = isRaw ? TypeConversionUtil.erasure(substitutor2.substitute(type2)) : type2;
        }
        return new MethodSignatureBackedByPsiMethod(method, substitutor2, isRaw, parameterTypes, methodTypeParameters);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodTypeParameters";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/MethodSignatureBackedByPsiMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/MethodSignatureBackedByPsiMethod";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

