/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.composite.internal.IncludedBuildTaskResource;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.execution.plan.TaskNode;
import org.gradle.internal.Actions;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.util.Path;

public abstract class TaskInAnotherBuild
extends TaskNode {
    protected final IncludedBuildTaskGraph taskGraph;
    protected IncludedBuildTaskResource.State state = IncludedBuildTaskResource.State.WAITING;
    private final BuildIdentifier thisBuild;
    private final BuildIdentifier targetBuild;

    public static TaskInAnotherBuild of(TaskInternal task, BuildIdentifier currentBuildId, IncludedBuildTaskGraph taskGraph) {
        return new Resolved(task, TaskInAnotherBuild.buildIdentifierOf(task), currentBuildId, taskGraph);
    }

    public static TaskInAnotherBuild of(Path taskIdentityPath, String taskPath, BuildIdentifier targetBuild, BuildIdentifier thisBuild, IncludedBuildTaskGraph taskGraph) {
        return new Deferred(taskIdentityPath, taskPath, targetBuild, thisBuild, taskGraph);
    }

    protected TaskInAnotherBuild(BuildIdentifier thisBuild, BuildIdentifier targetBuild, IncludedBuildTaskGraph taskGraph) {
        this.thisBuild = thisBuild;
        this.targetBuild = targetBuild;
        this.doNotRequire();
        this.taskGraph = taskGraph;
    }

    public BuildIdentifier getThisBuild() {
        return this.thisBuild;
    }

    public BuildIdentifier getTargetBuild() {
        return this.targetBuild;
    }

    public abstract String getTaskPath();

    public abstract Path getTaskIdentityPath();

    @Override
    public void prepareForExecution() {
        this.taskGraph.addTask(this.thisBuild, this.targetBuild, this.getTaskPath());
    }

    @Override
    @Nullable
    public ResourceLock getProjectToLock() {
        return null;
    }

    @Override
    @Nullable
    public ProjectInternal getOwningProject() {
        return null;
    }

    public List<ResourceLock> getResourcesToLock() {
        return Collections.emptyList();
    }

    @Override
    public Throwable getNodeFailure() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rethrowNodeFailure() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendPostAction(Action<? super Task> action) {
    }

    @Override
    public Action<? super Task> getPostAction() {
        return Actions.doNothing();
    }

    @Override
    public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<Node> processHardSuccessor) {
    }

    @Override
    public boolean requiresMonitoring() {
        return true;
    }

    @Override
    public boolean isSuccessful() {
        return this.state == IncludedBuildTaskResource.State.SUCCESS;
    }

    @Override
    public boolean isFailed() {
        return this.state == IncludedBuildTaskResource.State.FAILED;
    }

    @Override
    public boolean isComplete() {
        if (this.state != IncludedBuildTaskResource.State.WAITING) {
            return true;
        }
        this.state = this.taskGraph.getTaskState(this.targetBuild, this.getTaskPath());
        return this.state != IncludedBuildTaskResource.State.WAITING;
    }

    @Override
    public int compareTo(Node other) {
        if (this.getClass() != other.getClass()) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        TaskInAnotherBuild taskNode = (TaskInAnotherBuild)other;
        return this.getTaskIdentityPath().compareTo(taskNode.getTaskIdentityPath());
    }

    @Override
    public String toString() {
        return this.getTaskIdentityPath().toString();
    }

    @Override
    public void resolveMutations() {
    }

    private static BuildIdentifier buildIdentifierOf(TaskInternal task) {
        return ((BuildState)((ProjectInternal)task.getProject()).getServices().get(BuildState.class)).getBuildIdentifier();
    }

    private static class Deferred
    extends TaskInAnotherBuild {
        private final Path taskIdentityPath;
        private final String taskPath;
        private TaskInternal task;

        public Deferred(Path taskIdentityPath, String taskPath, BuildIdentifier targetBuild, BuildIdentifier thisBuild, IncludedBuildTaskGraph taskGraph) {
            super(thisBuild, targetBuild, taskGraph);
            this.taskIdentityPath = taskIdentityPath;
            this.taskPath = taskPath;
        }

        @Override
        public Path getTaskIdentityPath() {
            return this.taskIdentityPath;
        }

        @Override
        public String getTaskPath() {
            return this.taskPath;
        }

        @Override
        public TaskInternal getTask() {
            if (this.task == null) {
                this.task = this.taskGraph.getTask(this.getTargetBuild(), this.getTaskPath());
            }
            return this.task;
        }
    }

    private static class Resolved
    extends TaskInAnotherBuild {
        private final TaskInternal task;

        Resolved(TaskInternal task, BuildIdentifier targetBuild, BuildIdentifier thisBuild, IncludedBuildTaskGraph taskGraph) {
            super(thisBuild, targetBuild, taskGraph);
            this.task = task;
        }

        @Override
        public TaskInternal getTask() {
            return this.task;
        }

        @Override
        public Path getTaskIdentityPath() {
            return this.getTask().getIdentityPath();
        }

        @Override
        public String getTaskPath() {
            return this.task.getPath();
        }

        @Override
        public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<Node> processHardSuccessor) {
            Set<Node> dependencies = dependencyResolver.resolveDependenciesFor(this.task, this.task.getTaskDependencies());
            for (Node targetNode : dependencies) {
                if (!(targetNode instanceof TaskNode)) continue;
                this.addDependencySuccessor(targetNode);
                processHardSuccessor.execute((Object)targetNode);
            }
        }
    }
}

