/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileType;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.AbstractRecompilationSpecProvider;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CurrentCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileClassNameConverter;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.FileUtils;
import org.gradle.internal.file.Deleter;
import org.gradle.work.FileChange;

public class GroovyRecompilationSpecProvider
extends AbstractRecompilationSpecProvider {
    private final boolean incremental;
    private final Iterable<FileChange> sourceChanges;

    public GroovyRecompilationSpecProvider(Deleter deleter, FileOperations fileOperations, FileTree sources, boolean incremental, Iterable<FileChange> sourceChanges) {
        super(deleter, fileOperations, sources);
        this.incremental = incremental;
        this.sourceChanges = sourceChanges;
    }

    protected String getFileExtension() {
        return ".groovy";
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public RecompilationSpec provideRecompilationSpec(CurrentCompilation current, PreviousCompilation previous) {
        RecompilationSpec spec = new RecompilationSpec(previous);
        SourceFileClassNameConverter sourceFileClassNameConverter = this.getSourceFileClassNameConverter(previous);
        this.processClasspathChanges(current, previous, spec);
        this.processOtherChanges(previous, spec, sourceFileClassNameConverter);
        spec.addClassesToProcess((Collection)previous.getTypesToReprocess());
        return spec;
    }

    public boolean initializeCompilation(JavaCompileSpec spec, RecompilationSpec recompilationSpec) {
        if (!recompilationSpec.isBuildNeeded()) {
            spec.setSourceFiles(Collections.emptySet());
            spec.setClasses(Collections.emptySet());
            return false;
        }
        SourceFileClassNameConverter sourceFileClassNameConverter = this.getSourceFileClassNameConverter(recompilationSpec.getPreviousCompilation());
        PatternSet classesToDelete = this.fileOperations.patternSet();
        PatternSet filesToRecompile = this.fileOperations.patternSet();
        this.prepareFilePatterns(recompilationSpec.getRelativeSourcePathsToCompile(), classesToDelete, filesToRecompile, sourceFileClassNameConverter);
        spec.setSourceFiles((Iterable)this.sourceTree.matching((PatternFilterable)filesToRecompile));
        this.includePreviousCompilationOutputOnClasspath(spec);
        this.addClassesToProcess(spec, recompilationSpec);
        return this.deleteStaleFilesIn(classesToDelete, spec.getDestinationDir());
    }

    private void prepareFilePatterns(Set<String> relativeSourcePathsToCompile, PatternSet classesToDelete, PatternSet filesToRecompilePatterns, SourceFileClassNameConverter sourceFileClassNameConverter) {
        for (String relativeSourcePath : relativeSourcePathsToCompile) {
            filesToRecompilePatterns.include(new String[]{relativeSourcePath});
            sourceFileClassNameConverter.getClassNames(relativeSourcePath).stream().map(staleClass -> staleClass.replaceAll("\\.", "/").concat(".class")).forEach(xva$0 -> classesToDelete.include(new String[]{xva$0}));
        }
    }

    private void processOtherChanges(PreviousCompilation previous, RecompilationSpec spec, SourceFileClassNameConverter sourceFileClassNameConverter) {
        if (spec.isFullRebuildNeeded()) {
            return;
        }
        SourceFileChangeProcessor sourceFileChangeProcessor = new SourceFileChangeProcessor(previous);
        for (FileChange fileChange : this.sourceChanges) {
            if (spec.isFullRebuildNeeded()) {
                return;
            }
            if (fileChange.getFileType() != FileType.FILE) continue;
            File changedFile = fileChange.getFile();
            if (!FileUtils.hasExtension((File)changedFile, (String)".groovy")) {
                spec.setFullRebuildCause(this.rebuildClauseForChangedNonSourceFile("non-Groovy file", fileChange));
                return;
            }
            String relativeFilePath = fileChange.getNormalizedPath();
            Collection changedClasses = sourceFileClassNameConverter.getClassNames(relativeFilePath);
            spec.addRelativeSourcePathToCompile(relativeFilePath);
            sourceFileChangeProcessor.processChange(changedFile, changedClasses, spec);
        }
        for (String className : spec.getClassesToCompile()) {
            if (spec.isFullRebuildNeeded()) {
                return;
            }
            Collection relativeSourceFiles = sourceFileClassNameConverter.getRelativeSourcePaths(className);
            if (relativeSourceFiles.isEmpty()) {
                spec.setFullRebuildCause("unable to find source file of class " + className);
                continue;
            }
            spec.addRelativeSourcePathsToCompile(relativeSourceFiles);
        }
    }
}

