#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawsetviewport_ PETSCDRAWSETVIEWPORT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawsetviewport_ petscdrawsetviewport
#endif
PETSC_EXTERN void petscdrawsetviewport_(PetscDraw *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscErrorCode *ierr)
{
  *ierr = PetscDrawSetViewPort(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawgetviewport_ PETSCDRAWGETVIEWPORT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawgetviewport_ petscdrawgetviewport
#endif
PETSC_EXTERN void petscdrawgetviewport_(PetscDraw *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  *ierr = PetscDrawGetViewPort(*a, b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawviewportsdestroy_ PETSCDRAWVIEWPORTSDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawviewportsdestroy_ petscdrawviewportsdestroy
#endif
PETSC_EXTERN void petscdrawviewportsdestroy_(PetscDrawViewPorts *a, PetscErrorCode *ierr)
{
  *ierr = PetscDrawViewPortsDestroy(a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawviewportsset_ PETSCDRAWVIEWPORTSSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawviewportsset_ petscdrawviewportsset
#endif
PETSC_EXTERN void petscdrawviewportsset_(PetscDrawViewPorts *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscDrawViewPortsSet(a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawsplitviewport_ PETSCDRAWSPLITVIEWPORT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawsplitviewport_ petscdrawsplitviewport
#endif
PETSC_EXTERN void petscdrawsplitviewport_(PetscDraw *a, PetscErrorCode *ierr)
{
  *ierr = PetscDrawSplitViewPort(*a);
  if (*ierr) return;
}
