  type, extends(tPetscObject) ::  tPC
  end type tPC
  PC, parameter :: PETSC_NULL_PC = tPC(0)
  PC, target :: PETSC_NULL_PC_ARRAY(1) = [tPC(0)]
  PC, pointer :: PETSC_NULL_PC_POINTER(:) => PETSC_NULL_PC_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PC
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PC_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PC_POINTER
#endif

  type ePCSide
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCSide

  PCSide, parameter :: PETSC_NULL_PCSIDE = ePCSide(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCSIDE
#endif
    PCSide, parameter :: PC_SIDE_DEFAULT = ePCSide(-1)
    PCSide, parameter :: PC_LEFT = ePCSide(0)
    PCSide, parameter :: PC_RIGHT = ePCSide(1)
    PCSide, parameter :: PC_SYMMETRIC = ePCSide(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PC_SIDE_DEFAULT 
!DEC$ ATTRIBUTES DLLEXPORT::PC_LEFT 
!DEC$ ATTRIBUTES DLLEXPORT::PC_RIGHT 
!DEC$ ATTRIBUTES DLLEXPORT::PC_SYMMETRIC 
#endif

  type ePCRichardsonConvergedReason
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCRichardsonConvergedReason

  PCRichardsonConvergedReason, parameter :: PETSC_NULL_PCRICHARDSONCONVERGEDREASON = ePCRichardsonConvergedReason(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCRICHARDSONCONVERGEDREASON
#endif
    PCRichardsonConvergedReason, parameter :: PCRICHARDSON_NOT_SET = ePCRichardsonConvergedReason(0)
    PCRichardsonConvergedReason, parameter :: PCRICHARDSON_CONVERGED_RTOL = ePCRichardsonConvergedReason(2)
    PCRichardsonConvergedReason, parameter :: PCRICHARDSON_CONVERGED_ATOL = ePCRichardsonConvergedReason(3)
    PCRichardsonConvergedReason, parameter :: PCRICHARDSON_CONVERGED_ITS = ePCRichardsonConvergedReason(4)
    PCRichardsonConvergedReason, parameter :: PCRICHARDSON_DIVERGED_DTOL = ePCRichardsonConvergedReason(-4)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PCRICHARDSON_NOT_SET 
!DEC$ ATTRIBUTES DLLEXPORT::PCRICHARDSON_CONVERGED_RTOL 
!DEC$ ATTRIBUTES DLLEXPORT::PCRICHARDSON_CONVERGED_ATOL 
!DEC$ ATTRIBUTES DLLEXPORT::PCRICHARDSON_CONVERGED_ITS 
!DEC$ ATTRIBUTES DLLEXPORT::PCRICHARDSON_DIVERGED_DTOL 
#endif

  type ePCJacobiType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCJacobiType

  PCJacobiType, parameter :: PETSC_NULL_PCJACOBITYPE = ePCJacobiType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCJACOBITYPE
#endif
    PCJacobiType, parameter :: PC_JACOBI_DIAGONAL = ePCJacobiType(0)
    PCJacobiType, parameter :: PC_JACOBI_ROWL1 = ePCJacobiType(1)
    PCJacobiType, parameter :: PC_JACOBI_ROWMAX = ePCJacobiType(2)
    PCJacobiType, parameter :: PC_JACOBI_ROWSUM = ePCJacobiType(3)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PC_JACOBI_DIAGONAL
!DEC$ ATTRIBUTES DLLEXPORT::PC_JACOBI_ROWL1
!DEC$ ATTRIBUTES DLLEXPORT::PC_JACOBI_ROWMAX
!DEC$ ATTRIBUTES DLLEXPORT::PC_JACOBI_ROWSUM
#endif

  type ePCASMType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCASMType

  PCASMType, parameter :: PETSC_NULL_PCASMTYPE = ePCASMType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCASMTYPE
#endif
    PCASMType, parameter :: PC_ASM_BASIC = ePCASMType(3)
    PCASMType, parameter :: PC_ASM_RESTRICT = ePCASMType(1)
    PCASMType, parameter :: PC_ASM_INTERPOLATE = ePCASMType(2)
    PCASMType, parameter :: PC_ASM_NONE = ePCASMType(0)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PC_ASM_BASIC 
!DEC$ ATTRIBUTES DLLEXPORT::PC_ASM_RESTRICT 
!DEC$ ATTRIBUTES DLLEXPORT::PC_ASM_INTERPOLATE 
!DEC$ ATTRIBUTES DLLEXPORT::PC_ASM_NONE 
#endif

  type ePCGASMType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCGASMType

  PCGASMType, parameter :: PETSC_NULL_PCGASMTYPE = ePCGASMType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCGASMTYPE
#endif
    PCGASMType, parameter :: PC_GASM_BASIC = ePCGASMType(3)
    PCGASMType, parameter :: PC_GASM_RESTRICT = ePCGASMType(1)
    PCGASMType, parameter :: PC_GASM_INTERPOLATE = ePCGASMType(2)
    PCGASMType, parameter :: PC_GASM_NONE = ePCGASMType(0)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PC_GASM_BASIC 
!DEC$ ATTRIBUTES DLLEXPORT::PC_GASM_RESTRICT 
!DEC$ ATTRIBUTES DLLEXPORT::PC_GASM_INTERPOLATE 
!DEC$ ATTRIBUTES DLLEXPORT::PC_GASM_NONE 
#endif

  type ePCCompositeType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCCompositeType

  PCCompositeType, parameter :: PETSC_NULL_PCCOMPOSITETYPE = ePCCompositeType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCCOMPOSITETYPE
#endif
    PCCompositeType, parameter :: PC_COMPOSITE_ADDITIVE = ePCCompositeType(0)
    PCCompositeType, parameter :: PC_COMPOSITE_MULTIPLICATIVE = ePCCompositeType(1)
    PCCompositeType, parameter :: PC_COMPOSITE_SYMMETRIC_MULTIPLICATIVE = ePCCompositeType(2)
    PCCompositeType, parameter :: PC_COMPOSITE_SPECIAL = ePCCompositeType(3)
    PCCompositeType, parameter :: PC_COMPOSITE_SCHUR = ePCCompositeType(4)
    PCCompositeType, parameter :: PC_COMPOSITE_GKB = ePCCompositeType(5)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PC_COMPOSITE_ADDITIVE
!DEC$ ATTRIBUTES DLLEXPORT::PC_COMPOSITE_MULTIPLICATIVE
!DEC$ ATTRIBUTES DLLEXPORT::PC_COMPOSITE_SYMMETRIC_MULTIPLICATIVE
!DEC$ ATTRIBUTES DLLEXPORT::PC_COMPOSITE_SPECIAL
!DEC$ ATTRIBUTES DLLEXPORT::PC_COMPOSITE_SCHUR
!DEC$ ATTRIBUTES DLLEXPORT::PC_COMPOSITE_GKB
#endif

  type ePCFieldSplitSchurPreType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCFieldSplitSchurPreType

  PCFieldSplitSchurPreType, parameter :: PETSC_NULL_PCFIELDSPLITSCHURPRETYPE = ePCFieldSplitSchurPreType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCFIELDSPLITSCHURPRETYPE
#endif
    PCFieldSplitSchurPreType, parameter :: PC_FIELDSPLIT_SCHUR_PRE_SELF = ePCFieldSplitSchurPreType(0)
    PCFieldSplitSchurPreType, parameter :: PC_FIELDSPLIT_SCHUR_PRE_SELFP = ePCFieldSplitSchurPreType(1)
    PCFieldSplitSchurPreType, parameter :: PC_FIELDSPLIT_SCHUR_PRE_A11 = ePCFieldSplitSchurPreType(2)
    PCFieldSplitSchurPreType, parameter :: PC_FIELDSPLIT_SCHUR_PRE_USER = ePCFieldSplitSchurPreType(3)
    PCFieldSplitSchurPreType, parameter :: PC_FIELDSPLIT_SCHUR_PRE_FULL = ePCFieldSplitSchurPreType(4)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PC_FIELDSPLIT_SCHUR_PRE_SELF
!DEC$ ATTRIBUTES DLLEXPORT::PC_FIELDSPLIT_SCHUR_PRE_SELFP
!DEC$ ATTRIBUTES DLLEXPORT::PC_FIELDSPLIT_SCHUR_PRE_A11
!DEC$ ATTRIBUTES DLLEXPORT::PC_FIELDSPLIT_SCHUR_PRE_USER
!DEC$ ATTRIBUTES DLLEXPORT::PC_FIELDSPLIT_SCHUR_PRE_FULL
#endif

  type ePCFieldSplitSchurFactType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCFieldSplitSchurFactType

  PCFieldSplitSchurFactType, parameter :: PETSC_NULL_PCFIELDSPLITSCHURFACTTYPE = ePCFieldSplitSchurFactType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCFIELDSPLITSCHURFACTTYPE
#endif
    PCFieldSplitSchurFactType, parameter :: PC_FIELDSPLIT_SCHUR_FACT_DIAG = ePCFieldSplitSchurFactType(0)
    PCFieldSplitSchurFactType, parameter :: PC_FIELDSPLIT_SCHUR_FACT_LOWER = ePCFieldSplitSchurFactType(1)
    PCFieldSplitSchurFactType, parameter :: PC_FIELDSPLIT_SCHUR_FACT_UPPER = ePCFieldSplitSchurFactType(2)
    PCFieldSplitSchurFactType, parameter :: PC_FIELDSPLIT_SCHUR_FACT_FULL = ePCFieldSplitSchurFactType(3)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PC_FIELDSPLIT_SCHUR_FACT_DIAG
!DEC$ ATTRIBUTES DLLEXPORT::PC_FIELDSPLIT_SCHUR_FACT_LOWER
!DEC$ ATTRIBUTES DLLEXPORT::PC_FIELDSPLIT_SCHUR_FACT_UPPER
!DEC$ ATTRIBUTES DLLEXPORT::PC_FIELDSPLIT_SCHUR_FACT_FULL
#endif

  type ePCPARMSGlobalType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCPARMSGlobalType

  PCPARMSGlobalType, parameter :: PETSC_NULL_PCPARMSGLOBALTYPE = ePCPARMSGlobalType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCPARMSGLOBALTYPE
#endif
    PCPARMSGlobalType, parameter :: PC_PARMS_GLOBAL_RAS = ePCPARMSGlobalType(0)
    PCPARMSGlobalType, parameter :: PC_PARMS_GLOBAL_SCHUR = ePCPARMSGlobalType(1)
    PCPARMSGlobalType, parameter :: PC_PARMS_GLOBAL_BJ = ePCPARMSGlobalType(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PC_PARMS_GLOBAL_RAS
!DEC$ ATTRIBUTES DLLEXPORT::PC_PARMS_GLOBAL_SCHUR
!DEC$ ATTRIBUTES DLLEXPORT::PC_PARMS_GLOBAL_BJ
#endif

  type ePCPARMSLocalType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCPARMSLocalType

  PCPARMSLocalType, parameter :: PETSC_NULL_PCPARMSLOCALTYPE = ePCPARMSLocalType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCPARMSLOCALTYPE
#endif
    PCPARMSLocalType, parameter :: PC_PARMS_LOCAL_ILU0 = ePCPARMSLocalType(0)
    PCPARMSLocalType, parameter :: PC_PARMS_LOCAL_ILUK = ePCPARMSLocalType(1)
    PCPARMSLocalType, parameter :: PC_PARMS_LOCAL_ILUT = ePCPARMSLocalType(2)
    PCPARMSLocalType, parameter :: PC_PARMS_LOCAL_ARMS = ePCPARMSLocalType(3)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PC_PARMS_LOCAL_ILU0
!DEC$ ATTRIBUTES DLLEXPORT::PC_PARMS_LOCAL_ILUK
!DEC$ ATTRIBUTES DLLEXPORT::PC_PARMS_LOCAL_ILUT
!DEC$ ATTRIBUTES DLLEXPORT::PC_PARMS_LOCAL_ARMS
#endif

  type ePCMGType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCMGType

  PCMGType, parameter :: PETSC_NULL_PCMGTYPE = ePCMGType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCMGTYPE
#endif
    PCMGType, parameter :: PC_MG_MULTIPLICATIVE = ePCMGType(0)
    PCMGType, parameter :: PC_MG_ADDITIVE = ePCMGType(1)
    PCMGType, parameter :: PC_MG_FULL = ePCMGType(2)
    PCMGType, parameter :: PC_MG_KASKADE = ePCMGType(3)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PC_MG_MULTIPLICATIVE
!DEC$ ATTRIBUTES DLLEXPORT::PC_MG_ADDITIVE
!DEC$ ATTRIBUTES DLLEXPORT::PC_MG_FULL
!DEC$ ATTRIBUTES DLLEXPORT::PC_MG_KASKADE
#endif

  type ePCMGCycleType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCMGCycleType

  PCMGCycleType, parameter :: PETSC_NULL_PCMGCYCLETYPE = ePCMGCycleType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCMGCYCLETYPE
#endif
    PCMGCycleType, parameter :: PC_MG_CYCLE_V = ePCMGCycleType(1)
    PCMGCycleType, parameter :: PC_MG_CYCLE_W = ePCMGCycleType(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PC_MG_CYCLE_V 
!DEC$ ATTRIBUTES DLLEXPORT::PC_MG_CYCLE_W 
#endif

  type ePCMGGalerkinType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCMGGalerkinType

  PCMGGalerkinType, parameter :: PETSC_NULL_PCMGGALERKINTYPE = ePCMGGalerkinType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCMGGALERKINTYPE
#endif
    PCMGGalerkinType, parameter :: PC_MG_GALERKIN_BOTH = ePCMGGalerkinType(0)
    PCMGGalerkinType, parameter :: PC_MG_GALERKIN_PMAT = ePCMGGalerkinType(1)
    PCMGGalerkinType, parameter :: PC_MG_GALERKIN_MAT = ePCMGGalerkinType(2)
    PCMGGalerkinType, parameter :: PC_MG_GALERKIN_NONE = ePCMGGalerkinType(3)
    PCMGGalerkinType, parameter :: PC_MG_GALERKIN_EXTERNAL = ePCMGGalerkinType(4)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PC_MG_GALERKIN_BOTH
!DEC$ ATTRIBUTES DLLEXPORT::PC_MG_GALERKIN_PMAT
!DEC$ ATTRIBUTES DLLEXPORT::PC_MG_GALERKIN_MAT
!DEC$ ATTRIBUTES DLLEXPORT::PC_MG_GALERKIN_NONE
!DEC$ ATTRIBUTES DLLEXPORT::PC_MG_GALERKIN_EXTERNAL
#endif

  type ePCExoticType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCExoticType

  PCExoticType, parameter :: PETSC_NULL_PCEXOTICTYPE = ePCExoticType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCEXOTICTYPE
#endif
    PCExoticType, parameter :: PC_EXOTIC_FACE = ePCExoticType(0)
    PCExoticType, parameter :: PC_EXOTIC_WIREBASKET = ePCExoticType(1)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PC_EXOTIC_FACE
!DEC$ ATTRIBUTES DLLEXPORT::PC_EXOTIC_WIREBASKET
#endif

  type ePCBDDCInterfaceExtType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCBDDCInterfaceExtType

  PCBDDCInterfaceExtType, parameter :: PETSC_NULL_PCBDDCINTERFACEEXTTYPE = ePCBDDCInterfaceExtType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCBDDCINTERFACEEXTTYPE
#endif
    PCBDDCInterfaceExtType, parameter :: PC_BDDC_INTERFACE_EXT_DIRICHLET = ePCBDDCInterfaceExtType(0)
    PCBDDCInterfaceExtType, parameter :: PC_BDDC_INTERFACE_EXT_LUMP = ePCBDDCInterfaceExtType(1)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PC_BDDC_INTERFACE_EXT_DIRICHLET
!DEC$ ATTRIBUTES DLLEXPORT::PC_BDDC_INTERFACE_EXT_LUMP
#endif

  type ePCMGCoarseSpaceType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCMGCoarseSpaceType

  PCMGCoarseSpaceType, parameter :: PETSC_NULL_PCMGCOARSESPACETYPE = ePCMGCoarseSpaceType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCMGCOARSESPACETYPE
#endif
    PCMGCoarseSpaceType, parameter :: PCMG_ADAPT_NONE = ePCMGCoarseSpaceType(0)
    PCMGCoarseSpaceType, parameter :: PCMG_ADAPT_POLYNOMIAL = ePCMGCoarseSpaceType(1)
    PCMGCoarseSpaceType, parameter :: PCMG_ADAPT_HARMONIC = ePCMGCoarseSpaceType(2)
    PCMGCoarseSpaceType, parameter :: PCMG_ADAPT_EIGENVECTOR = ePCMGCoarseSpaceType(3)
    PCMGCoarseSpaceType, parameter :: PCMG_ADAPT_GENERALIZED_EIGENVECTOR = ePCMGCoarseSpaceType(4)
    PCMGCoarseSpaceType, parameter :: PCMG_ADAPT_GDSW = ePCMGCoarseSpaceType(5)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PCMG_ADAPT_NONE
!DEC$ ATTRIBUTES DLLEXPORT::PCMG_ADAPT_POLYNOMIAL
!DEC$ ATTRIBUTES DLLEXPORT::PCMG_ADAPT_HARMONIC
!DEC$ ATTRIBUTES DLLEXPORT::PCMG_ADAPT_EIGENVECTOR
!DEC$ ATTRIBUTES DLLEXPORT::PCMG_ADAPT_GENERALIZED_EIGENVECTOR
!DEC$ ATTRIBUTES DLLEXPORT::PCMG_ADAPT_GDSW
#endif

  type ePCPatchConstructType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCPatchConstructType

  PCPatchConstructType, parameter :: PETSC_NULL_PCPATCHCONSTRUCTTYPE = ePCPatchConstructType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCPATCHCONSTRUCTTYPE
#endif
    PCPatchConstructType, parameter :: PC_PATCH_STAR = ePCPatchConstructType(0)
    PCPatchConstructType, parameter :: PC_PATCH_VANKA = ePCPatchConstructType(1)
    PCPatchConstructType, parameter :: PC_PATCH_PARDECOMP = ePCPatchConstructType(2)
    PCPatchConstructType, parameter :: PC_PATCH_USER = ePCPatchConstructType(3)
    PCPatchConstructType, parameter :: PC_PATCH_PYTHON = ePCPatchConstructType(4)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PC_PATCH_STAR
!DEC$ ATTRIBUTES DLLEXPORT::PC_PATCH_VANKA
!DEC$ ATTRIBUTES DLLEXPORT::PC_PATCH_PARDECOMP
!DEC$ ATTRIBUTES DLLEXPORT::PC_PATCH_USER
!DEC$ ATTRIBUTES DLLEXPORT::PC_PATCH_PYTHON
#endif

  type ePCDeflationSpaceType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCDeflationSpaceType

  PCDeflationSpaceType, parameter :: PETSC_NULL_PCDEFLATIONSPACETYPE = ePCDeflationSpaceType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCDEFLATIONSPACETYPE
#endif
    PCDeflationSpaceType, parameter :: PC_DEFLATION_SPACE_HAAR = ePCDeflationSpaceType(0)
    PCDeflationSpaceType, parameter :: PC_DEFLATION_SPACE_DB2 = ePCDeflationSpaceType(1)
    PCDeflationSpaceType, parameter :: PC_DEFLATION_SPACE_DB4 = ePCDeflationSpaceType(2)
    PCDeflationSpaceType, parameter :: PC_DEFLATION_SPACE_DB8 = ePCDeflationSpaceType(3)
    PCDeflationSpaceType, parameter :: PC_DEFLATION_SPACE_DB16 = ePCDeflationSpaceType(4)
    PCDeflationSpaceType, parameter :: PC_DEFLATION_SPACE_BIORTH22 = ePCDeflationSpaceType(5)
    PCDeflationSpaceType, parameter :: PC_DEFLATION_SPACE_MEYER = ePCDeflationSpaceType(6)
    PCDeflationSpaceType, parameter :: PC_DEFLATION_SPACE_AGGREGATION = ePCDeflationSpaceType(7)
    PCDeflationSpaceType, parameter :: PC_DEFLATION_SPACE_USER = ePCDeflationSpaceType(8)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PC_DEFLATION_SPACE_HAAR
!DEC$ ATTRIBUTES DLLEXPORT::PC_DEFLATION_SPACE_DB2
!DEC$ ATTRIBUTES DLLEXPORT::PC_DEFLATION_SPACE_DB4
!DEC$ ATTRIBUTES DLLEXPORT::PC_DEFLATION_SPACE_DB8
!DEC$ ATTRIBUTES DLLEXPORT::PC_DEFLATION_SPACE_DB16
!DEC$ ATTRIBUTES DLLEXPORT::PC_DEFLATION_SPACE_BIORTH22
!DEC$ ATTRIBUTES DLLEXPORT::PC_DEFLATION_SPACE_MEYER
!DEC$ ATTRIBUTES DLLEXPORT::PC_DEFLATION_SPACE_AGGREGATION
!DEC$ ATTRIBUTES DLLEXPORT::PC_DEFLATION_SPACE_USER
#endif

  type ePCHPDDMCoarseCorrectionType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCHPDDMCoarseCorrectionType

  PCHPDDMCoarseCorrectionType, parameter :: PETSC_NULL_PCHPDDMCOARSECORRECTIONTYPE = ePCHPDDMCoarseCorrectionType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCHPDDMCOARSECORRECTIONTYPE
#endif
    PCHPDDMCoarseCorrectionType, parameter :: PC_HPDDM_COARSE_CORRECTION_DEFLATED = ePCHPDDMCoarseCorrectionType(0)
    PCHPDDMCoarseCorrectionType, parameter :: PC_HPDDM_COARSE_CORRECTION_ADDITIVE = ePCHPDDMCoarseCorrectionType(1)
    PCHPDDMCoarseCorrectionType, parameter :: PC_HPDDM_COARSE_CORRECTION_BALANCED = ePCHPDDMCoarseCorrectionType(2)
    PCHPDDMCoarseCorrectionType, parameter :: PC_HPDDM_COARSE_CORRECTION_NONE = ePCHPDDMCoarseCorrectionType(3)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PC_HPDDM_COARSE_CORRECTION_DEFLATED
!DEC$ ATTRIBUTES DLLEXPORT::PC_HPDDM_COARSE_CORRECTION_ADDITIVE
!DEC$ ATTRIBUTES DLLEXPORT::PC_HPDDM_COARSE_CORRECTION_BALANCED
!DEC$ ATTRIBUTES DLLEXPORT::PC_HPDDM_COARSE_CORRECTION_NONE
#endif

  type ePCHPDDMSchurPreType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCHPDDMSchurPreType

  PCHPDDMSchurPreType, parameter :: PETSC_NULL_PCHPDDMSCHURPRETYPE = ePCHPDDMSchurPreType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCHPDDMSCHURPRETYPE
#endif
    PCHPDDMSchurPreType, parameter :: PC_HPDDM_SCHUR_PRE_LEAST_SQUARES = ePCHPDDMSchurPreType(0)
    PCHPDDMSchurPreType, parameter :: PC_HPDDM_SCHUR_PRE_GENEO = ePCHPDDMSchurPreType(1)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PC_HPDDM_SCHUR_PRE_LEAST_SQUARES
!DEC$ ATTRIBUTES DLLEXPORT::PC_HPDDM_SCHUR_PRE_GENEO
#endif

  type ePCFailedReason
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCFailedReason

  PCFailedReason, parameter :: PETSC_NULL_PCFAILEDREASON = ePCFailedReason(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCFAILEDREASON
#endif
    PCFailedReason, parameter :: PC_SETUP_ERROR = ePCFailedReason(-1)
    PCFailedReason, parameter :: PC_NOERROR = ePCFailedReason(0)
    PCFailedReason, parameter :: PC_FACTOR_STRUCT_ZEROPIVOT = ePCFailedReason(1)
    PCFailedReason, parameter :: PC_FACTOR_NUMERIC_ZEROPIVOT = ePCFailedReason(2)
    PCFailedReason, parameter :: PC_FACTOR_OUTMEMORY = ePCFailedReason(3)
    PCFailedReason, parameter :: PC_FACTOR_OTHER = ePCFailedReason(4)
    PCFailedReason, parameter :: PC_INCONSISTENT_RHS = ePCFailedReason(5)
    PCFailedReason, parameter :: PC_SUBPC_ERROR = ePCFailedReason(6)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PC_SETUP_ERROR 
!DEC$ ATTRIBUTES DLLEXPORT::PC_NOERROR 
!DEC$ ATTRIBUTES DLLEXPORT::PC_FACTOR_STRUCT_ZEROPIVOT 
!DEC$ ATTRIBUTES DLLEXPORT::PC_FACTOR_NUMERIC_ZEROPIVOT 
!DEC$ ATTRIBUTES DLLEXPORT::PC_FACTOR_OUTMEMORY 
!DEC$ ATTRIBUTES DLLEXPORT::PC_FACTOR_OTHER 
!DEC$ ATTRIBUTES DLLEXPORT::PC_INCONSISTENT_RHS 
!DEC$ ATTRIBUTES DLLEXPORT::PC_SUBPC_ERROR 
#endif

  type ePCGAMGLayoutType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePCGAMGLayoutType

  PCGAMGLayoutType, parameter :: PETSC_NULL_PCGAMGLAYOUTTYPE = ePCGAMGLayoutType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_PCGAMGLAYOUTTYPE
#endif
    PCGAMGLayoutType, parameter :: PCGAMG_LAYOUT_COMPACT = ePCGAMGLayoutType(0)
    PCGAMGLayoutType, parameter :: PCGAMG_LAYOUT_SPREAD = ePCGAMGLayoutType(1)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PCGAMG_LAYOUT_COMPACT
!DEC$ ATTRIBUTES DLLEXPORT::PCGAMG_LAYOUT_SPREAD
#endif

  CHARACTER(LEN=*), PARAMETER :: PCNONE = 'none'
  CHARACTER(LEN=*), PARAMETER :: PCJACOBI = 'jacobi'
  CHARACTER(LEN=*), PARAMETER :: PCSOR = 'sor'
  CHARACTER(LEN=*), PARAMETER :: PCLU = 'lu'
  CHARACTER(LEN=*), PARAMETER :: PCQR = 'qr'
  CHARACTER(LEN=*), PARAMETER :: PCSHELL = 'shell'
  CHARACTER(LEN=*), PARAMETER :: PCAMGX = 'amgx'
  CHARACTER(LEN=*), PARAMETER :: PCBJACOBI = 'bjacobi'
  CHARACTER(LEN=*), PARAMETER :: PCMG = 'mg'
  CHARACTER(LEN=*), PARAMETER :: PCEISENSTAT = 'eisenstat'
  CHARACTER(LEN=*), PARAMETER :: PCILU = 'ilu'
  CHARACTER(LEN=*), PARAMETER :: PCICC = 'icc'
  CHARACTER(LEN=*), PARAMETER :: PCASM = 'asm'
  CHARACTER(LEN=*), PARAMETER :: PCGASM = 'gasm'
  CHARACTER(LEN=*), PARAMETER :: PCKSP = 'ksp'
  CHARACTER(LEN=*), PARAMETER :: PCBJKOKKOS = 'bjkokkos'
  CHARACTER(LEN=*), PARAMETER :: PCCOMPOSITE = 'composite'
  CHARACTER(LEN=*), PARAMETER :: PCREDUNDANT = 'redundant'
  CHARACTER(LEN=*), PARAMETER :: PCSPAI = 'spai'
  CHARACTER(LEN=*), PARAMETER :: PCNN = 'nn'
  CHARACTER(LEN=*), PARAMETER :: PCCHOLESKY = 'cholesky'
  CHARACTER(LEN=*), PARAMETER :: PCPBJACOBI = 'pbjacobi'
  CHARACTER(LEN=*), PARAMETER :: PCVPBJACOBI = 'vpbjacobi'
  CHARACTER(LEN=*), PARAMETER :: PCMAT = 'mat'
  CHARACTER(LEN=*), PARAMETER :: PCHYPRE = 'hypre'
  CHARACTER(LEN=*), PARAMETER :: PCPARMS = 'parms'
  CHARACTER(LEN=*), PARAMETER :: PCFIELDSPLIT = 'fieldsplit'
  CHARACTER(LEN=*), PARAMETER :: PCTFS = 'tfs'
  CHARACTER(LEN=*), PARAMETER :: PCML = 'ml'
  CHARACTER(LEN=*), PARAMETER :: PCGALERKIN = 'galerkin'
  CHARACTER(LEN=*), PARAMETER :: PCEXOTIC = 'exotic'
  CHARACTER(LEN=*), PARAMETER :: PCCP = 'cp'
  CHARACTER(LEN=*), PARAMETER :: PCLSC = 'lsc'
  CHARACTER(LEN=*), PARAMETER :: PCPYTHON = 'python'
  CHARACTER(LEN=*), PARAMETER :: PCPFMG = 'pfmg'
  CHARACTER(LEN=*), PARAMETER :: PCSMG = 'smg'
  CHARACTER(LEN=*), PARAMETER :: PCSYSPFMG = 'syspfmg'
  CHARACTER(LEN=*), PARAMETER :: PCREDISTRIBUTE = 'redistribute'
  CHARACTER(LEN=*), PARAMETER :: PCSVD = 'svd'
  CHARACTER(LEN=*), PARAMETER :: PCGAMG = 'gamg'
  CHARACTER(LEN=*), PARAMETER :: PCCHOWILUVIENNACL = 'chowiluviennacl'
  CHARACTER(LEN=*), PARAMETER :: PCROWSCALINGVIENNACL = 'rowscalingviennacl'
  CHARACTER(LEN=*), PARAMETER :: PCSAVIENNACL = 'saviennacl'
  CHARACTER(LEN=*), PARAMETER :: PCBDDC = 'bddc'
  CHARACTER(LEN=*), PARAMETER :: PCKACZMARZ = 'kaczmarz'
  CHARACTER(LEN=*), PARAMETER :: PCTELESCOPE = 'telescope'
  CHARACTER(LEN=*), PARAMETER :: PCPATCH = 'patch'
  CHARACTER(LEN=*), PARAMETER :: PCLMVM = 'lmvm'
  CHARACTER(LEN=*), PARAMETER :: PCHMG = 'hmg'
  CHARACTER(LEN=*), PARAMETER :: PCDEFLATION = 'deflation'
  CHARACTER(LEN=*), PARAMETER :: PCHPDDM = 'hpddm'
  CHARACTER(LEN=*), PARAMETER :: PCH2OPUS = 'h2opus'
  CHARACTER(LEN=*), PARAMETER :: PCMPI = 'mpi'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PCNONE
!DEC$ ATTRIBUTES DLLEXPORT::PCJACOBI
!DEC$ ATTRIBUTES DLLEXPORT::PCSOR
!DEC$ ATTRIBUTES DLLEXPORT::PCLU
!DEC$ ATTRIBUTES DLLEXPORT::PCQR
!DEC$ ATTRIBUTES DLLEXPORT::PCSHELL
!DEC$ ATTRIBUTES DLLEXPORT::PCAMGX
!DEC$ ATTRIBUTES DLLEXPORT::PCBJACOBI
!DEC$ ATTRIBUTES DLLEXPORT::PCMG
!DEC$ ATTRIBUTES DLLEXPORT::PCEISENSTAT
!DEC$ ATTRIBUTES DLLEXPORT::PCILU
!DEC$ ATTRIBUTES DLLEXPORT::PCICC
!DEC$ ATTRIBUTES DLLEXPORT::PCASM
!DEC$ ATTRIBUTES DLLEXPORT::PCGASM
!DEC$ ATTRIBUTES DLLEXPORT::PCKSP
!DEC$ ATTRIBUTES DLLEXPORT::PCBJKOKKOS
!DEC$ ATTRIBUTES DLLEXPORT::PCCOMPOSITE
!DEC$ ATTRIBUTES DLLEXPORT::PCREDUNDANT
!DEC$ ATTRIBUTES DLLEXPORT::PCSPAI
!DEC$ ATTRIBUTES DLLEXPORT::PCNN
!DEC$ ATTRIBUTES DLLEXPORT::PCCHOLESKY
!DEC$ ATTRIBUTES DLLEXPORT::PCPBJACOBI
!DEC$ ATTRIBUTES DLLEXPORT::PCVPBJACOBI
!DEC$ ATTRIBUTES DLLEXPORT::PCMAT
!DEC$ ATTRIBUTES DLLEXPORT::PCHYPRE
!DEC$ ATTRIBUTES DLLEXPORT::PCPARMS
!DEC$ ATTRIBUTES DLLEXPORT::PCFIELDSPLIT
!DEC$ ATTRIBUTES DLLEXPORT::PCTFS
!DEC$ ATTRIBUTES DLLEXPORT::PCML
!DEC$ ATTRIBUTES DLLEXPORT::PCGALERKIN
!DEC$ ATTRIBUTES DLLEXPORT::PCEXOTIC
!DEC$ ATTRIBUTES DLLEXPORT::PCCP
!DEC$ ATTRIBUTES DLLEXPORT::PCLSC
!DEC$ ATTRIBUTES DLLEXPORT::PCPYTHON
!DEC$ ATTRIBUTES DLLEXPORT::PCPFMG
!DEC$ ATTRIBUTES DLLEXPORT::PCSMG
!DEC$ ATTRIBUTES DLLEXPORT::PCSYSPFMG
!DEC$ ATTRIBUTES DLLEXPORT::PCREDISTRIBUTE
!DEC$ ATTRIBUTES DLLEXPORT::PCSVD
!DEC$ ATTRIBUTES DLLEXPORT::PCGAMG
!DEC$ ATTRIBUTES DLLEXPORT::PCCHOWILUVIENNACL
!DEC$ ATTRIBUTES DLLEXPORT::PCROWSCALINGVIENNACL
!DEC$ ATTRIBUTES DLLEXPORT::PCSAVIENNACL
!DEC$ ATTRIBUTES DLLEXPORT::PCBDDC
!DEC$ ATTRIBUTES DLLEXPORT::PCKACZMARZ
!DEC$ ATTRIBUTES DLLEXPORT::PCTELESCOPE
!DEC$ ATTRIBUTES DLLEXPORT::PCPATCH
!DEC$ ATTRIBUTES DLLEXPORT::PCLMVM
!DEC$ ATTRIBUTES DLLEXPORT::PCHMG
!DEC$ ATTRIBUTES DLLEXPORT::PCDEFLATION
!DEC$ ATTRIBUTES DLLEXPORT::PCHPDDM
!DEC$ ATTRIBUTES DLLEXPORT::PCH2OPUS
!DEC$ ATTRIBUTES DLLEXPORT::PCMPI
#endif

  CHARACTER(LEN=*), PARAMETER :: PCGAMGAGG = 'agg'
  CHARACTER(LEN=*), PARAMETER :: PCGAMGGEO = 'geo'
  CHARACTER(LEN=*), PARAMETER :: PCGAMGCLASSICAL = 'classical'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PCGAMGAGG
!DEC$ ATTRIBUTES DLLEXPORT::PCGAMGGEO
!DEC$ ATTRIBUTES DLLEXPORT::PCGAMGCLASSICAL
#endif

  CHARACTER(LEN=*), PARAMETER :: PCGAMGCLASSICALDIRECT = 'direct'
  CHARACTER(LEN=*), PARAMETER :: PCGAMGCLASSICALSTANDARD = 'standard'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PCGAMGCLASSICALDIRECT
!DEC$ ATTRIBUTES DLLEXPORT::PCGAMGCLASSICALSTANDARD
#endif

