#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isblocksetindices_ ISBLOCKSETINDICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isblocksetindices_ isblocksetindices
#endif
PETSC_EXTERN void isblocksetindices_(IS *a, PetscInt *b, PetscInt *c, const PetscInt d[], PetscCopyMode *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = ISBlockSetIndices(*a, *b, *c, d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define iscreateblock_ ISCREATEBLOCK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define iscreateblock_ iscreateblock
#endif
PETSC_EXTERN void iscreateblock_(MPI_Fint *a, PetscInt *b, PetscInt *c, const PetscInt d[], PetscCopyMode *e, IS *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLOBJECT(f);
  *ierr = ISCreateBlock(MPI_Comm_f2c(*(a)), *b, *c, d, *e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isblockgetlocalsize_ ISBLOCKGETLOCALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isblockgetlocalsize_ isblockgetlocalsize
#endif
PETSC_EXTERN void isblockgetlocalsize_(IS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = ISBlockGetLocalSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isblockgetsize_ ISBLOCKGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isblockgetsize_ isblockgetsize
#endif
PETSC_EXTERN void isblockgetsize_(IS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = ISBlockGetSize(*a, b);
  if (*ierr) return;
}
