#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmultequal_ MATMULTEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmultequal_ matmultequal
#endif
PETSC_EXTERN void matmultequal_(Mat *a, Mat *b, PetscInt *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(d);
  *ierr = MatMultEqual(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmultaddequal_ MATMULTADDEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmultaddequal_ matmultaddequal
#endif
PETSC_EXTERN void matmultaddequal_(Mat *a, Mat *b, PetscInt *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(d);
  *ierr = MatMultAddEqual(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmulttransposeequal_ MATMULTTRANSPOSEEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmulttransposeequal_ matmulttransposeequal
#endif
PETSC_EXTERN void matmulttransposeequal_(Mat *a, Mat *b, PetscInt *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(d);
  *ierr = MatMultTransposeEqual(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmulttransposeaddequal_ MATMULTTRANSPOSEADDEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmulttransposeaddequal_ matmulttransposeaddequal
#endif
PETSC_EXTERN void matmulttransposeaddequal_(Mat *a, Mat *b, PetscInt *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(d);
  *ierr = MatMultTransposeAddEqual(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmulthermitiantransposeequal_ MATMULTHERMITIANTRANSPOSEEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmulthermitiantransposeequal_ matmulthermitiantransposeequal
#endif
PETSC_EXTERN void matmulthermitiantransposeequal_(Mat *a, Mat *b, PetscInt *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(d);
  *ierr = MatMultHermitianTransposeEqual(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmulthermitiantransposeaddequal_ MATMULTHERMITIANTRANSPOSEADDEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmulthermitiantransposeaddequal_ matmulthermitiantransposeaddequal
#endif
PETSC_EXTERN void matmulthermitiantransposeaddequal_(Mat *a, Mat *b, PetscInt *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(d);
  *ierr = MatMultHermitianTransposeAddEqual(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmatmultequal_ MATMATMULTEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmatmultequal_ matmatmultequal
#endif
PETSC_EXTERN void matmatmultequal_(Mat *a, Mat *b, Mat *c, PetscInt *d, PetscBool *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(e);
  *ierr = MatMatMultEqual(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define mattransposematmultequal_ MATTRANSPOSEMATMULTEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define mattransposematmultequal_ mattransposematmultequal
#endif
PETSC_EXTERN void mattransposematmultequal_(Mat *a, Mat *b, Mat *c, PetscInt *d, PetscBool *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(e);
  *ierr = MatTransposeMatMultEqual(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmattransposemultequal_ MATMATTRANSPOSEMULTEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmattransposemultequal_ matmattransposemultequal
#endif
PETSC_EXTERN void matmattransposemultequal_(Mat *a, Mat *b, Mat *c, PetscInt *d, PetscBool *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(e);
  *ierr = MatMatTransposeMultEqual(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matptapmultequal_ MATPTAPMULTEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matptapmultequal_ matptapmultequal
#endif
PETSC_EXTERN void matptapmultequal_(Mat *a, Mat *b, Mat *c, PetscInt *d, PetscBool *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(e);
  *ierr = MatPtAPMultEqual(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matrartmultequal_ MATRARTMULTEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matrartmultequal_ matrartmultequal
#endif
PETSC_EXTERN void matrartmultequal_(Mat *a, Mat *b, Mat *c, PetscInt *d, PetscBool *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(e);
  *ierr = MatRARtMultEqual(*a, *b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matislinear_ MATISLINEAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matislinear_ matislinear
#endif
PETSC_EXTERN void matislinear_(Mat *a, PetscInt *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = MatIsLinear(*a, *b, c);
  if (*ierr) return;
}
