#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexextrude_ DMPLEXEXTRUDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexextrude_ dmplexextrude
#endif
PETSC_EXTERN void dmplexextrude_(DM *a, PetscInt *b, PetscReal *c, PetscBool *d, PetscBool *e, PetscBool *f, const PetscReal g[], const PetscReal h[], DM *i, PetscErrorCode *ierr)
{
  PetscBool null_i = !*(void**) i ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLREAL(g);
  CHKFORTRANNULLREAL(h);
  CHKFORTRANNULLOBJECT(i);
  *ierr = DMPlexExtrude(*a, *b, *c, *d ? PETSC_TRUE : PETSC_FALSE, *e ? PETSC_TRUE : PETSC_FALSE, *f ? PETSC_TRUE : PETSC_FALSE, g, h, i);
  if (*ierr) return;
  if (! null_i && !*(void**) i) *(void **) i = (void *)-2;
}
