#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesmsregisterall_ SNESMSREGISTERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesmsregisterall_ snesmsregisterall
#endif
PETSC_EXTERN void snesmsregisterall_(PetscErrorCode *ierr)
{
  *ierr = SNESMSRegisterAll();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesmsregisterdestroy_ SNESMSREGISTERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesmsregisterdestroy_ snesmsregisterdestroy
#endif
PETSC_EXTERN void snesmsregisterdestroy_(PetscErrorCode *ierr)
{
  *ierr = SNESMSRegisterDestroy();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesmsinitializepackage_ SNESMSINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesmsinitializepackage_ snesmsinitializepackage
#endif
PETSC_EXTERN void snesmsinitializepackage_(PetscErrorCode *ierr)
{
  *ierr = SNESMSInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesmsfinalizepackage_ SNESMSFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesmsfinalizepackage_ snesmsfinalizepackage
#endif
PETSC_EXTERN void snesmsfinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = SNESMSFinalizePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesmsregister_ SNESMSREGISTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesmsregister_ snesmsregister
#endif
PETSC_EXTERN void snesmsregister_(char * a, PetscInt *b, PetscInt *c, PetscReal *d, const PetscReal e[], const PetscReal f[], const PetscReal g[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLREAL(g);
  *ierr = SNESMSRegister(c_a, *b, *c, *d, e, f, g);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesmsgettype_ SNESMSGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesmsgettype_ snesmsgettype
#endif
PETSC_EXTERN void snesmsgettype_(SNES *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = SNESMSGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesmssettype_ SNESMSSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesmssettype_ snesmssettype
#endif
PETSC_EXTERN void snesmssettype_(SNES *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = SNESMSSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesmsgetdamping_ SNESMSGETDAMPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesmsgetdamping_ snesmsgetdamping
#endif
PETSC_EXTERN void snesmsgetdamping_(SNES *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = SNESMSGetDamping(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesmssetdamping_ SNESMSSETDAMPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesmssetdamping_ snesmssetdamping
#endif
PETSC_EXTERN void snesmssetdamping_(SNES *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = SNESMSSetDamping(*a, *b);
  if (*ierr) return;
}
