#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matscalapacksetblocksizes_ MATSCALAPACKSETBLOCKSIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matscalapacksetblocksizes_ matscalapacksetblocksizes
#endif
PETSC_EXTERN void matscalapacksetblocksizes_(Mat *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = MatScaLAPACKSetBlockSizes(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matscalapackgetblocksizes_ MATSCALAPACKGETBLOCKSIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matscalapackgetblocksizes_ matscalapackgetblocksizes
#endif
PETSC_EXTERN void matscalapackgetblocksizes_(Mat *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatScaLAPACKGetBlockSizes(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatescalapack_ MATCREATESCALAPACK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatescalapack_ matcreatescalapack
#endif
PETSC_EXTERN void matcreatescalapack_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscInt *g, Mat *h, PetscErrorCode *ierr)
{
  PetscBool null_h = !*(void**) h ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(h);
  *ierr = MatCreateScaLAPACK(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, *f, *g, h);
  if (*ierr) return;
  if (! null_h && !*(void**) h) *(void **) h = (void *)-2;
}
