#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matnestgetsubmat_ MATNESTGETSUBMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matnestgetsubmat_ matnestgetsubmat
#endif
PETSC_EXTERN void matnestgetsubmat_(Mat *a, PetscInt *b, PetscInt *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatNestGetSubMat(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matnestsetsubmat_ MATNESTSETSUBMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matnestsetsubmat_ matnestsetsubmat
#endif
PETSC_EXTERN void matnestsetsubmat_(Mat *a, PetscInt *b, PetscInt *c, Mat *d, PetscErrorCode *ierr)
{
  *ierr = MatNestSetSubMat(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matnestgetsize_ MATNESTGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matnestgetsize_ matnestgetsize
#endif
PETSC_EXTERN void matnestgetsize_(Mat *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatNestGetSize(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matnestgetiss_ MATNESTGETISS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matnestgetiss_ matnestgetiss
#endif
PETSC_EXTERN void matnestgetiss_(Mat *a, IS b[], IS c[], PetscErrorCode *ierr)
{
  *ierr = MatNestGetISs(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matnestgetlocaliss_ MATNESTGETLOCALISS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matnestgetlocaliss_ matnestgetlocaliss
#endif
PETSC_EXTERN void matnestgetlocaliss_(Mat *a, IS b[], IS c[], PetscErrorCode *ierr)
{
  *ierr = MatNestGetLocalISs(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matnestsetvectype_ MATNESTSETVECTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matnestsetvectype_ matnestsetvectype
#endif
PETSC_EXTERN void matnestsetvectype_(Mat *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = MatNestSetVecType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matnestsetsubmats_ MATNESTSETSUBMATS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matnestsetsubmats_ matnestsetsubmats
#endif
PETSC_EXTERN void matnestsetsubmats_(Mat *a, PetscInt *b, const IS c[], PetscInt *d, const IS e[], const Mat f[], PetscErrorCode *ierr)
{
  *ierr = MatNestSetSubMats(*a, *b, c, *d, e, f);
  if (*ierr) return;
}
