#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformextrudegetlayers_ DMPLEXTRANSFORMEXTRUDEGETLAYERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformextrudegetlayers_ dmplextransformextrudegetlayers
#endif
PETSC_EXTERN void dmplextransformextrudegetlayers_(DMPlexTransform *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMPlexTransformExtrudeGetLayers(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformextrudesetlayers_ DMPLEXTRANSFORMEXTRUDESETLAYERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformextrudesetlayers_ dmplextransformextrudesetlayers
#endif
PETSC_EXTERN void dmplextransformextrudesetlayers_(DMPlexTransform *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexTransformExtrudeSetLayers(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformextrudegetthickness_ DMPLEXTRANSFORMEXTRUDEGETTHICKNESS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformextrudegetthickness_ dmplextransformextrudegetthickness
#endif
PETSC_EXTERN void dmplextransformextrudegetthickness_(DMPlexTransform *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = DMPlexTransformExtrudeGetThickness(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformextrudesetthickness_ DMPLEXTRANSFORMEXTRUDESETTHICKNESS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformextrudesetthickness_ dmplextransformextrudesetthickness
#endif
PETSC_EXTERN void dmplextransformextrudesetthickness_(DMPlexTransform *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexTransformExtrudeSetThickness(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformextrudegettensor_ DMPLEXTRANSFORMEXTRUDEGETTENSOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformextrudegettensor_ dmplextransformextrudegettensor
#endif
PETSC_EXTERN void dmplextransformextrudegettensor_(DMPlexTransform *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexTransformExtrudeGetTensor(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformextrudesettensor_ DMPLEXTRANSFORMEXTRUDESETTENSOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformextrudesettensor_ dmplextransformextrudesettensor
#endif
PETSC_EXTERN void dmplextransformextrudesettensor_(DMPlexTransform *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexTransformExtrudeSetTensor(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformextrudegetsymmetric_ DMPLEXTRANSFORMEXTRUDEGETSYMMETRIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformextrudegetsymmetric_ dmplextransformextrudegetsymmetric
#endif
PETSC_EXTERN void dmplextransformextrudegetsymmetric_(DMPlexTransform *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexTransformExtrudeGetSymmetric(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformextrudesetsymmetric_ DMPLEXTRANSFORMEXTRUDESETSYMMETRIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformextrudesetsymmetric_ dmplextransformextrudesetsymmetric
#endif
PETSC_EXTERN void dmplextransformextrudesetsymmetric_(DMPlexTransform *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexTransformExtrudeSetSymmetric(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformextrudegetperiodic_ DMPLEXTRANSFORMEXTRUDEGETPERIODIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformextrudegetperiodic_ dmplextransformextrudegetperiodic
#endif
PETSC_EXTERN void dmplextransformextrudegetperiodic_(DMPlexTransform *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexTransformExtrudeGetPeriodic(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformextrudesetperiodic_ DMPLEXTRANSFORMEXTRUDESETPERIODIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformextrudesetperiodic_ dmplextransformextrudesetperiodic
#endif
PETSC_EXTERN void dmplextransformextrudesetperiodic_(DMPlexTransform *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexTransformExtrudeSetPeriodic(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformextrudegetnormal_ DMPLEXTRANSFORMEXTRUDEGETNORMAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformextrudegetnormal_ dmplextransformextrudegetnormal
#endif
PETSC_EXTERN void dmplextransformextrudegetnormal_(DMPlexTransform *a, PetscReal b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = DMPlexTransformExtrudeGetNormal(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformextrudesetnormal_ DMPLEXTRANSFORMEXTRUDESETNORMAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformextrudesetnormal_ dmplextransformextrudesetnormal
#endif
PETSC_EXTERN void dmplextransformextrudesetnormal_(DMPlexTransform *a, const PetscReal b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = DMPlexTransformExtrudeSetNormal(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformextrudesetthicknesses_ DMPLEXTRANSFORMEXTRUDESETTHICKNESSES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformextrudesetthicknesses_ dmplextransformextrudesetthicknesses
#endif
PETSC_EXTERN void dmplextransformextrudesetthicknesses_(DMPlexTransform *a, PetscInt *b, const PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = DMPlexTransformExtrudeSetThicknesses(*a, *b, c);
  if (*ierr) return;
}
