#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecexp_ VECEXP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecexp_ vecexp
#endif
PETSC_EXTERN void vecexp_(Vec *a, PetscErrorCode *ierr)
{
  *ierr = VecExp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veclog_ VECLOG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veclog_ veclog
#endif
PETSC_EXTERN void veclog_(Vec *a, PetscErrorCode *ierr)
{
  *ierr = VecLog(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecabs_ VECABS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecabs_ vecabs
#endif
PETSC_EXTERN void vecabs_(Vec *a, PetscErrorCode *ierr)
{
  *ierr = VecAbs(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecconjugate_ VECCONJUGATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecconjugate_ vecconjugate
#endif
PETSC_EXTERN void vecconjugate_(Vec *a, PetscErrorCode *ierr)
{
  *ierr = VecConjugate(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecimaginarypart_ VECIMAGINARYPART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecimaginarypart_ vecimaginarypart
#endif
PETSC_EXTERN void vecimaginarypart_(Vec *a, PetscErrorCode *ierr)
{
  *ierr = VecImaginaryPart(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecrealpart_ VECREALPART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecrealpart_ vecrealpart
#endif
PETSC_EXTERN void vecrealpart_(Vec *a, PetscErrorCode *ierr)
{
  *ierr = VecRealPart(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecdotnorm2_ VECDOTNORM2
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecdotnorm2_ vecdotnorm2
#endif
PETSC_EXTERN void vecdotnorm2_(Vec *a, Vec *b, PetscScalar *c, PetscReal *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  CHKFORTRANNULLREAL(d);
  *ierr = VecDotNorm2(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecmean_ VECMEAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecmean_ vecmean
#endif
PETSC_EXTERN void vecmean_(Vec *a, PetscScalar *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = VecMean(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecpermute_ VECPERMUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecpermute_ vecpermute
#endif
PETSC_EXTERN void vecpermute_(Vec *a, IS *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = VecPermute(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecequal_ VECEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecequal_ vecequal
#endif
PETSC_EXTERN void vecequal_(Vec *a, Vec *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = VecEqual(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstrideset_ VECSTRIDESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstrideset_ vecstrideset
#endif
PETSC_EXTERN void vecstrideset_(Vec *a, PetscInt *b, PetscScalar *c, PetscErrorCode *ierr)
{
  *ierr = VecStrideSet(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstridescale_ VECSTRIDESCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstridescale_ vecstridescale
#endif
PETSC_EXTERN void vecstridescale_(Vec *a, PetscInt *b, PetscScalar *c, PetscErrorCode *ierr)
{
  *ierr = VecStrideScale(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstridenorm_ VECSTRIDENORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstridenorm_ vecstridenorm
#endif
PETSC_EXTERN void vecstridenorm_(Vec *a, PetscInt *b, NormType *c, PetscReal *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  *ierr = VecStrideNorm(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstridemax_ VECSTRIDEMAX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstridemax_ vecstridemax
#endif
PETSC_EXTERN void vecstridemax_(Vec *a, PetscInt *b, PetscInt *c, PetscReal *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLREAL(d);
  *ierr = VecStrideMax(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstridemin_ VECSTRIDEMIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstridemin_ vecstridemin
#endif
PETSC_EXTERN void vecstridemin_(Vec *a, PetscInt *b, PetscInt *c, PetscReal *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLREAL(d);
  *ierr = VecStrideMin(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstridesum_ VECSTRIDESUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstridesum_ vecstridesum
#endif
PETSC_EXTERN void vecstridesum_(Vec *a, PetscInt *b, PetscScalar *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  *ierr = VecStrideSum(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstridescaleall_ VECSTRIDESCALEALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstridescaleall_ vecstridescaleall
#endif
PETSC_EXTERN void vecstridescaleall_(Vec *a, const PetscScalar *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = VecStrideScaleAll(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstridenormall_ VECSTRIDENORMALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstridenormall_ vecstridenormall
#endif
PETSC_EXTERN void vecstridenormall_(Vec *a, NormType *b, PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = VecStrideNormAll(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstridemaxall_ VECSTRIDEMAXALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstridemaxall_ vecstridemaxall
#endif
PETSC_EXTERN void vecstridemaxall_(Vec *a, PetscInt b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLREAL(c);
  *ierr = VecStrideMaxAll(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstrideminall_ VECSTRIDEMINALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstrideminall_ vecstrideminall
#endif
PETSC_EXTERN void vecstrideminall_(Vec *a, PetscInt b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLREAL(c);
  *ierr = VecStrideMinAll(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstridesumall_ VECSTRIDESUMALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstridesumall_ vecstridesumall
#endif
PETSC_EXTERN void vecstridesumall_(Vec *a, PetscScalar b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = VecStrideSumAll(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstridegatherall_ VECSTRIDEGATHERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstridegatherall_ vecstridegatherall
#endif
PETSC_EXTERN void vecstridegatherall_(Vec *a, Vec b[], InsertMode *c, PetscErrorCode *ierr)
{
  *ierr = VecStrideGatherAll(*a, b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstridescatterall_ VECSTRIDESCATTERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstridescatterall_ vecstridescatterall
#endif
PETSC_EXTERN void vecstridescatterall_(Vec a[], Vec *b, InsertMode *c, PetscErrorCode *ierr)
{
  *ierr = VecStrideScatterAll(a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstridegather_ VECSTRIDEGATHER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstridegather_ vecstridegather
#endif
PETSC_EXTERN void vecstridegather_(Vec *a, PetscInt *b, Vec *c, InsertMode *d, PetscErrorCode *ierr)
{
  *ierr = VecStrideGather(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstridescatter_ VECSTRIDESCATTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstridescatter_ vecstridescatter
#endif
PETSC_EXTERN void vecstridescatter_(Vec *a, PetscInt *b, Vec *c, InsertMode *d, PetscErrorCode *ierr)
{
  *ierr = VecStrideScatter(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstridesubsetgather_ VECSTRIDESUBSETGATHER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstridesubsetgather_ vecstridesubsetgather
#endif
PETSC_EXTERN void vecstridesubsetgather_(Vec *a, PetscInt *b, const PetscInt c[], const PetscInt d[], Vec *e, InsertMode *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = VecStrideSubSetGather(*a, *b, c, d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecstridesubsetscatter_ VECSTRIDESUBSETSCATTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecstridesubsetscatter_ vecstridesubsetscatter
#endif
PETSC_EXTERN void vecstridesubsetscatter_(Vec *a, PetscInt *b, const PetscInt c[], const PetscInt d[], Vec *e, InsertMode *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = VecStrideSubSetScatter(*a, *b, c, d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsqrtabs_ VECSQRTABS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsqrtabs_ vecsqrtabs
#endif
PETSC_EXTERN void vecsqrtabs_(Vec *a, PetscErrorCode *ierr)
{
  *ierr = VecSqrtAbs(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsum_ VECSUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsum_ vecsum
#endif
PETSC_EXTERN void vecsum_(Vec *a, PetscScalar *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = VecSum(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecshift_ VECSHIFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecshift_ vecshift
#endif
PETSC_EXTERN void vecshift_(Vec *a, PetscScalar *b, PetscErrorCode *ierr)
{
  *ierr = VecShift(*a, *b);
  if (*ierr) return;
}
