  type, extends(tPetscObject) ::  tTao
  end type tTao
  Tao, parameter :: PETSC_NULL_TAO = tTao(0)
  Tao, target :: PETSC_NULL_TAO_ARRAY(1) = [tTao(0)]
  Tao, pointer :: PETSC_NULL_TAO_POINTER(:) => PETSC_NULL_TAO_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TAO
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TAO_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TAO_POINTER
#endif

  type tTaoMonitorDrawCtx
    PetscFortranAddr:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type tTaoMonitorDrawCtx
  TaoMonitorDrawCtx, parameter :: PETSC_NULL_TAOMONITORDRAWCTX = tTaoMonitorDrawCtx(0)
  TaoMonitorDrawCtx, target :: PETSC_NULL_TAOMONITORDRAWCTX_ARRAY(1) = [tTaoMonitorDrawCtx(0)]
  TaoMonitorDrawCtx, pointer :: PETSC_NULL_TAOMONITORDRAWCTX_POINTER(:) => PETSC_NULL_TAOMONITORDRAWCTX_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TAOMONITORDRAWCTX
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TAOMONITORDRAWCTX_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TAOMONITORDRAWCTX_POINTER
#endif

  type eTaoSubsetType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eTaoSubsetType

  TaoSubsetType, parameter :: PETSC_NULL_TAOSUBSETTYPE = eTaoSubsetType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TAOSUBSETTYPE
#endif
    TaoSubsetType, parameter :: TAO_SUBSET_SUBVEC = eTaoSubsetType(0)
    TaoSubsetType, parameter :: TAO_SUBSET_MASK = eTaoSubsetType(1)
    TaoSubsetType, parameter :: TAO_SUBSET_MATRIXFREE = eTaoSubsetType(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TAO_SUBSET_SUBVEC
!DEC$ ATTRIBUTES DLLEXPORT::TAO_SUBSET_MASK
!DEC$ ATTRIBUTES DLLEXPORT::TAO_SUBSET_MATRIXFREE
#endif

  type eTaoADMMUpdateType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eTaoADMMUpdateType

  TaoADMMUpdateType, parameter :: PETSC_NULL_TAOADMMUPDATETYPE = eTaoADMMUpdateType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TAOADMMUPDATETYPE
#endif
    TaoADMMUpdateType, parameter :: TAO_ADMM_UPDATE_BASIC = eTaoADMMUpdateType(0)
    TaoADMMUpdateType, parameter :: TAO_ADMM_UPDATE_ADAPTIVE = eTaoADMMUpdateType(1)
    TaoADMMUpdateType, parameter :: TAO_ADMM_UPDATE_ADAPTIVE_RELAXED = eTaoADMMUpdateType(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TAO_ADMM_UPDATE_BASIC
!DEC$ ATTRIBUTES DLLEXPORT::TAO_ADMM_UPDATE_ADAPTIVE
!DEC$ ATTRIBUTES DLLEXPORT::TAO_ADMM_UPDATE_ADAPTIVE_RELAXED
#endif

  type eTaoADMMRegularizerType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eTaoADMMRegularizerType

  TaoADMMRegularizerType, parameter :: PETSC_NULL_TAOADMMREGULARIZERTYPE = eTaoADMMRegularizerType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TAOADMMREGULARIZERTYPE
#endif
    TaoADMMRegularizerType, parameter :: TAO_ADMM_REGULARIZER_USER = eTaoADMMRegularizerType(0)
    TaoADMMRegularizerType, parameter :: TAO_ADMM_REGULARIZER_SOFT_THRESH = eTaoADMMRegularizerType(1)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TAO_ADMM_REGULARIZER_USER
!DEC$ ATTRIBUTES DLLEXPORT::TAO_ADMM_REGULARIZER_SOFT_THRESH
#endif

  type eTaoALMMType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eTaoALMMType

  TaoALMMType, parameter :: PETSC_NULL_TAOALMMTYPE = eTaoALMMType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TAOALMMTYPE
#endif
    TaoALMMType, parameter :: TAO_ALMM_CLASSIC = eTaoALMMType(0)
    TaoALMMType, parameter :: TAO_ALMM_PHR = eTaoALMMType(1)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TAO_ALMM_CLASSIC
!DEC$ ATTRIBUTES DLLEXPORT::TAO_ALMM_PHR
#endif

  type eTaoBNCGType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eTaoBNCGType

  TaoBNCGType, parameter :: PETSC_NULL_TAOBNCGTYPE = eTaoBNCGType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TAOBNCGTYPE
#endif
    TaoBNCGType, parameter :: TAO_BNCG_GD = eTaoBNCGType(0)
    TaoBNCGType, parameter :: TAO_BNCG_PCGD = eTaoBNCGType(1)
    TaoBNCGType, parameter :: TAO_BNCG_HS = eTaoBNCGType(2)
    TaoBNCGType, parameter :: TAO_BNCG_FR = eTaoBNCGType(3)
    TaoBNCGType, parameter :: TAO_BNCG_PRP = eTaoBNCGType(4)
    TaoBNCGType, parameter :: TAO_BNCG_PRP_PLUS = eTaoBNCGType(5)
    TaoBNCGType, parameter :: TAO_BNCG_DY = eTaoBNCGType(6)
    TaoBNCGType, parameter :: TAO_BNCG_HZ = eTaoBNCGType(7)
    TaoBNCGType, parameter :: TAO_BNCG_DK = eTaoBNCGType(8)
    TaoBNCGType, parameter :: TAO_BNCG_KD = eTaoBNCGType(9)
    TaoBNCGType, parameter :: TAO_BNCG_SSML_BFGS = eTaoBNCGType(10)
    TaoBNCGType, parameter :: TAO_BNCG_SSML_DFP = eTaoBNCGType(11)
    TaoBNCGType, parameter :: TAO_BNCG_SSML_BRDN = eTaoBNCGType(12)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TAO_BNCG_GD
!DEC$ ATTRIBUTES DLLEXPORT::TAO_BNCG_PCGD
!DEC$ ATTRIBUTES DLLEXPORT::TAO_BNCG_HS
!DEC$ ATTRIBUTES DLLEXPORT::TAO_BNCG_FR
!DEC$ ATTRIBUTES DLLEXPORT::TAO_BNCG_PRP
!DEC$ ATTRIBUTES DLLEXPORT::TAO_BNCG_PRP_PLUS
!DEC$ ATTRIBUTES DLLEXPORT::TAO_BNCG_DY
!DEC$ ATTRIBUTES DLLEXPORT::TAO_BNCG_HZ
!DEC$ ATTRIBUTES DLLEXPORT::TAO_BNCG_DK
!DEC$ ATTRIBUTES DLLEXPORT::TAO_BNCG_KD
!DEC$ ATTRIBUTES DLLEXPORT::TAO_BNCG_SSML_BFGS
!DEC$ ATTRIBUTES DLLEXPORT::TAO_BNCG_SSML_DFP
!DEC$ ATTRIBUTES DLLEXPORT::TAO_BNCG_SSML_BRDN
#endif

  type eTaoConvergedReason
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eTaoConvergedReason

  TaoConvergedReason, parameter :: PETSC_NULL_TAOCONVERGEDREASON = eTaoConvergedReason(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_TAOCONVERGEDREASON
#endif
    TaoConvergedReason, parameter :: TAO_CONVERGED_GATOL = eTaoConvergedReason(3)
    TaoConvergedReason, parameter :: TAO_CONVERGED_GRTOL = eTaoConvergedReason(4)
    TaoConvergedReason, parameter :: TAO_CONVERGED_GTTOL = eTaoConvergedReason(5)
    TaoConvergedReason, parameter :: TAO_CONVERGED_STEPTOL = eTaoConvergedReason(6)
    TaoConvergedReason, parameter :: TAO_CONVERGED_MINF = eTaoConvergedReason(7)
    TaoConvergedReason, parameter :: TAO_CONVERGED_USER = eTaoConvergedReason(8)
    TaoConvergedReason, parameter :: TAO_DIVERGED_MAXITS = eTaoConvergedReason(-2)
    TaoConvergedReason, parameter :: TAO_DIVERGED_NAN = eTaoConvergedReason(-4)
    TaoConvergedReason, parameter :: TAO_DIVERGED_MAXFCN = eTaoConvergedReason(-5)
    TaoConvergedReason, parameter :: TAO_DIVERGED_LS_FAILURE = eTaoConvergedReason(-6)
    TaoConvergedReason, parameter :: TAO_DIVERGED_TR_REDUCTION = eTaoConvergedReason(-7)
    TaoConvergedReason, parameter :: TAO_DIVERGED_USER = eTaoConvergedReason(-8)
    TaoConvergedReason, parameter :: TAO_CONTINUE_ITERATING = eTaoConvergedReason(0)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TAO_CONVERGED_GATOL 
!DEC$ ATTRIBUTES DLLEXPORT::TAO_CONVERGED_GRTOL 
!DEC$ ATTRIBUTES DLLEXPORT::TAO_CONVERGED_GTTOL 
!DEC$ ATTRIBUTES DLLEXPORT::TAO_CONVERGED_STEPTOL 
!DEC$ ATTRIBUTES DLLEXPORT::TAO_CONVERGED_MINF 
!DEC$ ATTRIBUTES DLLEXPORT::TAO_CONVERGED_USER 
!DEC$ ATTRIBUTES DLLEXPORT::TAO_DIVERGED_MAXITS 
!DEC$ ATTRIBUTES DLLEXPORT::TAO_DIVERGED_NAN 
!DEC$ ATTRIBUTES DLLEXPORT::TAO_DIVERGED_MAXFCN 
!DEC$ ATTRIBUTES DLLEXPORT::TAO_DIVERGED_LS_FAILURE 
!DEC$ ATTRIBUTES DLLEXPORT::TAO_DIVERGED_TR_REDUCTION 
!DEC$ ATTRIBUTES DLLEXPORT::TAO_DIVERGED_USER 
!DEC$ ATTRIBUTES DLLEXPORT::TAO_CONTINUE_ITERATING 
#endif

  CHARACTER(LEN=*), PARAMETER :: TAOLMVM = 'lmvm'
  CHARACTER(LEN=*), PARAMETER :: TAONLS = 'nls'
  CHARACTER(LEN=*), PARAMETER :: TAONTR = 'ntr'
  CHARACTER(LEN=*), PARAMETER :: TAONTL = 'ntl'
  CHARACTER(LEN=*), PARAMETER :: TAOCG = 'cg'
  CHARACTER(LEN=*), PARAMETER :: TAOTRON = 'tron'
  CHARACTER(LEN=*), PARAMETER :: TAOOWLQN = 'owlqn'
  CHARACTER(LEN=*), PARAMETER :: TAOBMRM = 'bmrm'
  CHARACTER(LEN=*), PARAMETER :: TAOBLMVM = 'blmvm'
  CHARACTER(LEN=*), PARAMETER :: TAOBQNLS = 'bqnls'
  CHARACTER(LEN=*), PARAMETER :: TAOBNCG = 'bncg'
  CHARACTER(LEN=*), PARAMETER :: TAOBNLS = 'bnls'
  CHARACTER(LEN=*), PARAMETER :: TAOBNTR = 'bntr'
  CHARACTER(LEN=*), PARAMETER :: TAOBNTL = 'bntl'
  CHARACTER(LEN=*), PARAMETER :: TAOBQNKLS = 'bqnkls'
  CHARACTER(LEN=*), PARAMETER :: TAOBQNKTR = 'bqnktr'
  CHARACTER(LEN=*), PARAMETER :: TAOBQNKTL = 'bqnktl'
  CHARACTER(LEN=*), PARAMETER :: TAOBQPIP = 'bqpip'
  CHARACTER(LEN=*), PARAMETER :: TAOGPCG = 'gpcg'
  CHARACTER(LEN=*), PARAMETER :: TAONM = 'nm'
  CHARACTER(LEN=*), PARAMETER :: TAOPOUNDERS = 'pounders'
  CHARACTER(LEN=*), PARAMETER :: TAOBRGN = 'brgn'
  CHARACTER(LEN=*), PARAMETER :: TAOLCL = 'lcl'
  CHARACTER(LEN=*), PARAMETER :: TAOSSILS = 'ssils'
  CHARACTER(LEN=*), PARAMETER :: TAOSSFLS = 'ssfls'
  CHARACTER(LEN=*), PARAMETER :: TAOASILS = 'asils'
  CHARACTER(LEN=*), PARAMETER :: TAOASFLS = 'asfls'
  CHARACTER(LEN=*), PARAMETER :: TAOIPM = 'ipm'
  CHARACTER(LEN=*), PARAMETER :: TAOPDIPM = 'pdipm'
  CHARACTER(LEN=*), PARAMETER :: TAOSHELL = 'shell'
  CHARACTER(LEN=*), PARAMETER :: TAOADMM = 'admm'
  CHARACTER(LEN=*), PARAMETER :: TAOALMM = 'almm'
  CHARACTER(LEN=*), PARAMETER :: TAOPYTHON = 'python'
  CHARACTER(LEN=*), PARAMETER :: TAOSNES = 'snes'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::TAOLMVM
!DEC$ ATTRIBUTES DLLEXPORT::TAONLS
!DEC$ ATTRIBUTES DLLEXPORT::TAONTR
!DEC$ ATTRIBUTES DLLEXPORT::TAONTL
!DEC$ ATTRIBUTES DLLEXPORT::TAOCG
!DEC$ ATTRIBUTES DLLEXPORT::TAOTRON
!DEC$ ATTRIBUTES DLLEXPORT::TAOOWLQN
!DEC$ ATTRIBUTES DLLEXPORT::TAOBMRM
!DEC$ ATTRIBUTES DLLEXPORT::TAOBLMVM
!DEC$ ATTRIBUTES DLLEXPORT::TAOBQNLS
!DEC$ ATTRIBUTES DLLEXPORT::TAOBNCG
!DEC$ ATTRIBUTES DLLEXPORT::TAOBNLS
!DEC$ ATTRIBUTES DLLEXPORT::TAOBNTR
!DEC$ ATTRIBUTES DLLEXPORT::TAOBNTL
!DEC$ ATTRIBUTES DLLEXPORT::TAOBQNKLS
!DEC$ ATTRIBUTES DLLEXPORT::TAOBQNKTR
!DEC$ ATTRIBUTES DLLEXPORT::TAOBQNKTL
!DEC$ ATTRIBUTES DLLEXPORT::TAOBQPIP
!DEC$ ATTRIBUTES DLLEXPORT::TAOGPCG
!DEC$ ATTRIBUTES DLLEXPORT::TAONM
!DEC$ ATTRIBUTES DLLEXPORT::TAOPOUNDERS
!DEC$ ATTRIBUTES DLLEXPORT::TAOBRGN
!DEC$ ATTRIBUTES DLLEXPORT::TAOLCL
!DEC$ ATTRIBUTES DLLEXPORT::TAOSSILS
!DEC$ ATTRIBUTES DLLEXPORT::TAOSSFLS
!DEC$ ATTRIBUTES DLLEXPORT::TAOASILS
!DEC$ ATTRIBUTES DLLEXPORT::TAOASFLS
!DEC$ ATTRIBUTES DLLEXPORT::TAOIPM
!DEC$ ATTRIBUTES DLLEXPORT::TAOPDIPM
!DEC$ ATTRIBUTES DLLEXPORT::TAOSHELL
!DEC$ ATTRIBUTES DLLEXPORT::TAOADMM
!DEC$ ATTRIBUTES DLLEXPORT::TAOALMM
!DEC$ ATTRIBUTES DLLEXPORT::TAOPYTHON
!DEC$ ATTRIBUTES DLLEXPORT::TAOSNES
#endif

