#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatecomposite_ MATCREATECOMPOSITE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatecomposite_ matcreatecomposite
#endif
PETSC_EXTERN void matcreatecomposite_(MPI_Fint *a, PetscInt *b, const Mat *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatCreateComposite(MPI_Comm_f2c(*(a)), *b, c, d);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcompositeaddmat_ MATCOMPOSITEADDMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcompositeaddmat_ matcompositeaddmat
#endif
PETSC_EXTERN void matcompositeaddmat_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = MatCompositeAddMat(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcompositesettype_ MATCOMPOSITESETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcompositesettype_ matcompositesettype
#endif
PETSC_EXTERN void matcompositesettype_(Mat *a, MatCompositeType *b, PetscErrorCode *ierr)
{
  *ierr = MatCompositeSetType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcompositegettype_ MATCOMPOSITEGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcompositegettype_ matcompositegettype
#endif
PETSC_EXTERN void matcompositegettype_(Mat *a, MatCompositeType *b, PetscErrorCode *ierr)
{
  *ierr = MatCompositeGetType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcompositesetmatstructure_ MATCOMPOSITESETMATSTRUCTURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcompositesetmatstructure_ matcompositesetmatstructure
#endif
PETSC_EXTERN void matcompositesetmatstructure_(Mat *a, MatStructure *b, PetscErrorCode *ierr)
{
  *ierr = MatCompositeSetMatStructure(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcompositegetmatstructure_ MATCOMPOSITEGETMATSTRUCTURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcompositegetmatstructure_ matcompositegetmatstructure
#endif
PETSC_EXTERN void matcompositegetmatstructure_(Mat *a, MatStructure *b, PetscErrorCode *ierr)
{
  *ierr = MatCompositeGetMatStructure(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcompositesetmergetype_ MATCOMPOSITESETMERGETYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcompositesetmergetype_ matcompositesetmergetype
#endif
PETSC_EXTERN void matcompositesetmergetype_(Mat *a, MatCompositeMergeType *b, PetscErrorCode *ierr)
{
  *ierr = MatCompositeSetMergeType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcompositemerge_ MATCOMPOSITEMERGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcompositemerge_ matcompositemerge
#endif
PETSC_EXTERN void matcompositemerge_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatCompositeMerge(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcompositegetnumbermat_ MATCOMPOSITEGETNUMBERMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcompositegetnumbermat_ matcompositegetnumbermat
#endif
PETSC_EXTERN void matcompositegetnumbermat_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = MatCompositeGetNumberMat(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcompositegetmat_ MATCOMPOSITEGETMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcompositegetmat_ matcompositegetmat
#endif
PETSC_EXTERN void matcompositegetmat_(Mat *a, PetscInt *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatCompositeGetMat(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcompositesetscalings_ MATCOMPOSITESETSCALINGS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcompositesetscalings_ matcompositesetscalings
#endif
PETSC_EXTERN void matcompositesetscalings_(Mat *a, const PetscScalar *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = MatCompositeSetScalings(*a, b);
  if (*ierr) return;
}
