#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformregisterall_ DMPLEXTRANSFORMREGISTERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformregisterall_ dmplextransformregisterall
#endif
PETSC_EXTERN void dmplextransformregisterall_(PetscErrorCode *ierr)
{
  *ierr = DMPlexTransformRegisterAll();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformregisterdestroy_ DMPLEXTRANSFORMREGISTERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformregisterdestroy_ dmplextransformregisterdestroy
#endif
PETSC_EXTERN void dmplextransformregisterdestroy_(PetscErrorCode *ierr)
{
  *ierr = DMPlexTransformRegisterDestroy();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformcreate_ DMPLEXTRANSFORMCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformcreate_ dmplextransformcreate
#endif
PETSC_EXTERN void dmplextransformcreate_(MPI_Fint *a, DMPlexTransform *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexTransformCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformsettype_ DMPLEXTRANSFORMSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformsettype_ dmplextransformsettype
#endif
PETSC_EXTERN void dmplextransformsettype_(DMPlexTransform *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMPlexTransformSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformgettype_ DMPLEXTRANSFORMGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformgettype_ dmplextransformgettype
#endif
PETSC_EXTERN void dmplextransformgettype_(DMPlexTransform *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = DMPlexTransformGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformview_ DMPLEXTRANSFORMVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformview_ dmplextransformview
#endif
PETSC_EXTERN void dmplextransformview_(DMPlexTransform *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = DMPlexTransformView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformsetfromoptions_ DMPLEXTRANSFORMSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformsetfromoptions_ dmplextransformsetfromoptions
#endif
PETSC_EXTERN void dmplextransformsetfromoptions_(DMPlexTransform *a, PetscErrorCode *ierr)
{
  *ierr = DMPlexTransformSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformdestroy_ DMPLEXTRANSFORMDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformdestroy_ dmplextransformdestroy
#endif
PETSC_EXTERN void dmplextransformdestroy_(DMPlexTransform *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = DMPlexTransformDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformsetup_ DMPLEXTRANSFORMSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformsetup_ dmplextransformsetup
#endif
PETSC_EXTERN void dmplextransformsetup_(DMPlexTransform *a, PetscErrorCode *ierr)
{
  *ierr = DMPlexTransformSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformgetdm_ DMPLEXTRANSFORMGETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformgetdm_ dmplextransformgetdm
#endif
PETSC_EXTERN void dmplextransformgetdm_(DMPlexTransform *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexTransformGetDM(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformsetdm_ DMPLEXTRANSFORMSETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformsetdm_ dmplextransformsetdm
#endif
PETSC_EXTERN void dmplextransformsetdm_(DMPlexTransform *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexTransformSetDM(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformgetactive_ DMPLEXTRANSFORMGETACTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformgetactive_ dmplextransformgetactive
#endif
PETSC_EXTERN void dmplextransformgetactive_(DMPlexTransform *a, DMLabel *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexTransformGetActive(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformsetactive_ DMPLEXTRANSFORMSETACTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformsetactive_ dmplextransformsetactive
#endif
PETSC_EXTERN void dmplextransformsetactive_(DMPlexTransform *a, DMLabel *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexTransformSetActive(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformgettransformtypes_ DMPLEXTRANSFORMGETTRANSFORMTYPES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformgettransformtypes_ dmplextransformgettransformtypes
#endif
PETSC_EXTERN void dmplextransformgettransformtypes_(DMPlexTransform *a, DMLabel *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexTransformGetTransformTypes(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformsettransformtypes_ DMPLEXTRANSFORMSETTRANSFORMTYPES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformsettransformtypes_ dmplextransformsettransformtypes
#endif
PETSC_EXTERN void dmplextransformsettransformtypes_(DMPlexTransform *a, DMLabel *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexTransformSetTransformTypes(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformsetdimensions_ DMPLEXTRANSFORMSETDIMENSIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformsetdimensions_ dmplextransformsetdimensions
#endif
PETSC_EXTERN void dmplextransformsetdimensions_(DMPlexTransform *a, DM *b, DM *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexTransformSetDimensions(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformgetchart_ DMPLEXTRANSFORMGETCHART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformgetchart_ dmplextransformgetchart
#endif
PETSC_EXTERN void dmplextransformgetchart_(DMPlexTransform *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMPlexTransformGetChart(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformgetcelltype_ DMPLEXTRANSFORMGETCELLTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformgetcelltype_ dmplextransformgetcelltype
#endif
PETSC_EXTERN void dmplextransformgetcelltype_(DMPlexTransform *a, PetscInt *b, DMPolytopeType *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexTransformGetCellType(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformgetcelltypestratum_ DMPLEXTRANSFORMGETCELLTYPESTRATUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformgetcelltypestratum_ dmplextransformgetcelltypestratum
#endif
PETSC_EXTERN void dmplextransformgetcelltypestratum_(DMPlexTransform *a, DMPolytopeType *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMPlexTransformGetCellTypeStratum(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformgetdepth_ DMPLEXTRANSFORMGETDEPTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformgetdepth_ dmplextransformgetdepth
#endif
PETSC_EXTERN void dmplextransformgetdepth_(DMPlexTransform *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMPlexTransformGetDepth(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformgetdepthstratum_ DMPLEXTRANSFORMGETDEPTHSTRATUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformgetdepthstratum_ dmplextransformgetdepthstratum
#endif
PETSC_EXTERN void dmplextransformgetdepthstratum_(DMPlexTransform *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMPlexTransformGetDepthStratum(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformgetmatchstrata_ DMPLEXTRANSFORMGETMATCHSTRATA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformgetmatchstrata_ dmplextransformgetmatchstrata
#endif
PETSC_EXTERN void dmplextransformgetmatchstrata_(DMPlexTransform *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexTransformGetMatchStrata(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformsetmatchstrata_ DMPLEXTRANSFORMSETMATCHSTRATA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformsetmatchstrata_ dmplextransformsetmatchstrata
#endif
PETSC_EXTERN void dmplextransformsetmatchstrata_(DMPlexTransform *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexTransformSetMatchStrata(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformgettargetpoint_ DMPLEXTRANSFORMGETTARGETPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformgettargetpoint_ dmplextransformgettargetpoint
#endif
PETSC_EXTERN void dmplextransformgettargetpoint_(DMPlexTransform *a, DMPolytopeType *b, DMPolytopeType *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(f);
  *ierr = DMPlexTransformGetTargetPoint(*a, *b, *c, *d, *e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformgetsourcepoint_ DMPLEXTRANSFORMGETSOURCEPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformgetsourcepoint_ dmplextransformgetsourcepoint
#endif
PETSC_EXTERN void dmplextransformgetsourcepoint_(DMPlexTransform *a, PetscInt *b, DMPolytopeType *c, DMPolytopeType *d, PetscInt *e, PetscInt *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(f);
  *ierr = DMPlexTransformGetSourcePoint(*a, *b, c, d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformgetsubcellorientationidentity_ DMPLEXTRANSFORMGETSUBCELLORIENTATIONIDENTITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformgetsubcellorientationidentity_ dmplextransformgetsubcellorientationidentity
#endif
PETSC_EXTERN void dmplextransformgetsubcellorientationidentity_(DMPlexTransform *a, DMPolytopeType *b, PetscInt *c, PetscInt *d, DMPolytopeType *e, PetscInt *f, PetscInt *g, PetscInt *h, PetscInt *i, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(h);
  CHKFORTRANNULLINTEGER(i);
  *ierr = DMPlexTransformGetSubcellOrientationIdentity(*a, *b, *c, *d, *e, *f, *g, h, i);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformgetsubcellorientation_ DMPLEXTRANSFORMGETSUBCELLORIENTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformgetsubcellorientation_ dmplextransformgetsubcellorientation
#endif
PETSC_EXTERN void dmplextransformgetsubcellorientation_(DMPlexTransform *a, DMPolytopeType *b, PetscInt *c, PetscInt *d, DMPolytopeType *e, PetscInt *f, PetscInt *g, PetscInt *h, PetscInt *i, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(h);
  CHKFORTRANNULLINTEGER(i);
  *ierr = DMPlexTransformGetSubcellOrientation(*a, *b, *c, *d, *e, *f, *g, h, i);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformgetconesize_ DMPLEXTRANSFORMGETCONESIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformgetconesize_ dmplextransformgetconesize
#endif
PETSC_EXTERN void dmplextransformgetconesize_(DMPlexTransform *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMPlexTransformGetConeSize(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformmapcoordinates_ DMPLEXTRANSFORMMAPCOORDINATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformmapcoordinates_ dmplextransformmapcoordinates
#endif
PETSC_EXTERN void dmplextransformmapcoordinates_(DMPlexTransform *a, DMPolytopeType *b, DMPolytopeType *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscInt *g, const PetscScalar h[], PetscScalar i[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(h);
  CHKFORTRANNULLSCALAR(i);
  *ierr = DMPlexTransformMapCoordinates(*a, *b, *c, *d, *e, *f, *g, h, i);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformcreatedisclabels_ DMPLEXTRANSFORMCREATEDISCLABELS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformcreatedisclabels_ dmplextransformcreatedisclabels
#endif
PETSC_EXTERN void dmplextransformcreatedisclabels_(DMPlexTransform *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexTransformCreateDiscLabels(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformapply_ DMPLEXTRANSFORMAPPLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformapply_ dmplextransformapply
#endif
PETSC_EXTERN void dmplextransformapply_(DMPlexTransform *a, DM *b, DM *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexTransformApply(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextransformadaptlabel_ DMPLEXTRANSFORMADAPTLABEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextransformadaptlabel_ dmplextransformadaptlabel
#endif
PETSC_EXTERN void dmplextransformadaptlabel_(DM *a, Vec *b, DMLabel *c, DMLabel *d, DM *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMPlexTransformAdaptLabel(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
