#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdacreatepf_ DMDACREATEPF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdacreatepf_ dmdacreatepf
#endif
PETSC_EXTERN void dmdacreatepf_(DM *a, PF *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMDACreatePF(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
