#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetlmvmmatrix_ TAOGETLMVMMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetlmvmmatrix_ taogetlmvmmatrix
#endif
PETSC_EXTERN void taogetlmvmmatrix_(Tao *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TaoGetLMVMMatrix(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetlmvmmatrix_ TAOSETLMVMMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetlmvmmatrix_ taosetlmvmmatrix
#endif
PETSC_EXTERN void taosetlmvmmatrix_(Tao *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = TaoSetLMVMMatrix(*a, *b);
  if (*ierr) return;
}
