#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscgetversion_ PETSCGETVERSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscgetversion_ petscgetversion
#endif
PETSC_EXTERN void petscgetversion_(char a[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  *ierr = PetscGetVersion(a, l_a);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, a, l_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscgetversionnumber_ PETSCGETVERSIONNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscgetversionnumber_ petscgetversionnumber
#endif
PETSC_EXTERN void petscgetversionnumber_(PetscInt *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(a);
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscGetVersionNumber(a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscblassetnumthreads_ PETSCBLASSETNUMTHREADS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscblassetnumthreads_ petscblassetnumthreads
#endif
PETSC_EXTERN void petscblassetnumthreads_(PetscInt *a, PetscErrorCode *ierr)
{
  *ierr = PetscBLASSetNumThreads(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscblasgetnumthreads_ PETSCBLASGETNUMTHREADS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscblasgetnumthreads_ petscblasgetnumthreads
#endif
PETSC_EXTERN void petscblasgetnumthreads_(PetscInt *a, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(a);
  *ierr = PetscBLASGetNumThreads(a);
  if (*ierr) return;
}
