#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5getgroup_ PETSCVIEWERHDF5GETGROUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5getgroup_ petscviewerhdf5getgroup
#endif
PETSC_EXTERN void petscviewerhdf5getgroup_(PetscViewer *a, char b[], char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c = PETSC_NULLPTR;
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerHDF5GetGroup(v_a, c_b, (const char **)&c_c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5setbasedimension2_ PETSCVIEWERHDF5SETBASEDIMENSION2
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5setbasedimension2_ petscviewerhdf5setbasedimension2
#endif
PETSC_EXTERN void petscviewerhdf5setbasedimension2_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerHDF5SetBaseDimension2(v_a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5getbasedimension2_ PETSCVIEWERHDF5GETBASEDIMENSION2
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5getbasedimension2_ petscviewerhdf5getbasedimension2
#endif
PETSC_EXTERN void petscviewerhdf5getbasedimension2_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscViewerHDF5GetBaseDimension2(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5setspoutput_ PETSCVIEWERHDF5SETSPOUTPUT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5setspoutput_ petscviewerhdf5setspoutput
#endif
PETSC_EXTERN void petscviewerhdf5setspoutput_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerHDF5SetSPOutput(v_a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5getspoutput_ PETSCVIEWERHDF5GETSPOUTPUT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5getspoutput_ petscviewerhdf5getspoutput
#endif
PETSC_EXTERN void petscviewerhdf5getspoutput_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscViewerHDF5GetSPOutput(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5setcollective_ PETSCVIEWERHDF5SETCOLLECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5setcollective_ petscviewerhdf5setcollective
#endif
PETSC_EXTERN void petscviewerhdf5setcollective_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerHDF5SetCollective(v_a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5getcollective_ PETSCVIEWERHDF5GETCOLLECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5getcollective_ petscviewerhdf5getcollective
#endif
PETSC_EXTERN void petscviewerhdf5getcollective_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscViewerHDF5GetCollective(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5setdefaulttimestepping_ PETSCVIEWERHDF5SETDEFAULTTIMESTEPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5setdefaulttimestepping_ petscviewerhdf5setdefaulttimestepping
#endif
PETSC_EXTERN void petscviewerhdf5setdefaulttimestepping_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerHDF5SetDefaultTimestepping(v_a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5getdefaulttimestepping_ PETSCVIEWERHDF5GETDEFAULTTIMESTEPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5getdefaulttimestepping_ petscviewerhdf5getdefaulttimestepping
#endif
PETSC_EXTERN void petscviewerhdf5getdefaulttimestepping_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscViewerHDF5GetDefaultTimestepping(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5open_ PETSCVIEWERHDF5OPEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5open_ petscviewerhdf5open
#endif
PETSC_EXTERN void petscviewerhdf5open_(MPI_Fint *a, char b[], PetscFileMode *c, PetscViewer *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(d);
  *ierr = PetscViewerHDF5Open(MPI_Comm_f2c(*(a)), c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5pushgroup_ PETSCVIEWERHDF5PUSHGROUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5pushgroup_ petscviewerhdf5pushgroup
#endif
PETSC_EXTERN void petscviewerhdf5pushgroup_(PetscViewer *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerHDF5PushGroup(v_a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5popgroup_ PETSCVIEWERHDF5POPGROUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5popgroup_ petscviewerhdf5popgroup
#endif
PETSC_EXTERN void petscviewerhdf5popgroup_(PetscViewer *a, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerHDF5PopGroup(v_a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5writegroup_ PETSCVIEWERHDF5WRITEGROUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5writegroup_ petscviewerhdf5writegroup
#endif
PETSC_EXTERN void petscviewerhdf5writegroup_(PetscViewer *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerHDF5WriteGroup(v_a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5pushtimestepping_ PETSCVIEWERHDF5PUSHTIMESTEPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5pushtimestepping_ petscviewerhdf5pushtimestepping
#endif
PETSC_EXTERN void petscviewerhdf5pushtimestepping_(PetscViewer *a, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerHDF5PushTimestepping(v_a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5poptimestepping_ PETSCVIEWERHDF5POPTIMESTEPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5poptimestepping_ petscviewerhdf5poptimestepping
#endif
PETSC_EXTERN void petscviewerhdf5poptimestepping_(PetscViewer *a, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerHDF5PopTimestepping(v_a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5istimestepping_ PETSCVIEWERHDF5ISTIMESTEPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5istimestepping_ petscviewerhdf5istimestepping
#endif
PETSC_EXTERN void petscviewerhdf5istimestepping_(PetscViewer *a, PetscBool *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscViewerHDF5IsTimestepping(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5incrementtimestep_ PETSCVIEWERHDF5INCREMENTTIMESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5incrementtimestep_ petscviewerhdf5incrementtimestep
#endif
PETSC_EXTERN void petscviewerhdf5incrementtimestep_(PetscViewer *a, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerHDF5IncrementTimestep(v_a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5settimestep_ PETSCVIEWERHDF5SETTIMESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5settimestep_ petscviewerhdf5settimestep
#endif
PETSC_EXTERN void petscviewerhdf5settimestep_(PetscViewer *a, PetscInt *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerHDF5SetTimestep(v_a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5gettimestep_ PETSCVIEWERHDF5GETTIMESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5gettimestep_ petscviewerhdf5gettimestep
#endif
PETSC_EXTERN void petscviewerhdf5gettimestep_(PetscViewer *a, PetscInt *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscViewerHDF5GetTimestep(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5writeattribute_ PETSCVIEWERHDF5WRITEATTRIBUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5writeattribute_ petscviewerhdf5writeattribute
#endif
PETSC_EXTERN void petscviewerhdf5writeattribute_(PetscViewer *a, char b[], char c[], PetscDataType *d, const void *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerHDF5WriteAttribute(v_a, c_b, c_c, *d, e);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5writeobjectattribute_ PETSCVIEWERHDF5WRITEOBJECTATTRIBUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5writeobjectattribute_ petscviewerhdf5writeobjectattribute
#endif
PETSC_EXTERN void petscviewerhdf5writeobjectattribute_(PetscViewer *a, PetscObject *b, char c[], PetscDataType *d, const void *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerHDF5WriteObjectAttribute(v_a, *b, c_c, *d, e);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5readattribute_ PETSCVIEWERHDF5READATTRIBUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5readattribute_ petscviewerhdf5readattribute
#endif
PETSC_EXTERN void petscviewerhdf5readattribute_(PetscViewer *a, char b[], char c[], PetscDataType *d, const void *e, void *f, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerHDF5ReadAttribute(v_a, c_b, c_c, *d, e, f);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5readobjectattribute_ PETSCVIEWERHDF5READOBJECTATTRIBUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5readobjectattribute_ petscviewerhdf5readobjectattribute
#endif
PETSC_EXTERN void petscviewerhdf5readobjectattribute_(PetscViewer *a, PetscObject *b, char c[], PetscDataType *d, void *e, void *f, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerHDF5ReadObjectAttribute(v_a, *b, c_c, *d, e, f);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5hasgroup_ PETSCVIEWERHDF5HASGROUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5hasgroup_ petscviewerhdf5hasgroup
#endif
PETSC_EXTERN void petscviewerhdf5hasgroup_(PetscViewer *a, char b[], PetscBool *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscViewerHDF5HasGroup(v_a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5hasdataset_ PETSCVIEWERHDF5HASDATASET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5hasdataset_ petscviewerhdf5hasdataset
#endif
PETSC_EXTERN void petscviewerhdf5hasdataset_(PetscViewer *a, char b[], PetscBool *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscViewerHDF5HasDataset(v_a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5hasobject_ PETSCVIEWERHDF5HASOBJECT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5hasobject_ petscviewerhdf5hasobject
#endif
PETSC_EXTERN void petscviewerhdf5hasobject_(PetscViewer *a, PetscObject *b, PetscBool *c, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscViewerHDF5HasObject(v_a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5hasattribute_ PETSCVIEWERHDF5HASATTRIBUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5hasattribute_ petscviewerhdf5hasattribute
#endif
PETSC_EXTERN void petscviewerhdf5hasattribute_(PetscViewer *a, char b[], char c[], PetscBool *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLBOOL(d);
  *ierr = PetscViewerHDF5HasAttribute(v_a, c_b, c_c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewerhdf5.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerhdf5hasobjectattribute_ PETSCVIEWERHDF5HASOBJECTATTRIBUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerhdf5hasobjectattribute_ petscviewerhdf5hasobjectattribute
#endif
PETSC_EXTERN void petscviewerhdf5hasobjectattribute_(PetscViewer *a, PetscObject *b, char c[], PetscBool *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLBOOL(d);
  *ierr = PetscViewerHDF5HasObjectAttribute(v_a, *b, c_c, d);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
