#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcshellgetcontext_ PCSHELLGETCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcshellgetcontext_ pcshellgetcontext
#endif
PETSC_EXTERN void pcshellgetcontext_(PC *a, void *b, PetscErrorCode *ierr)
{
  *ierr = PCShellGetContext(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcshellsetcontext_ PCSHELLSETCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcshellsetcontext_ pcshellsetcontext
#endif
PETSC_EXTERN void pcshellsetcontext_(PC *a, void *b, PetscErrorCode *ierr)
{
  *ierr = PCShellSetContext(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcshellsetname_ PCSHELLSETNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcshellsetname_ pcshellsetname
#endif
PETSC_EXTERN void pcshellsetname_(PC *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PCShellSetName(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcshellgetname_ PCSHELLGETNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcshellgetname_ pcshellgetname
#endif
PETSC_EXTERN void pcshellgetname_(PC *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PCShellGetName(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
