#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelcreate_ DMLABELCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelcreate_ dmlabelcreate
#endif
PETSC_EXTERN void dmlabelcreate_(MPI_Fint *a, char b[], DMLabel *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(c);
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMLabelCreate(MPI_Comm_f2c(*(a)), c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelsetup_ DMLABELSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelsetup_ dmlabelsetup
#endif
PETSC_EXTERN void dmlabelsetup_(DMLabel *a, PetscErrorCode *ierr)
{
  *ierr = DMLabelSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabeladdstratum_ DMLABELADDSTRATUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabeladdstratum_ dmlabeladdstratum
#endif
PETSC_EXTERN void dmlabeladdstratum_(DMLabel *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMLabelAddStratum(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabeladdstrata_ DMLABELADDSTRATA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabeladdstrata_ dmlabeladdstrata
#endif
PETSC_EXTERN void dmlabeladdstrata_(DMLabel *a, PetscInt *b, const PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMLabelAddStrata(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabeladdstratais_ DMLABELADDSTRATAIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabeladdstratais_ dmlabeladdstratais
#endif
PETSC_EXTERN void dmlabeladdstratais_(DMLabel *a, IS *b, PetscErrorCode *ierr)
{
  *ierr = DMLabelAddStrataIS(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelview_ DMLABELVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelview_ dmlabelview
#endif
PETSC_EXTERN void dmlabelview_(DMLabel *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = DMLabelView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelreset_ DMLABELRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelreset_ dmlabelreset
#endif
PETSC_EXTERN void dmlabelreset_(DMLabel *a, PetscErrorCode *ierr)
{
  *ierr = DMLabelReset(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabeldestroy_ DMLABELDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabeldestroy_ dmlabeldestroy
#endif
PETSC_EXTERN void dmlabeldestroy_(DMLabel *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = DMLabelDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelduplicate_ DMLABELDUPLICATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelduplicate_ dmlabelduplicate
#endif
PETSC_EXTERN void dmlabelduplicate_(DMLabel *a, DMLabel *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMLabelDuplicate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelcomputeindex_ DMLABELCOMPUTEINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelcomputeindex_ dmlabelcomputeindex
#endif
PETSC_EXTERN void dmlabelcomputeindex_(DMLabel *a, PetscErrorCode *ierr)
{
  *ierr = DMLabelComputeIndex(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelcreateindex_ DMLABELCREATEINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelcreateindex_ dmlabelcreateindex
#endif
PETSC_EXTERN void dmlabelcreateindex_(DMLabel *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = DMLabelCreateIndex(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabeldestroyindex_ DMLABELDESTROYINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabeldestroyindex_ dmlabeldestroyindex
#endif
PETSC_EXTERN void dmlabeldestroyindex_(DMLabel *a, PetscErrorCode *ierr)
{
  *ierr = DMLabelDestroyIndex(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelgetbounds_ DMLABELGETBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelgetbounds_ dmlabelgetbounds
#endif
PETSC_EXTERN void dmlabelgetbounds_(DMLabel *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMLabelGetBounds(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelhasvalue_ DMLABELHASVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelhasvalue_ dmlabelhasvalue
#endif
PETSC_EXTERN void dmlabelhasvalue_(DMLabel *a, PetscInt *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = DMLabelHasValue(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelhaspoint_ DMLABELHASPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelhaspoint_ dmlabelhaspoint
#endif
PETSC_EXTERN void dmlabelhaspoint_(DMLabel *a, PetscInt *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = DMLabelHasPoint(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelstratumhaspoint_ DMLABELSTRATUMHASPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelstratumhaspoint_ dmlabelstratumhaspoint
#endif
PETSC_EXTERN void dmlabelstratumhaspoint_(DMLabel *a, PetscInt *b, PetscInt *c, PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(d);
  *ierr = DMLabelStratumHasPoint(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelgetdefaultvalue_ DMLABELGETDEFAULTVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelgetdefaultvalue_ dmlabelgetdefaultvalue
#endif
PETSC_EXTERN void dmlabelgetdefaultvalue_(DMLabel *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMLabelGetDefaultValue(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelsetdefaultvalue_ DMLABELSETDEFAULTVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelsetdefaultvalue_ dmlabelsetdefaultvalue
#endif
PETSC_EXTERN void dmlabelsetdefaultvalue_(DMLabel *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMLabelSetDefaultValue(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelgetvalue_ DMLABELGETVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelgetvalue_ dmlabelgetvalue
#endif
PETSC_EXTERN void dmlabelgetvalue_(DMLabel *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMLabelGetValue(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelsetvalue_ DMLABELSETVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelsetvalue_ dmlabelsetvalue
#endif
PETSC_EXTERN void dmlabelsetvalue_(DMLabel *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = DMLabelSetValue(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelclearvalue_ DMLABELCLEARVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelclearvalue_ dmlabelclearvalue
#endif
PETSC_EXTERN void dmlabelclearvalue_(DMLabel *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = DMLabelClearValue(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelinsertis_ DMLABELINSERTIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelinsertis_ dmlabelinsertis
#endif
PETSC_EXTERN void dmlabelinsertis_(DMLabel *a, IS *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = DMLabelInsertIS(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelgetnumvalues_ DMLABELGETNUMVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelgetnumvalues_ dmlabelgetnumvalues
#endif
PETSC_EXTERN void dmlabelgetnumvalues_(DMLabel *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMLabelGetNumValues(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelgetvalueis_ DMLABELGETVALUEIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelgetvalueis_ dmlabelgetvalueis
#endif
PETSC_EXTERN void dmlabelgetvalueis_(DMLabel *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMLabelGetValueIS(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelgetvaluebounds_ DMLABELGETVALUEBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelgetvaluebounds_ dmlabelgetvaluebounds
#endif
PETSC_EXTERN void dmlabelgetvaluebounds_(DMLabel *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMLabelGetValueBounds(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelgetnonemptystratumvaluesis_ DMLABELGETNONEMPTYSTRATUMVALUESIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelgetnonemptystratumvaluesis_ dmlabelgetnonemptystratumvaluesis
#endif
PETSC_EXTERN void dmlabelgetnonemptystratumvaluesis_(DMLabel *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMLabelGetNonEmptyStratumValuesIS(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelgetvalueindex_ DMLABELGETVALUEINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelgetvalueindex_ dmlabelgetvalueindex
#endif
PETSC_EXTERN void dmlabelgetvalueindex_(DMLabel *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMLabelGetValueIndex(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelhasstratum_ DMLABELHASSTRATUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelhasstratum_ dmlabelhasstratum
#endif
PETSC_EXTERN void dmlabelhasstratum_(DMLabel *a, PetscInt *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = DMLabelHasStratum(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelgetstratumsize_ DMLABELGETSTRATUMSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelgetstratumsize_ dmlabelgetstratumsize
#endif
PETSC_EXTERN void dmlabelgetstratumsize_(DMLabel *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMLabelGetStratumSize(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelgetstratumbounds_ DMLABELGETSTRATUMBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelgetstratumbounds_ dmlabelgetstratumbounds
#endif
PETSC_EXTERN void dmlabelgetstratumbounds_(DMLabel *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMLabelGetStratumBounds(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelgetstratumis_ DMLABELGETSTRATUMIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelgetstratumis_ dmlabelgetstratumis
#endif
PETSC_EXTERN void dmlabelgetstratumis_(DMLabel *a, PetscInt *b, IS *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMLabelGetStratumIS(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelsetstratumis_ DMLABELSETSTRATUMIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelsetstratumis_ dmlabelsetstratumis
#endif
PETSC_EXTERN void dmlabelsetstratumis_(DMLabel *a, PetscInt *b, IS *c, PetscErrorCode *ierr)
{
  *ierr = DMLabelSetStratumIS(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelclearstratum_ DMLABELCLEARSTRATUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelclearstratum_ dmlabelclearstratum
#endif
PETSC_EXTERN void dmlabelclearstratum_(DMLabel *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMLabelClearStratum(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelsetstratumbounds_ DMLABELSETSTRATUMBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelsetstratumbounds_ dmlabelsetstratumbounds
#endif
PETSC_EXTERN void dmlabelsetstratumbounds_(DMLabel *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = DMLabelSetStratumBounds(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelgetstratumpointindex_ DMLABELGETSTRATUMPOINTINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelgetstratumpointindex_ dmlabelgetstratumpointindex
#endif
PETSC_EXTERN void dmlabelgetstratumpointindex_(DMLabel *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMLabelGetStratumPointIndex(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelfilter_ DMLABELFILTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelfilter_ dmlabelfilter
#endif
PETSC_EXTERN void dmlabelfilter_(DMLabel *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = DMLabelFilter(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelpermute_ DMLABELPERMUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelpermute_ dmlabelpermute
#endif
PETSC_EXTERN void dmlabelpermute_(DMLabel *a, IS *b, DMLabel *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMLabelPermute(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelpermutevalues_ DMLABELPERMUTEVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelpermutevalues_ dmlabelpermutevalues
#endif
PETSC_EXTERN void dmlabelpermutevalues_(DMLabel *a, IS *b, PetscErrorCode *ierr)
{
  *ierr = DMLabelPermuteValues(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelrewritevalues_ DMLABELREWRITEVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelrewritevalues_ dmlabelrewritevalues
#endif
PETSC_EXTERN void dmlabelrewritevalues_(DMLabel *a, IS *b, PetscErrorCode *ierr)
{
  *ierr = DMLabelRewriteValues(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabeldistribute_ DMLABELDISTRIBUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabeldistribute_ dmlabeldistribute
#endif
PETSC_EXTERN void dmlabeldistribute_(DMLabel *a, PetscSF *b, DMLabel *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMLabelDistribute(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelgather_ DMLABELGATHER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelgather_ dmlabelgather
#endif
PETSC_EXTERN void dmlabelgather_(DMLabel *a, PetscSF *b, DMLabel *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMLabelGather(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelpropagatebegin_ DMLABELPROPAGATEBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelpropagatebegin_ dmlabelpropagatebegin
#endif
PETSC_EXTERN void dmlabelpropagatebegin_(DMLabel *a, PetscSF *b, PetscErrorCode *ierr)
{
  *ierr = DMLabelPropagateBegin(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelpropagateend_ DMLABELPROPAGATEEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelpropagateend_ dmlabelpropagateend
#endif
PETSC_EXTERN void dmlabelpropagateend_(DMLabel *a, PetscSF *b, PetscErrorCode *ierr)
{
  *ierr = DMLabelPropagateEnd(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelconverttosection_ DMLABELCONVERTTOSECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelconverttosection_ dmlabelconverttosection
#endif
PETSC_EXTERN void dmlabelconverttosection_(DMLabel *a, PetscSection *b, IS *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMLabelConvertToSection(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelregisterall_ DMLABELREGISTERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelregisterall_ dmlabelregisterall
#endif
PETSC_EXTERN void dmlabelregisterall_(PetscErrorCode *ierr)
{
  *ierr = DMLabelRegisterAll();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelregisterdestroy_ DMLABELREGISTERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelregisterdestroy_ dmlabelregisterdestroy
#endif
PETSC_EXTERN void dmlabelregisterdestroy_(PetscErrorCode *ierr)
{
  *ierr = DMLabelRegisterDestroy();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelsettype_ DMLABELSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelsettype_ dmlabelsettype
#endif
PETSC_EXTERN void dmlabelsettype_(DMLabel *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMLabelSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlabelgettype_ DMLABELGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlabelgettype_ dmlabelgettype
#endif
PETSC_EXTERN void dmlabelgettype_(DMLabel *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = DMLabelGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectioncreateglobalsectionlabel_ PETSCSECTIONCREATEGLOBALSECTIONLABEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectioncreateglobalsectionlabel_ petscsectioncreateglobalsectionlabel
#endif
PETSC_EXTERN void petscsectioncreateglobalsectionlabel_(PetscSection *a, PetscSF *b, PetscBool *c, DMLabel *d, PetscInt *e, PetscSection *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(f);
  *ierr = PetscSectionCreateGlobalSectionLabel(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, *d, *e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsymlabelsetlabel_ PETSCSECTIONSYMLABELSETLABEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsymlabelsetlabel_ petscsectionsymlabelsetlabel
#endif
PETSC_EXTERN void petscsectionsymlabelsetlabel_(PetscSectionSym *a, DMLabel *b, PetscErrorCode *ierr)
{
  *ierr = PetscSectionSymLabelSetLabel(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmlabel.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsectionsymcreatelabel_ PETSCSECTIONSYMCREATELABEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsectionsymcreatelabel_ petscsectionsymcreatelabel
#endif
PETSC_EXTERN void petscsectionsymcreatelabel_(MPI_Fint *a, DMLabel *b, PetscSectionSym *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscSectionSymCreateLabel(MPI_Comm_f2c(*(a)), *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
