#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecmaxpointwisedivide_ VECMAXPOINTWISEDIVIDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecmaxpointwisedivide_ vecmaxpointwisedivide
#endif
PETSC_EXTERN void vecmaxpointwisedivide_(Vec *a, Vec *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = VecMaxPointwiseDivide(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecdot_ VECDOT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecdot_ vecdot
#endif
PETSC_EXTERN void vecdot_(Vec *a, Vec *b, PetscScalar *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  *ierr = VecDot(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecdotrealpart_ VECDOTREALPART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecdotrealpart_ vecdotrealpart
#endif
PETSC_EXTERN void vecdotrealpart_(Vec *a, Vec *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = VecDotRealPart(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecnorm_ VECNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecnorm_ vecnorm
#endif
PETSC_EXTERN void vecnorm_(Vec *a, NormType *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = VecNorm(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecnormavailable_ VECNORMAVAILABLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecnormavailable_ vecnormavailable
#endif
PETSC_EXTERN void vecnormavailable_(Vec *a, NormType *b, PetscBool *c, PetscReal *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  CHKFORTRANNULLREAL(d);
  *ierr = VecNormAvailable(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecnormalize_ VECNORMALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecnormalize_ vecnormalize
#endif
PETSC_EXTERN void vecnormalize_(Vec *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = VecNormalize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecmax_ VECMAX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecmax_ vecmax
#endif
PETSC_EXTERN void vecmax_(Vec *a, PetscInt *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLREAL(c);
  *ierr = VecMax(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecmin_ VECMIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecmin_ vecmin
#endif
PETSC_EXTERN void vecmin_(Vec *a, PetscInt *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLREAL(c);
  *ierr = VecMin(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectdot_ VECTDOT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectdot_ vectdot
#endif
PETSC_EXTERN void vectdot_(Vec *a, Vec *b, PetscScalar *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  *ierr = VecTDot(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecaxpy_ VECAXPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecaxpy_ vecaxpy
#endif
PETSC_EXTERN void vecaxpy_(Vec *a, PetscScalar *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = VecAXPY(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecaypx_ VECAYPX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecaypx_ vecaypx
#endif
PETSC_EXTERN void vecaypx_(Vec *a, PetscScalar *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = VecAYPX(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecaxpby_ VECAXPBY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecaxpby_ vecaxpby
#endif
PETSC_EXTERN void vecaxpby_(Vec *a, PetscScalar *b, PetscScalar *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = VecAXPBY(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecaxpbypcz_ VECAXPBYPCZ
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecaxpbypcz_ vecaxpbypcz
#endif
PETSC_EXTERN void vecaxpbypcz_(Vec *a, PetscScalar *b, PetscScalar *c, PetscScalar *d, Vec *e, Vec *f, PetscErrorCode *ierr)
{
  *ierr = VecAXPBYPCZ(*a, *b, *c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecwaxpy_ VECWAXPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecwaxpy_ vecwaxpy
#endif
PETSC_EXTERN void vecwaxpy_(Vec *a, PetscScalar *b, Vec *c, Vec *d, PetscErrorCode *ierr)
{
  *ierr = VecWAXPY(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecgetvalues_ VECGETVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecgetvalues_ vecgetvalues
#endif
PETSC_EXTERN void vecgetvalues_(Vec *a, PetscInt *b, const PetscInt c[], PetscScalar d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLSCALAR(d);
  *ierr = VecGetValues(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecmtdot_ VECMTDOT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecmtdot_ vecmtdot
#endif
PETSC_EXTERN void vecmtdot_(Vec *a, PetscInt *b, const Vec c[], PetscScalar d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(d);
  *ierr = VecMTDot(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecmdot_ VECMDOT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecmdot_ vecmdot
#endif
PETSC_EXTERN void vecmdot_(Vec *a, PetscInt *b, const Vec c[], PetscScalar d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(d);
  *ierr = VecMDot(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecmaxpy_ VECMAXPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecmaxpy_ vecmaxpy
#endif
PETSC_EXTERN void vecmaxpy_(Vec *a, PetscInt *b, const PetscScalar c[], Vec d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  *ierr = VecMAXPY(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecmaxpby_ VECMAXPBY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecmaxpby_ vecmaxpby
#endif
PETSC_EXTERN void vecmaxpby_(Vec *a, PetscInt *b, const PetscScalar c[], PetscScalar *d, Vec e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  *ierr = VecMAXPBY(*a, *b, c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecgetsubvector_ VECGETSUBVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecgetsubvector_ vecgetsubvector
#endif
PETSC_EXTERN void vecgetsubvector_(Vec *a, IS *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = VecGetSubVector(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecrestoresubvector_ VECRESTORESUBVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecrestoresubvector_ vecrestoresubvector
#endif
PETSC_EXTERN void vecrestoresubvector_(Vec *a, IS *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = VecRestoreSubVector(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veccreatelocalvector_ VECCREATELOCALVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veccreatelocalvector_ veccreatelocalvector
#endif
PETSC_EXTERN void veccreatelocalvector_(Vec *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = VecCreateLocalVector(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecgetlocalvectorread_ VECGETLOCALVECTORREAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecgetlocalvectorread_ vecgetlocalvectorread
#endif
PETSC_EXTERN void vecgetlocalvectorread_(Vec *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = VecGetLocalVectorRead(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecrestorelocalvectorread_ VECRESTORELOCALVECTORREAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecrestorelocalvectorread_ vecrestorelocalvectorread
#endif
PETSC_EXTERN void vecrestorelocalvectorread_(Vec *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = VecRestoreLocalVectorRead(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecgetlocalvector_ VECGETLOCALVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecgetlocalvector_ vecgetlocalvector
#endif
PETSC_EXTERN void vecgetlocalvector_(Vec *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = VecGetLocalVector(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecrestorelocalvector_ VECRESTORELOCALVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecrestorelocalvector_ vecrestorelocalvector
#endif
PETSC_EXTERN void vecrestorelocalvector_(Vec *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = VecRestoreLocalVector(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecplacearray_ VECPLACEARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecplacearray_ vecplacearray
#endif
PETSC_EXTERN void vecplacearray_(Vec *a, const PetscScalar b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = VecPlaceArray(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecreplacearray_ VECREPLACEARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecreplacearray_ vecreplacearray
#endif
PETSC_EXTERN void vecreplacearray_(Vec *a, const PetscScalar b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = VecReplaceArray(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veclockget_ VECLOCKGET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veclockget_ veclockget
#endif
PETSC_EXTERN void veclockget_(Vec *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = VecLockGet(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veclockgetlocation_ VECLOCKGETLOCATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veclockgetlocation_ veclockgetlocation
#endif
PETSC_EXTERN void veclockgetlocation_(Vec *a, char b[], char c[], int *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b = PETSC_NULLPTR;
  char* c_c = PETSC_NULLPTR;
  *ierr = VecLockGetLocation(*a, (const char **)&c_b, (const char **)&c_c, d);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veclockreadpush_ VECLOCKREADPUSH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veclockreadpush_ veclockreadpush
#endif
PETSC_EXTERN void veclockreadpush_(Vec *a, PetscErrorCode *ierr)
{
  *ierr = VecLockReadPush(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veclockreadpop_ VECLOCKREADPOP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veclockreadpop_ veclockreadpop
#endif
PETSC_EXTERN void veclockreadpop_(Vec *a, PetscErrorCode *ierr)
{
  *ierr = VecLockReadPop(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veclockwriteset_ VECLOCKWRITESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veclockwriteset_ veclockwriteset
#endif
PETSC_EXTERN void veclockwriteset_(Vec *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = VecLockWriteSet(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecscale_ VECSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecscale_ vecscale
#endif
PETSC_EXTERN void vecscale_(Vec *a, PetscScalar *b, PetscErrorCode *ierr)
{
  *ierr = VecScale(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecset_ VECSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecset_ vecset
#endif
PETSC_EXTERN void vecset_(Vec *a, PetscScalar *b, PetscErrorCode *ierr)
{
  *ierr = VecSet(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetvalues_ VECSETVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetvalues_ vecsetvalues
#endif
PETSC_EXTERN void vecsetvalues_(Vec *a, PetscInt *b, const PetscInt c[], const PetscScalar d[], InsertMode *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLSCALAR(d);
  *ierr = VecSetValues(*a, *b, c, d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetvaluesblocked_ VECSETVALUESBLOCKED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetvaluesblocked_ vecsetvaluesblocked
#endif
PETSC_EXTERN void vecsetvaluesblocked_(Vec *a, PetscInt *b, const PetscInt c[], const PetscScalar d[], InsertMode *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLSCALAR(d);
  *ierr = VecSetValuesBlocked(*a, *b, c, d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetvalueslocal_ VECSETVALUESLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetvalueslocal_ vecsetvalueslocal
#endif
PETSC_EXTERN void vecsetvalueslocal_(Vec *a, PetscInt *b, const PetscInt c[], const PetscScalar d[], InsertMode *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLSCALAR(d);
  *ierr = VecSetValuesLocal(*a, *b, c, d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecsetvaluesblockedlocal_ VECSETVALUESBLOCKEDLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecsetvaluesblockedlocal_ vecsetvaluesblockedlocal
#endif
PETSC_EXTERN void vecsetvaluesblockedlocal_(Vec *a, PetscInt *b, const PetscInt c[], const PetscScalar d[], InsertMode *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLSCALAR(d);
  *ierr = VecSetValuesBlockedLocal(*a, *b, c, d, *e);
  if (*ierr) return;
}
