#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmkdir_ PETSCMKDIR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmkdir_ petscmkdir
#endif
PETSC_EXTERN void petscmkdir_(char a[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscMkdir(c_a);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmkdtemp_ PETSCMKDTEMP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmkdtemp_ petscmkdtemp
#endif
PETSC_EXTERN void petscmkdtemp_(char a[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  *ierr = PetscMkdtemp(a);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, a, l_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscrmtree_ PETSCRMTREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscrmtree_ petscrmtree
#endif
PETSC_EXTERN void petscrmtree_(char a[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscRMTree(c_a);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
