#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pccompositesettype_ PCCOMPOSITESETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pccompositesettype_ pccompositesettype
#endif
PETSC_EXTERN void pccompositesettype_(PC *a, PCCompositeType *b, PetscErrorCode *ierr)
{
  *ierr = PCCompositeSetType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pccompositegettype_ PCCOMPOSITEGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pccompositegettype_ pccompositegettype
#endif
PETSC_EXTERN void pccompositegettype_(PC *a, PCCompositeType *b, PetscErrorCode *ierr)
{
  *ierr = PCCompositeGetType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pccompositespecialsetalpha_ PCCOMPOSITESPECIALSETALPHA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pccompositespecialsetalpha_ pccompositespecialsetalpha
#endif
PETSC_EXTERN void pccompositespecialsetalpha_(PC *a, PetscScalar *b, PetscErrorCode *ierr)
{
  *ierr = PCCompositeSpecialSetAlpha(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pccompositespecialsetalphamat_ PCCOMPOSITESPECIALSETALPHAMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pccompositespecialsetalphamat_ pccompositespecialsetalphamat
#endif
PETSC_EXTERN void pccompositespecialsetalphamat_(PC *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = PCCompositeSpecialSetAlphaMat(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pccompositeaddpctype_ PCCOMPOSITEADDPCTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pccompositeaddpctype_ pccompositeaddpctype
#endif
PETSC_EXTERN void pccompositeaddpctype_(PC *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PCCompositeAddPCType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pccompositeaddpc_ PCCOMPOSITEADDPC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pccompositeaddpc_ pccompositeaddpc
#endif
PETSC_EXTERN void pccompositeaddpc_(PC *a, PC *b, PetscErrorCode *ierr)
{
  *ierr = PCCompositeAddPC(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pccompositegetnumberpc_ PCCOMPOSITEGETNUMBERPC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pccompositegetnumberpc_ pccompositegetnumberpc
#endif
PETSC_EXTERN void pccompositegetnumberpc_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PCCompositeGetNumberPC(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pccompositegetpc_ PCCOMPOSITEGETPC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pccompositegetpc_ pccompositegetpc
#endif
PETSC_EXTERN void pccompositegetpc_(PC *a, PetscInt *b, PC *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PCCompositeGetPC(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
