#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreateprocesssf_ DMPLEXCREATEPROCESSSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreateprocesssf_ dmplexcreateprocesssf
#endif
PETSC_EXTERN void dmplexcreateprocesssf_(DM *a, PetscSF *b, IS *c, PetscSF *d, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexCreateProcessSF(*a, *b, c, d);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatecoarsepointis_ DMPLEXCREATECOARSEPOINTIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatecoarsepointis_ dmplexcreatecoarsepointis
#endif
PETSC_EXTERN void dmplexcreatecoarsepointis_(DM *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexCreateCoarsePointIS(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsettransformtype_ DMPLEXSETTRANSFORMTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsettransformtype_ dmplexsettransformtype
#endif
PETSC_EXTERN void dmplexsettransformtype_(DM *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMPlexSetTransformType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplextransform.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgettransformtype_ DMPLEXGETTRANSFORMTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgettransformtype_ dmplexgettransformtype
#endif
PETSC_EXTERN void dmplexgettransformtype_(DM *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = DMPlexGetTransformType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetrefinementuniform_ DMPLEXSETREFINEMENTUNIFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetrefinementuniform_ dmplexsetrefinementuniform
#endif
PETSC_EXTERN void dmplexsetrefinementuniform_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetRefinementUniform(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetrefinementuniform_ DMPLEXGETREFINEMENTUNIFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetrefinementuniform_ dmplexgetrefinementuniform
#endif
PETSC_EXTERN void dmplexgetrefinementuniform_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexGetRefinementUniform(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetrefinementlimit_ DMPLEXSETREFINEMENTLIMIT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetrefinementlimit_ dmplexsetrefinementlimit
#endif
PETSC_EXTERN void dmplexsetrefinementlimit_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetRefinementLimit(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetrefinementlimit_ DMPLEXGETREFINEMENTLIMIT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetrefinementlimit_ dmplexgetrefinementlimit
#endif
PETSC_EXTERN void dmplexgetrefinementlimit_(DM *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = DMPlexGetRefinementLimit(*a, b);
  if (*ierr) return;
}
