#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetmigrationsf_ DMPLEXSETMIGRATIONSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetmigrationsf_ dmplexsetmigrationsf
#endif
PETSC_EXTERN void dmplexsetmigrationsf_(DM *a, PetscSF *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetMigrationSF(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetmigrationsf_ DMPLEXGETMIGRATIONSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetmigrationsf_ dmplexgetmigrationsf
#endif
PETSC_EXTERN void dmplexgetmigrationsf_(DM *a, PetscSF *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexGetMigrationSF(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreateglobaltonaturalsf_ DMPLEXCREATEGLOBALTONATURALSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreateglobaltonaturalsf_ dmplexcreateglobaltonaturalsf
#endif
PETSC_EXTERN void dmplexcreateglobaltonaturalsf_(DM *a, PetscSection *b, PetscSF *c, PetscSF *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexCreateGlobalToNaturalSF(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmigrateglobaltonaturalsf_ DMPLEXMIGRATEGLOBALTONATURALSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmigrateglobaltonaturalsf_ dmplexmigrateglobaltonaturalsf
#endif
PETSC_EXTERN void dmplexmigrateglobaltonaturalsf_(DM *a, DM *b, PetscSF *c, PetscSF *d, PetscSF *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMPlexMigrateGlobalToNaturalSF(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexglobaltonaturalbegin_ DMPLEXGLOBALTONATURALBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexglobaltonaturalbegin_ dmplexglobaltonaturalbegin
#endif
PETSC_EXTERN void dmplexglobaltonaturalbegin_(DM *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexGlobalToNaturalBegin(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexglobaltonaturalend_ DMPLEXGLOBALTONATURALEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexglobaltonaturalend_ dmplexglobaltonaturalend
#endif
PETSC_EXTERN void dmplexglobaltonaturalend_(DM *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexGlobalToNaturalEnd(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexnaturaltoglobalbegin_ DMPLEXNATURALTOGLOBALBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexnaturaltoglobalbegin_ dmplexnaturaltoglobalbegin
#endif
PETSC_EXTERN void dmplexnaturaltoglobalbegin_(DM *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexNaturalToGlobalBegin(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexnaturaltoglobalend_ DMPLEXNATURALTOGLOBALEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexnaturaltoglobalend_ dmplexnaturaltoglobalend
#endif
PETSC_EXTERN void dmplexnaturaltoglobalend_(DM *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexNaturalToGlobalEnd(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatenaturalvector_ DMPLEXCREATENATURALVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatenaturalvector_ dmplexcreatenaturalvector
#endif
PETSC_EXTERN void dmplexcreatenaturalvector_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexCreateNaturalVector(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
