#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscspacepointsetpoints_ PETSCSPACEPOINTSETPOINTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscspacepointsetpoints_ petscspacepointsetpoints
#endif
PETSC_EXTERN void petscspacepointsetpoints_(PetscSpace *a, PetscQuadrature *b, PetscErrorCode *ierr)
{
  *ierr = PetscSpacePointSetPoints(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscspacepointgetpoints_ PETSCSPACEPOINTGETPOINTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscspacepointgetpoints_ petscspacepointgetpoints
#endif
PETSC_EXTERN void petscspacepointgetpoints_(PetscSpace *a, PetscQuadrature *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscSpacePointGetPoints(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
