#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectaggercdfsetmethod_ VECTAGGERCDFSETMETHOD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectaggercdfsetmethod_ vectaggercdfsetmethod
#endif
PETSC_EXTERN void vectaggercdfsetmethod_(VecTagger *a, VecTaggerCDFMethod *b, PetscErrorCode *ierr)
{
  *ierr = VecTaggerCDFSetMethod(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectaggercdfgetmethod_ VECTAGGERCDFGETMETHOD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectaggercdfgetmethod_ vectaggercdfgetmethod
#endif
PETSC_EXTERN void vectaggercdfgetmethod_(VecTagger *a, VecTaggerCDFMethod *b, PetscErrorCode *ierr)
{
  *ierr = VecTaggerCDFGetMethod(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectaggercdfiterativesettolerances_ VECTAGGERCDFITERATIVESETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectaggercdfiterativesettolerances_ vectaggercdfiterativesettolerances
#endif
PETSC_EXTERN void vectaggercdfiterativesettolerances_(VecTagger *a, PetscInt *b, PetscReal *c, PetscReal *d, PetscErrorCode *ierr)
{
  *ierr = VecTaggerCDFIterativeSetTolerances(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectaggercdfiterativegettolerances_ VECTAGGERCDFITERATIVEGETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectaggercdfiterativegettolerances_ vectaggercdfiterativegettolerances
#endif
PETSC_EXTERN void vectaggercdfiterativegettolerances_(VecTagger *a, PetscInt *b, PetscReal *c, PetscReal *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  *ierr = VecTaggerCDFIterativeGetTolerances(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vectaggercdfsetbox_ VECTAGGERCDFSETBOX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vectaggercdfsetbox_ vectaggercdfsetbox
#endif
PETSC_EXTERN void vectaggercdfsetbox_(VecTagger *a, VecTaggerBox b[], PetscErrorCode *ierr)
{
  *ierr = VecTaggerCDFSetBox(*a, b);
  if (*ierr) return;
}
