#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionspushcreatevieweroff_ PETSCOPTIONSPUSHCREATEVIEWEROFF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionspushcreatevieweroff_ petscoptionspushcreatevieweroff
#endif
PETSC_EXTERN void petscoptionspushcreatevieweroff_(PetscBool *a, PetscErrorCode *ierr)
{
  *ierr = PetscOptionsPushCreateViewerOff(*a ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionspopcreatevieweroff_ PETSCOPTIONSPOPCREATEVIEWEROFF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionspopcreatevieweroff_ petscoptionspopcreatevieweroff
#endif
PETSC_EXTERN void petscoptionspopcreatevieweroff_(PetscErrorCode *ierr)
{
  *ierr = PetscOptionsPopCreateViewerOff();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsgetcreatevieweroff_ PETSCOPTIONSGETCREATEVIEWEROFF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsgetcreatevieweroff_ petscoptionsgetcreatevieweroff
#endif
PETSC_EXTERN void petscoptionsgetcreatevieweroff_(PetscBool *a, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(a);
  *ierr = PetscOptionsGetCreateViewerOff(a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionscreateviewer_ PETSCOPTIONSCREATEVIEWER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionscreateviewer_ petscoptionscreateviewer
#endif
PETSC_EXTERN void petscoptionscreateviewer_(MPI_Fint *a, PetscOptions *b, char c[], char d[], PetscViewer *e, PetscViewerFormat *f, PetscBool *g, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c, PETSC_FORTRAN_CHARLEN_T l_d)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  char* c_d;
  FIXCHAR(d, l_d, c_d);
  CHKFORTRANNULLOBJECT(e);
  CHKFORTRANNULLBOOL(g);
  *ierr = PetscOptionsCreateViewer(MPI_Comm_f2c(*(a)), *b, c_c, c_d, e, f, g);
  if (*ierr) return;
  FREECHAR(c, c_c);
  FREECHAR(d, c_d);
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionscreateviewers_ PETSCOPTIONSCREATEVIEWERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionscreateviewers_ petscoptionscreateviewers
#endif
PETSC_EXTERN void petscoptionscreateviewers_(MPI_Fint *a, PetscOptions *b, char c[], char d[], PetscInt *e, PetscViewer f[], PetscViewerFormat g[], PetscBool *h, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c, PETSC_FORTRAN_CHARLEN_T l_d)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  char* c_d;
  FIXCHAR(d, l_d, c_d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLBOOL(h);
  *ierr = PetscOptionsCreateViewers(MPI_Comm_f2c(*(a)), *b, c_c, c_d, e, f, g, h);
  if (*ierr) return;
  FREECHAR(c, c_c);
  FREECHAR(d, c_d);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionshelpprinteddestroy_ PETSCOPTIONSHELPPRINTEDDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionshelpprinteddestroy_ petscoptionshelpprinteddestroy
#endif
PETSC_EXTERN void petscoptionshelpprinteddestroy_(PetscOptionsHelpPrinted *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscOptionsHelpPrintedDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionshelpprintedcreate_ PETSCOPTIONSHELPPRINTEDCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionshelpprintedcreate_ petscoptionshelpprintedcreate
#endif
PETSC_EXTERN void petscoptionshelpprintedcreate_(PetscOptionsHelpPrinted *a, PetscErrorCode *ierr)
{
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(a);
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscOptionsHelpPrintedCreate(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionshelpprintedcheck_ PETSCOPTIONSHELPPRINTEDCHECK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionshelpprintedcheck_ petscoptionshelpprintedcheck
#endif
PETSC_EXTERN void petscoptionshelpprintedcheck_(PetscOptionsHelpPrinted *a, char b[], char c[], PetscBool *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLBOOL(d);
  *ierr = PetscOptionsHelpPrintedCheck(*a, c_b, c_c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewersettype_ PETSCVIEWERSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewersettype_ petscviewersettype
#endif
PETSC_EXTERN void petscviewersettype_(PetscViewer *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerSetType(v_a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewersetfromoptions_ PETSCVIEWERSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewersetfromoptions_ petscviewersetfromoptions
#endif
PETSC_EXTERN void petscviewersetfromoptions_(PetscViewer *a, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerSetFromOptions(v_a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewercreate_ PETSCVIEWERCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewercreate_ petscviewercreate
#endif
PETSC_EXTERN void petscviewercreate_(MPI_Fint *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscViewerCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerflowcontrolstart_ PETSCVIEWERFLOWCONTROLSTART
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerflowcontrolstart_ petscviewerflowcontrolstart
#endif
PETSC_EXTERN void petscviewerflowcontrolstart_(PetscViewer *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscViewerFlowControlStart(v_a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerflowcontrolstepmain_ PETSCVIEWERFLOWCONTROLSTEPMAIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerflowcontrolstepmain_ petscviewerflowcontrolstepmain
#endif
PETSC_EXTERN void petscviewerflowcontrolstepmain_(PetscViewer *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscViewerFlowControlStepMain(v_a, *b, c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerflowcontrolendmain_ PETSCVIEWERFLOWCONTROLENDMAIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerflowcontrolendmain_ petscviewerflowcontrolendmain
#endif
PETSC_EXTERN void petscviewerflowcontrolendmain_(PetscViewer *a, PetscInt *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscViewerFlowControlEndMain(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerflowcontrolstepworker_ PETSCVIEWERFLOWCONTROLSTEPWORKER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerflowcontrolstepworker_ petscviewerflowcontrolstepworker
#endif
PETSC_EXTERN void petscviewerflowcontrolstepworker_(PetscViewer *a, PetscMPIInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscViewerFlowControlStepWorker(v_a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerflowcontrolendworker_ PETSCVIEWERFLOWCONTROLENDWORKER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerflowcontrolendworker_ petscviewerflowcontrolendworker
#endif
PETSC_EXTERN void petscviewerflowcontrolendworker_(PetscViewer *a, PetscInt *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscViewerFlowControlEndWorker(v_a, b);
  if (*ierr) return;
}
