# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Stochastic process."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _model_process
else:
    import _model_process

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _model_process.delete_SwigPyIterator

    def value(self):
        return _model_process.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _model_process.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _model_process.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _model_process.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _model_process.SwigPyIterator_equal(self, x)

    def copy(self):
        return _model_process.SwigPyIterator_copy(self)

    def next(self):
        return _model_process.SwigPyIterator_next(self)

    def __next__(self):
        return _model_process.SwigPyIterator___next__(self)

    def previous(self):
        return _model_process.SwigPyIterator_previous(self)

    def advance(self, n):
        return _model_process.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _model_process.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _model_process.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _model_process.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _model_process.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _model_process.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _model_process.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _model_process:
_model_process.SwigPyIterator_swigregister(SwigPyIterator)
import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.dist_bundle1
import openturns.model_copula
import openturns.dist_bundle2
import openturns.dist_bundle3
import openturns.randomvector
import openturns.weightedexperiment
class WhiteNoise(openturns.randomvector.ProcessImplementation):
    r"""
    White Noise process.

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution` 
        Distribution of dimension :math:`d` of the white noise process.

    mesh : :class:`~openturns.Mesh`, optional
        Mesh in :math:`\Rset^n` over which the process is discretized. 
        By default, the mesh is reduced to one point in :math:`\Rset` which coordinate is equal to 0.


    Notes
    -----
    A second order white noise :math:`\varepsilon: \Omega \times \cD \rightarrow \Rset^d`  is a stochastic process of dimension :math:`d` such that the covariance function :math:`C(\vect{s},\vect{t})=\delta(\vect{t}-\vect{s})C(\vect{s},\vect{s})` where :math:`C(\vect{s},\vect{s})`  is the covariance matrix of the process at vertex :math:`\vect{s}` and :math:`\delta` the Kroenecker function.

    A process :math:`\varepsilon` is a white noise if  all finite family of locations  :math:`(\vect{t}_i)_{i=1, \dots, n} \in \cD`, :math:`(\varepsilon_{\vect{t}_i})_{i=1, \dots, n}` is independent and identically distributed.


    Examples
    --------
    Create a normal normal white noise of dimension 1:

    >>> import openturns as ot
    >>> myDist = ot.Normal()
    >>> myMesh = ot.IntervalMesher([10]*2).build(ot.Interval([0.0]*2, [1.0]*2))
    >>> myWN = ot.WhiteNoise(myDist, myMesh)

    Get a realization:

    >>> myReal =myWN.getRealization()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.WhiteNoise_getClassName(self)

    def __repr__(self):
        return _model_process.WhiteNoise___repr__(self)

    def __str__(self, *args):
        return _model_process.WhiteNoise___str__(self, *args)

    def isStationary(self):
        r"""
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\forall k \in \Nset`,
        :math:`\forall (\vect{t}_1, \dots, \vect{t}_k) \in \cD`,
        :math:`\forall \vect{h}\in \Rset^n`, we have:

        .. math::

            (X_{\vect{t}_1}, \dots, X_{\vect{t}_k})
            \stackrel{\mathcal{D}}{=} (X_{\vect{t}_1+\vect{h}}, \dots, X_{\vect{t}_k+\vect{h}})

        """
        return _model_process.WhiteNoise_isStationary(self)

    def isNormal(self):
        r"""
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \in \Nset` and
        :math:`I_k \in \Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\vect{m}_1, \dots, \vect{m}_k \in \Rset^d` and
        :math:`\mat{C}_{1,\dots,k}\in\mathcal{M}_{kd,kd}(\Rset)` such that:

        .. math::

            \Expect{\exp\left\{i\Tr{\vect{X}}_{I_k} \vect{U}_{k}  \right\}} =
            \exp{\left\{i\Tr{\vect{U}}_{k}\vect{M}_{k}-\frac{1}{2}\Tr{\vect{U}}_{k}\mat{C}_{1,\dots,k}\vect{U}_{k}\right\}}

        where :math:`\Tr{\vect{X}}_{I_k} = (\Tr{X}_{\vect{t}_1}, \hdots, \Tr{X}_{\vect{t}_k})`,
        :math:`\\Tr{vect{U}}_{k} = (\Tr{\vect{u}}_{1}, \hdots, \Tr{\vect{u}}_{k})` and
        :math:`\Tr{\vect{M}}_{k} = (\Tr{\vect{m}}_{1}, \hdots, \Tr{\vect{m}}_{k})` and
        :math:`\mat{C}_{1,\dots,k}` is the symmetric matrix:

        .. math::

          \mat{C}_{1,\dots,k} = \left(
          \begin{array}{cccc}
            C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \hdots & C(\vect{t}_1, \vect{t}_{k}) \\
            \hdots & C(\vect{t}_2, \vect{t}_2)  & \hdots & C(\vect{t}_2, \vect{t}_{k}) \\
            \hdots & \hdots & \hdots & \hdots \\
            \hdots & \hdots & \hdots & C(\vect{t}_{k}, \vect{t}_{k})
          \end{array}
          \right)

        A Gaussian process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _model_process.WhiteNoise_isNormal(self)

    def getRealization(self):
        r"""
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _model_process.WhiteNoise_getRealization(self)

    def getContinuousRealization(self):
        r"""
        Get a continuous realization.

        Returns
        -------
        realization : :class:`~openturns.Function`
            According to the process, the continuous realizations are built:

            - either using a dedicated functional model if it exists: e.g. a functional
              basis process.

            - or using an interpolation from a discrete realization of the process on
              :math:`\cM`: in dimension :math:`d=1`, a linear interpolation and in
              dimension :math:`d \geq 2`, a piecewise constant function (the value at a
              given position is equal to the value at the nearest vertex of the mesh of
              the process).
        """
        return _model_process.WhiteNoise_getContinuousRealization(self)

    def getFuture(self, *args):
        r"""
        Prediction of the :math:`N` future iterations of the process.

        Parameters
        ----------
        stepNumber : int, :math:`N \geq 0`
            Number of future steps.
        size : int, :math:`size \geq 0`, optional
            Number of futures needed. Default is 1.

        Returns
        -------
        prediction : :class:`~openturns.ProcessSample` or :class:`~openturns.TimeSeries`
            :math:`N` future iterations of the process.
            If :math:`size = 1`, *prediction* is a :class:`~openturns.TimeSeries`.
            Otherwise, it is a :class:`~openturns.ProcessSample`.
        """
        return _model_process.WhiteNoise_getFuture(self, *args)

    def getMarginal(self, indices):
        r"""
        Accessor to the marginal process.

        Parameters
        ----------
        N : int
            The  index of the marginal to be extracted.

        indices : :class:`~openturns.Indices`, optional
            The list of the indexes of the marginal to be extracted.

        Returns
        -------
        wn : :class:`~openturns.WhiteNoise` 
            The marginal white noise.
        """
        return _model_process.WhiteNoise_getMarginal(self, indices)

    def getDistribution(self):
        r"""
        Accessor to the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution` 
            The distribution of dimension :math:`d` of the white noise.
        """
        return _model_process.WhiteNoise_getDistribution(self)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution` 
            The distribution of dimension :math:`d` of the white noise.
        """
        return _model_process.WhiteNoise_setDistribution(self, distribution)

    def __init__(self, *args):
        _model_process.WhiteNoise_swiginit(self, _model_process.new_WhiteNoise(*args))
    __swig_destroy__ = _model_process.delete_WhiteNoise

# Register WhiteNoise in _model_process:
_model_process.WhiteNoise_swigregister(WhiteNoise)
class RandomWalk(openturns.randomvector.ProcessImplementation):
    r"""
    Random walk process.

    Parameters
    ----------
    origin : :class:`~openturns.Point` 
        Origin of the random walk.

    distribution : :class:`~openturns.Distribution` 
        Distribution of dimension equal to the dimension of `origin`.

    timeGrid : :class:`~openturns.RegularGrid`, optional
        The time grid of the process.
        By default, the time grid is  reduced to one time stamp equal to 0.


    Notes
    -----
    A random walk is a process :math:`X: \Omega \times \cD \rightarrow \Rset^d` where :math:`\cD=\Rset` discretized on the time grid :math:`(t_i)_{i \geq 0}` such that:

    .. math::

        \forall n>0,\: X_{t_n}  =  X_{t_{n-1}} + \varepsilon_{t_n}

    where :math:`\vect{x}_0 \in \Rset^d` and :math:`\varepsilon` is a  white noise of dimension :math:`d`.


    Examples
    --------
    Create a random walk:

    >>> import openturns as ot
    >>> myTimeGrid = ot.RegularGrid(0, 0.1, 10)
    >>> myDist = ot.JointDistribution([ot.Normal(), ot.Exponential(0.2)], ot.ClaytonCopula(0.5))
    >>> myOrigin = myDist.getMean()
    >>> myRandomWalk = ot.RandomWalk(myOrigin, myDist, myTimeGrid)

    Get a realization:

    >>> myReal = myRandomWalk.getRealization()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.RandomWalk_getClassName(self)

    def __repr__(self):
        return _model_process.RandomWalk___repr__(self)

    def __str__(self, *args):
        return _model_process.RandomWalk___str__(self, *args)

    def isStationary(self):
        r"""
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\forall k \in \Nset`,
        :math:`\forall (\vect{t}_1, \dots, \vect{t}_k) \in \cD`,
        :math:`\forall \vect{h}\in \Rset^n`, we have:

        .. math::

            (X_{\vect{t}_1}, \dots, X_{\vect{t}_k})
            \stackrel{\mathcal{D}}{=} (X_{\vect{t}_1+\vect{h}}, \dots, X_{\vect{t}_k+\vect{h}})

        """
        return _model_process.RandomWalk_isStationary(self)

    def isNormal(self):
        r"""
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \in \Nset` and
        :math:`I_k \in \Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\vect{m}_1, \dots, \vect{m}_k \in \Rset^d` and
        :math:`\mat{C}_{1,\dots,k}\in\mathcal{M}_{kd,kd}(\Rset)` such that:

        .. math::

            \Expect{\exp\left\{i\Tr{\vect{X}}_{I_k} \vect{U}_{k}  \right\}} =
            \exp{\left\{i\Tr{\vect{U}}_{k}\vect{M}_{k}-\frac{1}{2}\Tr{\vect{U}}_{k}\mat{C}_{1,\dots,k}\vect{U}_{k}\right\}}

        where :math:`\Tr{\vect{X}}_{I_k} = (\Tr{X}_{\vect{t}_1}, \hdots, \Tr{X}_{\vect{t}_k})`,
        :math:`\\Tr{vect{U}}_{k} = (\Tr{\vect{u}}_{1}, \hdots, \Tr{\vect{u}}_{k})` and
        :math:`\Tr{\vect{M}}_{k} = (\Tr{\vect{m}}_{1}, \hdots, \Tr{\vect{m}}_{k})` and
        :math:`\mat{C}_{1,\dots,k}` is the symmetric matrix:

        .. math::

          \mat{C}_{1,\dots,k} = \left(
          \begin{array}{cccc}
            C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \hdots & C(\vect{t}_1, \vect{t}_{k}) \\
            \hdots & C(\vect{t}_2, \vect{t}_2)  & \hdots & C(\vect{t}_2, \vect{t}_{k}) \\
            \hdots & \hdots & \hdots & \hdots \\
            \hdots & \hdots & \hdots & C(\vect{t}_{k}, \vect{t}_{k})
          \end{array}
          \right)

        A Gaussian process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _model_process.RandomWalk_isNormal(self)

    def getRealization(self):
        r"""
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _model_process.RandomWalk_getRealization(self)

    def getFuture(self, *args):
        r"""
        Prediction of the :math:`N` future iterations of the process.

        Parameters
        ----------
        stepNumber : int, :math:`N \geq 0`
            Number of future steps.
        size : int, :math:`size \geq 0`, optional
            Number of futures needed. Default is 1.

        Returns
        -------
        prediction : :class:`~openturns.ProcessSample` or :class:`~openturns.TimeSeries`
            :math:`N` future iterations of the process.
            If :math:`size = 1`, *prediction* is a :class:`~openturns.TimeSeries`.
            Otherwise, it is a :class:`~openturns.ProcessSample`.
        """
        return _model_process.RandomWalk_getFuture(self, *args)

    def getMarginal(self, indices):
        r"""
        Get the :math:`k^{th}` marginal of the random process.

        Parameters
        ----------
        k : int or list of ints :math:`0 \leq k < d`
            Index of the marginal(s) needed.

        Returns
        -------
        marginals : :class:`~openturns.Process`
            Process defined with marginal(s) of the random process.
        """
        return _model_process.RandomWalk_getMarginal(self, indices)

    def getDistribution(self):
        r"""
        Accessor to the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution` 
            The distribution of dimension :math:`d` of the white noise.
        """
        return _model_process.RandomWalk_getDistribution(self)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution` 
            The distribution of dimension :math:`d` of the white noise.
        """
        return _model_process.RandomWalk_setDistribution(self, distribution)

    def getOrigin(self):
        r"""
        Accessor to the origin.

        Returns
        -------
        origin : :class:`~openturns.Point` 
            The origin of the random walk.
        """
        return _model_process.RandomWalk_getOrigin(self)

    def setOrigin(self, origin):
        r"""
        Accessor to the origin.

        Parameters
        ----------
        origin : :class:`~openturns.Point` 
            The origin of the random walk.
        """
        return _model_process.RandomWalk_setOrigin(self, origin)

    def setMesh(self, mesh):
        r"""
        Set the mesh.

        Parameters
        ----------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\cD` is discretized.
        """
        return _model_process.RandomWalk_setMesh(self, mesh)

    def __init__(self, *args):
        _model_process.RandomWalk_swiginit(self, _model_process.new_RandomWalk(*args))
    __swig_destroy__ = _model_process.delete_RandomWalk

# Register RandomWalk in _model_process:
_model_process.RandomWalk_swigregister(RandomWalk)
class DiscreteMarkovChain(openturns.randomvector.ProcessImplementation):
    r"""
    Discrete Markov chain process.

    Parameters
    ----------
    origin : :class:`~openturns.Distribution` or :math:`int`, optional
        Probability distribution of the Markov chain origin, i.e. state of the process at :math:`t_0`.
        By default, the origin is set to a Dirac distribution of value 0.0.

    transitionMatrix : :class:`~openturns.SquareMatrix`, optional
        Transition matrix of the process. The matrix must be square, of dimension equal
        to the number of possible states of the process.
        By default, the transition matrix of the process is set to the 1x1 matrix [1].

    timeGrid : :class:`~openturns.TimeSeries`, optional
        The time grid of the process.
        By default, the time grid is  reduced to one time stamp equal to 0.


    Notes
    -----
    A discrete Markov chain is a process :math:`X: \Omega \times \cD \rightarrow E`, where :math:`\cD=\Rset` discretized on the time grid :math:`(t_i)_{i \geq 0}`, and :math:`E = [\![ 0,...,p-1]\!]` is the space of states, such that:

    .. math::

        \forall n>0,\: \Prob ( X_{t_n} \> | \> X_{t_0},...X_{t_{n-1}} )  =  \Prob ( X_{t_n} \> | \> X_{t_{n-1}} )

    The transition matrix of the process :math:`\cM = (m_{i,j})` can be defined such that:

    .. math::

         \forall t_n \in \cD, \forall i,j \in [\![ 0,...,p-1]\!], m_{i+1 , j+1} = \Prob (X_{t_{n+1}} = j \> | \> X_{t_{n}} = i)

    The transition matrix :math:`\cM` of the process is square, and its dimension :math:`p` is equal to the number of states of the process. Besides, :math:`\cM` is a stochastic matrix, i.e.:

    .. math::

        \forall i,j \leq p , \: m_{i,j} \geq 0

        \forall i \leq p, \: \sum_{j=1}^{p}{m_{i,j}} = 1

    The origin of the process must be provided either as a deterministic value :math:`x_0 \in [\![ 0,...,p-1]\!]`, or as a probability distribution. In this case, the distribution of :math:`X_0` must be 1D, and its support must be a part of :math:`[\![ 0,...,p-1]\!]`.


    Examples
    --------
    Create a Markov chain:

    >>> import openturns as ot
    >>> timeGrid = ot.RegularGrid(0, 0.1, 10)
    >>> transitionMatrix = ot.SquareMatrix([[0.9,0.05,0.05],[0.7,0.0,0.3],[0.8,0.0,0.2]])
    >>> origin = 0
    >>> myMarkovChain = ot.DiscreteMarkovChain(origin, transitionMatrix, timeGrid)

    Get a realization:

    >>> myReal = myMarkovChain.getRealization()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.DiscreteMarkovChain_getClassName(self)

    def __repr__(self):
        return _model_process.DiscreteMarkovChain___repr__(self)

    def __str__(self, *args):
        return _model_process.DiscreteMarkovChain___str__(self, *args)

    def getRealization(self):
        r"""
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _model_process.DiscreteMarkovChain_getRealization(self)

    def getFuture(self, *args):
        r"""
        Prediction of the :math:`N` future iterations of the process.

        Parameters
        ----------
        stepNumber : int, :math:`N \geq 0`
            Number of future steps.
        size : int, :math:`size \geq 0`, optional
            Number of futures needed. Default is 1.

        Returns
        -------
        prediction : :class:`~openturns.ProcessSample` or :class:`~openturns.TimeSeries`
            :math:`N` future iterations of the process.
            If :math:`size = 1`, *prediction* is a :class:`~openturns.TimeSeries`.
            Otherwise, it is a :class:`~openturns.ProcessSample`.
        """
        return _model_process.DiscreteMarkovChain_getFuture(self, *args)

    def getTransitionMatrix(self):
        r"""
        Accessor to the transition matrix.

        Returns
        -------
        matrix : :class:`~openturns.SquareMatrix` 
            The transition matrix of the process, of dimension :math:`n`.
        """
        return _model_process.DiscreteMarkovChain_getTransitionMatrix(self)

    def setTransitionMatrix(self, transitionMatrix):
        r"""
        Accessor to the transition matrix.

        Parameters
        ----------
        matrix : :class:`~openturns.SquareMatrix` 
            The transition matrix of the process, of dimension :math:`n`.
        """
        return _model_process.DiscreteMarkovChain_setTransitionMatrix(self, transitionMatrix)

    def getOrigin(self):
        r"""
        Accessor to the origin.

        Returns
        -------
        origin : :class:`~openturns.Distribution` 
            The probability distribution of the origin of the Markov chain.
        """
        return _model_process.DiscreteMarkovChain_getOrigin(self)

    def setOrigin(self, *args):
        r"""
        Accessor to the origin.

        Parameters
        ----------
        origin : :class:`~openturns.Distribution` or :math:`int`
            The probability distribution of the origin of the Markov chain.
        """
        return _model_process.DiscreteMarkovChain_setOrigin(self, *args)

    def setMesh(self, mesh):
        r"""
        Set the mesh.

        Parameters
        ----------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\cD` is discretized.
        """
        return _model_process.DiscreteMarkovChain_setMesh(self, mesh)

    def computeStationaryDistribution(self):
        r"""
        Compute the stationary distribution of the Markov chain.

        Returns
        -------
        distribution : :class:`~openturns.UserDefined`
            The stationary probability distribution of the Markov chain:
            its probability table is the left eigenvector of the
            transition matrix associated to the eigenvalue :math:`1`.

        Examples
        --------
        Compute the stationary distribution of a Markov chain:

        >>> import openturns as ot
        >>> timeGrid = ot.RegularGrid(0, 0.1, 10)
        >>> transitionMatrix = ot.SquareMatrix([[0.9,0.05,0.05],[0.7,0.0,0.3],[0.8,0.0,0.2]])
        >>> origin = 0
        >>> myMarkovChain = ot.DiscreteMarkovChain(origin, transitionMatrix, timeGrid)
        >>> distribution = myMarkovChain.computeStationaryDistribution()
        >>> print(distribution)
        UserDefined({x = [0], p = 0.883978}, {x = [1], p = 0.0441989}, {x = [2], p = 0.0718232})
        """
        return _model_process.DiscreteMarkovChain_computeStationaryDistribution(self)

    def exportToDOTFile(self, filename):
        r"""
        Export to DOT graph.

        `DOT <https://en.wikipedia.org/wiki/DOT_(graph_description_language)>`_ is a graph description language.

        Parameters
        ----------
        filename : str
            The name of the file to be written.

        Notes
        -----
        The graph can be customized using the following :class:`~openturns.ResourceMap` string entries:

        - *DiscreteMarkovChain-DOTArcColor*
        - *DiscreteMarkovChain-DOTLayout*
        - *DiscreteMarkovChain-DOTNodeColor*
        - *DiscreteMarkovChain-DOTNodeShape*
        """
        return _model_process.DiscreteMarkovChain_exportToDOTFile(self, filename)

    def __init__(self, *args):
        _model_process.DiscreteMarkovChain_swiginit(self, _model_process.new_DiscreteMarkovChain(*args))
    __swig_destroy__ = _model_process.delete_DiscreteMarkovChain

# Register DiscreteMarkovChain in _model_process:
_model_process.DiscreteMarkovChain_swigregister(DiscreteMarkovChain)
class SquareMatrixCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _model_process.delete_SquareMatrixCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _model_process.SquareMatrixCollection_clear(self)

    def __len__(self):
        return _model_process.SquareMatrixCollection___len__(self)

    def __eq__(self, rhs):
        return _model_process.SquareMatrixCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _model_process.SquareMatrixCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _model_process.SquareMatrixCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _model_process.SquareMatrixCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _model_process.SquareMatrixCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _model_process.SquareMatrixCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _model_process.SquareMatrixCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _model_process.SquareMatrixCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _model_process.SquareMatrixCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _model_process.SquareMatrixCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _model_process.SquareMatrixCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _model_process.SquareMatrixCollection_find(self, val)

    def __repr__(self):
        return _model_process.SquareMatrixCollection___repr__(self)

    def __str__(self, *args):
        return _model_process.SquareMatrixCollection___str__(self, *args)

    def __init__(self, *args):
        _model_process.SquareMatrixCollection_swiginit(self, _model_process.new_SquareMatrixCollection(*args))

# Register SquareMatrixCollection in _model_process:
_model_process.SquareMatrixCollection_swigregister(SquareMatrixCollection)
class _SquareMatrixPersistentCollection(openturns.common.PersistentObject, SquareMatrixCollection):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process._SquareMatrixPersistentCollection_getClassName(self)

    def __init__(self, *args):
        _model_process._SquareMatrixPersistentCollection_swiginit(self, _model_process.new__SquareMatrixPersistentCollection(*args))

    def __repr__(self):
        return _model_process._SquareMatrixPersistentCollection___repr__(self)

    def __str__(self, *args):
        return _model_process._SquareMatrixPersistentCollection___str__(self, *args)
    __swig_destroy__ = _model_process.delete__SquareMatrixPersistentCollection

# Register _SquareMatrixPersistentCollection in _model_process:
_model_process._SquareMatrixPersistentCollection_swigregister(_SquareMatrixPersistentCollection)
class ARMACoefficients(_SquareMatrixPersistentCollection):
    r"""
    Coefficients of an ARMA process (MA or AR part).

    Available constructors:
        ARMACoefficients(*size, dimension*)

        ARMACoefficients(*coeffList*)

        ARMACoefficients(*matrixColl*)


    Parameters
    ----------
    size : int, 
        The number of elements in the list.
    dimension : int, 
        The dimension of each element in the list.
    coeffList : a list of floats,
        In dimension 1, the list of the coefficients defining the recurrence of the ARMA process (MA or AR part).
    matrixColl : a list of :class:`~openturns.SquareMatrix`
        In dimension :math:`d`, the collection of square matrices in :math:`\Rset^d \times \Rset^d` defining the recurrence of the ARMA process (MA or AR part).

    Notes
    -----

    - In the first constructor:

    The elements are the null elements (scalar in dimension 1 and the null matrix in upper dimension).

    - In the other constructor:

    The elements are specified in the constructor.

    Examples
    --------
    Create the coefficients defining the recurrence of an ARMA process:

    >>> import openturns as ot
    >>> myARCoef = ot.ARMACoefficients([0.4, 0.3, 0.2, 0.1])
    >>> myMACoef = ot.ARMACoefficients([0.4, 0.3])
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.ARMACoefficients_getClassName(self)

    def __repr__(self):
        return _model_process.ARMACoefficients___repr__(self)

    def __str__(self, *args):
        return _model_process.ARMACoefficients___str__(self, *args)

    def getDimension(self):
        r"""
        Accessor to the dimension of coefficients in the list.

        Returns
        -------
        dimension : int
            The dimension of elements in the list.
        """
        return _model_process.ARMACoefficients_getDimension(self)

    def add(self, *args):
        r"""
        Add a new element in the list.

        Available usages:
            add(*coeff*)

            add(*squareMat*)

        Parameters
        ----------
        coeff : float
            A new scalar coefficient added to the list composed with scalars.
        squareMat : :class:`~openturns.SquareMatrix`
            A new element in the list composed with square matrices.

        Returns
        -------
        - In the first usage:

        A new list of elements composed with scalars.

        - In the second usage:

        A new list of elements composed with square matrices.


        """
        return _model_process.ARMACoefficients_add(self, *args)

    def __init__(self, *args):
        _model_process.ARMACoefficients_swiginit(self, _model_process.new_ARMACoefficients(*args))
    __swig_destroy__ = _model_process.delete_ARMACoefficients

# Register ARMACoefficients in _model_process:
_model_process.ARMACoefficients_swigregister(ARMACoefficients)
class ARMAState(openturns.common.PersistentObject):
    r"""
    Last state recorded of an ARMA process.

    Parameters
    ----------
    values : :class:`~openturns.Sample`
        Last :math:`p` values of the :math:`ARMA(p,q)` process of dimension :math:`d`. 
    noises : :class:`~openturns.Sample`
        Last :math:`q` values of the white noise defining the :math:`ARMA(p,q)` process of dimension :math:`d`.

    Examples
    --------
    Define a state of an :math:`ARMA(4,2)` process of dimension 1:

    >>> import openturns as ot
    >>> myLastValues = ot.Sample([[0.6], [0.7], [0.3], [0.2]])
    >>> myLastNoiseValues = ot.Sample([[1.2], [1.8]])
    >>> myARMAState = ot.ARMAState(myLastValues, myLastNoiseValues)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.ARMAState_getClassName(self)

    def __repr__(self):
        return _model_process.ARMAState___repr__(self)

    def __str__(self, *args):
        return _model_process.ARMAState___str__(self, *args)

    def getX(self):
        r"""
        Accessor to the last values of the ARMA process.

        Returns
        -------
        values : :class:`~openturns.Sample` of size :math:`p` and dimension :math:`d`
            Last :math:`p` values of the :math:`ARMA(p,q)` process of dimension :math:`d`.

        """
        return _model_process.ARMAState_getX(self)

    def setXEpsilon(self, x, epsilon):
        r"""
        Accessor to the last values of the noise defining the ARMA process.

        Parameters
        ----------
        values : :class:`~openturns.Sample` of size :math:`p` and dimension :math:`d`
            Last :math:`p` values of the :math:`ARMA(p,q)` process of dimension :math:`d`.
        noises : :class:`~openturns.Sample` of size :math:`q` and dimension :math:`d`
            Last :math:`q` values of the white noise of the :math:`ARMA(p,q)` process of dimension :math:`d`. 

        """
        return _model_process.ARMAState_setXEpsilon(self, x, epsilon)

    def getEpsilon(self):
        r"""
        Accessor to the last values of the noise defining the ARMA process.

        Returns
        -------
        noises : :class:`~openturns.Sample` of size :math:`q` and dimension :math:`d`
            Last :math:`q` values of the white noise of the :math:`ARMA(p,q)` process of dimension :math:`d`. 

        """
        return _model_process.ARMAState_getEpsilon(self)

    def getDimension(self):
        r"""
        Accessor to the dimension of coefficients in the list.

        Returns
        -------
        dimension : int
            The dimension :math:`d` of the ARMA process.
        """
        return _model_process.ARMAState_getDimension(self)

    def __init__(self, *args):
        _model_process.ARMAState_swiginit(self, _model_process.new_ARMAState(*args))
    __swig_destroy__ = _model_process.delete_ARMAState

# Register ARMAState in _model_process:
_model_process.ARMAState_swigregister(ARMAState)
class ARMA(openturns.randomvector.ProcessImplementation):
    r"""
    ARMA process.

    Refer to :ref:`arma_process`.

    Parameters
    ----------
    ARCoeff : :class:`~openturns.ARMACoefficients`
        The coefficients of the AR part of the recurrence : :math:`(a_1, \hdots, a_p)` in dimension 1 and :math:`(\mat{A}_{\, 1}, \hdots, \mat{A}{\, _p})` in dimension :math:`d`.

        Default is: :math:`0` in dimension 1 and the associated time grid is :math:`\{0,1\}`.
    MACoeff :  :class:`~openturns.ARMACoefficients`
        The coefficients of the MA part of the recurrence : :math:`(b_1, \hdots, b_q)` in dimension 1 and :math:`(\mat{B}_{\, 1}, \hdots, \mat{B}{\, _p})` in dimension :math:`d`.

        Default is: :math:`0` in dimension 1 and the associated time grid is :math:`\{0,1\}`.
    whiteNoise : :class:`~openturns.WhiteNoise`
        The white noise distribution of the recurrent relation.

        Default is: the Normal distribution with zero mean and unit variance in dimension 1.
    ARMAstate : :class:`~openturns.ARMAState`, optional
        The state of the ARMA process which will be extended to the next time stamps.
        The state is composed with :math:`p` values of the process and :math:`q` values of the white noise.
        This constructor is needed to get possible futures from the current state.


    Notes
    -----
    An ARMA process in dimension :math:`d` is defined by the linear recurrence :

    .. math::

        \vect{X}_t + \mat{A}_{\, 1}   \,  \vect{X}_{t-1} + \hdots +  \mat{A}_{\, p} \,   \vect{X}_{t-p} = \vect{\varepsilon}_{t}+  \mat{B}_ {\, 1} \,   \vect{\varepsilon}_{t-1}+   \hdots + \mat{B}_{\, q}  \,  \vect{\varepsilon}_{t-q}

    where :math:`\mat{A}_{\, i} \in  \Rset^d \times \Rset^d` and :math:`\mat{B}_{\, j} \in  \Rset^d \times \Rset^d`.

    In dimension 1, an ARMA process is defined by:

    .. math::

        X_t +a_1  X_{t-1} + \hdots +  a_p X_{t-p} = \varepsilon_{t}+  b_1 \varepsilon_{t-1}+   \hdots +b_q \varepsilon_{t-q}


    where :math:`(a_i,b_i) \in \Rset`.

    Examples
    --------
    Create an ARMA(4,2) process:

    >>> import openturns as ot
    >>> myTimeGrid = ot.RegularGrid(0.0, 0.1, 10)
    >>> myWhiteNoise = ot.WhiteNoise(ot.Triangular(-1.0, 0.0, 1.0), myTimeGrid)
    >>> myARCoef = ot.ARMACoefficients([0.4, 0.3, 0.2, 0.1])
    >>> myMACoef = ot.ARMACoefficients([0.4, 0.3])
    >>> myARMAProcess = ot.ARMA(myARCoef, myMACoef, myWhiteNoise)

    >>> myLastValues = ot.Sample([[0.6], [0.7], [0.3], [0.2]])
    >>> myLastNoiseValues = ot.Sample([[1.2], [1.8]])
    >>> myARMAState = ot.ARMAState(myLastValues, myLastNoiseValues)
    >>> myARMAProcessWithState = ot.ARMA(myARCoef, myMACoef, myWhiteNoise, myARMAState)

    Generate a realization:

    >>> myTimeSeries = myARMAProcess.getContinuousRealization()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.ARMA_getClassName(self)

    def __repr__(self):
        return _model_process.ARMA___repr__(self)

    def __str__(self, *args):
        return _model_process.ARMA___str__(self, *args)

    def isStationary(self):
        r"""
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\forall k \in \Nset`,
        :math:`\forall (\vect{t}_1, \dots, \vect{t}_k) \in \cD`,
        :math:`\forall \vect{h}\in \Rset^n`, we have:

        .. math::

            (X_{\vect{t}_1}, \dots, X_{\vect{t}_k})
            \stackrel{\mathcal{D}}{=} (X_{\vect{t}_1+\vect{h}}, \dots, X_{\vect{t}_k+\vect{h}})

        """
        return _model_process.ARMA_isStationary(self)

    def isNormal(self):
        r"""
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \in \Nset` and
        :math:`I_k \in \Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\vect{m}_1, \dots, \vect{m}_k \in \Rset^d` and
        :math:`\mat{C}_{1,\dots,k}\in\mathcal{M}_{kd,kd}(\Rset)` such that:

        .. math::

            \Expect{\exp\left\{i\Tr{\vect{X}}_{I_k} \vect{U}_{k}  \right\}} =
            \exp{\left\{i\Tr{\vect{U}}_{k}\vect{M}_{k}-\frac{1}{2}\Tr{\vect{U}}_{k}\mat{C}_{1,\dots,k}\vect{U}_{k}\right\}}

        where :math:`\Tr{\vect{X}}_{I_k} = (\Tr{X}_{\vect{t}_1}, \hdots, \Tr{X}_{\vect{t}_k})`,
        :math:`\\Tr{vect{U}}_{k} = (\Tr{\vect{u}}_{1}, \hdots, \Tr{\vect{u}}_{k})` and
        :math:`\Tr{\vect{M}}_{k} = (\Tr{\vect{m}}_{1}, \hdots, \Tr{\vect{m}}_{k})` and
        :math:`\mat{C}_{1,\dots,k}` is the symmetric matrix:

        .. math::

          \mat{C}_{1,\dots,k} = \left(
          \begin{array}{cccc}
            C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \hdots & C(\vect{t}_1, \vect{t}_{k}) \\
            \hdots & C(\vect{t}_2, \vect{t}_2)  & \hdots & C(\vect{t}_2, \vect{t}_{k}) \\
            \hdots & \hdots & \hdots & \hdots \\
            \hdots & \hdots & \hdots & C(\vect{t}_{k}, \vect{t}_{k})
          \end{array}
          \right)

        A Gaussian process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _model_process.ARMA_isNormal(self)

    def getRealization(self):
        r"""
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _model_process.ARMA_getRealization(self)

    def getFuture(self, *args):
        r"""
        Get possible futures from the current state of the ARMA process.

        Parameters
        ----------
        Nit : int, :math:`N_{it} \geq 1`
            The number of time stamps of the future.

        Nreal : int, :math:`N_{real} \geq 1`
            The number of possible futures that are generated. 

            Default is: :math:`N_{real} = 1`.

        Notes
        -----

        - If :math:`N_{real} = 1`:

        A :class:`~openturns.TimeSeries`
            One possible future of the ARMA process, from the current state over the next :math:`N_{it}` time stamps.


        - If :math:`N_{real} > 1`:

        A :class:`~openturns.ProcessSample`
            :math:`N_{real}`  possible futures of the ARMA process, from the current state over the next :math:`N_{it}` time stamps.

        Note that the time grid of each future begins at the last time stamp of the time grid associated to the time series which is extended.
        """
        return _model_process.ARMA_getFuture(self, *args)

    def getARCoefficients(self):
        r"""
        Accessor to the AR coefficients of the ARMA process.

        Returns
        -------
        ARCoeff : :class:`~openturns.ARMACoefficients`
            The AR coefficients of the linear recurrence defining the process.
        """
        return _model_process.ARMA_getARCoefficients(self)

    def getMACoefficients(self):
        r"""
        Accessor to the MA coefficients of the ARMA process.

        Returns
        -------
        MACoeff : :class:`~openturns.ARMACoefficients`
            The MA coefficients of the linear recurrence defining the process.
        """
        return _model_process.ARMA_getMACoefficients(self)

    def getState(self):
        r"""
        Accessor to the stored state of the ARMA process.

        Returns
        -------
        ARMAstate : :class:`~openturns.ARMAState`
            The state of the ARMA process which will be extended to the next time stamps. The state  is composed with :math:`p` values of the process and :math:`q` values of the white noise.
        """
        return _model_process.ARMA_getState(self)

    def setState(self, state):
        r"""
        Accessor to the stored state of the ARMA process.

        Parameters
        ----------
        ARMAstate : :class:`~openturns.ARMAState`
            The state of the ARMA process which will be extended to the next time stamps. The state  is composed with :math:`p` values of the process and :math:`q` values of the white noise.
        """
        return _model_process.ARMA_setState(self, state)

    def getWhiteNoise(self):
        r"""
        Accessor to the white noise defining the ARMA process.

        Returns
        -------
        whiteNoise : :class:`~openturns.WhiteNoise`
            The white noise :math:`\varepsilon` used in the linear recurrence of the ARMA process.
        """
        return _model_process.ARMA_getWhiteNoise(self)

    def setWhiteNoise(self, whiteNoise):
        r"""
        Accessor to the white noise defining the ARMA process.

        Parameters
        ----------
        whiteNoise : :class:`~openturns.WhiteNoise`
            The white noise :math:`\varepsilon` used in the linear recurrence of the ARMA process.
        """
        return _model_process.ARMA_setWhiteNoise(self, whiteNoise)

    def computeNThermalization(self, epsilon):
        r"""
        Accessor to the stored state of the ARMA process.

        Parameters
        ----------
        eps : float, :math:`\epsilon > 0`


        Returns
        -------
        Nther : int, :math:`N_{ther} \geq 1`
            The number of iterations of the ARMA process before being stationary and independent of its initial state.

        Notes
        -----
        The thermalization number :math:`N_{ther}` is defined as follows:

        .. math::

            N_{ther} > E\left[ \displaystyle \frac{\ln \epsilon}{\ln \max_{i,j} |r_{ij}|}\right]

        where :math:`E[]` is the integer part of a float and the :math:`(r_i)_i` are the roots of the polynomials (given here in dimension 1) :

        .. math::

           \Phi(\vect{r}) = \vect{r}^p + \sum_{i=1}^p a_i\vect{r}^{p-i}


        """
        return _model_process.ARMA_computeNThermalization(self, epsilon)

    def getNThermalization(self):
        r"""
        Accessor to the number of time stamps used to thermalize the process.

        Returns
        -------
        Nther : int, :math:`N_{ther} \geq 1`
            The number of time stamps used to make the ARMA realization be independent from its actual state.

            Default precision is: :math:`\varepsilon = 2^{-53} \equiv 10^{-16}`.
        """
        return _model_process.ARMA_getNThermalization(self)

    def setNThermalization(self, n):
        r"""
        Accessor to the number of time stamps used to thermalize the process.

        Parameters
        ----------
        Nther : int, :math:`N_{ther} \geq 1`
            The number of time stamps used to make the ARMA realization independent from its actual state.
        """
        return _model_process.ARMA_setNThermalization(self, n)

    def getMarginal(self, *args):
        r"""
        Get the :math:`k^{th}` marginal of the random process.

        Parameters
        ----------
        k : int or list of ints :math:`0 \leq k < d`
            Index of the marginal(s) needed.

        Returns
        -------
        marginals : :class:`~openturns.Process`
            Process defined with marginal(s) of the random process.
        """
        return _model_process.ARMA_getMarginal(self, *args)

    def __init__(self, *args):
        _model_process.ARMA_swiginit(self, _model_process.new_ARMA(*args))
    __swig_destroy__ = _model_process.delete_ARMA

# Register ARMA in _model_process:
_model_process.ARMA_swigregister(ARMA)
class SpectralGaussianProcess(openturns.randomvector.ProcessImplementation):
    r"""
    Spectral Gaussian process.

    Available constructors:
        SpectralGaussianProcess(*spectralModel, timeGrid*)

        SpectralGaussianProcess(*spectralModel, maxFreq, N*)

    Parameters
    ----------

    timeGrid : :class:`~openturns.RegularGrid`
        The time grid associated to the process.
        The algorithm is only implemented when the mesh is a regular grid.
    spectralModel : :class:`~openturns.SpectralModel`
    maxFreq : float
        Equal to the maximal frequency minus :math:`\Delta f`.
    N : float
        The number of points in the frequency grid, which is equal to the number of
        time stamps of the time grid.

    Notes
    -----

    - In the first usage, we fix the time grid and the second order model (spectral
      density model) which implements the process. The frequency discretization is
      deduced from the time discretization by the formulas
      :math:`f_{max} = \frac{1}{\Delta t}, \quad \Delta f = \frac{1}{t_{max}}, N = \frac{f_{max}}{\Delta f}= \frac{t_{max}}{\Delta t}`

    - In the second usage, the process is fixed in the frequency domain. *fmax*
      value and *N* induce the time grid. Care: the maximal frequency used in the
      computation is not *fmax* but :math:`(1-1/N)fmax = fmax - \Delta f`.

    - In the third usage, the spectral model is given and the other arguments are
      the same as the first usage.

    - In the fourth usage, the spectral model is given and the other arguments are
      the same as the second usage.

    The first call of :meth:`getRealization` might be time consuming because it
    computes :math:`N` hermitian matrices of size :math:`d \times \ d`, where
    :math:`d` is the dimension of the spectral model. These matrices are factorized
    and stored in order to be used for each call of the *getRealization* method.

    Examples
    --------
    Create a *SpectralGaussianProcess* from a spectral model and a time grid:

    >>> import openturns as ot
    >>> amplitude = [1.0, 2.0]
    >>> scale = [4.0, 5.0]
    >>> spatialCorrelation = ot.CorrelationMatrix(2)
    >>> spatialCorrelation[0,1] = 0.8
    >>> myTimeGrid =  ot.RegularGrid(0.0, 0.1, 20)
    >>> mySpectralModel = ot.CauchyModel(scale, amplitude, spatialCorrelation)
    >>> mySpectNormProc1 = ot.SpectralGaussianProcess(mySpectralModel, myTimeGrid)


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.SpectralGaussianProcess_getClassName(self)

    def __repr__(self):
        return _model_process.SpectralGaussianProcess___repr__(self)

    def __str__(self, *args):
        return _model_process.SpectralGaussianProcess___str__(self, *args)

    def getRealization(self):
        r"""
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _model_process.SpectralGaussianProcess_getRealization(self)

    def getFrequencyGrid(self):
        r"""
        Get the frequency grid used to discretize the spectral model.

        Returns
        -------
        freqGrid : :class:`~openturns.RegularGrid`
            The frequency grid used to discretize the spectral model.

        """
        return _model_process.SpectralGaussianProcess_getFrequencyGrid(self)

    def getMaximalFrequency(self):
        r"""
        Get the maximal frequency used in the computation.

        Returns
        -------
        freqMax : float
            The maximal frequency used in the computation: :math:`(1-1/N)fmax = fmax - \Delta f`.

        """
        return _model_process.SpectralGaussianProcess_getMaximalFrequency(self)

    def getNFrequency(self):
        r"""
        Get the  number of points in the frequency grid.

        Returns
        -------
        freqGrid : :class:`~openturns.RegularGrid`
            The number :math:`N` of points in the frequency grid, which is equal to the
            number of time stamps of the time grid.

        """
        return _model_process.SpectralGaussianProcess_getNFrequency(self)

    def getFrequencyStep(self):
        r"""
        Get the frequency step :math:`\Delta f` used to discretize the spectral model.

        Returns
        -------
        freqStep : float
            The frequency step :math:`\Delta f` used to discretize the spectral model.

        """
        return _model_process.SpectralGaussianProcess_getFrequencyStep(self)

    def getSpectralModel(self):
        r"""
        Get the spectral model.

        Returns
        -------
        specMod : :class:`~openturns.SpectralModel`
            The spectral model defining the process.

        """
        return _model_process.SpectralGaussianProcess_getSpectralModel(self)

    def setTimeGrid(self, timeGrid):
        r"""
        Set the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of observation of the process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _model_process.SpectralGaussianProcess_setTimeGrid(self, timeGrid)

    def getFFTAlgorithm(self):
        r"""
        Get the FFT algorithm used to generate realizations of the spectral Gaussian process.

        Returns
        -------
        fftAlgo : :class:`~openturns.FFT`
            FFT algorithm used to generate realizations of the spectral Gaussian process.
            By default, it is the :class:`~openturns.KissFFT` algorithm.

        """
        return _model_process.SpectralGaussianProcess_getFFTAlgorithm(self)

    def setFFTAlgorithm(self, fft):
        r"""
        Set the FFT algorithm used to generate realizations of the spectral Gaussian process.

        Parameters
        ----------
        fftAlgo : :class:`~openturns.FFT`
            FFT algorithm that will be used to generate realizations of the spectral
            Gaussian process. The :class:`~openturns.KissFFT` is provided.
            More efficient implementations are provided by the *openturns-fftw* module.

        """
        return _model_process.SpectralGaussianProcess_setFFTAlgorithm(self, fft)

    def isStationary(self):
        r"""
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\forall k \in \Nset`,
        :math:`\forall (\vect{t}_1, \dots, \vect{t}_k) \in \cD`,
        :math:`\forall \vect{h}\in \Rset^n`, we have:

        .. math::

            (X_{\vect{t}_1}, \dots, X_{\vect{t}_k})
            \stackrel{\mathcal{D}}{=} (X_{\vect{t}_1+\vect{h}}, \dots, X_{\vect{t}_k+\vect{h}})

        """
        return _model_process.SpectralGaussianProcess_isStationary(self)

    def isNormal(self):
        r"""
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \in \Nset` and
        :math:`I_k \in \Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\vect{m}_1, \dots, \vect{m}_k \in \Rset^d` and
        :math:`\mat{C}_{1,\dots,k}\in\mathcal{M}_{kd,kd}(\Rset)` such that:

        .. math::

            \Expect{\exp\left\{i\Tr{\vect{X}}_{I_k} \vect{U}_{k}  \right\}} =
            \exp{\left\{i\Tr{\vect{U}}_{k}\vect{M}_{k}-\frac{1}{2}\Tr{\vect{U}}_{k}\mat{C}_{1,\dots,k}\vect{U}_{k}\right\}}

        where :math:`\Tr{\vect{X}}_{I_k} = (\Tr{X}_{\vect{t}_1}, \hdots, \Tr{X}_{\vect{t}_k})`,
        :math:`\\Tr{vect{U}}_{k} = (\Tr{\vect{u}}_{1}, \hdots, \Tr{\vect{u}}_{k})` and
        :math:`\Tr{\vect{M}}_{k} = (\Tr{\vect{m}}_{1}, \hdots, \Tr{\vect{m}}_{k})` and
        :math:`\mat{C}_{1,\dots,k}` is the symmetric matrix:

        .. math::

          \mat{C}_{1,\dots,k} = \left(
          \begin{array}{cccc}
            C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \hdots & C(\vect{t}_1, \vect{t}_{k}) \\
            \hdots & C(\vect{t}_2, \vect{t}_2)  & \hdots & C(\vect{t}_2, \vect{t}_{k}) \\
            \hdots & \hdots & \hdots & \hdots \\
            \hdots & \hdots & \hdots & C(\vect{t}_{k}, \vect{t}_{k})
          \end{array}
          \right)

        A Gaussian process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _model_process.SpectralGaussianProcess_isNormal(self)

    @staticmethod
    def AdaptGrid(grid):
        return _model_process.SpectralGaussianProcess_AdaptGrid(grid)

    def __init__(self, *args):
        _model_process.SpectralGaussianProcess_swiginit(self, _model_process.new_SpectralGaussianProcess(*args))
    __swig_destroy__ = _model_process.delete_SpectralGaussianProcess

# Register SpectralGaussianProcess in _model_process:
_model_process.SpectralGaussianProcess_swigregister(SpectralGaussianProcess)
class GaussianProcess(openturns.randomvector.ProcessImplementation):
    r"""
    Gaussian processes.

    Available constructor:
        GaussianProcess(*trend, covarianceModel, mesh*)

        GaussianProcess(*covarianceModel, mesh*)

    Parameters
    ----------
    trend : :class:`~openturns.TrendTransform`
        Trend function of the process. By default the trend is null.
    covarianceModel : :class:`~openturns.CovarianceModel`
        Temporal covariance model :math:`C`.
    mesh : :class:`~openturns.Mesh`
        Mesh :math:`\cM` over which the domain :math:`\cD` is discretized.

    Notes
    -----
    GaussianProcess creates the processes,
    :math:`X: \Omega \times\cD \mapsto \Rset^d` where :math:`\cD \in \Rset^n`,
    from their temporal covariance function
    :math:`\cC: \cD \times \cD \mapsto \cM_{d \times d}(\Rset)`, which writes, in
    the stationary case: :math:`\cC^{stat}: \cD \mapsto \cM_{d \times d}(\Rset)`. A
    process is *normal*, if all its finite dimensional joint distributions are
    normal (See the method :meth:`~openturns.Process.isNormal` for a detailed definition).

    The gaussian processes may have a trend: in that case, the Gaussian 
    process is the sum of the trend function
    :math:`f_{trend}: \Rset^n \mapsto \Rset^d` and a zero-mean Gaussian process.


    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # Amplitude values
    >>> amplitude = [1.0]
    >>> # Scale values
    >>> scale = [1.0]
    >>> # Second order model with parameters
    >>> covarianceModel = ot.AbsoluteExponential(scale, amplitude)
    >>> # Time grid
    >>> tmin = 0.0
    >>> step = 0.1
    >>> n = 11
    >>> meshGrid = ot.RegularGrid(tmin, step, n)
    >>> size = 100
    >>> myProcess = ot.GaussianProcess(covarianceModel, meshGrid)
    >>> myProcess.setSamplingMethod(myProcess.CHOLESKY)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.GaussianProcess_getClassName(self)

    def __repr__(self):
        return _model_process.GaussianProcess___repr__(self)

    def __str__(self, *args):
        return _model_process.GaussianProcess___str__(self, *args)

    def setMesh(self, mesh):
        r"""
        Set the mesh.

        Parameters
        ----------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\cD` is discretized.
        """
        return _model_process.GaussianProcess_setMesh(self, mesh)

    def setTimeGrid(self, timeGrid):
        r"""
        Set the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of observation of the process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _model_process.GaussianProcess_setTimeGrid(self, timeGrid)
    CHOLESKY = _model_process.GaussianProcess_CHOLESKY
    HMAT = _model_process.GaussianProcess_HMAT
    GALLIGAOGIBBS = _model_process.GaussianProcess_GALLIGAOGIBBS

    def getSamplingMethod(self):
        r"""
        Get the used method for getRealization.

        Returns
        -------
        samplingMethod : int
            Used method for sampling.

        Notes
        -----

        Available parameters are :

          * 0 (GaussianProcess.CHOLESKY) : Cholesky factor sampling (default method)

          * 1 (GaussianProcess.HMAT) : H-Matrix method (if H-Mat available)

          * 2 (GaussianProcess.GALLIGAOGIBBS) : Gibbs method (in dimension 1 only)


        """
        return _model_process.GaussianProcess_getSamplingMethod(self)

    def setSamplingMethod(self, samplingMethod):
        r"""
        Set the used method for getRealization.

        Available parameters are :

          * 0 (GaussianProcess.CHOLESKY) : Cholesky factor sampling (default method)

          * 1 (GaussianProcess.HMAT) : H-Matrix method (if H-Mat available)

          * 2 (GaussianProcess.GALLIGAOGIBBS) : Gibbs method (in dimension 1 only)

        Parameters
        ----------
        samplingMethod : int
            Fix a method for sampling.


        """
        return _model_process.GaussianProcess_setSamplingMethod(self, samplingMethod)

    def getRealization(self):
        r"""
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _model_process.GaussianProcess_getRealization(self)

    def getCovarianceModel(self):
        r"""
        Get the covariance model.

        Returns
        -------
        covarianceModel : :class:`~openturns.CovarianceModel`
            Temporal covariance model :math:`C`.
        """
        return _model_process.GaussianProcess_getCovarianceModel(self)

    def getTrend(self):
        r"""
        Get the trend function.

        Returns
        -------
        trend : :class:`~openturns.TrendTransform`
            Trend function.
        """
        return _model_process.GaussianProcess_getTrend(self)

    def isStationary(self):
        r"""
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\forall k \in \Nset`,
        :math:`\forall (\vect{t}_1, \dots, \vect{t}_k) \in \cD`,
        :math:`\forall \vect{h}\in \Rset^n`, we have:

        .. math::

            (X_{\vect{t}_1}, \dots, X_{\vect{t}_k})
            \stackrel{\mathcal{D}}{=} (X_{\vect{t}_1+\vect{h}}, \dots, X_{\vect{t}_k+\vect{h}})

        """
        return _model_process.GaussianProcess_isStationary(self)

    def isTrendStationary(self):
        r"""
        Tell if the process is trend stationary or not.

        Returns
        -------
        isTrendStationary : bool
            *True* if the process is trend stationary.
        """
        return _model_process.GaussianProcess_isTrendStationary(self)

    def isNormal(self):
        r"""
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \in \Nset` and
        :math:`I_k \in \Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\vect{m}_1, \dots, \vect{m}_k \in \Rset^d` and
        :math:`\mat{C}_{1,\dots,k}\in\mathcal{M}_{kd,kd}(\Rset)` such that:

        .. math::

            \Expect{\exp\left\{i\Tr{\vect{X}}_{I_k} \vect{U}_{k}  \right\}} =
            \exp{\left\{i\Tr{\vect{U}}_{k}\vect{M}_{k}-\frac{1}{2}\Tr{\vect{U}}_{k}\mat{C}_{1,\dots,k}\vect{U}_{k}\right\}}

        where :math:`\Tr{\vect{X}}_{I_k} = (\Tr{X}_{\vect{t}_1}, \hdots, \Tr{X}_{\vect{t}_k})`,
        :math:`\\Tr{vect{U}}_{k} = (\Tr{\vect{u}}_{1}, \hdots, \Tr{\vect{u}}_{k})` and
        :math:`\Tr{\vect{M}}_{k} = (\Tr{\vect{m}}_{1}, \hdots, \Tr{\vect{m}}_{k})` and
        :math:`\mat{C}_{1,\dots,k}` is the symmetric matrix:

        .. math::

          \mat{C}_{1,\dots,k} = \left(
          \begin{array}{cccc}
            C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \hdots & C(\vect{t}_1, \vect{t}_{k}) \\
            \hdots & C(\vect{t}_2, \vect{t}_2)  & \hdots & C(\vect{t}_2, \vect{t}_{k}) \\
            \hdots & \hdots & \hdots & \hdots \\
            \hdots & \hdots & \hdots & C(\vect{t}_{k}, \vect{t}_{k})
          \end{array}
          \right)

        A Gaussian process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _model_process.GaussianProcess_isNormal(self)

    def getMarginal(self, indices):
        r"""
        Get the :math:`k^{th}` marginal of the random process.

        Parameters
        ----------
        k : int or list of ints :math:`0 \leq k < d`
            Index of the marginal(s) needed.

        Returns
        -------
        marginals : :class:`~openturns.Process`
            Process defined with marginal(s) of the random process.
        """
        return _model_process.GaussianProcess_getMarginal(self, indices)

    def __init__(self, *args):
        _model_process.GaussianProcess_swiginit(self, _model_process.new_GaussianProcess(*args))
    __swig_destroy__ = _model_process.delete_GaussianProcess

# Register GaussianProcess in _model_process:
_model_process.GaussianProcess_swigregister(GaussianProcess)
class ProcessCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _model_process.delete_ProcessCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _model_process.ProcessCollection_clear(self)

    def __len__(self):
        return _model_process.ProcessCollection___len__(self)

    def __eq__(self, rhs):
        return _model_process.ProcessCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _model_process.ProcessCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _model_process.ProcessCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _model_process.ProcessCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _model_process.ProcessCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _model_process.ProcessCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _model_process.ProcessCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _model_process.ProcessCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _model_process.ProcessCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _model_process.ProcessCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _model_process.ProcessCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _model_process.ProcessCollection_find(self, val)

    def __repr__(self):
        return _model_process.ProcessCollection___repr__(self)

    def __str__(self, *args):
        return _model_process.ProcessCollection___str__(self, *args)

    def __init__(self, *args):
        _model_process.ProcessCollection_swiginit(self, _model_process.new_ProcessCollection(*args))

# Register ProcessCollection in _model_process:
_model_process.ProcessCollection_swigregister(ProcessCollection)
class AggregatedProcess(openturns.randomvector.ProcessImplementation):
    r"""
    Aggregation of several processes in one process.

    Parameters
    ----------
    collProc : sequence of :class:`~openturns.Process`
        Collection of processes which all have the same input dimension.

    Notes
    -----
    If we note :math:`X_i: \Omega \times\cD_i \mapsto \Rset^{d_i}` for :math:`0 \leq i \leq N` the collection of processes, where :math:`\cD_i \in \Rset^n` for all :math:`i`.
    Then the resulting aggregated process :math:`Y: \Omega \times\cD_0 \mapsto \Rset^d` where :math:`d=\sum_{i=0}^N d_i`. The mesh of the first process :math:`X_0` has been assigned to the process :math:`Y`.

    Examples
    --------
    Create an aggregated process:

    >>> import openturns as ot
    >>> myMesher = ot.IntervalMesher([5, 10])
    >>> lowerbound = [0.0, 0.0]
    >>> upperBound = [2.0, 4.0]
    >>> myInterval = ot.Interval(lowerbound, upperBound)
    >>> myMesh = myMesher.build(myInterval)
    >>> myProcess1 = ot.WhiteNoise(ot.Normal(), myMesh)
    >>> myProcess2 = ot.WhiteNoise(ot.Triangular(), myMesh)
    >>> myAggregatedProcess = ot.AggregatedProcess([myProcess1, myProcess2])

    Draw one realization:

    >>> myGraph = myAggregatedProcess.getRealization().drawMarginal(0)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.AggregatedProcess_getClassName(self)

    def __repr__(self):
        return _model_process.AggregatedProcess___repr__(self)

    def __str__(self, *args):
        return _model_process.AggregatedProcess___str__(self, *args)

    def getRealization(self):
        r"""
        Get one realization of the aggregated process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Each process of the collection is realized on the common mesh defined on :math:`\cD_0`.
        """
        return _model_process.AggregatedProcess_getRealization(self)

    def getContinuousRealization(self):
        r"""
        Get a continuous realization.

        Returns
        -------
        realization : :class:`~openturns.Function`
            Each process of the collection is continuously realized on the common domain :math:`\cD_0`.
        """
        return _model_process.AggregatedProcess_getContinuousRealization(self)

    def getFuture(self, *args):
        r"""
        Prediction of the :math:`N` future iterations of the process.

        Parameters
        ----------
        stepNumber : int, :math:`N \geq 0`
            Number of future steps.
        size : int, :math:`size \geq 0`, optional
            Number of futures needed. Default is 1.

        Returns
        -------
        prediction : :class:`~openturns.ProcessSample` or :class:`~openturns.TimeSeries`
            :math:`N` future iterations of the process.
            If :math:`size = 1`, *prediction* is a :class:`~openturns.TimeSeries`.
            Otherwise, it is a :class:`~openturns.ProcessSample`.
        """
        return _model_process.AggregatedProcess_getFuture(self, *args)

    def getMarginal(self, *args):
        r"""
        Accessor the marginal processes.

        Available usages:
            getMarginal(*index*)

            getMarginal(*indices*)

        Parameters
        ----------
        index : int
            Index of the selected marginal process.
        indices : :class:`~openturns.Indices`
            List of indices of the selected marginal processes.

        Notes
        -----
        The selected marginal processes are extracted if the list of indices does not mingle the processes of the initial collection: take care to extract all the marginal processes process by process.
        For example, if :math:`X_0=(X_0^0, X_0^1)`, :math:`X_1=(X_1^0, X_1^1)` and :math:`X_2=(X_2^0, X_2^1, X_2^2)` then you can extract `Indices([1,0,2,4,6])` but not `Indices([1,2,0,4,6])`.
        """
        return _model_process.AggregatedProcess_getMarginal(self, *args)

    def setProcessCollection(self, coll):
        r"""
        Set the collection of processes.

        Parameters
        ----------
        collProc : sequence of :class:`~openturns.Process`
            Collection of processes which all have the same input dimension.

        """
        return _model_process.AggregatedProcess_setProcessCollection(self, coll)

    def getProcessCollection(self):
        r"""
        Get the collection of processes.

        Returns
        -------
        collProc : :class:`~openturns.ProcessCollection`
            Collection of processes which all have the same input dimension.

        """
        return _model_process.AggregatedProcess_getProcessCollection(self)

    def setMesh(self, mesh):
        r"""
        Set the mesh.

        Parameters
        ----------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\cD` is discretized.
        """
        return _model_process.AggregatedProcess_setMesh(self, mesh)

    def setTimeGrid(self, timeGrid):
        r"""
        Set the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of observation of the process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _model_process.AggregatedProcess_setTimeGrid(self, timeGrid)

    def isNormal(self):
        r"""
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \in \Nset` and
        :math:`I_k \in \Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\vect{m}_1, \dots, \vect{m}_k \in \Rset^d` and
        :math:`\mat{C}_{1,\dots,k}\in\mathcal{M}_{kd,kd}(\Rset)` such that:

        .. math::

            \Expect{\exp\left\{i\Tr{\vect{X}}_{I_k} \vect{U}_{k}  \right\}} =
            \exp{\left\{i\Tr{\vect{U}}_{k}\vect{M}_{k}-\frac{1}{2}\Tr{\vect{U}}_{k}\mat{C}_{1,\dots,k}\vect{U}_{k}\right\}}

        where :math:`\Tr{\vect{X}}_{I_k} = (\Tr{X}_{\vect{t}_1}, \hdots, \Tr{X}_{\vect{t}_k})`,
        :math:`\\Tr{vect{U}}_{k} = (\Tr{\vect{u}}_{1}, \hdots, \Tr{\vect{u}}_{k})` and
        :math:`\Tr{\vect{M}}_{k} = (\Tr{\vect{m}}_{1}, \hdots, \Tr{\vect{m}}_{k})` and
        :math:`\mat{C}_{1,\dots,k}` is the symmetric matrix:

        .. math::

          \mat{C}_{1,\dots,k} = \left(
          \begin{array}{cccc}
            C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \hdots & C(\vect{t}_1, \vect{t}_{k}) \\
            \hdots & C(\vect{t}_2, \vect{t}_2)  & \hdots & C(\vect{t}_2, \vect{t}_{k}) \\
            \hdots & \hdots & \hdots & \hdots \\
            \hdots & \hdots & \hdots & C(\vect{t}_{k}, \vect{t}_{k})
          \end{array}
          \right)

        A Gaussian process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _model_process.AggregatedProcess_isNormal(self)

    def isStationary(self):
        r"""
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\forall k \in \Nset`,
        :math:`\forall (\vect{t}_1, \dots, \vect{t}_k) \in \cD`,
        :math:`\forall \vect{h}\in \Rset^n`, we have:

        .. math::

            (X_{\vect{t}_1}, \dots, X_{\vect{t}_k})
            \stackrel{\mathcal{D}}{=} (X_{\vect{t}_1+\vect{h}}, \dots, X_{\vect{t}_k+\vect{h}})

        """
        return _model_process.AggregatedProcess_isStationary(self)

    def getCovarianceModel(self):
        r"""
        Accessor to the covariance model.

        Returns
        -------
        cov_model : :class:`~openturns.CovarianceModel`
            Covariance model, if any.
        """
        return _model_process.AggregatedProcess_getCovarianceModel(self)

    def getTrend(self):
        r"""
        Accessor to the trend.

        Returns
        -------
        trend : :class:`~openturns.TrendTransform`
            Trend, if any.
        """
        return _model_process.AggregatedProcess_getTrend(self)

    def __init__(self, *args):
        _model_process.AggregatedProcess_swiginit(self, _model_process.new_AggregatedProcess(*args))
    __swig_destroy__ = _model_process.delete_AggregatedProcess

# Register AggregatedProcess in _model_process:
_model_process.AggregatedProcess_swigregister(AggregatedProcess)
class CompositeProcess(openturns.randomvector.ProcessImplementation):
    r"""
    Process obtained by transformation.

    Parameters
    ----------
    fdyn : :class:`~openturns.FieldFunction`
        A field function.
    inputProc : :class:`~openturns.Process`
        The input process.

    Notes
    -----
    A composite process is the image of  process :math:`X: \Omega \times\cD \mapsto \Rset^d` by the field function :math:`f_{dyn}:\cD \times \Rset^d \rightarrow \cD' \times \Rset^q`:

    .. math::

        Y = fdyn(X)


    where :math:`\cD \in \Rset^n` and  :math:`\cD' \in \Rset^p`, defined by:

    .. math::

        f_{dyn}(\vect{t}, \vect{x}) = (t'(\vect{t}), v'(\vect{t}, \vect{x}))


    with :math:`t': \cD \rightarrow \cD'` and :math:`v': \cD \times \Rset^d \rightarrow \Rset^q`.

    The process :math:`Y: \Omega \times \cD' \rightarrow \Rset^q` is defined on the domain :math:`\cD'` associated to the mesh :math:`\cM'`.

    Examples
    --------
    Create the process X:

    >>> import openturns as ot
    >>> amplitude = [1.0, 1.0]
    >>> scale = [0.2, 0.3]
    >>> myCovModel = ot.ExponentialModel(scale, amplitude)
    >>> myMesh = ot.IntervalMesher([100]*2).build(ot.Interval([0.0]*2, [1.0]*2))
    >>> myXProcess = ot.GaussianProcess(myCovModel, myMesh)

    Create a spatial field  function :math:`g_{dyn}` associated to :math:`g: \Rset^2 \mapsto \Rset^2` where :math:`g(x_1,x_2)= (x_1^2, x_1+x_2)`:

    >>> g = ot.SymbolicFunction(['x1', 'x2'],  ['x1^2', 'x1+x2'])
    >>> nSpat = 2
    >>> gdyn = ot.ValueFunction(g, myMesh)

    Create the Y process :math:`Y = g_{dyn}(X)`:

    >>> myYProcess = ot.CompositeProcess(gdyn, myXProcess)

    Add the trend :math:`f_{trend}: \Rset^2 \mapsto \Rset^2` where :math:`f_{trend}(x_1,x_2)= (1+2x_1, 1+3x_2^2)`:

    >>> f = ot.SymbolicFunction(['x1', 'x2'], ['1+2*x1', '1+3*x2^2'])
    >>> fTrend = ot.TrendTransform(f, myMesh)

    Create the process :math:`Y(\omega, \vect{t}) = X(\omega, \vect{t}) + f_{trend}(\vect{t})`:

    >>> myYProcess2 = ot.CompositeProcess(fTrend, myXProcess)

    Apply the Box Cox transformation :math:`h=(h_1,h_2): \Rset\mapsto \Rset^2` where :math:`h_i(x) = \dfrac{x^3-1}{3}`:

    >>> h = ot.BoxCoxTransform([3.0, 0.0])
    >>> hBoxCox = ot.ValueFunction(h, myMesh)

    Create the Y process :math:`Y = hBoxCox(X)`:

    >>> myYProcess3 = ot.CompositeProcess(hBoxCox,  myXProcess)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.CompositeProcess_getClassName(self)

    def __repr__(self):
        return _model_process.CompositeProcess___repr__(self)

    def __str__(self, *args):
        return _model_process.CompositeProcess___str__(self, *args)

    def isComposite(self):
        r"""
        Test whether the process is composite or not.

        Returns
        -------
        isComposite : bool
            *True* if the process is composite (built upon a function and a process).
        """
        return _model_process.CompositeProcess_isComposite(self)

    def getRealization(self):
        r"""
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _model_process.CompositeProcess_getRealization(self)

    def getFuture(self, *args):
        r"""
        Prediction of the :math:`N` future iterations of the process.

        Parameters
        ----------
        stepNumber : int, :math:`N \geq 0`
            Number of future steps.
        size : int, :math:`size \geq 0`, optional
            Number of futures needed. Default is 1.

        Returns
        -------
        prediction : :class:`~openturns.ProcessSample` or :class:`~openturns.TimeSeries`
            :math:`N` future iterations of the process.
            If :math:`size = 1`, *prediction* is a :class:`~openturns.TimeSeries`.
            Otherwise, it is a :class:`~openturns.ProcessSample`.
        """
        return _model_process.CompositeProcess_getFuture(self, *args)

    def getAntecedent(self):
        r"""
        Get the antecedent process.

        Returns
        -------
        XProcess : :class:`~openturns.Process`
            The process :math:`X`.
        """
        return _model_process.CompositeProcess_getAntecedent(self)

    def getFunction(self):
        r"""
        Get the field function.

        Returns
        -------
        fdyn : :class:`~openturns.FieldFunction`
            The field function :math:`f_{dyn}`.
        """
        return _model_process.CompositeProcess_getFunction(self)

    def getMarginal(self, indices):
        r"""
        Get the :math:`k^{th}` marginal of the random process.

        Parameters
        ----------
        k : int or list of ints :math:`0 \leq k < d`
            Index of the marginal(s) needed.

        Returns
        -------
        marginals : :class:`~openturns.Process`
            Process defined with marginal(s) of the random process.
        """
        return _model_process.CompositeProcess_getMarginal(self, indices)

    def __init__(self, *args):
        _model_process.CompositeProcess_swiginit(self, _model_process.new_CompositeProcess(*args))
    __swig_destroy__ = _model_process.delete_CompositeProcess

# Register CompositeProcess in _model_process:
_model_process.CompositeProcess_swigregister(CompositeProcess)
class FunctionalBasisProcess(openturns.randomvector.ProcessImplementation):
    r"""
    Functional basis process.

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        The distribution of the random vector :math:`\vect{A}=(A_1,\dots, A_K)`.
    basis : sequence of :class:`~openturns.Function`
        Collection of deterministic functions.
    mesh : :class:`~openturns.Mesh`
        Mesh :math:`\cM` over which the domain :math:`\cD` is discretized.

    Notes
    -----
    A functional basis process :math:`X: \Omega \times\cD \mapsto \Rset^d` where :math:`\cD \in \Rset^n`, writes:

    .. math::

        X(\omega,\vect{t})=\sum_{i=1}^K A_i(\omega)\phi_i(\vect{t}) \quad  \forall \omega \in \Omega and \forall \vect{t} \in \cD

    with :math:`\phi_i: \Rset^n \rightarrow \Rset^d` for :math:`1 \leq i \leq K` and :math:`\vect{A}=(A_1,\dots, A_K)` a random vector of dimension :math:`K`.

    Examples
    --------
    Create the coefficients distribution:

    >>> import openturns as ot
    >>> coefDist = ot.Normal([2]*2, [5]*2, ot.CorrelationMatrix(2))

    Create a basis of functions:

    >>> phi_1 = ot.SymbolicFunction(['t'], ['sin(t)'])
    >>> phi_2 = ot.SymbolicFunction(['t'], ['cos(t)*cos(t)'])
    >>> myBasis = ot.Basis([phi_1, phi_2])

    Create a mesh:

    >>> myMesh = ot.RegularGrid(0.0, 0.1, 10)

    Create the functional basis process:

    >>> myFBProcess = ot.FunctionalBasisProcess(coefDist, myBasis, myMesh)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.FunctionalBasisProcess_getClassName(self)

    def __repr__(self):
        return _model_process.FunctionalBasisProcess___repr__(self)

    def __str__(self, *args):
        return _model_process.FunctionalBasisProcess___str__(self, *args)

    def isStationary(self):
        r"""
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\forall k \in \Nset`,
        :math:`\forall (\vect{t}_1, \dots, \vect{t}_k) \in \cD`,
        :math:`\forall \vect{h}\in \Rset^n`, we have:

        .. math::

            (X_{\vect{t}_1}, \dots, X_{\vect{t}_k})
            \stackrel{\mathcal{D}}{=} (X_{\vect{t}_1+\vect{h}}, \dots, X_{\vect{t}_k+\vect{h}})

        """
        return _model_process.FunctionalBasisProcess_isStationary(self)

    def isNormal(self):
        r"""
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \in \Nset` and
        :math:`I_k \in \Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\vect{m}_1, \dots, \vect{m}_k \in \Rset^d` and
        :math:`\mat{C}_{1,\dots,k}\in\mathcal{M}_{kd,kd}(\Rset)` such that:

        .. math::

            \Expect{\exp\left\{i\Tr{\vect{X}}_{I_k} \vect{U}_{k}  \right\}} =
            \exp{\left\{i\Tr{\vect{U}}_{k}\vect{M}_{k}-\frac{1}{2}\Tr{\vect{U}}_{k}\mat{C}_{1,\dots,k}\vect{U}_{k}\right\}}

        where :math:`\Tr{\vect{X}}_{I_k} = (\Tr{X}_{\vect{t}_1}, \hdots, \Tr{X}_{\vect{t}_k})`,
        :math:`\\Tr{vect{U}}_{k} = (\Tr{\vect{u}}_{1}, \hdots, \Tr{\vect{u}}_{k})` and
        :math:`\Tr{\vect{M}}_{k} = (\Tr{\vect{m}}_{1}, \hdots, \Tr{\vect{m}}_{k})` and
        :math:`\mat{C}_{1,\dots,k}` is the symmetric matrix:

        .. math::

          \mat{C}_{1,\dots,k} = \left(
          \begin{array}{cccc}
            C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \hdots & C(\vect{t}_1, \vect{t}_{k}) \\
            \hdots & C(\vect{t}_2, \vect{t}_2)  & \hdots & C(\vect{t}_2, \vect{t}_{k}) \\
            \hdots & \hdots & \hdots & \hdots \\
            \hdots & \hdots & \hdots & C(\vect{t}_{k}, \vect{t}_{k})
          \end{array}
          \right)

        A Gaussian process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _model_process.FunctionalBasisProcess_isNormal(self)

    def getRealization(self):
        r"""
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _model_process.FunctionalBasisProcess_getRealization(self)

    def getContinuousRealization(self):
        r"""
        Get a continuous realization.

        Returns
        -------
        realization : :class:`~openturns.Function`
            According to the process, the continuous realizations are built:

            - either using a dedicated functional model if it exists: e.g. a functional
              basis process.

            - or using an interpolation from a discrete realization of the process on
              :math:`\cM`: in dimension :math:`d=1`, a linear interpolation and in
              dimension :math:`d \geq 2`, a piecewise constant function (the value at a
              given position is equal to the value at the nearest vertex of the mesh of
              the process).
        """
        return _model_process.FunctionalBasisProcess_getContinuousRealization(self)

    def getFuture(self, *args):
        r"""
        Prediction of the :math:`N` future iterations of the process.

        Parameters
        ----------
        stepNumber : int, :math:`N \geq 0`
            Number of future steps.
        size : int, :math:`size \geq 0`, optional
            Number of futures needed. Default is 1.

        Returns
        -------
        prediction : :class:`~openturns.ProcessSample` or :class:`~openturns.TimeSeries`
            :math:`N` future iterations of the process.
            If :math:`size = 1`, *prediction* is a :class:`~openturns.TimeSeries`.
            Otherwise, it is a :class:`~openturns.ProcessSample`.
        """
        return _model_process.FunctionalBasisProcess_getFuture(self, *args)

    def getMarginal(self, indices):
        r"""
        Get the :math:`k^{th}` marginal of the random process.

        Parameters
        ----------
        k : int or list of ints :math:`0 \leq k < d`
            Index of the marginal(s) needed.

        Returns
        -------
        marginals : :class:`~openturns.Process`
            Process defined with marginal(s) of the random process.
        """
        return _model_process.FunctionalBasisProcess_getMarginal(self, indices)

    def getDistribution(self):
        r"""
        Get the coefficients distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The distribution of the random vector :math:`\vect{A}=(A_1,\dots, A_K)` of dimension :math:`K`.
        """
        return _model_process.FunctionalBasisProcess_getDistribution(self)

    def setDistribution(self, distribution):
        r"""
        Set the coefficients distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            The distribution of the random vector :math:`\vect{A}=(A_1,\dots, A_K)` of dimension :math:`K`.
        """
        return _model_process.FunctionalBasisProcess_setDistribution(self, distribution)

    def getBasis(self):
        r"""
        Get the basis of deterministic functions.

        Returns
        -------
        basis : collection of :class:`~openturns.Function`
            Collection of functions :math:`(\phi_i)_{1 \leq i \leq K}`.
        """
        return _model_process.FunctionalBasisProcess_getBasis(self)

    def setBasis(self, basis):
        r"""
        Set the basis of deterministic functions.

        Parameters
        ----------
        basis : sequence of :class:`~openturns.Function`
            Collection of functions :math:`(\phi_i)_{1 \leq i \leq K}`.
        """
        return _model_process.FunctionalBasisProcess_setBasis(self, basis)

    def getCovarianceModel(self):
        r"""
        Accessor to the covariance model.

        Returns
        -------
        cov_model : :class:`~openturns.CovarianceModel`
            Covariance model, if any.
        """
        return _model_process.FunctionalBasisProcess_getCovarianceModel(self)

    def __init__(self, *args):
        _model_process.FunctionalBasisProcess_swiginit(self, _model_process.new_FunctionalBasisProcess(*args))
    __swig_destroy__ = _model_process.delete_FunctionalBasisProcess

# Register FunctionalBasisProcess in _model_process:
_model_process.FunctionalBasisProcess_swigregister(FunctionalBasisProcess)
class ARMAFactoryImplementation(openturns.common.PersistentObject):
    r"""Base class for ARMA models factory."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.ARMAFactoryImplementation_getClassName(self)

    def __repr__(self):
        return _model_process.ARMAFactoryImplementation___repr__(self)

    def __str__(self, *args):
        return _model_process.ARMAFactoryImplementation___str__(self, *args)

    def getP(self):
        r"""
        Accessor to the P orders.

        Returns
        -------
        indP : :class:`~openturns.Indices`
            All the :math:`p` orders that will be investigated.
        """
        return _model_process.ARMAFactoryImplementation_getP(self)

    def getCurrentP(self):
        r"""
        Accessor to the current P order.

        Returns
        -------
        p : int
            Order of the AR part of the :math:`ARMA(p,q)` process of dimension :math:`d`.
        """
        return _model_process.ARMAFactoryImplementation_getCurrentP(self)

    def getQ(self):
        r"""
        Accessor to the Q orders.

        Returns
        -------
        indQ : :class:`~openturns.Indices`
            All the :math:`p` orders that will be investigated.
        """
        return _model_process.ARMAFactoryImplementation_getQ(self)

    def getCurrentQ(self):
        r"""
        Accessor to the current Q order.

        Returns
        -------
        q : int
            Order of the MA part of the :math:`ARMA(p,q)` process of dimension :math:`d`.
        """
        return _model_process.ARMAFactoryImplementation_getCurrentQ(self)

    def getInvertible(self):
        r"""
        Accessor to the invertible constraint.

        Returns
        -------
        invertible : bool
            The initial AR coefficients used for the optimization algorithm.
        """
        return _model_process.ARMAFactoryImplementation_getInvertible(self)

    def setInvertible(self, invertible):
        r"""
        Accessor to the invertible constraint.

        Parameters
        ----------
        invertible : bool
            The initial AR coefficients used for the optimization algorithm.
        """
        return _model_process.ARMAFactoryImplementation_setInvertible(self, invertible)

    def build(self, *args):
        r"""
        Estimate the ARMA model from data.

        Available usages:
            build(*myTimeSeries*)

            build(*myProcessSample*)

        Parameters
        ----------
        myTimeSeries : :class:`~openturns.TimeSeries` 
            The time series from which the ARMA model is estimated.
        myProcessSample : :class:`~openturns.ProcessSample` 
            The sample of time series from which the ARMA model is estimated.

        Returns
        -------
        myARMA : :class:`~openturns.ARMA`
            The estimated spectral model.

        """
        return _model_process.ARMAFactoryImplementation_build(self, *args)

    def __init__(self, *args):
        _model_process.ARMAFactoryImplementation_swiginit(self, _model_process.new_ARMAFactoryImplementation(*args))
    __swig_destroy__ = _model_process.delete_ARMAFactoryImplementation

# Register ARMAFactoryImplementation in _model_process:
_model_process.ARMAFactoryImplementation_swigregister(ARMAFactoryImplementation)
class WhittleFactoryState(openturns.common.PersistentObject):
    r"""
    Last state recorded of a scalar ARMA process.

    Parameters
    ----------
    p : int
        AR order of the estimated :math:`ARMA(p,q)`.
    ARMACoeff : sequence of float of dimension :math:`p+q`
        Coefficients of the AR then MA part of the estimated :math:`ARMA(p,q)` process.
    sigma2 : float
        Variance of the white noise.
    criteria : sequence of float of dimension 3
        The values of the criteria *AIC*, :math:`AIC_c` (corrected AIC) and *BIC* on the estimated :math:`ARMA(p,q)` process.
    timeGrid : :class:`~openturns.RegularGrid`
        Time grid of the :math:`ARMA(p,q)` process.

    Examples
    --------
    Create a time series from a scalar ARMA(4,2) and a normal white noise:

    >>> import openturns as ot
    >>> myTimeGrid = ot.RegularGrid(0.0, 0.1, 20)
    >>> myWhiteNoise = ot.WhiteNoise(ot.Triangular(-1.0, 0.0, 1.0), myTimeGrid)
    >>> myARCoef = ot.ARMACoefficients([0.4, 0.3, 0.2, 0.1])
    >>> myMACoef = ot.ARMACoefficients([0.4, 0.3])
    >>> myARMAProcess = ot.ARMA(myARCoef, myMACoef, myWhiteNoise)
    >>> myTimeSeries = myARMAProcess.getRealization()
    >>> myProcessSample = myARMAProcess.getSample(20)

    Estimate the ARMA process specifying a range for the orders:

    >>> pIndices = [1, 2]
    >>> qIndices =  [4, 5]
    >>> myFactory_Range = ot.WhittleFactory(pIndices, qIndices)

    Print all the models and their state:

    >>> myWhittleHistory = myFactory_Range.getHistory()
    >>> for i in range(myWhittleHistory.getSize()):
    ...     model_i = myWhittleHistory[i]
    ...     arma = model_i.getARMA()
    ...     print('Order(p,q) = '+str(model_i.getP())+', '+str(model_i.getQ()))
    ...     print('AR coeff = '+str(model_i.getARCoefficients()))
    ...     print('MA coeff = '+str(model_i.getMACoefficients()))
    ...     print('White Noise - Sigma = '+str(model_i.getSigma2()))
    ...     print('Criteria AICc, AIC, BIC = '+str(model_i.getInformationCriteria()))
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.WhittleFactoryState_getClassName(self)

    def __repr__(self):
        return _model_process.WhittleFactoryState___repr__(self)

    def __str__(self, *args):
        return _model_process.WhittleFactoryState___str__(self, *args)

    def getP(self):
        r"""
        Accessor to AR order.

        Returns
        -------
        p : int
            Order of the AR part of the estimated model.

        """
        return _model_process.WhittleFactoryState_getP(self)

    def getQ(self):
        r"""
        Accessor to MA order.

        Returns
        -------
        q : int
            Order of the MA part of the estimated model.
        """
        return _model_process.WhittleFactoryState_getQ(self)

    def getTheta(self):
        r"""
        Accessor to the coefficients of the scalar ARMA process.

        Returns
        -------
        coeff : :class:`~openturns.Point`
            The AR and MA coefficients of the linear recurrence defining the process.
        """
        return _model_process.WhittleFactoryState_getTheta(self)

    def getSigma2(self):
        r"""
        Accessor to the variance of the white noise.

        Parameters
        ----------
        sigma2 : positive float
            Variance of the white noise.
        """
        return _model_process.WhittleFactoryState_getSigma2(self)

    def getARCoefficients(self):
        r"""
        Accessor to the AR coefficients of the scalar ARMA process.

        Returns
        -------
        ARCoeff : :class:`~openturns.ARMACoefficients`
            The AR coefficients of the linear recurrence defining the process.
        """
        return _model_process.WhittleFactoryState_getARCoefficients(self)

    def getMACoefficients(self):
        r"""
        Accessor to the MA coefficients of the scalar ARMA process.

        Returns
        -------
        MACoeff : :class:`~openturns.ARMACoefficients`
            The MA coefficients of the linear recurrence defining the process.
        """
        return _model_process.WhittleFactoryState_getMACoefficients(self)

    def getWhiteNoise(self):
        r"""
        Accessor to the white noise defining the scalar ARMA process.

        Returns
        -------
        whiteNoise : :class:`~openturns.WhiteNoise`
            The white noise of the estimated model.
        """
        return _model_process.WhittleFactoryState_getWhiteNoise(self)

    def getARMA(self):
        r"""
        Accessor to the estimated scalar ARMA.

        Returns
        -------
        MACoeff : :class:`~openturns.ARMA`
            The estimated ARMA model.
        """
        return _model_process.WhittleFactoryState_getARMA(self)

    def getInformationCriteria(self):
        r"""
        Accessor to the values of the criteria *AIC*, :math:`AIC_c` and *BIC*.

        Returns
        -------
        criteria : :class:`~openturns.Point` of  dimension 3
            Values of the criteria *AIC*, :math:`AIC_c` (corrected AIC) and *BIC* of the estimated model. 
        """
        return _model_process.WhittleFactoryState_getInformationCriteria(self)

    def getTimeGrid(self):
        r"""
        Accessor to the time grid of the scalar ARMA process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid` 
           Time grid over which the ARMA process is defined.
        """
        return _model_process.WhittleFactoryState_getTimeGrid(self)

    def __init__(self, *args):
        _model_process.WhittleFactoryState_swiginit(self, _model_process.new_WhittleFactoryState(*args))
    __swig_destroy__ = _model_process.delete_WhittleFactoryState

# Register WhittleFactoryState in _model_process:
_model_process.WhittleFactoryState_swigregister(WhittleFactoryState)
class WhittleFactoryStateCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _model_process.delete_WhittleFactoryStateCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _model_process.WhittleFactoryStateCollection_clear(self)

    def __len__(self):
        return _model_process.WhittleFactoryStateCollection___len__(self)

    def __eq__(self, rhs):
        return _model_process.WhittleFactoryStateCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _model_process.WhittleFactoryStateCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _model_process.WhittleFactoryStateCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _model_process.WhittleFactoryStateCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _model_process.WhittleFactoryStateCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _model_process.WhittleFactoryStateCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _model_process.WhittleFactoryStateCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _model_process.WhittleFactoryStateCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _model_process.WhittleFactoryStateCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _model_process.WhittleFactoryStateCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _model_process.WhittleFactoryStateCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _model_process.WhittleFactoryStateCollection_find(self, val)

    def __repr__(self):
        return _model_process.WhittleFactoryStateCollection___repr__(self)

    def __str__(self, *args):
        return _model_process.WhittleFactoryStateCollection___str__(self, *args)

    def __init__(self, *args):
        _model_process.WhittleFactoryStateCollection_swiginit(self, _model_process.new_WhittleFactoryStateCollection(*args))

# Register WhittleFactoryStateCollection in _model_process:
_model_process.WhittleFactoryStateCollection_swigregister(WhittleFactoryStateCollection)
class WhittleFactory(ARMAFactoryImplementation):
    r"""
    Whittle estimator of a scalar ARMA Gaussian process.

    Available constructors:
        WhittleFactory()

        WhittleFactory(*p, q, invert*)

        WhittleFactory(*indP, indQ, invertible*)


    Parameters
    ----------
    p : int
        Order of the AR part of the :math:`ARMA(p,q)` process of dimension :math:`d`.
    q : int
        Order of the MA part of the :math:`ARMA(p,q)` process of dimension :math:`d`.
    invertible : bool, optional
        Restrict the estimation to invertible ARMA processes.

        By default: True.
    indP : :class:`~openturns.Indices`
        All the :math:`p` orders that will be investigated.
        Care: not yet implemented.
    indQ : :class:`~openturns.Indices`
        All the :math:`p` orders that will be investigated.
        Care: not yet implemented.

    Notes
    -----
    We suppose here that the white noise is normal with zero mean and  variance :math:`\sigma^2`. It implies that the ARMA process estimated is normal.

    For each order :math:`(p,q)`, the estimation of the coefficients :math:`(a_k)_{1\leq k\leq p}`, :math:`(b_k)_{1\leq k\leq q}` and the variance :math:`\sigma^2` is done using the Whittle estimator which is based on the maximization of the likelihood function in the frequency domain. 

    The principle is detailed hereafter for the case of a time series : in the case of a process sample, the estimator is similar except for the periodogram which is computed differently.

    Let :math:`(t_i, \vect{X}_i)_{0\leq i \leq n-1}` be a multivariate time series of dimension :math:`d` from an :math:`ARMA(p,q)` process. 

    The spectral density function of the :math:`ARMA(p,q)` process writes :

    .. math::

        f(\lambda, \vect{\theta}, \sigma^2) = \frac{\sigma^2}{2 \pi} \frac{|1 + b_1 \exp(-i \lambda) + \ldots + b_q \exp(-i q \lambda)|^2}{|1 + a_1 \exp(-i \lambda) + \ldots + a_p \exp(-i p \lambda)|^2} = \frac{\sigma^2}{2 \pi} g(\lambda, \vect{\theta})

    where  :math:`\vect{\theta} = (a_1, a_2,...,a_p,b_1,...,b_q)` and :math:`\lambda` is the frequency value.

    The Whittle log-likelihood writes :

    .. math::

        \log L_w(\vect{\theta}, \sigma^2) = - \sum_{j=1}^{m} \log f(\lambda_j,  \vect{\theta}, \sigma^2) - \frac{1}{2 \pi} \sum_{j=1}^{m} \frac{I(\lambda_j)}{f(\lambda_j,  \vect{\theta}, \sigma^2)}

    where :

    - :math:`I` is the non parametric estimate of the spectral density, expressed in the Fourier space (frequencies in :math:`[0,2\pi]` instead of :math:`[-f_{max}, f_{max}]`). OpenTURNS uses by default the Welch estimator.

    - :math:`\lambda_j` is the :math:`j-th` Fourier frequency, :math:`\lambda_j = \frac{2 \pi j}{n}`, :math:`j=1 \ldots m` with :math:`m` the largest integer  :math:`\leq \frac{n-1}{2}`.


    We estimate the :math:`(p+q+1)` scalar coefficients by maximizing the log-likelihood function. The corresponding equations lead to the following relation :

    .. math::

        \sigma^{2*} = \frac{1}{m} \sum_{j=1}^{m} \frac{I(\lambda_j)}{g(\lambda_j, \vect{\theta}^{*})}

    where :math:`\vect{\theta}^{*}` maximizes :

    .. math::

        \log L_w(\vect{\theta}) = m (\log(2 \pi) - 1) - m \log\left( \frac{1}{m} \sum_{j=1}^{m} \frac{I(\lambda_j)}{g(\lambda_j, \vect{\theta})}\right) - \sum_{j=1}^{m} g(\lambda_j, \vect{\theta})

    The Whitle estimation requires that :

    - the determinant of the eigenvalues of the companion matrix associated to the polynomial  :math:`1 + a_1X + \dots + a_pX^p` are  outside the unit disc, which guarantees the stationarity of the process;

    - the determinant of the eigenvalues of the companion matrix associated to the polynomial  :math:`1 + ba_1X + \dots + b_qX^q` are outside the unit disc, which guarantees the invertibility of the process.


    The criteria *AIC*, :math:`AIC_c` (corrected AIC) and *BIC* are evaluated to help the model selection:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            AIC_c  & = &  -2\log L_w + 2(p + q + 1)\frac{m}{m - p - q - 2}\\
            AIC & = & -2\log L_w + 2(p + q + 1)\\
            BIC & = & -2\log L_w + 2(p + q + 1)\log(p + q + 1)
        \end{eqnarray*}

    where :math:`m` is half the number of points of the time grid of the process sample (if the data are a process sample) or in a block of the time series (if the data are a time series).

    The *BIC* criterion leads to a model that gives a better prediction. The *AIC* criterion selects the best model that fits the given data. The :math:`AIC_c` criterion improves the previous one by penalizing a too high order that would artificially fit to the data.


    Examples
    --------
    Create a time series from a scalar ARMA(4,2) and a normal white noise:

    >>> import openturns as ot
    >>> myTimeGrid = ot.RegularGrid(0.0, 0.1, 100)
    >>> myWhiteNoise = ot.WhiteNoise(ot.Triangular(-1.0, 0.0, 1.0), myTimeGrid)
    >>> myARCoef = ot.ARMACoefficients([0.4, 0.3, 0.2, 0.1])
    >>> myMACoef = ot.ARMACoefficients([0.4, 0.3])
    >>> myARMAProcess = ot.ARMA(myARCoef, myMACoef, myWhiteNoise)
    >>> myTimeSeries = myARMAProcess.getRealization()
    >>> myProcessSample = myARMAProcess.getSample(10)

    Estimate the ARMA process specifying the orders:

    >>> myFactory_42 = ot.WhittleFactory(4, 2)

    Check the default SpectralModelFactory:

    >>> print(myFactory_42.getSpectralModelFactory())  # doctest: +SKIP

    Set a particular spectral model: WelchFactory as SpectralModelFactory with the Hann filtering window:

    >>> myFilteringWindow = ot.Hann()
    >>> mySpectralFactory = ot.WelchFactory(myFilteringWindow, 4, 0)
    >>> myFactory_42.setSpectralModelFactory(mySpectralFactory)
    >>> print(myFactory_42.getSpectralModelFactory())  # doctest: +SKIP

    Estimate the ARMA process specifying a range for the orders:

    p = [1, 2, 4] and q = [4,5,6]:

    >>> pIndices = [1, 2, 4]
    >>> qIndices = [4, 5, 6]
    >>> myFactory_Range = ot.WhittleFactory(pIndices, qIndices)

    To get the quantified AICc, AIC and BIC criteria:

    >>> myARMA_42, myCriterion = myFactory_42.buildWithCriteria(ot.TimeSeries(myTimeSeries))
    >>> AICc, AIC, BIC = myCriterion[0:3]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.WhittleFactory_getClassName(self)

    def __repr__(self):
        return _model_process.WhittleFactory___repr__(self)

    def __str__(self, *args):
        return _model_process.WhittleFactory___str__(self, *args)

    def getSpectralModelFactory(self):
        r"""
        Accessor to the spectral factory.

        Returns
        -------
        initARCoeff : :class:`~openturns.SpectralModelFactory`
            The spectral factory used to estimate the spectral density based on the data.

        """
        return _model_process.WhittleFactory_getSpectralModelFactory(self)

    def setSpectralModelFactory(self, factory):
        r"""
        Accessor to the spectral factory.

        Parameters
        ----------
        spectralModelFact : :class:`~openturns.SpectralModelFactory`
            The spectral factory used to estimate the spectral density based on the data.

        """
        return _model_process.WhittleFactory_setSpectralModelFactory(self, factory)

    def build(self, *args):
        r"""
        Estimate the ARMA process.

        Available usages:
            build(*myTimeSeries*)

            build(*myProcessSample*)

        Parameters
        ----------
        myTimeSeries : :class:`~openturns.TimeSeries`
            One realization of the  process.
        myProcessSample : :class:`~openturns.ProcessSample`
            Several realizations of the  process.

        Returns
        -------
        myARMA : :class:`~openturns.ARMA`
            The  process estimated with the Whittle estimator.

        Notes
        -----
        The model selection is made using the spectral density built using the given data and theoretical spectral density of the ARMA process.

        The best ARMA process is selected according to the corrected AIC criterion.

        """
        return _model_process.WhittleFactory_build(self, *args)

    def buildWithCriteria(self, *args):
        r"""
        Estimate the ARMA process.

        Available usages:
            buildWithCriteria(*myTimeSeries*)

            buildWithCriteria(*myProcessSample*)

        Parameters
        ----------
        myTimeSeries : :class:`~openturns.TimeSeries`
            One realization of the  process.
        myProcessSample : :class:`~openturns.ProcessSample`
            Several realizations of the  process.

        Returns
        -------
        myARMA : :class:`~openturns.ARMA`
            The  process estimated with the Whittle estimator.
        criterion : :class:`~openturns.Point`
            Result of the evaluation of the AICc, AIC and BIC criteria

        Notes
        -----
        The model selection is made using the spectral density built using the given data and theoretical spectral density of the ARMA process.

        The best ARMA process is selected according to the corrected AIC criterion.
        """
        return _model_process.WhittleFactory_buildWithCriteria(self, *args)

    def enableHistory(self):
        r"""
        Activate the history of all the estimated models.

        Notes
        -----
        Activate the history mechanism which is the trace of all the tested models and their associated information criteria.

        By default, the history mechanism is activated.

        """
        return _model_process.WhittleFactory_enableHistory(self)

    def disableHistory(self):
        r"""
        Deactivate the history of all the estimated models.

        Notes
        -----
        Deactivate the history mechanism which is the trace of all the tested models and their associated information criteria.

        """
        return _model_process.WhittleFactory_disableHistory(self)

    def isHistoryEnabled(self):
        r"""
        Check whether the history mechanism is activated.

        Returns
        -------
        histMec : bool
            Check whether the history mechanism is activated.

            By default, the history mechanism is activated.

        """
        return _model_process.WhittleFactory_isHistoryEnabled(self)

    def clearHistory(self):
        r"""
        Clear the history of the factory.

        Notes
        -----
        Clear the history of the factory.

        """
        return _model_process.WhittleFactory_clearHistory(self)

    def getHistory(self):
        r"""
        Check whether the history mechanism is activated.

        Returns
        -------
        histMec : a list of :class:`~openturns.WhittleFactoryState`
            Returns the collection of all the states that have been built for the estimation.

        """
        return _model_process.WhittleFactory_getHistory(self)

    def setStartingPoints(self, startingPoints):
        r"""
        Accessor to the starting points for the optimization step.

        Parameters
        ----------
        startPointsList : a list of :class:`~openturns.Point`
            Starting points for the optimization step, for each pair of orders that will be tested.

        """
        return _model_process.WhittleFactory_setStartingPoints(self, startingPoints)

    def getStartingPoints(self):
        r"""
        Accessor to the starting points for the optimization step.

        Returns
        -------
        startPointsList : a list of :class:`~openturns.Point`
            Starting points for the optimization step, for each pair of orders that will be tested.

        """
        return _model_process.WhittleFactory_getStartingPoints(self)

    def __init__(self, *args):
        _model_process.WhittleFactory_swiginit(self, _model_process.new_WhittleFactory(*args))
    __swig_destroy__ = _model_process.delete_WhittleFactory

# Register WhittleFactory in _model_process:
_model_process.WhittleFactory_swigregister(WhittleFactory)
class ARMALikelihoodFactory(ARMAFactoryImplementation):
    r"""
    Maximum likelihood estimator of a multivariate ARMA Gaussian process.

    Available constructors:
        ARMALikelihoodFactory()

        ARMALikelihoodFactory(*p, q, d, invertible*)

        ARMALikelihoodFactory(*indP, indQ, d, invertible*)


    Parameters
    ----------
    p : int
        Order of the AR part of the :math:`ARMA(p,q)` process of dimension :math:`d`.
    q : int
        Order of the MA part of the :math:`ARMA(p,q)` process of dimension :math:`d`.
    d : int, :math:`d \geq 1`
        Dimension of the process.
    invertible : bool, optional
        Restrict the estimation to invertible ARMA processes.

        By default: True.
    indP : :class:`~openturns.Indices`
        All the :math:`p` orders that will be investigated.
        Care: not yet implemented.
    indQ : :class:`~openturns.Indices`
        All the :math:`p` orders that will be investigated.
        Care: not yet implemented.

    Notes
    -----
    We suppose here that the white noise is normal with zero mean and  covariance matrix :math:`\mat{\Sigma}_{\varepsilon} = \sigma^2\mat{Q}` where :math:`|\mat{Q}| = 1`. It implies that the ARMA process estimated is normal.

    Let :math:`(t_i, \vect{X}_i)_{0\leq i \leq n-1}` be a multivariate time series of dimension :math:`d` from an :math:`ARMA(p,q)` process. 

    If we note :math:`\vect{W} = (\vect{X}_0, \hdots, \vect{X}_{n-1})`, then :math:`\vect{W}` is normal with zero mean. Its  covariance matrix writes :math:`\mathbb{E}(\vect{W}\Tr{\vect{W}})= \sigma^2 \Sigma_{\vect{W}}` which depends on the coefficients :math:`(\mat{A}_k, \mat{B}_l)` for :math:`k = 1,\ldots,p` and :math:`l = 1,\ldots, q` and on the matrix :math:`\mat{Q}`.

    The likelihood of :math:`\vect{W}` writes :

    .. math::

        L(\vect{\beta}, \sigma^2 | \vect{W}) = (2 \pi \sigma^2) ^{-\frac{d n}{2}} |\Sigma_{w}|^{-\frac{1}{2}} \exp\left(- (2\sigma^2)^{-1}  \Tr{\vect{W}} \Sigma_{\vect{W}}^{-1}  \vect{W} \right)

    where  :math:`\vect{\beta} = (\mat{A}_{k}, \mat{B}_{l}, \mat{Q}),\ k = 1,\ldots,p`, :math:`l = 1,\ldots, q` and where  :math:`|.|` denotes the determinant.

    No evaluation of selection criteria such as AIC or BIC is done.

    Examples
    --------
    Create a time series from a scalar ARMA(4,2) and a normal white noise:

    >>> import openturns as ot
    >>> myTimeGrid = ot.RegularGrid(0.0, 0.1, 50)
    >>> myWhiteNoise = ot.WhiteNoise(ot.Triangular(-1.0, 0.0, 1.0), myTimeGrid)
    >>> myARCoef = ot.ARMACoefficients([0.4, 0.3, 0.2, 0.1])
    >>> myMACoef = ot.ARMACoefficients([0.4, 0.3])
    >>> myARMAProcess = ot.ARMA(myARCoef, myMACoef, myWhiteNoise)
    >>> myTimeSeries = myARMAProcess.getRealization()

    Estimate the ARMA process with the maximum likelihood estimator:

    >>> myFactory = ot.ARMALikelihoodFactory(4, 2, 1)
    >>> myARMA = myFactory.build(ot.TimeSeries(myTimeSeries))
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.ARMALikelihoodFactory_getClassName(self)

    def __repr__(self):
        return _model_process.ARMALikelihoodFactory___repr__(self)

    def __str__(self, *args):
        return _model_process.ARMALikelihoodFactory___str__(self, *args)

    def setInitialARCoefficients(self, phi):
        r"""
        Accessor to the initial AR coefficients.

        Parameters
        ----------
        initARCoeff : :class:`~openturns.ARMACoefficients`
            The initial AR coefficients used for the optimization algorithm.

        """
        return _model_process.ARMALikelihoodFactory_setInitialARCoefficients(self, phi)

    def setInitialMACoefficients(self, theta):
        r"""
        Accessor to the initial MA coefficients.

        Parameters
        ----------
        initMACoeff : :class:`~openturns.ARMACoefficients`
            The initial MA coefficients used for the optimization algorithm.

        """
        return _model_process.ARMALikelihoodFactory_setInitialMACoefficients(self, theta)

    def setInitialCovarianceMatrix(self, covarianceMatrix):
        r"""
        Accessor to the initial covariance matrix of the white noise.

        Parameters
        ----------
        initCovMat : :class:`~openturns.CovarianceMatrix`
            The initial covariance matrix of the white noise used for the optimization algorithm.

        """
        return _model_process.ARMALikelihoodFactory_setInitialCovarianceMatrix(self, covarianceMatrix)

    def setInitialConditions(self, arCoefficients, maCoefficients, covarianceMatrix):
        r"""
        Accessor to the initial AR coefficients.

        Parameters
        ----------
        initARCoeff : :class:`~openturns.ARMACoefficients`
            The initial AR coefficients used for the optimization algorithm.
        initMACoeff : :class:`~openturns.ARMACoefficients`
            The initial AR coefficients used for the optimization algorithm.
        initCovMatr : :class:`~openturns.CovarianceMatrix`
            The initial covariance matrix of the white noise used for the optimization algorithm.

        """
        return _model_process.ARMALikelihoodFactory_setInitialConditions(self, arCoefficients, maCoefficients, covarianceMatrix)

    def getInitialARCoefficients(self):
        r"""
        Accessor to the initial AR coefficients.

        Returns
        -------
        initARCoeff : :class:`~openturns.ARMACoefficients`
            The initial AR coefficients used for the optimization algorithm.

        """
        return _model_process.ARMALikelihoodFactory_getInitialARCoefficients(self)

    def getInitialMACoefficients(self):
        r"""
        Accessor to the initial MA coefficients.

        Returns
        -------
        initMACoeff : :class:`~openturns.ARMACoefficients`
            The initial MA coefficients used for the optimization algorithm.

        """
        return _model_process.ARMALikelihoodFactory_getInitialMACoefficients(self)

    def getInitialCovarianceMatrix(self):
        r"""
        Accessor to the initial covariance matrix of the white noise.

        Returns
        -------
        initCovMat : :class:`~openturns.CovarianceMatrix`
            The initial covariance matrix of the white noise used for the optimization algorithm.

        """
        return _model_process.ARMALikelihoodFactory_getInitialCovarianceMatrix(self)

    def build(self, *args):
        r"""
        Estimate the ARMA process.

        Available usages:
            build(*myTimeSeries*)

            build(*myProcessSample*)

        Parameters
        ----------
        myTimeSeries : :class:`~openturns.TimeSeries`
            One realization of the  process.
        myProcessSample : :class:`~openturns.ProcessSample`
            Several realizations of the  process.

        Returns
        -------
        myARMA : :class:`~openturns.ARMA`
            The  process estimated with the maximum likelihood estimator.

        """
        return _model_process.ARMALikelihoodFactory_build(self, *args)

    def __init__(self, *args):
        _model_process.ARMALikelihoodFactory_swiginit(self, _model_process.new_ARMALikelihoodFactory(*args))
    __swig_destroy__ = _model_process.delete_ARMALikelihoodFactory

# Register ARMALikelihoodFactory in _model_process:
_model_process.ARMALikelihoodFactory_swigregister(ARMALikelihoodFactory)
class _ARMAFactoryImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _model_process._ARMAFactoryImplementationTypedInterfaceObject_swiginit(self, _model_process.new__ARMAFactoryImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _model_process._ARMAFactoryImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _model_process._ARMAFactoryImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _model_process._ARMAFactoryImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _model_process._ARMAFactoryImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _model_process._ARMAFactoryImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _model_process.delete__ARMAFactoryImplementationTypedInterfaceObject

# Register _ARMAFactoryImplementationTypedInterfaceObject in _model_process:
_model_process._ARMAFactoryImplementationTypedInterfaceObject_swigregister(_ARMAFactoryImplementationTypedInterfaceObject)
class ARMAFactory(_ARMAFactoryImplementationTypedInterfaceObject):
    r"""Base class for ARMA models factory."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.ARMAFactory_getClassName(self)

    def __repr__(self):
        return _model_process.ARMAFactory___repr__(self)

    def __str__(self, *args):
        return _model_process.ARMAFactory___str__(self, *args)

    def build(self, *args):
        r"""
        Estimate the ARMA model from data.

        Available usages:
            build(*myTimeSeries*)

            build(*myProcessSample*)

        Parameters
        ----------
        myTimeSeries : :class:`~openturns.TimeSeries` 
            The time series from which the ARMA model is estimated.
        myProcessSample : :class:`~openturns.ProcessSample` 
            The sample of time series from which the ARMA model is estimated.

        Returns
        -------
        myARMA : :class:`~openturns.ARMA`
            The estimated spectral model.

        """
        return _model_process.ARMAFactory_build(self, *args)

    def __init__(self, *args):
        _model_process.ARMAFactory_swiginit(self, _model_process.new_ARMAFactory(*args))
    __swig_destroy__ = _model_process.delete_ARMAFactory

# Register ARMAFactory in _model_process:
_model_process.ARMAFactory_swigregister(ARMAFactory)
class ConditionedGaussianProcess(GaussianProcess):
    r"""
    Conditioned Gaussian process.

        ConditionedGaussianProcess(*krigingResult, mesh*)


    Parameters
    ----------
    krigingResult : :class:`~openturns.KrigingResult`
        Structure that contains all elements of kriging computations.
    mesh : :class:`~openturns.Mesh`
        Mesh :math:`\cM` over which the domain :math:`\cD` is discretized.

    Notes
    -----
    ConditionedGaussianProcess helps to create Gaussian random fields,
    :math:`X: \Omega \times\cD \mapsto \Rset^d` where :math:`\cD \in \Rset^n`, with covariance function :math:`\cC: \cD \times \cD \mapsto \cM_{d \times d}(\Rset)` ( :math:`\cC^{stat}: \cD \mapsto \cM_{d \times d}(\Rset)` in the stationary case), conditionally to some observations.

          Let :math:`X(\omega,x=x_1)=y_1,\cdots,X(\omega,x=x_n)=y_n` be the observations of the Gaussian process. We assume the same Gaussian prior as in the :class:`~openturns.KrigingAlgorithm`:

    .. math::

        Y(\vect{x}) = \Tr{\vect{f}(\vect{x})} \vect{\beta} + Z(\vect{x})

    with :math:`\Tr{\vect{f}(\vect{x})} \vect{\beta}` a general linear model, :math:`Z(\vect{x})` a zero-mean Gaussian process with a stationary autocorrelation function :math:`\cC^{stat}`:

    .. math::

        \mathbb{E}[Z(\vect{x}), Z(\vect{\tilde{x}})] = \sigma^2 \cC^{stat}_{\theta}(\vect{x} - \vect{\tilde{x}})

    The ConditionedGaussianProcess generates realizations of the conditioned process. It focuses first on the :class:`~openturns.KrigingAlgorithm` to build such prior. Results are stored in a :class:`~openturns.KrigingResult` structure, which is given as input argument of the class. This last one, combined with the mesh argument, define both the prior  :math:`Y(\cM)` and the covariance evaluation on the mesh vertices :math:`\cC^{stat}_{\theta}(\cM)` conditionally to the previous observations. It follows that the realizations are randomly generated from the Gaussian distribution :math:`\cN ( Y(\cM), \cC^{stat}_{\theta}(\cM) )`.

    In practice, we do not store the Gaussian distribution as we need only the random realization method. For that purpose, we use the Cholesky method : we compute the Cholesky factor :math:`\cL_{\theta}(\cM)` of the covariance matrix :math:`\cC^{stat}_{\theta}(\cM)` such as :math:`\cC^{stat}_{\theta}(\cM) = \cL_{\theta}(\cM) \Tr{\cL_{\theta}(\cM)}`.
    It follows that the random realizations are obtained as following : :math:`realization = Y(\cM) + \cL_{\theta}(\cM) W` with :math:`W` a centered & reduced random Gaussian realization.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # Kriging use case
    >>> # Learning data
    >>> levels = [8.0, 5.0]
    >>> box = ot.Box(levels)
    >>> inputSample = box.generate()
    >>> # Scale each direction
    >>> inputSample *= 10
    >>> # Define model
    >>> model = ot.SymbolicFunction(['x', 'y'], ['cos(0.5*x) + sin(y)'])
    >>> outputSample = model(inputSample)
    >>> # Definition of exponential model
    >>> inputDimension = 2
    >>> covarianceModel = ot.SquaredExponential([1.988, 0.924], [3.153])
    >>> # Basis definition
    >>> basis = ot.ConstantBasisFactory(inputDimension).build()
    >>> # Kriring algorithm
    >>> algo = ot.KrigingAlgorithm(inputSample, outputSample, covarianceModel, basis)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> vertices = [[1.0, 0.0], [2.0, 0.0], [2.0, 1.0], [1.0, 1.0], [1.5, 0.5]]
    >>> simplices = [[0, 1, 4], [1, 2, 4], [2, 3, 4], [3, 0, 4]]
    >>> mesh2D = ot.Mesh(vertices, simplices)
    >>> process = ot.ConditionedGaussianProcess(result, mesh2D)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.ConditionedGaussianProcess_getClassName(self)

    def __repr__(self):
        return _model_process.ConditionedGaussianProcess___repr__(self)

    def __str__(self, *args):
        return _model_process.ConditionedGaussianProcess___str__(self, *args)

    def getRealization(self):
        r"""
        Return a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            A realization of the process.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> # Kriging use case
        >>> # Learning data
        >>> levels = [8.0, 5.0]
        >>> box = ot.Box(levels)
        >>> inputSample = box.generate()
        >>> # Scale each direction
        >>> inputSample *= 10
        >>> # Define model
        >>> model = ot.SymbolicFunction(['x', 'y'], ['cos(0.5*x) + sin(y)'])
        >>> outputSample = model(inputSample)
        >>> # Definition of exponential model
        >>> inputDimension = 2
        >>> covarianceModel = ot.SquaredExponential(inputDimension *[0.95])
        >>> # Basis definition
        >>> basis = ot.ConstantBasisFactory(inputDimension).build()
        >>> # Kriring algorithm
        >>> algo = ot.KrigingAlgorithm(inputSample, outputSample, covarianceModel, basis)
        >>> algo.run()
        >>> result = algo.getResult()
        >>> vertices = [[1.0, 0.0], [2.0, 0.0], [2.0, 1.0],[1.0, 1.0], [1.5, 0.5]]
        >>> simplices = [[0, 1, 4], [1, 2, 4], [2, 3, 4], [3, 0, 4]]
        >>> mesh2D = ot.Mesh(vertices, simplices)
        >>> process = ot.ConditionedGaussianProcess(result, mesh2D)
        >>> # Get a realization of the process
        >>> realization = process.getRealization()

        """
        return _model_process.ConditionedGaussianProcess_getRealization(self)

    def isNormal(self):
        r"""
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \in \Nset` and
        :math:`I_k \in \Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\vect{m}_1, \dots, \vect{m}_k \in \Rset^d` and
        :math:`\mat{C}_{1,\dots,k}\in\mathcal{M}_{kd,kd}(\Rset)` such that:

        .. math::

            \Expect{\exp\left\{i\Tr{\vect{X}}_{I_k} \vect{U}_{k}  \right\}} =
            \exp{\left\{i\Tr{\vect{U}}_{k}\vect{M}_{k}-\frac{1}{2}\Tr{\vect{U}}_{k}\mat{C}_{1,\dots,k}\vect{U}_{k}\right\}}

        where :math:`\Tr{\vect{X}}_{I_k} = (\Tr{X}_{\vect{t}_1}, \hdots, \Tr{X}_{\vect{t}_k})`,
        :math:`\\Tr{vect{U}}_{k} = (\Tr{\vect{u}}_{1}, \hdots, \Tr{\vect{u}}_{k})` and
        :math:`\Tr{\vect{M}}_{k} = (\Tr{\vect{m}}_{1}, \hdots, \Tr{\vect{m}}_{k})` and
        :math:`\mat{C}_{1,\dots,k}` is the symmetric matrix:

        .. math::

          \mat{C}_{1,\dots,k} = \left(
          \begin{array}{cccc}
            C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \hdots & C(\vect{t}_1, \vect{t}_{k}) \\
            \hdots & C(\vect{t}_2, \vect{t}_2)  & \hdots & C(\vect{t}_2, \vect{t}_{k}) \\
            \hdots & \hdots & \hdots & \hdots \\
            \hdots & \hdots & \hdots & C(\vect{t}_{k}, \vect{t}_{k})
          \end{array}
          \right)

        A Gaussian process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _model_process.ConditionedGaussianProcess_isNormal(self)

    def isStationary(self):
        r"""
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\forall k \in \Nset`,
        :math:`\forall (\vect{t}_1, \dots, \vect{t}_k) \in \cD`,
        :math:`\forall \vect{h}\in \Rset^n`, we have:

        .. math::

            (X_{\vect{t}_1}, \dots, X_{\vect{t}_k})
            \stackrel{\mathcal{D}}{=} (X_{\vect{t}_1+\vect{h}}, \dots, X_{\vect{t}_k+\vect{h}})

        """
        return _model_process.ConditionedGaussianProcess_isStationary(self)

    def setMesh(self, mesh):
        r"""
        Set the mesh.

        Parameters
        ----------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\cD` is discretized.
        """
        return _model_process.ConditionedGaussianProcess_setMesh(self, mesh)

    def setTimeGrid(self, timeGrid):
        r"""
        Set the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of observation of the process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _model_process.ConditionedGaussianProcess_setTimeGrid(self, timeGrid)

    def setSamplingMethod(self, *args):
        r"""
        Set the used method for getRealization.

        Available parameters are :

          * 0 (GaussianProcess.CHOLESKY) : Cholesky factor sampling (default method)

          * 1 (GaussianProcess.HMAT) : H-Matrix method (if H-Mat available)

          * 2 (GaussianProcess.GALLIGAOGIBBS) : Gibbs method (in dimension 1 only)

        Parameters
        ----------
        samplingMethod : int
            Fix a method for sampling.


        """
        return _model_process.ConditionedGaussianProcess_setSamplingMethod(self, *args)

    def __init__(self, *args):
        _model_process.ConditionedGaussianProcess_swiginit(self, _model_process.new_ConditionedGaussianProcess(*args))
    __swig_destroy__ = _model_process.delete_ConditionedGaussianProcess

# Register ConditionedGaussianProcess in _model_process:
_model_process.ConditionedGaussianProcess_swigregister(ConditionedGaussianProcess)
class KarhunenLoeveQuadratureAlgorithm(openturns.algo.KarhunenLoeveAlgorithmImplementation):
    r"""
    Computation of Karhunen-Loeve decomposition using Quadrature approximation.

    Available constructors:
        KarhunenLoeveQuadratureAlgorithm(*domain, bounds, covariance, experiment, basis, basisSize, mustScale, s*)

        KarhunenLoeveQuadratureAlgorithm(*domain, bounds, covariance, marginalDegree, s*)

    Parameters
    ----------
    domain : :class:`~openturns.Domain`
        The domain on which the covariance model and the Karhunen-Loeve eigenfunctions (modes) are discretized.
    bounds : :class:`~openturns.Interval`
        Numerical bounds of the domain.
    covariance : :class:`~openturns.CovarianceModel`
        The covariance function to decompose.
    experiment : :class:`~openturns.WeightedExperiment`
        The points and weights used in the quadrature approximation.
    basis : sequence of :class:`~openturns.Function`
        The basis in which the eigenfunctions are projected.
    marginalDegree : int
        The maximum degree to take into account in the tensorized Legendre basis.
    mustScale : boolean
        Flag to tell if the bounding box of the weighted experiment and the domain have to be maped or not.
    s : float, :math:`\geq0`
        The threshold used to select the most significant eigenmodes, defined in  :class:`~openturns.KarhunenLoeveAlgorithm`.

    Notes
    -----
    The Karhunen-Loeve quadrature algorithm solves the Fredholm problem  associated to the covariance function :math:`C`: see :class:`~openturns.KarhunenLoeveAlgorithm` to get the notations.

    The Karhunen-Loeve quadrature approximation consists in replacing the integral by a quadrature approximation: if :math:`(\omega_\ell, \vect{\xi}_\ell)_{1 \leq \ell \leq L}` is the weighted experiment (see :class:`~openturns.WeightedExperiment`) associated to the measure :math:`\mu`, then for all functions measurable wrt :math:`\mu`, we have:

    .. math::

        \int_{\Rset^n} f(\vect{x}) \mu(\vect{x})\, d\vect{x} \simeq \sum_{\ell=1}^{\ell=L} \omega_\ell f(\vect{\xi}_\ell)

    If we note :math:`\eta_{\ell}=\omega_{\ell}\dfrac{1_{\cD}(\vect{\xi}_{\ell})}{\mu(\vect{\xi}_{\ell})}`, we build a more general quadrature approximation :math:`(\eta_\ell, \xi_\ell)_{1 \leq l \leq L}` such that:

    .. math::

        \int_{\cD} f(\vect{t})  \, d\vect{t} \simeq \sum_{\ell=1}^L \eta_\ell f(\vect{\xi}_\ell)

    where only the points :math:`\vect{\xi}_\ell \in \cD` are considered. 

    We introduce the matrices :math:`\mat{\Theta}=(\mat{\Theta}_{ij})_{1 \leq i \leq L, 1 \leq j \leq P} \in \cM_{Ld, Pd}(\Rset)` such that :math:`\mat{\Theta}_{ij} = \theta_{j}(\vect{\xi}_i)\mat{I}_d`, :math:`\mat{C}_{\ell, \ell'} =  \mat{C}(\vect{\xi}_{\ell},\vect{\xi}_{\ell'})` and :math:`\mat{W}= \mathrm{diag} (\mat{W}_{ii})_{1 \leq i \leq L} \in \cM_{Ld, Ld}(\Rset)` such that :math:`\mat{W}_{ii} = \eta_i \mat{I}_d`.

    The normalisation constraint :math:`\|\vect{\varphi}_k\|^2_{L^2(\cD, \Rset^d)}=1` and the orthogonality of the :math:`\vect{\varphi}_k` in :math:`L^2(\cD, \Rset^d)` leads to:

    .. math::
        :label: contNorm

          \Tr{\vect{\Phi}} \,\Tr{\mat{\Theta}} \,\mat{W}\, \mat{\Theta} \,\vect{\Phi}=\mat{I}


    The  **Galerkin** approach leads to the following generalized eigenvalue problem:

    .. math::
        :label: EqFinQuadGalerkin

         \Tr{\mat{\Theta}} \,\mat{W} \,\mat{C}  \,\mat{W} \,\mat{\Theta}\,\vect{\Phi}_k = \lambda_k  \Tr{\mat{\Theta}}\, \mat{W}\,\mat{\Theta}\,\vect{\Phi}_k

    where :math:`\Tr{\mat{\Theta}}\, \mat{W} \,\mat{C} \, \mat{W}\, \mat{\Theta}` and :math:`\Tr{\mat{\Theta}}\, \mat{W}\, \mat{\Theta}\in \cM_{Pd,Pd}(\Rset)`.

    The  **collocation** approach leads to the following generalized eigenvalue problem:

    .. math::
        :label: EqFinQuadCollocation

         \mat{C}\, \mat{W} \,\mat{\Theta}\, \vect{\Phi}_k = \lambda_k \mat{\Theta}\,\vect{\Phi}_k

    Equations :eq:`EqFinQuadGalerkin` and  :eq:`EqFinQuadCollocation` are equivalent  when :math:`\mat{\Theta}` is invertible.

    OpenTURNS solves the equation :eq:`EqFinQuadGalerkin`.

    The second constructor is a short-hand to the first one, where *basis* is the tensorized Legendre basis (see :class:`~openturns.OrthogonalProductPolynomialFactory` and :class:`~openturns.LegendreFactory`), *experiment* is a tensorized Gauss-Legendre quadrature (see :class:`~openturns.GaussProductExperiment`), *basisSize* is equal to *marginalDegree* to the power the dimension of *domain* and *mustScale* is set to *True*.


    Examples
    --------
    Discretize the domain :math:`\cD` and create a covariance model:

    >>> import openturns as ot
    >>> bounds = ot.Interval([-1.0]*2, [1.0]*2)
    >>> domain = ot.MeshDomain(ot.IntervalMesher([10]*2).build(bounds))
    >>> s = 0.01
    >>> model = ot.AbsoluteExponential([1.0]*2)

    Give the basis used to decompose the eigenfunctions: 

    here, the 10 first Legendre polynomials family:

    >>> basis = ot.OrthogonalProductPolynomialFactory([ot.LegendreFactory()]*2)
    >>> functions = [basis.build(i) for i in range(10)]

    Create the weighted experiment of the quadrature approximation: here, a Monte Carlo experiment from the measure orthogonal wrt the Legendre polynomials family:

    >>> experiment = ot.MonteCarloExperiment(basis.getMeasure(), 1000)

    Create the Karhunen-Loeve Quadrature algorithm:

    >>> algorithm = ot.KarhunenLoeveQuadratureAlgorithm(domain, bounds, model, experiment, functions, True, s)

    Run it!

    >>> algorithm.run()
    >>> result = algorithm.getResult()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.KarhunenLoeveQuadratureAlgorithm_getClassName(self)

    def run(self):
        r"""
        Computation of the eigenvalues and eigenfunctions values at the quadrature points.

        Notes
        -----
        Runs the algorithm and creates the result structure :class:`~openturns.KarhunenLoeveResult`.
        """
        return _model_process.KarhunenLoeveQuadratureAlgorithm_run(self)

    def getDomain(self):
        r"""
        Accessor to the domain.

        Returns
        -------
        domain : :class:`~openturns.Domain`
        The domain  :math:`\cD_N` that discretizes the domin :math:`\cD`.
        """
        return _model_process.KarhunenLoeveQuadratureAlgorithm_getDomain(self)

    def getExperiment(self):
        r"""
        Accessor to the points and weights of the quadrature approximation.

        Returns
        -------
        experiment : :class:`~openturns.WeightedExperiment`
            The points and weights used in the quadrature approximation.
        """
        return _model_process.KarhunenLoeveQuadratureAlgorithm_getExperiment(self)

    def getBasis(self):
        r"""
        Accessor to the functional basis.

        Returns
        -------
        basis : :class:`~openturns.Basis`
            The basis in which the eigenfunctions are projected.
        """
        return _model_process.KarhunenLoeveQuadratureAlgorithm_getBasis(self)

    def getMustScale(self):
        r"""
        Accessor to scale option.

        Returns
        -------
        mustScale : boolean
            Flag to tell if the bounding box of the weighted experiment and the domain have to be maped or not.
        """
        return _model_process.KarhunenLoeveQuadratureAlgorithm_getMustScale(self)

    def __repr__(self):
        return _model_process.KarhunenLoeveQuadratureAlgorithm___repr__(self)

    def __str__(self, *args):
        return _model_process.KarhunenLoeveQuadratureAlgorithm___str__(self, *args)

    def __init__(self, *args):
        _model_process.KarhunenLoeveQuadratureAlgorithm_swiginit(self, _model_process.new_KarhunenLoeveQuadratureAlgorithm(*args))
    __swig_destroy__ = _model_process.delete_KarhunenLoeveQuadratureAlgorithm

# Register KarhunenLoeveQuadratureAlgorithm in _model_process:
_model_process.KarhunenLoeveQuadratureAlgorithm_swigregister(KarhunenLoeveQuadratureAlgorithm)
class KarhunenLoeveSVDAlgorithm(openturns.algo.KarhunenLoeveAlgorithmImplementation):
    r"""
    Computation of Karhunen-Loeve decomposition using SVD approximation.

    Available constructors:
        KarhunenLoeveSVDAlgorithm(*sample, threshold, centeredSample*)

        KarhunenLoeveSVDAlgorithm(*sample, verticesWeights, threshold, centeredSample*)

        KarhunenLoeveSVDAlgorithm(*sample, verticesWeights, sampleWeights, threshold, centeredSample*)

    Parameters
    ----------
    sample : :class:`~openturns.ProcessSample`
        The sample containing the observations.
    verticesWeights : sequence of float
        The weights associated to the vertices of the mesh defining the sample.
    sampleWeights : sequence of float
        The weights associated to the fields of the sample.
    threshold : positive float, default=0.0
        The threshold used to select the most significant eigenmodes, defined in :class:`~openturns.KarhunenLoeveAlgorithm`.
    centeredSample : bool, default=False
        Flag to tell if the sample is drawn according to a centered
        process or if it has to be centered using the empirical mean.

    Notes
    -----
    The Karhunen-Loeve SVD algorithm solves the Fredholm problem associated to the
    covariance function :math:`C`: see :class:`~openturns.KarhunenLoeveAlgorithm`
    to get the notations.
    If the mesh is regular, then this decomposition is equivalent to the principal
    component analysis (PCA) (see [pearson1907]_, [hotelling1933]_, [jackson1991]_, [jolliffe2002]_).
    In other fields such as computational fluid dynamics for example,
    this is called proper orthogonal decomposition (POD) (see [luo2018]_).

    The SVD approach is a particular case of the quadrature approach (see
    :class:`~openturns.KarhunenLoeveQuadratureAlgorithm`)  where we consider the
    functional basis  :math:`((\vect{\theta}_p^j(\vect{s}))_{1 \leq j \leq d, 1 \leq p \leq P}` of
    :math:`L^2(\cD, \Rset^d)` defined on :math:`\cD` by:

    .. math:: 

        \vect{\theta}_p^j(\vect{s})= \left[\mat{C}(\vect{s}, \vect{s}_p) \right]_{:, j}

    The SVD approach is used when the covariance function is not explicitly known but only
    through :math:`K` fields :math:`(\vect{X}_1, \dots, \vect{X}_K)`  respectively
    associated to the weights :math:`p_1, \dots, p_K`. The weights are not necessarily all equal
    when, for example, the fields have been generated from an importance sampling technique.

    The SVD approach consists in approximating :math:`\mat{C}` by its empirical estimator computed from the :math:`K` fields
    which have been centered and in taking the :math:`L` vertices of the mesh of :math:`\vect{X}` as
    the :math:`L` quadrature points to compute the integrals of the Fredholm problem.

    We denote by :math:`(\tilde{\vect{X}}_1, \dots, \tilde{\vect{X}}_K` the centered fields. If the mean process is not known,
    it is approximated by :math:`\sum_{k=1}^K p_k \vect{X}_k`.

    The empirical estimator of :math:`\mat{C}` is then defined by:

    .. math::

        \tilde{\mat{C}}_K = \sum_{k=1}^K \tilde{p}_k \vect{X}_k  \Tr{\vect{X}_k}

    where :math:`\widetilde{K} = p_k` if the :math:`\vect{X}_k` are already centered or
    if the mean process is known, and :math:`\widetilde{K} = \dfrac{K}{K-1}p_k` if the mean
    process has been estimated from the :math:`K` fields.

    We suppose now that :math:`K < Ld`, and we note :math:`\mat{Y} = \sqrt{\mat{W}} \,\mat{X}` and
    :math:`\mat{\Psi}_k = \sqrt{\mat{W}}^{-1} \,\mat{\Phi}_k` (see
    :class:`~openturns.KarhunenLoeveQuadratureAlgorithm`).

    As the matrix :math:`\mat{\Theta} = \mat{C}` is nonsingular, the Galerkin and collocation
    approaches are equivalent and both lead to the following singular value problem for :math:`\mat{Y}`:

    .. math::
        :label: QuadCollDim1_ter

         \mat{Y}\,\Tr{\mat{Y}}\,\mat{\Psi}_k  & = \lambda_k \mat{\Psi}_k.

    The SVD decomposition of :math:`\mat{Y}\in \mathcal{M}_{Ld,\widetilde{K}}(\Rset)` is:

    .. math::

        \mat{Y} = \mat{U}\, \mat{\Sigma} \, \Tr{\mat{V}}

    where  the matrices :math:`\mat{U} \in \mathcal{M}_{Ld, \widetilde{K}}(\Rset)`, 
    :math:`\mat{\Sigma}\in \mathcal{M}_{\widetilde{K},\widetilde{K}}(\Rset)`, 
    :math:`\mat{V} \in \mathcal{M}_{\widetilde{K},\widetilde{K}}(\Rset)` are such that :

    - :math:`\Tr{\mat{V}}\mat{V} =\mat{V}\Tr{\mat{V}}= \mat{I}_{\widetilde{K}}`,  
    - :math:`\Tr{\mat{U}}\mat{U} = \mat{I}_{\widetilde{K}}` ,
    - :math:`\mat{\Sigma} = \diag(\sigma_1, \dots, \sigma_{\widetilde{K}})`.

    Then the columns of :math:`\mat{U}` are the eigenvectors of :math:`\mat{Y}\Tr{\mat{Y}}`
    associated to the eigenvalues :math:`\sigma_k^2`.

    We deduce the modes and eigenvalues of the Fredholm problem for :math:`k \leq \widetilde{K}`:

    .. math::

          \mat{\Phi}_k & = \dfrac{1}{\lambda_k} \sqrt{\mat{W}}\, \mat{U}_k \\
          \lambda_k & = \dfrac{\sigma_k^2}{\widetilde{K}}.

    For :math:`k \leq \widetilde{K}`, we have:

    .. math::

        \widetilde{\vect{\varphi}}_k(\vect{t})= \sum_{\ell=1}^L  C(\vect{t}, \vect{\xi}_\ell) \vect{\phi}_{\ell,k} 

    The most computationally intensive part of the algorithm is the computation of the
    SVD decomposition. By default, it is done using LAPACK dgesdd routine. While being
    very accurate and reasonably fast for small to medium sized problems, it becomes
    prohibitively slow for large cases. The user can choose to use a stochastic
    algorithm instead, with the constraint that the number of singular values to be
    computed has to be fixed a priori.
    The following keys of :class:`~openturns.ResourceMap` allow one to select and tune
    these algorithms:

    - 'KarhunenLoeveSVDAlgorithm-UseRandomSVD' which triggers the use of a random
      algorithm. By default, it is set to *False* and LAPACK is used.
    - 'KarhunenLoeveSVDAlgorithm-RandomSVDMaximumRank' which fixes the number of
      singular values to compute. By default it is set to 1000.	
    - 'KarhunenLoeveSVDAlgorithm-RandomSVDVariant' which can be equal to either
      'Halko2010' for [halko2010]_ (the default) or 'Halko2011' for [halko2011]_.
      These two algorithms have very similar structures, the first one being based
      on a random compression of both the rows and columns of :math:`\mat{Y}`, the
      second one being based on an iterative compressed sampling of the columns of
      :math:`\mat{Y}`.
    - 'KarhunenLoeveSVDAlgorithm-halko2011Margin' and
      'KarhunenLoeveSVDAlgorithm-halko2011Iterations' to fix the parameters of the
      'halko2011' variant. See [halko2011]_ for the details.


    Examples
    --------
    Create a Karhunen-Loeve SVD algorithm:

    >>> import openturns as ot
    >>> mesh = ot.IntervalMesher([10]*2).build(ot.Interval([-1.0]*2, [1.0]*2))
    >>> s = 0.01
    >>> model = ot.AbsoluteExponential([1.0]*2)
    >>> sample = ot.GaussianProcess(model, mesh).getSample(8)
    >>> algorithm = ot.KarhunenLoeveSVDAlgorithm(sample, s)

    Run it!

    >>> algorithm.run()
    >>> result = algorithm.getResult()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _model_process.KarhunenLoeveSVDAlgorithm_getClassName(self)

    def run(self):
        r"""
        Computation of the eigenvalues and eigenfunctions values at nodes.

        Notes
        -----
        Runs the algorithm and creates the result structure :class:`~openturns.KarhunenLoeveResult`.

        """
        return _model_process.KarhunenLoeveSVDAlgorithm_run(self)

    def getSample(self):
        r"""
        Accessor to the process sample.

        Returns
        -------
        sample : :class:`~openturns.ProcessSample`
            The process sample containing the observations of the process.

        """
        return _model_process.KarhunenLoeveSVDAlgorithm_getSample(self)

    def getVerticesWeights(self):
        r"""
        Accessor to the weights of the vertices.

        Returns
        -------
        weights : :class:`~openturns.Point`
            The weights associated to the vertices of the mesh defining the sample field.

        Notes
        -----
        The vertices might not have the same weight, for example if the mesh is not regular.

        """
        return _model_process.KarhunenLoeveSVDAlgorithm_getVerticesWeights(self)

    def getSampleWeights(self):
        r"""
        Accessor to the weights of the sample.

        Returns
        -------
        weights : :class:`~openturns.Point`
            The weights associated to the fields of the sample.

        Notes
        -----
        The fields might not have the same weight, for example if they come from importance sampling.

        """
        return _model_process.KarhunenLoeveSVDAlgorithm_getSampleWeights(self)

    def getCovarianceModel(self):
        r"""
        Accessor to the covariance model.

        Returns
        -------
        covModel : :class:`~openturns.CovarianceModel`
            The covariance model.
        """
        return _model_process.KarhunenLoeveSVDAlgorithm_getCovarianceModel(self)

    def __repr__(self):
        return _model_process.KarhunenLoeveSVDAlgorithm___repr__(self)

    def __str__(self, *args):
        return _model_process.KarhunenLoeveSVDAlgorithm___str__(self, *args)

    def __init__(self, *args):
        _model_process.KarhunenLoeveSVDAlgorithm_swiginit(self, _model_process.new_KarhunenLoeveSVDAlgorithm(*args))
    __swig_destroy__ = _model_process.delete_KarhunenLoeveSVDAlgorithm

# Register KarhunenLoeveSVDAlgorithm in _model_process:
_model_process.KarhunenLoeveSVDAlgorithm_swigregister(KarhunenLoeveSVDAlgorithm)

