"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const expect_1 = __importDefault(require("expect"));
const jestMock = __importStar(require("jest-mock"));
const testUtil_1 = require("../testUtil");
const NvimPlugin_1 = require("./NvimPlugin");
describe('NvimPlugin', () => {
    it('should initialise variables', () => {
        const fakeNvimClient = (0, testUtil_1.getFakeNvimClient)();
        const plugin = new NvimPlugin_1.NvimPlugin('/tmp/filename', () => { }, fakeNvimClient);
        (0, expect_1.default)(plugin.filename).toEqual('/tmp/filename');
        (0, expect_1.default)(plugin.nvim).toEqual(fakeNvimClient);
        (0, expect_1.default)(plugin.dev).toBe(false);
        (0, expect_1.default)(Object.keys(plugin.autocmds)).toHaveLength(0);
        (0, expect_1.default)(Object.keys(plugin.commands)).toHaveLength(0);
        (0, expect_1.default)(Object.keys(plugin.functions)).toHaveLength(0);
    });
    it('should set dev options when you call setOptions', () => {
        const plugin = new NvimPlugin_1.NvimPlugin('/tmp/filename', () => { }, (0, testUtil_1.getFakeNvimClient)());
        plugin.setOptions({ dev: true });
        (0, expect_1.default)(plugin.dev).toBe(true);
        (0, expect_1.default)(plugin.shouldCacheModule).toBe(false);
    });
    it('should store registered autocmds', () => {
        const plugin = new NvimPlugin_1.NvimPlugin('/tmp/filename', () => { }, (0, testUtil_1.getFakeNvimClient)());
        const fn = () => { };
        const opts = { pattern: '*' };
        const spec = {
            name: 'BufWritePre',
            type: 'autocmd',
            sync: false,
            opts,
        };
        plugin.registerAutocmd('BufWritePre', fn, opts);
        (0, expect_1.default)(Object.keys(plugin.autocmds)).toHaveLength(1);
        (0, expect_1.default)(plugin.autocmds['BufWritePre *']).toEqual({ fn, spec });
    });
    it('should store registered commands', () => {
        const plugin = new NvimPlugin_1.NvimPlugin('/tmp/filename', () => { }, (0, testUtil_1.getFakeNvimClient)());
        const fn = () => { };
        const opts = { sync: true };
        const spec = {
            name: 'MyCommand',
            type: 'command',
            sync: true,
            opts: {},
        };
        plugin.registerCommand('MyCommand', fn, opts);
        (0, expect_1.default)(Object.keys(plugin.commands)).toHaveLength(1);
        (0, expect_1.default)(plugin.commands.MyCommand).toEqual({ fn, spec });
    });
    it('should store registered functions', () => {
        const plugin = new NvimPlugin_1.NvimPlugin('/tmp/filename', () => { }, (0, testUtil_1.getFakeNvimClient)());
        const fn = () => { };
        const opts = { sync: true };
        const spec = {
            name: 'MyFunction',
            type: 'function',
            sync: true,
            opts: {},
        };
        plugin.registerFunction('MyFunction', fn, opts);
        (0, expect_1.default)(Object.keys(plugin.functions)).toHaveLength(1);
        (0, expect_1.default)(plugin.functions.MyFunction).toEqual({ fn, spec });
    });
    it('should not add autocmds with no pattern option', () => {
        const plugin = new NvimPlugin_1.NvimPlugin('/tmp/filename', () => { }, (0, testUtil_1.getFakeNvimClient)());
        plugin.registerAutocmd('BufWritePre', () => { }, { pattern: '' });
        (0, expect_1.default)(Object.keys(plugin.autocmds)).toHaveLength(0);
    });
    it('should create functions from callable arrays', () => {
        const fn = jestMock.fn(function () {
            // @ts-expect-error intentional
            return this;
        });
        (0, expect_1.default)((0, NvimPlugin_1.callable)(fn)).toEqual(fn);
        (0, NvimPlugin_1.callable)([{}, fn])();
        (0, expect_1.default)(fn).toHaveBeenCalledTimes(1);
        const thisObj = {};
        (0, expect_1.default)((0, NvimPlugin_1.callable)([thisObj, fn])()).toBe(thisObj);
        const plugin = new NvimPlugin_1.NvimPlugin('/tmp/filename', () => { }, (0, testUtil_1.getFakeNvimClient)());
        const obj = {
            func: jestMock.fn(function () {
                // @ts-expect-error intentional
                return this;
            }),
        };
        plugin.registerCommand('MyCommand', [obj, obj.func], {});
        const thisObject = plugin.commands.MyCommand.fn('arg1', 'arg2');
        (0, expect_1.default)(obj.func).toHaveBeenCalledWith('arg1', 'arg2');
        (0, expect_1.default)(thisObject).toBe(obj);
    });
    it('should not register commands with incorrect callable arguments', () => {
        const plugin = new NvimPlugin_1.NvimPlugin('/tmp/filename', () => { }, (0, testUtil_1.getFakeNvimClient)());
        // @ts-expect-error Intentionally passing empty array for command arguments.
        plugin.registerCommand('MyCommand', [], {});
        (0, expect_1.default)(Object.keys(plugin.commands)).toHaveLength(0);
    });
    it('should return specs for registered commands', () => {
        const plugin = new NvimPlugin_1.NvimPlugin('/tmp/filename', () => { }, (0, testUtil_1.getFakeNvimClient)());
        const fn = () => { };
        const aOpts = { pattern: '*' };
        const aSpec = {
            name: 'BufWritePre',
            type: 'autocmd',
            sync: false,
            opts: aOpts,
        };
        plugin.registerAutocmd('BufWritePre', fn, aOpts);
        const cOpts = { sync: true };
        const cSpec = {
            name: 'MyCommand',
            type: 'command',
            sync: true,
            opts: {},
        };
        plugin.registerCommand('MyCommand', fn, cOpts);
        const fOpts = { sync: true };
        const fSpec = {
            name: 'MyFunction',
            type: 'function',
            sync: true,
            opts: {},
        };
        plugin.registerFunction('MyFunction', fn, fOpts);
        (0, expect_1.default)(plugin.specs).toEqual([aSpec, cSpec, fSpec]);
    });
    it('should handle requests for registered commands', () => __awaiter(void 0, void 0, void 0, function* () {
        const plugin = new NvimPlugin_1.NvimPlugin('/tmp/filename', () => { }, (0, testUtil_1.getFakeNvimClient)());
        const fn = (arg) => arg;
        plugin.registerAutocmd('BufWritePre', fn, { pattern: '*', sync: true });
        plugin.registerCommand('MyCommand', fn, { sync: true });
        plugin.registerFunction('MyFunction', fn);
        (0, expect_1.default)(yield plugin.handleRequest('BufWritePre *', 'autocmd', [true])).toBe(true);
        (0, expect_1.default)(yield plugin.handleRequest('MyCommand', 'command', [false])).toBe(false);
        (0, expect_1.default)(yield plugin.handleRequest('MyFunction', 'function', ['blue'])).toEqual('blue');
    }));
    it('should throw on unknown request', () => {
        const plugin = new NvimPlugin_1.NvimPlugin('/tmp/filename', () => { }, (0, testUtil_1.getFakeNvimClient)());
        expect_1.default.assertions(1);
        plugin.handleRequest('BufWritePre *', 'autocmd', [true]).catch(err => {
            (0, expect_1.default)(err).toEqual(new Error('Missing handler for autocmd: "BufWritePre *" in /tmp/filename'));
        });
    });
});
