#ifndef _BIGINTEGER_H_INCLUDED_
#define _BIGINTEGER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// BigInteger.h
// ------------
// BigInteger class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
// 
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: BigInteger 
// 
// Description: BigInteger class arbitrary decimal values
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include "Chain.h"

class BigInteger {

public:
    
    BigInteger();
    BigInteger(const BigInteger& bi);
    BigInteger(const Chain& s);
    ~BigInteger();

    BigInteger abs() const;
    bool isPositive() const;
    void negate();

    BigInteger add(const BigInteger& d) const;
    BigInteger sub(const BigInteger& d) const;
    BigInteger mul(const BigInteger& d) const;
    BigInteger div(const BigInteger& d) const;

    int length() const;
    int getDigit(int i) const;

    
    Chain toChain() const;
    
    BigInteger& operator = ( const BigInteger& d);
    BigInteger& operator += ( const BigInteger& d);
    BigInteger& operator -= ( const BigInteger& d);
    bool operator == ( const BigInteger& d) const;
    bool operator != ( const BigInteger& d) const;
    bool operator < ( const BigInteger& d) const;
    bool operator > ( const BigInteger& d) const;
    bool operator <= ( const BigInteger& d) const;
    bool operator >= ( const BigInteger& d) const;

    friend BigInteger operator + ( const BigInteger& d1, const BigInteger& d2);
    friend BigInteger operator - ( const BigInteger& d1, const BigInteger& d2);
    friend BigInteger operator * ( const BigInteger& d1, const BigInteger& d2);
    friend BigInteger operator / ( const BigInteger& d1, const BigInteger& d2);

    friend ostream& operator << (ostream& s, const  BigInteger& d);
    
private:

    BigInteger mulDigit(int f) const;

    bool _isPositive;
    Chain _val;
};
#endif



