#ifndef _GETLONGOPT_H_INCLUDED_
#define _GETLONGOPT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// GetLongOpt.h
// ------------
// GetLongOpt class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: GetLongOpt
// 
// Description: Handling long arguments from the command line
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include "Chain.h"
#include "SetT.h"

class GetLongOpt {
    
public:
    
  GetLongOpt(int argc, char** argv);  
  ~GetLongOpt();

  void addOpt(const Chain& opt);
  void addOpt(const Chain& opt, const Chain& defVal);
  Chain getOptValue(const Chain& opt);
  bool isSet(const Chain& opt);
  void parseOpt();

private:
  
  class OptHash {
      
  public:
      
      OptHash()
      {
      }

      OptHash(const Chain& opt)
      {
	  _opt = opt;
	  _isSet = false;
      }
      
      OptHash(const Chain& opt, const Chain& val)
      {
	  _opt = opt;
	  _val = val;
	  _isSet = false;
      }
      
      ~OptHash()
      {
      }
    
      void set()
      {
	  _isSet = true;
      }

      bool isSet()
      {
	  return _isSet;
      }
      
      void setValue(const Chain& val)
      {
	  _val = val;
      }

      const Chain& getValue()
      {
	  return _val;
      }

      bool operator == (const OptHash& oh) const
      {
	  if ( _opt == oh._opt )
	      return true;
	  return false;
      }
      
      OptHash& operator = (const OptHash& oh)
      {
	  _opt = oh._opt;
	  _val = oh._val;
	  _isSet = oh._isSet;
	  return (*this);
      }
      
  private:
      
      Chain _opt;
      Chain _val;
      bool _isSet;
  };
    
  SetT<OptHash> _optHash;

  bool _isParsed;
  int _argc;
  char **_argv;

};
#endif
