// Generated by gmmproc 2.49.4 -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_GUTTERRENDERER_H
#define _GTKSOURCEVIEWMM_GUTTERRENDERER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gutterrenderer.h
 *
 * Copyright (C) 2010, 2011 Krzesimir Nowak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/// \file
/// \brief GutterRenderer class

#include <gtkmm/object.h>
#include <gtkmm/tooltip.h>
#include <gtksourceviewmm/view.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkSourceGutterRenderer = struct _GtkSourceGutterRenderer;
using GtkSourceGutterRendererClass = struct _GtkSourceGutterRendererClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gsv
{ class GutterRenderer_Class; } // namespace Gsv
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gsv
{

/** @addtogroup gtksourceviewmmEnums gtksourceviewmm Enums and Flags */

/** 
 *  @var GutterRendererState GUTTER_RENDERER_STATE_NORMAL
 * Normal state.
 * 
 *  @var GutterRendererState GUTTER_RENDERER_STATE_CURSOR
 * Area in the renderer represents the
 * line on which the insert cursor is currently positioned.
 * 
 *  @var GutterRendererState GUTTER_RENDERER_STATE_PRELIT
 * The mouse pointer is currently
 * over the activatable area of the renderer.
 * 
 *  @var GutterRendererState GUTTER_RENDERER_STATE_SELECTED
 * Area in the renderer represents
 * a line in the buffer which contains part of the selection.
 * 
 *  @enum GutterRendererState
 *
 * @ingroup gtksourceviewmmEnums
 * @par Bitwise operators:
 * <tt>%GutterRendererState operator|(GutterRendererState, GutterRendererState)</tt><br>
 * <tt>%GutterRendererState operator&(GutterRendererState, GutterRendererState)</tt><br>
 * <tt>%GutterRendererState operator^(GutterRendererState, GutterRendererState)</tt><br>
 * <tt>%GutterRendererState operator~(GutterRendererState)</tt><br>
 * <tt>%GutterRendererState& operator|=(GutterRendererState&, GutterRendererState)</tt><br>
 * <tt>%GutterRendererState& operator&=(GutterRendererState&, GutterRendererState)</tt><br>
 * <tt>%GutterRendererState& operator^=(GutterRendererState&, GutterRendererState)</tt><br>
 */
enum GutterRendererState
{
  GUTTER_RENDERER_STATE_NORMAL = 0x0,
  GUTTER_RENDERER_STATE_CURSOR = 1 << 0,
  GUTTER_RENDERER_STATE_PRELIT = 1 << 1,
  GUTTER_RENDERER_STATE_SELECTED = 1 << 2
};

/** @ingroup gtksourceviewmmEnums */
inline GutterRendererState operator|(GutterRendererState lhs, GutterRendererState rhs)
  { return static_cast<GutterRendererState>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline GutterRendererState operator&(GutterRendererState lhs, GutterRendererState rhs)
  { return static_cast<GutterRendererState>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline GutterRendererState operator^(GutterRendererState lhs, GutterRendererState rhs)
  { return static_cast<GutterRendererState>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline GutterRendererState operator~(GutterRendererState flags)
  { return static_cast<GutterRendererState>(~static_cast<unsigned>(flags)); }

/** @ingroup gtksourceviewmmEnums */
inline GutterRendererState& operator|=(GutterRendererState& lhs, GutterRendererState rhs)
  { return (lhs = static_cast<GutterRendererState>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtksourceviewmmEnums */
inline GutterRendererState& operator&=(GutterRendererState& lhs, GutterRendererState rhs)
  { return (lhs = static_cast<GutterRendererState>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtksourceviewmmEnums */
inline GutterRendererState& operator^=(GutterRendererState& lhs, GutterRendererState rhs)
  { return (lhs = static_cast<GutterRendererState>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gsv

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gsv::GutterRendererState> : public Glib::Value_Flags<Gsv::GutterRendererState>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gsv
{


/** 
 *  @var GutterRendererAlignmentMode GUTTER_RENDERER_ALIGNMENT_MODE_CELL
 * The full cell.
 * 
 *  @var GutterRendererAlignmentMode GUTTER_RENDERER_ALIGNMENT_MODE_FIRST
 * The first line.
 * 
 *  @var GutterRendererAlignmentMode GUTTER_RENDERER_ALIGNMENT_MODE_LAST
 * The last line.
 * 
 *  @enum GutterRendererAlignmentMode
 * 
 * The alignment mode of the renderer, when a cell spans multiple lines (due to
 * text wrapping).
 *
 * @ingroup gtksourceviewmmEnums
 */
enum GutterRendererAlignmentMode
{
  GUTTER_RENDERER_ALIGNMENT_MODE_CELL,
  GUTTER_RENDERER_ALIGNMENT_MODE_FIRST,
  GUTTER_RENDERER_ALIGNMENT_MODE_LAST
};

} // namespace Gsv

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gsv::GutterRendererAlignmentMode> : public Glib::Value_Enum<Gsv::GutterRendererAlignmentMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gsv
{


// TODO: write docs.

class GutterRenderer : public Gtk::Object
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef GutterRenderer CppObjectType;
  typedef GutterRenderer_Class CppClassType;
  typedef GtkSourceGutterRenderer BaseObjectType;
  typedef GtkSourceGutterRendererClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  GutterRenderer(GutterRenderer&& src) noexcept;
  GutterRenderer& operator=(GutterRenderer&& src) noexcept;

  // noncopyable
  GutterRenderer(const GutterRenderer&) = delete;
  GutterRenderer& operator=(const GutterRenderer&) = delete;

  ~GutterRenderer() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class GutterRenderer_Class;
  static CppClassType gutterrenderer_class_;

protected:
  explicit GutterRenderer(const Glib::ConstructParams& construct_params);
  explicit GutterRenderer(GtkSourceGutterRenderer* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkSourceGutterRenderer*       gobj()       { return reinterpret_cast<GtkSourceGutterRenderer*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkSourceGutterRenderer* gobj() const { return reinterpret_cast<GtkSourceGutterRenderer*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_query_tooltip().
  virtual bool on_query_tooltip(const Gtk::TextIter& iter, const Gdk::Rectangle& area, int x, int y, const Glib::RefPtr<Gtk::Tooltip>& tooltip);
  /// This is a default handler for the signal signal_activate().
  virtual void on_activate(const Gtk::TextIter& iter, const Gdk::Rectangle& area, GdkEvent* event);
  /// This is a default handler for the signal signal_queue_draw().
  virtual void on_queue_draw();
  /// This is a default handler for the signal signal_query_data().
  virtual void on_query_data(const Gtk::TextIter& start, const Gtk::TextIter& end, GutterRendererState state);
  /// This is a default handler for the signal signal_query_activatable().
  virtual bool on_query_activatable(const Gtk::TextIter& iter, const Gdk::Rectangle& area, GdkEvent* event);


private:

public:
 

  /** Called when drawing a region begins. The region to be drawn is indicated
   * by @a start and @a end. The purpose is to allow the implementation to precompute
   * some state before the draw method is called for each cell.
   * 
   * @param cr A #cairo_t.
   * @param background_area A Gdk::Rectangle.
   * @param cell_area A Gdk::Rectangle.
   * @param start A Gtk::TextIter.
   * @param end A Gtk::TextIter.
   */
  void begin(const Cairo::RefPtr<Cairo::Context>& cr, const Gdk::Rectangle& background_area, const Gdk::Rectangle& cell_area, Gtk::TextIter& start, Gtk::TextIter& end);

  
  /** Main renderering method. Implementations should implement this method to draw
   * onto the cairo context. The @a background_area indicates the total area of the
   * cell to be drawn. The @a cell_area indicates the area where content can be
   * drawn (text, images, etc).
   * 
   * The @a background_area is the @a cell_area plus the padding on each side (two
   * times the Gtk::SourceGutterRenderer::property_xpad() horizontally and two times the
   * Gtk::SourceGutterRenderer::property_ypad() vertically, so that the @a cell_area is centered
   * inside @a background_area).
   * 
   * The @a p6 argument indicates the current state of the renderer and should
   * be taken into account to properly draw the different possible states
   * (cursor, prelit, selected) if appropriate.
   * 
   * @param cr The cairo render context.
   * @param background_area A Gdk::Rectangle indicating the total area to be drawn.
   * @param cell_area A Gdk::Rectangle indicating the area to draw content.
   * @param start A Gtk::TextIter.
   * @param end A Gtk::TextIter.
   * @param p6 A Gtk::SourceGutterRendererState.
   */
  void draw(const Cairo::RefPtr<Cairo::Context>& cr, const Gdk::Rectangle& background_area, const Gdk::Rectangle& cell_area, Gtk::TextIter& start, Gtk::TextIter& end, GutterRendererState p6);

  
  /** Called when drawing a region of lines has ended.
   */
  void end();

  
  /** Get the size of the renderer.
   * 
   * @return The size of the renderer.
   */
  int get_size() const;

  
  /** Sets the size of the renderer. A value of -1 specifies that the size
   * is to be determined dynamically.
   * 
   * @param size The size.
   */
  void set_size(int size);

  
  /** Get whether the gutter renderer is visible.
   * 
   * @return <tt>true</tt> if the renderer is visible, <tt>false</tt> otherwise.
   */
  bool get_visible() const;

  
  /** Set whether the gutter renderer is visible.
   * 
   * @param visible The visibility.
   */
  void set_visible(bool visible);

// TODO: write padding class. krnowak

  
  /** Get the x-padding and y-padding of the gutter renderer.
   * 
   * @param xpad Return location for the x-padding,
   * or <tt>nullptr</tt> to ignore.
   * @param ypad Return location for the y-padding,
   * or <tt>nullptr</tt> to ignore.
   */
  void get_padding(int& xpad, int& ypad) const;

  
  /** Set the padding of the gutter renderer. Both @a xpad and @a ypad can be
   * -1, which means the values will not be changed (this allows changing only
   * one of the values).
   * 
   *  @a xpad is the left and right padding. @a ypad is the top and bottom padding.
   * 
   * @param xpad The x-padding.
   * @param ypad The y-padding.
   */
  void set_padding(int xpad, int ypad);

// TODO: write alignment class. krnowak

  
  /** Get the x-alignment and y-alignment of the gutter renderer.
   * 
   * @param xalign Return location for the x-alignment,
   * or <tt>nullptr</tt> to ignore.
   * @param yalign Return location for the y-alignment,
   * or <tt>nullptr</tt> to ignore.
   */
  void get_alignment(float& xalign, float& yalign) const;

  
  /** Set the alignment of the gutter renderer. Both @a xalign and @a yalign can be
   * -1, which means the values will not be changed (this allows changing only
   * one of the values).
   * 
   *  @a xalign is the horizontal alignment. Set to 0 for a left alignment. 1 for a
   * right alignment. And 0.5 for centering the cells. @a yalign is the vertical
   * alignment. Set to 0 for a top alignment. 1 for a bottom alignment.
   * 
   * @param xalign The x-alignment.
   * @param yalign The y-alignment.
   */
  void set_alignment(float xalign, float yalign);

  
  /** Get the alignment mode. The alignment mode describes the manner in which the
   * renderer is aligned (see :xalign and :yalign).
   * 
   * @return A Gtk::SourceGutterRendererAlignmentMode.
   */
  GutterRendererAlignmentMode get_alignment_mode() const;

  
  /** Set the alignment mode. The alignment mode describes the manner in which the
   * renderer is aligned (see :xalign and :yalign).
   * 
   * @param mode A Gtk::SourceGutterRendererAlignmentMode.
   */
  void set_alignment_mode(GutterRendererAlignmentMode mode);

  
  /** Get the Gtk::TextWindowType associated with the gutter renderer.
   * 
   * @return A Gtk::TextWindowType.
   */
  Gtk::TextWindowType get_window_type() const;

 
  /** Get the view associated to the gutter renderer
   * 
   * @return A Gtk::TextView.
   */
  Gtk::TextView* get_view();

  
  /** Get the view associated to the gutter renderer
   * 
   * @return A Gtk::TextView.
   */
  const Gtk::TextView* get_view() const;

// TODO: use std::pair? krnowak

 
  /** Get the background color of the renderer.
   * 
   * @param color Return value for a Gdk::RGBA.
   * @return <tt>true</tt> if the background color is set, <tt>false</tt> otherwise.
   */
  bool get_background(Gdk::RGBA& color) const;

  bool is_background_set() const;

 
  /** Set the background color of the renderer. If @a color is set to <tt>nullptr</tt>, the
   * renderer will not have a background color.
   * 
   * @param color A Gdk::RGBA or <tt>nullptr</tt>.
   */
  void set_background(const Gdk::RGBA& color);

  
  /** Emits the Gtk::SourceGutterRenderer::signal_queue_draw() signal of the renderer. Call
   * this from an implementation to inform that the renderer has changed such that
   * it needs to redraw.
   */
  void queue_draw();

  /** Visible.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_visible() ;

/** Visible.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_visible() const;

  /** The x-padding.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_xpad() ;

/** The x-padding.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_xpad() const;

  /** The y-padding.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_ypad() ;

/** The y-padding.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_ypad() const;

  /** The x-alignment.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< float > property_xalign() ;

/** The x-alignment.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float > property_xalign() const;

  /** The y-alignment.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< float > property_yalign() ;

/** The y-alignment.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float > property_yalign() const;

  /** The view.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gtk::TextView* > property_view() const;


  /** The alignment mode.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< GutterRendererAlignmentMode > property_alignment_mode() ;

/** The alignment mode.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< GutterRendererAlignmentMode > property_alignment_mode() const;

  /** The window type.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gtk::TextWindowType > property_window_type() const;


  /** The size.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_size() ;

/** The size.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_size() const;

  /** The background color.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gdk::RGBA > property_background_rgba() ;

/** The background color.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gdk::RGBA > property_background_rgba() const;

  /** Whether the background color is set.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_background_set() ;

/** Whether the background color is set.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_background_set() const;


  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%query_tooltip(const Gtk::TextIter& iter, const Gdk::Rectangle& area, int x, int y, const Glib::RefPtr<Gtk::Tooltip>& tooltip)</tt>
   *
   * The signal_query_tooltip() signal is emitted when the renderer can
   * show a tooltip.
   * 
   * @param iter A Gtk::TextIter.
   * @param area A Gdk::Rectangle.
   * @param x The x position (in window coordinates).
   * @param y The y position (in window coordinates).
   * @param tooltip A Gtk::Tooltip.
   */

  Glib::SignalProxy< bool,const Gtk::TextIter&,const Gdk::Rectangle&,int,int,const Glib::RefPtr<Gtk::Tooltip>& > signal_query_tooltip();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%activate(const Gtk::TextIter& iter, const Gdk::Rectangle& area, GdkEvent* event)</tt>
   *
   * The signal_activate() signal is emitted when the renderer is
   * activated.
   * 
   * @param iter A Gtk::TextIter.
   * @param area A Gdk::Rectangle.
   * @param event The event that caused the activation.
   */

  Glib::SignalProxy< void,const Gtk::TextIter&,const Gdk::Rectangle&,GdkEvent* > signal_activate();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%queue_draw()</tt>
   *
   * The signal_queue_draw() signal is emitted when the renderer needs
   * to be redrawn. Use Gtk::SourceGutterRenderer::queue_draw()
   * to emit this signal from an implementation of the
   * Gtk::SourceGutterRenderer interface.
   */

  Glib::SignalProxy< void > signal_queue_draw();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%query_data(const Gtk::TextIter& start, const Gtk::TextIter& end, GutterRendererState state)</tt>
   *
   * The signal_query_data() signal is emitted when the renderer needs
   * to be filled with data just before a cell is drawn. This can
   * be used by general renderer implementations to allow render
   * data to be filled in externally.
   * 
   * @param start A Gtk::TextIter.
   * @param end A Gtk::TextIter.
   * @param state The renderer state.
   */

  Glib::SignalProxy< void,const Gtk::TextIter&,const Gtk::TextIter&,GutterRendererState > signal_query_data();


  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%query_activatable(const Gtk::TextIter& iter, const Gdk::Rectangle& area, GdkEvent* event)</tt>
   *
   * The signal_query_activatable() signal is emitted when the renderer
   * can possibly be activated.
   * 
   * @param iter A Gtk::TextIter.
   * @param area A Gdk::Rectangle.
   * @param event The Gdk::Event that is causing the activatable query.
   */

  Glib::SignalProxy< bool,const Gtk::TextIter&,const Gdk::Rectangle&,GdkEvent* > signal_query_activatable();


protected:
  GutterRenderer();

 
    virtual void begin_vfunc(const Cairo::RefPtr<Cairo::Context>& cr, const Gdk::Rectangle& background_area, const Gdk::Rectangle& cell_area, Gtk::TextIter& start, Gtk::TextIter& end);


    virtual void draw_vfunc(const Cairo::RefPtr<Cairo::Context>& cr, const Gdk::Rectangle& background_area, const Gdk::Rectangle& cell_area, Gtk::TextIter& start, Gtk::TextIter& end, GutterRendererState p6);


    virtual void end_vfunc();


    virtual void change_view_vfunc(Gtk::TextView* old_view);


    virtual void change_buffer_vfunc(const Glib::RefPtr<Gtk::TextBuffer>& old_buffer);


};

} // namespace Gsv


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gsv::GutterRenderer
   */
  Gsv::GutterRenderer* wrap(GtkSourceGutterRenderer* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKSOURCEVIEWMM_GUTTERRENDERER_H */

