#ifdef __cplusplus
#define __STDC_FORMAT_MACROS
#endif
#include <inttypes.h>
#include <stdio.h>
#include <arm_neon.h>

// FIXME: this file misses tests for a small number of Neon intrinsics. Add
// the tests for these once emperor (ARM-internal test suite) has been improved
// to cover all Neon intrinsics as defined in the ACLE specification.

#define TEST_SATURATION 1
#define test_saturation(x) (TEST_SATURATION && (x))
static inline uint64_t get_fpsr()
{
  uint64_t fpsr;
  __asm__ __volatile__ ("mrs %0, FPSR"
                        : "=r"(fpsr)
                        :
                        : "memory"
                       );
  return fpsr;
}
static inline void set_fpsr(uint64_t mask, uint64_t value)
{
  uint64_t fpsr=get_fpsr();
  fpsr = (fpsr & ~mask) | (value & mask);
  __asm__ __volatile__ ("msr FPSR, %0"
                        :
                        : "r"(fpsr)
                        : "memory"
                       );
}

// Do not inline these functions, to make sure that they don't get reordered
// over the instructions that could set the saturation flag.
static __attribute__ ((noinline))
int get_neon_saturated(void)
{
    return get_fpsr() & (1<<27) ? 1 : 0;
}
static __attribute__ ((noinline))
int get_neon_saturated_inv(void)
{
    return !get_neon_saturated();
}
static __attribute__ ((noinline))
void clear_neon_saturated(void)
{
    set_fpsr(1<<27, 0);
}
static __attribute__ ((noinline))
void set_neon_saturated(void)
{
    set_fpsr(1<<27, 1<<27);
}

static int failed=0;

void dotests_1() {

{
   {
      int8x8_t arg1;
      int8x8_t arg2;
      int8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vadd_s8\", rettype = \"int8x8_t\", argtypes = \"[int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal 127,IntegerVal 0,IntegerVal (-128),IntegerVal (-63),IntegerVal 20,IntegerVal (-1),IntegerVal 0],VectorVal [IntegerVal 127,IntegerVal (-128),IntegerVal 127,IntegerVal (-1),IntegerVal (-128),IntegerVal (-104),IntegerVal (-128),IntegerVal 127]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s8(UINT64_C(0x00ff14c180007fff));
      arg2 = vcreate_s8(UINT64_C(0x7f809880ff7f807f));
      clear_neon_saturated();
      //  Expect: "result" = 7f7fac417f7fff7e
      result = vadd_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s8(result), 0);
      exp = UINT64_C(0x7f7fac417f7fff7e);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_2() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      int16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vadd_s16\", rettype = \"int16x4_t\", argtypes = \"[int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 0,IntegerVal (-32768),IntegerVal (-20246)],VectorVal [IntegerVal (-32768),IntegerVal (-1),IntegerVal 32767,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s16(UINT64_C(0xb0ea800000007fff));
      arg2 = vcreate_s16(UINT64_C(0x7fff7fffffff8000));
      clear_neon_saturated();
      //  Expect: "result" = 30e9ffffffffffff
      result = vadd_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s16(result), 0);
      exp = UINT64_C(0x30e9ffffffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_3() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      int32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vadd_s32\", rettype = \"int32x2_t\", argtypes = \"[int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal 25829,IntegerVal (-2147483648)],VectorVal [IntegerVal (-2147450881),IntegerVal (-32768)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s32(UINT64_C(0x80000000000064e5));
      arg2 = vcreate_s32(UINT64_C(0xffff800080007fff));
      clear_neon_saturated();
      //  Expect: "result" = 7fff80008000e4e4
      result = vadd_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s32(result), 0);
      exp = UINT64_C(0x7fff80008000e4e4);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_4() {

{
   {
      int64x1_t arg1;
      int64x1_t arg2;
      int64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vadd_s64\", rettype = \"int64x1_t\", argtypes = \"[int64x1_t,int64x1_t]\", vals = [VectorVal [IntegerVal 9223231295506972671],VectorVal [IntegerVal (-2290581505)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s64(UINT64_C(0x7fff7fff19f57fff));
      arg2 = vcreate_s64(UINT64_C(0xffffffff77787fff));
      clear_neon_saturated();
      //  Expect: "result" = 7fff7ffe916dfffe
      result = vadd_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s64(result), 0);
      exp = UINT64_C(0x7fff7ffe916dfffe);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_5() {

{
   {
      float32x2_t arg1;
      float32x2_t arg2;
      float32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vadd_f32\", rettype = \"float32x2_t\", argtypes = \"[float32x2_t,float32x2_t]\", vals = [VectorVal [FloatVal 0.6478096842765808,FloatVal 0.1690211296081543],VectorVal [FloatVal 0.7901993989944458,FloatVal 0.3300831913948059]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_f32(UINT64_C(0x3e2d13e03f25d6db));
      arg2 = vcreate_f32(UINT64_C(0x3ea900aa3f4a4a82));
      clear_neon_saturated();
      //  Expect: "result" = 3eff8a9a3fb810ae
      result = vadd_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float32_t got;
         float32_t exp;
         got = vget_lane_f32(result, 0);
         exp = ((float32_t) 1.4380090236663818);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vget_lane_f32(result, 1);
         exp = ((float32_t) 0.4991043210029602);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
   }
}
}
void dotests_6() {

{
   {
      uint8x8_t arg1;
      uint8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vadd_u8\", rettype = \"uint8x8_t\", argtypes = \"[uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 143,IntegerVal 255,IntegerVal 127,IntegerVal 255,IntegerVal 128,IntegerVal 127,IntegerVal 128,IntegerVal 127],VectorVal [IntegerVal 128,IntegerVal 111,IntegerVal 128,IntegerVal 0,IntegerVal 128,IntegerVal 38,IntegerVal 0,IntegerVal 128]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u8(UINT64_C(0x7f807f80ff7fff8f));
      arg2 = vcreate_u8(UINT64_C(0x8000268000806f80));
      clear_neon_saturated();
      //  Expect: "result" = ff80a500ffff6e0f
      result = vadd_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0xff80a500ffff6e0f);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_7() {

{
   {
      uint16x4_t arg1;
      uint16x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vadd_u16\", rettype = \"uint16x4_t\", argtypes = \"[uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 35968,IntegerVal 32768,IntegerVal 32767,IntegerVal 19602],VectorVal [IntegerVal 0,IntegerVal 0,IntegerVal 65535,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u16(UINT64_C(0x4c927fff80008c80));
      arg2 = vcreate_u16(UINT64_C(0x0000ffff00000000));
      clear_neon_saturated();
      //  Expect: "result" = 4c927ffe80008c80
      result = vadd_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0x4c927ffe80008c80);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_8() {

{
   {
      uint32x2_t arg1;
      uint32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vadd_u32\", rettype = \"uint32x2_t\", argtypes = \"[uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 3826483200,IntegerVal 65535],VectorVal [IntegerVal 1909227519,IntegerVal 1682898943]], start_saturated = True}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u32(UINT64_C(0x0000ffffe4138000));
      arg2 = vcreate_u32(UINT64_C(0x644effff71cc7fff));
      set_neon_saturated();
      //  Expect: "result" = 644ffffe55dfffff
      result = vadd_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0x644ffffe55dfffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_9() {

{
   {
      uint64x1_t arg1;
      uint64x1_t arg2;
      uint64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vadd_u64\", rettype = \"uint64x1_t\", argtypes = \"[uint64x1_t,uint64x1_t]\", vals = [VectorVal [IntegerVal 9223231299366391987],VectorVal [IntegerVal 18446603339490766811]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u64(UINT64_C(0x7fff7fffffff90b3));
      arg2 = vcreate_u64(UINT64_C(0xffff8000c2e1afdb));
      clear_neon_saturated();
      //  Expect: "result" = 7fff0000c2e1408e
      result = vadd_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(result, 0);
      exp = UINT64_C(0x7fff0000c2e1408e);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_10() {

{
   {
      int8x16_t arg1;
      int8x16_t arg2;
      int8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddq_s8\", rettype = \"int8x16_t\", argtypes = \"[int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal (-128),IntegerVal 127,IntegerVal 63,IntegerVal 0,IntegerVal (-57),IntegerVal (-1),IntegerVal (-1),IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal (-1),IntegerVal 25,IntegerVal (-118),IntegerVal (-128),IntegerVal (-1)],VectorVal [IntegerVal (-128),IntegerVal (-1),IntegerVal (-1),IntegerVal 127,IntegerVal 0,IntegerVal (-69),IntegerVal 90,IntegerVal (-1),IntegerVal 127,IntegerVal (-1),IntegerVal 0,IntegerVal 35,IntegerVal (-128),IntegerVal (-1),IntegerVal (-128),IntegerVal (-101)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s8(vcreate_s8(UINT64_C(0xffffc7003f7f80ff)),
                         vcreate_s8(UINT64_C(0xff808a19ff7f007f)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0xff5abb007fffff80)),
                         vcreate_s8(UINT64_C(0x9b80ff802300ff7f)));
      clear_neon_saturated();
      //  Expect: "result" = 9a008999227ffffefe598200be7e7f7f
      result = vaddq_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 0);
         exp = UINT64_C(0xfe598200be7e7f7f);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 1);
         exp = UINT64_C(0x9a008999227ffffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_11() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddq_s16\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal (-32768),IntegerVal (-1),IntegerVal 27071,IntegerVal (-1),IntegerVal 0,IntegerVal (-860),IntegerVal (-32768)],VectorVal [IntegerVal (-32768),IntegerVal (-1549),IntegerVal 32767,IntegerVal 0,IntegerVal (-32515),IntegerVal 32767,IntegerVal 0,IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x69bfffff80000000)),
                          vcreate_s16(UINT64_C(0x8000fca40000ffff)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x00007ffff9f38000)),
                          vcreate_s16(UINT64_C(0xffff00007fff80fd)));
      clear_neon_saturated();
      //  Expect: "result" = 7ffffca47fff80fc69bf7ffe79f38000
      result = vaddq_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x69bf7ffe79f38000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x7ffffca47fff80fc);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_12() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddq_s32\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal (-35529),IntegerVal 2147450879,IntegerVal (-2147450880),IntegerVal (-2147483648)],VectorVal [IntegerVal (-1),IntegerVal (-2147447473),IntegerVal 0,IntegerVal 65535]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x7fff7fffffff7537)),
                          vcreate_s32(UINT64_C(0x8000000080008000)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x80008d4fffffffff)),
                          vcreate_s32(UINT64_C(0x0000ffff00000000)));
      clear_neon_saturated();
      //  Expect: "result" = 8000ffff8000800000000d4effff7536
      result = vaddq_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x00000d4effff7536);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x8000ffff80008000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_13() {

{
   {
      int64x2_t arg1;
      int64x2_t arg2;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddq_s64\", rettype = \"int64x2_t\", argtypes = \"[int64x2_t,int64x2_t]\", vals = [VectorVal [IntegerVal (-65536),IntegerVal 4801400150582890932],VectorVal [IntegerVal 9223202200963022847,IntegerVal 281474976671794]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0xffffffffffff0000)),
                          vcreate_s64(UINT64_C(0x42a1ffff800011b4)));
      arg2 = vcombine_s64(vcreate_s64(UINT64_C(0x7fff658900007fff)),
                          vcreate_s64(UINT64_C(0x0000ffffffff6832)));
      clear_neon_saturated();
      //  Expect: "result" = 42a2ffff7fff79e67fff6588ffff7fff
      result = vaddq_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x7fff6588ffff7fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0x42a2ffff7fff79e6);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_14() {

{
   {
      float32x4_t arg1;
      float32x4_t arg2;
      float32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddq_f32\", rettype = \"float32x4_t\", argtypes = \"[float32x4_t,float32x4_t]\", vals = [VectorVal [FloatVal 0.9937112331390381,FloatVal 0.870923638343811,FloatVal 0.48253411054611206,FloatVal 0.8242339491844177],VectorVal [FloatVal 0.721931517124176,FloatVal 0.6431887149810791,FloatVal 0.5044335126876831,FloatVal 0.3438141345977783]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f32(vcreate_f32(UINT64_C(0x3f5ef4da3f7e63dc)),
                          vcreate_f32(UINT64_C(0x3f5300ff3ef70eb6)));
      arg2 = vcombine_f32(vcreate_f32(UINT64_C(0x3f24a8043f38d081)),
                          vcreate_f32(UINT64_C(0x3eb008683f01228e)));
      clear_neon_saturated();
      //  Expect: "result" = 3f95829a3f7ca9e93fc1ce6f3fdb9a2e
      result = vaddq_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 0);
         exp = ((float32_t) 1.7156426906585693);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 1);
         exp = ((float32_t) 1.5141123533248901);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 2);
         exp = ((float32_t) 0.9869676232337952);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 2 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 3);
         exp = ((float32_t) 1.1680481433868408);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 3 ", exp, got);
            }
      }
   }
}
}
void dotests_15() {

{
   {
      uint8x16_t arg1;
      uint8x16_t arg2;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddq_u8\", rettype = \"uint8x16_t\", argtypes = \"[uint8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 127,IntegerVal 255,IntegerVal 127,IntegerVal 0,IntegerVal 247,IntegerVal 127,IntegerVal 128,IntegerVal 128,IntegerVal 240,IntegerVal 255,IntegerVal 128,IntegerVal 127,IntegerVal 0,IntegerVal 255,IntegerVal 128,IntegerVal 0],VectorVal [IntegerVal 255,IntegerVal 170,IntegerVal 0,IntegerVal 127,IntegerVal 127,IntegerVal 255,IntegerVal 0,IntegerVal 127,IntegerVal 107,IntegerVal 128,IntegerVal 255,IntegerVal 127,IntegerVal 127,IntegerVal 67,IntegerVal 0,IntegerVal 127]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u8(vcreate_u8(UINT64_C(0x80807ff7007fff7f)),
                         vcreate_u8(UINT64_C(0x0080ff007f80fff0)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0x7f00ff7f7f00aaff)),
                         vcreate_u8(UINT64_C(0x7f00437f7fff806b)));
      clear_neon_saturated();
      //  Expect: "result" = 7f80427ffe7f7f5bff807e767f7fa97e
      result = vaddq_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0xff807e767f7fa97e);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0x7f80427ffe7f7f5b);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_16() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddq_u16\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 32767,IntegerVal 32767,IntegerVal 27789,IntegerVal 50382,IntegerVal 32767,IntegerVal 32767,IntegerVal 32768],VectorVal [IntegerVal 24385,IntegerVal 65535,IntegerVal 65535,IntegerVal 65535,IntegerVal 32767,IntegerVal 32767,IntegerVal 0,IntegerVal 51488]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x6c8d7fff7fff7fff)),
                          vcreate_u16(UINT64_C(0x80007fff7fffc4ce)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0xffffffffffff5f41)),
                          vcreate_u16(UINT64_C(0xc92000007fff7fff)));
      clear_neon_saturated();
      //  Expect: "result" = 49207ffffffe44cd6c8c7ffe7ffedf40
      result = vaddq_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x6c8c7ffe7ffedf40);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x49207ffffffe44cd);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_17() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddq_u32\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 2147450879,IntegerVal 20857,IntegerVal 2147450880,IntegerVal 2147447855],VectorVal [IntegerVal 1888223231,IntegerVal 135757823,IntegerVal 32767,IntegerVal 526876672]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x000051797fff7fff)),
                          vcreate_u32(UINT64_C(0x7fff742f7fff8000)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x08177fff708bffff)),
                          vcreate_u32(UINT64_C(0x1f67800000007fff)));
      clear_neon_saturated();
      //  Expect: "result" = 9f66f42f7fffffff0817d178f08b7ffe
      result = vaddq_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x0817d178f08b7ffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0x9f66f42f7fffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_18() {

{
   {
      uint64x2_t arg1;
      uint64x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddq_u64\", rettype = \"uint64x2_t\", argtypes = \"[uint64x2_t,uint64x2_t]\", vals = [VectorVal [IntegerVal 13972959722760896511,IntegerVal 9223576122963230719],VectorVal [IntegerVal 12497911181332119552,IntegerVal 9223231303661387775]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0xc1e9ecd60000ffff)),
                          vcreate_u64(UINT64_C(0x8000b99d7fff7fff)));
      arg2 = vcombine_u64(vcreate_u64(UINT64_C(0xad718000adaf0000)),
                          vcreate_u64(UINT64_C(0x7fff8000ffffffff)));
      clear_neon_saturated();
      //  Expect: "result" = 0000399e7fff7ffe6f5b6cd6adafffff
      result = vaddq_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0x6f5b6cd6adafffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0x0000399e7fff7ffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_19() {

{
   {
      float64x1_t arg1;
      float64x1_t arg2;
      float64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vadd_f64\", rettype = \"float64x1_t\", argtypes = \"[float64x1_t,float64x1_t]\", vals = [VectorVal [FloatVal 0.7272158868577863],VectorVal [FloatVal 0.7995861011279443]], start_saturated = True}";
      int reported = 0;
      float64_t got;
      float64_t exp;
      arg1 = vcreate_f64(UINT64_C(0x3fe7455a4065f24e));
      arg2 = vcreate_f64(UINT64_C(0x3fe996359755c80b));
      set_neon_saturated();
      //  Expect: "result" = 3ff86dc7ebdddd2c
      result = vadd_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_f64(result, 0);
      exp = 1.5268019879857304;
      if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
         }
   }
}
}
void dotests_20() {

{
   {
      float64x2_t arg1;
      float64x2_t arg2;
      float64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddq_f64\", rettype = \"float64x2_t\", argtypes = \"[float64x2_t,float64x2_t]\", vals = [VectorVal [FloatVal 0.625577838098139,FloatVal 0.37438043683304323],VectorVal [FloatVal 0.2792863290849389,FloatVal 0.42160559330924874]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f64(vcreate_f64(UINT64_C(0x3fe404bbd0777c07)),
                          vcreate_f64(UINT64_C(0x3fd7f5d95d1d7284)));
      arg2 = vcombine_f64(vcreate_f64(UINT64_C(0x3fd1dfd3c468f0f2)),
                          vcreate_f64(UINT64_C(0x3fdafb9606c4bac6)));
      clear_neon_saturated();
      //  Expect: "result" = 3fe978b7b1f116a53fecf4a5b2abf480
      result = vaddq_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float64_t got;
         float64_t exp;
         got = vgetq_lane_f64(result, 0);
         exp = 0.9048641671830779;
         if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float64_t got;
         float64_t exp;
         got = vgetq_lane_f64(result, 1);
         exp = 0.795986030142292;
         if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
   }
}
}
void dotests_21() {

{
   {
      int64_t arg1;
      int64_t arg2;
      int64_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddd_s64\", rettype = \"int64_t\", argtypes = \"[int64_t,int64_t]\", vals = [IntegerVal 1752040990387929088,IntegerVal 140739635904511], start_saturated = False}";
      int reported = 0;
      int64_t got;
      int64_t exp;
      arg1 = INT64_C(1752040990387929088);
      arg2 = INT64_C(140739635904511);
      clear_neon_saturated();
      //  Expect: "result" = 1850ffffffffffff
      result = vaddd_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = INT64_C(1752181730023833599);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi64 " Got: %" PRIi64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_22() {

{
   {
      uint64_t arg1;
      uint64_t arg2;
      uint64_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddd_u64\", rettype = \"uint64_t\", argtypes = \"[uint64_t,uint64_t]\", vals = [IntegerVal 9223653509683937280,IntegerVal 9223372039002324991], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = UINT64_C(0x8000ffff7fff0000);
      arg2 = UINT64_C(0x800000008000ffff);
      clear_neon_saturated();
      //  Expect: "result" = 0000ffffffffffff
      result = vaddd_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = UINT64_C(0x0000ffffffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_23() {

{
   {
      int8x8_t arg1;
      int8x8_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddl_s8\", rettype = \"int16x8_t\", argtypes = \"[int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal (-1),IntegerVal (-128),IntegerVal (-128),IntegerVal (-1),IntegerVal (-1),IntegerVal (-117),IntegerVal (-107)],VectorVal [IntegerVal (-1),IntegerVal (-1),IntegerVal (-128),IntegerVal 0,IntegerVal (-1),IntegerVal (-110),IntegerVal 127,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s8(UINT64_C(0x958bffff8080ffff));
      arg2 = vcreate_s8(UINT64_C(0x007f92ff0080ffff));
      clear_neon_saturated();
      //  Expect: "result" = ff95000aff91fffeff80ff00fffefffe
      result = vaddl_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0xff80ff00fffefffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0xff95000aff91fffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_24() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddl_s16\", rettype = \"int32x4_t\", argtypes = \"[int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal (-32768),IntegerVal 0,IntegerVal (-11684)],VectorVal [IntegerVal 0,IntegerVal (-1625),IntegerVal (-1),IntegerVal (-32768)]], start_saturated = True}";
      int reported = 0;
      arg1 = vcreate_s16(UINT64_C(0xd25c000080007fff));
      arg2 = vcreate_s16(UINT64_C(0x8000fffff9a70000));
      set_neon_saturated();
      //  Expect: "result" = ffff525cffffffffffff79a700007fff
      result = vaddl_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0xffff79a700007fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0xffff525cffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_25() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddl_s32\", rettype = \"int64x2_t\", argtypes = \"[int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal (-32768),IntegerVal (-2147483648)],VectorVal [IntegerVal 62231,IntegerVal (-2147482517)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s32(UINT64_C(0x80000000ffff8000));
      arg2 = vcreate_s32(UINT64_C(0x8000046b0000f317));
      clear_neon_saturated();
      //  Expect: "result" = ffffffff0000046b0000000000007317
      result = vaddl_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x0000000000007317);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0xffffffff0000046b);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_26() {

{
   {
      uint8x8_t arg1;
      uint8x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddl_u8\", rettype = \"uint16x8_t\", argtypes = \"[uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 128,IntegerVal 128,IntegerVal 0,IntegerVal 128,IntegerVal 247,IntegerVal 127,IntegerVal 255,IntegerVal 128],VectorVal [IntegerVal 0,IntegerVal 127,IntegerVal 128,IntegerVal 0,IntegerVal 0,IntegerVal 128,IntegerVal 226,IntegerVal 16]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u8(UINT64_C(0x80ff7ff780008080));
      arg2 = vcreate_u8(UINT64_C(0x10e2800000807f00));
      clear_neon_saturated();
      //  Expect: "result" = 009001e100ff00f70080008000ff0080
      result = vaddl_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x0080008000ff0080);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x009001e100ff00f7);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_27() {

{
   {
      uint16x4_t arg1;
      uint16x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddl_u16\", rettype = \"uint32x4_t\", argtypes = \"[uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 32768,IntegerVal 0,IntegerVal 0],VectorVal [IntegerVal 65535,IntegerVal 32768,IntegerVal 32768,IntegerVal 32768]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u16(UINT64_C(0x0000000080007fff));
      arg2 = vcreate_u16(UINT64_C(0x800080008000ffff));
      clear_neon_saturated();
      //  Expect: "result" = 00008000000080000001000000017ffe
      result = vaddl_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x0001000000017ffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0x0000800000008000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_28() {

{
   {
      uint32x2_t arg1;
      uint32x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddl_u32\", rettype = \"uint64x2_t\", argtypes = \"[uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 2147483647,IntegerVal 2147450879],VectorVal [IntegerVal 4294967295,IntegerVal 56194]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u32(UINT64_C(0x7fff7fff7fffffff));
      arg2 = vcreate_u32(UINT64_C(0x0000db82ffffffff));
      clear_neon_saturated();
      //  Expect: "result" = 0000000080005b81000000017ffffffe
      result = vaddl_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0x000000017ffffffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0x0000000080005b81);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_29() {

{
   {
      int8x16_t arg1;
      int8x16_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddl_high_s8\", rettype = \"int16x8_t\", argtypes = \"[int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal 127,IntegerVal (-128),IntegerVal (-65),IntegerVal 127,IntegerVal 127,IntegerVal (-128),IntegerVal 0,IntegerVal (-128),IntegerVal 127,IntegerVal (-24),IntegerVal 127,IntegerVal (-1),IntegerVal (-128),IntegerVal 73,IntegerVal (-1),IntegerVal 127],VectorVal [IntegerVal (-1),IntegerVal (-128),IntegerVal (-1),IntegerVal (-1),IntegerVal 127,IntegerVal 79,IntegerVal 127,IntegerVal (-89),IntegerVal 0,IntegerVal 127,IntegerVal (-128),IntegerVal (-64),IntegerVal 0,IntegerVal (-128),IntegerVal 127,IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s8(vcreate_s8(UINT64_C(0x8000807f7fbf807f)),
                         vcreate_s8(UINT64_C(0x7fff4980ff7fe87f)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0xa77f4f7fffff80ff)),
                         vcreate_s8(UINT64_C(0xff7f8000c0807f00)));
      clear_neon_saturated();
      //  Expect: "result" = 007e007effc9ff80ffbfffff0067007f
      result = vaddl_high_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0xffbfffff0067007f);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x007e007effc9ff80);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_30() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddl_high_s16\", rettype = \"int32x4_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 0,IntegerVal 1884,IntegerVal (-1),IntegerVal (-32768),IntegerVal (-32768),IntegerVal (-1),IntegerVal (-32768)],VectorVal [IntegerVal (-1),IntegerVal (-32768),IntegerVal (-1),IntegerVal 32767,IntegerVal (-32768),IntegerVal 32767,IntegerVal 0,IntegerVal (-32768)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0xffff075c00007fff)),
                          vcreate_s16(UINT64_C(0x8000ffff80008000)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x7fffffff8000ffff)),
                          vcreate_s16(UINT64_C(0x800000007fff8000)));
      clear_neon_saturated();
      //  Expect: "result" = ffff0000ffffffffffffffffffff0000
      result = vaddl_high_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0xffffffffffff0000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0xffff0000ffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_31() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddl_high_s32\", rettype = \"int64x2_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal (-32768),IntegerVal 1306951680,IntegerVal 2147466781,IntegerVal (-32768)],VectorVal [IntegerVal (-2147450880),IntegerVal (-2147418113),IntegerVal 2147449047,IntegerVal (-2147483648)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x4de68000ffff8000)),
                          vcreate_s32(UINT64_C(0xffff80007fffbe1d)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x8000ffff80008000)),
                          vcreate_s32(UINT64_C(0x800000007fff78d7)));
      clear_neon_saturated();
      //  Expect: "result" = ffffffff7fff800000000000ffff36f4
      result = vaddl_high_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x00000000ffff36f4);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0xffffffff7fff8000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_32() {

{
   {
      uint8x16_t arg1;
      uint8x16_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddl_high_u8\", rettype = \"uint16x8_t\", argtypes = \"[uint8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 246,IntegerVal 128,IntegerVal 213,IntegerVal 127,IntegerVal 255,IntegerVal 128,IntegerVal 0,IntegerVal 0,IntegerVal 11,IntegerVal 127,IntegerVal 233,IntegerVal 92,IntegerVal 127,IntegerVal 127,IntegerVal 128,IntegerVal 255],VectorVal [IntegerVal 255,IntegerVal 0,IntegerVal 128,IntegerVal 128,IntegerVal 128,IntegerVal 128,IntegerVal 255,IntegerVal 162,IntegerVal 128,IntegerVal 255,IntegerVal 128,IntegerVal 127,IntegerVal 127,IntegerVal 127,IntegerVal 127,IntegerVal 128]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u8(vcreate_u8(UINT64_C(0x000080ff7fd580f6)),
                         vcreate_u8(UINT64_C(0xff807f7f5ce97f0b)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0xa2ff8080808000ff)),
                         vcreate_u8(UINT64_C(0x807f7f7f7f80ff80)));
      clear_neon_saturated();
      //  Expect: "result" = 017f00ff00fe00fe00db0169017e008b
      result = vaddl_high_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x00db0169017e008b);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x017f00ff00fe00fe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_33() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddl_high_u16\", rettype = \"uint32x4_t\", argtypes = \"[uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 65535,IntegerVal 65535,IntegerVal 36107,IntegerVal 56373,IntegerVal 0,IntegerVal 32768,IntegerVal 65535,IntegerVal 32767],VectorVal [IntegerVal 32768,IntegerVal 32767,IntegerVal 32768,IntegerVal 32767,IntegerVal 0,IntegerVal 10016,IntegerVal 65535,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0xdc358d0bffffffff)),
                          vcreate_u16(UINT64_C(0x7fffffff80000000)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0x7fff80007fff8000)),
                          vcreate_u16(UINT64_C(0x7fffffff27200000)));
      clear_neon_saturated();
      //  Expect: "result" = 0000fffe0001fffe0000a72000000000
      result = vaddl_high_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x0000a72000000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0x0000fffe0001fffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_34() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddl_high_u32\", rettype = \"uint64x2_t\", argtypes = \"[uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 4294934527,IntegerVal 2278490112,IntegerVal 2147450880,IntegerVal 32767],VectorVal [IntegerVal 2147499193,IntegerVal 411238399,IntegerVal 65535,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x87cf0000ffff7fff)),
                          vcreate_u32(UINT64_C(0x00007fff7fff8000)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x1882ffff80003cb9)),
                          vcreate_u32(UINT64_C(0x00007fff0000ffff)));
      clear_neon_saturated();
      //  Expect: "result" = 000000000000fffe0000000080007fff
      result = vaddl_high_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0x0000000080007fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0x000000000000fffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_35() {

{
   {
      int16x8_t arg1;
      int8x8_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddw_s8\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal (-1),IntegerVal 0,IntegerVal (-1),IntegerVal (-32768),IntegerVal (-1),IntegerVal 0,IntegerVal (-1)],VectorVal [IntegerVal (-1),IntegerVal 93,IntegerVal (-128),IntegerVal 0,IntegerVal 0,IntegerVal (-116),IntegerVal (-1),IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0xffff0000ffff7fff)),
                          vcreate_s16(UINT64_C(0xffff0000ffff8000)));
      arg2 = vcreate_s8(UINT64_C(0x00ff8c0000805dff));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffff8b8000ffffff80005c7ffe
      result = vaddw_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0xffffff80005c7ffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0xffffffffff8b8000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_36() {

{
   {
      int32x4_t arg1;
      int16x4_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddw_s16\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal 65535,IntegerVal 2147450879,IntegerVal (-2147450880),IntegerVal (-2147442040)],VectorVal [IntegerVal (-28058),IntegerVal (-32768),IntegerVal 0,IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x7fff7fff0000ffff)),
                          vcreate_s32(UINT64_C(0x8000a28880008000)));
      arg2 = vcreate_s16(UINT64_C(0xffff000080009266));
      clear_neon_saturated();
      //  Expect: "result" = 8000a287800080007ffeffff00009265
      result = vaddw_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x7ffeffff00009265);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x8000a28780008000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_37() {

{
   {
      int64x2_t arg1;
      int32x2_t arg2;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddw_s32\", rettype = \"int64x2_t\", argtypes = \"[int64x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal 281470681808895,IntegerVal 281474976645120],VectorVal [IntegerVal (-2147458980),IntegerVal (-65536)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x0000ffff0000ffff)),
                          vcreate_s64(UINT64_C(0x0000ffffffff0000)));
      arg2 = vcreate_s32(UINT64_C(0xffff00008000605c));
      clear_neon_saturated();
      //  Expect: "result" = 0000fffffffe00000000fffe8001605b
      result = vaddw_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x0000fffe8001605b);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0x0000fffffffe0000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_38() {

{
   {
      uint16x8_t arg1;
      uint8x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddw_u8\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 29032,IntegerVal 8602,IntegerVal 32767,IntegerVal 32767,IntegerVal 0,IntegerVal 65535,IntegerVal 32767],VectorVal [IntegerVal 0,IntegerVal 0,IntegerVal 128,IntegerVal 255,IntegerVal 137,IntegerVal 255,IntegerVal 255,IntegerVal 0]], start_saturated = True}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x7fff219a71680000)),
                          vcreate_u16(UINT64_C(0x7fffffff00007fff)));
      arg2 = vcreate_u8(UINT64_C(0x00ffff89ff800000));
      set_neon_saturated();
      //  Expect: "result" = 7fff00fe00ff808880fe221a71680000
      result = vaddw_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x80fe221a71680000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x7fff00fe00ff8088);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_39() {

{
   {
      uint32x4_t arg1;
      uint16x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddw_u16\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 32768,IntegerVal 2147448269,IntegerVal 3882024959,IntegerVal 4294901760],VectorVal [IntegerVal 65535,IntegerVal 59438,IntegerVal 0,IntegerVal 65535]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x7fff75cd00008000)),
                          vcreate_u32(UINT64_C(0xffff0000e762ffff)));
      arg2 = vcreate_u16(UINT64_C(0xffff0000e82effff));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffe762ffff80005dfb00017fff
      result = vaddw_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x80005dfb00017fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0xffffffffe762ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_40() {

{
   {
      uint64x2_t arg1;
      uint32x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddw_u32\", rettype = \"uint64x2_t\", argtypes = \"[uint64x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 9223372039002226687,IntegerVal 140741783266598],VectorVal [IntegerVal 2147450879,IntegerVal 2147516416]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0x800000007fff7fff)),
                          vcreate_u64(UINT64_C(0x00008000ffff2526)));
      arg2 = vcreate_u32(UINT64_C(0x800080007fff7fff));
      clear_neon_saturated();
      //  Expect: "result" = 000080017fffa52680000000fffefffe
      result = vaddw_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0x80000000fffefffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0x000080017fffa526);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_41() {

{
   {
      int16x8_t arg1;
      int8x16_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddw_high_s8\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int8x16_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal (-12481),IntegerVal (-1),IntegerVal 0,IntegerVal (-32768),IntegerVal 0,IntegerVal (-1),IntegerVal 2613],VectorVal [IntegerVal 127,IntegerVal (-87),IntegerVal (-1),IntegerVal 127,IntegerVal (-1),IntegerVal (-128),IntegerVal 0,IntegerVal (-42),IntegerVal 127,IntegerVal (-128),IntegerVal 127,IntegerVal (-26),IntegerVal 76,IntegerVal (-128),IntegerVal (-128),IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x0000ffffcf3f7fff)),
                          vcreate_s16(UINT64_C(0x0a35ffff00008000)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0xd60080ff7fffa97f)),
                         vcreate_s8(UINT64_C(0x0080804ce67f807f)));
      clear_neon_saturated();
      //  Expect: "result" = 0a35ff7fff80804cffe6007ecebf807e
      result = vaddw_high_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0xffe6007ecebf807e);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x0a35ff7fff80804c);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_42() {

{
   {
      int32x4_t arg1;
      int16x8_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddw_high_s16\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int16x8_t]\", vals = [VectorVal [IntegerVal 2147434387,IntegerVal (-1518108672),IntegerVal (-2147483648),IntegerVal (-2147418113)],VectorVal [IntegerVal 0,IntegerVal (-1),IntegerVal 32767,IntegerVal 32767,IntegerVal (-1),IntegerVal (-1),IntegerVal (-32768),IntegerVal (-27287)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0xa58380007fff3f93)),
                          vcreate_s32(UINT64_C(0x8000ffff80000000)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x7fff7fffffff0000)),
                          vcreate_s16(UINT64_C(0x95698000ffffffff)));
      clear_neon_saturated();
      //  Expect: "result" = 800095687fff8000a5837fff7fff3f92
      result = vaddw_high_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0xa5837fff7fff3f92);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x800095687fff8000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_43() {

{
   {
      int64x2_t arg1;
      int32x4_t arg2;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddw_high_s32\", rettype = \"int64x2_t\", argtypes = \"[int64x2_t,int32x4_t]\", vals = [VectorVal [IntegerVal 281472829280455,IntegerVal (-9223231297218969600)],VectorVal [IntegerVal 2147483647,IntegerVal 1314914303,IntegerVal (-2147418113),IntegerVal 2147430857]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x0000ffff8000d0c7)),
                          vcreate_s64(UINT64_C(0x800080007fff8000)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x4e5fffff7fffffff)),
                          vcreate_s32(UINT64_C(0x7fff31c98000ffff)));
      clear_neon_saturated();
      //  Expect: "result" = 80008000fffeb1c90000ffff0001d0c6
      result = vaddw_high_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x0000ffff0001d0c6);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0x80008000fffeb1c9);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_44() {

{
   {
      uint16x8_t arg1;
      uint8x16_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddw_high_u8\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 65535,IntegerVal 32767,IntegerVal 32767,IntegerVal 42786,IntegerVal 65535,IntegerVal 32768,IntegerVal 7757,IntegerVal 47026],VectorVal [IntegerVal 128,IntegerVal 33,IntegerVal 255,IntegerVal 128,IntegerVal 255,IntegerVal 255,IntegerVal 0,IntegerVal 128,IntegerVal 255,IntegerVal 127,IntegerVal 255,IntegerVal 128,IntegerVal 7,IntegerVal 0,IntegerVal 127,IntegerVal 127]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0xa7227fff7fffffff)),
                          vcreate_u16(UINT64_C(0xb7b21e4d8000ffff)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0x8000ffff80ff2180)),
                         vcreate_u8(UINT64_C(0x7f7f000780ff7fff)));
      clear_neon_saturated();
      //  Expect: "result" = b8311ecc80000006a7a280fe807e00fe
      result = vaddw_high_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0xa7a280fe807e00fe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0xb8311ecc80000006);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_45() {

{
   {
      uint32x4_t arg1;
      uint16x8_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddw_high_u16\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 2147549183,IntegerVal 221807068,IntegerVal 2147535456,IntegerVal 2147516416],VectorVal [IntegerVal 50124,IntegerVal 32768,IntegerVal 0,IntegerVal 32767,IntegerVal 65535,IntegerVal 65535,IntegerVal 32768,IntegerVal 32768]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x0d3881dc8000ffff)),
                          vcreate_u32(UINT64_C(0x800080008000ca60)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0x7fff00008000c3cc)),
                          vcreate_u16(UINT64_C(0x80008000ffffffff)));
      clear_neon_saturated();
      //  Expect: "result" = 8001000080014a600d3981db8001fffe
      result = vaddw_high_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x0d3981db8001fffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0x8001000080014a60);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_46() {

{
   {
      uint64x2_t arg1;
      uint32x4_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"add\", fnname = \"vaddw_high_u32\", rettype = \"uint64x2_t\", argtypes = \"[uint64x2_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 9223090564025548799,IntegerVal 18446462600880324608],VectorVal [IntegerVal 2085355520,IntegerVal 2147418112,IntegerVal 13926,IntegerVal 2147483647]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0x7fff00007fffffff)),
                          vcreate_u64(UINT64_C(0xffff000080000000)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x7fff00007c4c0000)),
                          vcreate_u32(UINT64_C(0x7fffffff00003666)));
      clear_neon_saturated();
      //  Expect: "result" = ffff0000ffffffff7fff000080003665
      result = vaddw_high_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0x7fff000080003665);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0xffff0000ffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_47() {

{
   {
      int8x8_t arg1;
      int8x8_t arg2;
      int8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_add\", fnname = \"vhadd_s8\", rettype = \"int8x8_t\", argtypes = \"[int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal 0,IntegerVal (-128),IntegerVal (-128),IntegerVal (-1),IntegerVal 127,IntegerVal (-128),IntegerVal (-1)],VectorVal [IntegerVal 127,IntegerVal (-128),IntegerVal (-18),IntegerVal (-1),IntegerVal 0,IntegerVal 127,IntegerVal (-8),IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s8(UINT64_C(0xff807fff808000ff));
      arg2 = vcreate_s8(UINT64_C(0x00f87f00ffee807f));
      clear_neon_saturated();
      //  Expect: "result" = ffbc7fffbfb7c03f
      result = vhadd_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s8(result), 0);
      exp = UINT64_C(0xffbc7fffbfb7c03f);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_48() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      int16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_add\", fnname = \"vhadd_s16\", rettype = \"int16x4_t\", argtypes = \"[int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal (-32768),IntegerVal 0,IntegerVal (-32768)],VectorVal [IntegerVal 32767,IntegerVal (-32768),IntegerVal (-32768),IntegerVal (-13073)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s16(UINT64_C(0x8000000080007fff));
      arg2 = vcreate_s16(UINT64_C(0xccef800080007fff));
      clear_neon_saturated();
      //  Expect: "result" = a677c00080007fff
      result = vhadd_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s16(result), 0);
      exp = UINT64_C(0xa677c00080007fff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_49() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      int32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_add\", fnname = \"vhadd_s32\", rettype = \"int32x2_t\", argtypes = \"[int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal 2147436585,IntegerVal (-65536)],VectorVal [IntegerVal (-2147450881),IntegerVal (-1070553660)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s32(UINT64_C(0xffff00007fff4829));
      arg2 = vcreate_s32(UINT64_C(0xc030a5c480007fff));
      clear_neon_saturated();
      //  Expect: "result" = e017d2e2ffffe414
      result = vhadd_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s32(result), 0);
      exp = UINT64_C(0xe017d2e2ffffe414);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_50() {

{
   {
      uint8x8_t arg1;
      uint8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_add\", fnname = \"vhadd_u8\", rettype = \"uint8x8_t\", argtypes = \"[uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 128,IntegerVal 128,IntegerVal 161,IntegerVal 255,IntegerVal 255,IntegerVal 127,IntegerVal 25,IntegerVal 3],VectorVal [IntegerVal 127,IntegerVal 127,IntegerVal 128,IntegerVal 128,IntegerVal 0,IntegerVal 127,IntegerVal 128,IntegerVal 127]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u8(UINT64_C(0x03197fffffa18080));
      arg2 = vcreate_u8(UINT64_C(0x7f807f0080807f7f));
      clear_neon_saturated();
      //  Expect: "result" = 414c7f7fbf907f7f
      result = vhadd_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0x414c7f7fbf907f7f);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_51() {

{
   {
      uint16x4_t arg1;
      uint16x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_add\", fnname = \"vhadd_u16\", rettype = \"uint16x4_t\", argtypes = \"[uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 32767,IntegerVal 44580,IntegerVal 32767],VectorVal [IntegerVal 32768,IntegerVal 32768,IntegerVal 24268,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u16(UINT64_C(0x7fffae247fff0000));
      arg2 = vcreate_u16(UINT64_C(0x7fff5ecc80008000));
      clear_neon_saturated();
      //  Expect: "result" = 7fff86787fff4000
      result = vhadd_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0x7fff86787fff4000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_52() {

{
   {
      uint32x2_t arg1;
      uint32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_add\", fnname = \"vhadd_u32\", rettype = \"uint32x2_t\", argtypes = \"[uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 65535,IntegerVal 4294967295],VectorVal [IntegerVal 34124,IntegerVal 2147483648]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u32(UINT64_C(0xffffffff0000ffff));
      arg2 = vcreate_u32(UINT64_C(0x800000000000854c));
      clear_neon_saturated();
      //  Expect: "result" = bfffffff0000c2a5
      result = vhadd_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0xbfffffff0000c2a5);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_53() {

{
   {
      int8x16_t arg1;
      int8x16_t arg2;
      int8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_add\", fnname = \"vhaddq_s8\", rettype = \"int8x16_t\", argtypes = \"[int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal (-1),IntegerVal (-1),IntegerVal 0,IntegerVal 39,IntegerVal (-128),IntegerVal (-1),IntegerVal (-128),IntegerVal 127,IntegerVal (-48),IntegerVal (-128),IntegerVal (-15),IntegerVal (-14),IntegerVal (-1),IntegerVal 127,IntegerVal (-128)],VectorVal [IntegerVal (-49),IntegerVal 99,IntegerVal 127,IntegerVal (-128),IntegerVal 0,IntegerVal 127,IntegerVal (-128),IntegerVal (-1),IntegerVal (-1),IntegerVal (-1),IntegerVal (-128),IntegerVal 1,IntegerVal (-82),IntegerVal (-97),IntegerVal (-128),IntegerVal 127]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s8(vcreate_s8(UINT64_C(0x80ff802700ffff00)),
                         vcreate_s8(UINT64_C(0x807ffff2f180d07f)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0xff807f00807f63cf)),
                         vcreate_s8(UINT64_C(0x7f809fae0180ffff)));
      clear_neon_saturated();
      //  Expect: "result" = ffffcfd0f980e73fbfbfff13c03f31e7
      result = vhaddq_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 0);
         exp = UINT64_C(0xbfbfff13c03f31e7);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 1);
         exp = UINT64_C(0xffffcfd0f980e73f);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_54() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_add\", fnname = \"vhaddq_s16\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal (-10930),IntegerVal (-32768),IntegerVal (-32768),IntegerVal 32767,IntegerVal (-1),IntegerVal (-1),IntegerVal 32767,IntegerVal 32767],VectorVal [IntegerVal (-4983),IntegerVal 32767,IntegerVal 0,IntegerVal 18180,IntegerVal (-32768),IntegerVal (-1),IntegerVal 32767,IntegerVal 0]], start_saturated = True}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x7fff80008000d54e)),
                          vcreate_s16(UINT64_C(0x7fff7fffffffffff)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x470400007fffec89)),
                          vcreate_s16(UINT64_C(0x00007fffffff8000)));
      set_neon_saturated();
      //  Expect: "result" = 3fff7fffffffbfff6381c000ffffe0eb
      result = vhaddq_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x6381c000ffffe0eb);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x3fff7fffffffbfff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_55() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_add\", fnname = \"vhaddq_s32\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal (-2147483648),IntegerVal 714,IntegerVal 2147450880,IntegerVal (-2147418113)],VectorVal [IntegerVal 0,IntegerVal (-1488453632),IntegerVal (-32768),IntegerVal (-65536)]], start_saturated = True}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x000002ca80000000)),
                          vcreate_s32(UINT64_C(0x8000ffff7fff8000)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0xa748000000000000)),
                          vcreate_s32(UINT64_C(0xffff0000ffff8000)));
      set_neon_saturated();
      //  Expect: "result" = bfffffff3fff8000d3a40165c0000000
      result = vhaddq_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0xd3a40165c0000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0xbfffffff3fff8000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_56() {

{
   {
      uint8x16_t arg1;
      uint8x16_t arg2;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_add\", fnname = \"vhaddq_u8\", rettype = \"uint8x16_t\", argtypes = \"[uint8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 128,IntegerVal 0,IntegerVal 243,IntegerVal 127,IntegerVal 255,IntegerVal 128,IntegerVal 255,IntegerVal 127,IntegerVal 127,IntegerVal 128,IntegerVal 101,IntegerVal 0,IntegerVal 0,IntegerVal 127,IntegerVal 255,IntegerVal 127],VectorVal [IntegerVal 128,IntegerVal 0,IntegerVal 197,IntegerVal 128,IntegerVal 255,IntegerVal 0,IntegerVal 128,IntegerVal 127,IntegerVal 122,IntegerVal 128,IntegerVal 0,IntegerVal 255,IntegerVal 0,IntegerVal 99,IntegerVal 0,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u8(vcreate_u8(UINT64_C(0x7fff80ff7ff30080)),
                         vcreate_u8(UINT64_C(0x7fff7f000065807f)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0x7f8000ff80c50080)),
                         vcreate_u8(UINT64_C(0x00006300ff00807a)));
      clear_neon_saturated();
      //  Expect: "result" = 3f7f71007f32807c7fbf40ff7fdc0080
      result = vhaddq_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x7fbf40ff7fdc0080);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0x3f7f71007f32807c);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_57() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_add\", fnname = \"vhaddq_u16\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 32768,IntegerVal 32767,IntegerVal 32767,IntegerVal 0,IntegerVal 32767,IntegerVal 65535,IntegerVal 65535],VectorVal [IntegerVal 43889,IntegerVal 32767,IntegerVal 32768,IntegerVal 32767,IntegerVal 55164,IntegerVal 32768,IntegerVal 0,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x7fff7fff80000000)),
                          vcreate_u16(UINT64_C(0xffffffff7fff0000)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0x7fff80007fffab71)),
                          vcreate_u16(UINT64_C(0x7fff00008000d77c)));
      clear_neon_saturated();
      //  Expect: "result" = bfff7fff7fff6bbe7fff7fff7fff55b8
      result = vhaddq_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x7fff7fff7fff55b8);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0xbfff7fff7fff6bbe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_58() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_add\", fnname = \"vhaddq_u32\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 4294934528,IntegerVal 2147514244,IntegerVal 65535,IntegerVal 492437503],VectorVal [IntegerVal 4294934527,IntegerVal 2147516416,IntegerVal 2147483648,IntegerVal 2147549183]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x80007784ffff8000)),
                          vcreate_u32(UINT64_C(0x1d59ffff0000ffff)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x80008000ffff7fff)),
                          vcreate_u32(UINT64_C(0x8000ffff80000000)));
      clear_neon_saturated();
      //  Expect: "result" = 4ead7fff40007fff80007bc2ffff7fff
      result = vhaddq_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x80007bc2ffff7fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0x4ead7fff40007fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_59() {

{
   {
      int8x8_t arg1;
      int8x8_t arg2;
      int8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghalving_add\", fnname = \"vrhadd_s8\", rettype = \"int8x8_t\", argtypes = \"[int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal (-128),IntegerVal 127,IntegerVal 127,IntegerVal (-57),IntegerVal 127,IntegerVal (-1),IntegerVal 127,IntegerVal 127],VectorVal [IntegerVal (-128),IntegerVal 0,IntegerVal 0,IntegerVal (-1),IntegerVal (-1),IntegerVal 127,IntegerVal (-128),IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s8(UINT64_C(0x7f7fff7fc77f7f80));
      arg2 = vcreate_s8(UINT64_C(0xff807fffff000080));
      clear_neon_saturated();
      //  Expect: "result" = 3f003f3fe3404080
      result = vrhadd_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s8(result), 0);
      exp = UINT64_C(0x3f003f3fe3404080);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_60() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      int16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghalving_add\", fnname = \"vrhadd_s16\", rettype = \"int16x4_t\", argtypes = \"[int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal 32767,IntegerVal 32767,IntegerVal (-26422)],VectorVal [IntegerVal 0,IntegerVal 32767,IntegerVal 0,IntegerVal (-32768)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s16(UINT64_C(0x98ca7fff7fffffff));
      arg2 = vcreate_s16(UINT64_C(0x800000007fff0000));
      clear_neon_saturated();
      //  Expect: "result" = 8c6540007fff0000
      result = vrhadd_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s16(result), 0);
      exp = UINT64_C(0x8c6540007fff0000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_61() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      int32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghalving_add\", fnname = \"vrhadd_s32\", rettype = \"int32x2_t\", argtypes = \"[int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 1342504959],VectorVal [IntegerVal 1437925376,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s32(UINT64_C(0x5004ffff00000000));
      arg2 = vcreate_s32(UINT64_C(0x0000000055b50000));
      clear_neon_saturated();
      //  Expect: "result" = 280280002ada8000
      result = vrhadd_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s32(result), 0);
      exp = UINT64_C(0x280280002ada8000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_62() {

{
   {
      uint8x8_t arg1;
      uint8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghalving_add\", fnname = \"vrhadd_u8\", rettype = \"uint8x8_t\", argtypes = \"[uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 255,IntegerVal 173,IntegerVal 255,IntegerVal 213,IntegerVal 0,IntegerVal 255,IntegerVal 127,IntegerVal 137],VectorVal [IntegerVal 128,IntegerVal 128,IntegerVal 0,IntegerVal 128,IntegerVal 128,IntegerVal 128,IntegerVal 139,IntegerVal 230]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u8(UINT64_C(0x897fff00d5ffadff));
      arg2 = vcreate_u8(UINT64_C(0xe68b808080008080));
      clear_neon_saturated();
      //  Expect: "result" = b885c040ab8097c0
      result = vrhadd_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0xb885c040ab8097c0);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_63() {

{
   {
      uint16x4_t arg1;
      uint16x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghalving_add\", fnname = \"vrhadd_u16\", rettype = \"uint16x4_t\", argtypes = \"[uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 65535,IntegerVal 0,IntegerVal 65535,IntegerVal 32768],VectorVal [IntegerVal 32767,IntegerVal 0,IntegerVal 65535,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u16(UINT64_C(0x8000ffff0000ffff));
      arg2 = vcreate_u16(UINT64_C(0x0000ffff00007fff));
      clear_neon_saturated();
      //  Expect: "result" = 4000ffff0000bfff
      result = vrhadd_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0x4000ffff0000bfff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_64() {

{
   {
      uint32x2_t arg1;
      uint32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghalving_add\", fnname = \"vrhadd_u32\", rettype = \"uint32x2_t\", argtypes = \"[uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 2147549183,IntegerVal 32768],VectorVal [IntegerVal 2316337151,IntegerVal 2147516415]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u32(UINT64_C(0x000080008000ffff));
      arg2 = vcreate_u32(UINT64_C(0x80007fff8a107fff));
      clear_neon_saturated();
      //  Expect: "result" = 400080008508bfff
      result = vrhadd_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0x400080008508bfff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_65() {

{
   {
      int8x16_t arg1;
      int8x16_t arg2;
      int8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghalving_add\", fnname = \"vrhaddq_s8\", rettype = \"int8x16_t\", argtypes = \"[int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal (-59),IntegerVal (-128),IntegerVal 0,IntegerVal 0,IntegerVal 43,IntegerVal (-25),IntegerVal (-1),IntegerVal 80,IntegerVal (-1),IntegerVal 0,IntegerVal 0,IntegerVal 0,IntegerVal (-1),IntegerVal (-22),IntegerVal (-71),IntegerVal (-1)],VectorVal [IntegerVal (-1),IntegerVal 127,IntegerVal 0,IntegerVal (-1),IntegerVal (-128),IntegerVal 127,IntegerVal 127,IntegerVal 0,IntegerVal (-1),IntegerVal 0,IntegerVal 127,IntegerVal (-128),IntegerVal (-1),IntegerVal (-1),IntegerVal (-64),IntegerVal 127]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s8(vcreate_s8(UINT64_C(0x50ffe72b000080c5)),
                         vcreate_s8(UINT64_C(0xffb9eaff000000ff)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0x007f7f80ff007fff)),
                         vcreate_s8(UINT64_C(0x7fc0ffff807f00ff)));
      clear_neon_saturated();
      //  Expect: "result" = 3fbdf5ffc04000ff283f33d6000000e2
      result = vrhaddq_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 0);
         exp = UINT64_C(0x283f33d6000000e2);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 1);
         exp = UINT64_C(0x3fbdf5ffc04000ff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_66() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghalving_add\", fnname = \"vrhaddq_s16\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal (-32768),IntegerVal (-32768),IntegerVal 0,IntegerVal 0,IntegerVal (-1),IntegerVal (-1),IntegerVal 3035,IntegerVal (-1)],VectorVal [IntegerVal 0,IntegerVal (-1),IntegerVal (-1),IntegerVal 0,IntegerVal (-23325),IntegerVal 0,IntegerVal (-32768),IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x0000000080008000)),
                          vcreate_s16(UINT64_C(0xffff0bdbffffffff)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x0000ffffffff0000)),
                          vcreate_s16(UINT64_C(0x000080000000a4e3)));
      clear_neon_saturated();
      //  Expect: "result" = 0000c5ee0000d27100000000c000c000
      result = vrhaddq_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x00000000c000c000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x0000c5ee0000d271);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_67() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghalving_add\", fnname = \"vrhaddq_s32\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal 2147483647,IntegerVal (-2147475410),IntegerVal (-2147418113),IntegerVal 32768],VectorVal [IntegerVal 1718910975,IntegerVal 0,IntegerVal 2147483647,IntegerVal (-31899)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x8000202e7fffffff)),
                          vcreate_s32(UINT64_C(0x000080008000ffff)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x0000000066747fff)),
                          vcreate_s32(UINT64_C(0xffff83657fffffff)));
      clear_neon_saturated();
      //  Expect: "result" = 000001b300007fffc0001017733a3fff
      result = vrhaddq_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0xc0001017733a3fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x000001b300007fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_68() {

{
   {
      uint8x16_t arg1;
      uint8x16_t arg2;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghalving_add\", fnname = \"vrhaddq_u8\", rettype = \"uint8x16_t\", argtypes = \"[uint8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 127,IntegerVal 210,IntegerVal 221,IntegerVal 128,IntegerVal 90,IntegerVal 19,IntegerVal 100,IntegerVal 0,IntegerVal 255,IntegerVal 127,IntegerVal 128,IntegerVal 128,IntegerVal 142,IntegerVal 140,IntegerVal 127,IntegerVal 128],VectorVal [IntegerVal 127,IntegerVal 255,IntegerVal 128,IntegerVal 127,IntegerVal 127,IntegerVal 128,IntegerVal 125,IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal 128,IntegerVal 19,IntegerVal 127,IntegerVal 128,IntegerVal 255,IntegerVal 128]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u8(vcreate_u8(UINT64_C(0x0064135a80ddd27f)),
                         vcreate_u8(UINT64_C(0x807f8c8e80807fff)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0x007d807f7f80ff7f)),
                         vcreate_u8(UINT64_C(0x80ff807f1380007f)));
      clear_neon_saturated();
      //  Expect: "result" = 80bf86874a8040bf00714a6d80afe97f
      result = vrhaddq_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x00714a6d80afe97f);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0x80bf86874a8040bf);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_69() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghalving_add\", fnname = \"vrhaddq_u16\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 0,IntegerVal 0,IntegerVal 32767,IntegerVal 0,IntegerVal 0,IntegerVal 65535,IntegerVal 65535],VectorVal [IntegerVal 32767,IntegerVal 46138,IntegerVal 65535,IntegerVal 0,IntegerVal 0,IntegerVal 7927,IntegerVal 65535,IntegerVal 47148]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x7fff000000000000)),
                          vcreate_u16(UINT64_C(0xffffffff00000000)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0x0000ffffb43a7fff)),
                          vcreate_u16(UINT64_C(0xb82cffff1ef70000)));
      clear_neon_saturated();
      //  Expect: "result" = dc16ffff0f7c0000400080005a1d4000
      result = vrhaddq_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x400080005a1d4000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0xdc16ffff0f7c0000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_70() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghalving_add\", fnname = \"vrhaddq_u32\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 3018883072,IntegerVal 4294967295,IntegerVal 4294967295,IntegerVal 0],VectorVal [IntegerVal 22629,IntegerVal 32768,IntegerVal 2147516416,IntegerVal 805896192]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0xffffffffb3f08000)),
                          vcreate_u32(UINT64_C(0x00000000ffffffff)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x0000800000005865)),
                          vcreate_u32(UINT64_C(0x3009000080008000)));
      clear_neon_saturated();
      //  Expect: "result" = 18048000c00040008000400059f86c33
      result = vrhaddq_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x8000400059f86c33);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0x18048000c0004000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_71() {

{
   {
      int8x8_t arg1;
      int8x8_t arg2;
      int8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqadd_s8\", rettype = \"int8x8_t\", argtypes = \"[int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal 52,IntegerVal (-1),IntegerVal (-128),IntegerVal 74,IntegerVal 127,IntegerVal (-1),IntegerVal 84,IntegerVal 127],VectorVal [IntegerVal 0,IntegerVal (-1),IntegerVal 71,IntegerVal (-1),IntegerVal (-128),IntegerVal (-128),IntegerVal 0,IntegerVal 55]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s8(UINT64_C(0x7f54ff7f4a80ff34));
      arg2 = vcreate_s8(UINT64_C(0x37008080ff47ff00));
      clear_neon_saturated();
      //  Expect: "result" = 7f5480ff49c7fe34
      result = vqadd_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s8(result), 0);
      exp = UINT64_C(0x7f5480ff49c7fe34);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_72() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      int16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqadd_s16\", rettype = \"int16x4_t\", argtypes = \"[int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 32767,IntegerVal 32767,IntegerVal (-32768)],VectorVal [IntegerVal 24380,IntegerVal 0,IntegerVal 0,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s16(UINT64_C(0x80007fff7fff7fff));
      arg2 = vcreate_s16(UINT64_C(0x0000000000005f3c));
      clear_neon_saturated();
      //  Expect: "result" = 80007fff7fff7fff
      result = vqadd_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s16(result), 0);
      exp = UINT64_C(0x80007fff7fff7fff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_73() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      int32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqadd_s32\", rettype = \"int32x2_t\", argtypes = \"[int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal 32768,IntegerVal 2147423842],VectorVal [IntegerVal 65535,IntegerVal 414351360]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s32(UINT64_C(0x7fff166200008000));
      arg2 = vcreate_s32(UINT64_C(0x18b280000000ffff));
      clear_neon_saturated();
      //  Expect: "result" = 7fffffff00017fff
      result = vqadd_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s32(result), 0);
      exp = UINT64_C(0x7fffffff00017fff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_74() {

{
   {
      int64x1_t arg1;
      int64x1_t arg2;
      int64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqadd_s64\", rettype = \"int64x1_t\", argtypes = \"[int64x1_t,int64x1_t]\", vals = [VectorVal [IntegerVal 101741332824063],VectorVal [IntegerVal (-140739635806209)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s64(UINT64_C(0x00005c8880007fff));
      arg2 = vcreate_s64(UINT64_C(0xffff7fff80007fff));
      clear_neon_saturated();
      //  Expect: "result" = ffffdc880000fffe
      result = vqadd_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s64(result), 0);
      exp = UINT64_C(0xffffdc880000fffe);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_75() {

{
   {
      uint8x8_t arg1;
      uint8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqadd_u8\", rettype = \"uint8x8_t\", argtypes = \"[uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 127,IntegerVal 127,IntegerVal 45,IntegerVal 127,IntegerVal 0,IntegerVal 0,IntegerVal 128,IntegerVal 128],VectorVal [IntegerVal 74,IntegerVal 255,IntegerVal 0,IntegerVal 82,IntegerVal 172,IntegerVal 128,IntegerVal 255,IntegerVal 3]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u8(UINT64_C(0x808000007f2d7f7f));
      arg2 = vcreate_u8(UINT64_C(0x03ff80ac5200ff4a));
      clear_neon_saturated();
      //  Expect: "result" = 83ff80acd12dffc9
      result = vqadd_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0x83ff80acd12dffc9);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_76() {

{
   {
      uint16x4_t arg1;
      uint16x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqadd_u16\", rettype = \"uint16x4_t\", argtypes = \"[uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 54547,IntegerVal 48298,IntegerVal 65535,IntegerVal 32767],VectorVal [IntegerVal 0,IntegerVal 32768,IntegerVal 1654,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u16(UINT64_C(0x7fffffffbcaad513));
      arg2 = vcreate_u16(UINT64_C(0x7fff067680000000));
      clear_neon_saturated();
      //  Expect: "result" = fffeffffffffd513
      result = vqadd_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0xfffeffffffffd513);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_77() {

{
   {
      uint32x2_t arg1;
      uint32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqadd_u32\", rettype = \"uint32x2_t\", argtypes = \"[uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 2571862015,IntegerVal 37985380],VectorVal [IntegerVal 2147450879,IntegerVal 4294901760]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u32(UINT64_C(0x02439c64994b7fff));
      arg2 = vcreate_u32(UINT64_C(0xffff00007fff7fff));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffff
      result = vqadd_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0xffffffffffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_78() {

{
   {
      uint64x1_t arg1;
      uint64x1_t arg2;
      uint64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqadd_u64\", rettype = \"uint64x1_t\", argtypes = \"[uint64x1_t,uint64x1_t]\", vals = [VectorVal [IntegerVal 9223372033579319295],VectorVal [IntegerVal 2147450880]], start_saturated = True}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u64(UINT64_C(0x7fffffff3cc47fff));
      arg2 = vcreate_u64(UINT64_C(0x000000007fff8000));
      set_neon_saturated();
      //  Expect: "result" = 7fffffffbcc3ffff
      result = vqadd_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(result, 0);
      exp = UINT64_C(0x7fffffffbcc3ffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_79() {

{
   {
      int8x16_t arg1;
      int8x16_t arg2;
      int8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqaddq_s8\", rettype = \"int8x16_t\", argtypes = \"[int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal (-1),IntegerVal (-1),IntegerVal 0,IntegerVal 37,IntegerVal 127,IntegerVal (-128),IntegerVal 127,IntegerVal 0,IntegerVal (-1),IntegerVal 0,IntegerVal 0,IntegerVal (-1),IntegerVal 0,IntegerVal 127,IntegerVal 59],VectorVal [IntegerVal (-128),IntegerVal (-1),IntegerVal 127,IntegerVal (-45),IntegerVal 0,IntegerVal 0,IntegerVal (-1),IntegerVal 127,IntegerVal (-128),IntegerVal 127,IntegerVal (-128),IntegerVal 127,IntegerVal 0,IntegerVal (-128),IntegerVal (-122),IntegerVal (-128)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s8(vcreate_s8(UINT64_C(0x7f807f2500ffffff)),
                         vcreate_s8(UINT64_C(0x3b7f00ff0000ff00)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0x7fff0000d37fff80)),
                         vcreate_s8(UINT64_C(0x808680007f807f80)));
      clear_neon_saturated();
      //  Expect: "result" = bb0580ff7f807e807f807f25d37efe80
      result = vqaddq_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 0);
         exp = UINT64_C(0x7f807f25d37efe80);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 1);
         exp = UINT64_C(0xbb0580ff7f807e80);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_80() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqaddq_s16\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal (-9571),IntegerVal (-7257),IntegerVal 0,IntegerVal 32767,IntegerVal (-32768),IntegerVal 0,IntegerVal 0,IntegerVal 27648],VectorVal [IntegerVal (-3070),IntegerVal 0,IntegerVal 32767,IntegerVal (-1),IntegerVal 0,IntegerVal 32767,IntegerVal (-32768),IntegerVal (-16090)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x7fff0000e3a7da9d)),
                          vcreate_s16(UINT64_C(0x6c00000000008000)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0xffff7fff0000f402)),
                          vcreate_s16(UINT64_C(0xc12680007fff0000)));
      clear_neon_saturated();
      //  Expect: "result" = 2d2680007fff80007ffe7fffe3a7ce9f
      result = vqaddq_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x7ffe7fffe3a7ce9f);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x2d2680007fff8000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_81() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqaddq_s32\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal (-1118142464),IntegerVal (-1),IntegerVal (-32769),IntegerVal (-2147465401)],VectorVal [IntegerVal (-2147483648),IntegerVal (-2147483648),IntegerVal 20743,IntegerVal 2147450879]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0xffffffffbd5a8000)),
                          vcreate_s32(UINT64_C(0x80004747ffff7fff)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x8000000080000000)),
                          vcreate_s32(UINT64_C(0x7fff7fff00005107)));
      clear_neon_saturated();
      //  Expect: "result" = ffffc746ffffd1068000000080000000
      result = vqaddq_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x8000000080000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0xffffc746ffffd106);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_82() {

{
   {
      int64x2_t arg1;
      int64x2_t arg2;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqaddq_s64\", rettype = \"int64x2_t\", argtypes = \"[int64x2_t,int64x2_t]\", vals = [VectorVal [IntegerVal (-9223231303564460032),IntegerVal 2147516416],VectorVal [IntegerVal 1646653125135663104,IntegerVal 9223231297218871296]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x80007fff05c70000)),
                          vcreate_s64(UINT64_C(0x0000000080008000)));
      arg2 = vcombine_s64(vcreate_s64(UINT64_C(0x16da164affff8000)),
                          vcreate_s64(UINT64_C(0x7fff7fff7fff0000)));
      clear_neon_saturated();
      //  Expect: "result" = 7fff7fffffff800096da964a05c68000
      result = vqaddq_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x96da964a05c68000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0x7fff7fffffff8000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_83() {

{
   {
      uint8x16_t arg1;
      uint8x16_t arg2;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqaddq_u8\", rettype = \"uint8x16_t\", argtypes = \"[uint8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 128,IntegerVal 92,IntegerVal 255,IntegerVal 0,IntegerVal 104,IntegerVal 128,IntegerVal 128,IntegerVal 128,IntegerVal 127,IntegerVal 207,IntegerVal 125,IntegerVal 128,IntegerVal 255,IntegerVal 104,IntegerVal 255],VectorVal [IntegerVal 0,IntegerVal 128,IntegerVal 34,IntegerVal 128,IntegerVal 255,IntegerVal 127,IntegerVal 128,IntegerVal 127,IntegerVal 128,IntegerVal 143,IntegerVal 128,IntegerVal 128,IntegerVal 11,IntegerVal 255,IntegerVal 128,IntegerVal 193]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u8(vcreate_u8(UINT64_C(0x80806800ff5c8000)),
                         vcreate_u8(UINT64_C(0xff68ff807dcf7f80)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0x7f807fff80228000)),
                         vcreate_u8(UINT64_C(0xc180ff0b80808f80)));
      clear_neon_saturated();
      //  Expect: "result" = ffe8ff8bfdffffffffffe7ffff7eff00
      result = vqaddq_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0xffffe7ffff7eff00);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0xffe8ff8bfdffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_84() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqaddq_u16\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 50464,IntegerVal 54499,IntegerVal 32768,IntegerVal 48249,IntegerVal 65535,IntegerVal 32767,IntegerVal 65535,IntegerVal 65535],VectorVal [IntegerVal 32767,IntegerVal 0,IntegerVal 65535,IntegerVal 44826,IntegerVal 65535,IntegerVal 32768,IntegerVal 32768,IntegerVal 26498]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0xbc798000d4e3c520)),
                          vcreate_u16(UINT64_C(0xffffffff7fffffff)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0xaf1affff00007fff)),
                          vcreate_u16(UINT64_C(0x678280008000ffff)));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffffffffffffd4e3ffff
      result = vqaddq_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0xffffffffd4e3ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0xffffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_85() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqaddq_u32\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 1560346623,IntegerVal 62973,IntegerVal 2147549183,IntegerVal 4294901760],VectorVal [IntegerVal 4294901760,IntegerVal 4294901760,IntegerVal 2147483648,IntegerVal 32768]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x0000f5fd5d00ffff)),
                          vcreate_u32(UINT64_C(0xffff00008000ffff)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0xffff0000ffff0000)),
                          vcreate_u32(UINT64_C(0x0000800080000000)));
      clear_neon_saturated();
      //  Expect: "result" = ffff8000fffffffffffff5fdffffffff
      result = vqaddq_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0xfffff5fdffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0xffff8000ffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_86() {

{
   {
      uint64x2_t arg1;
      uint64x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqaddq_u64\", rettype = \"uint64x2_t\", argtypes = \"[uint64x2_t,uint64x2_t]\", vals = [VectorVal [IntegerVal 18446545640574386175,IntegerVal 13614269357998702592],VectorVal [IntegerVal 9223512771124854783,IntegerVal 9223175971597680640]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0xffff4b86af777fff)),
                          vcreate_u64(UINT64_C(0xbcef99d97fff8000)));
      arg2 = vcombine_u64(vcreate_u64(UINT64_C(0x80007fff402cffff)),
                          vcreate_u64(UINT64_C(0x7fff4dadffff8000)));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffffffffffffffffffff
      result = vqaddq_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0xffffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0xffffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_87() {

{
   {
      int8x8_t arg1;
      uint8x8_t arg2;
      int8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vuqadd_s8\", rettype = \"int8x8_t\", argtypes = \"[int8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 21,IntegerVal 39,IntegerVal 13,IntegerVal 127,IntegerVal 103,IntegerVal 127,IntegerVal 0,IntegerVal 127],VectorVal [IntegerVal 250,IntegerVal 0,IntegerVal 0,IntegerVal 255,IntegerVal 97,IntegerVal 180,IntegerVal 0,IntegerVal 127]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s8(UINT64_C(0x7f007f677f0d2715));
      arg2 = vcreate_u8(UINT64_C(0x7f00b461ff0000fa));
      clear_neon_saturated();
      //  Expect: "result" = 7f007f7f7f0d277f
      result = vuqadd_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s8(result), 0);
      exp = UINT64_C(0x7f007f7f7f0d277f);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_88() {

{
   {
      int16x4_t arg1;
      uint16x4_t arg2;
      int16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vuqadd_s16\", rettype = \"int16x4_t\", argtypes = \"[int16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal (-1),IntegerVal (-16828),IntegerVal 29934],VectorVal [IntegerVal 65535,IntegerVal 18401,IntegerVal 10435,IntegerVal 65535]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s16(UINT64_C(0x74eebe44ffffffff));
      arg2 = vcreate_u16(UINT64_C(0xffff28c347e1ffff));
      clear_neon_saturated();
      //  Expect: "result" = 7fffe70747e07fff
      result = vuqadd_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s16(result), 0);
      exp = UINT64_C(0x7fffe70747e07fff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_89() {

{
   {
      int32x2_t arg1;
      uint32x2_t arg2;
      int32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vuqadd_s32\", rettype = \"int32x2_t\", argtypes = \"[int32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 2147418112,IntegerVal 32768],VectorVal [IntegerVal 917864447,IntegerVal 2147549183]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s32(UINT64_C(0x000080007fff0000));
      arg2 = vcreate_u32(UINT64_C(0x8000ffff36b57fff));
      clear_neon_saturated();
      //  Expect: "result" = 7fffffff7fffffff
      result = vuqadd_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s32(result), 0);
      exp = UINT64_C(0x7fffffff7fffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_90() {

{
   {
      int64x1_t arg1;
      uint64x1_t arg2;
      int64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vuqadd_s64\", rettype = \"int64x1_t\", argtypes = \"[int64x1_t,uint64x1_t]\", vals = [VectorVal [IntegerVal (-140737488420864)],VectorVal [IntegerVal 9223512770048196607]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s64(UINT64_C(0xffff7fffffff0000));
      arg2 = vcreate_u64(UINT64_C(0x80007fff00007fff));
      clear_neon_saturated();
      //  Expect: "result" = 7ffffffeffff7fff
      result = vuqadd_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s64(result), 0);
      exp = UINT64_C(0x7ffffffeffff7fff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_91() {

{
   {
      uint8x8_t arg1;
      int8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vsqadd_u8\", rettype = \"uint8x8_t\", argtypes = \"[uint8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal 127,IntegerVal 216,IntegerVal 255,IntegerVal 149,IntegerVal 255,IntegerVal 128,IntegerVal 222,IntegerVal 0],VectorVal [IntegerVal 127,IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal (-1),IntegerVal (-128)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u8(UINT64_C(0x00de80ff95ffd87f));
      arg2 = vcreate_s8(UINT64_C(0x80ff7f007f007f7f));
      clear_neon_saturated();
      //  Expect: "result" = 00ddfffffffffffe
      result = vsqadd_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0x00ddfffffffffffe);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_92() {

{
   {
      uint16x4_t arg1;
      int16x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vsqadd_u16\", rettype = \"uint16x4_t\", argtypes = \"[uint16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal 65535,IntegerVal 32767,IntegerVal 25236,IntegerVal 65535],VectorVal [IntegerVal (-1),IntegerVal 14475,IntegerVal 32767,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u16(UINT64_C(0xffff62947fffffff));
      arg2 = vcreate_s16(UINT64_C(0x7fff7fff388bffff));
      clear_neon_saturated();
      //  Expect: "result" = ffffe293b88afffe
      result = vsqadd_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0xffffe293b88afffe);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_93() {

{
   {
      uint32x2_t arg1;
      int32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vsqadd_u32\", rettype = \"uint32x2_t\", argtypes = \"[uint32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal 2147549183,IntegerVal 0],VectorVal [IntegerVal 65535,IntegerVal 65535]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u32(UINT64_C(0x000000008000ffff));
      arg2 = vcreate_s32(UINT64_C(0x0000ffff0000ffff));
      clear_neon_saturated();
      //  Expect: "result" = 0000ffff8001fffe
      result = vsqadd_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0x0000ffff8001fffe);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_94() {

{
   {
      uint64x1_t arg1;
      int64x1_t arg2;
      uint64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vsqadd_u64\", rettype = \"uint64x1_t\", argtypes = \"[uint64x1_t,int64x1_t]\", vals = [VectorVal [IntegerVal 4014818332459892735],VectorVal [IntegerVal (-9223372034707324928)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u64(UINT64_C(0x37b780007fff7fff));
      arg2 = vcreate_s64(UINT64_C(0x800000007fff8000));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vsqadd_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(result, 0);
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_95() {

{
   {
      int8x16_t arg1;
      uint8x16_t arg2;
      int8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vuqaddq_s8\", rettype = \"int8x16_t\", argtypes = \"[int8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal (-128),IntegerVal (-1),IntegerVal 0,IntegerVal (-128),IntegerVal (-1),IntegerVal 0,IntegerVal 13,IntegerVal 0,IntegerVal 0,IntegerVal 111,IntegerVal 0,IntegerVal 3,IntegerVal 0,IntegerVal (-1),IntegerVal (-128)],VectorVal [IntegerVal 0,IntegerVal 19,IntegerVal 167,IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal 128,IntegerVal 128,IntegerVal 248,IntegerVal 0,IntegerVal 128,IntegerVal 0,IntegerVal 0,IntegerVal 0,IntegerVal 153,IntegerVal 127]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s8(vcreate_s8(UINT64_C(0x0d00ff8000ff80ff)),
                         vcreate_s8(UINT64_C(0x80ff0003006f0000)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0x80807f007fa71300)),
                         vcreate_u8(UINT64_C(0x7f990000008000f8)));
      clear_neon_saturated();
      //  Expect: "result" = ff7f0003007f007f7f7f7e807f7f93ff
      result = vuqaddq_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 0);
         exp = UINT64_C(0x7f7f7e807f7f93ff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 1);
         exp = UINT64_C(0xff7f0003007f007f);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_96() {

{
   {
      int16x8_t arg1;
      uint16x8_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vuqaddq_s16\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal (-1199),IntegerVal 0,IntegerVal (-1),IntegerVal 3903,IntegerVal (-1),IntegerVal (-25457),IntegerVal 32767,IntegerVal (-32768)],VectorVal [IntegerVal 32768,IntegerVal 0,IntegerVal 32767,IntegerVal 65535,IntegerVal 32767,IntegerVal 32768,IntegerVal 65535,IntegerVal 43401]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x0f3fffff0000fb51)),
                          vcreate_s16(UINT64_C(0x80007fff9c8fffff)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0xffff7fff00008000)),
                          vcreate_u16(UINT64_C(0xa989ffff80007fff)));
      clear_neon_saturated();
      //  Expect: "result" = 29897fff1c8f7ffe7fff7ffe00007b51
      result = vuqaddq_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x7fff7ffe00007b51);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x29897fff1c8f7ffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_97() {

{
   {
      int32x4_t arg1;
      uint32x4_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vuqaddq_s32\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 32768,IntegerVal (-2147418113),IntegerVal (-32768),IntegerVal 32767],VectorVal [IntegerVal 2147549183,IntegerVal 2147418112,IntegerVal 4260102143,IntegerVal 4294934527]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x8000ffff00008000)),
                          vcreate_s32(UINT64_C(0x00007fffffff8000)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x7fff00008000ffff)),
                          vcreate_u32(UINT64_C(0xffff7ffffdebffff)));
      clear_neon_saturated();
      //  Expect: "result" = 7fffffff7fffffffffffffff7fffffff
      result = vuqaddq_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0xffffffff7fffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x7fffffff7fffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_98() {

{
   {
      int64x2_t arg1;
      uint64x2_t arg2;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vuqaddq_s64\", rettype = \"int64x2_t\", argtypes = \"[int64x2_t,uint64x2_t]\", vals = [VectorVal [IntegerVal 9223231297500512255,IntegerVal 9223104050222825472],VectorVal [IntegerVal 9223231301513904127,IntegerVal 140741783289856]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x7fff7fff90c87fff)),
                          vcreate_s64(UINT64_C(0x7fff0c447fff8000)));
      arg2 = vcombine_u64(vcreate_u64(UINT64_C(0x7fff80007fffffff)),
                          vcreate_u64(UINT64_C(0x00008000ffff8000)));
      clear_neon_saturated();
      //  Expect: "result" = 7fff8c457fff00007fffffffffffffff
      result = vuqaddq_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x7fffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0x7fff8c457fff0000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_99() {

{
   {
      uint8x16_t arg1;
      int8x16_t arg2;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vsqaddq_u8\", rettype = \"uint8x16_t\", argtypes = \"[uint8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal 109,IntegerVal 128,IntegerVal 127,IntegerVal 0,IntegerVal 128,IntegerVal 127,IntegerVal 127,IntegerVal 6,IntegerVal 128,IntegerVal 255,IntegerVal 255,IntegerVal 165,IntegerVal 248,IntegerVal 127,IntegerVal 0,IntegerVal 90],VectorVal [IntegerVal (-128),IntegerVal (-1),IntegerVal (-1),IntegerVal (-128),IntegerVal 94,IntegerVal (-128),IntegerVal 127,IntegerVal (-128),IntegerVal 127,IntegerVal (-128),IntegerVal (-128),IntegerVal 127,IntegerVal 127,IntegerVal 72,IntegerVal (-1),IntegerVal 113]], start_saturated = True}";
      int reported = 0;
      arg1 = vcombine_u8(vcreate_u8(UINT64_C(0x067f7f80007f806d)),
                         vcreate_u8(UINT64_C(0x5a007ff8a5ffff80)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0x807f805e80ffff80)),
                         vcreate_s8(UINT64_C(0x71ff487f7f80807f)));
      set_neon_saturated();
      //  Expect: "result" = cb00c7ffff7f7fff00fe00de007e7f00
      result = vsqaddq_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x00fe00de007e7f00);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0xcb00c7ffff7f7fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_100() {

{
   {
      uint16x8_t arg1;
      int16x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vsqaddq_u16\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal 32768,IntegerVal 32767,IntegerVal 0,IntegerVal 65535,IntegerVal 65535,IntegerVal 65535,IntegerVal 32767,IntegerVal 0],VectorVal [IntegerVal (-1),IntegerVal 29755,IntegerVal 0,IntegerVal 32767,IntegerVal (-1),IntegerVal 32767,IntegerVal (-32768),IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0xffff00007fff8000)),
                          vcreate_u16(UINT64_C(0x00007fffffffffff)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x7fff0000743bffff)),
                          vcreate_s16(UINT64_C(0xffff80007fffffff)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000fffffffeffff0000f43a7fff
      result = vsqaddq_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0xffff0000f43a7fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x00000000fffffffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_101() {

{
   {
      uint32x4_t arg1;
      int32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vsqaddq_u32\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal 20885,IntegerVal 0,IntegerVal 32768,IntegerVal 3863216127],VectorVal [IntegerVal (-32768),IntegerVal 32767,IntegerVal (-1322287104),IntegerVal 63161]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x0000000000005195)),
                          vcreate_u32(UINT64_C(0xe643ffff00008000)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x00007fffffff8000)),
                          vcreate_s32(UINT64_C(0x0000f6b9b12f8000)));
      clear_neon_saturated();
      //  Expect: "result" = e644f6b80000000000007fff00000000
      result = vsqaddq_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x00007fff00000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0xe644f6b800000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_102() {

{
   {
      uint64x2_t arg1;
      int64x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vsqaddq_u64\", rettype = \"uint64x2_t\", argtypes = \"[uint64x2_t,int64x2_t]\", vals = [VectorVal [IntegerVal 5622040448772866048,IntegerVal 18446744071562035199],VectorVal [IntegerVal (-21916144074752),IntegerVal 407153555959447552]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0x4e05800055fc0000)),
                          vcreate_u64(UINT64_C(0xffffffff7fff7fff)));
      arg2 = vcombine_s64(vcreate_s64(UINT64_C(0xffffec1140048000)),
                          vcreate_s64(UINT64_C(0x05a6800080000000)));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffff4e056c1196008000
      result = vsqaddq_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0x4e056c1196008000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0xffffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_103() {

{
   {
      int8_t arg1;
      int8_t arg2;
      int8_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqaddb_s8\", rettype = \"int8_t\", argtypes = \"[int8_t,int8_t]\", vals = [IntegerVal (-1),IntegerVal 0], start_saturated = False}";
      int reported = 0;
      int8_t got;
      int8_t exp;
      arg1 = -1;
      arg2 = 0;
      clear_neon_saturated();
      //  Expect: "result" = ff
      result = vqaddb_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = -1;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi8 " Got: %" PRIi8 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_104() {

{
   {
      int16_t arg1;
      int16_t arg2;
      int16_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqaddh_s16\", rettype = \"int16_t\", argtypes = \"[int16_t,int16_t]\", vals = [IntegerVal 21762,IntegerVal 0], start_saturated = False}";
      int reported = 0;
      int16_t got;
      int16_t exp;
      arg1 = 21762;
      arg2 = 0;
      clear_neon_saturated();
      //  Expect: "result" = 5502
      result = vqaddh_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 21762;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi16 " Got: %" PRIi16 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_105() {

{
   {
      int32_t arg1;
      int32_t arg2;
      int32_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqadds_s32\", rettype = \"int32_t\", argtypes = \"[int32_t,int32_t]\", vals = [IntegerVal 0,IntegerVal 2147450880], start_saturated = False}";
      int reported = 0;
      int32_t got;
      int32_t exp;
      arg1 = 0;
      arg2 = 2147450880;
      clear_neon_saturated();
      //  Expect: "result" = 7fff8000
      result = vqadds_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 2147450880;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi32 " Got: %" PRIi32 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_106() {

{
   {
      int64_t arg1;
      int64_t arg2;
      int64_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqaddd_s64\", rettype = \"int64_t\", argtypes = \"[int64_t,int64_t]\", vals = [IntegerVal 140733193453567,IntegerVal (-9223185811367758745)], start_saturated = False}";
      int reported = 0;
      int64_t got;
      int64_t exp;
      arg1 = INT64_C(140733193453567);
      arg2 = INT64_C(-9223185811367758745);
      clear_neon_saturated();
      //  Expect: "result" = 8001295e00017466
      result = vqaddd_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = INT64_C(-9223045078174305178);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi64 " Got: %" PRIi64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_107() {

{
   {
      uint8_t arg1;
      uint8_t arg2;
      uint8_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqaddb_u8\", rettype = \"uint8_t\", argtypes = \"[uint8_t,uint8_t]\", vals = [IntegerVal 0,IntegerVal 128], start_saturated = False}";
      int reported = 0;
      uint8_t got;
      uint8_t exp;
      arg1 = 0;
      arg2 = 128U;
      clear_neon_saturated();
      //  Expect: "result" = 80
      result = vqaddb_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 128U;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIu8 " Got: %" PRIu8 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_108() {

{
   {
      uint16_t arg1;
      uint16_t arg2;
      uint16_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqaddh_u16\", rettype = \"uint16_t\", argtypes = \"[uint16_t,uint16_t]\", vals = [IntegerVal 0,IntegerVal 65535], start_saturated = False}";
      int reported = 0;
      uint16_t got;
      uint16_t exp;
      arg1 = 0;
      arg2 = 65535U;
      clear_neon_saturated();
      //  Expect: "result" = ffff
      result = vqaddh_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 65535U;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIu16 " Got: %" PRIu16 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_109() {

{
   {
      uint32_t arg1;
      uint32_t arg2;
      uint32_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqadds_u32\", rettype = \"uint32_t\", argtypes = \"[uint32_t,uint32_t]\", vals = [IntegerVal 2147483647,IntegerVal 2147483647], start_saturated = False}";
      int reported = 0;
      uint32_t got;
      uint32_t exp;
      arg1 = 2147483647U;
      arg2 = 2147483647U;
      clear_neon_saturated();
      //  Expect: "result" = fffffffe
      result = vqadds_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 4294967294U;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIu32 " Got: %" PRIu32 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_110() {

{
   {
      uint64_t arg1;
      uint64_t arg2;
      uint64_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vqaddd_u64\", rettype = \"uint64_t\", argtypes = \"[uint64_t,uint64_t]\", vals = [IntegerVal 9223621658206502912,IntegerVal 4870361519876964352], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = UINT64_C(0x8000e3077fff8000);
      arg2 = UINT64_C(0x4396ffff7fff8000);
      clear_neon_saturated();
      //  Expect: "result" = c397e306ffff0000
      result = vqaddd_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = UINT64_C(0xc397e306ffff0000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_111() {

{
   {
      int8_t arg1;
      uint8_t arg2;
      int8_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vuqaddb_s8\", rettype = \"int8_t\", argtypes = \"[int8_t,uint8_t]\", vals = [IntegerVal (-1),IntegerVal 255], start_saturated = False}";
      int reported = 0;
      int8_t got;
      int8_t exp;
      arg1 = -1;
      arg2 = 255U;
      clear_neon_saturated();
      //  Expect: "result" = 7f
      result = vuqaddb_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = result;
      exp = 127;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi8 " Got: %" PRIi8 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_112() {

{
   {
      int16_t arg1;
      uint16_t arg2;
      int16_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vuqaddh_s16\", rettype = \"int16_t\", argtypes = \"[int16_t,uint16_t]\", vals = [IntegerVal 3233,IntegerVal 0], start_saturated = False}";
      int reported = 0;
      int16_t got;
      int16_t exp;
      arg1 = 3233;
      arg2 = 0;
      clear_neon_saturated();
      //  Expect: "result" = 0ca1
      result = vuqaddh_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 3233;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi16 " Got: %" PRIi16 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_113() {

{
   {
      int32_t arg1;
      uint32_t arg2;
      int32_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vuqadds_s32\", rettype = \"int32_t\", argtypes = \"[int32_t,uint32_t]\", vals = [IntegerVal (-32769),IntegerVal 35712], start_saturated = False}";
      int reported = 0;
      int32_t got;
      int32_t exp;
      arg1 = -32769;
      arg2 = 35712U;
      clear_neon_saturated();
      //  Expect: "result" = 00000b7f
      result = vuqadds_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 2943;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi32 " Got: %" PRIi32 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_114() {

{
   {
      int64_t arg1;
      uint64_t arg2;
      int64_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vuqaddd_s64\", rettype = \"int64_t\", argtypes = \"[int64_t,uint64_t]\", vals = [IntegerVal 35747324189736960,IntegerVal 9223231297218969599], start_saturated = False}";
      int reported = 0;
      int64_t got;
      int64_t exp;
      arg1 = INT64_C(35747324189736960);
      arg2 = UINT64_C(0x7fff7fff80007fff);
      clear_neon_saturated();
      //  Expect: "result" = 7fffffffffffffff
      result = vuqaddd_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = result;
      exp = INT64_C(9223372036854775807);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi64 " Got: %" PRIi64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_115() {

{
   {
      uint8_t arg1;
      int8_t arg2;
      uint8_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vsqaddb_u8\", rettype = \"uint8_t\", argtypes = \"[uint8_t,int8_t]\", vals = [IntegerVal 127,IntegerVal (-128)], start_saturated = False}";
      int reported = 0;
      uint8_t got;
      uint8_t exp;
      arg1 = 127U;
      arg2 = -128;
      clear_neon_saturated();
      //  Expect: "result" = 00
      result = vsqaddb_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = result;
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIu8 " Got: %" PRIu8 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_116() {

{
   {
      uint16_t arg1;
      int16_t arg2;
      uint16_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vsqaddh_u16\", rettype = \"uint16_t\", argtypes = \"[uint16_t,int16_t]\", vals = [IntegerVal 65535,IntegerVal (-16357)], start_saturated = False}";
      int reported = 0;
      uint16_t got;
      uint16_t exp;
      arg1 = 65535U;
      arg2 = -16357;
      clear_neon_saturated();
      //  Expect: "result" = c01a
      result = vsqaddh_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 49178U;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIu16 " Got: %" PRIu16 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_117() {

{
   {
      uint32_t arg1;
      int32_t arg2;
      uint32_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vsqadds_u32\", rettype = \"uint32_t\", argtypes = \"[uint32_t,int32_t]\", vals = [IntegerVal 2147549183,IntegerVal (-2147450881)], start_saturated = False}";
      int reported = 0;
      uint32_t got;
      uint32_t exp;
      arg1 = 2147549183U;
      arg2 = -2147450881;
      clear_neon_saturated();
      //  Expect: "result" = 00017ffe
      result = vsqadds_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 98302U;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIu32 " Got: %" PRIu32 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_118() {

{
   {
      uint64_t arg1;
      int64_t arg2;
      uint64_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_add\", fnname = \"vsqaddd_u64\", rettype = \"uint64_t\", argtypes = \"[uint64_t,int64_t]\", vals = [IntegerVal 9223231299366450211,IntegerVal 281470681743360], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = UINT64_C(0x7fff800000007423);
      arg2 = INT64_C(281470681743360);
      clear_neon_saturated();
      //  Expect: "result" = 80007fff00007423
      result = vsqaddd_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = UINT64_C(0x80007fff00007423);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_119() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_add\", fnname = \"vaddhn_s16\", rettype = \"int8x8_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 0,IntegerVal (-32768),IntegerVal 32767,IntegerVal 12886,IntegerVal 0,IntegerVal 0,IntegerVal 32767],VectorVal [IntegerVal 0,IntegerVal 32122,IntegerVal (-32768),IntegerVal 0,IntegerVal (-1),IntegerVal (-32768),IntegerVal 0,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x7fff800000007fff)),
                          vcreate_s16(UINT64_C(0x7fff000000003256)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x000080007d7a0000)),
                          vcreate_s16(UINT64_C(0x7fff00008000ffff)));
      clear_neon_saturated();
      //  Expect: "result" = ff0080327f007d7f
      result = vaddhn_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s8(result), 0);
      exp = UINT64_C(0xff0080327f007d7f);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_120() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_add\", fnname = \"vaddhn_s32\", rettype = \"int16x4_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal 1509490688,IntegerVal (-2147450880),IntegerVal (-2147450881),IntegerVal (-2085276856)],VectorVal [IntegerVal 32767,IntegerVal (-32769),IntegerVal 2147483647,IntegerVal (-32768)]], start_saturated = True}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x8000800059f90000)),
                          vcreate_s32(UINT64_C(0x83b5334880007fff)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0xffff7fff00007fff)),
                          vcreate_s32(UINT64_C(0xffff80007fffffff)));
      set_neon_saturated();
      //  Expect: "result" = 83b400007fff59f9
      result = vaddhn_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s16(result), 0);
      exp = UINT64_C(0x83b400007fff59f9);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_121() {

{
   {
      int64x2_t arg1;
      int64x2_t arg2;
      int32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_add\", fnname = \"vaddhn_s64\", rettype = \"int32x2_t\", argtypes = \"[int64x2_t,int64x2_t]\", vals = [VectorVal [IntegerVal (-9223372036854710273),IntegerVal (-140739635838977)],VectorVal [IntegerVal 140741783289856,IntegerVal 8485344647919384359]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x800000000000ffff)),
                          vcreate_s64(UINT64_C(0xffff7fff7fffffff)));
      arg2 = vcombine_s64(vcreate_s64(UINT64_C(0x00008000ffff8000)),
                          vcreate_s64(UINT64_C(0x75c1ffffffff3727)));
      clear_neon_saturated();
      //  Expect: "result" = 75c17fff80008001
      result = vaddhn_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s32(result), 0);
      exp = UINT64_C(0x75c17fff80008001);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_122() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_add\", fnname = \"vaddhn_u16\", rettype = \"uint8x8_t\", argtypes = \"[uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 32768,IntegerVal 32767,IntegerVal 32767,IntegerVal 0,IntegerVal 0,IntegerVal 32767,IntegerVal 65535],VectorVal [IntegerVal 21696,IntegerVal 13171,IntegerVal 32768,IntegerVal 65535,IntegerVal 17610,IntegerVal 0,IntegerVal 0,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x7fff7fff80000000)),
                          vcreate_u16(UINT64_C(0xffff7fff00000000)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0xffff8000337354c0)),
                          vcreate_u16(UINT64_C(0x7fff0000000044ca)));
      clear_neon_saturated();
      //  Expect: "result" = 7f7f00447fffb354
      result = vaddhn_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0x7f7f00447fffb354);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_123() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_add\", fnname = \"vaddhn_u32\", rettype = \"uint16x4_t\", argtypes = \"[uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 2147483647,IntegerVal 1889926006,IntegerVal 2147450879,IntegerVal 2147516416],VectorVal [IntegerVal 2147516416,IntegerVal 36423,IntegerVal 616497151,IntegerVal 4294927391]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x70a5fb767fffffff)),
                          vcreate_u32(UINT64_C(0x800080007fff7fff)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x00008e4780008000)),
                          vcreate_u32(UINT64_C(0xffff641f24beffff)));
      clear_neon_saturated();
      //  Expect: "result" = 7fffa4be70a60000
      result = vaddhn_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0x7fffa4be70a60000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_124() {

{
   {
      uint64x2_t arg1;
      uint64x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_add\", fnname = \"vaddhn_u64\", rettype = \"uint32x2_t\", argtypes = \"[uint64x2_t,uint64x2_t]\", vals = [VectorVal [IntegerVal 9223512772195647487,IntegerVal 140735340871679],VectorVal [IntegerVal 2147450880,IntegerVal 9223090562789169855]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0x80007fff7fffffff)),
                          vcreate_u64(UINT64_C(0x00007fff7fffffff)));
      arg2 = vcombine_u64(vcreate_u64(UINT64_C(0x000000007fff8000)),
                          vcreate_u64(UINT64_C(0x7fff0000364e5abf)));
      clear_neon_saturated();
      //  Expect: "result" = 7fff7fff80007fff
      result = vaddhn_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0x7fff7fff80007fff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_125() {

{
   {
      int8x8_t arg1;
      int16x8_t arg2;
      int16x8_t arg3;
      int8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_add\", fnname = \"vaddhn_high_s16\", rettype = \"int8x16_t\", argtypes = \"[int8x8_t,int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal 70,IntegerVal 127,IntegerVal (-128),IntegerVal 127,IntegerVal (-128),IntegerVal (-128),IntegerVal 127,IntegerVal (-1)],VectorVal [IntegerVal 8588,IntegerVal 0,IntegerVal (-1),IntegerVal (-32768),IntegerVal (-32768),IntegerVal (-1),IntegerVal 0,IntegerVal (-32768)],VectorVal [IntegerVal 0,IntegerVal 32767,IntegerVal 0,IntegerVal (-32768),IntegerVal 32767,IntegerVal 0,IntegerVal 0,IntegerVal (-32768)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s8(UINT64_C(0xff7f80807f807f46));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x8000ffff0000218c)),
                          vcreate_s16(UINT64_C(0x80000000ffff8000)));
      arg3 = vcombine_s16(vcreate_s16(UINT64_C(0x800000007fff0000)),
                          vcreate_s16(UINT64_C(0x8000000000007fff)));
      clear_neon_saturated();
      //  Expect: "result" = 0000ffff00ff7f21ff7f80807f807f46
      result = vaddhn_high_s16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 0);
         exp = UINT64_C(0xff7f80807f807f46);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 1);
         exp = UINT64_C(0x0000ffff00ff7f21);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_126() {

{
   {
      int16x4_t arg1;
      int32x4_t arg2;
      int32x4_t arg3;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_add\", fnname = \"vaddhn_high_s32\", rettype = \"int16x8_t\", argtypes = \"[int16x4_t,int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal (-23535),IntegerVal (-32768),IntegerVal 32767,IntegerVal (-32768)],VectorVal [IntegerVal 32768,IntegerVal (-2147470210),IntegerVal (-81362944),IntegerVal (-125)],VectorVal [IntegerVal 32768,IntegerVal (-32769),IntegerVal 2147465160,IntegerVal 2147483647]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s16(UINT64_C(0x80007fff8000a411));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x8000347e00008000)),
                          vcreate_s32(UINT64_C(0xffffff83fb268000)));
      arg3 = vcombine_s32(vcreate_s32(UINT64_C(0xffff7fff00008000)),
                          vcreate_s32(UINT64_C(0x7fffffff7fffb7c8)));
      clear_neon_saturated();
      //  Expect: "result" = 7fff7b267fff000180007fff8000a411
      result = vaddhn_high_s32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x80007fff8000a411);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x7fff7b267fff0001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_127() {

{
   {
      int32x2_t arg1;
      int64x2_t arg2;
      int64x2_t arg3;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_add\", fnname = \"vaddhn_high_s64\", rettype = \"int32x4_t\", argtypes = \"[int32x2_t,int64x2_t,int64x2_t]\", vals = [VectorVal [IntegerVal (-1789624321),IntegerVal (-1)],VectorVal [IntegerVal 9223369406187307008,IntegerVal 140739635838975],VectorVal [IntegerVal 96439195664383,IntegerVal 9223372035172630527]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s32(UINT64_C(0xffffffff95547fff));
      arg2 = vcombine_s64(vcreate_s64(UINT64_C(0x7ffffd9b80000000)),
                          vcreate_s64(UINT64_C(0x000080007fffffff)));
      arg3 = vcombine_s64(vcreate_s64(UINT64_C(0x000057b5ffffffff)),
                          vcreate_s64(UINT64_C(0x7fffffff9bbc7fff)));
      clear_neon_saturated();
      //  Expect: "result" = 8000800080005551ffffffff95547fff
      result = vaddhn_high_s64(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0xffffffff95547fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x8000800080005551);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_128() {

{
   {
      uint8x8_t arg1;
      uint16x8_t arg2;
      uint16x8_t arg3;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_add\", fnname = \"vaddhn_high_u16\", rettype = \"uint8x16_t\", argtypes = \"[uint8x8_t,uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 127,IntegerVal 127,IntegerVal 128,IntegerVal 0,IntegerVal 128,IntegerVal 128,IntegerVal 0],VectorVal [IntegerVal 65535,IntegerVal 4791,IntegerVal 32767,IntegerVal 32767,IntegerVal 7251,IntegerVal 65535,IntegerVal 32768,IntegerVal 32767],VectorVal [IntegerVal 0,IntegerVal 32767,IntegerVal 5390,IntegerVal 32768,IntegerVal 32768,IntegerVal 65159,IntegerVal 65535,IntegerVal 32768]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u8(UINT64_C(0x00808000807f7f00));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0x7fff7fff12b7ffff)),
                          vcreate_u16(UINT64_C(0x7fff8000ffff1c53)));
      arg3 = vcombine_u16(vcreate_u16(UINT64_C(0x8000150e7fff0000)),
                          vcreate_u16(UINT64_C(0x8000fffffe878000)));
      clear_neon_saturated();
      //  Expect: "result" = ff7ffe9cff9592ff00808000807f7f00
      result = vaddhn_high_u16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x00808000807f7f00);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0xff7ffe9cff9592ff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_129() {

{
   {
      uint16x4_t arg1;
      uint32x4_t arg2;
      uint32x4_t arg3;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_add\", fnname = \"vaddhn_high_u32\", rettype = \"uint16x8_t\", argtypes = \"[uint16x4_t,uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 32768,IntegerVal 9660,IntegerVal 32768,IntegerVal 65535],VectorVal [IntegerVal 2147483648,IntegerVal 2147418112,IntegerVal 3761505964,IntegerVal 4294934527],VectorVal [IntegerVal 32767,IntegerVal 0,IntegerVal 2147516416,IntegerVal 4294967295]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u16(UINT64_C(0xffff800025bc8000));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x7fff000080000000)),
                          vcreate_u32(UINT64_C(0xffff7fffe03406ac)));
      arg3 = vcombine_u32(vcreate_u32(UINT64_C(0x0000000000007fff)),
                          vcreate_u32(UINT64_C(0xffffffff80008000)));
      clear_neon_saturated();
      //  Expect: "result" = ffff60347fff8000ffff800025bc8000
      result = vaddhn_high_u32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0xffff800025bc8000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0xffff60347fff8000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_130() {

{
   {
      uint32x2_t arg1;
      uint64x2_t arg2;
      uint64x2_t arg3;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_add\", fnname = \"vaddhn_high_u64\", rettype = \"uint32x4_t\", argtypes = \"[uint32x2_t,uint64x2_t,uint64x2_t]\", vals = [VectorVal [IntegerVal 2279014399,IntegerVal 1265958912],VectorVal [IntegerVal 9223512772195591529,IntegerVal 9223372039002324991],VectorVal [IntegerVal 140733193388032,IntegerVal 9223231299038838784]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u32(UINT64_C(0x4b75000087d6ffff));
      arg2 = vcombine_u64(vcreate_u64(UINT64_C(0x80007fff7fff2569)),
                          vcreate_u64(UINT64_C(0x800000008000ffff)));
      arg3 = vcombine_u64(vcreate_u64(UINT64_C(0x00007fff00000000)),
                          vcreate_u64(UINT64_C(0x7fff7fffec798000)));
      clear_neon_saturated();
      //  Expect: "result" = ffff80008000fffe4b75000087d6ffff
      result = vaddhn_high_u64(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x4b75000087d6ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0xffff80008000fffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_131() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_add\", fnname = \"vraddhn_s16\", rettype = \"int8x8_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal 0,IntegerVal 22176,IntegerVal (-1),IntegerVal (-1),IntegerVal 0,IntegerVal (-32768),IntegerVal 0],VectorVal [IntegerVal (-32768),IntegerVal 32767,IntegerVal 1071,IntegerVal (-32768),IntegerVal (-1),IntegerVal 11782,IntegerVal 32767,IntegerVal (-32768)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0xffff56a00000ffff)),
                          vcreate_s16(UINT64_C(0x000080000000ffff)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x8000042f7fff8000)),
                          vcreate_s16(UINT64_C(0x80007fff2e06ffff)));
      clear_neon_saturated();
      //  Expect: "result" = 80002e00805b8080
      result = vraddhn_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s8(result), 0);
      exp = UINT64_C(0x80002e00805b8080);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_132() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_add\", fnname = \"vraddhn_s32\", rettype = \"int16x4_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal 358350847,IntegerVal (-2147483648),IntegerVal 32767,IntegerVal 2147450879],VectorVal [IntegerVal 32768,IntegerVal 32767,IntegerVal 762118144,IntegerVal (-2147418113)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x80000000155bffff)),
                          vcreate_s32(UINT64_C(0x7fff7fff00007fff)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x00007fff00008000)),
                          vcreate_s32(UINT64_C(0x8000ffff2d6d0000)));
      clear_neon_saturated();
      //  Expect: "result" = 00002d6d8000155c
      result = vraddhn_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s16(result), 0);
      exp = UINT64_C(0x00002d6d8000155c);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_133() {

{
   {
      int64x2_t arg1;
      int64x2_t arg2;
      int32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_add\", fnname = \"vraddhn_s64\", rettype = \"int32x2_t\", argtypes = \"[int64x2_t,int64x2_t]\", vals = [VectorVal [IntegerVal (-9223090564025580056),IntegerVal 9223256639673466879],VectorVal [IntegerVal 9223372036527962365,IntegerVal (-5590655985279533057)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x8000ffff7fff85e8)),
                          vcreate_s64(UINT64_C(0x7fff970bffffffff)));
      arg2 = vcombine_s64(vcreate_s64(UINT64_C(0x7fffffffec8538fd)),
                          vcreate_s64(UINT64_C(0xb26a000080007fff)));
      clear_neon_saturated();
      //  Expect: "result" = 3269970d0000ffff
      result = vraddhn_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s32(result), 0);
      exp = UINT64_C(0x3269970d0000ffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_134() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_add\", fnname = \"vraddhn_u16\", rettype = \"uint8x8_t\", argtypes = \"[uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 32768,IntegerVal 32768,IntegerVal 0,IntegerVal 0,IntegerVal 4248,IntegerVal 65535,IntegerVal 65535,IntegerVal 0],VectorVal [IntegerVal 0,IntegerVal 32768,IntegerVal 32767,IntegerVal 65535,IntegerVal 32767,IntegerVal 32768,IntegerVal 18784,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x0000000080008000)),
                          vcreate_u16(UINT64_C(0x0000ffffffff1098)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0xffff7fff80000000)),
                          vcreate_u16(UINT64_C(0x0000496080007fff)));
      clear_neon_saturated();
      //  Expect: "result" = 0049809100800080
      result = vraddhn_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0x0049809100800080);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_135() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_add\", fnname = \"vraddhn_u32\", rettype = \"uint16x4_t\", argtypes = \"[uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 2147450879,IntegerVal 32767,IntegerVal 4294934527,IntegerVal 1342603264],VectorVal [IntegerVal 4294934527,IntegerVal 54689791,IntegerVal 1666646016,IntegerVal 2147516416]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x00007fff7fff7fff)),
                          vcreate_u32(UINT64_C(0x50068000ffff7fff)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x03427fffffff7fff)),
                          vcreate_u32(UINT64_C(0x8000800063570000)));
      clear_neon_saturated();
      //  Expect: "result" = d007635603437fff
      result = vraddhn_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0xd007635603437fff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_136() {

{
   {
      uint64x2_t arg1;
      uint64x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_add\", fnname = \"vraddhn_u64\", rettype = \"uint32x2_t\", argtypes = \"[uint64x2_t,uint64x2_t]\", vals = [VectorVal [IntegerVal 9223354979392126976,IntegerVal 9223512774343196671],VectorVal [IntegerVal 18446603334073696896,IntegerVal 9223231297218904064]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0x7ffff07c7fff8000)),
                          vcreate_u64(UINT64_C(0x800080000000ffff)));
      arg2 = vcombine_u64(vcreate_u64(UINT64_C(0xffff7fff7fffc280)),
                          vcreate_u64(UINT64_C(0x7fff7fff7fff8000)));
      clear_neon_saturated();
      //  Expect: "result" = 000000007fff707c
      result = vraddhn_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0x000000007fff707c);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_137() {

{
   {
      int8x8_t arg1;
      int16x8_t arg2;
      int16x8_t arg3;
      int8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_add\", fnname = \"vraddhn_high_s16\", rettype = \"int8x16_t\", argtypes = \"[int8x8_t,int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal 28,IntegerVal (-1),IntegerVal 0,IntegerVal (-1),IntegerVal 127,IntegerVal 127,IntegerVal 87,IntegerVal (-1)],VectorVal [IntegerVal (-1),IntegerVal (-19030),IntegerVal 32767,IntegerVal (-1),IntegerVal (-32768),IntegerVal (-1),IntegerVal 10190,IntegerVal 32767],VectorVal [IntegerVal 32767,IntegerVal 0,IntegerVal (-32768),IntegerVal 32767,IntegerVal (-32768),IntegerVal 17186,IntegerVal (-32768),IntegerVal (-32768)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s8(UINT64_C(0xff577f7fff00ff1c));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0xffff7fffb5aaffff)),
                          vcreate_s16(UINT64_C(0x7fff27ceffff8000)));
      arg3 = vcombine_s16(vcreate_s16(UINT64_C(0x7fff800000007fff)),
                          vcreate_s16(UINT64_C(0x8000800043228000)));
      clear_neon_saturated();
      //  Expect: "result" = 00a843008000b680ff577f7fff00ff1c
      result = vraddhn_high_s16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 0);
         exp = UINT64_C(0xff577f7fff00ff1c);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 1);
         exp = UINT64_C(0x00a843008000b680);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_138() {

{
   {
      int16x4_t arg1;
      int32x4_t arg2;
      int32x4_t arg3;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_add\", fnname = \"vraddhn_high_s32\", rettype = \"int16x8_t\", argtypes = \"[int16x4_t,int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal (-14242),IntegerVal (-1),IntegerVal (-32768)],VectorVal [IntegerVal (-966404798),IntegerVal (-32768),IntegerVal 1096351744,IntegerVal (-2147450881)],VectorVal [IntegerVal (-14441),IntegerVal (-2147450881),IntegerVal (-32768),IntegerVal 1372356608]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s16(UINT64_C(0x8000ffffc85effff));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0xffff8000c665d542)),
                          vcreate_s32(UINT64_C(0x80007fff41590000)));
      arg3 = vcombine_s32(vcreate_s32(UINT64_C(0x80007fffffffc797)),
                          vcreate_s32(UINT64_C(0x51cc8000ffff8000)));
      clear_neon_saturated();
      //  Expect: "result" = d1cd41598000c6668000ffffc85effff
      result = vraddhn_high_s32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x8000ffffc85effff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0xd1cd41598000c666);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_139() {

{
   {
      int32x2_t arg1;
      int64x2_t arg2;
      int64x2_t arg3;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_add\", fnname = \"vraddhn_high_s64\", rettype = \"int32x4_t\", argtypes = \"[int32x2_t,int64x2_t,int64x2_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 35990],VectorVal [IntegerVal 9223372036854743040,IntegerVal 9223372035391873376],VectorVal [IntegerVal 5131007350458482688,IntegerVal (-140740229103617)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s32(UINT64_C(0x00008c9600007fff));
      arg2 = vcombine_s64(vcreate_s64(UINT64_C(0x7fffffffffff8000)),
                          vcreate_s64(UINT64_C(0x7fffffffa8cde160)));
      arg3 = vcombine_s64(vcreate_s64(UINT64_C(0x4734ffffffff0000)),
                          vcreate_s64(UINT64_C(0xffff7fff5ca37fff)));
      clear_neon_saturated();
      //  Expect: "result" = 7fff7fffc735000000008c9600007fff
      result = vraddhn_high_s64(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x00008c9600007fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x7fff7fffc7350000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_140() {

{
   {
      uint8x8_t arg1;
      uint16x8_t arg2;
      uint16x8_t arg3;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_add\", fnname = \"vraddhn_high_u16\", rettype = \"uint8x16_t\", argtypes = \"[uint8x8_t,uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 255,IntegerVal 128,IntegerVal 188,IntegerVal 0,IntegerVal 255,IntegerVal 128,IntegerVal 127],VectorVal [IntegerVal 32768,IntegerVal 32768,IntegerVal 32767,IntegerVal 32767,IntegerVal 32767,IntegerVal 0,IntegerVal 32767,IntegerVal 32768],VectorVal [IntegerVal 65535,IntegerVal 8986,IntegerVal 0,IntegerVal 0,IntegerVal 62158,IntegerVal 32767,IntegerVal 0,IntegerVal 65535]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u8(UINT64_C(0x7f80ff00bc80ff00));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0x7fff7fff80008000)),
                          vcreate_u16(UINT64_C(0x80007fff00007fff)));
      arg3 = vcombine_u16(vcreate_u16(UINT64_C(0x00000000231affff)),
                          vcreate_u16(UINT64_C(0xffff00007ffff2ce)));
      clear_neon_saturated();
      //  Expect: "result" = 808080738080a3807f80ff00bc80ff00
      result = vraddhn_high_u16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x7f80ff00bc80ff00);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0x808080738080a380);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_141() {

{
   {
      uint16x4_t arg1;
      uint32x4_t arg2;
      uint32x4_t arg3;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_add\", fnname = \"vraddhn_high_u32\", rettype = \"uint16x8_t\", argtypes = \"[uint16x4_t,uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 31979,IntegerVal 65535,IntegerVal 41632],VectorVal [IntegerVal 2147532134,IntegerVal 2210966716,IntegerVal 2147432447,IntegerVal 65535],VectorVal [IntegerVal 4294934528,IntegerVal 154109705,IntegerVal 2147483648,IntegerVal 4142366720]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u16(UINT64_C(0xa2a0ffff7ceb7fff));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x83c8acbc8000bd66)),
                          vcreate_u32(UINT64_C(0x0000ffff7fff37ff)));
      arg3 = vcombine_u32(vcreate_u32(UINT64_C(0x092f8709ffff8000)),
                          vcreate_u32(UINT64_C(0xf6e7800080000000)));
      clear_neon_saturated();
      //  Expect: "result" = f6e8ffff8cf88000a2a0ffff7ceb7fff
      result = vraddhn_high_u32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0xa2a0ffff7ceb7fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0xf6e8ffff8cf88000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_142() {

{
   {
      uint32x2_t arg1;
      uint64x2_t arg2;
      uint64x2_t arg3;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_add\", fnname = \"vraddhn_high_u64\", rettype = \"uint32x4_t\", argtypes = \"[uint32x2_t,uint64x2_t,uint64x2_t]\", vals = [VectorVal [IntegerVal 2147483647,IntegerVal 2147450879],VectorVal [IntegerVal 18446603337947906048,IntegerVal 9223231299366472468],VectorVal [IntegerVal 7884154897707335679,IntegerVal 9223512774343131136]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u32(UINT64_C(0x7fff7fff7fffffff));
      arg2 = vcombine_u64(vcreate_u64(UINT64_C(0xffff800066eb8000)),
                          vcreate_u64(UINT64_C(0x7fff80000000cb14)));
      arg3 = vcombine_u64(vcreate_u64(UINT64_C(0x6d6a251b80007fff)),
                          vcreate_u64(UINT64_C(0x8000800000000000)));
      clear_neon_saturated();
      //  Expect: "result" = 000000006d69a51c7fff7fff7fffffff
      result = vraddhn_high_u64(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x7fff7fff7fffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0x000000006d69a51c);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_143() {

{
   {
      int8x8_t arg1;
      int8x8_t arg2;
      int8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmul_s8\", rettype = \"int8x8_t\", argtypes = \"[int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal (-128),IntegerVal (-128),IntegerVal 0,IntegerVal (-1),IntegerVal 0,IntegerVal 0,IntegerVal (-1),IntegerVal (-86)],VectorVal [IntegerVal 0,IntegerVal (-1),IntegerVal (-128),IntegerVal (-116),IntegerVal 127,IntegerVal 127,IntegerVal (-89),IntegerVal (-128)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s8(UINT64_C(0xaaff0000ff008080));
      arg2 = vcreate_s8(UINT64_C(0x80a77f7f8c80ff00));
      clear_neon_saturated();
      //  Expect: "result" = 0059000074008000
      result = vmul_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s8(result), 0);
      exp = UINT64_C(0x0059000074008000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_144() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      int16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmul_s16\", rettype = \"int16x4_t\", argtypes = \"[int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal 10725,IntegerVal 32767,IntegerVal 17291,IntegerVal (-32768)],VectorVal [IntegerVal (-32768),IntegerVal (-1),IntegerVal 32767,IntegerVal (-18267)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s16(UINT64_C(0x8000438b7fff29e5));
      arg2 = vcreate_s16(UINT64_C(0xb8a57fffffff8000));
      clear_neon_saturated();
      //  Expect: "result" = 80003c7580018000
      result = vmul_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s16(result), 0);
      exp = UINT64_C(0x80003c7580018000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_145() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      int32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmul_s32\", rettype = \"int32x2_t\", argtypes = \"[int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal (-2147428713),IntegerVal (-2147483648)],VectorVal [IntegerVal 0,IntegerVal 2147418112]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s32(UINT64_C(0x800000008000d697));
      arg2 = vcreate_s32(UINT64_C(0x7fff000000000000));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vmul_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s32(result), 0);
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_146() {

{
   {
      float32x2_t arg1;
      float32x2_t arg2;
      float32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmul_f32\", rettype = \"float32x2_t\", argtypes = \"[float32x2_t,float32x2_t]\", vals = [VectorVal [FloatVal 0.371631383895874,FloatVal 0.268302321434021],VectorVal [FloatVal 8.336490392684937e-2,FloatVal 0.9900298714637756]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_f32(UINT64_C(0x3e895eec3ebe4678));
      arg2 = vcreate_f32(UINT64_C(0x3f7d72993daabb38));
      clear_neon_saturated();
      //  Expect: "result" = 3e88004e3cfdcbe6
      result = vmul_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float32_t got;
         float32_t exp;
         got = vget_lane_f32(result, 0);
         exp = ((float32_t) 3.0981015413999557e-2);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vget_lane_f32(result, 1);
         exp = ((float32_t) 0.26562732458114624);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
   }
}
}
void dotests_147() {

{
   {
      uint8x8_t arg1;
      uint8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmul_u8\", rettype = \"uint8x8_t\", argtypes = \"[uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 255,IntegerVal 127,IntegerVal 255,IntegerVal 17,IntegerVal 0,IntegerVal 218,IntegerVal 128,IntegerVal 0],VectorVal [IntegerVal 0,IntegerVal 128,IntegerVal 0,IntegerVal 199,IntegerVal 0,IntegerVal 127,IntegerVal 127,IntegerVal 127]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u8(UINT64_C(0x0080da0011ff7fff));
      arg2 = vcreate_u8(UINT64_C(0x7f7f7f00c7008000));
      clear_neon_saturated();
      //  Expect: "result" = 0080260037008000
      result = vmul_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0x0080260037008000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_148() {

{
   {
      uint16x4_t arg1;
      uint16x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmul_u16\", rettype = \"uint16x4_t\", argtypes = \"[uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 0,IntegerVal 5015,IntegerVal 10482],VectorVal [IntegerVal 32768,IntegerVal 31320,IntegerVal 65535,IntegerVal 0]], start_saturated = True}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u16(UINT64_C(0x28f2139700000000));
      arg2 = vcreate_u16(UINT64_C(0x0000ffff7a588000));
      set_neon_saturated();
      //  Expect: "result" = 0000ec6900000000
      result = vmul_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0x0000ec6900000000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_149() {

{
   {
      uint32x2_t arg1;
      uint32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmul_u32\", rettype = \"uint32x2_t\", argtypes = \"[uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 4294901760,IntegerVal 32767],VectorVal [IntegerVal 2147483648,IntegerVal 573898751]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u32(UINT64_C(0x00007fffffff0000));
      arg2 = vcreate_u32(UINT64_C(0x2234ffff80000000));
      clear_neon_saturated();
      //  Expect: "result" = 5dca800100000000
      result = vmul_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0x5dca800100000000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_150() {

{
   {
      poly8x8_t arg1;
      poly8x8_t arg2;
      poly8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmul_p8\", rettype = \"poly8x8_t\", argtypes = \"[poly8x8_t,poly8x8_t]\", vals = [VectorVal [PolyVal [1,1,0,1,1,0,0,0],PolyVal [1,0,0,1,1,1,0,0],PolyVal [0,0,1,0,1,1,1,1],PolyVal [0,1,1,1,1,1,0,1],PolyVal [1,1,0,1,0,0,0,1],PolyVal [1,1,1,0,0,0,1,0],PolyVal [0,0,1,0,1,0,1,0],PolyVal [0,0,1,1,0,1,1,0]],VectorVal [PolyVal [1,1,0,0,1,0,0,0],PolyVal [0,0,0,0,1,0,0,0],PolyVal [1,1,0,1,0,0,0,1],PolyVal [1,0,1,0,0,1,1,1],PolyVal [1,0,1,0,1,1,1,1],PolyVal [1,1,0,0,1,1,1,0],PolyVal [0,1,1,1,1,1,1,1],PolyVal [0,0,1,1,0,0,0,1]]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_p8(UINT64_C(0x6c54478bbef4391b));
      arg2 = vcreate_p8(UINT64_C(0x8cfe73f5e58b1013));
      clear_neon_saturated();
      //  Expect: "result" = d098993706bc909d
      result = vmul_p8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_p8(result), 0);
      exp = UINT64_C(0xd098993706bc909d);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_151() {

{
   {
      int8x16_t arg1;
      int8x16_t arg2;
      int8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmulq_s8\", rettype = \"int8x16_t\", argtypes = \"[int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal (-128),IntegerVal (-128),IntegerVal (-57),IntegerVal 84,IntegerVal 0,IntegerVal (-128),IntegerVal (-1),IntegerVal 7,IntegerVal (-128),IntegerVal 0,IntegerVal 127,IntegerVal 75,IntegerVal (-128),IntegerVal (-128),IntegerVal 0],VectorVal [IntegerVal 127,IntegerVal (-128),IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal 124,IntegerVal (-128),IntegerVal (-1),IntegerVal (-44),IntegerVal (-128),IntegerVal (-128),IntegerVal 67,IntegerVal (-128),IntegerVal (-128),IntegerVal (-128)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s8(vcreate_s8(UINT64_C(0xff800054c78080ff)),
                         vcreate_s8(UINT64_C(0x0080804b7f008007)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0x807c7f007f00807f)),
                         vcreate_s8(UINT64_C(0x808080438080d4ff)));
      clear_neon_saturated();
      //  Expect: "result" = 000000a1800000f980000000b9000081
      result = vmulq_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 0);
         exp = UINT64_C(0x80000000b9000081);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 1);
         exp = UINT64_C(0x000000a1800000f9);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_152() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmulq_s16\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal 12293,IntegerVal (-1),IntegerVal (-32768),IntegerVal (-1),IntegerVal (-1),IntegerVal (-32768),IntegerVal (-1),IntegerVal (-1)],VectorVal [IntegerVal (-14902),IntegerVal 32767,IntegerVal (-1),IntegerVal 0,IntegerVal (-1),IntegerVal 32767,IntegerVal (-32768),IntegerVal 14637]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0xffff8000ffff3005)),
                          vcreate_s16(UINT64_C(0xffffffff8000ffff)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x0000ffff7fffc5ca)),
                          vcreate_s16(UINT64_C(0x392d80007fffffff)));
      clear_neon_saturated();
      //  Expect: "result" = c6d3800080000001000080008001bcf2
      result = vmulq_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x000080008001bcf2);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0xc6d3800080000001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_153() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmulq_s32\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal 44637,IntegerVal 2147483647,IntegerVal 1577385984,IntegerVal 1897049551],VectorVal [IntegerVal 2147482479,IntegerVal (-2147450880),IntegerVal 1609492388,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x7fffffff0000ae5d)),
                          vcreate_s32(UINT64_C(0x7112adcf5e050000)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x800080007ffffb6f)),
                          vcreate_s32(UINT64_C(0x00007fff5feee7a4)));
      clear_neon_saturated();
      //  Expect: "result" = e5d4d231be3400007fff80007ce3c953
      result = vmulq_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x7fff80007ce3c953);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0xe5d4d231be340000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_154() {

{
   {
      float32x4_t arg1;
      float32x4_t arg2;
      float32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmulq_f32\", rettype = \"float32x4_t\", argtypes = \"[float32x4_t,float32x4_t]\", vals = [VectorVal [FloatVal 0.5192524790763855,FloatVal 0.6874197721481323,FloatVal 0.13385248184204102,FloatVal 0.7150024175643921],VectorVal [FloatVal 0.9502118229866028,FloatVal 0.25896841287612915,FloatVal 0.9825602769851685,FloatVal 0.2639363408088684]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f32(vcreate_f32(UINT64_C(0x3f2ffabe3f04edbb)),
                          vcreate_f32(UINT64_C(0x3f370a663e0910a0)));
      arg2 = vcombine_f32(vcreate_f32(UINT64_C(0x3e8497823f734115)),
                          vcreate_f32(UINT64_C(0x3e8722aa3f7b8912)));
      clear_neon_saturated();
      //  Expect: "result" = 3e413e893e06acb03e364ae03efc9ee8
      result = vmulq_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 0);
         exp = ((float32_t) 0.49339985847473145);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 1);
         exp = ((float32_t) 0.17802000045776367);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 2);
         exp = ((float32_t) 0.13151812553405762);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 2 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 3);
         exp = ((float32_t) 0.1887151151895523);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 3 ", exp, got);
            }
      }
   }
}
}
void dotests_155() {

{
   {
      uint8x16_t arg1;
      uint8x16_t arg2;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmulq_u8\", rettype = \"uint8x16_t\", argtypes = \"[uint8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 127,IntegerVal 128,IntegerVal 127,IntegerVal 255,IntegerVal 0,IntegerVal 0,IntegerVal 255,IntegerVal 0,IntegerVal 127,IntegerVal 119,IntegerVal 128,IntegerVal 255,IntegerVal 128,IntegerVal 0,IntegerVal 0],VectorVal [IntegerVal 127,IntegerVal 128,IntegerVal 128,IntegerVal 0,IntegerVal 0,IntegerVal 161,IntegerVal 105,IntegerVal 127,IntegerVal 127,IntegerVal 128,IntegerVal 255,IntegerVal 127,IntegerVal 255,IntegerVal 165,IntegerVal 127,IntegerVal 127]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u8(vcreate_u8(UINT64_C(0xff0000ff7f807f00)),
                         vcreate_u8(UINT64_C(0x000080ff80777f00)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0x7f69a1000080807f)),
                         vcreate_u8(UINT64_C(0x7f7fa5ff7fff807f)));
      clear_neon_saturated();
      //  Expect: "result" = 00008001808980008100000000008000
      result = vmulq_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x8100000000008000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0x0000800180898000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_156() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmulq_u16\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 32768,IntegerVal 32767,IntegerVal 32767,IntegerVal 0,IntegerVal 63401,IntegerVal 65535,IntegerVal 65535],VectorVal [IntegerVal 0,IntegerVal 10420,IntegerVal 65535,IntegerVal 0,IntegerVal 32768,IntegerVal 32767,IntegerVal 0,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x7fff7fff80007fff)),
                          vcreate_u16(UINT64_C(0xfffffffff7a90000)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0x0000ffff28b40000)),
                          vcreate_u16(UINT64_C(0x000000007fff8000)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000885700000000800100000000
      result = vmulq_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x0000800100000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x0000000088570000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_157() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmulq_u32\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 2147516415,IntegerVal 2147528101,IntegerVal 32768,IntegerVal 2147483648],VectorVal [IntegerVal 4294955062,IntegerVal 32767,IntegerVal 2147483648,IntegerVal 2147472130]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x8000ada580007fff)),
                          vcreate_u32(UINT64_C(0x8000000000008000)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x00007fffffffd036)),
                          vcreate_u32(UINT64_C(0x7fffd30280000000)));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000d6d1d25be81b2fca
      result = vmulq_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0xd6d1d25be81b2fca);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_158() {

{
   {
      poly8x16_t arg1;
      poly8x16_t arg2;
      poly8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmulq_p8\", rettype = \"poly8x16_t\", argtypes = \"[poly8x16_t,poly8x16_t]\", vals = [VectorVal [PolyVal [0,1,1,1,1,0,0,1],PolyVal [0,1,1,0,1,0,1,0],PolyVal [0,1,0,0,1,1,0,1],PolyVal [1,0,0,0,1,0,0,0],PolyVal [0,0,0,0,1,1,0,1],PolyVal [0,0,1,1,1,0,0,0],PolyVal [1,1,1,1,1,1,1,1],PolyVal [1,0,1,0,0,0,0,0],PolyVal [0,1,1,0,0,1,1,0],PolyVal [0,1,1,1,1,0,1,1],PolyVal [0,1,0,0,0,0,0,0],PolyVal [0,1,1,0,1,0,1,1],PolyVal [1,0,0,0,1,1,0,1],PolyVal [0,0,1,1,0,0,1,1],PolyVal [1,1,0,0,0,1,1,1],PolyVal [1,0,1,1,0,0,1,0]],VectorVal [PolyVal [0,1,0,0,1,0,0,0],PolyVal [0,0,0,1,0,1,0,1],PolyVal [0,0,1,0,1,0,0,0],PolyVal [1,0,1,1,1,1,1,0],PolyVal [0,1,0,1,0,1,1,0],PolyVal [1,0,0,1,1,0,1,0],PolyVal [1,0,1,1,0,0,0,0],PolyVal [1,1,0,1,1,0,0,1],PolyVal [1,1,0,0,0,1,1,1],PolyVal [0,0,1,0,1,0,1,0],PolyVal [0,0,1,0,0,1,1,0],PolyVal [1,1,0,0,0,1,0,1],PolyVal [1,1,1,0,1,1,1,0],PolyVal [0,0,1,1,0,0,0,1],PolyVal [1,0,1,1,1,0,0,0],PolyVal [0,0,1,1,0,1,0,0]]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_p8(vcreate_p8(UINT64_C(0x05ff1cb011b2569e)),
                         vcreate_p8(UINT64_C(0x4de3ccb1d602de66)));
      arg2 = vcombine_p8(vcreate_p8(UINT64_C(0x9b0d596a7d14a812)),
                         vcreate_p8(UINT64_C(0x2c1d8c77a36454e3)));
      clear_neon_saturated();
      //  Expect: "result" = fc475067bac818eaf7fb3ce0ade870dc
      result = vmulq_p8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_p8(result), 0);
         exp = UINT64_C(0xf7fb3ce0ade870dc);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_p8(result), 1);
         exp = UINT64_C(0xfc475067bac818ea);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_159() {

{
   {
      float64x1_t arg1;
      float64x1_t arg2;
      float64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmul_f64\", rettype = \"float64x1_t\", argtypes = \"[float64x1_t,float64x1_t]\", vals = [VectorVal [FloatVal 0.24574326407743374],VectorVal [FloatVal 0.7338272593187489]], start_saturated = False}";
      int reported = 0;
      float64_t got;
      float64_t exp;
      arg1 = vcreate_f64(UINT64_C(0x3fcf7483e9366220));
      arg2 = vcreate_f64(UINT64_C(0x3fe77b834df5feac));
      clear_neon_saturated();
      //  Expect: "result" = 3fc71527bc45ae18
      result = vmul_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_f64(result, 0);
      exp = 0.18033310597398677;
      if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
         }
   }
}
}
void dotests_160() {

{
   {
      float64x2_t arg1;
      float64x2_t arg2;
      float64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmulq_f64\", rettype = \"float64x2_t\", argtypes = \"[float64x2_t,float64x2_t]\", vals = [VectorVal [FloatVal 0.5282711911118664,FloatVal 0.21838090102007368],VectorVal [FloatVal 0.7794159105630826,FloatVal 0.2216736436952591]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f64(vcreate_f64(UINT64_C(0x3fe0e798fc27d263)),
                          vcreate_f64(UINT64_C(0x3fcbf3e7c5f9e2a8)));
      arg2 = vcombine_f64(vcreate_f64(UINT64_C(0x3fe8f0f9a2bb374d)),
                          vcreate_f64(UINT64_C(0x3fcc5fcd4d0734a8)));
      clear_neon_saturated();
      //  Expect: "result" = 3fa8c91a3b1c61833fda59ff312d9f47
      result = vmulq_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float64_t got;
         float64_t exp;
         got = vgetq_lane_f64(result, 0);
         exp = 0.41174297144469957;
         if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float64_t got;
         float64_t exp;
         got = vgetq_lane_f64(result, 1);
         exp = 4.840929004257346e-2;
         if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
   }
}
}
void dotests_161() {

{
   {
      float32x2_t arg1;
      float32x2_t arg2;
      float32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mulx\", fnname = \"vmulx_f32\", rettype = \"float32x2_t\", argtypes = \"[float32x2_t,float32x2_t]\", vals = [VectorVal [FloatVal 0.9114170670509338,FloatVal 4.282456636428833e-2],VectorVal [FloatVal 0.21795672178268433,FloatVal 0.2854704260826111]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_f32(UINT64_C(0x3d2f68d03f6952a1));
      arg2 = vcreate_f32(UINT64_C(0x3e92292e3e5f300c));
      clear_neon_saturated();
      //  Expect: "result" = 3c484bfc3e4b6ac5
      result = vmulx_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float32_t got;
         float32_t exp;
         got = vget_lane_f32(result, 0);
         exp = ((float32_t) 0.19864948093891144);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vget_lane_f32(result, 1);
         exp = ((float32_t) 1.222514733672142e-2);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
   }
}
}
void dotests_162() {

{
   {
      float64x1_t arg1;
      float64x1_t arg2;
      float64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"mulx\", fnname = \"vmulx_f64\", rettype = \"float64x1_t\", argtypes = \"[float64x1_t,float64x1_t]\", vals = [VectorVal [FloatVal 0.21725456272085408],VectorVal [FloatVal 0.7407062564771136]], start_saturated = False}";
      int reported = 0;
      float64_t got;
      float64_t exp;
      arg1 = vcreate_f64(UINT64_C(0x3fcbceff5ce57c14));
      arg2 = vcreate_f64(UINT64_C(0x3fe7b3dd9b706098));
      clear_neon_saturated();
      //  Expect: "result" = 3fc4991603dc7bc6
      result = vmulx_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_f64(result, 0);
      exp = 0.1609218138555361;
      if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
         }
   }
}
}
void dotests_163() {

{
   {
      float32x4_t arg1;
      float32x4_t arg2;
      float32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mulx\", fnname = \"vmulxq_f32\", rettype = \"float32x4_t\", argtypes = \"[float32x4_t,float32x4_t]\", vals = [VectorVal [FloatVal 0.38123202323913574,FloatVal 0.38664060831069946,FloatVal 0.892707884311676,FloatVal 0.2679207921028137],VectorVal [FloatVal 5.2255451679229736e-2,FloatVal 0.3203023672103882,FloatVal 0.5177145600318909,FloatVal 0.36064422130584717]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f32(vcreate_f32(UINT64_C(0x3ec5f5c23ec330d8)),
                          vcreate_f32(UINT64_C(0x3e892cea3f648881)));
      arg2 = vcombine_f32(vcreate_f32(UINT64_C(0x3ea3feac3d5609d0)),
                          vcreate_f32(UINT64_C(0x3eb8a65c3f0488f1)));
      clear_neon_saturated();
      //  Expect: "result" = 3dc5e2d93eeca1443dfda0d33ca33250
      result = vmulxq_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 0);
         exp = ((float32_t) 1.9921451807022095e-2);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 1);
         exp = ((float32_t) 0.12384190410375595);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 2);
         exp = ((float32_t) 0.4621678590774536);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 2 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 3);
         exp = ((float32_t) 9.662408381700516e-2);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 3 ", exp, got);
            }
      }
   }
}
}
void dotests_164() {

{
   {
      float64x2_t arg1;
      float64x2_t arg2;
      float64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mulx\", fnname = \"vmulxq_f64\", rettype = \"float64x2_t\", argtypes = \"[float64x2_t,float64x2_t]\", vals = [VectorVal [FloatVal 0.7701882665996651,FloatVal 0.3714954672011004],VectorVal [FloatVal 0.4738158593183568,FloatVal 0.5629370150711849]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f64(vcreate_f64(UINT64_C(0x3fe8a561dd19df28)),
                          vcreate_f64(UINT64_C(0x3fd7c694ec8f6c00)));
      arg2 = vcombine_f64(vcreate_f64(UINT64_C(0x3fde52ffc1064d7c)),
                          vcreate_f64(UINT64_C(0x3fe203947cae08ff)));
      clear_neon_saturated();
      //  Expect: "result" = 3fcac4b96c34dfae3fd75af8849cfe55
      result = vmulxq_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float64_t got;
         float64_t exp;
         got = vgetq_lane_f64(result, 0);
         exp = 0.364927415375836;
         if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float64_t got;
         float64_t exp;
         got = vgetq_lane_f64(result, 1);
         exp = 0.2091285494186627;
         if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
   }
}
}
void dotests_165() {

{
   {
      float32_t arg1;
      float32_t arg2;
      float32_t result;
      char* str1 = "ReproInfo2 {semantics = \"mulx\", fnname = \"vmulxs_f32\", rettype = \"float32_t\", argtypes = \"[float32_t,float32_t]\", vals = [FloatVal 0.5359081029891968,FloatVal 0.5533544421195984], start_saturated = False}";
      int reported = 0;
      float32_t got;
      float32_t exp;
      arg1 = ((float32_t) 0.5359081029891968);
      arg2 = ((float32_t) 0.5533544421195984);
      clear_neon_saturated();
      //  Expect: "result" = 3e97d506
      result = vmulxs_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = ((float32_t) 0.2965471148490906);
      if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %f Got: %f\n", "   ", exp, got);
         }
   }
}
}
void dotests_166() {

{
   {
      float64_t arg1;
      float64_t arg2;
      float64_t result;
      char* str1 = "ReproInfo2 {semantics = \"mulx\", fnname = \"vmulxd_f64\", rettype = \"float64_t\", argtypes = \"[float64_t,float64_t]\", vals = [FloatVal 7.686030867368787e-2,FloatVal 0.6759700411672562], start_saturated = False}";
      int reported = 0;
      float64_t got;
      float64_t exp;
      arg1 = 7.686030867368787e-2;
      arg2 = 0.6759700411672562;
      clear_neon_saturated();
      //  Expect: "result" = 3faa99e170ce970f
      result = vmulxd_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 5.1955266018280814e-2;
      if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %f Got: %f\n", "   ", exp, got);
         }
   }
}
}
void dotests_167() {

{
   {
      int8x8_t arg1;
      int8x8_t arg2;
      int8x8_t arg3;
      int8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmla_s8\", rettype = \"int8x8_t\", argtypes = \"[int8x8_t,int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal (-128),IntegerVal 0,IntegerVal (-128),IntegerVal (-1),IntegerVal 127,IntegerVal 123,IntegerVal (-79),IntegerVal 0],VectorVal [IntegerVal 95,IntegerVal 127,IntegerVal 127,IntegerVal (-128),IntegerVal (-41),IntegerVal 0,IntegerVal 127,IntegerVal (-128)],VectorVal [IntegerVal 127,IntegerVal (-1),IntegerVal (-26),IntegerVal 0,IntegerVal (-114),IntegerVal (-1),IntegerVal (-128),IntegerVal (-128)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s8(UINT64_C(0x00b17b7fff800080));
      arg2 = vcreate_s8(UINT64_C(0x807f00d7807f7f5f));
      arg3 = vcreate_s8(UINT64_C(0x8080ff8e00e6ff7f));
      clear_neon_saturated();
      //  Expect: "result" = 00317bc1ff9a81a1
      result = vmla_s8(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s8(result), 0);
      exp = UINT64_C(0x00317bc1ff9a81a1);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_168() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      int16x4_t arg3;
      int16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmla_s16\", rettype = \"int16x4_t\", argtypes = \"[int16x4_t,int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal (-21535),IntegerVal (-32768),IntegerVal (-1)],VectorVal [IntegerVal (-1),IntegerVal (-32768),IntegerVal 0,IntegerVal (-1)],VectorVal [IntegerVal 2673,IntegerVal 9349,IntegerVal 32767,IntegerVal (-32768)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s16(UINT64_C(0xffff8000abe1ffff));
      arg2 = vcreate_s16(UINT64_C(0xffff00008000ffff));
      arg3 = vcreate_s16(UINT64_C(0x80007fff24850a71));
      clear_neon_saturated();
      //  Expect: "result" = 7fff80002be1f58e
      result = vmla_s16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s16(result), 0);
      exp = UINT64_C(0x7fff80002be1f58e);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_169() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      int32x2_t arg3;
      int32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmla_s32\", rettype = \"int32x2_t\", argtypes = \"[int32x2_t,int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal (-560604324),IntegerVal 2147450879],VectorVal [IntegerVal (-32769),IntegerVal 54423],VectorVal [IntegerVal (-32769),IntegerVal 2147450879]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s32(UINT64_C(0x7fff7fffde95db5c));
      arg2 = vcreate_s32(UINT64_C(0x0000d497ffff7fff));
      arg3 = vcreate_s32(UINT64_C(0x7fff7fffffff7fff));
      clear_neon_saturated();
      //  Expect: "result" = 95b32b681e96db5d
      result = vmla_s32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s32(result), 0);
      exp = UINT64_C(0x95b32b681e96db5d);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_170() {

{
   {
      uint8x8_t arg1;
      uint8x8_t arg2;
      uint8x8_t arg3;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmla_u8\", rettype = \"uint8x8_t\", argtypes = \"[uint8x8_t,uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 5,IntegerVal 0,IntegerVal 127,IntegerVal 113,IntegerVal 128,IntegerVal 0,IntegerVal 215,IntegerVal 128],VectorVal [IntegerVal 255,IntegerVal 255,IntegerVal 127,IntegerVal 255,IntegerVal 0,IntegerVal 128,IntegerVal 128,IntegerVal 255],VectorVal [IntegerVal 128,IntegerVal 255,IntegerVal 127,IntegerVal 255,IntegerVal 255,IntegerVal 0,IntegerVal 137,IntegerVal 255]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u8(UINT64_C(0x80d70080717f0005));
      arg2 = vcreate_u8(UINT64_C(0xff808000ff7fffff));
      arg3 = vcreate_u8(UINT64_C(0xff8900ffff7fff80));
      clear_neon_saturated();
      //  Expect: "result" = 8157008072800185
      result = vmla_u8(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0x8157008072800185);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_171() {

{
   {
      uint16x4_t arg1;
      uint16x4_t arg2;
      uint16x4_t arg3;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmla_u16\", rettype = \"uint16x4_t\", argtypes = \"[uint16x4_t,uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 65535,IntegerVal 0,IntegerVal 0],VectorVal [IntegerVal 0,IntegerVal 32768,IntegerVal 14478,IntegerVal 65535],VectorVal [IntegerVal 0,IntegerVal 23640,IntegerVal 44188,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u16(UINT64_C(0x00000000ffff0000));
      arg2 = vcreate_u16(UINT64_C(0xffff388e80000000));
      arg3 = vcreate_u16(UINT64_C(0x0000ac9c5c580000));
      clear_neon_saturated();
      //  Expect: "result" = 0000de88ffff0000
      result = vmla_u16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0x0000de88ffff0000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_172() {

{
   {
      uint32x2_t arg1;
      uint32x2_t arg2;
      uint32x2_t arg3;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmla_u32\", rettype = \"uint32x2_t\", argtypes = \"[uint32x2_t,uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 2147514489,IntegerVal 2147516415],VectorVal [IntegerVal 65535,IntegerVal 2292318208],VectorVal [IntegerVal 2147450880,IntegerVal 4294901760]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u32(UINT64_C(0x80007fff80007879));
      arg2 = vcreate_u32(UINT64_C(0x88a200000000ffff));
      arg3 = vcreate_u32(UINT64_C(0xffff00007fff8000));
      clear_neon_saturated();
      //  Expect: "result" = 80007fff8000f879
      result = vmla_u32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0x80007fff8000f879);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_173() {

{
   {
      int8x16_t arg1;
      int8x16_t arg2;
      int8x16_t arg3;
      int8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlaq_s8\", rettype = \"int8x16_t\", argtypes = \"[int8x16_t,int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal (-128),IntegerVal (-128),IntegerVal 0,IntegerVal (-128),IntegerVal 127,IntegerVal (-128),IntegerVal (-1),IntegerVal (-1),IntegerVal 127,IntegerVal 0,IntegerVal 0,IntegerVal (-48),IntegerVal (-128),IntegerVal 0,IntegerVal (-95)],VectorVal [IntegerVal 127,IntegerVal (-1),IntegerVal (-1),IntegerVal (-43),IntegerVal 127,IntegerVal 0,IntegerVal (-1),IntegerVal 0,IntegerVal 127,IntegerVal (-1),IntegerVal 127,IntegerVal (-1),IntegerVal 127,IntegerVal (-105),IntegerVal 0,IntegerVal 127],VectorVal [IntegerVal 0,IntegerVal (-128),IntegerVal 0,IntegerVal (-1),IntegerVal 102,IntegerVal (-128),IntegerVal 127,IntegerVal (-1),IntegerVal (-128),IntegerVal (-1),IntegerVal (-128),IntegerVal (-1),IntegerVal (-1),IntegerVal (-30),IntegerVal 59,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s8(vcreate_s8(UINT64_C(0xff807f80008080ff)),
                         vcreate_s8(UINT64_C(0xa10080d000007fff)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0x00ff007fd5ffff7f)),
                         vcreate_s8(UINT64_C(0x7f00977fff7fff7f)));
      arg3 = vcombine_s8(vcreate_s8(UINT64_C(0xff7f8066ff008000)),
                         vcreate_s8(UINT64_C(0x003be2ffff80ff80)));
      clear_neon_saturated();
      //  Expect: "result" = a100ce510180807fff017f1a2b8000ff
      result = vmlaq_s8(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 0);
         exp = UINT64_C(0xff017f1a2b8000ff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 1);
         exp = UINT64_C(0xa100ce510180807f);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_174() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int16x8_t arg3;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlaq_s16\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 32767,IntegerVal 0,IntegerVal 0,IntegerVal (-9346),IntegerVal 32767,IntegerVal 32767,IntegerVal (-32768)],VectorVal [IntegerVal (-1),IntegerVal (-1),IntegerVal (-32768),IntegerVal 8824,IntegerVal 0,IntegerVal 0,IntegerVal 32767,IntegerVal 32767],VectorVal [IntegerVal (-32768),IntegerVal 0,IntegerVal (-32768),IntegerVal (-5827),IntegerVal (-32768),IntegerVal 32767,IntegerVal 32767,IntegerVal 32188]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x000000007fff7fff)),
                          vcreate_s16(UINT64_C(0x80007fff7fffdb7e)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x22788000ffffffff)),
                          vcreate_s16(UINT64_C(0x7fff7fff00000000)));
      arg3 = vcombine_s16(vcreate_s16(UINT64_C(0xe93d800000008000)),
                          vcreate_s16(UINT64_C(0x7dbc7fff7fff8000)));
      clear_neon_saturated();
      //  Expect: "result" = 024480007fffdb7e6e9800007fffffff
      result = vmlaq_s16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x6e9800007fffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x024480007fffdb7e);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_175() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int32x4_t arg3;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlaq_s32\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal 2147483647,IntegerVal 2147418112,IntegerVal (-2147461487),IntegerVal (-2147483648)],VectorVal [IntegerVal 32768,IntegerVal (-32768),IntegerVal 0,IntegerVal (-32769)],VectorVal [IntegerVal (-1),IntegerVal (-1),IntegerVal (-65536),IntegerVal (-32768)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x7fff00007fffffff)),
                          vcreate_s32(UINT64_C(0x8000000080005691)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0xffff800000008000)),
                          vcreate_s32(UINT64_C(0xffff7fff00000000)));
      arg3 = vcombine_s32(vcreate_s32(UINT64_C(0xffffffffffffffff)),
                          vcreate_s32(UINT64_C(0xffff8000ffff0000)));
      clear_neon_saturated();
      //  Expect: "result" = c0008000800056917fff80007fff7fff
      result = vmlaq_s32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x7fff80007fff7fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0xc000800080005691);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_176() {

{
   {
      uint8x16_t arg1;
      uint8x16_t arg2;
      uint8x16_t arg3;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlaq_u8\", rettype = \"uint8x16_t\", argtypes = \"[uint8x16_t,uint8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 127,IntegerVal 127,IntegerVal 255,IntegerVal 0,IntegerVal 127,IntegerVal 127,IntegerVal 127,IntegerVal 34,IntegerVal 127,IntegerVal 0,IntegerVal 0,IntegerVal 127,IntegerVal 255,IntegerVal 0,IntegerVal 127,IntegerVal 255],VectorVal [IntegerVal 128,IntegerVal 255,IntegerVal 255,IntegerVal 128,IntegerVal 127,IntegerVal 255,IntegerVal 255,IntegerVal 0,IntegerVal 128,IntegerVal 128,IntegerVal 255,IntegerVal 127,IntegerVal 128,IntegerVal 255,IntegerVal 107,IntegerVal 32],VectorVal [IntegerVal 117,IntegerVal 255,IntegerVal 127,IntegerVal 128,IntegerVal 255,IntegerVal 0,IntegerVal 255,IntegerVal 128,IntegerVal 171,IntegerVal 0,IntegerVal 128,IntegerVal 204,IntegerVal 124,IntegerVal 190,IntegerVal 255,IntegerVal 162]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u8(vcreate_u8(UINT64_C(0x227f7f7f00ff7f7f)),
                         vcreate_u8(UINT64_C(0xff7f00ff7f00007f)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0x00ffff7f80ffff80)),
                         vcreate_u8(UINT64_C(0x206bff807fff8080)));
      arg3 = vcombine_u8(vcreate_u8(UINT64_C(0x80ff00ff807fff75)),
                         vcreate_u8(UINT64_C(0xa2ffbe7ccc8000ab)));
      clear_neon_saturated();
      //  Expect: "result" = 3f1442ffb38000ff22807f00008080ff
      result = vmlaq_u8(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x22807f00008080ff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0x3f1442ffb38000ff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_177() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint16x8_t arg3;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlaq_u16\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 19965,IntegerVal 32767,IntegerVal 0,IntegerVal 32767,IntegerVal 32768,IntegerVal 32767,IntegerVal 32768,IntegerVal 32767],VectorVal [IntegerVal 32768,IntegerVal 65535,IntegerVal 32768,IntegerVal 32768,IntegerVal 443,IntegerVal 0,IntegerVal 8403,IntegerVal 32768],VectorVal [IntegerVal 65535,IntegerVal 0,IntegerVal 65535,IntegerVal 0,IntegerVal 32767,IntegerVal 32767,IntegerVal 65535,IntegerVal 32768]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x7fff00007fff4dfd)),
                          vcreate_u16(UINT64_C(0x7fff80007fff8000)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0x80008000ffff8000)),
                          vcreate_u16(UINT64_C(0x800020d3000001bb)));
      arg3 = vcombine_u16(vcreate_u16(UINT64_C(0x0000ffff0000ffff)),
                          vcreate_u16(UINT64_C(0x8000ffff7fff7fff)));
      clear_neon_saturated();
      //  Expect: "result" = 7fff5f2d7ffffe457fff80007fffcdfd
      result = vmlaq_u16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x7fff80007fffcdfd);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x7fff5f2d7ffffe45);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_178() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint32x4_t arg3;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlaq_u32\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 4294934527,IntegerVal 0,IntegerVal 4294901760,IntegerVal 614465536],VectorVal [IntegerVal 2147483648,IntegerVal 2147483648,IntegerVal 4294931689,IntegerVal 2147418112],VectorVal [IntegerVal 32768,IntegerVal 0,IntegerVal 42333,IntegerVal 2147511490]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x00000000ffff7fff)),
                          vcreate_u32(UINT64_C(0x24a00000ffff0000)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x8000000080000000)),
                          vcreate_u32(UINT64_C(0x7fff0000ffff74e9)));
      arg3 = vcombine_u32(vcreate_u32(UINT64_C(0x0000000000008000)),
                          vcreate_u32(UINT64_C(0x80006cc20000a55d)));
      clear_neon_saturated();
      //  Expect: "result" = b7de0000a626a5a500000000ffff7fff
      result = vmlaq_u32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x00000000ffff7fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0xb7de0000a626a5a5);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_179() {

{
   {
      float32x2_t arg1;
      float32x2_t arg2;
      float32x2_t arg3;
      float32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vfma_f32\", rettype = \"float32x2_t\", argtypes = \"[float32x2_t,float32x2_t,float32x2_t]\", vals = [VectorVal [FloatVal 0.6816774010658264,FloatVal 0.1872469186782837],VectorVal [FloatVal 0.8370440006256104,FloatVal 0.832042396068573],VectorVal [FloatVal 0.4559548497200012,FloatVal 0.4626467227935791]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_f32(UINT64_C(0x3e3fbda83f2e8269));
      arg2 = vcreate_f32(UINT64_C(0x3f5500bb3f564884));
      arg3 = vcreate_f32(UINT64_C(0x3eece0083ee972ea));
      clear_neon_saturated();
      //  Expect: "result" = 3f127af43f881b41
      result = vfma_f32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float32_t got;
         float32_t exp;
         got = vget_lane_f32(result, 0);
         exp = ((float32_t) 1.0633317232131958);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vget_lane_f32(result, 1);
         exp = ((float32_t) 0.5721886157989502);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
   }
}
}
void dotests_180() {

{
   {
      float32x4_t arg1;
      float32x4_t arg2;
      float32x4_t arg3;
      float32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vfmaq_f32\", rettype = \"float32x4_t\", argtypes = \"[float32x4_t,float32x4_t,float32x4_t]\", vals = [VectorVal [FloatVal 0.646003782749176,FloatVal 0.20977479219436646,FloatVal 0.9382407665252686,FloatVal 0.16961604356765747],VectorVal [FloatVal 0.451129674911499,FloatVal 0.9493672251701355,FloatVal 0.6505329608917236,FloatVal 0.9197012186050415],VectorVal [FloatVal 0.49465763568878174,FloatVal 0.9820606708526611,FloatVal 0.48356926441192627,FloatVal 0.790895938873291]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f32(vcreate_f32(UINT64_C(0x3e56cf343f256081)),
                          vcreate_f32(UINT64_C(0x3e2dafd43f70308c)));
      arg2 = vcombine_f32(vcreate_f32(UINT64_C(0x3f7309bb3ee6fa78)),
                          vcreate_f32(UINT64_C(0x3f6b718a3f268954)));
      arg3 = vcombine_f32(vcreate_f32(UINT64_C(0x3f7b68543efd43c4)),
                          vcreate_f32(UINT64_C(0x3f4a78283ef79664)));
      clear_neon_saturated();
      //  Expect: "result" = 3f65a20e3fa05c5b3f9230b23f5e812c
      result = vfmaq_f32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 0);
         exp = ((float32_t) 0.8691585063934326);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 1);
         exp = ((float32_t) 1.14211106300354);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 2);
         exp = ((float32_t) 1.2528184652328491);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 2 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 3);
         exp = ((float32_t) 0.8970040082931519);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 3 ", exp, got);
            }
      }
   }
}
}
void dotests_181() {

{
   {
      float64x2_t arg1;
      float64x2_t arg2;
      float64x2_t arg3;
      float64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vfmaq_f64\", rettype = \"float64x2_t\", argtypes = \"[float64x2_t,float64x2_t,float64x2_t]\", vals = [VectorVal [FloatVal 0.8560766867377201,FloatVal 0.700111108896245],VectorVal [FloatVal 0.7552425211492262,FloatVal 0.6176368786088501],VectorVal [FloatVal 0.21216571182409016,FloatVal 0.25495304625431137]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f64(vcreate_f64(UINT64_C(0x3feb64faef8d026a)),
                          vcreate_f64(UINT64_C(0x3fe6674f6988d243)));
      arg2 = vcombine_f64(vcreate_f64(UINT64_C(0x3fe82af25d1c4df2)),
                          vcreate_f64(UINT64_C(0x3fe3c3ae6a4db68b)));
      arg3 = vcombine_f64(vcreate_f64(UINT64_C(0x3fcb283efccefac4)),
                          vcreate_f64(UINT64_C(0x3fd0512694eb61c6)));
      clear_neon_saturated();
      //  Expect: "result" = 3feb714a97078d6b3ff042d1afbb8d36
      result = vfmaq_f64(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float64_t got;
         float64_t exp;
         got = vgetq_lane_f64(result, 0);
         exp = 1.0163132538371662;
         if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float64_t got;
         float64_t exp;
         got = vgetq_lane_f64(result, 1);
         exp = 0.8575795125765756;
         if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
   }
}
}
void dotests_182() {

{
   {
      float64x1_t arg1;
      float64x1_t arg2;
      float64x1_t arg3;
      float64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vfma_f64\", rettype = \"float64x1_t\", argtypes = \"[float64x1_t,float64x1_t,float64x1_t]\", vals = [VectorVal [FloatVal 0.6841847921940517],VectorVal [FloatVal 0.16055718104871064],VectorVal [FloatVal 0.32731033977065116]], start_saturated = False}";
      int reported = 0;
      float64_t got;
      float64_t exp;
      arg1 = vcreate_f64(UINT64_C(0x3fe5e4d7815c9bb7));
      arg2 = vcreate_f64(UINT64_C(0x3fc48d2340deff34));
      arg3 = vcreate_f64(UINT64_C(0x3fd4f2a7113d493c));
      clear_neon_saturated();
      //  Expect: "result" = 3fe793591735a4a0
      result = vfma_f64(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_f64(result, 0);
      exp = 0.7367368176757232;
      if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
         }
   }
}
}
void dotests_183() {

{
   {
      float32x2_t arg1;
      float32x2_t arg2;
      float32x2_t arg3;
      float32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmla_f32\", rettype = \"float32x2_t\", argtypes = \"[float32x2_t,float32x2_t,float32x2_t]\", vals = [VectorVal [FloatVal 0.8686251640319824,FloatVal 8.819437026977539e-2],VectorVal [FloatVal 8.273643255233765e-2,FloatVal 0.8943750262260437],VectorVal [FloatVal 0.6253815293312073,FloatVal 0.439550518989563]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_f32(UINT64_C(0x3db49f403f5e5e38));
      arg2 = vcreate_f32(UINT64_C(0x3f64f5c33da971b8));
      arg3 = vcreate_f32(UINT64_C(0x3ee10cc43f201901));
      clear_neon_saturated();
      //  Expect: "result" = 3ef66f3b3f6b9d2c
      result = vmla_f32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float32_t got;
         float32_t exp;
         got = vget_lane_f32(result, 0);
         exp = ((float32_t) 0.9203670024871826);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vget_lane_f32(result, 1);
         exp = ((float32_t) 0.4813173711299896);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
   }
}
}
void dotests_184() {

{
   {
      float32x4_t arg1;
      float32x4_t arg2;
      float32x4_t arg3;
      float32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlaq_f32\", rettype = \"float32x4_t\", argtypes = \"[float32x4_t,float32x4_t,float32x4_t]\", vals = [VectorVal [FloatVal 0.8419051170349121,FloatVal 0.3875741958618164,FloatVal 0.30864405632019043,FloatVal 0.9758923053741455],VectorVal [FloatVal 0.21739304065704346,FloatVal 0.5994455218315125,FloatVal 0.20237034559249878,FloatVal 0.11964911222457886],VectorVal [FloatVal 0.46991485357284546,FloatVal 0.11324018239974976,FloatVal 0.4986122250556946,FloatVal 0.7726595997810364]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f32(vcreate_f32(UINT64_C(0x3ec670203f578718)),
                          vcreate_f32(UINT64_C(0x3f79d4143e9e0698)));
      arg2 = vcombine_f32(vcreate_f32(UINT64_C(0x3f1975433e5e9c48)),
                          vcreate_f32(UINT64_C(0x3df50a983e4f3a2c)));
      arg3 = vcombine_f32(vcreate_f32(UINT64_C(0x3de7ea783ef098ae)),
                          vcreate_f32(UINT64_C(0x3f45cd053eff4a1a)));
      clear_neon_saturated();
      //  Expect: "result" = 3f88bf603ed1b0533ee931773f71ae01
      result = vmlaq_f32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 0);
         exp = ((float32_t) 0.9440613389015198);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 1);
         exp = ((float32_t) 0.4554555118083954);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 2);
         exp = ((float32_t) 0.4095483720302582);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 2 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 3);
         exp = ((float32_t) 1.0683403015136719);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 3 ", exp, got);
            }
      }
   }
}
}
void dotests_185() {

{
   {
      float64x2_t arg1;
      float64x2_t arg2;
      float64x2_t arg3;
      float64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlaq_f64\", rettype = \"float64x2_t\", argtypes = \"[float64x2_t,float64x2_t,float64x2_t]\", vals = [VectorVal [FloatVal 0.25790008903029327,FloatVal 0.9719934866758558],VectorVal [FloatVal 0.6230205599330156,FloatVal 0.9749433731966858],VectorVal [FloatVal 1.8476889375302563e-2,FloatVal 0.35170675216548886]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f64(vcreate_f64(UINT64_C(0x3fd0816f6001517a)),
                          vcreate_f64(UINT64_C(0x3fef1a9215a6547b)));
      arg2 = vcombine_f64(vcreate_f64(UINT64_C(0x3fe3efc8d034bbae)),
                          vcreate_f64(UINT64_C(0x3fef32bc71ea9d31)));
      arg3 = vcombine_f64(vcreate_f64(UINT64_C(0x3f92eb9b0e651aa0)),
                          vcreate_f64(UINT64_C(0x3fd6825d0995525c)));
      clear_neon_saturated();
      //  Expect: "result" = 3ff509c7a2fe10b03fd13e0a07a585a3
      result = vmlaq_f64(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float64_t got;
         float64_t exp;
         got = vgetq_lane_f64(result, 0);
         exp = 0.26941157099471463;
         if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float64_t got;
         float64_t exp;
         got = vgetq_lane_f64(result, 1);
         exp = 1.3148876540081282;
         if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
   }
}
}
void dotests_186() {

{
   {
      float64x1_t arg1;
      float64x1_t arg2;
      float64x1_t arg3;
      float64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmla_f64\", rettype = \"float64x1_t\", argtypes = \"[float64x1_t,float64x1_t,float64x1_t]\", vals = [VectorVal [FloatVal 0.3522100259880828],VectorVal [FloatVal 0.2371403955016521],VectorVal [FloatVal 0.8474060149039537]], start_saturated = False}";
      int reported = 0;
      float64_t got;
      float64_t exp;
      arg1 = vcreate_f64(UINT64_C(0x3fd68a9bebbc4bca));
      arg2 = vcreate_f64(UINT64_C(0x3fce5a9dd19ebba4));
      arg3 = vcreate_f64(UINT64_C(0x3feb1df3380e4706));
      clear_neon_saturated();
      //  Expect: "result" = 3fe1b3857529c330
      result = vmla_f64(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_f64(result, 0);
      exp = 0.5531642235128853;
      if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
         }
   }
}
}
void dotests_187() {

{
   {
      int16x8_t arg1;
      int8x8_t arg2;
      int8x8_t arg3;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlal_s8\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal (-32768),IntegerVal (-32768),IntegerVal (-1),IntegerVal (-32768),IntegerVal 32767,IntegerVal 0,IntegerVal (-1)],VectorVal [IntegerVal (-1),IntegerVal (-1),IntegerVal (-128),IntegerVal (-128),IntegerVal 0,IntegerVal 0,IntegerVal (-1),IntegerVal (-112)],VectorVal [IntegerVal 127,IntegerVal 0,IntegerVal (-99),IntegerVal (-106),IntegerVal (-1),IntegerVal (-128),IntegerVal 0,IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0xffff80008000ffff)),
                          vcreate_s16(UINT64_C(0xffff00007fff8000)));
      arg2 = vcreate_s8(UINT64_C(0x90ff00008080ffff));
      arg3 = vcreate_s8(UINT64_C(0xff0080ff969d007f));
      clear_neon_saturated();
      //  Expect: "result" = 006f00007fff800034ffb1808000ff80
      result = vmlal_s8(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x34ffb1808000ff80);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x006f00007fff8000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_188() {

{
   {
      int32x4_t arg1;
      int16x4_t arg2;
      int16x4_t arg3;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlal_s16\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal (-3601),IntegerVal 2147483647,IntegerVal (-1208975361),IntegerVal (-61875)],VectorVal [IntegerVal 32767,IntegerVal (-32768),IntegerVal 32767,IntegerVal 32767],VectorVal [IntegerVal 32302,IntegerVal 10208,IntegerVal 32767,IntegerVal (-31526)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x7ffffffffffff1ef)),
                          vcreate_s32(UINT64_C(0xffff0e4db7f07fff)));
      arg2 = vcreate_s16(UINT64_C(0x7fff7fff80007fff));
      arg3 = vcreate_s16(UINT64_C(0x84da7fff27e07e2e));
      clear_neon_saturated();
      //  Expect: "result" = c26c8973f7ef80006c0fffff3f1673c1
      result = vmlal_s16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x6c0fffff3f1673c1);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0xc26c8973f7ef8000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_189() {

{
   {
      int64x2_t arg1;
      int32x2_t arg2;
      int32x2_t arg3;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlal_s32\", rettype = \"int64x2_t\", argtypes = \"[int64x2_t,int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal 281470681808895,IntegerVal (-181770376773632)],VectorVal [IntegerVal (-32769),IntegerVal 32768],VectorVal [IntegerVal 32767,IntegerVal 2147483647]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x0000ffff0000ffff)),
                          vcreate_s64(UINT64_C(0xffff5aae49430000)));
      arg2 = vcreate_s32(UINT64_C(0x00008000ffff7fff));
      arg3 = vcreate_s32(UINT64_C(0x7fffffff00007fff));
      clear_neon_saturated();
      //  Expect: "result" = ffff9aae494280000000fffec0010000
      result = vmlal_s32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x0000fffec0010000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0xffff9aae49428000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_190() {

{
   {
      uint16x8_t arg1;
      uint8x8_t arg2;
      uint8x8_t arg3;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlal_u8\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 32768,IntegerVal 32767,IntegerVal 0,IntegerVal 32768,IntegerVal 65535,IntegerVal 65535,IntegerVal 35712],VectorVal [IntegerVal 255,IntegerVal 0,IntegerVal 71,IntegerVal 0,IntegerVal 128,IntegerVal 0,IntegerVal 41,IntegerVal 128],VectorVal [IntegerVal 0,IntegerVal 127,IntegerVal 128,IntegerVal 127,IntegerVal 129,IntegerVal 150,IntegerVal 255,IntegerVal 143]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x00007fff80007fff)),
                          vcreate_u16(UINT64_C(0x8b80ffffffff8000)));
      arg2 = vcreate_u8(UINT64_C(0x80290080004700ff));
      arg3 = vcreate_u8(UINT64_C(0x8fff96817f807f00));
      clear_neon_saturated();
      //  Expect: "result" = d30028d6ffffc0800000a37f80007fff
      result = vmlal_u8(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x0000a37f80007fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0xd30028d6ffffc080);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_191() {

{
   {
      uint32x4_t arg1;
      uint16x4_t arg2;
      uint16x4_t arg3;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlal_u16\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 65535,IntegerVal 32768,IntegerVal 2147483648,IntegerVal 2147450880],VectorVal [IntegerVal 22690,IntegerVal 32767,IntegerVal 0,IntegerVal 6382],VectorVal [IntegerVal 0,IntegerVal 23896,IntegerVal 32767,IntegerVal 1283]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x000080000000ffff)),
                          vcreate_u32(UINT64_C(0x7fff800080000000)));
      arg2 = vcreate_u16(UINT64_C(0x18ee00007fff58a2));
      arg3 = vcreate_u16(UINT64_C(0x05037fff5d580000));
      clear_neon_saturated();
      //  Expect: "result" = 807c70ca800000002eac22a80000ffff
      result = vmlal_u16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x2eac22a80000ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0x807c70ca80000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_192() {

{
   {
      uint64x2_t arg1;
      uint32x2_t arg2;
      uint32x2_t arg3;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlal_u32\", rettype = \"uint64x2_t\", argtypes = \"[uint64x2_t,uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 140735340838911,IntegerVal 16705258389637136383],VectorVal [IntegerVal 65535,IntegerVal 4294901760],VectorVal [IntegerVal 32768,IntegerVal 2147484557]], start_saturated = True}";
      int reported = 0;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0x00007fff7fff7fff)),
                          vcreate_u64(UINT64_C(0xe7d4ffff436f7fff)));
      arg2 = vcreate_u32(UINT64_C(0xffff00000000ffff));
      arg3 = vcreate_u32(UINT64_C(0x8000038d00008000));
      set_neon_saturated();
      //  Expect: "result" = 67d4838c3fe27fff00007ffffffeffff
      result = vmlal_u32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0x00007ffffffeffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0x67d4838c3fe27fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_193() {

{
   {
      int16x8_t arg1;
      int8x16_t arg2;
      int8x16_t arg3;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlal_high_s8\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal (-32768),IntegerVal (-7611),IntegerVal (-2383),IntegerVal 29259,IntegerVal (-32768),IntegerVal 32767,IntegerVal (-1),IntegerVal (-32768)],VectorVal [IntegerVal 127,IntegerVal (-1),IntegerVal 93,IntegerVal 0,IntegerVal 0,IntegerVal 127,IntegerVal 127,IntegerVal 127,IntegerVal 49,IntegerVal (-97),IntegerVal (-1),IntegerVal (-40),IntegerVal 0,IntegerVal (-1),IntegerVal 127,IntegerVal (-128)],VectorVal [IntegerVal (-88),IntegerVal (-128),IntegerVal (-1),IntegerVal (-1),IntegerVal 0,IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal (-128),IntegerVal (-128),IntegerVal (-128),IntegerVal (-128),IntegerVal (-128),IntegerVal (-1),IntegerVal 119,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x724bf6b1e2458000)),
                          vcreate_s16(UINT64_C(0x8000ffff7fff8000)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0x7f7f7f00005dff7f)),
                         vcreate_s8(UINT64_C(0x807fff00d8ff9f31)));
      arg3 = vcombine_s8(vcreate_s8(UINT64_C(0x007f0000ffff80a8)),
                         vcreate_s8(UINT64_C(0x0077ff8080808080)));
      clear_neon_saturated();
      //  Expect: "result" = 80003b0880008000864bf73112c56780
      result = vmlal_high_s8(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x864bf73112c56780);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x80003b0880008000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_194() {

{
   {
      int32x4_t arg1;
      int16x8_t arg2;
      int16x8_t arg3;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlal_high_s16\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal 2147450880,IntegerVal 12334,IntegerVal 2147450880,IntegerVal (-2147450881)],VectorVal [IntegerVal 32767,IntegerVal (-1),IntegerVal (-32768),IntegerVal (-32768),IntegerVal 32767,IntegerVal (-1),IntegerVal (-32768),IntegerVal (-32768)],VectorVal [IntegerVal (-32768),IntegerVal 0,IntegerVal 32767,IntegerVal 32767,IntegerVal (-1),IntegerVal 0,IntegerVal (-1),IntegerVal (-32768)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x0000302e7fff8000)),
                          vcreate_s32(UINT64_C(0x80007fff7fff8000)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x80008000ffff7fff)),
                          vcreate_s16(UINT64_C(0x80008000ffff7fff)));
      arg3 = vcombine_s16(vcreate_s16(UINT64_C(0x7fff7fff00008000)),
                          vcreate_s16(UINT64_C(0x8000ffff0000ffff)));
      clear_neon_saturated();
      //  Expect: "result" = c0007fff800000000000302e7fff0001
      result = vmlal_high_s16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x0000302e7fff0001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0xc0007fff80000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_195() {

{
   {
      int64x2_t arg1;
      int32x4_t arg2;
      int32x4_t arg3;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlal_high_s32\", rettype = \"int64x2_t\", argtypes = \"[int64x2_t,int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal (-3952049412653481985),IntegerVal (-9223231301036900353)],VectorVal [IntegerVal 32768,IntegerVal (-65536),IntegerVal (-2147418113),IntegerVal 0],VectorVal [IntegerVal 33034,IntegerVal 2147483647,IntegerVal 2076593817,IntegerVal 2147418112]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0xc9277fff7fff7fff)),
                          vcreate_s64(UINT64_C(0x80007fff9c6e7fff)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0xffff000000008000)),
                          vcreate_s32(UINT64_C(0x000000008000ffff)));
      arg3 = vcombine_s32(vcreate_s32(UINT64_C(0x7fffffff0000810a)),
                          vcreate_s32(UINT64_C(0x7fff00007bc64e99)));
      clear_neon_saturated();
      //  Expect: "result" = 80007fff9c6e7fff8b44d478d2d23166
      result = vmlal_high_s32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x8b44d478d2d23166);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0x80007fff9c6e7fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_196() {

{
   {
      uint16x8_t arg1;
      uint8x16_t arg2;
      uint8x16_t arg3;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlal_high_u8\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 65535,IntegerVal 0,IntegerVal 0,IntegerVal 32767,IntegerVal 65535,IntegerVal 32768,IntegerVal 32767],VectorVal [IntegerVal 255,IntegerVal 0,IntegerVal 0,IntegerVal 0,IntegerVal 255,IntegerVal 127,IntegerVal 0,IntegerVal 128,IntegerVal 127,IntegerVal 205,IntegerVal 61,IntegerVal 128,IntegerVal 0,IntegerVal 127,IntegerVal 92,IntegerVal 255],VectorVal [IntegerVal 0,IntegerVal 128,IntegerVal 128,IntegerVal 0,IntegerVal 127,IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal 127,IntegerVal 159,IntegerVal 0,IntegerVal 255,IntegerVal 255,IntegerVal 0,IntegerVal 127,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x00000000ffff0000)),
                          vcreate_u16(UINT64_C(0x7fff8000ffff7fff)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0x80007fff000000ff)),
                         vcreate_u8(UINT64_C(0xff5c7f00803dcd7f)));
      arg3 = vcombine_u8(vcreate_u8(UINT64_C(0x7f007f7f00808000)),
                         vcreate_u8(UINT64_C(0x007f00ffff009f7f)));
      clear_neon_saturated();
      //  Expect: "result" = 7fffada4ffff7fff7f8000007f523f01
      result = vmlal_high_u8(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x7f8000007f523f01);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x7fffada4ffff7fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_197() {

{
   {
      uint32x4_t arg1;
      uint16x8_t arg2;
      uint16x8_t arg3;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlal_high_u16\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 4294967295,IntegerVal 2147516415,IntegerVal 2147549183,IntegerVal 2147457244],VectorVal [IntegerVal 11650,IntegerVal 65535,IntegerVal 22745,IntegerVal 65535,IntegerVal 32767,IntegerVal 0,IntegerVal 0,IntegerVal 50452],VectorVal [IntegerVal 29127,IntegerVal 32767,IntegerVal 0,IntegerVal 25983,IntegerVal 0,IntegerVal 32768,IntegerVal 0,IntegerVal 34000]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x80007fffffffffff)),
                          vcreate_u32(UINT64_C(0x7fff98dc8000ffff)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0xffff58d9ffff2d82)),
                          vcreate_u16(UINT64_C(0xc514000000007fff)));
      arg3 = vcombine_u16(vcreate_u16(UINT64_C(0x657f00007fff71c7)),
                          vcreate_u16(UINT64_C(0x84d0000080000000)));
      clear_neon_saturated();
      //  Expect: "result" = e63e091c8000ffff80007fffffffffff
      result = vmlal_high_u16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x80007fffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0xe63e091c8000ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_198() {

{
   {
      uint64x2_t arg1;
      uint32x4_t arg2;
      uint32x4_t arg3;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mla\", fnname = \"vmlal_high_u32\", rettype = \"uint64x2_t\", argtypes = \"[uint64x2_t,uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 8820159134864244735,IntegerVal 18446603334073745407],VectorVal [IntegerVal 32767,IntegerVal 2147483647,IntegerVal 3547561983,IntegerVal 4294934528],VectorVal [IntegerVal 469172224,IntegerVal 1001546775,IntegerVal 848789504,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0x7a6780007fffffff)),
                          vcreate_u64(UINT64_C(0xffff7fff80007fff)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x7fffffff00007fff)),
                          vcreate_u32(UINT64_C(0xffff8000d3737fff)));
      arg3 = vcombine_u32(vcreate_u32(UINT64_C(0x3bb264171bf70000)),
                          vcreate_u32(UINT64_C(0x0000000032978000)));
      clear_neon_saturated();
      //  Expect: "result" = ffff7fff80007fffa43131da8d687fff
      result = vmlal_high_u32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0xa43131da8d687fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0xffff7fff80007fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_199() {

{
   {
      int8x8_t arg1;
      int8x8_t arg2;
      int8x8_t arg3;
      int8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmls_s8\", rettype = \"int8x8_t\", argtypes = \"[int8x8_t,int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal (-108),IntegerVal (-128),IntegerVal (-1),IntegerVal (-1),IntegerVal (-1),IntegerVal (-1),IntegerVal (-1),IntegerVal 0],VectorVal [IntegerVal (-1),IntegerVal (-128),IntegerVal 127,IntegerVal 0,IntegerVal (-128),IntegerVal (-1),IntegerVal (-128),IntegerVal (-113)],VectorVal [IntegerVal (-128),IntegerVal 127,IntegerVal (-128),IntegerVal (-1),IntegerVal 122,IntegerVal 0,IntegerVal 127,IntegerVal (-101)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s8(UINT64_C(0x00ffffffffff8094));
      arg2 = vcreate_s8(UINT64_C(0x8f80ff80007f80ff));
      arg3 = vcreate_s8(UINT64_C(0x9b7f007aff807f80));
      clear_neon_saturated();
      //  Expect: "result" = 6b7fffffff7f0014
      result = vmls_s8(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s8(result), 0);
      exp = UINT64_C(0x6b7fffffff7f0014);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_200() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      int16x4_t arg3;
      int16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmls_s16\", rettype = \"int16x4_t\", argtypes = \"[int16x4_t,int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 32767,IntegerVal (-1),IntegerVal 0],VectorVal [IntegerVal 682,IntegerVal (-25352),IntegerVal (-1),IntegerVal (-1)],VectorVal [IntegerVal (-25999),IntegerVal 0,IntegerVal (-32768),IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s16(UINT64_C(0x0000ffff7fff7fff));
      arg2 = vcreate_s16(UINT64_C(0xffffffff9cf802aa));
      arg3 = vcreate_s16(UINT64_C(0xffff800000009a71));
      clear_neon_saturated();
      //  Expect: "result" = ffff7fff7fff0ef5
      result = vmls_s16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s16(result), 0);
      exp = UINT64_C(0xffff7fff7fff0ef5);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_201() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      int32x2_t arg3;
      int32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmls_s32\", rettype = \"int32x2_t\", argtypes = \"[int32x2_t,int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal (-2147418113),IntegerVal 2147483647],VectorVal [IntegerVal 32767,IntegerVal (-1379434497)],VectorVal [IntegerVal (-2147450880),IntegerVal 2147450879]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s32(UINT64_C(0x7fffffff8000ffff));
      arg2 = vcreate_s32(UINT64_C(0xadc77fff00007fff));
      arg3 = vcreate_s32(UINT64_C(0x7fff7fff80008000));
      clear_neon_saturated();
      //  Expect: "result" = 6dc6fffec0017fff
      result = vmls_s32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s32(result), 0);
      exp = UINT64_C(0x6dc6fffec0017fff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_202() {

{
   {
      uint8x8_t arg1;
      uint8x8_t arg2;
      uint8x8_t arg3;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmls_u8\", rettype = \"uint8x8_t\", argtypes = \"[uint8x8_t,uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 255,IntegerVal 55,IntegerVal 127,IntegerVal 255,IntegerVal 255,IntegerVal 127,IntegerVal 255,IntegerVal 144],VectorVal [IntegerVal 91,IntegerVal 0,IntegerVal 0,IntegerVal 74,IntegerVal 255,IntegerVal 0,IntegerVal 128,IntegerVal 194],VectorVal [IntegerVal 255,IntegerVal 20,IntegerVal 127,IntegerVal 0,IntegerVal 128,IntegerVal 127,IntegerVal 220,IntegerVal 255]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u8(UINT64_C(0x90ff7fffff7f37ff));
      arg2 = vcreate_u8(UINT64_C(0xc28000ff4a00005b));
      arg3 = vcreate_u8(UINT64_C(0xffdc7f80007f14ff));
      clear_neon_saturated();
      //  Expect: "result" = 52ff7f7fff7f375a
      result = vmls_u8(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0x52ff7f7fff7f375a);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_203() {

{
   {
      uint16x4_t arg1;
      uint16x4_t arg2;
      uint16x4_t arg3;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmls_u16\", rettype = \"uint16x4_t\", argtypes = \"[uint16x4_t,uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 65535,IntegerVal 0,IntegerVal 65535,IntegerVal 0],VectorVal [IntegerVal 28278,IntegerVal 7384,IntegerVal 29744,IntegerVal 0],VectorVal [IntegerVal 0,IntegerVal 32767,IntegerVal 32767,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u16(UINT64_C(0x0000ffff0000ffff));
      arg2 = vcreate_u16(UINT64_C(0x000074301cd86e76));
      arg3 = vcreate_u16(UINT64_C(0x00007fff7fff0000));
      clear_neon_saturated();
      //  Expect: "result" = 0000742f1cd8ffff
      result = vmls_u16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0x0000742f1cd8ffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_204() {

{
   {
      uint32x2_t arg1;
      uint32x2_t arg2;
      uint32x2_t arg3;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmls_u32\", rettype = \"uint32x2_t\", argtypes = \"[uint32x2_t,uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 2147483647,IntegerVal 2147450880],VectorVal [IntegerVal 2147483648,IntegerVal 2147449605],VectorVal [IntegerVal 2147450880,IntegerVal 4294934528]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u32(UINT64_C(0x7fff80007fffffff));
      arg2 = vcreate_u32(UINT64_C(0x7fff7b0580000000));
      arg3 = vcreate_u32(UINT64_C(0xffff80007fff8000));
      clear_neon_saturated();
      //  Expect: "result" = 3d8200007fffffff
      result = vmls_u32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0x3d8200007fffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_205() {

{
   {
      int8x16_t arg1;
      int8x16_t arg2;
      int8x16_t arg3;
      int8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsq_s8\", rettype = \"int8x16_t\", argtypes = \"[int8x16_t,int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal 127,IntegerVal 89,IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal (-128),IntegerVal (-128),IntegerVal (-128),IntegerVal 0,IntegerVal 127,IntegerVal (-12),IntegerVal (-1),IntegerVal (-128),IntegerVal 127,IntegerVal (-1),IntegerVal (-128)],VectorVal [IntegerVal 0,IntegerVal (-128),IntegerVal 0,IntegerVal (-83),IntegerVal (-9),IntegerVal 0,IntegerVal (-1),IntegerVal 127,IntegerVal (-128),IntegerVal (-128),IntegerVal (-1),IntegerVal 0,IntegerVal 0,IntegerVal (-128),IntegerVal 55,IntegerVal 127],VectorVal [IntegerVal 121,IntegerVal (-4),IntegerVal (-128),IntegerVal (-1),IntegerVal 127,IntegerVal 0,IntegerVal (-110),IntegerVal 0,IntegerVal 127,IntegerVal (-98),IntegerVal (-1),IntegerVal 127,IntegerVal (-1),IntegerVal (-128),IntegerVal (-1),IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s8(vcreate_s8(UINT64_C(0x808080007f00597f)),
                         vcreate_s8(UINT64_C(0x80ff7f80fff47f00)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0x7fff00f7ad008000)),
                         vcreate_s8(UINT64_C(0x7f37800000ff8080)));
      arg3 = vcombine_s8(vcreate_s8(UINT64_C(0x0092007fff80fc79)),
                         vcreate_s8(UINT64_C(0x00ff80ff7fff9e7f)));
      clear_neon_saturated();
      //  Expect: "result" = 80367f80fff37f80801280772c00597f
      result = vmlsq_s8(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 0);
         exp = UINT64_C(0x801280772c00597f);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 1);
         exp = UINT64_C(0x80367f80fff37f80);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_206() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int16x8_t arg3;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsq_s16\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 32767,IntegerVal (-1),IntegerVal 0,IntegerVal 0,IntegerVal (-10476),IntegerVal (-32768),IntegerVal 0],VectorVal [IntegerVal (-1),IntegerVal 32767,IntegerVal 0,IntegerVal (-1),IntegerVal 32767,IntegerVal 0,IntegerVal (-32768),IntegerVal (-1)],VectorVal [IntegerVal (-1),IntegerVal 0,IntegerVal (-1),IntegerVal (-32768),IntegerVal 32767,IntegerVal (-32768),IntegerVal 0,IntegerVal 28649]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x0000ffff7fff7fff)),
                          vcreate_s16(UINT64_C(0x00008000d7140000)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0xffff00007fffffff)),
                          vcreate_s16(UINT64_C(0xffff800000007fff)));
      arg3 = vcombine_s16(vcreate_s16(UINT64_C(0x8000ffff0000ffff)),
                          vcreate_s16(UINT64_C(0x6fe9000080007fff)));
      clear_neon_saturated();
      //  Expect: "result" = 6fe98000d714ffff8000ffff7fff7ffe
      result = vmlsq_s16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x8000ffff7fff7ffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x6fe98000d714ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_207() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int32x4_t arg3;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsq_s32\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 32768,IntegerVal 2147418112,IntegerVal (-2147483648)],VectorVal [IntegerVal 1123385344,IntegerVal (-2147450881),IntegerVal 50955,IntegerVal 2147483647],VectorVal [IntegerVal 2147450880,IntegerVal 65535,IntegerVal 2147428142,IntegerVal (-2147450880)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x0000800000000000)),
                          vcreate_s32(UINT64_C(0x800000007fff0000)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x80007fff42f58000)),
                          vcreate_s32(UINT64_C(0x7fffffff0000c70b)));
      arg3 = vcombine_s32(vcreate_s32(UINT64_C(0x0000ffff7fff8000)),
                          vcreate_s32(UINT64_C(0x800080007fff272e)));
      clear_neon_saturated();
      //  Expect: "result" = 00008000a8938f060001ffffc0000000
      result = vmlsq_s32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x0001ffffc0000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x00008000a8938f06);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_208() {

{
   {
      uint8x16_t arg1;
      uint8x16_t arg2;
      uint8x16_t arg3;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsq_u8\", rettype = \"uint8x16_t\", argtypes = \"[uint8x16_t,uint8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 128,IntegerVal 0,IntegerVal 255,IntegerVal 128,IntegerVal 255,IntegerVal 255,IntegerVal 128,IntegerVal 127,IntegerVal 86,IntegerVal 90,IntegerVal 128,IntegerVal 255,IntegerVal 255,IntegerVal 28,IntegerVal 255],VectorVal [IntegerVal 0,IntegerVal 127,IntegerVal 203,IntegerVal 255,IntegerVal 195,IntegerVal 255,IntegerVal 0,IntegerVal 0,IntegerVal 127,IntegerVal 87,IntegerVal 128,IntegerVal 128,IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal 173],VectorVal [IntegerVal 255,IntegerVal 192,IntegerVal 232,IntegerVal 255,IntegerVal 128,IntegerVal 27,IntegerVal 5,IntegerVal 128,IntegerVal 127,IntegerVal 127,IntegerVal 128,IntegerVal 127,IntegerVal 0,IntegerVal 0,IntegerVal 0,IntegerVal 128]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u8(vcreate_u8(UINT64_C(0x80ffff80ff008000)),
                         vcreate_u8(UINT64_C(0xff1cffff805a567f)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0x0000ffc3ffcb7f00)),
                         vcreate_u8(UINT64_C(0xad007f008080577f)));
      arg3 = vcombine_u8(vcreate_u8(UINT64_C(0x80051b80ffe8c0ff)),
                         vcreate_u8(UINT64_C(0x800000007f807f7f)));
      clear_neon_saturated();
      //  Expect: "result" = 7f1cffff005a2d7e80ff1a00fe084000
      result = vmlsq_u8(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x80ff1a00fe084000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0x7f1cffff005a2d7e);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_209() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint16x8_t arg3;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsq_u16\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 36530,IntegerVal 46534,IntegerVal 32768,IntegerVal 52360,IntegerVal 0,IntegerVal 54611,IntegerVal 32767],VectorVal [IntegerVal 32767,IntegerVal 54356,IntegerVal 15942,IntegerVal 46997,IntegerVal 32768,IntegerVal 19840,IntegerVal 32767,IntegerVal 642],VectorVal [IntegerVal 32768,IntegerVal 0,IntegerVal 65535,IntegerVal 65535,IntegerVal 32768,IntegerVal 32767,IntegerVal 32767,IntegerVal 65535]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x8000b5c68eb27fff)),
                          vcreate_u16(UINT64_C(0x7fffd5530000cc88)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0xb7953e46d4547fff)),
                          vcreate_u16(UINT64_C(0x02827fff4d808000)));
      arg3 = vcombine_u16(vcreate_u16(UINT64_C(0xffffffff00008000)),
                          vcreate_u16(UINT64_C(0xffff7fff7fff8000)));
      clear_neon_saturated();
      //  Expect: "result" = 8281d5524d80cc883795f40c8eb2ffff
      result = vmlsq_u16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x3795f40c8eb2ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x8281d5524d80cc88);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_210() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint32x4_t arg3;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsq_u32\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 2147433242,IntegerVal 2147441038,IntegerVal 1437564928,IntegerVal 2147483647],VectorVal [IntegerVal 776667136,IntegerVal 0,IntegerVal 3945201663,IntegerVal 2147483648],VectorVal [IntegerVal 2147483648,IntegerVal 598343680,IntegerVal 4294934527,IntegerVal 2147524035]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x7fff598e7fff3b1a)),
                          vcreate_u32(UINT64_C(0x7fffffff55af8000)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x000000002e4b0000)),
                          vcreate_u32(UINT64_C(0x80000000eb26ffff)));
      arg3 = vcombine_u32(vcreate_u32(UINT64_C(0x23aa000080000000)),
                          vcreate_u32(UINT64_C(0x80009dc3ffff7fff)));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffc0d5ffff7fff598e7fff3b1a
      result = vmlsq_u32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x7fff598e7fff3b1a);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0xffffffffc0d5ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_211() {

{
   {
      float32x2_t arg1;
      float32x2_t arg2;
      float32x2_t arg3;
      float32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vfms_f32\", rettype = \"float32x2_t\", argtypes = \"[float32x2_t,float32x2_t,float32x2_t]\", vals = [VectorVal [FloatVal 0.33316779136657715,FloatVal 0.795536994934082],VectorVal [FloatVal 3.146618604660034e-2,FloatVal 2.6081502437591553e-2],VectorVal [FloatVal 0.7430906295776367,FloatVal 0.7188999056816101]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_f32(UINT64_C(0x3f4ba8503eaa94f8));
      arg2 = vcreate_f32(UINT64_C(0x3cd5a8e03d00e2b0));
      arg3 = vcreate_f32(UINT64_C(0x3f3809d33f3e3b30));
      clear_neon_saturated();
      //  Expect: "result" = 3f46db833e9e9c37
      result = vfms_f32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float32_t got;
         float32_t exp;
         got = vget_lane_f32(result, 0);
         exp = ((float32_t) 0.3097855746746063);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vget_lane_f32(result, 1);
         exp = ((float32_t) 0.7767869830131531);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
   }
}
}
void dotests_212() {

{
   {
      float32x4_t arg1;
      float32x4_t arg2;
      float32x4_t arg3;
      float32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vfmsq_f32\", rettype = \"float32x4_t\", argtypes = \"[float32x4_t,float32x4_t,float32x4_t]\", vals = [VectorVal [FloatVal 0.7210066318511963,FloatVal 0.2663896083831787,FloatVal 0.7976276278495789,FloatVal 0.6981443762779236],VectorVal [FloatVal 0.8121473789215088,FloatVal 0.834670901298523,FloatVal 0.5449929237365723,FloatVal 0.5822281241416931],VectorVal [FloatVal 0.6892375946044922,FloatVal 0.39572393894195557,FloatVal 1.2957453727722168e-3,FloatVal 0.6025665998458862]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f32(vcreate_f32(UINT64_C(0x3e8864383f3893e4)),
                          vcreate_f32(UINT64_C(0x3f32b9973f4c3153)));
      arg2 = vcombine_f32(vcreate_f32(UINT64_C(0x3f55acfe3f4fe8e4)),
                          vcreate_f32(UINT64_C(0x3f150ce73f0b84a8)));
      arg3 = vcombine_f32(vcreate_f32(UINT64_C(0x3eca9c543f3071e0)),
                          vcreate_f32(UINT64_C(0x3f1a41ce3aa9d600)));
      clear_neon_saturated();
      //  Expect: "result" = 3eb1d3083f4c030bbd82e3103e251d2e
      result = vfmsq_f32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 0);
         exp = ((float32_t) 0.16124412417411804);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 1);
         exp = ((float32_t) -6.390964984893799e-2);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 2);
         exp = ((float32_t) 0.79692143201828);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 2 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 3);
         exp = ((float32_t) 0.34731316566467285);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 3 ", exp, got);
            }
      }
   }
}
}
void dotests_213() {

{
   {
      float64x2_t arg1;
      float64x2_t arg2;
      float64x2_t arg3;
      float64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vfmsq_f64\", rettype = \"float64x2_t\", argtypes = \"[float64x2_t,float64x2_t,float64x2_t]\", vals = [VectorVal [FloatVal 0.7341674092947582,FloatVal 0.3120734761337982],VectorVal [FloatVal 0.7648043957063155,FloatVal 0.27073800303263795],VectorVal [FloatVal 0.4671120548625505,FloatVal 0.3273242128594823]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f64(vcreate_f64(UINT64_C(0x3fe77e4ca696b897)),
                          vcreate_f64(UINT64_C(0x3fd3f903077c6594)));
      arg2 = vcombine_f64(vcreate_f64(UINT64_C(0x3fe87947116ca950)),
                          vcreate_f64(UINT64_C(0x3fd153c57d33cf52)));
      arg3 = vcombine_f64(vcreate_f64(UINT64_C(0x3fdde529f5ccedc4)),
                          vcreate_f64(UINT64_C(0x3fd4f2e1415ae826)));
      clear_neon_saturated();
      //  Expect: "result" = 3fcc9a2722cd96fb3fd81f6ce96df4b4
      result = vfmsq_f64(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float64_t got;
         float64_t exp;
         got = vgetq_lane_f64(result, 0);
         exp = 0.37691805644847;
         if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float64_t got;
         float64_t exp;
         got = vgetq_lane_f64(result, 1);
         exp = 0.22345437239999186;
         if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
   }
}
}
void dotests_214() {

{
   {
      float64x1_t arg1;
      float64x1_t arg2;
      float64x1_t arg3;
      float64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vfms_f64\", rettype = \"float64x1_t\", argtypes = \"[float64x1_t,float64x1_t,float64x1_t]\", vals = [VectorVal [FloatVal 2.329701079495594e-2],VectorVal [FloatVal 0.7389985214494788],VectorVal [FloatVal 0.35260261051980024]], start_saturated = False}";
      int reported = 0;
      float64_t got;
      float64_t exp;
      arg1 = vcreate_f64(UINT64_C(0x3f97db2bedd5e880));
      arg2 = vcreate_f64(UINT64_C(0x3fe7a5e03a2d5f28));
      arg3 = vcreate_f64(UINT64_C(0x3fd6910a8a2aac52));
      clear_neon_saturated();
      //  Expect: "result" = bfce5f0da634c564
      result = vfms_f64(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_f64(result, 0);
      exp = -0.23727579703840285;
      if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
         }
   }
}
}
void dotests_215() {

{
   {
      float32x2_t arg1;
      float32x2_t arg2;
      float32x2_t arg3;
      float32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmls_f32\", rettype = \"float32x2_t\", argtypes = \"[float32x2_t,float32x2_t,float32x2_t]\", vals = [VectorVal [FloatVal 0.11067205667495728,FloatVal 0.2678745985031128],VectorVal [FloatVal 0.6423867344856262,FloatVal 0.7507759928703308],VectorVal [FloatVal 0.26666808128356934,FloatVal 0.2080388069152832]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_f32(UINT64_C(0x3e8926dc3de2a808));
      arg2 = vcreate_f32(UINT64_C(0x3f4032db3f247375));
      arg3 = vcreate_f32(UINT64_C(0x3e5508203e8888b8));
      clear_neon_saturated();
      //  Expect: "result" = 3de4ba9cbd78593e
      result = vmls_f32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float32_t got;
         float32_t exp;
         got = vget_lane_f32(result, 0);
         exp = ((float32_t) -6.063198298215866e-2);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vget_lane_f32(result, 1);
         exp = ((float32_t) 0.11168405413627625);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
   }
}
}
void dotests_216() {

{
   {
      float32x4_t arg1;
      float32x4_t arg2;
      float32x4_t arg3;
      float32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsq_f32\", rettype = \"float32x4_t\", argtypes = \"[float32x4_t,float32x4_t,float32x4_t]\", vals = [VectorVal [FloatVal 0.8864086866378784,FloatVal 0.36815696954727173,FloatVal 0.4579457640647888,FloatVal 0.6729732155799866],VectorVal [FloatVal 0.33614522218704224,FloatVal 0.7089780569076538,FloatVal 1.621156930923462e-2,FloatVal 0.7321020364761353],VectorVal [FloatVal 0.6063637137413025,FloatVal 9.446007013320923e-2,FloatVal 0.7341058254241943,FloatVal 0.6447949409484863]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f32(vcreate_f32(UINT64_C(0x3ebc7f123f62ebae)),
                          vcreate_f32(UINT64_C(0x3f2c47f93eea77de)));
      arg2 = vcombine_f32(vcreate_f32(UINT64_C(0x3f357f963eac1b3a)),
                          vcreate_f32(UINT64_C(0x3f3b6b0a3c84ce20)));
      arg3 = vcombine_f32(vcreate_f32(UINT64_C(0x3dc174483f1b3aa7)),
                          vcreate_f32(UINT64_C(0x3f2511483f3bee5c)));
      clear_neon_saturated();
      //  Expect: "result" = 3e4dbd533ee45ffa3e9a352a3f2ebdb9
      result = vmlsq_f32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 0);
         exp = ((float32_t) 0.682582437992096);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 1);
         exp = ((float32_t) 0.30118685960769653);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 2);
         exp = ((float32_t) 0.4460447430610657);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 2 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 3);
         exp = ((float32_t) 0.20091752707958221);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 3 ", exp, got);
            }
      }
   }
}
}
void dotests_217() {

{
   {
      float64x2_t arg1;
      float64x2_t arg2;
      float64x2_t arg3;
      float64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsq_f64\", rettype = \"float64x2_t\", argtypes = \"[float64x2_t,float64x2_t,float64x2_t]\", vals = [VectorVal [FloatVal 0.7169973526218792,FloatVal 0.24968247703092805],VectorVal [FloatVal 0.8092840452447038,FloatVal 0.9377388873415169],VectorVal [FloatVal 0.803108926686415,FloatVal 0.36502161541764944]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f64(vcreate_f64(UINT64_C(0x3fe6f1a46e9a8baf)),
                          vcreate_f64(UINT64_C(0x3fcff5986c9db5b0)));
      arg2 = vcombine_f64(vcreate_f64(UINT64_C(0x3fe9e5a7a77004cf)),
                          vcreate_f64(UINT64_C(0x3fee01f4fbaa373e)));
      arg3 = vcombine_f64(vcreate_f64(UINT64_C(0x3fe9b3117de7cd53)),
                          vcreate_f64(UINT64_C(0x3fd75c839f23523a)));
      clear_neon_saturated();
      //  Expect: "result" = bfb7b573b09313f83fb12a7550a56be0
      result = vmlsq_f64(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float64_t got;
         float64_t exp;
         got = vgetq_lane_f64(result, 0);
         exp = 6.705411166096509e-2;
         if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float64_t got;
         float64_t exp;
         got = vgetq_lane_f64(result, 1);
         exp = -9.261248646642162e-2;
         if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
   }
}
}
void dotests_218() {

{
   {
      float64x1_t arg1;
      float64x1_t arg2;
      float64x1_t arg3;
      float64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmls_f64\", rettype = \"float64x1_t\", argtypes = \"[float64x1_t,float64x1_t,float64x1_t]\", vals = [VectorVal [FloatVal 0.8612911220451575],VectorVal [FloatVal 3.6827639370720644e-2],VectorVal [FloatVal 1.699983357345336e-2]], start_saturated = False}";
      int reported = 0;
      float64_t got;
      float64_t exp;
      arg1 = vcreate_f64(UINT64_C(0x3feb8fb266309c6f));
      arg2 = vcreate_f64(UINT64_C(0x3fa2db12855f4c10));
      arg3 = vcreate_f64(UINT64_C(0x3f91686784f11340));
      clear_neon_saturated();
      //  Expect: "result" = 3feb8a9172c759b8
      result = vmls_f64(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_f64(result, 0);
      exp = 0.860665058304952;
      if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
         }
   }
}
}
void dotests_219() {

{
   {
      int16x8_t arg1;
      int8x8_t arg2;
      int8x8_t arg3;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsl_s8\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 0,IntegerVal (-1),IntegerVal 0,IntegerVal (-32768),IntegerVal (-32768),IntegerVal 0,IntegerVal (-14669)],VectorVal [IntegerVal 127,IntegerVal (-1),IntegerVal 127,IntegerVal (-1),IntegerVal (-128),IntegerVal 0,IntegerVal (-1),IntegerVal 127],VectorVal [IntegerVal (-128),IntegerVal (-1),IntegerVal (-1),IntegerVal (-122),IntegerVal (-128),IntegerVal 0,IntegerVal (-1),IntegerVal (-128)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x0000ffff00007fff)),
                          vcreate_s16(UINT64_C(0xc6b3000080008000)));
      arg2 = vcreate_s8(UINT64_C(0x7fff0080ff7fff7f));
      arg3 = vcreate_s8(UINT64_C(0x80ff008086ffff80));
      clear_neon_saturated();
      //  Expect: "result" = 0633ffff80004000ff86007effffbf7f
      result = vmlsl_s8(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0xff86007effffbf7f);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x0633ffff80004000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_220() {

{
   {
      int32x4_t arg1;
      int16x4_t arg2;
      int16x4_t arg3;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsl_s16\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal 65535,IntegerVal 2147450879,IntegerVal (-1877082113),IntegerVal 732758015],VectorVal [IntegerVal 32767,IntegerVal (-1),IntegerVal 0,IntegerVal (-32768)],VectorVal [IntegerVal (-1),IntegerVal 32767,IntegerVal (-32768),IntegerVal (-30669)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x7fff7fff0000ffff)),
                          vcreate_s32(UINT64_C(0x2bacffff901dffff)));
      arg2 = vcreate_s16(UINT64_C(0x80000000ffff7fff));
      arg3 = vcreate_s16(UINT64_C(0x883380007fffffff));
      clear_neon_saturated();
      //  Expect: "result" = efc67fff901dffff7ffffffe00017ffe
      result = vmlsl_s16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x7ffffffe00017ffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0xefc67fff901dffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_221() {

{
   {
      int64x2_t arg1;
      int32x2_t arg2;
      int32x2_t arg3;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsl_s32\", rettype = \"int64x2_t\", argtypes = \"[int64x2_t,int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal (-9223090564025557946),IntegerVal (-9223372034639331328)],VectorVal [IntegerVal 65535,IntegerVal 2147450879],VectorVal [IntegerVal 2147450880,IntegerVal (-2147418113)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x8000ffff7fffdc46)),
                          vcreate_s64(UINT64_C(0x80000000840d0000)));
      arg2 = vcreate_s32(UINT64_C(0x7fff7fff0000ffff));
      arg3 = vcreate_s32(UINT64_C(0x8000ffff7fff8000));
      clear_neon_saturated();
      //  Expect: "result" = bfff4001040d7fff800080007fff5c46
      result = vmlsl_s32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x800080007fff5c46);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0xbfff4001040d7fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_222() {

{
   {
      uint16x8_t arg1;
      uint8x8_t arg2;
      uint8x8_t arg3;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsl_u8\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 32768,IntegerVal 0,IntegerVal 32768,IntegerVal 0,IntegerVal 55880,IntegerVal 30542,IntegerVal 32768,IntegerVal 32768],VectorVal [IntegerVal 145,IntegerVal 0,IntegerVal 127,IntegerVal 255,IntegerVal 255,IntegerVal 127,IntegerVal 128,IntegerVal 242],VectorVal [IntegerVal 128,IntegerVal 212,IntegerVal 128,IntegerVal 255,IntegerVal 255,IntegerVal 141,IntegerVal 127,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x0000800000008000)),
                          vcreate_u16(UINT64_C(0x80008000774eda48)));
      arg2 = vcreate_u8(UINT64_C(0xf2807fffff7f0091));
      arg3 = vcreate_u8(UINT64_C(0x007f8dffff80d480));
      clear_neon_saturated();
      //  Expect: "result" = 80004080315bdc4701ff408000003780
      result = vmlsl_u8(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x01ff408000003780);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x80004080315bdc47);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_223() {

{
   {
      uint32x4_t arg1;
      uint16x4_t arg2;
      uint16x4_t arg3;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsl_u16\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 2147520270,IntegerVal 2147450880,IntegerVal 2147450879,IntegerVal 2986],VectorVal [IntegerVal 0,IntegerVal 0,IntegerVal 61793,IntegerVal 32767],VectorVal [IntegerVal 65535,IntegerVal 32768,IntegerVal 32767,IntegerVal 55479]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x7fff800080008f0e)),
                          vcreate_u32(UINT64_C(0x00000baa7fff7fff)));
      arg2 = vcreate_u16(UINT64_C(0x7ffff16100000000));
      arg3 = vcreate_u16(UINT64_C(0xd8b77fff8000ffff));
      clear_neon_saturated();
      //  Expect: "result" = 93a56461074ff1607fff800080008f0e
      result = vmlsl_u16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x7fff800080008f0e);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0x93a56461074ff160);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_224() {

{
   {
      uint64x2_t arg1;
      uint32x2_t arg2;
      uint32x2_t arg3;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsl_u32\", rettype = \"uint64x2_t\", argtypes = \"[uint64x2_t,uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 11069847884076711936,IntegerVal 9223512770251327165],VectorVal [IntegerVal 873299967,IntegerVal 2147516416],VectorVal [IntegerVal 4294966220,IntegerVal 357564415]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0x99a0000000008000)),
                          vcreate_u64(UINT64_C(0x80007fff0c1c06bd)));
      arg2 = vcreate_u32(UINT64_C(0x80008000340d7fff));
      arg3 = vcreate_u32(UINT64_C(0x154ffffffffffbcc));
      clear_neon_saturated();
      //  Expect: "result" = 755875578c1c86bd659280dbc8be7bcc
      result = vmlsl_u32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0x659280dbc8be7bcc);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0x755875578c1c86bd);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_225() {

{
   {
      int16x8_t arg1;
      int8x16_t arg2;
      int8x16_t arg3;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsl_high_s8\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal 10413,IntegerVal (-1),IntegerVal (-21760),IntegerVal 0,IntegerVal 0,IntegerVal (-7589),IntegerVal 32767,IntegerVal 0],VectorVal [IntegerVal (-30),IntegerVal 127,IntegerVal (-86),IntegerVal 0,IntegerVal (-1),IntegerVal 0,IntegerVal (-1),IntegerVal (-128),IntegerVal 127,IntegerVal (-1),IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal 0,IntegerVal (-1),IntegerVal 49],VectorVal [IntegerVal 127,IntegerVal 127,IntegerVal 127,IntegerVal (-1),IntegerVal (-128),IntegerVal (-1),IntegerVal 127,IntegerVal (-1),IntegerVal 0,IntegerVal (-128),IntegerVal (-128),IntegerVal (-82),IntegerVal 0,IntegerVal (-1),IntegerVal 33,IntegerVal 127]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x0000ab00ffff28ad)),
                          vcreate_s16(UINT64_C(0x00007fffe25b0000)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0x80ff00ff00aa7fe2)),
                         vcreate_s8(UINT64_C(0x31ff00007f00ff7f)));
      arg3 = vcombine_s8(vcreate_s8(UINT64_C(0xff7fff80ff7f7f7f)),
                         vcreate_s8(UINT64_C(0x7f21ff00ae808000)));
      clear_neon_saturated();
      //  Expect: "result" = e7b18020e25b000028aeab00ff7f28ad
      result = vmlsl_high_s8(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x28aeab00ff7f28ad);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0xe7b18020e25b0000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_226() {

{
   {
      int32x4_t arg1;
      int16x8_t arg2;
      int16x8_t arg3;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsl_high_s16\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal (-2104098817),IntegerVal 1339588608,IntegerVal 727711743,IntegerVal (-1)],VectorVal [IntegerVal (-32768),IntegerVal (-32768),IntegerVal 1549,IntegerVal 0,IntegerVal (-1),IntegerVal (-1),IntegerVal (-1),IntegerVal (-9723)],VectorVal [IntegerVal (-32768),IntegerVal 0,IntegerVal (-1),IntegerVal (-1),IntegerVal (-1),IntegerVal (-32768),IntegerVal (-32768),IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x4fd880008295ffff)),
                          vcreate_s32(UINT64_C(0xffffffff2b5fffff)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x0000060d80008000)),
                          vcreate_s16(UINT64_C(0xda05ffffffffffff)));
      arg3 = vcombine_s16(vcreate_s16(UINT64_C(0xffffffff00008000)),
                          vcreate_s16(UINT64_C(0xffff80008000ffff)));
      clear_neon_saturated();
      //  Expect: "result" = ffffda042b5f7fff4fd800008295fffe
      result = vmlsl_high_s16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x4fd800008295fffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0xffffda042b5f7fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_227() {

{
   {
      int64x2_t arg1;
      int32x4_t arg2;
      int32x4_t arg3;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsl_high_s32\", rettype = \"int64x2_t\", argtypes = \"[int64x2_t,int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal 65535,IntegerVal (-9223231303661355009)],VectorVal [IntegerVal 50004,IntegerVal (-303895113),IntegerVal (-2147483648),IntegerVal (-1973485568)],VectorVal [IntegerVal 2147474075,IntegerVal 22295,IntegerVal 65535,IntegerVal (-65536)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x000000000000ffff)),
                          vcreate_s64(UINT64_C(0x80007fff00007fff)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0xede2edb70000c354)),
                          vcreate_s32(UINT64_C(0x8a5f000080000000)));
      arg3 = vcombine_s32(vcreate_s32(UINT64_C(0x000057177fffda9b)),
                          vcreate_s32(UINT64_C(0xffff00000000ffff)));
      clear_neon_saturated();
      //  Expect: "result" = 80000a5e00007fff00007fff8000ffff
      result = vmlsl_high_s32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x00007fff8000ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0x80000a5e00007fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_228() {

{
   {
      uint16x8_t arg1;
      uint8x16_t arg2;
      uint8x16_t arg3;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsl_high_u8\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 65535,IntegerVal 32768,IntegerVal 32768,IntegerVal 65535,IntegerVal 44419,IntegerVal 32768,IntegerVal 65535,IntegerVal 0],VectorVal [IntegerVal 0,IntegerVal 255,IntegerVal 140,IntegerVal 0,IntegerVal 128,IntegerVal 0,IntegerVal 69,IntegerVal 128,IntegerVal 255,IntegerVal 88,IntegerVal 163,IntegerVal 112,IntegerVal 128,IntegerVal 127,IntegerVal 127,IntegerVal 255],VectorVal [IntegerVal 255,IntegerVal 127,IntegerVal 255,IntegerVal 0,IntegerVal 128,IntegerVal 128,IntegerVal 255,IntegerVal 127,IntegerVal 223,IntegerVal 128,IntegerVal 0,IntegerVal 0,IntegerVal 116,IntegerVal 127,IntegerVal 10,IntegerVal 253]], start_saturated = True}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0xffff80008000ffff)),
                          vcreate_u16(UINT64_C(0x0000ffff8000ad83)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0x80450080008cff00)),
                         vcreate_u8(UINT64_C(0xff7f7f8070a358ff)));
      arg3 = vcombine_u8(vcreate_u8(UINT64_C(0x7fff808000ff7fff)),
                         vcreate_u8(UINT64_C(0xfd0a7f74000080df)));
      set_neon_saturated();
      //  Expect: "result" = 03fdfb0940ff7383ffff8000540021de
      result = vmlsl_high_u8(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0xffff8000540021de);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x03fdfb0940ff7383);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_229() {

{
   {
      uint32x4_t arg1;
      uint16x8_t arg2;
      uint16x8_t arg3;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsl_high_u16\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 2147549183,IntegerVal 359202816,IntegerVal 2147498161,IntegerVal 2147483647],VectorVal [IntegerVal 32768,IntegerVal 65535,IntegerVal 32768,IntegerVal 65535,IntegerVal 32767,IntegerVal 32767,IntegerVal 32767,IntegerVal 0],VectorVal [IntegerVal 0,IntegerVal 32768,IntegerVal 65535,IntegerVal 12430,IntegerVal 65535,IntegerVal 65535,IntegerVal 32767,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x156900008000ffff)),
                          vcreate_u32(UINT64_C(0x7fffffff800038b1)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0xffff8000ffff8000)),
                          vcreate_u16(UINT64_C(0x00007fff7fff7fff)));
      arg3 = vcombine_u16(vcreate_u16(UINT64_C(0x308effff80000000)),
                          vcreate_u16(UINT64_C(0x7fff7fffffffffff)));
      clear_neon_saturated();
      //  Expect: "result" = 7fffffff400138b0956a7fff00027ffe
      result = vmlsl_high_u16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x956a7fff00027ffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0x7fffffff400138b0);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_230() {

{
   {
      uint64x2_t arg1;
      uint32x4_t arg2;
      uint32x4_t arg3;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mls\", fnname = \"vmlsl_high_u32\", rettype = \"uint64x2_t\", argtypes = \"[uint64x2_t,uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 9223372041149743103,IntegerVal 18446603338368692602],VectorVal [IntegerVal 4294958711,IntegerVal 2147450879,IntegerVal 2147454329,IntegerVal 2147467487],VectorVal [IntegerVal 2147532222,IntegerVal 2147516416,IntegerVal 2147418112,IntegerVal 2147418112]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0x80000000ffffffff)),
                          vcreate_u64(UINT64_C(0xffff80008000317a)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x7fff7fffffffde77)),
                          vcreate_u32(UINT64_C(0x7fffc0df7fff8d79)));
      arg3 = vcombine_u32(vcreate_u32(UINT64_C(0x800080008000bdbe)),
                          vcreate_u32(UINT64_C(0x7fff00007fff0000)));
      clear_neon_saturated();
      //  Expect: "result" = c0001f90c0df317a4000b9440d78ffff
      result = vmlsl_high_u32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0x4000b9440d78ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0xc0001f90c0df317a);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_231() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      int16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmlh\", fnname = \"vqdmulh_s16\", rettype = \"int16x4_t\", argtypes = \"[int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal 0,IntegerVal (-26286),IntegerVal 2005],VectorVal [IntegerVal 0,IntegerVal 32767,IntegerVal 0,IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s16(UINT64_C(0x07d599520000ffff));
      arg2 = vcreate_s16(UINT64_C(0xffff00007fff0000));
      clear_neon_saturated();
      //  Expect: "result" = ffff000000000000
      result = vqdmulh_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s16(result), 0);
      exp = UINT64_C(0xffff000000000000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_232() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      int32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmlh\", fnname = \"vqdmulh_s32\", rettype = \"int32x2_t\", argtypes = \"[int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal (-529268736),IntegerVal (-32769)],VectorVal [IntegerVal 2147483647,IntegerVal (-32768)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s32(UINT64_C(0xffff7fffe0740000));
      arg2 = vcreate_s32(UINT64_C(0xffff80007fffffff));
      clear_neon_saturated();
      //  Expect: "result" = 00000000e0740000
      result = vqdmulh_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s32(result), 0);
      exp = UINT64_C(0x00000000e0740000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_233() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmlh\", fnname = \"vqdmulhq_s16\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal 23555,IntegerVal 32767,IntegerVal (-32768),IntegerVal 32767,IntegerVal 0,IntegerVal 0,IntegerVal 32767,IntegerVal (-19653)],VectorVal [IntegerVal (-22270),IntegerVal 0,IntegerVal 0,IntegerVal 4603,IntegerVal (-1),IntegerVal (-28560),IntegerVal 0,IntegerVal 21337]], start_saturated = True}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x7fff80007fff5c03)),
                          vcreate_s16(UINT64_C(0xb33b7fff00000000)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x11fb00000000a902)),
                          vcreate_s16(UINT64_C(0x535900009070ffff)));
      set_neon_saturated();
      //  Expect: "result" = ce0200000000000011fa00000000c177
      result = vqdmulhq_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x11fa00000000c177);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0xce02000000000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_234() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmlh\", fnname = \"vqdmulhq_s32\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal 3351,IntegerVal 32768,IntegerVal (-32769),IntegerVal 32768],VectorVal [IntegerVal (-2147450881),IntegerVal (-1489400985),IntegerVal 32767,IntegerVal 2147480987]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x0000800000000d17)),
                          vcreate_s32(UINT64_C(0x00008000ffff7fff)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0xa7398b6780007fff)),
                          vcreate_s32(UINT64_C(0x7ffff59b00007fff)));
      clear_neon_saturated();
      //  Expect: "result" = 00007fffffffffffffffa739fffff2e9
      result = vqdmulhq_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0xffffa739fffff2e9);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x00007fffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_235() {

{
   {
      int16_t arg1;
      int16_t arg2;
      int16_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmlh\", fnname = \"vqdmulhh_s16\", rettype = \"int16_t\", argtypes = \"[int16_t,int16_t]\", vals = [IntegerVal 0,IntegerVal 18756], start_saturated = False}";
      int reported = 0;
      int16_t got;
      int16_t exp;
      arg1 = 0;
      arg2 = 18756;
      clear_neon_saturated();
      //  Expect: "result" = 0000
      result = vqdmulhh_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi16 " Got: %" PRIi16 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_236() {

{
   {
      int32_t arg1;
      int32_t arg2;
      int32_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmlh\", fnname = \"vqdmulhs_s32\", rettype = \"int32_t\", argtypes = \"[int32_t,int32_t]\", vals = [IntegerVal (-32769),IntegerVal (-1)], start_saturated = False}";
      int reported = 0;
      int32_t got;
      int32_t exp;
      arg1 = -32769;
      arg2 = -1;
      clear_neon_saturated();
      //  Expect: "result" = 00000000
      result = vqdmulhs_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi32 " Got: %" PRIi32 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_237() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      int16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"qrdmlh\", fnname = \"vqrdmulh_s16\", rettype = \"int16x4_t\", argtypes = \"[int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal (-32768),IntegerVal (-32181),IntegerVal 32767,IntegerVal 32767],VectorVal [IntegerVal (-1),IntegerVal 0,IntegerVal 32767,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s16(UINT64_C(0x7fff7fff824b8000));
      arg2 = vcreate_s16(UINT64_C(0x00007fff0000ffff));
      clear_neon_saturated();
      //  Expect: "result" = 00007ffe00000001
      result = vqrdmulh_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s16(result), 0);
      exp = UINT64_C(0x00007ffe00000001);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_238() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      int32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"qrdmlh\", fnname = \"vqrdmulh_s32\", rettype = \"int32x2_t\", argtypes = \"[int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal 2147418112,IntegerVal 2147448068],VectorVal [IntegerVal (-2147450880),IntegerVal 2147450880]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s32(UINT64_C(0x7fff75047fff0000));
      arg2 = vcreate_s32(UINT64_C(0x7fff800080008000));
      clear_neon_saturated();
      //  Expect: "result" = 7ffef50580017fff
      result = vqrdmulh_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s32(result), 0);
      exp = UINT64_C(0x7ffef50580017fff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_239() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"qrdmlh\", fnname = \"vqrdmulhq_s16\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal (-32768),IntegerVal (-1),IntegerVal (-32768),IntegerVal 0,IntegerVal 4585,IntegerVal 21514,IntegerVal (-1),IntegerVal (-32768)],VectorVal [IntegerVal (-1),IntegerVal 32767,IntegerVal 31768,IntegerVal 0,IntegerVal 0,IntegerVal (-1),IntegerVal (-30435),IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x00008000ffff8000)),
                          vcreate_s16(UINT64_C(0x8000ffff540a11e9)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x00007c187fffffff)),
                          vcreate_s16(UINT64_C(0x7fff891dffff0000)));
      clear_neon_saturated();
      //  Expect: "result" = 80010001ffff0000000083e8ffff0001
      result = vqrdmulhq_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x000083e8ffff0001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x80010001ffff0000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_240() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"qrdmlh\", fnname = \"vqrdmulhq_s32\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal 65535,IntegerVal (-32768),IntegerVal (-32769),IntegerVal (-32769)],VectorVal [IntegerVal (-35686),IntegerVal 2147450879,IntegerVal 1413873664,IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0xffff80000000ffff)),
                          vcreate_s32(UINT64_C(0xffff7fffffff7fff)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x7fff7fffffff749a)),
                          vcreate_s32(UINT64_C(0xffffffff54460000)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000ffffabb9ffff8001ffffffff
      result = vqrdmulhq_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0xffff8001ffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x00000000ffffabb9);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_241() {

{
   {
      int16_t arg1;
      int16_t arg2;
      int16_t result;
      char* str1 = "ReproInfo2 {semantics = \"qrdmlh\", fnname = \"vqrdmulhh_s16\", rettype = \"int16_t\", argtypes = \"[int16_t,int16_t]\", vals = [IntegerVal 2310,IntegerVal 32767], start_saturated = False}";
      int reported = 0;
      int16_t got;
      int16_t exp;
      arg1 = 2310;
      arg2 = 32767;
      clear_neon_saturated();
      //  Expect: "result" = 0906
      result = vqrdmulhh_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 2310;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi16 " Got: %" PRIi16 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_242() {

{
   {
      int32_t arg1;
      int32_t arg2;
      int32_t result;
      char* str1 = "ReproInfo2 {semantics = \"qrdmlh\", fnname = \"vqrdmulhs_s32\", rettype = \"int32_t\", argtypes = \"[int32_t,int32_t]\", vals = [IntegerVal (-32769),IntegerVal 2147418112], start_saturated = False}";
      int reported = 0;
      int32_t got;
      int32_t exp;
      arg1 = -32769;
      arg2 = 2147418112;
      clear_neon_saturated();
      //  Expect: "result" = ffff8000
      result = vqrdmulhs_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = -32768;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi32 " Got: %" PRIi32 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_243() {

{
   {
      int32x4_t arg1;
      int16x4_t arg2;
      int16x4_t arg3;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmla\", fnname = \"vqdmlal_s16\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal (-32769),IntegerVal (-32769),IntegerVal (-2147418113),IntegerVal 1664734237],VectorVal [IntegerVal (-25948),IntegerVal (-32768),IntegerVal (-32768),IntegerVal (-32768)],VectorVal [IntegerVal 0,IntegerVal (-32768),IntegerVal (-32768),IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0xffff7fffffff7fff)),
                          vcreate_s32(UINT64_C(0x6339d41d8000ffff)));
      arg2 = vcreate_s16(UINT64_C(0x8000800080009aa4));
      arg3 = vcreate_s16(UINT64_C(0x7fff800080000000));
      clear_neon_saturated();
      //  Expect: "result" = e33ad41d0000fffe7fff7ffeffff7fff
      result = vqdmlal_s16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x7fff7ffeffff7fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0xe33ad41d0000fffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_244() {

{
   {
      int64x2_t arg1;
      int32x2_t arg2;
      int32x2_t arg3;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmla\", fnname = \"vqdmlal_s32\", rettype = \"int64x2_t\", argtypes = \"[int64x2_t,int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal 8150811635951337471,IntegerVal 140735340904447],VectorVal [IntegerVal (-1),IntegerVal 2147418112],VectorVal [IntegerVal (-2147450880),IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x711d7fff7fffffff)),
                          vcreate_s64(UINT64_C(0x00007fff80007fff)));
      arg2 = vcreate_s32(UINT64_C(0x7fff0000ffffffff));
      arg3 = vcreate_s32(UINT64_C(0xffffffff80008000));
      clear_neon_saturated();
      //  Expect: "result" = 00007ffe80027fff711d80007ffeffff
      result = vqdmlal_s32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x711d80007ffeffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0x00007ffe80027fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_245() {

{
   {
      int32_t arg1;
      int16_t arg2;
      int16_t arg3;
      int32_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmla\", fnname = \"vqdmlalh_s16\", rettype = \"int32_t\", argtypes = \"[int32_t,int16_t,int16_t]\", vals = [IntegerVal (-2147418113),IntegerVal (-32768),IntegerVal (-1)], start_saturated = False}";
      int reported = 0;
      int32_t got;
      int32_t exp;
      arg1 = -2147418113;
      arg2 = -32768;
      arg3 = -1;
      clear_neon_saturated();
      //  Expect: "result" = 8001ffff
      result = vqdmlalh_s16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = -2147352577;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi32 " Got: %" PRIi32 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_246() {

{
   {
      int64_t arg1;
      int32_t arg2;
      int32_t arg3;
      int64_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmla\", fnname = \"vqdmlals_s32\", rettype = \"int64_t\", argtypes = \"[int64_t,int32_t,int32_t]\", vals = [IntegerVal (-140737918042113),IntegerVal (-2147450880),IntegerVal (-2147443200)], start_saturated = False}";
      int reported = 0;
      int64_t got;
      int64_t exp;
      arg1 = INT64_C(-140737918042113);
      arg2 = -2147450880;
      arg3 = -2147443200;
      clear_neon_saturated();
      //  Expect: "result" = 7ffe620084637fff
      result = vqdmlals_s32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = INT64_C(9222916841261989887);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi64 " Got: %" PRIi64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_247() {

{
   {
      int32x4_t arg1;
      int16x8_t arg2;
      int16x8_t arg3;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmla\", fnname = \"vqdmlal_high_s16\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal (-2147450881),IntegerVal 32768,IntegerVal (-2147450881),IntegerVal 32767],VectorVal [IntegerVal (-1),IntegerVal (-32768),IntegerVal (-32768),IntegerVal 0,IntegerVal 32767,IntegerVal 0,IntegerVal (-32768),IntegerVal (-32768)],VectorVal [IntegerVal 0,IntegerVal (-32768),IntegerVal 32767,IntegerVal 0,IntegerVal 32767,IntegerVal 3846,IntegerVal 32767,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x0000800080007fff)),
                          vcreate_s32(UINT64_C(0x00007fff80007fff)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x000080008000ffff)),
                          vcreate_s16(UINT64_C(0x8000800000007fff)));
      arg3 = vcombine_s16(vcreate_s16(UINT64_C(0x00007fff80000000)),
                          vcreate_s16(UINT64_C(0x00007fff0f067fff)));
      clear_neon_saturated();
      //  Expect: "result" = 00007fff8000000000008000fffe8001
      result = vqdmlal_high_s16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x00008000fffe8001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x00007fff80000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_248() {

{
   {
      int64x2_t arg1;
      int32x4_t arg2;
      int32x4_t arg3;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmla\", fnname = \"vqdmlal_high_s32\", rettype = \"int64x2_t\", argtypes = \"[int64x2_t,int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal 279787054563328,IntegerVal 281470681803008],VectorVal [IntegerVal (-32122),IntegerVal (-1),IntegerVal (-1),IntegerVal (-680525824)],VectorVal [IntegerVal 2147450879,IntegerVal 0,IntegerVal 739335104,IntegerVal 41264]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x0000fe7700000000)),
                          vcreate_s64(UINT64_C(0x0000ffff0000e900)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0xffffffffffff8286)),
                          vcreate_s32(UINT64_C(0xd7700000ffffffff)));
      arg3 = vcombine_s32(vcreate_s32(UINT64_C(0x000000007fff7fff)),
                          vcreate_s32(UINT64_C(0x0000a1302c115bc0)));
      clear_neon_saturated();
      //  Expect: "result" = 0000cceaaa00e9000000fe76a7dd4880
      result = vqdmlal_high_s32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x0000fe76a7dd4880);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0x0000cceaaa00e900);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_249() {

{
   {
      int32x4_t arg1;
      int16x4_t arg2;
      int16x4_t arg3;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmls\", fnname = \"vqdmlsl_s16\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal (-2147464260),IntegerVal 0,IntegerVal 32768,IntegerVal (-32768)],VectorVal [IntegerVal 28128,IntegerVal (-1),IntegerVal 32767,IntegerVal (-32768)],VectorVal [IntegerVal 0,IntegerVal (-1),IntegerVal 32767,IntegerVal (-32768)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x0000000080004bbc)),
                          vcreate_s32(UINT64_C(0xffff800000008000)));
      arg2 = vcreate_s16(UINT64_C(0x80007fffffff6de0));
      arg3 = vcreate_s16(UINT64_C(0x80007fffffff0000));
      clear_neon_saturated();
      //  Expect: "result" = 8000000080027ffefffffffe80004bbc
      result = vqdmlsl_s16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0xfffffffe80004bbc);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x8000000080027ffe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_250() {

{
   {
      int64x2_t arg1;
      int32x2_t arg2;
      int32x2_t arg3;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmls\", fnname = \"vqdmlsl_s32\", rettype = \"int64x2_t\", argtypes = \"[int64x2_t,int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal 9223349402377093120,IntegerVal 281472829227008],VectorVal [IntegerVal 476250111,IntegerVal 2147450880],VectorVal [IntegerVal 1839333376,IntegerVal (-64365)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x7fffeb69ffff8000)),
                          vcreate_s64(UINT64_C(0x0000ffff80000000)));
      arg2 = vcreate_s32(UINT64_C(0x7fff80001c62ffff));
      arg3 = vcreate_s32(UINT64_C(0xffff04936da20000));
      clear_neon_saturated();
      //  Expect: "result" = 0001fb6b8493000067afb01edb438000
      result = vqdmlsl_s32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x67afb01edb438000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0x0001fb6b84930000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_251() {

{
   {
      int32_t arg1;
      int16_t arg2;
      int16_t arg3;
      int32_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmls\", fnname = \"vqdmlslh_s16\", rettype = \"int32_t\", argtypes = \"[int32_t,int16_t,int16_t]\", vals = [IntegerVal 2147483647,IntegerVal 32767,IntegerVal 0], start_saturated = False}";
      int reported = 0;
      int32_t got;
      int32_t exp;
      arg1 = 2147483647;
      arg2 = 32767;
      arg3 = 0;
      clear_neon_saturated();
      //  Expect: "result" = 7fffffff
      result = vqdmlslh_s16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 2147483647;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi32 " Got: %" PRIi32 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_252() {

{
   {
      int64_t arg1;
      int32_t arg2;
      int32_t arg3;
      int64_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmls\", fnname = \"vqdmlsls_s32\", rettype = \"int64_t\", argtypes = \"[int64_t,int32_t,int32_t]\", vals = [IntegerVal (-9197335599361589249),IntegerVal (-331415552),IntegerVal (-456622081)], start_saturated = False}";
      int reported = 0;
      int64_t got;
      int64_t exp;
      arg1 = INT64_C(-9197335599361589249);
      arg2 = -331415552;
      arg3 = -456622081;
      clear_neon_saturated();
      //  Expect: "result" = 8000000000000000
      result = vqdmlsls_s32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = result;
      exp = INT64_MIN;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi64 " Got: %" PRIi64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_253() {

{
   {
      int32x4_t arg1;
      int16x8_t arg2;
      int16x8_t arg3;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmls\", fnname = \"vqdmlsl_high_s16\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal (-32769),IntegerVal 32767,IntegerVal (-24460),IntegerVal (-2147450880)],VectorVal [IntegerVal (-15303),IntegerVal (-32768),IntegerVal (-32768),IntegerVal (-9107),IntegerVal 14949,IntegerVal 29539,IntegerVal 0,IntegerVal (-1)],VectorVal [IntegerVal 32767,IntegerVal (-32768),IntegerVal 0,IntegerVal 22666,IntegerVal (-32768),IntegerVal (-32768),IntegerVal 2177,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x00007fffffff7fff)),
                          vcreate_s32(UINT64_C(0x80008000ffffa074)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0xdc6d80008000c439)),
                          vcreate_s16(UINT64_C(0xffff000073633a65)));
      arg3 = vcombine_s16(vcreate_s16(UINT64_C(0x588a000080007fff)),
                          vcreate_s16(UINT64_C(0x0000088180008000)));
      clear_neon_saturated();
      //  Expect: "result" = 80008000ffffa07473637fff3a647fff
      result = vqdmlsl_high_s16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x73637fff3a647fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x80008000ffffa074);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_254() {

{
   {
      int64x2_t arg1;
      int32x4_t arg2;
      int32x4_t arg3;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmls\", fnname = \"vqdmlsl_high_s32\", rettype = \"int64x2_t\", argtypes = \"[int64x2_t,int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal 2048152665132630016,IntegerVal (-164254581786222)],VectorVal [IntegerVal (-32769),IntegerVal (-2147450881),IntegerVal (-2147483648),IntegerVal 37414],VectorVal [IntegerVal 2147458893,IntegerVal 0,IntegerVal (-32768),IntegerVal (-2147450881)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x1c6c7fff53000000)),
                          vcreate_s64(UINT64_C(0xffff6a9c7ffff992)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x80007fffffff7fff)),
                          vcreate_s32(UINT64_C(0x0000922680000000)));
      arg3 = vcombine_s32(vcreate_s32(UINT64_C(0x000000007fff9f4d)),
                          vcreate_s32(UINT64_C(0x80007fffffff8000)));
      clear_neon_saturated();
      //  Expect: "result" = fffffcc1eddb1dde1c6bffff53000000
      result = vqdmlsl_high_s32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x1c6bffff53000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0xfffffcc1eddb1dde);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_255() {

{
   {
      int8x8_t arg1;
      int8x8_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmull_s8\", rettype = \"int16x8_t\", argtypes = \"[int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 0,IntegerVal (-1),IntegerVal (-1),IntegerVal 99,IntegerVal 0,IntegerVal 124,IntegerVal (-1)],VectorVal [IntegerVal 127,IntegerVal (-128),IntegerVal (-128),IntegerVal (-1),IntegerVal 0,IntegerVal 0,IntegerVal 0,IntegerVal (-128)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s8(UINT64_C(0xff7c0063ffff0000));
      arg2 = vcreate_s8(UINT64_C(0x80000000ff80807f));
      clear_neon_saturated();
      //  Expect: "result" = 00800000000000000001008000000000
      result = vmull_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x0001008000000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x0080000000000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_256() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmull_s16\", rettype = \"int32x4_t\", argtypes = \"[int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal 0,IntegerVal 32767,IntegerVal 0],VectorVal [IntegerVal 0,IntegerVal 0,IntegerVal 0,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s16(UINT64_C(0x00007fff0000ffff));
      arg2 = vcreate_s16(UINT64_C(0x7fff000000000000));
      clear_neon_saturated();
      //  Expect: "result" = 00000000000000000000000000000000
      result = vmull_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_257() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmull_s32\", rettype = \"int64x2_t\", argtypes = \"[int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal (-1746501633),IntegerVal (-2147450881)],VectorVal [IntegerVal 2147450879,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s32(UINT64_C(0x80007fff97e67fff));
      arg2 = vcreate_s32(UINT64_C(0x00007fff7fff7fff));
      clear_neon_saturated();
      //  Expect: "result" = ffffc000bfff0001cbf3740ca81a0001
      result = vmull_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0xcbf3740ca81a0001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0xffffc000bfff0001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_258() {

{
   {
      uint8x8_t arg1;
      uint8x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmull_u8\", rettype = \"uint16x8_t\", argtypes = \"[uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 255,IntegerVal 0,IntegerVal 127,IntegerVal 255,IntegerVal 255,IntegerVal 128,IntegerVal 127],VectorVal [IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal 127,IntegerVal 255,IntegerVal 255,IntegerVal 127,IntegerVal 200]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u8(UINT64_C(0x7f80ffff7f00ff00));
      arg2 = vcreate_u8(UINT64_C(0xc87fffff7f7f007f));
      clear_neon_saturated();
      //  Expect: "result" = 63383f80fe01fe013f01000000000000
      result = vmull_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x3f01000000000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x63383f80fe01fe01);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_259() {

{
   {
      uint16x4_t arg1;
      uint16x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmull_u16\", rettype = \"uint32x4_t\", argtypes = \"[uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 32768,IntegerVal 65535,IntegerVal 0],VectorVal [IntegerVal 65535,IntegerVal 65535,IntegerVal 65535,IntegerVal 45855]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u16(UINT64_C(0x0000ffff80007fff));
      arg2 = vcreate_u16(UINT64_C(0xb31fffffffffffff));
      clear_neon_saturated();
      //  Expect: "result" = 00000000fffe00017fff80007ffe8001
      result = vmull_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x7fff80007ffe8001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0x00000000fffe0001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_260() {

{
   {
      uint32x2_t arg1;
      uint32x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmull_u32\", rettype = \"uint64x2_t\", argtypes = \"[uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 4294967295,IntegerVal 2147418112],VectorVal [IntegerVal 2147483647,IntegerVal 2070249472]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u32(UINT64_C(0x7fff0000ffffffff));
      arg2 = vcreate_u32(UINT64_C(0x7b6580007fffffff));
      clear_neon_saturated();
      //  Expect: "result" = 3db2449a800000007ffffffe80000001
      result = vmull_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0x7ffffffe80000001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0x3db2449a80000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_261() {

{
   {
      poly8x8_t arg1;
      poly8x8_t arg2;
      poly16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmull_p8\", rettype = \"poly16x8_t\", argtypes = \"[poly8x8_t,poly8x8_t]\", vals = [VectorVal [PolyVal [1,0,0,1,1,1,0,0],PolyVal [1,0,0,0,0,0,1,1],PolyVal [0,0,1,1,1,0,0,1],PolyVal [0,0,0,1,0,1,1,1],PolyVal [0,1,1,1,1,1,0,1],PolyVal [1,1,1,0,1,1,1,1],PolyVal [1,1,0,1,0,0,0,1],PolyVal [0,0,0,1,0,1,0,1]],VectorVal [PolyVal [0,0,1,0,0,1,0,1],PolyVal [1,0,1,0,0,0,1,0],PolyVal [0,0,1,0,0,1,0,1],PolyVal [0,0,1,0,0,1,1,0],PolyVal [0,0,1,0,0,0,0,1],PolyVal [1,1,1,1,0,1,0,1],PolyVal [0,0,1,0,0,0,1,1],PolyVal [1,0,0,0,0,1,0,0]]], start_saturated = True}";
      int reported = 0;
      arg1 = vcreate_p8(UINT64_C(0xa88bf7bee89cc139));
      arg2 = vcreate_p8(UINT64_C(0x21c4af8464a445a4));
      set_neon_saturated();
      //  Expect: "result" = 15a8656c601d5df824a05ff033851b44
      result = vmull_p8(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_p16(result), 0);
         exp = UINT64_C(0x24a05ff033851b44);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_p16(result), 1);
         exp = UINT64_C(0x15a8656c601d5df8);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_262() {

{
   {
      int8x16_t arg1;
      int8x16_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmull_high_s8\", rettype = \"int16x8_t\", argtypes = \"[int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal (-128),IntegerVal (-1),IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal (-128),IntegerVal 0,IntegerVal (-128),IntegerVal 0,IntegerVal (-1),IntegerVal 58,IntegerVal (-1),IntegerVal (-1),IntegerVal (-128)],VectorVal [IntegerVal (-1),IntegerVal (-128),IntegerVal (-1),IntegerVal (-128),IntegerVal (-128),IntegerVal (-1),IntegerVal (-1),IntegerVal 127,IntegerVal (-128),IntegerVal 43,IntegerVal 0,IntegerVal (-128),IntegerVal (-1),IntegerVal (-1),IntegerVal 0,IntegerVal (-128)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s8(vcreate_s8(UINT64_C(0x807f007f007fff80)),
                         vcreate_s8(UINT64_C(0x80ffff3aff008000)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0x7fffff8080ff80ff)),
                         vcreate_s8(UINT64_C(0x8000ffff80002b80)));
      clear_neon_saturated();
      //  Expect: "result" = 400000000001ffc600800000ea800000
      result = vmull_high_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x00800000ea800000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x400000000001ffc6);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_263() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmull_high_s16\", rettype = \"int32x4_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 32767,IntegerVal 32767,IntegerVal (-1),IntegerVal 0,IntegerVal 0,IntegerVal (-32768),IntegerVal 0],VectorVal [IntegerVal (-32768),IntegerVal 29647,IntegerVal 30390,IntegerVal 0,IntegerVal (-32768),IntegerVal (-31438),IntegerVal (-32768),IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0xffff7fff7fff0000)),
                          vcreate_s16(UINT64_C(0x0000800000000000)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x000076b673cf8000)),
                          vcreate_s16(UINT64_C(0x0000800085328000)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000400000000000000000000000
      result = vmull_high_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x0000000040000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_264() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmull_high_s32\", rettype = \"int64x2_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal (-2147424463),IntegerVal 2147483647,IntegerVal (-65536),IntegerVal 65535],VectorVal [IntegerVal 32768,IntegerVal (-2147483648),IntegerVal (-1),IntegerVal 2147483647]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x7fffffff8000e731)),
                          vcreate_s32(UINT64_C(0x0000ffffffff0000)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x8000000000008000)),
                          vcreate_s32(UINT64_C(0x7fffffffffffffff)));
      clear_neon_saturated();
      //  Expect: "result" = 00007fff7fff00010000000000010000
      result = vmull_high_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x0000000000010000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0x00007fff7fff0001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_265() {

{
   {
      uint8x16_t arg1;
      uint8x16_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmull_high_u8\", rettype = \"uint16x8_t\", argtypes = \"[uint8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal 39,IntegerVal 128,IntegerVal 128,IntegerVal 255,IntegerVal 127,IntegerVal 255,IntegerVal 255,IntegerVal 255,IntegerVal 127,IntegerVal 255,IntegerVal 128],VectorVal [IntegerVal 255,IntegerVal 127,IntegerVal 128,IntegerVal 127,IntegerVal 255,IntegerVal 127,IntegerVal 127,IntegerVal 218,IntegerVal 255,IntegerVal 255,IntegerVal 128,IntegerVal 128,IntegerVal 186,IntegerVal 0,IntegerVal 115,IntegerVal 255]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u8(vcreate_u8(UINT64_C(0x8080277f007f0000)),
                         vcreate_u8(UINT64_C(0x80ff7fffffff7fff)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0xda7f7fff7f807fff)),
                         vcreate_u8(UINT64_C(0xff7300ba8080ffff)));
      clear_neon_saturated();
      //  Expect: "result" = 7f80728d0000b9467f807f807e81fe01
      result = vmull_high_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x7f807f807e81fe01);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x7f80728d0000b946);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_266() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmull_high_u16\", rettype = \"uint32x4_t\", argtypes = \"[uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 55242,IntegerVal 32768,IntegerVal 0,IntegerVal 0,IntegerVal 17296,IntegerVal 0,IntegerVal 0,IntegerVal 65535],VectorVal [IntegerVal 48135,IntegerVal 32767,IntegerVal 0,IntegerVal 32768,IntegerVal 65535,IntegerVal 0,IntegerVal 0,IntegerVal 43376]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x000000008000d7ca)),
                          vcreate_u16(UINT64_C(0xffff000000004390)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0x800000007fffbc07)),
                          vcreate_u16(UINT64_C(0xa97000000000ffff)));
      clear_neon_saturated();
      //  Expect: "result" = a96f56900000000000000000438fbc70
      result = vmull_high_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x00000000438fbc70);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0xa96f569000000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_267() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmull_high_u32\", rettype = \"uint64x2_t\", argtypes = \"[uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 4294967295,IntegerVal 32768,IntegerVal 2147549183,IntegerVal 997883903],VectorVal [IntegerVal 4294934528,IntegerVal 65535,IntegerVal 2130974505,IntegerVal 2147516415]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x00008000ffffffff)),
                          vcreate_u32(UINT64_C(0x3b7a7fff8000ffff)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x0000ffffffff8000)),
                          vcreate_u32(UINT64_C(0x80007fff7f041729)));
      clear_neon_saturated();
      //  Expect: "result" = 1dbd5dbc848500013f828a981824e8d7
      result = vmull_high_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0x3f828a981824e8d7);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0x1dbd5dbc84850001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_268() {

{
   {
      poly8x16_t arg1;
      poly8x16_t arg2;
      poly16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"mul\", fnname = \"vmull_high_p8\", rettype = \"poly16x8_t\", argtypes = \"[poly8x16_t,poly8x16_t]\", vals = [VectorVal [PolyVal [1,0,1,0,0,1,0,1],PolyVal [1,0,1,0,1,1,0,1],PolyVal [1,1,1,0,1,0,0,1],PolyVal [1,1,1,0,1,1,0,0],PolyVal [0,0,0,1,1,0,1,0],PolyVal [1,0,0,0,0,1,1,1],PolyVal [0,1,0,0,0,0,1,0],PolyVal [1,1,0,1,1,1,1,0],PolyVal [0,0,1,0,0,1,1,1],PolyVal [0,0,1,0,1,1,0,0],PolyVal [1,1,1,1,0,1,0,0],PolyVal [0,0,0,1,1,1,0,1],PolyVal [1,1,1,1,1,1,0,0],PolyVal [0,0,1,0,0,0,0,1],PolyVal [1,1,1,1,0,0,0,0],PolyVal [0,1,1,1,1,0,0,0]],VectorVal [PolyVal [1,0,1,1,1,1,1,0],PolyVal [0,0,1,1,0,0,1,1],PolyVal [1,0,1,1,0,0,0,1],PolyVal [0,1,0,1,0,0,0,0],PolyVal [1,0,0,0,1,0,1,0],PolyVal [1,1,1,1,0,1,0,1],PolyVal [0,1,1,0,1,1,1,0],PolyVal [1,0,1,0,0,0,0,1],PolyVal [1,1,0,1,1,1,1,0],PolyVal [1,0,0,1,0,1,1,1],PolyVal [1,0,0,0,0,1,0,1],PolyVal [1,0,1,0,1,1,1,0],PolyVal [0,1,1,0,0,0,1,0],PolyVal [1,1,0,0,1,0,0,1],PolyVal [1,0,0,1,0,0,1,1],PolyVal [0,1,1,1,1,1,1,0]]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_p8(vcreate_p8(UINT64_C(0x7b42e1583797b5a5)),
                         vcreate_p8(UINT64_C(0x1e0f843fb82f34e4)));
      arg2 = vcombine_p8(vcreate_p8(UINT64_C(0x8576af510a8dcc7d)),
                         vcreate_p8(UINT64_C(0x7ec9934675a1e97b)));
      clear_neon_saturated();
      //  Expect: "result" = 051404374bcc0f4230d8124f10142dcc
      result = vmull_high_p8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_p16(result), 0);
         exp = UINT64_C(0x30d8124f10142dcc);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_p16(result), 1);
         exp = UINT64_C(0x051404374bcc0f42);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_269() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmul\", fnname = \"vqdmull_s16\", rettype = \"int32x4_t\", argtypes = \"[int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal (-32768),IntegerVal (-13834),IntegerVal 29258],VectorVal [IntegerVal (-1),IntegerVal 31869,IntegerVal (-1),IntegerVal (-1)]], start_saturated = True}";
      int reported = 0;
      arg1 = vcreate_s16(UINT64_C(0x724ac9f680000000));
      arg2 = vcreate_s16(UINT64_C(0xffffffff7c7dffff));
      set_neon_saturated();
      //  Expect: "result" = ffff1b6c00006c148383000000000000
      result = vqdmull_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x8383000000000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0xffff1b6c00006c14);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_270() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmul\", fnname = \"vqdmull_s32\", rettype = \"int64x2_t\", argtypes = \"[int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal 32768,IntegerVal (-32768)],VectorVal [IntegerVal 2147457208,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s32(UINT64_C(0xffff800000008000));
      arg2 = vcreate_s32(UINT64_C(0x000000007fff98b8));
      clear_neon_saturated();
      //  Expect: "result" = 000000000000000000007fff98b80000
      result = vqdmull_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x00007fff98b80000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_271() {

{
   {
      int16_t arg1;
      int16_t arg2;
      int32_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmul\", fnname = \"vqdmullh_s16\", rettype = \"int32_t\", argtypes = \"[int16_t,int16_t]\", vals = [IntegerVal (-1),IntegerVal 0], start_saturated = False}";
      int reported = 0;
      int32_t got;
      int32_t exp;
      arg1 = -1;
      arg2 = 0;
      clear_neon_saturated();
      //  Expect: "result" = 00000000
      result = vqdmullh_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi32 " Got: %" PRIi32 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_272() {

{
   {
      int32_t arg1;
      int32_t arg2;
      int64_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmul\", fnname = \"vqdmulls_s32\", rettype = \"int64_t\", argtypes = \"[int32_t,int32_t]\", vals = [IntegerVal (-1664745473),IntegerVal (-2147483648)], start_saturated = False}";
      int reported = 0;
      int64_t got;
      int64_t exp;
      arg1 = -1664745473;
      arg2 = (int32_t) 0x80000000;
      clear_neon_saturated();
      //  Expect: "result" = 633a000100000000
      result = vqdmulls_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = INT64_C(7150027362699051008);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi64 " Got: %" PRIi64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_273() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmul\", fnname = \"vqdmull_high_s16\", rettype = \"int32x4_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal (-9963),IntegerVal (-32768),IntegerVal 17025,IntegerVal (-32768),IntegerVal 4215,IntegerVal (-1),IntegerVal 29099,IntegerVal (-31618)],VectorVal [IntegerVal (-32768),IntegerVal (-32768),IntegerVal 32767,IntegerVal (-32768),IntegerVal 0,IntegerVal 0,IntegerVal (-1),IntegerVal (-32768)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x800042818000d915)),
                          vcreate_s16(UINT64_C(0x847e71abffff1077)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x80007fff80008000)),
                          vcreate_s16(UINT64_C(0x8000ffff00000000)));
      clear_neon_saturated();
      //  Expect: "result" = 7b820000ffff1caa0000000000000000
      result = vqdmull_high_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x7b820000ffff1caa);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_274() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"qdmul\", fnname = \"vqdmull_high_s32\", rettype = \"int64x2_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal (-2147418113),IntegerVal (-791314433),IntegerVal 1878261759,IntegerVal 1425408000],VectorVal [IntegerVal (-32769),IntegerVal 2147450880,IntegerVal (-32768),IntegerVal (-867433466)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0xd0d57fff8000ffff)),
                          vcreate_s32(UINT64_C(0x54f600006ff3ffff)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x7fff8000ffff7fff)),
                          vcreate_s32(UINT64_C(0xcc4c0406ffff8000)));
      clear_neon_saturated();
      //  Expect: "result" = ddae84bbab880000ffff900c00010000
      result = vqdmull_high_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0xffff900c00010000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0xddae84bbab880000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_275() {

{
   {
      float32x2_t arg1;
      float32x2_t arg2;
      float32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"div\", fnname = \"vdiv_f32\", rettype = \"float32x2_t\", argtypes = \"[float32x2_t,float32x2_t]\", vals = [VectorVal [FloatVal 0.3943381905555725,FloatVal 0.10620331764221191],VectorVal [FloatVal 0.24389833211898804,FloatVal 0.793936014175415]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_f32(UINT64_C(0x3dd981203ec9e6b2));
      arg2 = vcreate_f32(UINT64_C(0x3f4b3f643e79c07c));
      clear_neon_saturated();
      //  Expect: "result" = 3e08fa823fcef3c1
      result = vdiv_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float32_t got;
         float32_t exp;
         got = vget_lane_f32(result, 0);
         exp = ((float32_t) 1.6168137788772583);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vget_lane_f32(result, 1);
         exp = ((float32_t) 0.13376811146736145);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
   }
}
}
void dotests_276() {

{
   {
      float64x1_t arg1;
      float64x1_t arg2;
      float64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"div\", fnname = \"vdiv_f64\", rettype = \"float64x1_t\", argtypes = \"[float64x1_t,float64x1_t]\", vals = [VectorVal [FloatVal 0.42691917315532213],VectorVal [FloatVal 5.333014278155601e-2]], start_saturated = False}";
      int reported = 0;
      float64_t got;
      float64_t exp;
      arg1 = vcreate_f64(UINT64_C(0x3fdb52a4cbaf32b4));
      arg2 = vcreate_f64(UINT64_C(0x3fab4e16a6468ce0));
      clear_neon_saturated();
      //  Expect: "result" = 402002ab54625854
      result = vdiv_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_f64(result, 0);
      exp = 8.005213391308793;
      if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
         }
   }
}
}
void dotests_277() {

{
   {
      float32x4_t arg1;
      float32x4_t arg2;
      float32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"div\", fnname = \"vdivq_f32\", rettype = \"float32x4_t\", argtypes = \"[float32x4_t,float32x4_t]\", vals = [VectorVal [FloatVal 0.9860303997993469,FloatVal 2.8651535511016846e-2,FloatVal 0.32012295722961426,FloatVal 1.9760191440582275e-2],VectorVal [FloatVal 0.49116039276123047,FloatVal 8.336400985717773e-2,FloatVal 0.45163965225219727,FloatVal 0.8752203583717346]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f32(vcreate_f32(UINT64_C(0x3ceab6a03f7c6c7d)),
                          vcreate_f32(UINT64_C(0x3ca1e0203ea3e728)));
      arg2 = vcombine_f32(vcreate_f32(UINT64_C(0x3daabac03efb7960)),
                          vcreate_f32(UINT64_C(0x3f600e713ee73d50)));
      clear_neon_saturated();
      //  Expect: "result" = 3cb8f4383f3574073eaff86340007bbf
      result = vdivq_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 0);
         exp = ((float32_t) 2.0075528621673584);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 1);
         exp = ((float32_t) 0.3436919152736664);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 2);
         exp = ((float32_t) 0.7088016867637634);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 2 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 3);
         exp = ((float32_t) 2.257739007472992e-2);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 3 ", exp, got);
            }
      }
   }
}
}
void dotests_278() {

{
   {
      float64x2_t arg1;
      float64x2_t arg2;
      float64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"div\", fnname = \"vdivq_f64\", rettype = \"float64x2_t\", argtypes = \"[float64x2_t,float64x2_t]\", vals = [VectorVal [FloatVal 0.49584213293553303,FloatVal 0.5483966758710147],VectorVal [FloatVal 0.10229001214715716,FloatVal 0.5381493677929209]], start_saturated = True}";
      int reported = 0;
      arg1 = vcombine_f64(vcreate_f64(UINT64_C(0x3fdfbbe0a43bf7ca)),
                          vcreate_f64(UINT64_C(0x3fe18c772f833c61)));
      arg2 = vcombine_f64(vcreate_f64(UINT64_C(0x3fba2fada0e125c8)),
                          vcreate_f64(UINT64_C(0x3fe1388505e113d5)));
      set_neon_saturated();
      //  Expect: "result" = 3ff04dfeba04b95d401363c0bddaffcf
      result = vdivq_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         float64_t got;
         float64_t exp;
         got = vgetq_lane_f64(result, 0);
         exp = 4.8474149384419;
         if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float64_t got;
         float64_t exp;
         got = vgetq_lane_f64(result, 1);
         exp = 1.019041754374107;
         if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
   }
}
}
void dotests_279() {

{
   {
      int8x8_t arg1;
      int8x8_t arg2;
      int8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsub_s8\", rettype = \"int8x8_t\", argtypes = \"[int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 127,IntegerVal (-128),IntegerVal (-1),IntegerVal 0,IntegerVal 0,IntegerVal 0,IntegerVal 127],VectorVal [IntegerVal (-128),IntegerVal (-128),IntegerVal 0,IntegerVal 127,IntegerVal 45,IntegerVal 0,IntegerVal (-122),IntegerVal 127]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s8(UINT64_C(0x7f000000ff807f00));
      arg2 = vcreate_s8(UINT64_C(0x7f86002d7f008080));
      clear_neon_saturated();
      //  Expect: "result" = 007a00d38080ff80
      result = vsub_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s8(result), 0);
      exp = UINT64_C(0x007a00d38080ff80);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_280() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      int16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsub_s16\", rettype = \"int16x4_t\", argtypes = \"[int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal (-616),IntegerVal (-9023),IntegerVal (-1)],VectorVal [IntegerVal (-32768),IntegerVal (-32734),IntegerVal 0,IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s16(UINT64_C(0xffffdcc1fd980000));
      arg2 = vcreate_s16(UINT64_C(0xffff000080228000));
      clear_neon_saturated();
      //  Expect: "result" = 0000dcc17d768000
      result = vsub_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s16(result), 0);
      exp = UINT64_C(0x0000dcc17d768000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_281() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      int32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsub_s32\", rettype = \"int32x2_t\", argtypes = \"[int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 2147433289],VectorVal [IntegerVal (-2147418113),IntegerVal 22408]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s32(UINT64_C(0x7fff3b4900007fff));
      arg2 = vcreate_s32(UINT64_C(0x000057888000ffff));
      clear_neon_saturated();
      //  Expect: "result" = 7ffee3c17fff8000
      result = vsub_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s32(result), 0);
      exp = UINT64_C(0x7ffee3c17fff8000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_282() {

{
   {
      int64x1_t arg1;
      int64x1_t arg2;
      int64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsub_s64\", rettype = \"int64x1_t\", argtypes = \"[int64x1_t,int64x1_t]\", vals = [VectorVal [IntegerVal (-140741068390401)],VectorVal [IntegerVal (-136985834455041)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s64(UINT64_C(0xffff7fff2a9cffff));
      arg2 = vcreate_s64(UINT64_C(0xffff83697fff7fff));
      clear_neon_saturated();
      //  Expect: "result" = fffffc95aa9d8000
      result = vsub_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s64(result), 0);
      exp = UINT64_C(0xfffffc95aa9d8000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_283() {

{
   {
      float32x2_t arg1;
      float32x2_t arg2;
      float32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsub_f32\", rettype = \"float32x2_t\", argtypes = \"[float32x2_t,float32x2_t]\", vals = [VectorVal [FloatVal 4.768824577331543e-2,FloatVal 0.8095514178276062],VectorVal [FloatVal 0.6507919430732727,FloatVal 0.2855151891708374]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_f32(UINT64_C(0x3f4f3ec33d4354c0));
      arg2 = vcreate_f32(UINT64_C(0x3e922f0c3f269a4d));
      clear_neon_saturated();
      //  Expect: "result" = 3f06273dbf1a6501
      result = vsub_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float32_t got;
         float32_t exp;
         got = vget_lane_f32(result, 0);
         exp = ((float32_t) -0.6031036972999573);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vget_lane_f32(result, 1);
         exp = ((float32_t) 0.5240362286567688);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
   }
}
}
void dotests_284() {

{
   {
      uint8x8_t arg1;
      uint8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsub_u8\", rettype = \"uint8x8_t\", argtypes = \"[uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 128,IntegerVal 128,IntegerVal 127,IntegerVal 255,IntegerVal 128,IntegerVal 80,IntegerVal 0,IntegerVal 127],VectorVal [IntegerVal 162,IntegerVal 54,IntegerVal 0,IntegerVal 255,IntegerVal 255,IntegerVal 82,IntegerVal 255,IntegerVal 255]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u8(UINT64_C(0x7f005080ff7f8080));
      arg2 = vcreate_u8(UINT64_C(0xffff52ffff0036a2));
      clear_neon_saturated();
      //  Expect: "result" = 8001fe81007f4ade
      result = vsub_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0x8001fe81007f4ade);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_285() {

{
   {
      uint16x4_t arg1;
      uint16x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsub_u16\", rettype = \"uint16x4_t\", argtypes = \"[uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 32767,IntegerVal 32767,IntegerVal 65535],VectorVal [IntegerVal 65535,IntegerVal 32767,IntegerVal 65535,IntegerVal 32768]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u16(UINT64_C(0xffff7fff7fff0000));
      arg2 = vcreate_u16(UINT64_C(0x8000ffff7fffffff));
      clear_neon_saturated();
      //  Expect: "result" = 7fff800000000001
      result = vsub_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0x7fff800000000001);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_286() {

{
   {
      uint32x2_t arg1;
      uint32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsub_u32\", rettype = \"uint32x2_t\", argtypes = \"[uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 4294950460,IntegerVal 65535],VectorVal [IntegerVal 2147418112,IntegerVal 4294967295]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u32(UINT64_C(0x0000ffffffffbe3c));
      arg2 = vcreate_u32(UINT64_C(0xffffffff7fff0000));
      clear_neon_saturated();
      //  Expect: "result" = 000100008000be3c
      result = vsub_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0x000100008000be3c);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_287() {

{
   {
      uint64x1_t arg1;
      uint64x1_t arg2;
      uint64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsub_u64\", rettype = \"uint64x1_t\", argtypes = \"[uint64x1_t,uint64x1_t]\", vals = [VectorVal [IntegerVal 65535],VectorVal [IntegerVal 9223512774343163067]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u64(UINT64_C(0x000000000000ffff));
      arg2 = vcreate_u64(UINT64_C(0x8000800000007cbb));
      clear_neon_saturated();
      //  Expect: "result" = 7fff800000008344
      result = vsub_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(result, 0);
      exp = UINT64_C(0x7fff800000008344);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_288() {

{
   {
      int8x16_t arg1;
      int8x16_t arg2;
      int8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubq_s8\", rettype = \"int8x16_t\", argtypes = \"[int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal 57,IntegerVal (-48),IntegerVal (-60),IntegerVal (-128),IntegerVal 0,IntegerVal 127,IntegerVal 127,IntegerVal (-1),IntegerVal (-128),IntegerVal 0,IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal 127],VectorVal [IntegerVal 0,IntegerVal (-1),IntegerVal (-1),IntegerVal (-1),IntegerVal 111,IntegerVal 127,IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal (-128),IntegerVal (-28),IntegerVal (-101),IntegerVal 70,IntegerVal 127,IntegerVal (-128),IntegerVal 127]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s8(vcreate_s8(UINT64_C(0x7f7f0080c4d039ff)),
                         vcreate_s8(UINT64_C(0x7f7f007f000080ff)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0x007f7f6fffffff00)),
                         vcreate_s8(UINT64_C(0x7f807f469be4807f)));
      clear_neon_saturated();
      //  Expect: "result" = 00ff8139651c00807f008111c5d13aff
      result = vsubq_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 0);
         exp = UINT64_C(0x7f008111c5d13aff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 1);
         exp = UINT64_C(0x00ff8139651c0080);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_289() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubq_s16\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal (-32768),IntegerVal (-32768),IntegerVal (-32768),IntegerVal (-1454),IntegerVal (-1),IntegerVal 32767,IntegerVal (-32768),IntegerVal 17881],VectorVal [IntegerVal 0,IntegerVal 0,IntegerVal 32767,IntegerVal (-18513),IntegerVal 32459,IntegerVal 27292,IntegerVal 32767,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0xfa52800080008000)),
                          vcreate_s16(UINT64_C(0x45d980007fffffff)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0xb7af7fff00000000)),
                          vcreate_s16(UINT64_C(0x00007fff6a9c7ecb)));
      clear_neon_saturated();
      //  Expect: "result" = 45d900011563813442a3000180008000
      result = vsubq_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x42a3000180008000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x45d9000115638134);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_290() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubq_s32\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal 2147483647,IntegerVal 56519,IntegerVal (-32768),IntegerVal 65535],VectorVal [IntegerVal (-413794304),IntegerVal (-2147450880),IntegerVal 1679479345,IntegerVal 2147450879]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x0000dcc77fffffff)),
                          vcreate_s32(UINT64_C(0x0000ffffffff8000)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x80008000e7560000)),
                          vcreate_s32(UINT64_C(0x7fff7fff641ad231)));
      clear_neon_saturated();
      //  Expect: "result" = 800180009be4adcf80005cc798a9ffff
      result = vsubq_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x80005cc798a9ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x800180009be4adcf);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_291() {

{
   {
      int64x2_t arg1;
      int64x2_t arg2;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubq_s64\", rettype = \"int64x2_t\", argtypes = \"[int64x2_t,int64x2_t]\", vals = [VectorVal [IntegerVal 140737488360065,IntegerVal (-281474976677888)],VectorVal [IntegerVal (-9223231295071453185),IntegerVal 281474976677887]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x0000800000001281)),
                          vcreate_s64(UINT64_C(0xffff000000008000)));
      arg2 = vcombine_s64(vcreate_s64(UINT64_C(0x80008000ffffffff)),
                          vcreate_s64(UINT64_C(0x0000ffffffff7fff)));
      clear_neon_saturated();
      //  Expect: "result" = fffe0000000100017fffffff00001282
      result = vsubq_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x7fffffff00001282);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0xfffe000000010001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_292() {

{
   {
      float32x4_t arg1;
      float32x4_t arg2;
      float32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubq_f32\", rettype = \"float32x4_t\", argtypes = \"[float32x4_t,float32x4_t]\", vals = [VectorVal [FloatVal 0.805039644241333,FloatVal 0.8142534494400024,FloatVal 0.31933683156967163,FloatVal 1.9804537296295166e-2],VectorVal [FloatVal 0.43983978033065796,FloatVal 0.8844547867774963,FloatVal 0.375455379486084,FloatVal 0.6776692867279053]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f32(vcreate_f32(UINT64_C(0x3f5072ea3f4e1714)),
                          vcreate_f32(UINT64_C(0x3ca23d203ea3801e)));
      arg2 = vcombine_f32(vcreate_f32(UINT64_C(0x3f626ba13ee132ae)),
                          vcreate_f32(UINT64_C(0x3f2d7bbc3ec03bb0)));
      clear_neon_saturated();
      //  Expect: "result" = bf2869d3bd65dc90bd8fc5b83ebafb7a
      result = vsubq_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 0);
         exp = ((float32_t) 0.36519986391067505);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 1);
         exp = ((float32_t) -7.02013373374939e-2);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 2);
         exp = ((float32_t) -5.6118547916412354e-2);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 2 ", exp, got);
            }
      }
      {
         float32_t got;
         float32_t exp;
         got = vgetq_lane_f32(result, 3);
         exp = ((float32_t) -0.6578647494316101);
         if(((((exp / got) < ((float32_t) 0.999)) || ((exp / got) > ((float32_t) 1.001))) && (((exp - got) < ((float32_t) -1.0e-4)) || ((exp - got) > ((float32_t) 1.0e-4)))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 3 ", exp, got);
            }
      }
   }
}
}
void dotests_293() {

{
   {
      uint8x16_t arg1;
      uint8x16_t arg2;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubq_u8\", rettype = \"uint8x16_t\", argtypes = \"[uint8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 127,IntegerVal 21,IntegerVal 20,IntegerVal 13,IntegerVal 210,IntegerVal 127,IntegerVal 128,IntegerVal 182,IntegerVal 66,IntegerVal 255,IntegerVal 255,IntegerVal 0,IntegerVal 0,IntegerVal 87,IntegerVal 200,IntegerVal 255],VectorVal [IntegerVal 0,IntegerVal 127,IntegerVal 127,IntegerVal 127,IntegerVal 153,IntegerVal 127,IntegerVal 127,IntegerVal 172,IntegerVal 29,IntegerVal 64,IntegerVal 127,IntegerVal 128,IntegerVal 139,IntegerVal 0,IntegerVal 128,IntegerVal 128]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u8(vcreate_u8(UINT64_C(0xb6807fd20d14157f)),
                         vcreate_u8(UINT64_C(0xffc8570000ffff42)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0xac7f7f997f7f7f00)),
                         vcreate_u8(UINT64_C(0x8080008b807f401d)));
      clear_neon_saturated();
      //  Expect: "result" = 7f4857758080bf250a0100398e95967f
      result = vsubq_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x0a0100398e95967f);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0x7f4857758080bf25);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_294() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubq_u16\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 65535,IntegerVal 0,IntegerVal 0,IntegerVal 32768,IntegerVal 32768,IntegerVal 32768,IntegerVal 32768],VectorVal [IntegerVal 39398,IntegerVal 65535,IntegerVal 0,IntegerVal 56883,IntegerVal 65535,IntegerVal 32768,IntegerVal 0,IntegerVal 11324]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x00000000ffff0000)),
                          vcreate_u16(UINT64_C(0x8000800080008000)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0xde330000ffff99e6)),
                          vcreate_u16(UINT64_C(0x2c3c00008000ffff)));
      clear_neon_saturated();
      //  Expect: "result" = 53c480000000800121cd00000000661a
      result = vsubq_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x21cd00000000661a);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x53c4800000008001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_295() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubq_u32\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 2147483647,IntegerVal 2147450879,IntegerVal 2147516415,IntegerVal 13639],VectorVal [IntegerVal 2734177468,IntegerVal 32768,IntegerVal 2147516415,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x7fff7fff7fffffff)),
                          vcreate_u32(UINT64_C(0x0000354780007fff)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x00008000a2f83cbc)),
                          vcreate_u32(UINT64_C(0x00007fff80007fff)));
      clear_neon_saturated();
      //  Expect: "result" = ffffb548000000007ffeffffdd07c343
      result = vsubq_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x7ffeffffdd07c343);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0xffffb54800000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_296() {

{
   {
      uint64x2_t arg1;
      uint64x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubq_u64\", rettype = \"uint64x2_t\", argtypes = \"[uint64x2_t,uint64x2_t]\", vals = [VectorVal [IntegerVal 281472829194239,IntegerVal 2238429752291491840],VectorVal [IntegerVal 18446744069414617087,IntegerVal 9223101646737859685]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0x0000ffff7fff7fff)),
                          vcreate_u64(UINT64_C(0x1f10800000000000)));
      arg2 = vcombine_u64(vcreate_u64(UINT64_C(0xffffffff00007fff)),
                          vcreate_u64(UINT64_C(0x7fff0a14e5216465)));
      clear_neon_saturated();
      //  Expect: "result" = 9f1175eb1ade9b9b000100007fff0000
      result = vsubq_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0x000100007fff0000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0x9f1175eb1ade9b9b);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_297() {

{
   {
      float64x1_t arg1;
      float64x1_t arg2;
      float64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsub_f64\", rettype = \"float64x1_t\", argtypes = \"[float64x1_t,float64x1_t]\", vals = [VectorVal [FloatVal 0.5843540769789802],VectorVal [FloatVal 0.3586207257152022]], start_saturated = False}";
      int reported = 0;
      float64_t got;
      float64_t exp;
      arg1 = vcreate_f64(UINT64_C(0x3fe2b307523d166b));
      arg2 = vcreate_f64(UINT64_C(0x3fd6f3a458275546));
      clear_neon_saturated();
      //  Expect: "result" = 3fcce4d498a5af20
      result = vsub_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_f64(result, 0);
      exp = 0.22573335126377803;
      if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
         }
   }
}
}
void dotests_298() {

{
   {
      float64x2_t arg1;
      float64x2_t arg2;
      float64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubq_f64\", rettype = \"float64x2_t\", argtypes = \"[float64x2_t,float64x2_t]\", vals = [VectorVal [FloatVal 0.2204200279093601,FloatVal 0.33492918569927255],VectorVal [FloatVal 0.6584738349037559,FloatVal 0.17379582216196376]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f64(vcreate_f64(UINT64_C(0x3fcc36b935a086a4)),
                          vcreate_f64(UINT64_C(0x3fd56f7ad2c3796e)));
      arg2 = vcombine_f64(vcreate_f64(UINT64_C(0x3fe51237b845dde1)),
                          vcreate_f64(UINT64_C(0x3fc63ef1062efc08)));
      clear_neon_saturated();
      //  Expect: "result" = 3fc4a0049f57f6d4bfdc0912d5bb7870
      result = vsubq_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         float64_t got;
         float64_t exp;
         got = vgetq_lane_f64(result, 0);
         exp = -0.4380538069943958;
         if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 0 ", exp, got);
            }
      }
      {
         float64_t got;
         float64_t exp;
         got = vgetq_lane_f64(result, 1);
         exp = 0.16113336353730878;
         if(((((exp / got) < 0.999) || ((exp / got) > 1.001)) && (((exp - got) < -1.0e-4) || ((exp - got) > 1.0e-4))))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %f Got: %f\n", "   Lane 1 ", exp, got);
            }
      }
   }
}
}
void dotests_299() {

{
   {
      int64_t arg1;
      int64_t arg2;
      int64_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubd_s64\", rettype = \"int64_t\", argtypes = \"[int64_t,int64_t]\", vals = [IntegerVal (-9223090564398678017),IntegerVal 1314769614067990527], start_saturated = False}";
      int reported = 0;
      int64_t got;
      int64_t exp;
      arg1 = INT64_C(-9223090564398678017);
      arg2 = INT64_C(1314769614067990527);
      clear_neon_saturated();
      //  Expect: "result" = 6dc1ffffe9c28000
      result = vsubd_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = INT64_C(7908883895242883072);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi64 " Got: %" PRIi64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_300() {

{
   {
      uint64_t arg1;
      uint64_t arg2;
      uint64_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubd_u64\", rettype = \"uint64_t\", argtypes = \"[uint64_t,uint64_t]\", vals = [IntegerVal 9223653509787396097,IntegerVal 9223372040262647807], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = UINT64_C(0x8000ffff8629a801);
      arg2 = UINT64_C(0x80000000cb1fffff);
      clear_neon_saturated();
      //  Expect: "result" = 0000fffebb09a802
      result = vsubd_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = UINT64_C(0x0000fffebb09a802);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_301() {

{
   {
      int8x8_t arg1;
      int8x8_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubl_s8\", rettype = \"int16x8_t\", argtypes = \"[int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal (-128),IntegerVal (-128),IntegerVal (-1),IntegerVal 0,IntegerVal 0,IntegerVal 0,IntegerVal 127,IntegerVal 0],VectorVal [IntegerVal 9,IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal (-93),IntegerVal (-1),IntegerVal (-1),IntegerVal (-42)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s8(UINT64_C(0x007f000000ff8080));
      arg2 = vcreate_s8(UINT64_C(0xd6ffffa3007f0009));
      clear_neon_saturated();
      //  Expect: "result" = 002a00800001005d0000ff80ff80ff77
      result = vsubl_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x0000ff80ff80ff77);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x002a00800001005d);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_302() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubl_s16\", rettype = \"int32x4_t\", argtypes = \"[int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal (-32768),IntegerVal 32767,IntegerVal 32767,IntegerVal 32767],VectorVal [IntegerVal 0,IntegerVal 20272,IntegerVal 27842,IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s16(UINT64_C(0x7fff7fff7fff8000));
      arg2 = vcreate_s16(UINT64_C(0xffff6cc24f300000));
      clear_neon_saturated();
      //  Expect: "result" = 000080000000133d000030cfffff8000
      result = vsubl_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x000030cfffff8000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x000080000000133d);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_303() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubl_s32\", rettype = \"int64x2_t\", argtypes = \"[int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal (-32769),IntegerVal 0],VectorVal [IntegerVal 15109,IntegerVal (-2147418113)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s32(UINT64_C(0x00000000ffff7fff));
      arg2 = vcreate_s32(UINT64_C(0x8000ffff00003b05));
      clear_neon_saturated();
      //  Expect: "result" = 000000007fff0001ffffffffffff44fa
      result = vsubl_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0xffffffffffff44fa);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0x000000007fff0001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_304() {

{
   {
      uint8x8_t arg1;
      uint8x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubl_u8\", rettype = \"uint16x8_t\", argtypes = \"[uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 108,IntegerVal 128,IntegerVal 0,IntegerVal 20,IntegerVal 204,IntegerVal 0,IntegerVal 69,IntegerVal 0],VectorVal [IntegerVal 0,IntegerVal 128,IntegerVal 128,IntegerVal 7,IntegerVal 128,IntegerVal 127,IntegerVal 95,IntegerVal 160]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u8(UINT64_C(0x004500cc1400806c));
      arg2 = vcreate_u8(UINT64_C(0xa05f7f8007808000));
      clear_neon_saturated();
      //  Expect: "result" = ff60ffe6ff81004c000dff800000006c
      result = vsubl_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x000dff800000006c);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0xff60ffe6ff81004c);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_305() {

{
   {
      uint16x4_t arg1;
      uint16x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubl_u16\", rettype = \"uint32x4_t\", argtypes = \"[uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 60683,IntegerVal 65535,IntegerVal 0,IntegerVal 0],VectorVal [IntegerVal 65535,IntegerVal 0,IntegerVal 0,IntegerVal 32768]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u16(UINT64_C(0x00000000ffffed0b));
      arg2 = vcreate_u16(UINT64_C(0x800000000000ffff));
      clear_neon_saturated();
      //  Expect: "result" = ffff8000000000000000ffffffffed0c
      result = vsubl_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x0000ffffffffed0c);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0xffff800000000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_306() {

{
   {
      uint32x2_t arg1;
      uint32x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubl_u32\", rettype = \"uint64x2_t\", argtypes = \"[uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 4294967295,IntegerVal 2147482202],VectorVal [IntegerVal 2247950335,IntegerVal 2147516416]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u32(UINT64_C(0x7ffffa5affffffff));
      arg2 = vcreate_u32(UINT64_C(0x8000800085fcffff));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffff7a5a000000007a030000
      result = vsubl_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0x000000007a030000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0xffffffffffff7a5a);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_307() {

{
   {
      int8x16_t arg1;
      int8x16_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubl_high_s8\", rettype = \"int16x8_t\", argtypes = \"[int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal 120,IntegerVal 0,IntegerVal 0,IntegerVal (-128),IntegerVal (-88),IntegerVal (-1),IntegerVal 0,IntegerVal (-128),IntegerVal (-128),IntegerVal 127,IntegerVal (-1),IntegerVal 6,IntegerVal 0,IntegerVal 0,IntegerVal 0,IntegerVal 127],VectorVal [IntegerVal (-69),IntegerVal (-1),IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal (-128),IntegerVal 0,IntegerVal 127,IntegerVal (-128),IntegerVal 127,IntegerVal (-128),IntegerVal (-128),IntegerVal 127,IntegerVal 116,IntegerVal (-128),IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s8(vcreate_s8(UINT64_C(0x8000ffa880000078)),
                         vcreate_s8(UINT64_C(0x7f00000006ff7f80)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0x7f0080007f00ffbb)),
                         vcreate_s8(UINT64_C(0x0080747f80807f80)));
      clear_neon_saturated();
      //  Expect: "result" = 007f0080ff8cff810086007f00000000
      result = vsubl_high_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x0086007f00000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x007f0080ff8cff81);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_308() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubl_high_s16\", rettype = \"int32x4_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal (-32768),IntegerVal 32767,IntegerVal (-32768),IntegerVal (-32768),IntegerVal 32767,IntegerVal (-28030),IntegerVal (-32768),IntegerVal 0],VectorVal [IntegerVal 0,IntegerVal 32767,IntegerVal 10851,IntegerVal 32767,IntegerVal (-29254),IntegerVal (-32768),IntegerVal 0,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x800080007fff8000)),
                          vcreate_s16(UINT64_C(0x0000800092827fff)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x7fff2a637fff0000)),
                          vcreate_s16(UINT64_C(0x0000000080008dba)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000ffff8000000012820000f245
      result = vsubl_high_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x000012820000f245);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x00000000ffff8000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_309() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubl_high_s32\", rettype = \"int64x2_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal (-1959919617),IntegerVal 2147464108,IntegerVal (-1),IntegerVal (-32769)],VectorVal [IntegerVal (-28107),IntegerVal (-65536),IntegerVal (-32768),IntegerVal 2147450880]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x7fffb3ac8b2dffff)),
                          vcreate_s32(UINT64_C(0xffff7fffffffffff)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0xffff0000ffff9235)),
                          vcreate_s32(UINT64_C(0x7fff8000ffff8000)));
      clear_neon_saturated();
      //  Expect: "result" = ffffffff7fffffff0000000000007fff
      result = vsubl_high_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x0000000000007fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0xffffffff7fffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_310() {

{
   {
      uint8x16_t arg1;
      uint8x16_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubl_high_u8\", rettype = \"uint16x8_t\", argtypes = \"[uint8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 127,IntegerVal 127,IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal 255,IntegerVal 211,IntegerVal 128,IntegerVal 127,IntegerVal 184,IntegerVal 227,IntegerVal 255,IntegerVal 128,IntegerVal 128,IntegerVal 149],VectorVal [IntegerVal 0,IntegerVal 127,IntegerVal 128,IntegerVal 0,IntegerVal 0,IntegerVal 127,IntegerVal 255,IntegerVal 255,IntegerVal 75,IntegerVal 255,IntegerVal 127,IntegerVal 127,IntegerVal 0,IntegerVal 221,IntegerVal 0,IntegerVal 128]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u8(vcreate_u8(UINT64_C(0xd3ff7f007f7f7f00)),
                         vcreate_u8(UINT64_C(0x958080ffe3b87f80)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0xffff7f0000807f00)),
                         vcreate_u8(UINT64_C(0x8000dd007f7fff4b)));
      clear_neon_saturated();
      //  Expect: "result" = 00150080ffa300ff00640039ff800035
      result = vsubl_high_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x00640039ff800035);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x00150080ffa300ff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_311() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubl_high_u16\", rettype = \"uint32x4_t\", argtypes = \"[uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 32768,IntegerVal 52680,IntegerVal 65535,IntegerVal 65535,IntegerVal 0,IntegerVal 32767,IntegerVal 65535,IntegerVal 32767],VectorVal [IntegerVal 65535,IntegerVal 32767,IntegerVal 32768,IntegerVal 32768,IntegerVal 0,IntegerVal 32767,IntegerVal 65419,IntegerVal 43954]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0xffffffffcdc88000)),
                          vcreate_u16(UINT64_C(0x7fffffff7fff0000)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0x800080007fffffff)),
                          vcreate_u16(UINT64_C(0xabb2ff8b7fff0000)));
      clear_neon_saturated();
      //  Expect: "result" = ffffd44d000000740000000000000000
      result = vsubl_high_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0xffffd44d00000074);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_312() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubl_high_u32\", rettype = \"uint64x2_t\", argtypes = \"[uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 4294967295,IntegerVal 2147450880,IntegerVal 2147516416,IntegerVal 1529348096],VectorVal [IntegerVal 2147516416,IntegerVal 52955,IntegerVal 4294901760,IntegerVal 2147453221]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x7fff8000ffffffff)),
                          vcreate_u32(UINT64_C(0x5b28000080008000)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x0000cedb80008000)),
                          vcreate_u32(UINT64_C(0x7fff8925ffff0000)));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffdb2876dbffffffff80018000
      result = vsubl_high_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0xffffffff80018000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0xffffffffdb2876db);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_313() {

{
   {
      int16x8_t arg1;
      int8x8_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubw_s8\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal 32767,IntegerVal (-32768),IntegerVal 32767,IntegerVal (-32768),IntegerVal 32767,IntegerVal (-32768),IntegerVal (-32768)],VectorVal [IntegerVal (-128),IntegerVal (-1),IntegerVal 0,IntegerVal (-74),IntegerVal (-128),IntegerVal (-1),IntegerVal 81,IntegerVal (-128)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x7fff80007fffffff)),
                          vcreate_s16(UINT64_C(0x800080007fff8000)));
      arg2 = vcreate_s8(UINT64_C(0x8051ff80b600ff80));
      clear_neon_saturated();
      //  Expect: "result" = 80807faf80008080804980008000007f
      result = vsubw_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x804980008000007f);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x80807faf80008080);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_314() {

{
   {
      int32x4_t arg1;
      int16x4_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubw_s16\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal (-32769),IntegerVal 2147483647,IntegerVal 32767,IntegerVal (-2147483648)],VectorVal [IntegerVal (-32768),IntegerVal (-1),IntegerVal (-32768),IntegerVal (-32768)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x7fffffffffff7fff)),
                          vcreate_s32(UINT64_C(0x8000000000007fff)));
      arg2 = vcreate_s16(UINT64_C(0x80008000ffff8000));
      clear_neon_saturated();
      //  Expect: "result" = 800080000000ffff80000000ffffffff
      result = vsubw_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x80000000ffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x800080000000ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_315() {

{
   {
      int64x2_t arg1;
      int32x2_t arg2;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubw_s32\", rettype = \"int64x2_t\", argtypes = \"[int64x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal 4552013323364663296,IntegerVal (-4294934351)],VectorVal [IntegerVal 2147451168,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x3f2bffffffff0000)),
                          vcreate_s64(UINT64_C(0xffffffff000080b1)));
      arg2 = vcreate_s32(UINT64_C(0x000000007fff8120));
      clear_neon_saturated();
      //  Expect: "result" = ffffffff000080b13f2bffff7fff7ee0
      result = vsubw_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x3f2bffff7fff7ee0);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0xffffffff000080b1);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_316() {

{
   {
      uint16x8_t arg1;
      uint8x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubw_u8\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 44764,IntegerVal 65535,IntegerVal 27124,IntegerVal 5209,IntegerVal 65535,IntegerVal 0,IntegerVal 32767,IntegerVal 65535],VectorVal [IntegerVal 32,IntegerVal 128,IntegerVal 128,IntegerVal 127,IntegerVal 0,IntegerVal 0,IntegerVal 128,IntegerVal 128]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x145969f4ffffaedc)),
                          vcreate_u16(UINT64_C(0xffff7fff0000ffff)));
      arg2 = vcreate_u8(UINT64_C(0x808000007f808020));
      clear_neon_saturated();
      //  Expect: "result" = ff7f7f7f0000ffff13da6974ff7faebc
      result = vsubw_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x13da6974ff7faebc);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0xff7f7f7f0000ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_317() {

{
   {
      uint32x4_t arg1;
      uint16x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubw_u16\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 2147450879,IntegerVal 2147483647,IntegerVal 2147516415,IntegerVal 65535],VectorVal [IntegerVal 9511,IntegerVal 32768,IntegerVal 32768,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x7fffffff7fff7fff)),
                          vcreate_u32(UINT64_C(0x0000ffff80007fff)));
      arg2 = vcreate_u16(UINT64_C(0x0000800080002527));
      clear_neon_saturated();
      //  Expect: "result" = 0000ffff7fffffff7fff7fff7fff5ad8
      result = vsubw_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x7fff7fff7fff5ad8);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0x0000ffff7fffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_318() {

{
   {
      uint64x2_t arg1;
      uint32x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubw_u32\", rettype = \"uint64x2_t\", argtypes = \"[uint64x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 463870763392663551,IntegerVal 18446462600880390143],VectorVal [IntegerVal 0,IntegerVal 4294944381]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0x0670000069b57fff)),
                          vcreate_u64(UINT64_C(0xffff00008000ffff)));
      arg2 = vcreate_u32(UINT64_C(0xffffa67d00000000));
      clear_neon_saturated();
      //  Expect: "result" = fffeffff800159820670000069b57fff
      result = vsubw_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0x0670000069b57fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0xfffeffff80015982);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_319() {

{
   {
      int16x8_t arg1;
      int8x16_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubw_high_s8\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int8x16_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal 32767,IntegerVal (-1),IntegerVal (-32768),IntegerVal (-32768),IntegerVal (-32768),IntegerVal (-1),IntegerVal 32767],VectorVal [IntegerVal 0,IntegerVal (-1),IntegerVal (-128),IntegerVal (-1),IntegerVal 127,IntegerVal (-54),IntegerVal 0,IntegerVal (-1),IntegerVal 39,IntegerVal 0,IntegerVal 0,IntegerVal (-87),IntegerVal (-1),IntegerVal (-1),IntegerVal (-128),IntegerVal 127]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x8000ffff7fffffff)),
                          vcreate_s16(UINT64_C(0x7fffffff80008000)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0xff00ca7fff80ff00)),
                         vcreate_s8(UINT64_C(0x7f80ffffa9000027)));
      clear_neon_saturated();
      //  Expect: "result" = 7f80007f800180018057ffff7fffffd8
      result = vsubw_high_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x8057ffff7fffffd8);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x7f80007f80018001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_320() {

{
   {
      int32x4_t arg1;
      int16x8_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubw_high_s16\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int16x8_t]\", vals = [VectorVal [IntegerVal (-52363264),IntegerVal (-2147428582),IntegerVal (-32768),IntegerVal 32768],VectorVal [IntegerVal (-20535),IntegerVal 32767,IntegerVal 0,IntegerVal 32767,IntegerVal 32767,IntegerVal 22927,IntegerVal (-1),IntegerVal 24388]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x8000d71afce10000)),
                          vcreate_s32(UINT64_C(0x00008000ffff8000)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x7fff00007fffafc9)),
                          vcreate_s16(UINT64_C(0x5f44ffff598f7fff)));
      clear_neon_saturated();
      //  Expect: "result" = 000020bcffff800180007d8bfce08001
      result = vsubw_high_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x80007d8bfce08001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x000020bcffff8001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_321() {

{
   {
      int64x2_t arg1;
      int32x4_t arg2;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubw_high_s32\", rettype = \"int64x2_t\", argtypes = \"[int64x2_t,int32x4_t]\", vals = [VectorVal [IntegerVal (-9223231301513838593),IntegerVal (-281472829284228)],VectorVal [IntegerVal 2147418112,IntegerVal 65535,IntegerVal (-2147450881),IntegerVal 2147483647]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x80007fff8000ffff)),
                          vcreate_s64(UINT64_C(0xffff00007fff207c)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x0000ffff7fff0000)),
                          vcreate_s32(UINT64_C(0x7fffffff80007fff)));
      clear_neon_saturated();
      //  Expect: "result" = fffeffffffff207d8000800000008000
      result = vsubw_high_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x8000800000008000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0xfffeffffffff207d);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_322() {

{
   {
      uint16x8_t arg1;
      uint8x16_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubw_high_u8\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 32768,IntegerVal 55834,IntegerVal 4593,IntegerVal 0,IntegerVal 0,IntegerVal 0,IntegerVal 32767],VectorVal [IntegerVal 255,IntegerVal 0,IntegerVal 100,IntegerVal 255,IntegerVal 255,IntegerVal 127,IntegerVal 128,IntegerVal 255,IntegerVal 255,IntegerVal 152,IntegerVal 128,IntegerVal 0,IntegerVal 128,IntegerVal 128,IntegerVal 255,IntegerVal 127]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x11f1da1a80007fff)),
                          vcreate_u16(UINT64_C(0x7fff000000000000)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0xff807fffff6400ff)),
                         vcreate_u8(UINT64_C(0x7fff8080008098ff)));
      clear_neon_saturated();
      //  Expect: "result" = 7f80ff01ff80ff8011f1d99a7f687f00
      result = vsubw_high_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x11f1d99a7f687f00);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x7f80ff01ff80ff80);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_323() {

{
   {
      uint32x4_t arg1;
      uint16x8_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubw_high_u16\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 4294967295,IntegerVal 2147450879,IntegerVal 2147516416,IntegerVal 4294934527],VectorVal [IntegerVal 37812,IntegerVal 0,IntegerVal 65535,IntegerVal 32768,IntegerVal 65535,IntegerVal 0,IntegerVal 0,IntegerVal 32768]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x7fff7fffffffffff)),
                          vcreate_u32(UINT64_C(0xffff7fff80008000)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0x8000ffff000093b4)),
                          vcreate_u16(UINT64_C(0x800000000000ffff)));
      clear_neon_saturated();
      //  Expect: "result" = fffeffff800080007fff7fffffff0000
      result = vsubw_high_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x7fff7fffffff0000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0xfffeffff80008000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_324() {

{
   {
      uint64x2_t arg1;
      uint32x4_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"sub\", fnname = \"vsubw_high_u32\", rettype = \"uint64x2_t\", argtypes = \"[uint64x2_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 9223372034707303286,IntegerVal 140739635806208],VectorVal [IntegerVal 2147549183,IntegerVal 4294934528,IntegerVal 4294934528,IntegerVal 47567]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0x7fffffff80002b76)),
                          vcreate_u64(UINT64_C(0x000080007fff8000)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0xffff80008000ffff)),
                          vcreate_u32(UINT64_C(0x0000b9cfffff8000)));
      clear_neon_saturated();
      //  Expect: "result" = 000080007ffec6317ffffffe8000ab76
      result = vsubw_high_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0x7ffffffe8000ab76);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0x000080007ffec631);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_325() {

{
   {
      int8x8_t arg1;
      int8x8_t arg2;
      int8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsub_s8\", rettype = \"int8x8_t\", argtypes = \"[int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal 0,IntegerVal (-128),IntegerVal 0,IntegerVal (-5),IntegerVal 127,IntegerVal (-1),IntegerVal (-1)],VectorVal [IntegerVal 127,IntegerVal (-1),IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal (-1),IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s8(UINT64_C(0xffff7ffb008000ff));
      arg2 = vcreate_s8(UINT64_C(0x00ff7f007f00ff7f));
      clear_neon_saturated();
      //  Expect: "result" = ff0000fb81800180
      result = vqsub_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s8(result), 0);
      exp = UINT64_C(0xff0000fb81800180);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_326() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      int16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsub_s16\", rettype = \"int16x4_t\", argtypes = \"[int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 0,IntegerVal (-1),IntegerVal (-32768)],VectorVal [IntegerVal (-1),IntegerVal (-4735),IntegerVal 17665,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s16(UINT64_C(0x8000ffff00000000));
      arg2 = vcreate_s16(UINT64_C(0x00004501ed81ffff));
      clear_neon_saturated();
      //  Expect: "result" = 8000bafe127f0001
      result = vqsub_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s16(result), 0);
      exp = UINT64_C(0x8000bafe127f0001);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_327() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      int32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsub_s32\", rettype = \"int32x2_t\", argtypes = \"[int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal 1513127935,IntegerVal (-1)],VectorVal [IntegerVal 1081,IntegerVal 14545]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s32(UINT64_C(0xffffffff5a307fff));
      arg2 = vcreate_s32(UINT64_C(0x000038d100000439));
      clear_neon_saturated();
      //  Expect: "result" = ffffc72e5a307bc6
      result = vqsub_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s32(result), 0);
      exp = UINT64_C(0xffffc72e5a307bc6);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_328() {

{
   {
      int64x1_t arg1;
      int64x1_t arg2;
      int64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsub_s64\", rettype = \"int64x1_t\", argtypes = \"[int64x1_t,int64x1_t]\", vals = [VectorVal [IntegerVal (-281472829227008)],VectorVal [IntegerVal 253431385718784]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s64(UINT64_C(0xffff000080000000));
      arg2 = vcreate_s64(UINT64_C(0x0000e67e97b88000));
      clear_neon_saturated();
      //  Expect: "result" = fffe1981e8478000
      result = vqsub_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s64(result), 0);
      exp = UINT64_C(0xfffe1981e8478000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_329() {

{
   {
      uint8x8_t arg1;
      uint8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsub_u8\", rettype = \"uint8x8_t\", argtypes = \"[uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 19,IntegerVal 255,IntegerVal 128,IntegerVal 127,IntegerVal 128,IntegerVal 128,IntegerVal 127,IntegerVal 128],VectorVal [IntegerVal 127,IntegerVal 255,IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal 127,IntegerVal 127]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u8(UINT64_C(0x807f80807f80ff13));
      arg2 = vcreate_u8(UINT64_C(0x7f7f7f007f00ff7f));
      clear_neon_saturated();
      //  Expect: "result" = 0100018000800000
      result = vqsub_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0x0100018000800000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_330() {

{
   {
      uint16x4_t arg1;
      uint16x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsub_u16\", rettype = \"uint16x4_t\", argtypes = \"[uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 61756,IntegerVal 65535,IntegerVal 32768,IntegerVal 32768],VectorVal [IntegerVal 0,IntegerVal 0,IntegerVal 65535,IntegerVal 43360]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u16(UINT64_C(0x80008000fffff13c));
      arg2 = vcreate_u16(UINT64_C(0xa960ffff00000000));
      clear_neon_saturated();
      //  Expect: "result" = 00000000fffff13c
      result = vqsub_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0x00000000fffff13c);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_331() {

{
   {
      uint32x2_t arg1;
      uint32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsub_u32\", rettype = \"uint32x2_t\", argtypes = \"[uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 2147450880,IntegerVal 2147450879],VectorVal [IntegerVal 32768,IntegerVal 19517]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u32(UINT64_C(0x7fff7fff7fff8000));
      arg2 = vcreate_u32(UINT64_C(0x00004c3d00008000));
      clear_neon_saturated();
      //  Expect: "result" = 7fff33c27fff0000
      result = vqsub_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0x7fff33c27fff0000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_332() {

{
   {
      uint64x1_t arg1;
      uint64x1_t arg2;
      uint64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsub_u64\", rettype = \"uint64x1_t\", argtypes = \"[uint64x1_t,uint64x1_t]\", vals = [VectorVal [IntegerVal 2073001983],VectorVal [IntegerVal 18446691675108474880]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u64(UINT64_C(0x000000007b8f7fff));
      arg2 = vcreate_u64(UINT64_C(0xffffd057ffff0000));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vqsub_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(result, 0);
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_333() {

{
   {
      int8x16_t arg1;
      int8x16_t arg2;
      int8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsubq_s8\", rettype = \"int8x16_t\", argtypes = \"[int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal (-1),IntegerVal (-125),IntegerVal (-1),IntegerVal 19,IntegerVal 116,IntegerVal 121,IntegerVal 96,IntegerVal (-1),IntegerVal 127,IntegerVal 0,IntegerVal (-47),IntegerVal 0,IntegerVal (-1),IntegerVal 0,IntegerVal (-1)],VectorVal [IntegerVal 127,IntegerVal 84,IntegerVal 127,IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal (-128),IntegerVal 0,IntegerVal 0,IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal (-128),IntegerVal 127,IntegerVal (-51)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s8(vcreate_s8(UINT64_C(0x60797413ff83ffff)),
                         vcreate_s8(UINT64_C(0xff00ff00d1007fff)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0x00807f007f7f547f)),
                         vcreate_s8(UINT64_C(0xcd7f807f007f0000)));
      clear_neon_saturated();
      //  Expect: "result" = 32817f81d1817fff607ff5138080ab80
      result = vqsubq_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 0);
         exp = UINT64_C(0x607ff5138080ab80);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 1);
         exp = UINT64_C(0x32817f81d1817fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_334() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsubq_s16\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal (-32768),IntegerVal 0,IntegerVal (-1),IntegerVal (-32768),IntegerVal 32767,IntegerVal 0,IntegerVal 14146],VectorVal [IntegerVal 25741,IntegerVal (-32768),IntegerVal (-1),IntegerVal 21103,IntegerVal (-1),IntegerVal 32767,IntegerVal 0,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0xffff00008000ffff)),
                          vcreate_s16(UINT64_C(0x374200007fff8000)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x526fffff8000648d)),
                          vcreate_s16(UINT64_C(0x000000007fffffff)));
      clear_neon_saturated();
      //  Expect: "result" = 3742000000008001ad90000100009b72
      result = vqsubq_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0xad90000100009b72);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x3742000000008001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_335() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsubq_s32\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal (-1800273920),IntegerVal 65535,IntegerVal (-32768),IntegerVal (-727810049)],VectorVal [IntegerVal (-1670971392),IntegerVal (-1),IntegerVal (-32768),IntegerVal 26116]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x0000ffff94b20000)),
                          vcreate_s32(UINT64_C(0xd49e7fffffff8000)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0xffffffff9c670000)),
                          vcreate_s32(UINT64_C(0x00006604ffff8000)));
      clear_neon_saturated();
      //  Expect: "result" = d49e19fb0000000000010000f84b0000
      result = vqsubq_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x00010000f84b0000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0xd49e19fb00000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_336() {

{
   {
      int64x2_t arg1;
      int64x2_t arg2;
      int64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsubq_s64\", rettype = \"int64x2_t\", argtypes = \"[int64x2_t,int64x2_t]\", vals = [VectorVal [IntegerVal 9223090565880741888,IntegerVal (-9223090564121670708)],VectorVal [IntegerVal 140739635838976,IntegerVal (-9223231297218966286)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x7fff0000ee940000)),
                          vcreate_s64(UINT64_C(0x8000ffff7a454bcc)));
      arg2 = vcombine_s64(vcreate_s64(UINT64_C(0x0000800080000000)),
                          vcreate_s64(UINT64_C(0x800080007fff8cf2)));
      clear_neon_saturated();
      //  Expect: "result" = 00007ffefa45beda7ffe80006e940000
      result = vqsubq_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 0);
         exp = UINT64_C(0x7ffe80006e940000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s64(result), 1);
         exp = UINT64_C(0x00007ffefa45beda);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_337() {

{
   {
      uint8x16_t arg1;
      uint8x16_t arg2;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsubq_u8\", rettype = \"uint8x16_t\", argtypes = \"[uint8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal 65,IntegerVal 0,IntegerVal 128,IntegerVal 0,IntegerVal 0,IntegerVal 128,IntegerVal 127,IntegerVal 127,IntegerVal 114,IntegerVal 127,IntegerVal 0,IntegerVal 14],VectorVal [IntegerVal 255,IntegerVal 0,IntegerVal 128,IntegerVal 127,IntegerVal 0,IntegerVal 255,IntegerVal 128,IntegerVal 90,IntegerVal 128,IntegerVal 255,IntegerVal 127,IntegerVal 128,IntegerVal 128,IntegerVal 172,IntegerVal 255,IntegerVal 176]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u8(vcreate_u8(UINT64_C(0x00800041007f007f)),
                         vcreate_u8(UINT64_C(0x0e007f727f7f8000)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0x5a80ff007f8000ff)),
                         vcreate_u8(UINT64_C(0xb0ffac80807fff80)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000000000000000004100000000
      result = vqsubq_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x0000004100000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_338() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsubq_u16\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 65535,IntegerVal 32768,IntegerVal 65535,IntegerVal 32767,IntegerVal 65535,IntegerVal 65535,IntegerVal 0],VectorVal [IntegerVal 29915,IntegerVal 0,IntegerVal 32767,IntegerVal 0,IntegerVal 0,IntegerVal 62072,IntegerVal 65535,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0xffff8000ffff0000)),
                          vcreate_u16(UINT64_C(0x0000ffffffff7fff)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0x00007fff000074db)),
                          vcreate_u16(UINT64_C(0x0000fffff2780000)));
      clear_neon_saturated();
      //  Expect: "result" = 000000000d877fffffff0001ffff0000
      result = vqsubq_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0xffff0001ffff0000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x000000000d877fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_339() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsubq_u32\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 2147450880,IntegerVal 2147483648,IntegerVal 4294964763,IntegerVal 22159],VectorVal [IntegerVal 2147498796,IntegerVal 4294909770,IntegerVal 32767,IntegerVal 1556742143]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x800000007fff8000)),
                          vcreate_u32(UINT64_C(0x0000568ffffff61b)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0xffff1f4a80003b2c)),
                          vcreate_u32(UINT64_C(0x5cc9ffff00007fff)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000ffff761c0000000000000000
      result = vqsubq_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0x00000000ffff761c);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_340() {

{
   {
      uint64x2_t arg1;
      uint64x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsubq_u64\", rettype = \"uint64x2_t\", argtypes = \"[uint64x2_t,uint64x2_t]\", vals = [VectorVal [IntegerVal 2147450879,IntegerVal 18446603338368745471],VectorVal [IntegerVal 4206362051964048524,IntegerVal 9223559074090614784]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0x000000007fff7fff)),
                          vcreate_u64(UINT64_C(0xffff80008000ffff)));
      arg2 = vcombine_u64(vcreate_u64(UINT64_C(0x3a6000000000148c)),
                          vcreate_u64(UINT64_C(0x8000aa1c00008000)));
      clear_neon_saturated();
      //  Expect: "result" = 7ffed5e480007fff0000000000000000
      result = vqsubq_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0x7ffed5e480007fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_341() {

{
   {
      int8_t arg1;
      int8_t arg2;
      int8_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsubb_s8\", rettype = \"int8_t\", argtypes = \"[int8_t,int8_t]\", vals = [IntegerVal (-1),IntegerVal 0], start_saturated = False}";
      int reported = 0;
      int8_t got;
      int8_t exp;
      arg1 = -1;
      arg2 = 0;
      clear_neon_saturated();
      //  Expect: "result" = ff
      result = vqsubb_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = -1;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi8 " Got: %" PRIi8 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_342() {

{
   {
      int16_t arg1;
      int16_t arg2;
      int16_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsubh_s16\", rettype = \"int16_t\", argtypes = \"[int16_t,int16_t]\", vals = [IntegerVal (-3799),IntegerVal (-1)], start_saturated = False}";
      int reported = 0;
      int16_t got;
      int16_t exp;
      arg1 = -3799;
      arg2 = -1;
      clear_neon_saturated();
      //  Expect: "result" = f12a
      result = vqsubh_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = -3798;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi16 " Got: %" PRIi16 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_343() {

{
   {
      int32_t arg1;
      int32_t arg2;
      int32_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsubs_s32\", rettype = \"int32_t\", argtypes = \"[int32_t,int32_t]\", vals = [IntegerVal (-1),IntegerVal (-32768)], start_saturated = False}";
      int reported = 0;
      int32_t got;
      int32_t exp;
      arg1 = -1;
      arg2 = -32768;
      clear_neon_saturated();
      //  Expect: "result" = 00007fff
      result = vqsubs_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 32767;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi32 " Got: %" PRIi32 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_344() {

{
   {
      int64_t arg1;
      int64_t arg2;
      int64_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsubd_s64\", rettype = \"int64_t\", argtypes = \"[int64_t,int64_t]\", vals = [IntegerVal (-9223341757335306240),IntegerVal (-140739635838976)], start_saturated = False}";
      int reported = 0;
      int64_t got;
      int64_t exp;
      arg1 = INT64_C(-9223341757335306240);
      arg2 = INT64_C(-140739635838976);
      clear_neon_saturated();
      //  Expect: "result" = 80009b8a80008000
      result = vqsubd_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = INT64_C(-9223201017699467264);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIi64 " Got: %" PRIi64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_345() {

{
   {
      uint8_t arg1;
      uint8_t arg2;
      uint8_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsubb_u8\", rettype = \"uint8_t\", argtypes = \"[uint8_t,uint8_t]\", vals = [IntegerVal 0,IntegerVal 0], start_saturated = False}";
      int reported = 0;
      uint8_t got;
      uint8_t exp;
      arg1 = 0;
      arg2 = 0;
      clear_neon_saturated();
      //  Expect: "result" = 00
      result = vqsubb_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIu8 " Got: %" PRIu8 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_346() {

{
   {
      uint16_t arg1;
      uint16_t arg2;
      uint16_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsubh_u16\", rettype = \"uint16_t\", argtypes = \"[uint16_t,uint16_t]\", vals = [IntegerVal 65535,IntegerVal 32767], start_saturated = False}";
      int reported = 0;
      uint16_t got;
      uint16_t exp;
      arg1 = 65535U;
      arg2 = 32767U;
      clear_neon_saturated();
      //  Expect: "result" = 8000
      result = vqsubh_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 32768U;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIu16 " Got: %" PRIu16 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_347() {

{
   {
      uint32_t arg1;
      uint32_t arg2;
      uint32_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsubs_u32\", rettype = \"uint32_t\", argtypes = \"[uint32_t,uint32_t]\", vals = [IntegerVal 2147450880,IntegerVal 2147450880], start_saturated = False}";
      int reported = 0;
      uint32_t got;
      uint32_t exp;
      arg1 = 2147450880U;
      arg2 = 2147450880U;
      clear_neon_saturated();
      //  Expect: "result" = 00000000
      result = vqsubs_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIu32 " Got: %" PRIu32 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_348() {

{
   {
      uint64_t arg1;
      uint64_t arg2;
      uint64_t result;
      char* str1 = "ReproInfo2 {semantics = \"saturating_sub\", fnname = \"vqsubd_u64\", rettype = \"uint64_t\", argtypes = \"[uint64_t,uint64_t]\", vals = [IntegerVal 9223433268055971537,IntegerVal 9223512770114781183], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = UINT64_C(0x800037b07fff16d1);
      arg2 = UINT64_C(0x80007fff03f87fff);
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vqsubd_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = result;
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_349() {

{
   {
      int8x8_t arg1;
      int8x8_t arg2;
      int8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_sub\", fnname = \"vhsub_s8\", rettype = \"int8x8_t\", argtypes = \"[int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 105,IntegerVal (-94),IntegerVal (-128),IntegerVal (-45),IntegerVal 0,IntegerVal 127,IntegerVal (-12)],VectorVal [IntegerVal 0,IntegerVal 0,IntegerVal (-1),IntegerVal (-1),IntegerVal (-128),IntegerVal 127,IntegerVal 127,IntegerVal (-128)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s8(UINT64_C(0xf47f00d380a26900));
      arg2 = vcreate_s8(UINT64_C(0x807f7f80ffff0000));
      clear_neon_saturated();
      //  Expect: "result" = 3a00c029c0d13400
      result = vhsub_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s8(result), 0);
      exp = UINT64_C(0x3a00c029c0d13400);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_350() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      int16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_sub\", fnname = \"vhsub_s16\", rettype = \"int16x4_t\", argtypes = \"[int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal (-32768),IntegerVal (-1),IntegerVal 32767,IntegerVal 32767],VectorVal [IntegerVal (-32768),IntegerVal (-32768),IntegerVal (-32768),IntegerVal 13667]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s16(UINT64_C(0x7fff7fffffff8000));
      arg2 = vcreate_s16(UINT64_C(0x3563800080008000));
      clear_neon_saturated();
      //  Expect: "result" = 254e7fff3fff0000
      result = vhsub_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s16(result), 0);
      exp = UINT64_C(0x254e7fff3fff0000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_351() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      int32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_sub\", fnname = \"vhsub_s32\", rettype = \"int32x2_t\", argtypes = \"[int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal (-32769),IntegerVal (-1914601472)],VectorVal [IntegerVal 1878196224,IntegerVal 2084024778]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s32(UINT64_C(0x8de18000ffff7fff));
      arg2 = vcreate_s32(UINT64_C(0x7c37b1ca6ff30000));
      clear_neon_saturated();
      //  Expect: "result" = 88d4e71bc8063fff
      result = vhsub_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s32(result), 0);
      exp = UINT64_C(0x88d4e71bc8063fff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_352() {

{
   {
      uint8x8_t arg1;
      uint8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_sub\", fnname = \"vhsub_u8\", rettype = \"uint8x8_t\", argtypes = \"[uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 127,IntegerVal 0,IntegerVal 224,IntegerVal 128,IntegerVal 127,IntegerVal 255,IntegerVal 255,IntegerVal 127],VectorVal [IntegerVal 255,IntegerVal 0,IntegerVal 128,IntegerVal 177,IntegerVal 253,IntegerVal 255,IntegerVal 16,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u8(UINT64_C(0x7fffff7f80e0007f));
      arg2 = vcreate_u8(UINT64_C(0x0010fffdb18000ff));
      clear_neon_saturated();
      //  Expect: "result" = 3f7700c1e73000c0
      result = vhsub_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0x3f7700c1e73000c0);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_353() {

{
   {
      uint16x4_t arg1;
      uint16x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_sub\", fnname = \"vhsub_u16\", rettype = \"uint16x4_t\", argtypes = \"[uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 32768,IntegerVal 32768,IntegerVal 0,IntegerVal 32975],VectorVal [IntegerVal 0,IntegerVal 32767,IntegerVal 32768,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u16(UINT64_C(0x80cf000080008000));
      arg2 = vcreate_u16(UINT64_C(0x000080007fff0000));
      clear_neon_saturated();
      //  Expect: "result" = 4067c00000004000
      result = vhsub_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0x4067c00000004000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_354() {

{
   {
      uint32x2_t arg1;
      uint32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_sub\", fnname = \"vhsub_u32\", rettype = \"uint32x2_t\", argtypes = \"[uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 2147516415,IntegerVal 0],VectorVal [IntegerVal 2147517250,IntegerVal 2147516415]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u32(UINT64_C(0x0000000080007fff));
      arg2 = vcreate_u32(UINT64_C(0x80007fff80008342));
      clear_neon_saturated();
      //  Expect: "result" = bfffc000fffffe5e
      result = vhsub_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0xbfffc000fffffe5e);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_355() {

{
   {
      int8x16_t arg1;
      int8x16_t arg2;
      int8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_sub\", fnname = \"vhsubq_s8\", rettype = \"int8x16_t\", argtypes = \"[int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal 127,IntegerVal (-128),IntegerVal (-128),IntegerVal (-128),IntegerVal 0,IntegerVal (-1),IntegerVal (-71),IntegerVal (-128),IntegerVal 127,IntegerVal (-1),IntegerVal 0,IntegerVal (-128),IntegerVal (-128),IntegerVal (-1),IntegerVal (-128),IntegerVal (-128)],VectorVal [IntegerVal (-128),IntegerVal (-104),IntegerVal 66,IntegerVal (-128),IntegerVal 127,IntegerVal (-1),IntegerVal 127,IntegerVal 127,IntegerVal (-1),IntegerVal (-15),IntegerVal (-128),IntegerVal 0,IntegerVal (-128),IntegerVal (-33),IntegerVal (-1),IntegerVal 30]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s8(vcreate_s8(UINT64_C(0x80b9ff008080807f)),
                         vcreate_s8(UINT64_C(0x8080ff808000ff7f)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0x7f7fff7f80429880)),
                         vcreate_s8(UINT64_C(0x1effdf800080f1ff)));
      clear_neon_saturated();
      //  Expect: "result" = b1c01000c0400740809d00c0009ff47f
      result = vhsubq_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 0);
         exp = UINT64_C(0x809d00c0009ff47f);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 1);
         exp = UINT64_C(0xb1c01000c0400740);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_356() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_sub\", fnname = \"vhsubq_s16\", rettype = \"int16x8_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal (-10037),IntegerVal (-1),IntegerVal 32767,IntegerVal (-32768),IntegerVal 32767,IntegerVal (-32768),IntegerVal 30989],VectorVal [IntegerVal (-1),IntegerVal 32767,IntegerVal (-2198),IntegerVal 0,IntegerVal (-32768),IntegerVal 32767,IntegerVal 0,IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x7fffffffd8cbffff)),
                          vcreate_s16(UINT64_C(0x790d80007fff8000)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x0000f76a7fffffff)),
                          vcreate_s16(UINT64_C(0xffff00007fff8000)));
      clear_neon_saturated();
      //  Expect: "result" = 3c87c000000000003fff044aac660000
      result = vhsubq_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x3fff044aac660000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x3c87c00000000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_357() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_sub\", fnname = \"vhsubq_s32\", rettype = \"int32x4_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal 6939,IntegerVal (-35425),IntegerVal (-65536),IntegerVal 2147450880],VectorVal [IntegerVal (-2147450880),IntegerVal 65535,IntegerVal 65535,IntegerVal (-2147483648)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0xffff759f00001b1b)),
                          vcreate_s32(UINT64_C(0x7fff8000ffff0000)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x0000ffff80008000)),
                          vcreate_s32(UINT64_C(0x800000000000ffff)));
      clear_neon_saturated();
      //  Expect: "result" = 7fffc000ffff0000ffff3ad03fffcd8d
      result = vhsubq_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0xffff3ad03fffcd8d);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x7fffc000ffff0000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_358() {

{
   {
      uint8x16_t arg1;
      uint8x16_t arg2;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_sub\", fnname = \"vhsubq_u8\", rettype = \"uint8x16_t\", argtypes = \"[uint8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 222,IntegerVal 128,IntegerVal 127,IntegerVal 128,IntegerVal 253,IntegerVal 106,IntegerVal 127,IntegerVal 128,IntegerVal 0,IntegerVal 255,IntegerVal 127,IntegerVal 128,IntegerVal 255,IntegerVal 37,IntegerVal 0,IntegerVal 0],VectorVal [IntegerVal 127,IntegerVal 127,IntegerVal 180,IntegerVal 112,IntegerVal 255,IntegerVal 128,IntegerVal 0,IntegerVal 99,IntegerVal 128,IntegerVal 253,IntegerVal 127,IntegerVal 128,IntegerVal 128,IntegerVal 255,IntegerVal 0,IntegerVal 128]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u8(vcreate_u8(UINT64_C(0x807f6afd807f80de)),
                         vcreate_u8(UINT64_C(0x000025ff807fff00)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0x630080ff70b47f7f)),
                         vcreate_u8(UINT64_C(0x8000ff80807ffd80)));
      clear_neon_saturated();
      //  Expect: "result" = c000933f000001c00e3ff5ff08e5002f
      result = vhsubq_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x0e3ff5ff08e5002f);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0xc000933f000001c0);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_359() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_sub\", fnname = \"vhsubq_u16\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 65535,IntegerVal 65535,IntegerVal 65535,IntegerVal 65535,IntegerVal 0,IntegerVal 32768,IntegerVal 65535],VectorVal [IntegerVal 32768,IntegerVal 0,IntegerVal 65535,IntegerVal 0,IntegerVal 32768,IntegerVal 2925,IntegerVal 32767,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0xffffffffffff0000)),
                          vcreate_u16(UINT64_C(0xffff80000000ffff)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0x0000ffff00008000)),
                          vcreate_u16(UINT64_C(0x00007fff0b6d8000)));
      clear_neon_saturated();
      //  Expect: "result" = 7fff0000fa493fff7fff00007fffc000
      result = vhsubq_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x7fff00007fffc000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x7fff0000fa493fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_360() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"halving_sub\", fnname = \"vhsubq_u32\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 2147483648,IntegerVal 65535,IntegerVal 2147428255,IntegerVal 2147549183],VectorVal [IntegerVal 2147525836,IntegerVal 2824667136,IntegerVal 2147418112,IntegerVal 728104959]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x0000ffff80000000)),
                          vcreate_u32(UINT64_C(0x8000ffff7fff279f)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0xa85d00008000a4cc)),
                          vcreate_u32(UINT64_C(0x2b65ffff7fff0000)));
      clear_neon_saturated();
      //  Expect: "result" = 2a4d8000000013cfabd1ffffffffad9a
      result = vhsubq_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0xabd1ffffffffad9a);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0x2a4d8000000013cf);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_361() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_sub\", fnname = \"vsubhn_s16\", rettype = \"int8x8_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal (-1),IntegerVal 32767,IntegerVal 32767,IntegerVal (-32768),IntegerVal 0,IntegerVal (-32768),IntegerVal 0],VectorVal [IntegerVal 0,IntegerVal 32767,IntegerVal (-1),IntegerVal (-32768),IntegerVal (-26367),IntegerVal (-32768),IntegerVal (-1),IntegerVal (-32768)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x7fff7fffffff7fff)),
                          vcreate_s16(UINT64_C(0x0000800000008000)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x8000ffff7fff0000)),
                          vcreate_s16(UINT64_C(0x8000ffff80009901)));
      clear_neon_saturated();
      //  Expect: "result" = 808080e6ff80807f
      result = vsubhn_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s8(result), 0);
      exp = UINT64_C(0x808080e6ff80807f);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_362() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_sub\", fnname = \"vsubhn_s32\", rettype = \"int16x4_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal (-2147483648),IntegerVal (-1544814593),IntegerVal 61243391,IntegerVal (-65536)],VectorVal [IntegerVal 29416,IntegerVal 1273167872,IntegerVal 65535,IntegerVal 1129644032]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0xa3ebffff80000000)),
                          vcreate_s32(UINT64_C(0xffff000003a67fff)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x4be30000000072e8)),
                          vcreate_s32(UINT64_C(0x435500000000ffff)));
      clear_neon_saturated();
      //  Expect: "result" = bcaa03a558087fff
      result = vsubhn_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s16(result), 0);
      exp = UINT64_C(0xbcaa03a558087fff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_363() {

{
   {
      int64x2_t arg1;
      int64x2_t arg2;
      int32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_sub\", fnname = \"vsubhn_s64\", rettype = \"int32x2_t\", argtypes = \"[int64x2_t,int64x2_t]\", vals = [VectorVal [IntegerVal 281470681783027,IntegerVal 2824460651655593983],VectorVal [IntegerVal 9223231300677337088,IntegerVal 9223372032559841279]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x0000ffff00009af3)),
                          vcreate_s64(UINT64_C(0x27327fff7fffffff)));
      arg2 = vcombine_s64(vcreate_s64(UINT64_C(0x7fff80004e230000)),
                          vcreate_s64(UINT64_C(0x7fffffff00007fff)));
      clear_neon_saturated();
      //  Expect: "result" = a732800080017ffe
      result = vsubhn_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s32(result), 0);
      exp = UINT64_C(0xa732800080017ffe);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_364() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_sub\", fnname = \"vsubhn_u16\", rettype = \"uint8x8_t\", argtypes = \"[uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 65535,IntegerVal 0,IntegerVal 65535,IntegerVal 0,IntegerVal 65535,IntegerVal 0,IntegerVal 32767,IntegerVal 32767],VectorVal [IntegerVal 0,IntegerVal 65535,IntegerVal 14549,IntegerVal 65535,IntegerVal 32768,IntegerVal 32768,IntegerVal 65535,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x0000ffff0000ffff)),
                          vcreate_u16(UINT64_C(0x7fff7fff0000ffff)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0xffff38d5ffff0000)),
                          vcreate_u16(UINT64_C(0x0000ffff80008000)));
      clear_neon_saturated();
      //  Expect: "result" = 7f80807f00c700ff
      result = vsubhn_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0x7f80807f00c700ff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_365() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_sub\", fnname = \"vsubhn_u32\", rettype = \"uint16x4_t\", argtypes = \"[uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 2147507352,IntegerVal 4294934528,IntegerVal 54648],VectorVal [IntegerVal 4294967295,IntegerVal 2147473191,IntegerVal 47248,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x80005c9800007fff)),
                          vcreate_u32(UINT64_C(0x0000d578ffff8000)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x7fffd727ffffffff)),
                          vcreate_u32(UINT64_C(0x00007fff0000b890)));
      clear_neon_saturated();
      //  Expect: "result" = 0000fffe00000000
      result = vsubhn_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0x0000fffe00000000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_366() {

{
   {
      uint64x2_t arg1;
      uint64x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_sub\", fnname = \"vsubhn_u64\", rettype = \"uint32x2_t\", argtypes = \"[uint64x2_t,uint64x2_t]\", vals = [VectorVal [IntegerVal 18446603340516150911,IntegerVal 18446603331926294527],VectorVal [IntegerVal 9223231297218936831,IntegerVal 7099361858301233593]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0xffff8000ffffce7f)),
                          vcreate_u64(UINT64_C(0xffff7fff0000ffff)));
      arg2 = vcombine_u64(vcreate_u64(UINT64_C(0x7fff7fff7fffffff)),
                          vcreate_u64(UINT64_C(0x6285ffff000089b9)));
      clear_neon_saturated();
      //  Expect: "result" = 9d79800080000001
      result = vsubhn_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0x9d79800080000001);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_367() {

{
   {
      int8x8_t arg1;
      int16x8_t arg2;
      int16x8_t arg3;
      int8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_sub\", fnname = \"vsubhn_high_s16\", rettype = \"int8x16_t\", argtypes = \"[int8x8_t,int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 127,IntegerVal (-128),IntegerVal (-128),IntegerVal 127,IntegerVal 0,IntegerVal (-1),IntegerVal (-1)],VectorVal [IntegerVal 32767,IntegerVal (-32768),IntegerVal 32767,IntegerVal 0,IntegerVal 0,IntegerVal (-904),IntegerVal 32767,IntegerVal 0],VectorVal [IntegerVal 11399,IntegerVal 0,IntegerVal (-32768),IntegerVal (-20507),IntegerVal 32767,IntegerVal 0,IntegerVal 0,IntegerVal (-1)]], start_saturated = True}";
      int reported = 0;
      arg1 = vcreate_s8(UINT64_C(0xffff007f80807f00));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x00007fff80007fff)),
                          vcreate_s16(UINT64_C(0x00007ffffc780000)));
      arg3 = vcombine_s16(vcreate_s16(UINT64_C(0xafe5800000002c87)),
                          vcreate_s16(UINT64_C(0xffff000000007fff)));
      set_neon_saturated();
      //  Expect: "result" = 007ffc8050ff8053ffff007f80807f00
      result = vsubhn_high_s16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 0);
         exp = UINT64_C(0xffff007f80807f00);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 1);
         exp = UINT64_C(0x007ffc8050ff8053);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_368() {

{
   {
      int16x4_t arg1;
      int32x4_t arg2;
      int32x4_t arg3;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_sub\", fnname = \"vsubhn_high_s32\", rettype = \"int16x8_t\", argtypes = \"[int16x4_t,int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal (-1),IntegerVal (-28850),IntegerVal 32767],VectorVal [IntegerVal 32768,IntegerVal (-65536),IntegerVal (-2147483648),IntegerVal 2147418112],VectorVal [IntegerVal (-1),IntegerVal (-1894350849),IntegerVal 65535,IntegerVal (-2147450881)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s16(UINT64_C(0x7fff8f4effff0000));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0xffff000000008000)),
                          vcreate_s32(UINT64_C(0x7fff000080000000)));
      arg3 = vcombine_s32(vcreate_s32(UINT64_C(0x8f167fffffffffff)),
                          vcreate_s32(UINT64_C(0x80007fff0000ffff)));
      clear_neon_saturated();
      //  Expect: "result" = fffe7fff70e800007fff8f4effff0000
      result = vsubhn_high_s32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x7fff8f4effff0000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0xfffe7fff70e80000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_369() {

{
   {
      int32x2_t arg1;
      int64x2_t arg2;
      int64x2_t arg3;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_sub\", fnname = \"vsubhn_high_s64\", rettype = \"int32x4_t\", argtypes = \"[int32x2_t,int64x2_t,int64x2_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal (-2147436867)],VectorVal [IntegerVal 9223231303661355008,IntegerVal 1041739157241561088],VectorVal [IntegerVal (-3674937293259997185),IntegerVal 9223231299366453247]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s32(UINT64_C(0x8000b6bd00007fff));
      arg2 = vcombine_s64(vcreate_s64(UINT64_C(0x7fff8000ffff8000)),
                          vcreate_s64(UINT64_C(0x0e75003e7fff8000)));
      arg3 = vcombine_s64(vcreate_s64(UINT64_C(0xcd0000009f66ffff)),
                          vcreate_s64(UINT64_C(0x7fff800000007fff)));
      clear_neon_saturated();
      //  Expect: "result" = 8e75803eb2ff80008000b6bd00007fff
      result = vsubhn_high_s64(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x8000b6bd00007fff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0x8e75803eb2ff8000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_370() {

{
   {
      uint8x8_t arg1;
      uint16x8_t arg2;
      uint16x8_t arg3;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_sub\", fnname = \"vsubhn_high_u16\", rettype = \"uint8x16_t\", argtypes = \"[uint8x8_t,uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 128,IntegerVal 128,IntegerVal 247,IntegerVal 255,IntegerVal 191,IntegerVal 255,IntegerVal 127,IntegerVal 127],VectorVal [IntegerVal 65535,IntegerVal 32767,IntegerVal 32768,IntegerVal 65535,IntegerVal 13333,IntegerVal 48276,IntegerVal 32767,IntegerVal 21025],VectorVal [IntegerVal 65535,IntegerVal 65535,IntegerVal 46858,IntegerVal 0,IntegerVal 65535,IntegerVal 32768,IntegerVal 32768,IntegerVal 44825]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u8(UINT64_C(0x7f7fffbffff78080));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0xffff80007fffffff)),
                          vcreate_u16(UINT64_C(0x52217fffbc943415)));
      arg3 = vcombine_u16(vcreate_u16(UINT64_C(0x0000b70affffffff)),
                          vcreate_u16(UINT64_C(0xaf1980008000ffff)));
      clear_neon_saturated();
      //  Expect: "result" = a3ff3c34ffc880007f7fffbffff78080
      result = vsubhn_high_u16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x7f7fffbffff78080);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0xa3ff3c34ffc88000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_371() {

{
   {
      uint16x4_t arg1;
      uint32x4_t arg2;
      uint32x4_t arg3;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_sub\", fnname = \"vsubhn_high_u32\", rettype = \"uint16x8_t\", argtypes = \"[uint16x4_t,uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 32768,IntegerVal 23159,IntegerVal 65535,IntegerVal 32767],VectorVal [IntegerVal 2147443466,IntegerVal 421330943,IntegerVal 2147418112,IntegerVal 4294934527],VectorVal [IntegerVal 2147450879,IntegerVal 65535,IntegerVal 2147516416,IntegerVal 4294901760]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u16(UINT64_C(0x7fffffff5a778000));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x191cffff7fff630a)),
                          vcreate_u32(UINT64_C(0xffff7fff7fff0000)));
      arg3 = vcombine_u32(vcreate_u32(UINT64_C(0x0000ffff7fff7fff)),
                          vcreate_u32(UINT64_C(0xffff000080008000)));
      clear_neon_saturated();
      //  Expect: "result" = 0000fffe191cffff7fffffff5a778000
      result = vsubhn_high_u32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x7fffffff5a778000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x0000fffe191cffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_372() {

{
   {
      uint32x2_t arg1;
      uint64x2_t arg2;
      uint64x2_t arg3;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"highhalf_sub\", fnname = \"vsubhn_high_u64\", rettype = \"uint32x4_t\", argtypes = \"[uint32x2_t,uint64x2_t,uint64x2_t]\", vals = [VectorVal [IntegerVal 2147549183,IntegerVal 65535],VectorVal [IntegerVal 18446462602652909568,IntegerVal 9223372032559862725],VectorVal [IntegerVal 9223144049253253119,IntegerVal 281472829269646]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u32(UINT64_C(0x0000ffff8000ffff));
      arg2 = vcombine_u64(vcreate_u64(UINT64_C(0xffff0000e9a78000)),
                          vcreate_u64(UINT64_C(0x7fffffff0000d3c5)));
      arg3 = vcombine_u64(vcreate_u64(UINT64_C(0x7fff30a57fff7fff)),
                          vcreate_u64(UINT64_C(0x0000ffff8000a68e)));
      clear_neon_saturated();
      //  Expect: "result" = 7ffeffff7fffcf5b0000ffff8000ffff
      result = vsubhn_high_u64(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0x0000ffff8000ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0x7ffeffff7fffcf5b);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_373() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      int8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_sub\", fnname = \"vrsubhn_s16\", rettype = \"int8x8_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal (-32768),IntegerVal 20630,IntegerVal 32767,IntegerVal (-24445),IntegerVal 0,IntegerVal (-32768),IntegerVal (-1),IntegerVal 0],VectorVal [IntegerVal (-1),IntegerVal 16076,IntegerVal 0,IntegerVal (-32768),IntegerVal 2017,IntegerVal 0,IntegerVal 32767,IntegerVal (-14741)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0xa0837fff50968000)),
                          vcreate_s16(UINT64_C(0x0000ffff80000000)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0x800000003eccffff)),
                          vcreate_s16(UINT64_C(0xc66b7fff000007e1)));
      clear_neon_saturated();
      //  Expect: "result" = 3a8080f821801280
      result = vrsubhn_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s8(result), 0);
      exp = UINT64_C(0x3a8080f821801280);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_374() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      int16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_sub\", fnname = \"vrsubhn_s32\", rettype = \"int16x4_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal (-65536),IntegerVal (-2147418113),IntegerVal 0],VectorVal [IntegerVal 2147450879,IntegerVal 65535,IntegerVal (-65536),IntegerVal (-32768)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0xffff000000000000)),
                          vcreate_s32(UINT64_C(0x000000008000ffff)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x0000ffff7fff7fff)),
                          vcreate_s32(UINT64_C(0xffff8000ffff0000)));
      clear_neon_saturated();
      //  Expect: "result" = 00018002fffe8001
      result = vrsubhn_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s16(result), 0);
      exp = UINT64_C(0x00018002fffe8001);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_375() {

{
   {
      int64x2_t arg1;
      int64x2_t arg2;
      int32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_sub\", fnname = \"vrsubhn_s64\", rettype = \"int32x2_t\", argtypes = \"[int64x2_t,int64x2_t]\", vals = [VectorVal [IntegerVal 1798906576157802496,IntegerVal (-9223231297218904064)],VectorVal [IntegerVal (-1558949160659517440),IntegerVal (-9223229946451755009)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x18f7000000000000)),
                          vcreate_s64(UINT64_C(0x8000800080008000)));
      arg2 = vcombine_s64(vcreate_s64(UINT64_C(0xea5d7fff7fff0000)),
                          vcreate_s64(UINT64_C(0x8000813affff7fff)));
      clear_neon_saturated();
      //  Expect: "result" = fffffec62e998001
      result = vrsubhn_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_s32(result), 0);
      exp = UINT64_C(0xfffffec62e998001);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_376() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_sub\", fnname = \"vrsubhn_u16\", rettype = \"uint8x8_t\", argtypes = \"[uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 44818,IntegerVal 0,IntegerVal 0,IntegerVal 15791,IntegerVal 0,IntegerVal 32767,IntegerVal 20237],VectorVal [IntegerVal 0,IntegerVal 0,IntegerVal 13864,IntegerVal 32768,IntegerVal 32768,IntegerVal 65535,IntegerVal 0,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x00000000af127fff)),
                          vcreate_u16(UINT64_C(0x4f0d7fff00003daf)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0x8000362800000000)),
                          vcreate_u16(UINT64_C(0x7fff0000ffff8000)));
      clear_neon_saturated();
      //  Expect: "result" = cf8000be80caaf80
      result = vrsubhn_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0xcf8000be80caaf80);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_377() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_sub\", fnname = \"vrsubhn_u32\", rettype = \"uint16x4_t\", argtypes = \"[uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 2734260223,IntegerVal 2147529491,IntegerVal 2147450880,IntegerVal 2147516416],VectorVal [IntegerVal 2147549183,IntegerVal 2147418112,IntegerVal 2147450880,IntegerVal 6799]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x8000b313a2f97fff)),
                          vcreate_u32(UINT64_C(0x800080007fff8000)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x7fff00008000ffff)),
                          vcreate_u32(UINT64_C(0x00001a8f7fff8000)));
      clear_neon_saturated();
      //  Expect: "result" = 80000000000222f9
      result = vrsubhn_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0x80000000000222f9);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_378() {

{
   {
      uint64x2_t arg1;
      uint64x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_sub\", fnname = \"vrsubhn_u64\", rettype = \"uint32x2_t\", argtypes = \"[uint64x2_t,uint64x2_t]\", vals = [VectorVal [IntegerVal 7222366429566173183,IntegerVal 9223231297218969599],VectorVal [IntegerVal 9223231297219002367,IntegerVal 9223653511831420928]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0x643b00007fff7fff)),
                          vcreate_u64(UINT64_C(0x7fff7fff80007fff)));
      arg2 = vcombine_u64(vcreate_u64(UINT64_C(0x7fff7fff8000ffff)),
                          vcreate_u64(UINT64_C(0x8000ffffffff0000)));
      clear_neon_saturated();
      //  Expect: "result" = fffe8000e43b8001
      result = vrsubhn_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0xfffe8000e43b8001);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_379() {

{
   {
      int8x8_t arg1;
      int16x8_t arg2;
      int16x8_t arg3;
      int8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_sub\", fnname = \"vrsubhn_high_s16\", rettype = \"int8x16_t\", argtypes = \"[int8x8_t,int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal (-128),IntegerVal (-1),IntegerVal 0,IntegerVal 0,IntegerVal (-128),IntegerVal (-128),IntegerVal 0,IntegerVal 0],VectorVal [IntegerVal (-512),IntegerVal 32767,IntegerVal 32767,IntegerVal (-1),IntegerVal 32767,IntegerVal (-32768),IntegerVal 32767,IntegerVal (-1)],VectorVal [IntegerVal 0,IntegerVal (-32768),IntegerVal (-1),IntegerVal (-32768),IntegerVal (-32768),IntegerVal 32767,IntegerVal 0,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s8(UINT64_C(0x000080800000ff80));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0xffff7fff7ffffe00)),
                          vcreate_s16(UINT64_C(0xffff7fff80007fff)));
      arg3 = vcombine_s16(vcreate_s16(UINT64_C(0x8000ffff80000000)),
                          vcreate_s16(UINT64_C(0x000000007fff8000)));
      clear_neon_saturated();
      //  Expect: "result" = 00800000808000fe000080800000ff80
      result = vrsubhn_high_s16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 0);
         exp = UINT64_C(0x000080800000ff80);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s8(result), 1);
         exp = UINT64_C(0x00800000808000fe);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_380() {

{
   {
      int16x4_t arg1;
      int32x4_t arg2;
      int32x4_t arg3;
      int16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_sub\", fnname = \"vrsubhn_high_s32\", rettype = \"int16x8_t\", argtypes = \"[int16x4_t,int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal (-32768),IntegerVal (-1),IntegerVal (-1),IntegerVal 0],VectorVal [IntegerVal 2147468443,IntegerVal 1061777400,IntegerVal (-1),IntegerVal 32767],VectorVal [IntegerVal (-65536),IntegerVal (-2147464316),IntegerVal 1538059649,IntegerVal (-65536)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s16(UINT64_C(0x0000ffffffff8000));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x3f496ff87fffc49b)),
                          vcreate_s32(UINT64_C(0x00007fffffffffff)));
      arg3 = vcombine_s32(vcreate_s32(UINT64_C(0x80004b84ffff0000)),
                          vcreate_s32(UINT64_C(0xffff00005baced81)));
      clear_neon_saturated();
      //  Expect: "result" = 0001a453bf4980010000ffffffff8000
      result = vrsubhn_high_s32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 0);
         exp = UINT64_C(0x0000ffffffff8000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s16(result), 1);
         exp = UINT64_C(0x0001a453bf498001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_381() {

{
   {
      int32x2_t arg1;
      int64x2_t arg2;
      int64x2_t arg3;
      int32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_sub\", fnname = \"vrsubhn_high_s64\", rettype = \"int32x4_t\", argtypes = \"[int32x2_t,int64x2_t,int64x2_t]\", vals = [VectorVal [IntegerVal 1886322688,IntegerVal (-2147450880)],VectorVal [IntegerVal 9223144959786385407,IntegerVal (-9223372034707324928)],VectorVal [IntegerVal (-9223231295690174885),IntegerVal (-9136537006539571200)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_s32(UINT64_C(0x80008000706f0000));
      arg2 = vcombine_s64(vcreate_s64(UINT64_C(0x7fff317980007fff)),
                          vcreate_s64(UINT64_C(0x800000007fff8000)));
      arg3 = vcombine_s64(vcreate_s64(UINT64_C(0x80008000db1f0e5b)),
                          vcreate_s64(UINT64_C(0x81347fffffff8000)));
      clear_neon_saturated();
      //  Expect: "result" = fecb8001fffeb17980008000706f0000
      result = vrsubhn_high_s64(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 0);
         exp = UINT64_C(0x80008000706f0000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_s32(result), 1);
         exp = UINT64_C(0xfecb8001fffeb179);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_382() {

{
   {
      uint8x8_t arg1;
      uint16x8_t arg2;
      uint16x8_t arg3;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_sub\", fnname = \"vrsubhn_high_u16\", rettype = \"uint8x16_t\", argtypes = \"[uint8x8_t,uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 142,IntegerVal 128,IntegerVal 166,IntegerVal 0,IntegerVal 255,IntegerVal 127,IntegerVal 127,IntegerVal 127],VectorVal [IntegerVal 39927,IntegerVal 32768,IntegerVal 36362,IntegerVal 0,IntegerVal 0,IntegerVal 0,IntegerVal 32768,IntegerVal 65535],VectorVal [IntegerVal 0,IntegerVal 64941,IntegerVal 0,IntegerVal 40045,IntegerVal 0,IntegerVal 32767,IntegerVal 32767,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u8(UINT64_C(0x7f7f7fff00a6808e));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0x00008e0a80009bf7)),
                          vcreate_u16(UINT64_C(0xffff800000000000)));
      arg3 = vcombine_u16(vcreate_u16(UINT64_C(0x9c6d0000fdad0000)),
                          vcreate_u16(UINT64_C(0x7fff7fff7fff0000)));
      clear_neon_saturated();
      //  Expect: "result" = 80008000648e829c7f7f7fff00a6808e
      result = vrsubhn_high_u16(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x7f7f7fff00a6808e);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0x80008000648e829c);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_383() {

{
   {
      uint16x4_t arg1;
      uint32x4_t arg2;
      uint32x4_t arg3;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_sub\", fnname = \"vrsubhn_high_u32\", rettype = \"uint16x8_t\", argtypes = \"[uint16x4_t,uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 65535,IntegerVal 32768,IntegerVal 32768,IntegerVal 32768],VectorVal [IntegerVal 177307648,IntegerVal 0,IntegerVal 2147483647,IntegerVal 573210624],VectorVal [IntegerVal 2147528347,IntegerVal 2147450879,IntegerVal 750551040,IntegerVal 2147483647]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u16(UINT64_C(0x800080008000ffff));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x000000000a918000)),
                          vcreate_u32(UINT64_C(0x222a80007fffffff)));
      arg3 = vcombine_u32(vcreate_u32(UINT64_C(0x7fff7fff8000ae9b)),
                          vcreate_u32(UINT64_C(0x7fffffff2cbc8000)));
      clear_neon_saturated();
      //  Expect: "result" = a22b534380018a91800080008000ffff
      result = vrsubhn_high_u32(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x800080008000ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0xa22b534380018a91);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_384() {

{
   {
      uint32x2_t arg1;
      uint64x2_t arg2;
      uint64x2_t arg3;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"roundinghighhalf_sub\", fnname = \"vrsubhn_high_u64\", rettype = \"uint32x4_t\", argtypes = \"[uint32x2_t,uint64x2_t,uint64x2_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 4294967295],VectorVal [IntegerVal 9223090564025578507,IntegerVal 156159713640447],VectorVal [IntegerVal 140737488355328,IntegerVal 9223231295071453184]], start_saturated = False}";
      int reported = 0;
      arg1 = vcreate_u32(UINT64_C(0xffffffff00000000));
      arg2 = vcombine_u64(vcreate_u64(UINT64_C(0x7fff00008000740b)),
                          vcreate_u64(UINT64_C(0x00008e06c4427fff)));
      arg3 = vcombine_u64(vcreate_u64(UINT64_C(0x0000800000000000)),
                          vcreate_u64(UINT64_C(0x7fff7fff00000000)));
      clear_neon_saturated();
      //  Expect: "result" = 80010e087ffe8001ffffffff00000000
      result = vrsubhn_high_u64(arg1, arg2, arg3);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0xffffffff00000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0x80010e087ffe8001);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_385() {

{
   {
      int8x8_t arg1;
      int8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceq_s8\", rettype = \"uint8x8_t\", argtypes = \"[int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal (-128),IntegerVal 127,IntegerVal 0,IntegerVal (-128),IntegerVal 10,IntegerVal 31,IntegerVal (-62)],VectorVal [IntegerVal (-128),IntegerVal 75,IntegerVal (-25),IntegerVal (-1),IntegerVal 0,IntegerVal 83,IntegerVal (-1),IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s8(UINT64_C(0xc21f0a80007f80ff));
      arg2 = vcreate_s8(UINT64_C(0xffff5300ffe74b80));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vceq_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_386() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceq_s16\", rettype = \"uint16x4_t\", argtypes = \"[int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal (-32768),IntegerVal 32767,IntegerVal (-1),IntegerVal 0],VectorVal [IntegerVal 0,IntegerVal 32767,IntegerVal 31720,IntegerVal (-32768)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s16(UINT64_C(0x0000ffff7fff8000));
      arg2 = vcreate_s16(UINT64_C(0x80007be87fff0000));
      clear_neon_saturated();
      //  Expect: "result" = 00000000ffff0000
      result = vceq_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0x00000000ffff0000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_387() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceq_s32\", rettype = \"uint32x2_t\", argtypes = \"[int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal (-32769),IntegerVal 32767],VectorVal [IntegerVal (-2147450881),IntegerVal (-1812824065)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s32(UINT64_C(0x00007fffffff7fff));
      arg2 = vcreate_s32(UINT64_C(0x93f27fff80007fff));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vceq_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_388() {

{
   {
      float32x2_t arg1;
      float32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceq_f32\", rettype = \"uint32x2_t\", argtypes = \"[float32x2_t,float32x2_t]\", vals = [VectorVal [FloatVal 0.7415538430213928,FloatVal 0.5409243702888489],VectorVal [FloatVal 0.8341127038002014,FloatVal 0.6394548416137695]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_f32(UINT64_C(0x3f0a7a053f3dd679));
      arg2 = vcreate_f32(UINT64_C(0x3f23b3503f558869));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vceq_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_389() {

{
   {
      uint8x8_t arg1;
      uint8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceq_u8\", rettype = \"uint8x8_t\", argtypes = \"[uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 127,IntegerVal 255,IntegerVal 127,IntegerVal 0,IntegerVal 128,IntegerVal 59,IntegerVal 0,IntegerVal 255],VectorVal [IntegerVal 127,IntegerVal 0,IntegerVal 0,IntegerVal 128,IntegerVal 18,IntegerVal 0,IntegerVal 255,IntegerVal 134]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u8(UINT64_C(0xff003b80007fff7f));
      arg2 = vcreate_u8(UINT64_C(0x86ff00128000007f));
      clear_neon_saturated();
      //  Expect: "result" = 00000000000000ff
      result = vceq_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0x00000000000000ff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_390() {

{
   {
      uint16x4_t arg1;
      uint16x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceq_u16\", rettype = \"uint16x4_t\", argtypes = \"[uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 12549,IntegerVal 37519,IntegerVal 65535,IntegerVal 56246],VectorVal [IntegerVal 0,IntegerVal 1177,IntegerVal 2896,IntegerVal 32485]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u16(UINT64_C(0xdbb6ffff928f3105));
      arg2 = vcreate_u16(UINT64_C(0x7ee50b5004990000));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vceq_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_391() {

{
   {
      uint32x2_t arg1;
      uint32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceq_u32\", rettype = \"uint32x2_t\", argtypes = \"[uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 2147506120,IntegerVal 32768],VectorVal [IntegerVal 4294916148,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u32(UINT64_C(0x00008000800057c8));
      arg2 = vcreate_u32(UINT64_C(0x00000000ffff3834));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vceq_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_392() {

{
   {
      poly8x8_t arg1;
      poly8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceq_p8\", rettype = \"uint8x8_t\", argtypes = \"[poly8x8_t,poly8x8_t]\", vals = [VectorVal [PolyVal [0,0,1,0,1,1,1,0],PolyVal [1,0,0,0,0,1,0,0],PolyVal [0,1,0,1,1,0,0,0],PolyVal [0,0,1,0,1,0,1,0],PolyVal [1,0,1,1,1,0,0,0],PolyVal [0,1,0,0,0,1,0,1],PolyVal [1,1,0,0,0,1,0,0],PolyVal [1,0,0,1,0,0,0,1]],VectorVal [PolyVal [0,1,0,1,1,0,1,0],PolyVal [0,0,1,1,1,0,0,0],PolyVal [0,0,1,1,1,0,1,0],PolyVal [1,0,1,0,1,0,1,1],PolyVal [1,1,0,1,1,0,1,1],PolyVal [0,0,1,0,1,1,1,0],PolyVal [1,1,0,1,1,0,1,1],PolyVal [0,1,1,0,1,0,1,1]]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_p8(UINT64_C(0x8923a21d541a2174));
      arg2 = vcreate_p8(UINT64_C(0xd6db74dbd55c1c5a));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vceq_p8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_393() {

{
   {
      int8x16_t arg1;
      int8x16_t arg2;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceqq_s8\", rettype = \"uint8x16_t\", argtypes = \"[int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal (-128),IntegerVal (-128),IntegerVal (-1),IntegerVal (-1),IntegerVal 127,IntegerVal 80,IntegerVal (-48),IntegerVal (-128),IntegerVal (-1),IntegerVal (-39),IntegerVal (-1),IntegerVal (-1),IntegerVal 88,IntegerVal 0,IntegerVal (-128),IntegerVal 127],VectorVal [IntegerVal (-1),IntegerVal (-60),IntegerVal (-1),IntegerVal 0,IntegerVal 27,IntegerVal 0,IntegerVal (-128),IntegerVal 127,IntegerVal 97,IntegerVal 93,IntegerVal 124,IntegerVal (-1),IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal (-80)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s8(vcreate_s8(UINT64_C(0x80d0507fffff8080)),
                         vcreate_s8(UINT64_C(0x7f800058ffffd9ff)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0x7f80001b00ffc4ff)),
                         vcreate_s8(UINT64_C(0xb0007f00ff7c5d61)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000ff0000000000000000ff0000
      result = vceqq_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x0000000000ff0000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0x00000000ff000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_394() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceqq_s16\", rettype = \"uint16x8_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 32767,IntegerVal (-32768),IntegerVal (-10705),IntegerVal 6825,IntegerVal (-1),IntegerVal (-1),IntegerVal (-22381)],VectorVal [IntegerVal (-15144),IntegerVal 0,IntegerVal 32767,IntegerVal (-1),IntegerVal (-1),IntegerVal 32767,IntegerVal 32767,IntegerVal (-4492)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0xd62f80007fff0000)),
                          vcreate_s16(UINT64_C(0xa893ffffffff1aa9)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0xffff7fff0000c4d8)),
                          vcreate_s16(UINT64_C(0xee747fff7fffffff)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000000000000000000000000000
      result = vceqq_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_395() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceqq_s32\", rettype = \"uint32x4_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal 58816,IntegerVal 2147418112,IntegerVal (-1282965504),IntegerVal 2147450879],VectorVal [IntegerVal 65535,IntegerVal (-2147450881),IntegerVal 0,IntegerVal 2147418112]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x7fff00000000e5c0)),
                          vcreate_s32(UINT64_C(0x7fff7fffb3878000)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x80007fff0000ffff)),
                          vcreate_s32(UINT64_C(0x7fff000000000000)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000000000000000000000000000
      result = vceqq_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_396() {

{
   {
      float32x4_t arg1;
      float32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceqq_f32\", rettype = \"uint32x4_t\", argtypes = \"[float32x4_t,float32x4_t]\", vals = [VectorVal [FloatVal 0.3720451593399048,FloatVal 0.966404139995575,FloatVal 0.4019153118133545,FloatVal 0.6189365386962891],VectorVal [FloatVal 1.122206449508667e-2,FloatVal 0.8974215388298035,FloatVal 0.4048483967781067,FloatVal 0.12181311845779419]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f32(vcreate_f32(UINT64_C(0x3f7766433ebe7cb4)),
                          vcreate_f32(UINT64_C(0x3f1e72a03ecdc7d8)));
      arg2 = vcombine_f32(vcreate_f32(UINT64_C(0x3f65bd6b3c37dcc0)),
                          vcreate_f32(UINT64_C(0x3df979283ecf484a)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000000000000000000000000000
      result = vceqq_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_397() {

{
   {
      uint8x16_t arg1;
      uint8x16_t arg2;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceqq_u8\", rettype = \"uint8x16_t\", argtypes = \"[uint8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 127,IntegerVal 255,IntegerVal 128,IntegerVal 128,IntegerVal 0,IntegerVal 255,IntegerVal 128,IntegerVal 128,IntegerVal 255,IntegerVal 127,IntegerVal 255,IntegerVal 0,IntegerVal 79,IntegerVal 255,IntegerVal 150,IntegerVal 127],VectorVal [IntegerVal 0,IntegerVal 128,IntegerVal 57,IntegerVal 128,IntegerVal 255,IntegerVal 127,IntegerVal 128,IntegerVal 255,IntegerVal 127,IntegerVal 255,IntegerVal 128,IntegerVal 0,IntegerVal 127,IntegerVal 128,IntegerVal 127,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u8(vcreate_u8(UINT64_C(0x8080ff008080ff7f)),
                         vcreate_u8(UINT64_C(0x7f96ff4f00ff7fff)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0xff807fff80398000)),
                         vcreate_u8(UINT64_C(0x007f807f0080ff7f)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000ff00000000ff0000ff000000
      result = vceqq_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x00ff0000ff000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0x00000000ff000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_398() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceqq_u16\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 32768,IntegerVal 32768,IntegerVal 32767,IntegerVal 36014,IntegerVal 0,IntegerVal 65535,IntegerVal 0],VectorVal [IntegerVal 32767,IntegerVal 52218,IntegerVal 32768,IntegerVal 0,IntegerVal 32768,IntegerVal 32768,IntegerVal 0,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x7fff800080007fff)),
                          vcreate_u16(UINT64_C(0x0000ffff00008cae)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0x00008000cbfa7fff)),
                          vcreate_u16(UINT64_C(0x0000000080008000)));
      clear_neon_saturated();
      //  Expect: "result" = ffff0000000000000000ffff0000ffff
      result = vceqq_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x0000ffff0000ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0xffff000000000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_399() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceqq_u32\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 4294934528,IntegerVal 4294934528,IntegerVal 2296152064,IntegerVal 2777219072],VectorVal [IntegerVal 2147418112,IntegerVal 4294967295,IntegerVal 4294934528,IntegerVal 2147460039]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0xffff8000ffff8000)),
                          vcreate_u32(UINT64_C(0xa589000088dc8000)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0xffffffff7fff0000)),
                          vcreate_u32(UINT64_C(0x7fffa3c7ffff8000)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000000000000000000000000000
      result = vceqq_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_400() {

{
   {
      poly8x16_t arg1;
      poly8x16_t arg2;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceqq_p8\", rettype = \"uint8x16_t\", argtypes = \"[poly8x16_t,poly8x16_t]\", vals = [VectorVal [PolyVal [0,0,1,1,1,0,0,1],PolyVal [0,0,1,1,0,1,1,1],PolyVal [1,1,0,0,0,1,0,0],PolyVal [0,0,0,0,0,0,0,1],PolyVal [1,1,0,1,1,1,0,0],PolyVal [1,1,0,0,0,1,1,1],PolyVal [0,0,1,1,1,0,0,1],PolyVal [1,1,1,1,1,1,1,1],PolyVal [1,0,0,1,1,1,1,1],PolyVal [1,1,1,0,0,1,0,1],PolyVal [1,0,0,1,0,0,0,1],PolyVal [1,1,0,0,1,1,0,0],PolyVal [1,1,1,0,1,0,0,1],PolyVal [0,1,1,1,0,0,1,1],PolyVal [0,1,0,1,1,1,1,0],PolyVal [0,0,1,0,0,0,0,0]],VectorVal [PolyVal [1,1,0,1,1,0,0,1],PolyVal [0,0,1,0,1,0,0,0],PolyVal [1,1,1,1,1,1,1,1],PolyVal [0,0,1,1,1,1,1,1],PolyVal [1,1,1,1,0,0,0,1],PolyVal [0,0,1,1,1,1,1,1],PolyVal [0,0,1,0,0,1,0,0],PolyVal [1,0,1,0,1,0,0,1],PolyVal [1,0,1,1,1,1,1,1],PolyVal [0,1,0,0,1,1,0,1],PolyVal [1,0,1,0,0,1,0,0],PolyVal [1,0,0,1,0,1,1,1],PolyVal [1,1,1,1,0,1,1,1],PolyVal [0,1,0,0,0,1,1,1],PolyVal [0,0,1,0,1,1,0,0],PolyVal [1,1,0,1,1,1,0,0]]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_p8(vcreate_p8(UINT64_C(0xff9ce33b8023ec9c)),
                         vcreate_p8(UINT64_C(0x047ace973389a7f9)));
      arg2 = vcombine_p8(vcreate_p8(UINT64_C(0x9524fc8ffcff149b)),
                         vcreate_p8(UINT64_C(0x3b34e2efe925b2fd)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000000000000000000000000000
      result = vceqq_p8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_401() {

{
   {
      int64x1_t arg1;
      int64x1_t arg2;
      uint64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceq_s64\", rettype = \"uint64x1_t\", argtypes = \"[int64x1_t,int64x1_t]\", vals = [VectorVal [IntegerVal (-219749854183424)],VectorVal [IntegerVal (-9223231303661343310)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s64(UINT64_C(0xffff382380008000));
      arg2 = vcreate_s64(UINT64_C(0x80007fff0000adb2));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vceq_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(result, 0);
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_402() {

{
   {
      uint64x1_t arg1;
      uint64x1_t arg2;
      uint64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceq_u64\", rettype = \"uint64x1_t\", argtypes = \"[uint64x1_t,uint64x1_t]\", vals = [VectorVal [IntegerVal 9223090564386577711],VectorVal [IntegerVal 281472829292543]], start_saturated = True}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u64(UINT64_C(0x7fff00009584dd2f));
      arg2 = vcreate_u64(UINT64_C(0x0000ffff8000ffff));
      set_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vceq_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(result, 0);
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_403() {

{
   {
      float64x1_t arg1;
      float64x1_t arg2;
      uint64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceq_f64\", rettype = \"uint64x1_t\", argtypes = \"[float64x1_t,float64x1_t]\", vals = [VectorVal [FloatVal 0.9973723897793982],VectorVal [FloatVal 0.6904952465761311]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_f64(UINT64_C(0x3fefea79808125ee));
      arg2 = vcreate_f64(UINT64_C(0x3fe618897cc2d066));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vceq_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(result, 0);
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_404() {

{
   {
      int64x2_t arg1;
      int64x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceqq_s64\", rettype = \"uint64x2_t\", argtypes = \"[int64x2_t,int64x2_t]\", vals = [VectorVal [IntegerVal (-140735340817641),IntegerVal 9223090564025548800],VectorVal [IntegerVal (-9223090564025524127),IntegerVal 6875026310452738476]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0xffff80008000d317)),
                          vcreate_s64(UINT64_C(0x7fff000080000000)));
      arg2 = vcombine_s64(vcreate_s64(UINT64_C(0x8000ffff80006061)),
                          vcreate_s64(UINT64_C(0x5f690000fffff9ac)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000000000000000000000000000
      result = vceqq_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_405() {

{
   {
      uint64x2_t arg1;
      uint64x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceqq_u64\", rettype = \"uint64x2_t\", argtypes = \"[uint64x2_t,uint64x2_t]\", vals = [VectorVal [IntegerVal 9223578858857489908,IntegerVal 13762578248779202560],VectorVal [IntegerVal 9223372032559849338,IntegerVal 18446631074865184767]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0x8000bc1a8000e5f4)),
                          vcreate_u64(UINT64_C(0xbefe800000008000)));
      arg2 = vcombine_u64(vcreate_u64(UINT64_C(0x7fffffff00009f7a)),
                          vcreate_u64(UINT64_C(0xffff993a68057fff)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000000000000000000000000000
      result = vceqq_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_406() {

{
   {
      float64x2_t arg1;
      float64x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceqq_f64\", rettype = \"uint64x2_t\", argtypes = \"[float64x2_t,float64x2_t]\", vals = [VectorVal [FloatVal 0.8856813185513182,FloatVal 0.5522779331450832],VectorVal [FloatVal 0.21798700252556724,FloatVal 0.5484680458256258]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f64(vcreate_f64(UINT64_C(0x3fec5780593b64ec)),
                          vcreate_f64(UINT64_C(0x3fe1ac42c5a523b1)));
      arg2 = vcombine_f64(vcreate_f64(UINT64_C(0x3fcbe6ff836672e0)),
                          vcreate_f64(UINT64_C(0x3fe18d0cdbf71b61)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000000000000000000000000000
      result = vceqq_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_407() {

{
   {
      int64_t arg1;
      int64_t arg2;
      uint64_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceqd_s64\", rettype = \"uint64_t\", argtypes = \"[int64_t,int64_t]\", vals = [IntegerVal 9223118311661795647,IntegerVal (-5682135350563095517)], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = INT64_C(9223118311661795647);
      arg2 = INT64_C(-5682135350563095517);
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vceqd_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_408() {

{
   {
      uint64_t arg1;
      uint64_t arg2;
      uint64_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceqd_u64\", rettype = \"uint64_t\", argtypes = \"[uint64_t,uint64_t]\", vals = [IntegerVal 18446603335542505472,IntegerVal 9223231299366453247], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = UINT64_C(0xffff7fffd78c0000);
      arg2 = UINT64_C(0x7fff800000007fff);
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vceqd_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_409() {

{
   {
      float64_t arg1;
      float64_t arg2;
      uint64_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceqd_f64\", rettype = \"uint64_t\", argtypes = \"[float64_t,float64_t]\", vals = [FloatVal 0.29243191873812024,FloatVal 0.3581657798051834], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = 0.29243191873812024;
      arg2 = 0.3581657798051834;
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vceqd_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_410() {

{
   {
      float32_t arg1;
      float32_t arg2;
      uint32_t result;
      char* str1 = "ReproInfo2 {semantics = \"ceq\", fnname = \"vceqs_f32\", rettype = \"uint32_t\", argtypes = \"[float32_t,float32_t]\", vals = [FloatVal 0.4552466869354248,FloatVal 0.4301597476005554], start_saturated = False}";
      int reported = 0;
      uint32_t got;
      uint32_t exp;
      arg1 = ((float32_t) 0.4552466869354248);
      arg2 = ((float32_t) 0.4301597476005554);
      clear_neon_saturated();
      //  Expect: "result" = 00000000
      result = vceqs_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIu32 " Got: %" PRIu32 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_411() {

{
   {
      int8x8_t arg1;
      int8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcge_s8\", rettype = \"uint8x8_t\", argtypes = \"[int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal 127,IntegerVal (-1),IntegerVal 49,IntegerVal (-1),IntegerVal 127,IntegerVal (-1),IntegerVal 56],VectorVal [IntegerVal (-1),IntegerVal (-1),IntegerVal (-66),IntegerVal (-1),IntegerVal 127,IntegerVal 0,IntegerVal (-128),IntegerVal (-128)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s8(UINT64_C(0x38ff7fff31ff7fff));
      arg2 = vcreate_s8(UINT64_C(0x8080007fffbeffff));
      clear_neon_saturated();
      //  Expect: "result" = ffffff00ffffffff
      result = vcge_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0xffffff00ffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_412() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcge_s16\", rettype = \"uint16x4_t\", argtypes = \"[int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal (-1),IntegerVal 1033,IntegerVal (-1)],VectorVal [IntegerVal 32767,IntegerVal (-32768),IntegerVal (-1),IntegerVal (-32768)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s16(UINT64_C(0xffff0409ffffffff));
      arg2 = vcreate_s16(UINT64_C(0x8000ffff80007fff));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffff0000
      result = vcge_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0xffffffffffff0000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_413() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcge_s32\", rettype = \"uint32x2_t\", argtypes = \"[int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal (-2147439654),IntegerVal 32767],VectorVal [IntegerVal 2147449882,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s32(UINT64_C(0x00007fff8000abda));
      arg2 = vcreate_s32(UINT64_C(0x00007fff7fff7c1a));
      clear_neon_saturated();
      //  Expect: "result" = ffffffff00000000
      result = vcge_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0xffffffff00000000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_414() {

{
   {
      float32x2_t arg1;
      float32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcge_f32\", rettype = \"uint32x2_t\", argtypes = \"[float32x2_t,float32x2_t]\", vals = [VectorVal [FloatVal 0.23078715801239014,FloatVal 0.8321971297264099],VectorVal [FloatVal 1.2592792510986328e-2,FloatVal 0.8450909852981567]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_f32(UINT64_C(0x3f550adf3e6c5378));
      arg2 = vcreate_f32(UINT64_C(0x3f5857e23c4e5200));
      clear_neon_saturated();
      //  Expect: "result" = 00000000ffffffff
      result = vcge_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0x00000000ffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_415() {

{
   {
      uint8x8_t arg1;
      uint8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcge_u8\", rettype = \"uint8x8_t\", argtypes = \"[uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 127,IntegerVal 127,IntegerVal 156,IntegerVal 128,IntegerVal 127,IntegerVal 255,IntegerVal 127,IntegerVal 127],VectorVal [IntegerVal 0,IntegerVal 127,IntegerVal 255,IntegerVal 69,IntegerVal 128,IntegerVal 0,IntegerVal 0,IntegerVal 255]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u8(UINT64_C(0x7f7fff7f809c7f7f));
      arg2 = vcreate_u8(UINT64_C(0xff00008045ff7f00));
      clear_neon_saturated();
      //  Expect: "result" = 00ffff00ff00ffff
      result = vcge_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0x00ffff00ff00ffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_416() {

{
   {
      uint16x4_t arg1;
      uint16x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcge_u16\", rettype = \"uint16x4_t\", argtypes = \"[uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 65535,IntegerVal 36642,IntegerVal 65535],VectorVal [IntegerVal 32767,IntegerVal 0,IntegerVal 14179,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u16(UINT64_C(0xffff8f22ffff7fff));
      arg2 = vcreate_u16(UINT64_C(0x7fff376300007fff));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffff
      result = vcge_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0xffffffffffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_417() {

{
   {
      uint32x2_t arg1;
      uint32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcge_u32\", rettype = \"uint32x2_t\", argtypes = \"[uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 65535,IntegerVal 2147508900],VectorVal [IntegerVal 327352320,IntegerVal 2147483648]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u32(UINT64_C(0x800062a40000ffff));
      arg2 = vcreate_u32(UINT64_C(0x8000000013830000));
      clear_neon_saturated();
      //  Expect: "result" = ffffffff00000000
      result = vcge_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0xffffffff00000000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_418() {

{
   {
      int8x16_t arg1;
      int8x16_t arg2;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcgeq_s8\", rettype = \"uint8x16_t\", argtypes = \"[int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal 127,IntegerVal 127,IntegerVal (-128),IntegerVal (-128),IntegerVal 127,IntegerVal 127,IntegerVal (-1),IntegerVal (-128),IntegerVal 127,IntegerVal 0,IntegerVal (-128),IntegerVal 0,IntegerVal 79,IntegerVal 0,IntegerVal (-37)],VectorVal [IntegerVal (-1),IntegerVal (-128),IntegerVal 127,IntegerVal 33,IntegerVal 18,IntegerVal 0,IntegerVal (-45),IntegerVal (-128),IntegerVal 127,IntegerVal (-128),IntegerVal 0,IntegerVal 127,IntegerVal 53,IntegerVal 0,IntegerVal 22,IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s8(vcreate_s8(UINT64_C(0xff7f7f80807f7fff)),
                         vcreate_s8(UINT64_C(0xdb004f0080007f80)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0x80d30012217f80ff)),
                         vcreate_s8(UINT64_C(0xff1600357f00807f)));
      clear_neon_saturated();
      //  Expect: "result" = 0000ff0000ffff00ffffff0000ffffff
      result = vcgeq_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0xffffff0000ffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0x0000ff0000ffff00);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_419() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcgeq_s16\", rettype = \"uint16x8_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal 5414,IntegerVal 871,IntegerVal 0,IntegerVal 0,IntegerVal (-1),IntegerVal (-32768),IntegerVal (-1),IntegerVal (-32768)],VectorVal [IntegerVal (-1),IntegerVal 0,IntegerVal 32767,IntegerVal (-1),IntegerVal (-1),IntegerVal 0,IntegerVal (-1),IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x0000000003671526)),
                          vcreate_s16(UINT64_C(0x8000ffff8000ffff)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0xffff7fff0000ffff)),
                          vcreate_s16(UINT64_C(0x7fffffff0000ffff)));
      clear_neon_saturated();
      //  Expect: "result" = 0000ffff0000ffffffff0000ffffffff
      result = vcgeq_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0xffff0000ffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x0000ffff0000ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_420() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcgeq_s32\", rettype = \"uint32x4_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal (-425984000),IntegerVal 32767,IntegerVal 1883531172,IntegerVal (-2147450881)],VectorVal [IntegerVal 54848,IntegerVal (-57151),IntegerVal (-2147418113),IntegerVal 65535]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x00007fffe69c0000)),
                          vcreate_s32(UINT64_C(0x80007fff704467a4)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0xffff20c10000d640)),
                          vcreate_s32(UINT64_C(0x0000ffff8000ffff)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000ffffffffffffffff00000000
      result = vcgeq_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0xffffffff00000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0x00000000ffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_421() {

{
   {
      float32x4_t arg1;
      float32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcgeq_f32\", rettype = \"uint32x4_t\", argtypes = \"[float32x4_t,float32x4_t]\", vals = [VectorVal [FloatVal 3.410017490386963e-2,FloatVal 0.8852890729904175,FloatVal 0.8844092488288879,FloatVal 0.6028785705566406],VectorVal [FloatVal 0.9062389731407166,FloatVal 0.32099467515945435,FloatVal 0.17679059505462646,FloatVal 0.7122007012367249]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f32(vcreate_f32(UINT64_C(0x3f62a24e3d0baca0)),
                          vcreate_f32(UINT64_C(0x3f1a56403f6268a5)));
      arg2 = vcombine_f32(vcreate_f32(UINT64_C(0x3ea4596a3f67ff47)),
                          vcreate_f32(UINT64_C(0x3f3652c93e350898)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000ffffffffffffffff00000000
      result = vcgeq_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0xffffffff00000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0x00000000ffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_422() {

{
   {
      uint8x16_t arg1;
      uint8x16_t arg2;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcgeq_u8\", rettype = \"uint8x16_t\", argtypes = \"[uint8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal 255,IntegerVal 0,IntegerVal 0,IntegerVal 128,IntegerVal 127,IntegerVal 255,IntegerVal 128,IntegerVal 128,IntegerVal 128,IntegerVal 127,IntegerVal 255,IntegerVal 255],VectorVal [IntegerVal 0,IntegerVal 128,IntegerVal 127,IntegerVal 221,IntegerVal 15,IntegerVal 190,IntegerVal 174,IntegerVal 255,IntegerVal 128,IntegerVal 255,IntegerVal 128,IntegerVal 128,IntegerVal 127,IntegerVal 128,IntegerVal 155,IntegerVal 127]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u8(vcreate_u8(UINT64_C(0x800000ff007f007f)),
                         vcreate_u8(UINT64_C(0xffff7f808080ff7f)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0xffaebe0fdd7f8000)),
                         vcreate_u8(UINT64_C(0x7f9b807f8080ff80)));
      clear_neon_saturated();
      //  Expect: "result" = ffff00ffffffff00000000ff00ff00ff
      result = vcgeq_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x000000ff00ff00ff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0xffff00ffffffff00);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_423() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcgeq_u16\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 35118,IntegerVal 32768,IntegerVal 65535,IntegerVal 32767,IntegerVal 32767,IntegerVal 65535,IntegerVal 0,IntegerVal 32767],VectorVal [IntegerVal 41215,IntegerVal 32767,IntegerVal 65535,IntegerVal 32768,IntegerVal 32768,IntegerVal 32768,IntegerVal 32767,IntegerVal 65535]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x7fffffff8000892e)),
                          vcreate_u16(UINT64_C(0x7fff0000ffff7fff)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0x8000ffff7fffa0ff)),
                          vcreate_u16(UINT64_C(0xffff7fff80008000)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000ffff00000000ffffffff0000
      result = vcgeq_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x0000ffffffff0000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x00000000ffff0000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_424() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcgeq_u32\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 2147419759,IntegerVal 2147516416,IntegerVal 3037396991,IntegerVal 4294934527],VectorVal [IntegerVal 4294943723,IntegerVal 2147546278,IntegerVal 4294934528,IntegerVal 4294934528]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x800080007fff066f)),
                          vcreate_u32(UINT64_C(0xffff7fffb50affff)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x8000f4a6ffffa3eb)),
                          vcreate_u32(UINT64_C(0xffff8000ffff8000)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000000000000000000000000000
      result = vcgeq_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_425() {

{
   {
      int64x1_t arg1;
      int64x1_t arg2;
      uint64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcge_s64\", rettype = \"uint64x1_t\", argtypes = \"[int64x1_t,int64x1_t]\", vals = [VectorVal [IntegerVal (-2406645760)],VectorVal [IntegerVal 9223231302935379968]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s64(UINT64_C(0xffffffff708d8000));
      arg2 = vcreate_s64(UINT64_C(0x7fff8000d4ba0000));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vcge_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(result, 0);
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_426() {

{
   {
      uint64x1_t arg1;
      uint64x1_t arg2;
      uint64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcge_u64\", rettype = \"uint64x1_t\", argtypes = \"[uint64x1_t,uint64x1_t]\", vals = [VectorVal [IntegerVal 18446462599640612864],VectorVal [IntegerVal 2147516416]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u64(UINT64_C(0xffff0000361b8000));
      arg2 = vcreate_u64(UINT64_C(0x0000000080008000));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffff
      result = vcge_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(result, 0);
      exp = UINT64_C(0xffffffffffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_427() {

{
   {
      float64x1_t arg1;
      float64x1_t arg2;
      uint64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcge_f64\", rettype = \"uint64x1_t\", argtypes = \"[float64x1_t,float64x1_t]\", vals = [VectorVal [FloatVal 0.8997001964820792],VectorVal [FloatVal 0.35468495694778623]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_f64(UINT64_C(0x3fecca5811030cbc));
      arg2 = vcreate_f64(UINT64_C(0x3fd6b328889e548a));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffff
      result = vcge_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(result, 0);
      exp = UINT64_C(0xffffffffffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_428() {

{
   {
      int64x2_t arg1;
      int64x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcgeq_s64\", rettype = \"uint64x2_t\", argtypes = \"[int64x2_t,int64x2_t]\", vals = [VectorVal [IntegerVal 1858720010856300543,IntegerVal 98640366370816],VectorVal [IntegerVal 9223372032559851686,IntegerVal 2147521207]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x19cb80007fffffff)),
                          vcreate_s64(UINT64_C(0x000059b67fff8000)));
      arg2 = vcombine_s64(vcreate_s64(UINT64_C(0x7fffffff0000a8a6)),
                          vcreate_s64(UINT64_C(0x00000000800092b7)));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffff0000000000000000
      result = vcgeq_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0xffffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_429() {

{
   {
      uint64x2_t arg1;
      uint64x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcgeq_u64\", rettype = \"uint64x2_t\", argtypes = \"[uint64x2_t,uint64x2_t]\", vals = [VectorVal [IntegerVal 18446512065337655296,IntegerVal 2545941162382426112],VectorVal [IntegerVal 9223231303661387775,IntegerVal 9223231297218904064]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0xffff2cfd57688000)),
                          vcreate_u64(UINT64_C(0x2354ffff8ad98000)));
      arg2 = vcombine_u64(vcreate_u64(UINT64_C(0x7fff8000ffffffff)),
                          vcreate_u64(UINT64_C(0x7fff7fff7fff8000)));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000ffffffffffffffff
      result = vcgeq_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0xffffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_430() {

{
   {
      float64x2_t arg1;
      float64x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcgeq_f64\", rettype = \"uint64x2_t\", argtypes = \"[float64x2_t,float64x2_t]\", vals = [VectorVal [FloatVal 0.9753480261822668,FloatVal 0.8650751068463587],VectorVal [FloatVal 0.8688812819926862,FloatVal 0.5729589109934595]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f64(vcreate_f64(UINT64_C(0x3fef360d105578bb)),
                          vcreate_f64(UINT64_C(0x3febaeb1fd8fa462)));
      arg2 = vcombine_f64(vcreate_f64(UINT64_C(0x3febcde01e487c09)),
                          vcreate_f64(UINT64_C(0x3fe255aded1565db)));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffffffffffffffffffff
      result = vcgeq_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0xffffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0xffffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_431() {

{
   {
      int64_t arg1;
      int64_t arg2;
      uint64_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcged_s64\", rettype = \"uint64_t\", argtypes = \"[int64_t,int64_t]\", vals = [IntegerVal 9223231297218969599,IntegerVal 140737488388095], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = INT64_C(9223231297218969599);
      arg2 = INT64_C(140737488388095);
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffff
      result = vcged_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = UINT64_C(0xffffffffffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_432() {

{
   {
      uint64_t arg1;
      uint64_t arg2;
      uint64_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcged_u64\", rettype = \"uint64_t\", argtypes = \"[uint64_t,uint64_t]\", vals = [IntegerVal 4294934528,IntegerVal 9223090561878097920], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = UINT64_C(0x00000000ffff8000);
      arg2 = UINT64_C(0x7fff000000008000);
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vcged_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_433() {

{
   {
      float32_t arg1;
      float32_t arg2;
      uint32_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcges_f32\", rettype = \"uint32_t\", argtypes = \"[float32_t,float32_t]\", vals = [FloatVal 0.8124157786369324,FloatVal 0.2660365104675293], start_saturated = False}";
      int reported = 0;
      uint32_t got;
      uint32_t exp;
      arg1 = ((float32_t) 0.8124157786369324);
      arg2 = ((float32_t) 0.2660365104675293);
      clear_neon_saturated();
      //  Expect: "result" = ffffffff
      result = vcges_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 4294967295U;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIu32 " Got: %" PRIu32 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_434() {

{
   {
      float64_t arg1;
      float64_t arg2;
      uint64_t result;
      char* str1 = "ReproInfo2 {semantics = \"cge\", fnname = \"vcged_f64\", rettype = \"uint64_t\", argtypes = \"[float64_t,float64_t]\", vals = [FloatVal 0.5920066047947112,FloatVal 0.9503528284173293], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = 0.5920066047947112;
      arg2 = 0.9503528284173293;
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vcged_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_435() {

{
   {
      int8x8_t arg1;
      int8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcle_s8\", rettype = \"uint8x8_t\", argtypes = \"[int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 65,IntegerVal (-128),IntegerVal 0,IntegerVal (-128),IntegerVal (-1),IntegerVal (-128),IntegerVal (-1)],VectorVal [IntegerVal (-1),IntegerVal 108,IntegerVal (-128),IntegerVal (-128),IntegerVal 15,IntegerVal (-128),IntegerVal (-128),IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s8(UINT64_C(0xff80ff8000804100));
      arg2 = vcreate_s8(UINT64_C(0xff80800f80806cff));
      clear_neon_saturated();
      //  Expect: "result" = ffff00ff00ffff00
      result = vcle_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0xffff00ff00ffff00);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_436() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcle_s16\", rettype = \"uint16x4_t\", argtypes = \"[int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 6277,IntegerVal (-32768),IntegerVal 32767],VectorVal [IntegerVal 32767,IntegerVal 32767,IntegerVal (-32768),IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s16(UINT64_C(0x7fff800018857fff));
      arg2 = vcreate_s16(UINT64_C(0x7fff80007fff7fff));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffff
      result = vcle_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0xffffffffffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_437() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcle_s32\", rettype = \"uint32x2_t\", argtypes = \"[int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal 2147439044,IntegerVal (-6848)],VectorVal [IntegerVal 17160,IntegerVal 32768]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s32(UINT64_C(0xffffe5407fff51c4));
      arg2 = vcreate_s32(UINT64_C(0x0000800000004308));
      clear_neon_saturated();
      //  Expect: "result" = ffffffff00000000
      result = vcle_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0xffffffff00000000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_438() {

{
   {
      float32x2_t arg1;
      float32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcle_f32\", rettype = \"uint32x2_t\", argtypes = \"[float32x2_t,float32x2_t]\", vals = [VectorVal [FloatVal 0.11911267042160034,FloatVal 0.9773296117782593],VectorVal [FloatVal 0.1493215560913086,FloatVal 0.31313663721084595]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_f32(UINT64_C(0x3f7a32463df3f158));
      arg2 = vcreate_f32(UINT64_C(0x3ea053723e18e7c0));
      clear_neon_saturated();
      //  Expect: "result" = 00000000ffffffff
      result = vcle_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0x00000000ffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_439() {

{
   {
      uint8x8_t arg1;
      uint8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcle_u8\", rettype = \"uint8x8_t\", argtypes = \"[uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 128,IntegerVal 209,IntegerVal 255,IntegerVal 127,IntegerVal 72,IntegerVal 197,IntegerVal 128,IntegerVal 0],VectorVal [IntegerVal 127,IntegerVal 127,IntegerVal 0,IntegerVal 128,IntegerVal 92,IntegerVal 128,IntegerVal 197,IntegerVal 127]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u8(UINT64_C(0x0080c5487fffd180));
      arg2 = vcreate_u8(UINT64_C(0x7fc5805c80007f7f));
      clear_neon_saturated();
      //  Expect: "result" = ffff00ffff000000
      result = vcle_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0xffff00ffff000000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_440() {

{
   {
      uint16x4_t arg1;
      uint16x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcle_u16\", rettype = \"uint16x4_t\", argtypes = \"[uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 29616,IntegerVal 32768,IntegerVal 0,IntegerVal 62400],VectorVal [IntegerVal 65535,IntegerVal 32767,IntegerVal 65535,IntegerVal 65535]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u16(UINT64_C(0xf3c00000800073b0));
      arg2 = vcreate_u16(UINT64_C(0xffffffff7fffffff));
      clear_neon_saturated();
      //  Expect: "result" = ffffffff0000ffff
      result = vcle_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0xffffffff0000ffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_441() {

{
   {
      uint32x2_t arg1;
      uint32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcle_u32\", rettype = \"uint32x2_t\", argtypes = \"[uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 2147450880,IntegerVal 2147523193],VectorVal [IntegerVal 4294954796,IntegerVal 2147516416]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u32(UINT64_C(0x80009a797fff8000));
      arg2 = vcreate_u32(UINT64_C(0x80008000ffffcf2c));
      clear_neon_saturated();
      //  Expect: "result" = 00000000ffffffff
      result = vcle_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0x00000000ffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_442() {

{
   {
      int8x16_t arg1;
      int8x16_t arg2;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcleq_s8\", rettype = \"uint8x16_t\", argtypes = \"[int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal (-127),IntegerVal 127,IntegerVal 25,IntegerVal (-128),IntegerVal (-128),IntegerVal (-128),IntegerVal (-128),IntegerVal 0,IntegerVal (-128),IntegerVal 127,IntegerVal 127,IntegerVal 113,IntegerVal (-1),IntegerVal 0,IntegerVal (-59),IntegerVal (-1)],VectorVal [IntegerVal 127,IntegerVal 127,IntegerVal (-109),IntegerVal 0,IntegerVal (-72),IntegerVal 127,IntegerVal (-1),IntegerVal (-1),IntegerVal 90,IntegerVal (-128),IntegerVal 127,IntegerVal 127,IntegerVal (-128),IntegerVal (-1),IntegerVal 127,IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s8(vcreate_s8(UINT64_C(0x0080808080197f81)),
                         vcreate_s8(UINT64_C(0xffc500ff717f7f80)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0xffff7fb800937f7f)),
                         vcreate_s8(UINT64_C(0xff7fff807f7f805a)));
      clear_neon_saturated();
      //  Expect: "result" = ffff0000ffff00ff00ffffffff00ffff
      result = vcleq_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x00ffffffff00ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0xffff0000ffff00ff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_443() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcleq_s16\", rettype = \"uint16x8_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal (-1),IntegerVal (-32768),IntegerVal 32767,IntegerVal 0,IntegerVal (-1),IntegerVal (-1),IntegerVal (-1),IntegerVal (-1)],VectorVal [IntegerVal 0,IntegerVal (-18814),IntegerVal (-1),IntegerVal (-1),IntegerVal 32767,IntegerVal 32767,IntegerVal (-32768),IntegerVal (-31875)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x00007fff8000ffff)),
                          vcreate_s16(UINT64_C(0xffffffffffffffff)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0xffffffffb6820000)),
                          vcreate_s16(UINT64_C(0x837d80007fff7fff)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000ffffffff00000000ffffffff
      result = vcleq_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x00000000ffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x00000000ffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_444() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcleq_s32\", rettype = \"uint32x4_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal (-32769),IntegerVal 32768,IntegerVal (-32768),IntegerVal 2147450880],VectorVal [IntegerVal (-2147475798),IntegerVal 65535,IntegerVal (-2147432347),IntegerVal (-32768)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0x00008000ffff7fff)),
                          vcreate_s32(UINT64_C(0x7fff8000ffff8000)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x0000ffff80001eaa)),
                          vcreate_s32(UINT64_C(0xffff80008000c865)));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000ffffffff00000000
      result = vcleq_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0xffffffff00000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_445() {

{
   {
      float32x4_t arg1;
      float32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcleq_f32\", rettype = \"uint32x4_t\", argtypes = \"[float32x4_t,float32x4_t]\", vals = [VectorVal [FloatVal 0.4177969694137573,FloatVal 0.7051618695259094,FloatVal 0.13368189334869385,FloatVal 0.774517297744751],VectorVal [FloatVal 0.459153413772583,FloatVal 0.7842180132865906,FloatVal 0.9391838908195496,FloatVal 0.3144046664237976]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f32(vcreate_f32(UINT64_C(0x3f34857d3ed5e97c)),
                          vcreate_f32(UINT64_C(0x3f4646c43e08e3e8)));
      arg2 = vcombine_f32(vcreate_f32(UINT64_C(0x3f48c2833eeb1628)),
                          vcreate_f32(UINT64_C(0x3ea0f9a63f706e5b)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000ffffffffffffffffffffffff
      result = vcleq_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0xffffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0x00000000ffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_446() {

{
   {
      uint8x16_t arg1;
      uint8x16_t arg2;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcleq_u8\", rettype = \"uint8x16_t\", argtypes = \"[uint8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 127,IntegerVal 128,IntegerVal 0,IntegerVal 127,IntegerVal 166,IntegerVal 127,IntegerVal 127,IntegerVal 6,IntegerVal 128,IntegerVal 38,IntegerVal 127,IntegerVal 153,IntegerVal 127,IntegerVal 127,IntegerVal 128],VectorVal [IntegerVal 0,IntegerVal 81,IntegerVal 0,IntegerVal 128,IntegerVal 127,IntegerVal 128,IntegerVal 255,IntegerVal 255,IntegerVal 127,IntegerVal 130,IntegerVal 127,IntegerVal 255,IntegerVal 0,IntegerVal 244,IntegerVal 0,IntegerVal 59]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u8(vcreate_u8(UINT64_C(0x7f7fa67f00807f00)),
                         vcreate_u8(UINT64_C(0x807f7f997f268006)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0xffff807f80005100)),
                         vcreate_u8(UINT64_C(0x3b00f400ff7f827f)));
      clear_neon_saturated();
      //  Expect: "result" = 0000ff00ffffffffffff00ffff0000ff
      result = vcleq_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0xffff00ffff0000ff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0x0000ff00ffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_447() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcleq_u16\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 65535,IntegerVal 61669,IntegerVal 32768,IntegerVal 0,IntegerVal 32768,IntegerVal 54017,IntegerVal 39241],VectorVal [IntegerVal 397,IntegerVal 44066,IntegerVal 32768,IntegerVal 65535,IntegerVal 12171,IntegerVal 56957,IntegerVal 38871,IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x8000f0e5ffff7fff)),
                          vcreate_u16(UINT64_C(0x9949d30180000000)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0xffff8000ac22018d)),
                          vcreate_u16(UINT64_C(0x7fff97d7de7d2f8b)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000ffffffffffff000000000000
      result = vcleq_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0xffff000000000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x00000000ffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_448() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcleq_u32\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 65535,IntegerVal 2147450880,IntegerVal 9435,IntegerVal 0],VectorVal [IntegerVal 4294967295,IntegerVal 4294967295,IntegerVal 2845999104,IntegerVal 2147450879]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0x7fff80000000ffff)),
                          vcreate_u32(UINT64_C(0x00000000000024db)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0xffffffffffffffff)),
                          vcreate_u32(UINT64_C(0x7fff7fffa9a28000)));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffffffffffffffffffff
      result = vcleq_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0xffffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0xffffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_449() {

{
   {
      int64x1_t arg1;
      int64x1_t arg2;
      uint64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcle_s64\", rettype = \"uint64x1_t\", argtypes = \"[int64x1_t,int64x1_t]\", vals = [VectorVal [IntegerVal 2638124217989595135],VectorVal [IntegerVal (-137784698372097)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s64(UINT64_C(0x249c7fffb69fffff));
      arg2 = vcreate_s64(UINT64_C(0xffff82af7fff7fff));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vcle_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(result, 0);
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_450() {

{
   {
      uint64x1_t arg1;
      uint64x1_t arg2;
      uint64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcle_u64\", rettype = \"uint64x1_t\", argtypes = \"[uint64x1_t,uint64x1_t]\", vals = [VectorVal [IntegerVal 140740784776748],VectorVal [IntegerVal 9223372036854743039]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u64(UINT64_C(0x00008000c47b662c));
      arg2 = vcreate_u64(UINT64_C(0x7fffffffffff7fff));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffff
      result = vcle_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(result, 0);
      exp = UINT64_C(0xffffffffffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_451() {

{
   {
      float64x1_t arg1;
      float64x1_t arg2;
      uint64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcle_f64\", rettype = \"uint64x1_t\", argtypes = \"[float64x1_t,float64x1_t]\", vals = [VectorVal [FloatVal 0.1456712534569793],VectorVal [FloatVal 0.7979027675106829]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_f64(UINT64_C(0x3fc2a55b0ac853a8));
      arg2 = vcreate_f64(UINT64_C(0x3fe9886b627b14ae));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffff
      result = vcle_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(result, 0);
      exp = UINT64_C(0xffffffffffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_452() {

{
   {
      int64x2_t arg1;
      int64x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcleq_s64\", rettype = \"uint64x2_t\", argtypes = \"[int64x2_t,int64x2_t]\", vals = [VectorVal [IntegerVal (-4294967296),IntegerVal 281470681794309],VectorVal [IntegerVal 9223231295071453184,IntegerVal (-9223372034707324929)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0xffffffff00000000)),
                          vcreate_s64(UINT64_C(0x0000ffff0000c705)));
      arg2 = vcombine_s64(vcreate_s64(UINT64_C(0x7fff7fff00000000)),
                          vcreate_s64(UINT64_C(0x800000007fff7fff)));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000ffffffffffffffff
      result = vcleq_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0xffffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_453() {

{
   {
      uint64x2_t arg1;
      uint64x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcleq_u64\", rettype = \"uint64x2_t\", argtypes = \"[uint64x2_t,uint64x2_t]\", vals = [VectorVal [IntegerVal 18446603340516158844,IntegerVal 639172607],VectorVal [IntegerVal 18446603340516130815,IntegerVal 2541416513536]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0xffff8000ffffed7c)),
                          vcreate_u64(UINT64_C(0x000000002618ffff)));
      arg2 = vcombine_u64(vcreate_u64(UINT64_C(0xffff8000ffff7fff)),
                          vcreate_u64(UINT64_C(0x0000024fb83a8000)));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffff0000000000000000
      result = vcleq_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0xffffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_454() {

{
   {
      float64x2_t arg1;
      float64x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcleq_f64\", rettype = \"uint64x2_t\", argtypes = \"[float64x2_t,float64x2_t]\", vals = [VectorVal [FloatVal 0.6620606893815918,FloatVal 0.20173022309807231],VectorVal [FloatVal 0.23255616767045562,FloatVal 0.6383186186670216]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f64(vcreate_f64(UINT64_C(0x3fe52f99e61b8e8d)),
                          vcreate_f64(UINT64_C(0x3fc9d24bc36916ac)));
      arg2 = vcombine_f64(vcreate_f64(UINT64_C(0x3fcdc46687505874)),
                          vcreate_f64(UINT64_C(0x3fe46d1b2af349c0)));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffff0000000000000000
      result = vcleq_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0xffffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_455() {

{
   {
      int64_t arg1;
      int64_t arg2;
      uint64_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcled_s64\", rettype = \"uint64_t\", argtypes = \"[int64_t,int64_t]\", vals = [IntegerVal 140741783289855,IntegerVal (-9223231297218914104)], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = INT64_C(140741783289855);
      arg2 = INT64_C(-9223231297218914104);
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vcled_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_456() {

{
   {
      uint64_t arg1;
      uint64_t arg2;
      uint64_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcled_u64\", rettype = \"uint64_t\", argtypes = \"[uint64_t,uint64_t]\", vals = [IntegerVal 9223372034321874944,IntegerVal 8995658782893015039], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = UINT64_C(0x7fffffff69070000);
      arg2 = UINT64_C(0x7cd7000082f5ffff);
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vcled_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_457() {

{
   {
      float32_t arg1;
      float32_t arg2;
      uint32_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcles_f32\", rettype = \"uint32_t\", argtypes = \"[float32_t,float32_t]\", vals = [FloatVal 0.36730051040649414,FloatVal 0.4961974024772644], start_saturated = False}";
      int reported = 0;
      uint32_t got;
      uint32_t exp;
      arg1 = ((float32_t) 0.36730051040649414);
      arg2 = ((float32_t) 0.4961974024772644);
      clear_neon_saturated();
      //  Expect: "result" = ffffffff
      result = vcles_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 4294967295U;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIu32 " Got: %" PRIu32 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_458() {

{
   {
      float64_t arg1;
      float64_t arg2;
      uint64_t result;
      char* str1 = "ReproInfo2 {semantics = \"cle\", fnname = \"vcled_f64\", rettype = \"uint64_t\", argtypes = \"[float64_t,float64_t]\", vals = [FloatVal 0.4615627557681746,FloatVal 0.2548462912759485], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = 0.4615627557681746;
      arg2 = 0.2548462912759485;
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vcled_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_459() {

{
   {
      int8x8_t arg1;
      int8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgt_s8\", rettype = \"uint8x8_t\", argtypes = \"[int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal (-60),IntegerVal 0,IntegerVal (-128),IntegerVal (-1),IntegerVal (-1),IntegerVal 127,IntegerVal 127,IntegerVal (-1)],VectorVal [IntegerVal 127,IntegerVal 0,IntegerVal 127,IntegerVal 127,IntegerVal (-86),IntegerVal 127,IntegerVal (-122),IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s8(UINT64_C(0xff7f7fffff8000c4));
      arg2 = vcreate_s8(UINT64_C(0xff867faa7f7f007f));
      clear_neon_saturated();
      //  Expect: "result" = 00ff00ff00000000
      result = vcgt_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0x00ff00ff00000000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_460() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgt_s16\", rettype = \"uint16x4_t\", argtypes = \"[int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal (-32768),IntegerVal (-32768),IntegerVal 32767,IntegerVal 11244],VectorVal [IntegerVal 32767,IntegerVal (-32768),IntegerVal 0,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s16(UINT64_C(0x2bec7fff80008000));
      arg2 = vcreate_s16(UINT64_C(0x0000000080007fff));
      clear_neon_saturated();
      //  Expect: "result" = ffffffff00000000
      result = vcgt_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0xffffffff00000000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_461() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgt_s32\", rettype = \"uint32x2_t\", argtypes = \"[int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal (-2147418113),IntegerVal (-2147483648)],VectorVal [IntegerVal (-32768),IntegerVal (-65536)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s32(UINT64_C(0x800000008000ffff));
      arg2 = vcreate_s32(UINT64_C(0xffff0000ffff8000));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vcgt_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_462() {

{
   {
      float32x2_t arg1;
      float32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgt_f32\", rettype = \"uint32x2_t\", argtypes = \"[float32x2_t,float32x2_t]\", vals = [VectorVal [FloatVal 0.7434440851211548,FloatVal 0.2963656187057495],VectorVal [FloatVal 0.4449610710144043,FloatVal 3.983408212661743e-2]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_f32(UINT64_C(0x3e97bd3c3f3e525a));
      arg2 = vcreate_f32(UINT64_C(0x3d2329103ee3d1f0));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffff
      result = vcgt_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0xffffffffffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_463() {

{
   {
      uint8x8_t arg1;
      uint8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgt_u8\", rettype = \"uint8x8_t\", argtypes = \"[uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal 175,IntegerVal 127,IntegerVal 255,IntegerVal 0,IntegerVal 127],VectorVal [IntegerVal 255,IntegerVal 255,IntegerVal 134,IntegerVal 0,IntegerVal 0,IntegerVal 118,IntegerVal 128,IntegerVal 43]], start_saturated = True}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u8(UINT64_C(0x7f00ff7faf007f00));
      arg2 = vcreate_u8(UINT64_C(0x2b8076000086ffff));
      set_neon_saturated();
      //  Expect: "result" = ff00ffffff000000
      result = vcgt_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0xff00ffffff000000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_464() {

{
   {
      uint16x4_t arg1;
      uint16x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgt_u16\", rettype = \"uint16x4_t\", argtypes = \"[uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 65535,IntegerVal 6336,IntegerVal 65535],VectorVal [IntegerVal 32767,IntegerVal 0,IntegerVal 32768,IntegerVal 32768]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u16(UINT64_C(0xffff18c0ffff0000));
      arg2 = vcreate_u16(UINT64_C(0x8000800000007fff));
      clear_neon_saturated();
      //  Expect: "result" = ffff0000ffff0000
      result = vcgt_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0xffff0000ffff0000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_465() {

{
   {
      uint32x2_t arg1;
      uint32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgt_u32\", rettype = \"uint32x2_t\", argtypes = \"[uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 2147418112,IntegerVal 2147450880],VectorVal [IntegerVal 2147549183,IntegerVal 4294967295]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u32(UINT64_C(0x7fff80007fff0000));
      arg2 = vcreate_u32(UINT64_C(0xffffffff8000ffff));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vcgt_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_466() {

{
   {
      int8x16_t arg1;
      int8x16_t arg2;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgtq_s8\", rettype = \"uint8x16_t\", argtypes = \"[int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 127,IntegerVal 0,IntegerVal 18,IntegerVal (-1),IntegerVal (-1),IntegerVal 0,IntegerVal (-128),IntegerVal (-128),IntegerVal 127,IntegerVal 0,IntegerVal 0,IntegerVal (-128),IntegerVal 127,IntegerVal (-1),IntegerVal (-128)],VectorVal [IntegerVal 0,IntegerVal (-128),IntegerVal (-114),IntegerVal 59,IntegerVal 127,IntegerVal (-128),IntegerVal (-128),IntegerVal 0,IntegerVal (-1),IntegerVal 0,IntegerVal 0,IntegerVal (-128),IntegerVal (-128),IntegerVal 0,IntegerVal (-128),IntegerVal (-75)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s8(vcreate_s8(UINT64_C(0x8000ffff12007f00)),
                         vcreate_s8(UINT64_C(0x80ff7f8000007f80)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0x0080807f3b8e8000)),
                         vcreate_s8(UINT64_C(0xb5800080800000ff)));
      clear_neon_saturated();
      //  Expect: "result" = 00ffff00ff00ff0000ffff0000ffff00
      result = vcgtq_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x00ffff0000ffff00);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0x00ffff00ff00ff00);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_467() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgtq_s16\", rettype = \"uint16x8_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal 32767,IntegerVal 0,IntegerVal 0,IntegerVal (-1),IntegerVal (-1),IntegerVal 1874,IntegerVal 0,IntegerVal 0],VectorVal [IntegerVal 0,IntegerVal (-1),IntegerVal 32767,IntegerVal (-1),IntegerVal (-1),IntegerVal 32767,IntegerVal (-32768),IntegerVal 32767]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0xffff000000007fff)),
                          vcreate_s16(UINT64_C(0x000000000752ffff)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0xffff7fffffff0000)),
                          vcreate_s16(UINT64_C(0x7fff80007fffffff)));
      clear_neon_saturated();
      //  Expect: "result" = 0000ffff0000000000000000ffffffff
      result = vcgtq_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x00000000ffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x0000ffff00000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_468() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgtq_s32\", rettype = \"uint32x4_t\", argtypes = \"[int32x4_t,int32x4_t]\", vals = [VectorVal [IntegerVal (-20220),IntegerVal (-1109721725),IntegerVal 65535,IntegerVal 65535],VectorVal [IntegerVal 32767,IntegerVal 1541636096,IntegerVal 2147483647,IntegerVal (-2147418113)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s32(vcreate_s32(UINT64_C(0xbddafd83ffffb104)),
                          vcreate_s32(UINT64_C(0x0000ffff0000ffff)));
      arg2 = vcombine_s32(vcreate_s32(UINT64_C(0x5be3800000007fff)),
                          vcreate_s32(UINT64_C(0x8000ffff7fffffff)));
      clear_neon_saturated();
      //  Expect: "result" = ffffffff000000000000000000000000
      result = vcgtq_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0xffffffff00000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_469() {

{
   {
      float32x4_t arg1;
      float32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgtq_f32\", rettype = \"uint32x4_t\", argtypes = \"[float32x4_t,float32x4_t]\", vals = [VectorVal [FloatVal 1.7205119132995605e-2,FloatVal 0.8866116404533386,FloatVal 0.29345226287841797,FloatVal 0.8003382086753845],VectorVal [FloatVal 6.560403108596802e-2,FloatVal 0.5092384815216064,FloatVal 0.16813433170318604,FloatVal 0.15904802083969116]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f32(vcreate_f32(UINT64_C(0x3f62f8fb3c8cf1c0)),
                          vcreate_f32(UINT64_C(0x3f4ce2f73e963f60)));
      arg2 = vcombine_f32(vcreate_f32(UINT64_C(0x3f025d743d865b68)),
                          vcreate_f32(UINT64_C(0x3e22dd7c3e2c2b68)));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffffffffffff00000000
      result = vcgtq_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0xffffffff00000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0xffffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_470() {

{
   {
      uint8x16_t arg1;
      uint8x16_t arg2;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgtq_u8\", rettype = \"uint8x16_t\", argtypes = \"[uint8x16_t,uint8x16_t]\", vals = [VectorVal [IntegerVal 127,IntegerVal 255,IntegerVal 0,IntegerVal 0,IntegerVal 162,IntegerVal 45,IntegerVal 128,IntegerVal 0,IntegerVal 53,IntegerVal 0,IntegerVal 127,IntegerVal 127,IntegerVal 127,IntegerVal 127,IntegerVal 255,IntegerVal 0],VectorVal [IntegerVal 0,IntegerVal 127,IntegerVal 255,IntegerVal 255,IntegerVal 0,IntegerVal 0,IntegerVal 255,IntegerVal 128,IntegerVal 255,IntegerVal 128,IntegerVal 255,IntegerVal 255,IntegerVal 128,IntegerVal 127,IntegerVal 127,IntegerVal 255]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u8(vcreate_u8(UINT64_C(0x00802da20000ff7f)),
                         vcreate_u8(UINT64_C(0x00ff7f7f7f7f0035)));
      arg2 = vcombine_u8(vcreate_u8(UINT64_C(0x80ff0000ffff7f00)),
                         vcreate_u8(UINT64_C(0xff7f7f80ffff80ff)));
      clear_neon_saturated();
      //  Expect: "result" = 00ff0000000000000000ffff0000ffff
      result = vcgtq_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x0000ffff0000ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0x00ff000000000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_471() {

{
   {
      uint16x8_t arg1;
      uint16x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgtq_u16\", rettype = \"uint16x8_t\", argtypes = \"[uint16x8_t,uint16x8_t]\", vals = [VectorVal [IntegerVal 65535,IntegerVal 32767,IntegerVal 46697,IntegerVal 32606,IntegerVal 0,IntegerVal 32768,IntegerVal 36854,IntegerVal 65535],VectorVal [IntegerVal 0,IntegerVal 9011,IntegerVal 32768,IntegerVal 32768,IntegerVal 0,IntegerVal 65535,IntegerVal 46776,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u16(vcreate_u16(UINT64_C(0x7f5eb6697fffffff)),
                          vcreate_u16(UINT64_C(0xffff8ff680000000)));
      arg2 = vcombine_u16(vcreate_u16(UINT64_C(0x8000800023330000)),
                          vcreate_u16(UINT64_C(0x0000b6b8ffff0000)));
      clear_neon_saturated();
      //  Expect: "result" = ffff0000000000000000ffffffffffff
      result = vcgtq_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x0000ffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0xffff000000000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_472() {

{
   {
      uint32x4_t arg1;
      uint32x4_t arg2;
      uint32x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgtq_u32\", rettype = \"uint32x4_t\", argtypes = \"[uint32x4_t,uint32x4_t]\", vals = [VectorVal [IntegerVal 32768,IntegerVal 4294934528,IntegerVal 2147549183,IntegerVal 32768],VectorVal [IntegerVal 0,IntegerVal 65535,IntegerVal 4294934527,IntegerVal 0]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u32(vcreate_u32(UINT64_C(0xffff800000008000)),
                          vcreate_u32(UINT64_C(0x000080008000ffff)));
      arg2 = vcombine_u32(vcreate_u32(UINT64_C(0x0000ffff00000000)),
                          vcreate_u32(UINT64_C(0x00000000ffff7fff)));
      clear_neon_saturated();
      //  Expect: "result" = ffffffff00000000ffffffffffffffff
      result = vcgtq_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 0);
         exp = UINT64_C(0xffffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u32(result), 1);
         exp = UINT64_C(0xffffffff00000000);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_473() {

{
   {
      int64x1_t arg1;
      int64x1_t arg2;
      uint64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgt_s64\", rettype = \"uint64x1_t\", argtypes = \"[int64x1_t,int64x1_t]\", vals = [VectorVal [IntegerVal (-140735340904449)],VectorVal [IntegerVal (-140733193420800)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s64(UINT64_C(0xffff80007fff7fff));
      arg2 = vcreate_s64(UINT64_C(0xffff8000ffff8000));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vcgt_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(result, 0);
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_474() {

{
   {
      uint64x1_t arg1;
      uint64x1_t arg2;
      uint64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgt_u64\", rettype = \"uint64x1_t\", argtypes = \"[uint64x1_t,uint64x1_t]\", vals = [VectorVal [IntegerVal 14500634390373105663],VectorVal [IntegerVal 9223620391191202737]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u64(UINT64_C(0xc93c9a2680007fff));
      arg2 = vcreate_u64(UINT64_C(0x8000e1e080004bb1));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffff
      result = vcgt_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(result, 0);
      exp = UINT64_C(0xffffffffffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_475() {

{
   {
      float64x1_t arg1;
      float64x1_t arg2;
      uint64x1_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgt_f64\", rettype = \"uint64x1_t\", argtypes = \"[float64x1_t,float64x1_t]\", vals = [VectorVal [FloatVal 0.6320469607869017],VectorVal [FloatVal 0.38537476109418867]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_f64(UINT64_C(0x3fe439ba8c43b5c2));
      arg2 = vcreate_f64(UINT64_C(0x3fd8a9fae6e69d58));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffff
      result = vcgt_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(result, 0);
      exp = UINT64_C(0xffffffffffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_476() {

{
   {
      int64x2_t arg1;
      int64x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgtq_s64\", rettype = \"uint64x2_t\", argtypes = \"[int64x2_t,int64x2_t]\", vals = [VectorVal [IntegerVal 9223231295071453184,IntegerVal 9223372036854743039],VectorVal [IntegerVal 281474976677887,IntegerVal 4294967295]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s64(vcreate_s64(UINT64_C(0x7fff7fff00000000)),
                          vcreate_s64(UINT64_C(0x7fffffffffff7fff)));
      arg2 = vcombine_s64(vcreate_s64(UINT64_C(0x0000ffffffff7fff)),
                          vcreate_s64(UINT64_C(0x00000000ffffffff)));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffffffffffffffffffff
      result = vcgtq_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0xffffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = UINT64_C(0xffffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_477() {

{
   {
      uint64x2_t arg1;
      uint64x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgtq_u64\", rettype = \"uint64x2_t\", argtypes = \"[uint64x2_t,uint64x2_t]\", vals = [VectorVal [IntegerVal 18446603336221196288,IntegerVal 32768],VectorVal [IntegerVal 9223512776310095872,IntegerVal 8012185212068757504]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_u64(vcreate_u64(UINT64_C(0xffff800000000000)),
                          vcreate_u64(UINT64_C(0x0000000000008000)));
      arg2 = vcombine_u64(vcreate_u64(UINT64_C(0x80008000753d8000)),
                          vcreate_u64(UINT64_C(0x6f30ffffffff0000)));
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000ffffffffffffffff
      result = vcgtq_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = UINT64_C(0xffffffffffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_478() {

{
   {
      float64x2_t arg1;
      float64x2_t arg2;
      uint64x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgtq_f64\", rettype = \"uint64x2_t\", argtypes = \"[float64x2_t,float64x2_t]\", vals = [VectorVal [FloatVal 9.367823300401235e-2,FloatVal 0.4725559583068679],VectorVal [FloatVal 0.29986310324146526,FloatVal 0.9933233815736151]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_f64(vcreate_f64(UINT64_C(0x3fb7fb4bf3196bc8)),
                          vcreate_f64(UINT64_C(0x3fde3e5b589d4ed8)));
      arg2 = vcombine_f64(vcreate_f64(UINT64_C(0x3fd330f5036cbf1e)),
                          vcreate_f64(UINT64_C(0x3fefc94e1dc6beec)));
      clear_neon_saturated();
      //  Expect: "result" = 00000000000000000000000000000000
      result = vcgtq_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 0);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(result, 1);
         exp = 0;
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_479() {

{
   {
      int64_t arg1;
      int64_t arg2;
      uint64_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgtd_s64\", rettype = \"uint64_t\", argtypes = \"[int64_t,int64_t]\", vals = [IntegerVal 2147489170,IntegerVal 281470681776128], start_saturated = True}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = INT64_C(2147489170);
      arg2 = INT64_C(281470681776128);
      set_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vcgtd_s64(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = result;
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_480() {

{
   {
      uint64_t arg1;
      uint64_t arg2;
      uint64_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgtd_u64\", rettype = \"uint64_t\", argtypes = \"[uint64_t,uint64_t]\", vals = [IntegerVal 9223471362268495872,IntegerVal 9223090564025548799], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = UINT64_C(0x80005a5600008000);
      arg2 = UINT64_C(0x7fff00007fffffff);
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffff
      result = vcgtd_u64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = UINT64_C(0xffffffffffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_481() {

{
   {
      float32_t arg1;
      float32_t arg2;
      uint32_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgts_f32\", rettype = \"uint32_t\", argtypes = \"[float32_t,float32_t]\", vals = [FloatVal 0.25199735164642334,FloatVal 0.8890627026557922], start_saturated = False}";
      int reported = 0;
      uint32_t got;
      uint32_t exp;
      arg1 = ((float32_t) 0.25199735164642334);
      arg2 = ((float32_t) 0.8890627026557922);
      clear_neon_saturated();
      //  Expect: "result" = 00000000
      result = vcgts_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %" PRIu32 " Got: %" PRIu32 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_482() {

{
   {
      float64_t arg1;
      float64_t arg2;
      uint64_t result;
      char* str1 = "ReproInfo2 {semantics = \"cgt\", fnname = \"vcgtd_f64\", rettype = \"uint64_t\", argtypes = \"[float64_t,float64_t]\", vals = [FloatVal 0.6069491456622899,FloatVal 0.972212956284481], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = 0.6069491456622899;
      arg2 = 0.972212956284481;
      clear_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vcgtd_f64(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = result;
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_483() {

{
   {
      int8x8_t arg1;
      int8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"clt\", fnname = \"vclt_s8\", rettype = \"uint8x8_t\", argtypes = \"[int8x8_t,int8x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 127,IntegerVal (-128),IntegerVal (-122),IntegerVal (-1),IntegerVal (-1),IntegerVal (-1),IntegerVal 0],VectorVal [IntegerVal (-1),IntegerVal 127,IntegerVal (-1),IntegerVal (-1),IntegerVal (-1),IntegerVal (-128),IntegerVal 127,IntegerVal (-128)]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s8(UINT64_C(0x00ffffff86807f00));
      arg2 = vcreate_s8(UINT64_C(0x807f80ffffff7fff));
      clear_neon_saturated();
      //  Expect: "result" = 00ff0000ffff0000
      result = vclt_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0x00ff0000ffff0000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_484() {

{
   {
      int16x4_t arg1;
      int16x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"clt\", fnname = \"vclt_s16\", rettype = \"uint16x4_t\", argtypes = \"[int16x4_t,int16x4_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal 32767,IntegerVal 0,IntegerVal 0],VectorVal [IntegerVal (-32768),IntegerVal (-9536),IntegerVal (-32768),IntegerVal (-32768)]], start_saturated = True}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s16(UINT64_C(0x000000007fff0000));
      arg2 = vcreate_s16(UINT64_C(0x80008000dac08000));
      set_neon_saturated();
      //  Expect: "result" = 0000000000000000
      result = vclt_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = 0;
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_485() {

{
   {
      int32x2_t arg1;
      int32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"clt\", fnname = \"vclt_s32\", rettype = \"uint32x2_t\", argtypes = \"[int32x2_t,int32x2_t]\", vals = [VectorVal [IntegerVal 2147418112,IntegerVal 65535],VectorVal [IntegerVal 2147450880,IntegerVal 869335039]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_s32(UINT64_C(0x0000ffff7fff0000));
      arg2 = vcreate_s32(UINT64_C(0x33d0ffff7fff8000));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffff
      result = vclt_s32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0xffffffffffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_486() {

{
   {
      float32x2_t arg1;
      float32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"clt\", fnname = \"vclt_f32\", rettype = \"uint32x2_t\", argtypes = \"[float32x2_t,float32x2_t]\", vals = [VectorVal [FloatVal 0.5922384858131409,FloatVal 0.5808623433113098],VectorVal [FloatVal 0.8279045224189758,FloatVal 0.9200665354728699]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_f32(UINT64_C(0x3f14b3653f179cf1));
      arg2 = vcreate_f32(UINT64_C(0x3f6b897b3f53f18d));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffff
      result = vclt_f32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0xffffffffffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_487() {

{
   {
      uint8x8_t arg1;
      uint8x8_t arg2;
      uint8x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"clt\", fnname = \"vclt_u8\", rettype = \"uint8x8_t\", argtypes = \"[uint8x8_t,uint8x8_t]\", vals = [VectorVal [IntegerVal 128,IntegerVal 215,IntegerVal 136,IntegerVal 255,IntegerVal 0,IntegerVal 0,IntegerVal 128,IntegerVal 127],VectorVal [IntegerVal 255,IntegerVal 127,IntegerVal 127,IntegerVal 127,IntegerVal 0,IntegerVal 0,IntegerVal 0,IntegerVal 0]], start_saturated = True}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u8(UINT64_C(0x7f800000ff88d780));
      arg2 = vcreate_u8(UINT64_C(0x000000007f7f7fff));
      set_neon_saturated();
      //  Expect: "result" = 00000000000000ff
      result = vclt_u8(arg1, arg2);
      if((test_saturation(get_neon_saturated_inv())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Didn't get expected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u8(result), 0);
      exp = UINT64_C(0x00000000000000ff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_488() {

{
   {
      uint16x4_t arg1;
      uint16x4_t arg2;
      uint16x4_t result;
      char* str1 = "ReproInfo2 {semantics = \"clt\", fnname = \"vclt_u16\", rettype = \"uint16x4_t\", argtypes = \"[uint16x4_t,uint16x4_t]\", vals = [VectorVal [IntegerVal 32768,IntegerVal 32768,IntegerVal 65535,IntegerVal 13147],VectorVal [IntegerVal 32768,IntegerVal 65535,IntegerVal 32767,IntegerVal 2808]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u16(UINT64_C(0x335bffff80008000));
      arg2 = vcreate_u16(UINT64_C(0x0af87fffffff8000));
      clear_neon_saturated();
      //  Expect: "result" = 00000000ffff0000
      result = vclt_u16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u16(result), 0);
      exp = UINT64_C(0x00000000ffff0000);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_489() {

{
   {
      uint32x2_t arg1;
      uint32x2_t arg2;
      uint32x2_t result;
      char* str1 = "ReproInfo2 {semantics = \"clt\", fnname = \"vclt_u32\", rettype = \"uint32x2_t\", argtypes = \"[uint32x2_t,uint32x2_t]\", vals = [VectorVal [IntegerVal 516358144,IntegerVal 2147549183],VectorVal [IntegerVal 2147450879,IntegerVal 3261156552]], start_saturated = False}";
      int reported = 0;
      uint64_t got;
      uint64_t exp;
      arg1 = vcreate_u32(UINT64_C(0x8000ffff1ec70000));
      arg2 = vcreate_u32(UINT64_C(0xc2614cc87fff7fff));
      clear_neon_saturated();
      //  Expect: "result" = ffffffffffffffff
      result = vclt_u32(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      got = vget_lane_u64(vreinterpret_u64_u32(result), 0);
      exp = UINT64_C(0xffffffffffffffff);
      if((exp != got))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                   "   ",
                   exp,
                   got);
         }
   }
}
}
void dotests_490() {

{
   {
      int8x16_t arg1;
      int8x16_t arg2;
      uint8x16_t result;
      char* str1 = "ReproInfo2 {semantics = \"clt\", fnname = \"vcltq_s8\", rettype = \"uint8x16_t\", argtypes = \"[int8x16_t,int8x16_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal (-128),IntegerVal 0,IntegerVal 127,IntegerVal (-128),IntegerVal (-1),IntegerVal 127,IntegerVal 112,IntegerVal 0,IntegerVal 0,IntegerVal (-66),IntegerVal 0,IntegerVal (-128),IntegerVal 0,IntegerVal 91,IntegerVal (-1)],VectorVal [IntegerVal 127,IntegerVal (-128),IntegerVal 0,IntegerVal 72,IntegerVal (-128),IntegerVal (-1),IntegerVal 0,IntegerVal (-115),IntegerVal (-128),IntegerVal 127,IntegerVal 66,IntegerVal (-128),IntegerVal (-15),IntegerVal (-128),IntegerVal (-1),IntegerVal 59]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s8(vcreate_s8(UINT64_C(0x707fff807f008000)),
                         vcreate_s8(UINT64_C(0xff5b008000be0000)));
      arg2 = vcombine_s8(vcreate_s8(UINT64_C(0x8d00ff804800807f)),
                         vcreate_s8(UINT64_C(0x3bff80f180427f80)));
      clear_neon_saturated();
      //  Expect: "result" = ff0000ff00ffff0000000000000000ff
      result = vcltq_s8(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 0);
         exp = UINT64_C(0x00000000000000ff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u8(result), 1);
         exp = UINT64_C(0xff0000ff00ffff00);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_491() {

{
   {
      int16x8_t arg1;
      int16x8_t arg2;
      uint16x8_t result;
      char* str1 = "ReproInfo2 {semantics = \"clt\", fnname = \"vcltq_s16\", rettype = \"uint16x8_t\", argtypes = \"[int16x8_t,int16x8_t]\", vals = [VectorVal [IntegerVal 0,IntegerVal (-32768),IntegerVal 7151,IntegerVal 25357,IntegerVal (-1),IntegerVal 0,IntegerVal 32767,IntegerVal 17221],VectorVal [IntegerVal 32767,IntegerVal (-1),IntegerVal 0,IntegerVal (-1),IntegerVal 32767,IntegerVal (-1),IntegerVal (-1),IntegerVal (-1)]], start_saturated = False}";
      int reported = 0;
      arg1 = vcombine_s16(vcreate_s16(UINT64_C(0x630d1bef80000000)),
                          vcreate_s16(UINT64_C(0x43457fff0000ffff)));
      arg2 = vcombine_s16(vcreate_s16(UINT64_C(0xffff0000ffff7fff)),
                          vcreate_s16(UINT64_C(0xffffffffffff7fff)));
      clear_neon_saturated();
      //  Expect: "result" = 000000000000ffff00000000ffffffff
      result = vcltq_s16(arg1, arg2);
      if((test_saturation(get_neon_saturated())))
         {
            if(reported == 0)
               {
                  printf("%s\n", str1);
                  reported = 1;
               }
            failed = 1;
            printf("%s\n", "   Got unexpected saturation");
         }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 0);
         exp = UINT64_C(0x00000000ffffffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   Low part ",
                      exp,
                      got);
            }
      }
      {
         uint64_t got;
         uint64_t exp;
         got = vgetq_lane_u64(vreinterpretq_u64_u16(result), 1);
         exp = UINT64_C(0x000000000000ffff);
         if((exp != got))
            {
               if(reported == 0)
                  {
                     printf("%s\n", str1);
                     reported = 1;
                  }
               failed = 1;
               printf("%sExpected: %016" PRIx64 " Got: %016" PRIx64 "\n",
                      "   High part ",
                      exp,
                      got);
            }
      }
   }
}
}
void dotests_492() {

{
   {
      int32x4_t arg1;
      int32x4_t arg2;
      uint32x