//===--- large-array.c --- Test Cases for Bit Accurate Types --------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
//
// This is used to test large local arrays. Some local arrays are
// partially initilized.
//
//===----------------------------------------------------------------------===//


#include <stdio.h>

typedef int __attribute__ ((bitwidth(13))) int13;


int13 test(int13 x)
{
  const int13 XX[1000] = { 0, 0 };
  const char S [1000] = "foo";

  const int13 array[] = {
    17, 53, 523, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
    17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
    17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
    17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
    17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
    17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
    17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
    17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
    17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
    17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
    17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
    17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
    17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
    17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
    17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
    17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
    17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
    17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
    17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
    17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 17, 23, 123, 123, 49, 
  };
  return array[x];
} 

int main()
{
  if(test(1) != 53)
    printf("error\n");
  if(test(2) != 523)
    printf("error2\n");
  return 0;
}
