/*
 * utils.h - Some utility functions common to several applications
 *
 * This file is a part of the NetBench suite by Gokhan Memik
 *
 * This source file is distributed "as is" in the hope that it will be
 * useful.  The suite comes with no warranty, and no author or
 * distributor accepts any responsibility for the consequences of its
 * use. 
 * 
 * You are welcome to use, share and improve this
 * source file.  You are forbidden to forbid anyone else to use, share
 * and improve what you give them.
 *
 */

#ifdef __GNUC__
/* declare a fatal run-time error, calls fatal hook function */
#define fatal(fmt, args...)	\
  _fatal(__FILE__, __FUNCTION__, __LINE__, fmt, ## args)

void
_fatal(char *file, char *func, int line, char *fmt, ...)
__attribute__ ((noreturn));
#else 
void fatal(char *fmt, ...);
#endif


