/*************************************************************************
 *
 *        PathFinder: finding a series of labeled nodes within a
 *                two-layer directed, cyclic graph.
 *               Copyright (2013) Sandia Corporation
 *
 * Copyright (2013) Sandia Corporation. Under the terms of Contract 
 * DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government 
 * retains certain rights in this software.
 *
 * This file is part of PathFinder.
 * 
 * PathFinder is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * PathFinder is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PathFinder.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Questions? Contact J. Brian Rigdon (jbrigdo@sandia.gov)
 *
 */
 
/*
 * graphGen.h
 *
 *  Created on: Aug 2, 2013
 *      Author: J. Brian Rigdon
 */

#ifndef GRAPHGEN_H
#define GRAPHGEN_H

#include "graph.h"

typedef enum { endNodesOnly, labeledNodes, completePath } BuildType;

Graph *buildGraphFromPaths(NodeVecVec **pathList, BuildType build);

/* Write the given graph to a file */
bool exportGraph(Graph *graph, char *fileName);




#endif /* GRAPHGEN_H_ */
