// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: c_compiler -c %s -I "common" -o %t2.o
// RUN: linker -o %t1%exeext  %t1.o %t2.o
// RUN: runtool %t1%exeext | checker "TEST PASSED"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"

struct  Ul_BFu8i_BFu31ll  {
  __tsu64 v1;
  unsigned int v2:8;
  __tsu64 v3:31;
};
//SIG(1 Ul_BFu8i_BFu31ll) C1{ FL Fi:8 FL:31}



static void Test_Ul_BFu8i_BFu31ll()
{
  {
    init_simple_test("Ul_BFu8i_BFu31ll");
    static STRUCT_IF_C Ul_BFu8i_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "Ul_BFu8i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "Ul_BFu8i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu31ll, Ul_BFu8i_BFu31ll)
//============================================================================


struct  Ul_BFu8i_BFu32i  {
  __tsu64 v1;
  unsigned int v2:8;
  unsigned int v3:32;
};
//SIG(1 Ul_BFu8i_BFu32i) C1{ FL Fi:8 Fi:32}



static void Test_Ul_BFu8i_BFu32i()
{
  {
    init_simple_test("Ul_BFu8i_BFu32i");
    static STRUCT_IF_C Ul_BFu8i_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_BFu8i_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_BFu8i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu32i, Ul_BFu8i_BFu32i)
//============================================================================


struct  Ul_BFu8i_BFu32ll  {
  __tsu64 v1;
  unsigned int v2:8;
  __tsu64 v3:32;
};
//SIG(1 Ul_BFu8i_BFu32ll) C1{ FL Fi:8 FL:32}



static void Test_Ul_BFu8i_BFu32ll()
{
  {
    init_simple_test("Ul_BFu8i_BFu32ll");
    static STRUCT_IF_C Ul_BFu8i_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "Ul_BFu8i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "Ul_BFu8i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu32ll, Ul_BFu8i_BFu32ll)
//============================================================================


struct  Ul_BFu8i_BFu33  {
  __tsu64 v1;
  unsigned int v2:8;
  __tsu64 v3:33;
};
//SIG(1 Ul_BFu8i_BFu33) C1{ FL Fi:8 FL:33}



static void Test_Ul_BFu8i_BFu33()
{
  {
    init_simple_test("Ul_BFu8i_BFu33");
    static STRUCT_IF_C Ul_BFu8i_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "Ul_BFu8i_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "Ul_BFu8i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu33, Ul_BFu8i_BFu33)
//============================================================================


struct  Ul_BFu8i_BFu7c  {
  __tsu64 v1;
  unsigned int v2:8;
  unsigned char v3:7;
};
//SIG(1 Ul_BFu8i_BFu7c) C1{ FL Fi:8 Fc:7}



static void Test_Ul_BFu8i_BFu7c()
{
  {
    init_simple_test("Ul_BFu8i_BFu7c");
    static STRUCT_IF_C Ul_BFu8i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8i_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu7c, Ul_BFu8i_BFu7c)
//============================================================================


struct  Ul_BFu8i_BFu7i  {
  __tsu64 v1;
  unsigned int v2:8;
  unsigned int v3:7;
};
//SIG(1 Ul_BFu8i_BFu7i) C1{ FL Fi:8 Fi:7}



static void Test_Ul_BFu8i_BFu7i()
{
  {
    init_simple_test("Ul_BFu8i_BFu7i");
    static STRUCT_IF_C Ul_BFu8i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8i_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu7i, Ul_BFu8i_BFu7i)
//============================================================================


struct  Ul_BFu8i_BFu7ll  {
  __tsu64 v1;
  unsigned int v2:8;
  __tsu64 v3:7;
};
//SIG(1 Ul_BFu8i_BFu7ll) C1{ FL Fi:8 FL:7}



static void Test_Ul_BFu8i_BFu7ll()
{
  {
    init_simple_test("Ul_BFu8i_BFu7ll");
    static STRUCT_IF_C Ul_BFu8i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu7ll, Ul_BFu8i_BFu7ll)
//============================================================================


struct  Ul_BFu8i_BFu7s  {
  __tsu64 v1;
  unsigned int v2:8;
  unsigned short v3:7;
};
//SIG(1 Ul_BFu8i_BFu7s) C1{ FL Fi:8 Fs:7}



static void Test_Ul_BFu8i_BFu7s()
{
  {
    init_simple_test("Ul_BFu8i_BFu7s");
    static STRUCT_IF_C Ul_BFu8i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8i_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu7s, Ul_BFu8i_BFu7s)
//============================================================================


struct  Ul_BFu8i_BFu8c  {
  __tsu64 v1;
  unsigned int v2:8;
  unsigned char v3:8;
};
//SIG(1 Ul_BFu8i_BFu8c) C1{ FL Fi:8 Fc:8}



static void Test_Ul_BFu8i_BFu8c()
{
  {
    init_simple_test("Ul_BFu8i_BFu8c");
    static STRUCT_IF_C Ul_BFu8i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8i_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu8c, Ul_BFu8i_BFu8c)
//============================================================================


struct  Ul_BFu8i_BFu8i  {
  __tsu64 v1;
  unsigned int v2:8;
  unsigned int v3:8;
};
//SIG(1 Ul_BFu8i_BFu8i) C1{ FL Fi:8 Fi:8}



static void Test_Ul_BFu8i_BFu8i()
{
  {
    init_simple_test("Ul_BFu8i_BFu8i");
    static STRUCT_IF_C Ul_BFu8i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8i_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu8i, Ul_BFu8i_BFu8i)
//============================================================================


struct  Ul_BFu8i_BFu8ll  {
  __tsu64 v1;
  unsigned int v2:8;
  __tsu64 v3:8;
};
//SIG(1 Ul_BFu8i_BFu8ll) C1{ FL Fi:8 FL:8}



static void Test_Ul_BFu8i_BFu8ll()
{
  {
    init_simple_test("Ul_BFu8i_BFu8ll");
    static STRUCT_IF_C Ul_BFu8i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu8ll, Ul_BFu8i_BFu8ll)
//============================================================================


struct  Ul_BFu8i_BFu8s  {
  __tsu64 v1;
  unsigned int v2:8;
  unsigned short v3:8;
};
//SIG(1 Ul_BFu8i_BFu8s) C1{ FL Fi:8 Fs:8}



static void Test_Ul_BFu8i_BFu8s()
{
  {
    init_simple_test("Ul_BFu8i_BFu8s");
    static STRUCT_IF_C Ul_BFu8i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8i_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu8s, Ul_BFu8i_BFu8s)
//============================================================================


struct  Ul_BFu8i_BFu9i  {
  __tsu64 v1;
  unsigned int v2:8;
  unsigned int v3:9;
};
//SIG(1 Ul_BFu8i_BFu9i) C1{ FL Fi:8 Fi:9}



static void Test_Ul_BFu8i_BFu9i()
{
  {
    init_simple_test("Ul_BFu8i_BFu9i");
    static STRUCT_IF_C Ul_BFu8i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_BFu8i_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_BFu8i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu9i, Ul_BFu8i_BFu9i)
//============================================================================


struct  Ul_BFu8i_BFu9ll  {
  __tsu64 v1;
  unsigned int v2:8;
  __tsu64 v3:9;
};
//SIG(1 Ul_BFu8i_BFu9ll) C1{ FL Fi:8 FL:9}



static void Test_Ul_BFu8i_BFu9ll()
{
  {
    init_simple_test("Ul_BFu8i_BFu9ll");
    static STRUCT_IF_C Ul_BFu8i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_BFu8i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_BFu8i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu9ll, Ul_BFu8i_BFu9ll)
//============================================================================


struct  Ul_BFu8i_BFu9s  {
  __tsu64 v1;
  unsigned int v2:8;
  unsigned short v3:9;
};
//SIG(1 Ul_BFu8i_BFu9s) C1{ FL Fi:8 Fs:9}



static void Test_Ul_BFu8i_BFu9s()
{
  {
    init_simple_test("Ul_BFu8i_BFu9s");
    static STRUCT_IF_C Ul_BFu8i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_BFu8i_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_BFu8i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_BFu9s, Ul_BFu8i_BFu9s)
//============================================================================


struct  Ul_BFu8i_C  {
  __tsu64 v1;
  unsigned int v2:8;
  char v3;
};
//SIG(1 Ul_BFu8i_C) C1{ FL Fi:8 Fc}



static void Test_Ul_BFu8i_C()
{
  {
    init_simple_test("Ul_BFu8i_C");
    static STRUCT_IF_C Ul_BFu8i_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_C");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_C");
    check_field_offset(lv, v3, 9, "Ul_BFu8i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_C, Ul_BFu8i_C)
//============================================================================


struct  Ul_BFu8i_D  {
  __tsu64 v1;
  unsigned int v2:8;
  double v3;
};
//SIG(1 Ul_BFu8i_D) C1{ FL Fi:8 FL}



static void Test_Ul_BFu8i_D()
{
  {
    init_simple_test("Ul_BFu8i_D");
    static STRUCT_IF_C Ul_BFu8i_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_BFu8i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_D");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_D");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu8i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_D, Ul_BFu8i_D)
//============================================================================


struct  Ul_BFu8i_F  {
  __tsu64 v1;
  unsigned int v2:8;
  float v3;
};
//SIG(1 Ul_BFu8i_F) C1{ FL Fi:8 Fi}



static void Test_Ul_BFu8i_F()
{
  {
    init_simple_test("Ul_BFu8i_F");
    static STRUCT_IF_C Ul_BFu8i_F lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_F");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_F");
    check_field_offset(lv, v3, 12, "Ul_BFu8i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_F, Ul_BFu8i_F)
//============================================================================


struct  Ul_BFu8i_I  {
  __tsu64 v1;
  unsigned int v2:8;
  int v3;
};
//SIG(1 Ul_BFu8i_I) C1{ FL Fi:8 Fi}



static void Test_Ul_BFu8i_I()
{
  {
    init_simple_test("Ul_BFu8i_I");
    static STRUCT_IF_C Ul_BFu8i_I lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_I");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_I");
    check_field_offset(lv, v3, 12, "Ul_BFu8i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_I, Ul_BFu8i_I)
//============================================================================


struct  Ul_BFu8i_Ip  {
  __tsu64 v1;
  unsigned int v2:8;
  int *v3;
};
//SIG(1 Ul_BFu8i_Ip) C1{ FL Fi:8 Fp}



static void Test_Ul_BFu8i_Ip()
{
  {
    init_simple_test("Ul_BFu8i_Ip");
    static STRUCT_IF_C Ul_BFu8i_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_BFu8i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_Ip");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu8i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_Ip, Ul_BFu8i_Ip)
//============================================================================


struct  Ul_BFu8i_L  {
  __tsu64 v1;
  unsigned int v2:8;
  __tsi64 v3;
};
//SIG(1 Ul_BFu8i_L) C1{ FL Fi:8 FL}



static void Test_Ul_BFu8i_L()
{
  {
    init_simple_test("Ul_BFu8i_L");
    static STRUCT_IF_C Ul_BFu8i_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_BFu8i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_L");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_L");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu8i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_L, Ul_BFu8i_L)
//============================================================================


struct  Ul_BFu8i_S  {
  __tsu64 v1;
  unsigned int v2:8;
  short v3;
};
//SIG(1 Ul_BFu8i_S) C1{ FL Fi:8 Fs}



static void Test_Ul_BFu8i_S()
{
  {
    init_simple_test("Ul_BFu8i_S");
    static STRUCT_IF_C Ul_BFu8i_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_S");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_S");
    check_field_offset(lv, v3, 10, "Ul_BFu8i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_S, Ul_BFu8i_S)
//============================================================================


struct  Ul_BFu8i_Uc  {
  __tsu64 v1;
  unsigned int v2:8;
  unsigned char v3;
};
//SIG(1 Ul_BFu8i_Uc) C1{ FL Fi:8 Fc}



static void Test_Ul_BFu8i_Uc()
{
  {
    init_simple_test("Ul_BFu8i_Uc");
    static STRUCT_IF_C Ul_BFu8i_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_Uc");
    check_field_offset(lv, v3, 9, "Ul_BFu8i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_Uc, Ul_BFu8i_Uc)
//============================================================================


struct  Ul_BFu8i_Ui  {
  __tsu64 v1;
  unsigned int v2:8;
  unsigned int v3;
};
//SIG(1 Ul_BFu8i_Ui) C1{ FL Fi:8 Fi}



static void Test_Ul_BFu8i_Ui()
{
  {
    init_simple_test("Ul_BFu8i_Ui");
    static STRUCT_IF_C Ul_BFu8i_Ui lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_Ui");
    check_field_offset(lv, v3, 12, "Ul_BFu8i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_Ui, Ul_BFu8i_Ui)
//============================================================================


struct  Ul_BFu8i_Ul  {
  __tsu64 v1;
  unsigned int v2:8;
  __tsu64 v3;
};
//SIG(1 Ul_BFu8i_Ul) C1{ FL Fi:8 FL}



static void Test_Ul_BFu8i_Ul()
{
  {
    init_simple_test("Ul_BFu8i_Ul");
    static STRUCT_IF_C Ul_BFu8i_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_BFu8i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_Ul");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu8i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_Ul, Ul_BFu8i_Ul)
//============================================================================


struct  Ul_BFu8i_Us  {
  __tsu64 v1;
  unsigned int v2:8;
  unsigned short v3;
};
//SIG(1 Ul_BFu8i_Us) C1{ FL Fi:8 Fs}



static void Test_Ul_BFu8i_Us()
{
  {
    init_simple_test("Ul_BFu8i_Us");
    static STRUCT_IF_C Ul_BFu8i_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_Us");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_Us");
    check_field_offset(lv, v3, 10, "Ul_BFu8i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_Us, Ul_BFu8i_Us)
//============================================================================


struct  Ul_BFu8i_Vp  {
  __tsu64 v1;
  unsigned int v2:8;
  void *v3;
};
//SIG(1 Ul_BFu8i_Vp) C1{ FL Fi:8 Fp}



static void Test_Ul_BFu8i_Vp()
{
  {
    init_simple_test("Ul_BFu8i_Vp");
    static STRUCT_IF_C Ul_BFu8i_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_BFu8i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8i_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu8i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8i_Vp");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu8i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8i_Vp, Ul_BFu8i_Vp)
//============================================================================


struct  Ul_BFu8ll  {
  __tsu64 v1;
  __tsu64 v2:8;
};
//SIG(1 Ul_BFu8ll) C1{ FL FL:8}



static void Test_Ul_BFu8ll()
{
  {
    init_simple_test("Ul_BFu8ll");
    static STRUCT_IF_C Ul_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll, Ul_BFu8ll)
//============================================================================


struct  Ul_BFu8ll_BFu15i  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned int v3:15;
};
//SIG(1 Ul_BFu8ll_BFu15i) C1{ FL FL:8 Fi:15}



static void Test_Ul_BFu8ll_BFu15i()
{
  {
    init_simple_test("Ul_BFu8ll_BFu15i");
    static STRUCT_IF_C Ul_BFu8ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_BFu8ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_BFu8ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu15i, Ul_BFu8ll_BFu15i)
//============================================================================


struct  Ul_BFu8ll_BFu15ll  {
  __tsu64 v1;
  __tsu64 v2:8;
  __tsu64 v3:15;
};
//SIG(1 Ul_BFu8ll_BFu15ll) C1{ FL FL:8 FL:15}



static void Test_Ul_BFu8ll_BFu15ll()
{
  {
    init_simple_test("Ul_BFu8ll_BFu15ll");
    static STRUCT_IF_C Ul_BFu8ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_BFu8ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_BFu8ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu15ll, Ul_BFu8ll_BFu15ll)
//============================================================================


struct  Ul_BFu8ll_BFu15s  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned short v3:15;
};
//SIG(1 Ul_BFu8ll_BFu15s) C1{ FL FL:8 Fs:15}



static void Test_Ul_BFu8ll_BFu15s()
{
  {
    init_simple_test("Ul_BFu8ll_BFu15s");
    static STRUCT_IF_C Ul_BFu8ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_BFu8ll_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_BFu8ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu15s, Ul_BFu8ll_BFu15s)
//============================================================================


struct  Ul_BFu8ll_BFu16i  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned int v3:16;
};
//SIG(1 Ul_BFu8ll_BFu16i) C1{ FL FL:8 Fi:16}



static void Test_Ul_BFu8ll_BFu16i()
{
  {
    init_simple_test("Ul_BFu8ll_BFu16i");
    static STRUCT_IF_C Ul_BFu8ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_BFu8ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_BFu8ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu16i, Ul_BFu8ll_BFu16i)
//============================================================================


struct  Ul_BFu8ll_BFu16ll  {
  __tsu64 v1;
  __tsu64 v2:8;
  __tsu64 v3:16;
};
//SIG(1 Ul_BFu8ll_BFu16ll) C1{ FL FL:8 FL:16}



static void Test_Ul_BFu8ll_BFu16ll()
{
  {
    init_simple_test("Ul_BFu8ll_BFu16ll");
    static STRUCT_IF_C Ul_BFu8ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_BFu8ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_BFu8ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu16ll, Ul_BFu8ll_BFu16ll)
//============================================================================


struct  Ul_BFu8ll_BFu16s  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned short v3:16;
};
//SIG(1 Ul_BFu8ll_BFu16s) C1{ FL FL:8 Fs:16}



static void Test_Ul_BFu8ll_BFu16s()
{
  {
    init_simple_test("Ul_BFu8ll_BFu16s");
    static STRUCT_IF_C Ul_BFu8ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_BFu8ll_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_BFu8ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu16s, Ul_BFu8ll_BFu16s)
//============================================================================


struct  Ul_BFu8ll_BFu17i  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned int v3:17;
};
//SIG(1 Ul_BFu8ll_BFu17i) C1{ FL FL:8 Fi:17}



static void Test_Ul_BFu8ll_BFu17i()
{
  {
    init_simple_test("Ul_BFu8ll_BFu17i");
    static STRUCT_IF_C Ul_BFu8ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Ul_BFu8ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Ul_BFu8ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu17i, Ul_BFu8ll_BFu17i)
//============================================================================


struct  Ul_BFu8ll_BFu17ll  {
  __tsu64 v1;
  __tsu64 v2:8;
  __tsu64 v3:17;
};
//SIG(1 Ul_BFu8ll_BFu17ll) C1{ FL FL:8 FL:17}



static void Test_Ul_BFu8ll_BFu17ll()
{
  {
    init_simple_test("Ul_BFu8ll_BFu17ll");
    static STRUCT_IF_C Ul_BFu8ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Ul_BFu8ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Ul_BFu8ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu17ll, Ul_BFu8ll_BFu17ll)
//============================================================================


struct  Ul_BFu8ll_BFu1c  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned char v3:1;
};
//SIG(1 Ul_BFu8ll_BFu1c) C1{ FL FL:8 Fc:1}



static void Test_Ul_BFu8ll_BFu1c()
{
  {
    init_simple_test("Ul_BFu8ll_BFu1c");
    static STRUCT_IF_C Ul_BFu8ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu1c");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu1c, Ul_BFu8ll_BFu1c)
//============================================================================


struct  Ul_BFu8ll_BFu1i  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned int v3:1;
};
//SIG(1 Ul_BFu8ll_BFu1i) C1{ FL FL:8 Fi:1}



static void Test_Ul_BFu8ll_BFu1i()
{
  {
    init_simple_test("Ul_BFu8ll_BFu1i");
    static STRUCT_IF_C Ul_BFu8ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu1i");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu1i, Ul_BFu8ll_BFu1i)
//============================================================================


struct  Ul_BFu8ll_BFu1ll  {
  __tsu64 v1;
  __tsu64 v2:8;
  __tsu64 v3:1;
};
//SIG(1 Ul_BFu8ll_BFu1ll) C1{ FL FL:8 FL:1}



static void Test_Ul_BFu8ll_BFu1ll()
{
  {
    init_simple_test("Ul_BFu8ll_BFu1ll");
    static STRUCT_IF_C Ul_BFu8ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu1ll");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu1ll, Ul_BFu8ll_BFu1ll)
//============================================================================


struct  Ul_BFu8ll_BFu1s  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned short v3:1;
};
//SIG(1 Ul_BFu8ll_BFu1s) C1{ FL FL:8 Fs:1}



static void Test_Ul_BFu8ll_BFu1s()
{
  {
    init_simple_test("Ul_BFu8ll_BFu1s");
    static STRUCT_IF_C Ul_BFu8ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu1s");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu1s, Ul_BFu8ll_BFu1s)
//============================================================================


struct  Ul_BFu8ll_BFu31i  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned int v3:31;
};
//SIG(1 Ul_BFu8ll_BFu31i) C1{ FL FL:8 Fi:31}



static void Test_Ul_BFu8ll_BFu31i()
{
  {
    init_simple_test("Ul_BFu8ll_BFu31i");
    static STRUCT_IF_C Ul_BFu8ll_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "Ul_BFu8ll_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "Ul_BFu8ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu31i, Ul_BFu8ll_BFu31i)
//============================================================================


struct  Ul_BFu8ll_BFu31ll  {
  __tsu64 v1;
  __tsu64 v2:8;
  __tsu64 v3:31;
};
//SIG(1 Ul_BFu8ll_BFu31ll) C1{ FL FL:8 FL:31}



static void Test_Ul_BFu8ll_BFu31ll()
{
  {
    init_simple_test("Ul_BFu8ll_BFu31ll");
    static STRUCT_IF_C Ul_BFu8ll_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "Ul_BFu8ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "Ul_BFu8ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu31ll, Ul_BFu8ll_BFu31ll)
//============================================================================


struct  Ul_BFu8ll_BFu32i  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned int v3:32;
};
//SIG(1 Ul_BFu8ll_BFu32i) C1{ FL FL:8 Fi:32}



static void Test_Ul_BFu8ll_BFu32i()
{
  {
    init_simple_test("Ul_BFu8ll_BFu32i");
    static STRUCT_IF_C Ul_BFu8ll_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_BFu8ll_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_BFu8ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu32i, Ul_BFu8ll_BFu32i)
//============================================================================


struct  Ul_BFu8ll_BFu32ll  {
  __tsu64 v1;
  __tsu64 v2:8;
  __tsu64 v3:32;
};
//SIG(1 Ul_BFu8ll_BFu32ll) C1{ FL FL:8 FL:32}



static void Test_Ul_BFu8ll_BFu32ll()
{
  {
    init_simple_test("Ul_BFu8ll_BFu32ll");
    static STRUCT_IF_C Ul_BFu8ll_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "Ul_BFu8ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "Ul_BFu8ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu32ll, Ul_BFu8ll_BFu32ll)
//============================================================================


struct  Ul_BFu8ll_BFu33  {
  __tsu64 v1;
  __tsu64 v2:8;
  __tsu64 v3:33;
};
//SIG(1 Ul_BFu8ll_BFu33) C1{ FL FL:8 FL:33}



static void Test_Ul_BFu8ll_BFu33()
{
  {
    init_simple_test("Ul_BFu8ll_BFu33");
    static STRUCT_IF_C Ul_BFu8ll_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "Ul_BFu8ll_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "Ul_BFu8ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu33, Ul_BFu8ll_BFu33)
//============================================================================


struct  Ul_BFu8ll_BFu7c  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned char v3:7;
};
//SIG(1 Ul_BFu8ll_BFu7c) C1{ FL FL:8 Fc:7}



static void Test_Ul_BFu8ll_BFu7c()
{
  {
    init_simple_test("Ul_BFu8ll_BFu7c");
    static STRUCT_IF_C Ul_BFu8ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu7c, Ul_BFu8ll_BFu7c)
//============================================================================


struct  Ul_BFu8ll_BFu7i  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned int v3:7;
};
//SIG(1 Ul_BFu8ll_BFu7i) C1{ FL FL:8 Fi:7}



static void Test_Ul_BFu8ll_BFu7i()
{
  {
    init_simple_test("Ul_BFu8ll_BFu7i");
    static STRUCT_IF_C Ul_BFu8ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu7i, Ul_BFu8ll_BFu7i)
//============================================================================


struct  Ul_BFu8ll_BFu7ll  {
  __tsu64 v1;
  __tsu64 v2:8;
  __tsu64 v3:7;
};
//SIG(1 Ul_BFu8ll_BFu7ll) C1{ FL FL:8 FL:7}



static void Test_Ul_BFu8ll_BFu7ll()
{
  {
    init_simple_test("Ul_BFu8ll_BFu7ll");
    static STRUCT_IF_C Ul_BFu8ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu7ll, Ul_BFu8ll_BFu7ll)
//============================================================================


struct  Ul_BFu8ll_BFu7s  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned short v3:7;
};
//SIG(1 Ul_BFu8ll_BFu7s) C1{ FL FL:8 Fs:7}



static void Test_Ul_BFu8ll_BFu7s()
{
  {
    init_simple_test("Ul_BFu8ll_BFu7s");
    static STRUCT_IF_C Ul_BFu8ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu7s, Ul_BFu8ll_BFu7s)
//============================================================================


struct  Ul_BFu8ll_BFu8c  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned char v3:8;
};
//SIG(1 Ul_BFu8ll_BFu8c) C1{ FL FL:8 Fc:8}



static void Test_Ul_BFu8ll_BFu8c()
{
  {
    init_simple_test("Ul_BFu8ll_BFu8c");
    static STRUCT_IF_C Ul_BFu8ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8ll_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu8c, Ul_BFu8ll_BFu8c)
//============================================================================


struct  Ul_BFu8ll_BFu8i  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned int v3:8;
};
//SIG(1 Ul_BFu8ll_BFu8i) C1{ FL FL:8 Fi:8}



static void Test_Ul_BFu8ll_BFu8i()
{
  {
    init_simple_test("Ul_BFu8ll_BFu8i");
    static STRUCT_IF_C Ul_BFu8ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu8i, Ul_BFu8ll_BFu8i)
//============================================================================


struct  Ul_BFu8ll_BFu8ll  {
  __tsu64 v1;
  __tsu64 v2:8;
  __tsu64 v3:8;
};
//SIG(1 Ul_BFu8ll_BFu8ll) C1{ FL FL:8 FL:8}



static void Test_Ul_BFu8ll_BFu8ll()
{
  {
    init_simple_test("Ul_BFu8ll_BFu8ll");
    static STRUCT_IF_C Ul_BFu8ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu8ll, Ul_BFu8ll_BFu8ll)
//============================================================================


struct  Ul_BFu8ll_BFu8s  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned short v3:8;
};
//SIG(1 Ul_BFu8ll_BFu8s) C1{ FL FL:8 Fs:8}



static void Test_Ul_BFu8ll_BFu8s()
{
  {
    init_simple_test("Ul_BFu8ll_BFu8s");
    static STRUCT_IF_C Ul_BFu8ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8ll_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu8s, Ul_BFu8ll_BFu8s)
//============================================================================


struct  Ul_BFu8ll_BFu9i  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned int v3:9;
};
//SIG(1 Ul_BFu8ll_BFu9i) C1{ FL FL:8 Fi:9}



static void Test_Ul_BFu8ll_BFu9i()
{
  {
    init_simple_test("Ul_BFu8ll_BFu9i");
    static STRUCT_IF_C Ul_BFu8ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_BFu8ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_BFu8ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu9i, Ul_BFu8ll_BFu9i)
//============================================================================


struct  Ul_BFu8ll_BFu9ll  {
  __tsu64 v1;
  __tsu64 v2:8;
  __tsu64 v3:9;
};
//SIG(1 Ul_BFu8ll_BFu9ll) C1{ FL FL:8 FL:9}



static void Test_Ul_BFu8ll_BFu9ll()
{
  {
    init_simple_test("Ul_BFu8ll_BFu9ll");
    static STRUCT_IF_C Ul_BFu8ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_BFu8ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_BFu8ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu9ll, Ul_BFu8ll_BFu9ll)
//============================================================================


struct  Ul_BFu8ll_BFu9s  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned short v3:9;
};
//SIG(1 Ul_BFu8ll_BFu9s) C1{ FL FL:8 Fs:9}



static void Test_Ul_BFu8ll_BFu9s()
{
  {
    init_simple_test("Ul_BFu8ll_BFu9s");
    static STRUCT_IF_C Ul_BFu8ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_BFu8ll_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_BFu8ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_BFu9s, Ul_BFu8ll_BFu9s)
//============================================================================


struct  Ul_BFu8ll_C  {
  __tsu64 v1;
  __tsu64 v2:8;
  char v3;
};
//SIG(1 Ul_BFu8ll_C) C1{ FL FL:8 Fc}



static void Test_Ul_BFu8ll_C()
{
  {
    init_simple_test("Ul_BFu8ll_C");
    static STRUCT_IF_C Ul_BFu8ll_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_C");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_C");
    check_field_offset(lv, v3, 9, "Ul_BFu8ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_C, Ul_BFu8ll_C)
//============================================================================


struct  Ul_BFu8ll_D  {
  __tsu64 v1;
  __tsu64 v2:8;
  double v3;
};
//SIG(1 Ul_BFu8ll_D) C1{ FL FL:8 FL}



static void Test_Ul_BFu8ll_D()
{
  {
    init_simple_test("Ul_BFu8ll_D");
    static STRUCT_IF_C Ul_BFu8ll_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_BFu8ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_D");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_D");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu8ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_D, Ul_BFu8ll_D)
//============================================================================


struct  Ul_BFu8ll_F  {
  __tsu64 v1;
  __tsu64 v2:8;
  float v3;
};
//SIG(1 Ul_BFu8ll_F) C1{ FL FL:8 Fi}



static void Test_Ul_BFu8ll_F()
{
  {
    init_simple_test("Ul_BFu8ll_F");
    static STRUCT_IF_C Ul_BFu8ll_F lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_F");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_F");
    check_field_offset(lv, v3, 12, "Ul_BFu8ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_F, Ul_BFu8ll_F)
//============================================================================


struct  Ul_BFu8ll_I  {
  __tsu64 v1;
  __tsu64 v2:8;
  int v3;
};
//SIG(1 Ul_BFu8ll_I) C1{ FL FL:8 Fi}



static void Test_Ul_BFu8ll_I()
{
  {
    init_simple_test("Ul_BFu8ll_I");
    static STRUCT_IF_C Ul_BFu8ll_I lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_I");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_I");
    check_field_offset(lv, v3, 12, "Ul_BFu8ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_I, Ul_BFu8ll_I)
//============================================================================


struct  Ul_BFu8ll_Ip  {
  __tsu64 v1;
  __tsu64 v2:8;
  int *v3;
};
//SIG(1 Ul_BFu8ll_Ip) C1{ FL FL:8 Fp}



static void Test_Ul_BFu8ll_Ip()
{
  {
    init_simple_test("Ul_BFu8ll_Ip");
    static STRUCT_IF_C Ul_BFu8ll_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_BFu8ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_Ip");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu8ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_Ip, Ul_BFu8ll_Ip)
//============================================================================


struct  Ul_BFu8ll_L  {
  __tsu64 v1;
  __tsu64 v2:8;
  __tsi64 v3;
};
//SIG(1 Ul_BFu8ll_L) C1{ FL FL:8 FL}



static void Test_Ul_BFu8ll_L()
{
  {
    init_simple_test("Ul_BFu8ll_L");
    static STRUCT_IF_C Ul_BFu8ll_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_BFu8ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_L");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_L");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu8ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_L, Ul_BFu8ll_L)
//============================================================================


struct  Ul_BFu8ll_S  {
  __tsu64 v1;
  __tsu64 v2:8;
  short v3;
};
//SIG(1 Ul_BFu8ll_S) C1{ FL FL:8 Fs}



static void Test_Ul_BFu8ll_S()
{
  {
    init_simple_test("Ul_BFu8ll_S");
    static STRUCT_IF_C Ul_BFu8ll_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_S");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_S");
    check_field_offset(lv, v3, 10, "Ul_BFu8ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_S, Ul_BFu8ll_S)
//============================================================================


struct  Ul_BFu8ll_Uc  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned char v3;
};
//SIG(1 Ul_BFu8ll_Uc) C1{ FL FL:8 Fc}



static void Test_Ul_BFu8ll_Uc()
{
  {
    init_simple_test("Ul_BFu8ll_Uc");
    static STRUCT_IF_C Ul_BFu8ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_Uc");
    check_field_offset(lv, v3, 9, "Ul_BFu8ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_Uc, Ul_BFu8ll_Uc)
//============================================================================


struct  Ul_BFu8ll_Ui  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned int v3;
};
//SIG(1 Ul_BFu8ll_Ui) C1{ FL FL:8 Fi}



static void Test_Ul_BFu8ll_Ui()
{
  {
    init_simple_test("Ul_BFu8ll_Ui");
    static STRUCT_IF_C Ul_BFu8ll_Ui lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_Ui");
    check_field_offset(lv, v3, 12, "Ul_BFu8ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_Ui, Ul_BFu8ll_Ui)
//============================================================================


struct  Ul_BFu8ll_Ul  {
  __tsu64 v1;
  __tsu64 v2:8;
  __tsu64 v3;
};
//SIG(1 Ul_BFu8ll_Ul) C1{ FL FL:8 FL}



static void Test_Ul_BFu8ll_Ul()
{
  {
    init_simple_test("Ul_BFu8ll_Ul");
    static STRUCT_IF_C Ul_BFu8ll_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_BFu8ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_Ul");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu8ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_Ul, Ul_BFu8ll_Ul)
//============================================================================


struct  Ul_BFu8ll_Us  {
  __tsu64 v1;
  __tsu64 v2:8;
  unsigned short v3;
};
//SIG(1 Ul_BFu8ll_Us) C1{ FL FL:8 Fs}



static void Test_Ul_BFu8ll_Us()
{
  {
    init_simple_test("Ul_BFu8ll_Us");
    static STRUCT_IF_C Ul_BFu8ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_Us");
    check_field_offset(lv, v3, 10, "Ul_BFu8ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_Us, Ul_BFu8ll_Us)
//============================================================================


struct  Ul_BFu8ll_Vp  {
  __tsu64 v1;
  __tsu64 v2:8;
  void *v3;
};
//SIG(1 Ul_BFu8ll_Vp) C1{ FL FL:8 Fp}



static void Test_Ul_BFu8ll_Vp()
{
  {
    init_simple_test("Ul_BFu8ll_Vp");
    static STRUCT_IF_C Ul_BFu8ll_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_BFu8ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8ll_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu8ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8ll_Vp");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu8ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8ll_Vp, Ul_BFu8ll_Vp)
//============================================================================


struct  Ul_BFu8s  {
  __tsu64 v1;
  unsigned short v2:8;
};
//SIG(1 Ul_BFu8s) C1{ FL Fs:8}



static void Test_Ul_BFu8s()
{
  {
    init_simple_test("Ul_BFu8s");
    static STRUCT_IF_C Ul_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s, Ul_BFu8s)
//============================================================================


struct  Ul_BFu8s_BFu15i  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned int v3:15;
};
//SIG(1 Ul_BFu8s_BFu15i) C1{ FL Fs:8 Fi:15}



static void Test_Ul_BFu8s_BFu15i()
{
  {
    init_simple_test("Ul_BFu8s_BFu15i");
    static STRUCT_IF_C Ul_BFu8s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_BFu8s_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_BFu8s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu15i, Ul_BFu8s_BFu15i)
//============================================================================


struct  Ul_BFu8s_BFu15ll  {
  __tsu64 v1;
  unsigned short v2:8;
  __tsu64 v3:15;
};
//SIG(1 Ul_BFu8s_BFu15ll) C1{ FL Fs:8 FL:15}



static void Test_Ul_BFu8s_BFu15ll()
{
  {
    init_simple_test("Ul_BFu8s_BFu15ll");
    static STRUCT_IF_C Ul_BFu8s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_BFu8s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_BFu8s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu15ll, Ul_BFu8s_BFu15ll)
//============================================================================


struct  Ul_BFu8s_BFu15s  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned short v3:15;
};
//SIG(1 Ul_BFu8s_BFu15s) C1{ FL Fs:8 Fs:15}



static void Test_Ul_BFu8s_BFu15s()
{
  {
    init_simple_test("Ul_BFu8s_BFu15s");
    static STRUCT_IF_C Ul_BFu8s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_BFu8s_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_BFu8s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu15s, Ul_BFu8s_BFu15s)
//============================================================================


struct  Ul_BFu8s_BFu16i  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned int v3:16;
};
//SIG(1 Ul_BFu8s_BFu16i) C1{ FL Fs:8 Fi:16}



static void Test_Ul_BFu8s_BFu16i()
{
  {
    init_simple_test("Ul_BFu8s_BFu16i");
    static STRUCT_IF_C Ul_BFu8s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_BFu8s_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_BFu8s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu16i, Ul_BFu8s_BFu16i)
//============================================================================


struct  Ul_BFu8s_BFu16ll  {
  __tsu64 v1;
  unsigned short v2:8;
  __tsu64 v3:16;
};
//SIG(1 Ul_BFu8s_BFu16ll) C1{ FL Fs:8 FL:16}



static void Test_Ul_BFu8s_BFu16ll()
{
  {
    init_simple_test("Ul_BFu8s_BFu16ll");
    static STRUCT_IF_C Ul_BFu8s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_BFu8s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_BFu8s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu16ll, Ul_BFu8s_BFu16ll)
//============================================================================


struct  Ul_BFu8s_BFu16s  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned short v3:16;
};
//SIG(1 Ul_BFu8s_BFu16s) C1{ FL Fs:8 Fs:16}



static void Test_Ul_BFu8s_BFu16s()
{
  {
    init_simple_test("Ul_BFu8s_BFu16s");
    static STRUCT_IF_C Ul_BFu8s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_BFu8s_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_BFu8s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu16s, Ul_BFu8s_BFu16s)
//============================================================================


struct  Ul_BFu8s_BFu17i  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned int v3:17;
};
//SIG(1 Ul_BFu8s_BFu17i) C1{ FL Fs:8 Fi:17}



static void Test_Ul_BFu8s_BFu17i()
{
  {
    init_simple_test("Ul_BFu8s_BFu17i");
    static STRUCT_IF_C Ul_BFu8s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Ul_BFu8s_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Ul_BFu8s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu17i, Ul_BFu8s_BFu17i)
//============================================================================


struct  Ul_BFu8s_BFu17ll  {
  __tsu64 v1;
  unsigned short v2:8;
  __tsu64 v3:17;
};
//SIG(1 Ul_BFu8s_BFu17ll) C1{ FL Fs:8 FL:17}



static void Test_Ul_BFu8s_BFu17ll()
{
  {
    init_simple_test("Ul_BFu8s_BFu17ll");
    static STRUCT_IF_C Ul_BFu8s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Ul_BFu8s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Ul_BFu8s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu17ll, Ul_BFu8s_BFu17ll)
//============================================================================


struct  Ul_BFu8s_BFu1c  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned char v3:1;
};
//SIG(1 Ul_BFu8s_BFu1c) C1{ FL Fs:8 Fc:1}



static void Test_Ul_BFu8s_BFu1c()
{
  {
    init_simple_test("Ul_BFu8s_BFu1c");
    static STRUCT_IF_C Ul_BFu8s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu1c");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu1c, Ul_BFu8s_BFu1c)
//============================================================================


struct  Ul_BFu8s_BFu1i  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned int v3:1;
};
//SIG(1 Ul_BFu8s_BFu1i) C1{ FL Fs:8 Fi:1}



static void Test_Ul_BFu8s_BFu1i()
{
  {
    init_simple_test("Ul_BFu8s_BFu1i");
    static STRUCT_IF_C Ul_BFu8s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu1i");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu1i, Ul_BFu8s_BFu1i)
//============================================================================


struct  Ul_BFu8s_BFu1ll  {
  __tsu64 v1;
  unsigned short v2:8;
  __tsu64 v3:1;
};
//SIG(1 Ul_BFu8s_BFu1ll) C1{ FL Fs:8 FL:1}



static void Test_Ul_BFu8s_BFu1ll()
{
  {
    init_simple_test("Ul_BFu8s_BFu1ll");
    static STRUCT_IF_C Ul_BFu8s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu1ll");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu1ll, Ul_BFu8s_BFu1ll)
//============================================================================


struct  Ul_BFu8s_BFu1s  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned short v3:1;
};
//SIG(1 Ul_BFu8s_BFu1s) C1{ FL Fs:8 Fs:1}



static void Test_Ul_BFu8s_BFu1s()
{
  {
    init_simple_test("Ul_BFu8s_BFu1s");
    static STRUCT_IF_C Ul_BFu8s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu1s");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_BFu8s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu1s, Ul_BFu8s_BFu1s)
//============================================================================


struct  Ul_BFu8s_BFu31i  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned int v3:31;
};
//SIG(1 Ul_BFu8s_BFu31i) C1{ FL Fs:8 Fi:31}



static void Test_Ul_BFu8s_BFu31i()
{
  {
    init_simple_test("Ul_BFu8s_BFu31i");
    static STRUCT_IF_C Ul_BFu8s_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "Ul_BFu8s_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "Ul_BFu8s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu31i, Ul_BFu8s_BFu31i)
//============================================================================


struct  Ul_BFu8s_BFu31ll  {
  __tsu64 v1;
  unsigned short v2:8;
  __tsu64 v3:31;
};
//SIG(1 Ul_BFu8s_BFu31ll) C1{ FL Fs:8 FL:31}



static void Test_Ul_BFu8s_BFu31ll()
{
  {
    init_simple_test("Ul_BFu8s_BFu31ll");
    static STRUCT_IF_C Ul_BFu8s_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "Ul_BFu8s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "Ul_BFu8s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu31ll, Ul_BFu8s_BFu31ll)
//============================================================================


struct  Ul_BFu8s_BFu32i  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned int v3:32;
};
//SIG(1 Ul_BFu8s_BFu32i) C1{ FL Fs:8 Fi:32}



static void Test_Ul_BFu8s_BFu32i()
{
  {
    init_simple_test("Ul_BFu8s_BFu32i");
    static STRUCT_IF_C Ul_BFu8s_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_BFu8s_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_BFu8s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu32i, Ul_BFu8s_BFu32i)
//============================================================================


struct  Ul_BFu8s_BFu32ll  {
  __tsu64 v1;
  unsigned short v2:8;
  __tsu64 v3:32;
};
//SIG(1 Ul_BFu8s_BFu32ll) C1{ FL Fs:8 FL:32}



static void Test_Ul_BFu8s_BFu32ll()
{
  {
    init_simple_test("Ul_BFu8s_BFu32ll");
    static STRUCT_IF_C Ul_BFu8s_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "Ul_BFu8s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "Ul_BFu8s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu32ll, Ul_BFu8s_BFu32ll)
//============================================================================


struct  Ul_BFu8s_BFu33  {
  __tsu64 v1;
  unsigned short v2:8;
  __tsu64 v3:33;
};
//SIG(1 Ul_BFu8s_BFu33) C1{ FL Fs:8 FL:33}



static void Test_Ul_BFu8s_BFu33()
{
  {
    init_simple_test("Ul_BFu8s_BFu33");
    static STRUCT_IF_C Ul_BFu8s_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "Ul_BFu8s_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "Ul_BFu8s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu33, Ul_BFu8s_BFu33)
//============================================================================


struct  Ul_BFu8s_BFu7c  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned char v3:7;
};
//SIG(1 Ul_BFu8s_BFu7c) C1{ FL Fs:8 Fc:7}



static void Test_Ul_BFu8s_BFu7c()
{
  {
    init_simple_test("Ul_BFu8s_BFu7c");
    static STRUCT_IF_C Ul_BFu8s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8s_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu7c, Ul_BFu8s_BFu7c)
//============================================================================


struct  Ul_BFu8s_BFu7i  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned int v3:7;
};
//SIG(1 Ul_BFu8s_BFu7i) C1{ FL Fs:8 Fi:7}



static void Test_Ul_BFu8s_BFu7i()
{
  {
    init_simple_test("Ul_BFu8s_BFu7i");
    static STRUCT_IF_C Ul_BFu8s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8s_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu7i, Ul_BFu8s_BFu7i)
//============================================================================


struct  Ul_BFu8s_BFu7ll  {
  __tsu64 v1;
  unsigned short v2:8;
  __tsu64 v3:7;
};
//SIG(1 Ul_BFu8s_BFu7ll) C1{ FL Fs:8 FL:7}



static void Test_Ul_BFu8s_BFu7ll()
{
  {
    init_simple_test("Ul_BFu8s_BFu7ll");
    static STRUCT_IF_C Ul_BFu8s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu7ll, Ul_BFu8s_BFu7ll)
//============================================================================


struct  Ul_BFu8s_BFu7s  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned short v3:7;
};
//SIG(1 Ul_BFu8s_BFu7s) C1{ FL Fs:8 Fs:7}



static void Test_Ul_BFu8s_BFu7s()
{
  {
    init_simple_test("Ul_BFu8s_BFu7s");
    static STRUCT_IF_C Ul_BFu8s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_BFu8s_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_BFu8s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu7s, Ul_BFu8s_BFu7s)
//============================================================================


struct  Ul_BFu8s_BFu8c  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned char v3:8;
};
//SIG(1 Ul_BFu8s_BFu8c) C1{ FL Fs:8 Fc:8}



static void Test_Ul_BFu8s_BFu8c()
{
  {
    init_simple_test("Ul_BFu8s_BFu8c");
    static STRUCT_IF_C Ul_BFu8s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8s_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu8c, Ul_BFu8s_BFu8c)
//============================================================================


struct  Ul_BFu8s_BFu8i  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned int v3:8;
};
//SIG(1 Ul_BFu8s_BFu8i) C1{ FL Fs:8 Fi:8}



static void Test_Ul_BFu8s_BFu8i()
{
  {
    init_simple_test("Ul_BFu8s_BFu8i");
    static STRUCT_IF_C Ul_BFu8s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8s_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu8i, Ul_BFu8s_BFu8i)
//============================================================================


struct  Ul_BFu8s_BFu8ll  {
  __tsu64 v1;
  unsigned short v2:8;
  __tsu64 v3:8;
};
//SIG(1 Ul_BFu8s_BFu8ll) C1{ FL Fs:8 FL:8}



static void Test_Ul_BFu8s_BFu8ll()
{
  {
    init_simple_test("Ul_BFu8s_BFu8ll");
    static STRUCT_IF_C Ul_BFu8s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu8ll, Ul_BFu8s_BFu8ll)
//============================================================================


struct  Ul_BFu8s_BFu8s  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned short v3:8;
};
//SIG(1 Ul_BFu8s_BFu8s) C1{ FL Fs:8 Fs:8}



static void Test_Ul_BFu8s_BFu8s()
{
  {
    init_simple_test("Ul_BFu8s_BFu8s");
    static STRUCT_IF_C Ul_BFu8s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_BFu8s_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu8s, Ul_BFu8s_BFu8s)
//============================================================================


struct  Ul_BFu8s_BFu9i  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned int v3:9;
};
//SIG(1 Ul_BFu8s_BFu9i) C1{ FL Fs:8 Fi:9}



static void Test_Ul_BFu8s_BFu9i()
{
  {
    init_simple_test("Ul_BFu8s_BFu9i");
    static STRUCT_IF_C Ul_BFu8s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_BFu8s_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_BFu8s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu9i, Ul_BFu8s_BFu9i)
//============================================================================


struct  Ul_BFu8s_BFu9ll  {
  __tsu64 v1;
  unsigned short v2:8;
  __tsu64 v3:9;
};
//SIG(1 Ul_BFu8s_BFu9ll) C1{ FL Fs:8 FL:9}



static void Test_Ul_BFu8s_BFu9ll()
{
  {
    init_simple_test("Ul_BFu8s_BFu9ll");
    static STRUCT_IF_C Ul_BFu8s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_BFu8s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_BFu8s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu9ll, Ul_BFu8s_BFu9ll)
//============================================================================


struct  Ul_BFu8s_BFu9s  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned short v3:9;
};
//SIG(1 Ul_BFu8s_BFu9s) C1{ FL Fs:8 Fs:9}



static void Test_Ul_BFu8s_BFu9s()
{
  {
    init_simple_test("Ul_BFu8s_BFu9s");
    static STRUCT_IF_C Ul_BFu8s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_BFu8s_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_BFu8s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_BFu9s, Ul_BFu8s_BFu9s)
//============================================================================


struct  Ul_BFu8s_C  {
  __tsu64 v1;
  unsigned short v2:8;
  char v3;
};
//SIG(1 Ul_BFu8s_C) C1{ FL Fs:8 Fc}



static void Test_Ul_BFu8s_C()
{
  {
    init_simple_test("Ul_BFu8s_C");
    static STRUCT_IF_C Ul_BFu8s_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_C");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_C");
    check_field_offset(lv, v3, 9, "Ul_BFu8s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_C, Ul_BFu8s_C)
//============================================================================


struct  Ul_BFu8s_D  {
  __tsu64 v1;
  unsigned short v2:8;
  double v3;
};
//SIG(1 Ul_BFu8s_D) C1{ FL Fs:8 FL}



static void Test_Ul_BFu8s_D()
{
  {
    init_simple_test("Ul_BFu8s_D");
    static STRUCT_IF_C Ul_BFu8s_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_BFu8s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_D");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_D");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu8s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_D, Ul_BFu8s_D)
//============================================================================


struct  Ul_BFu8s_F  {
  __tsu64 v1;
  unsigned short v2:8;
  float v3;
};
//SIG(1 Ul_BFu8s_F) C1{ FL Fs:8 Fi}



static void Test_Ul_BFu8s_F()
{
  {
    init_simple_test("Ul_BFu8s_F");
    static STRUCT_IF_C Ul_BFu8s_F lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_F");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_F");
    check_field_offset(lv, v3, 12, "Ul_BFu8s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_F, Ul_BFu8s_F)
//============================================================================


struct  Ul_BFu8s_I  {
  __tsu64 v1;
  unsigned short v2:8;
  int v3;
};
//SIG(1 Ul_BFu8s_I) C1{ FL Fs:8 Fi}



static void Test_Ul_BFu8s_I()
{
  {
    init_simple_test("Ul_BFu8s_I");
    static STRUCT_IF_C Ul_BFu8s_I lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_I");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_I");
    check_field_offset(lv, v3, 12, "Ul_BFu8s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_I, Ul_BFu8s_I)
//============================================================================


struct  Ul_BFu8s_Ip  {
  __tsu64 v1;
  unsigned short v2:8;
  int *v3;
};
//SIG(1 Ul_BFu8s_Ip) C1{ FL Fs:8 Fp}



static void Test_Ul_BFu8s_Ip()
{
  {
    init_simple_test("Ul_BFu8s_Ip");
    static STRUCT_IF_C Ul_BFu8s_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_BFu8s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_Ip");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_Ip");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu8s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_Ip, Ul_BFu8s_Ip)
//============================================================================


struct  Ul_BFu8s_L  {
  __tsu64 v1;
  unsigned short v2:8;
  __tsi64 v3;
};
//SIG(1 Ul_BFu8s_L) C1{ FL Fs:8 FL}



static void Test_Ul_BFu8s_L()
{
  {
    init_simple_test("Ul_BFu8s_L");
    static STRUCT_IF_C Ul_BFu8s_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_BFu8s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_L");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_L");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu8s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_L, Ul_BFu8s_L)
//============================================================================


struct  Ul_BFu8s_S  {
  __tsu64 v1;
  unsigned short v2:8;
  short v3;
};
//SIG(1 Ul_BFu8s_S) C1{ FL Fs:8 Fs}



static void Test_Ul_BFu8s_S()
{
  {
    init_simple_test("Ul_BFu8s_S");
    static STRUCT_IF_C Ul_BFu8s_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_S");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_S");
    check_field_offset(lv, v3, 10, "Ul_BFu8s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_S, Ul_BFu8s_S)
//============================================================================


struct  Ul_BFu8s_Uc  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned char v3;
};
//SIG(1 Ul_BFu8s_Uc) C1{ FL Fs:8 Fc}



static void Test_Ul_BFu8s_Uc()
{
  {
    init_simple_test("Ul_BFu8s_Uc");
    static STRUCT_IF_C Ul_BFu8s_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_Uc");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_Uc");
    check_field_offset(lv, v3, 9, "Ul_BFu8s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_Uc, Ul_BFu8s_Uc)
//============================================================================


struct  Ul_BFu8s_Ui  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned int v3;
};
//SIG(1 Ul_BFu8s_Ui) C1{ FL Fs:8 Fi}



static void Test_Ul_BFu8s_Ui()
{
  {
    init_simple_test("Ul_BFu8s_Ui");
    static STRUCT_IF_C Ul_BFu8s_Ui lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu8s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_Ui");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_Ui");
    check_field_offset(lv, v3, 12, "Ul_BFu8s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_Ui, Ul_BFu8s_Ui)
//============================================================================


struct  Ul_BFu8s_Ul  {
  __tsu64 v1;
  unsigned short v2:8;
  __tsu64 v3;
};
//SIG(1 Ul_BFu8s_Ul) C1{ FL Fs:8 FL}



static void Test_Ul_BFu8s_Ul()
{
  {
    init_simple_test("Ul_BFu8s_Ul");
    static STRUCT_IF_C Ul_BFu8s_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_BFu8s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_Ul");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_Ul");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu8s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_Ul, Ul_BFu8s_Ul)
//============================================================================


struct  Ul_BFu8s_Us  {
  __tsu64 v1;
  unsigned short v2:8;
  unsigned short v3;
};
//SIG(1 Ul_BFu8s_Us) C1{ FL Fs:8 Fs}



static void Test_Ul_BFu8s_Us()
{
  {
    init_simple_test("Ul_BFu8s_Us");
    static STRUCT_IF_C Ul_BFu8s_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu8s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_Us");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_Us");
    check_field_offset(lv, v3, 10, "Ul_BFu8s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_Us, Ul_BFu8s_Us)
//============================================================================


struct  Ul_BFu8s_Vp  {
  __tsu64 v1;
  unsigned short v2:8;
  void *v3;
};
//SIG(1 Ul_BFu8s_Vp) C1{ FL Fs:8 Fp}



static void Test_Ul_BFu8s_Vp()
{
  {
    init_simple_test("Ul_BFu8s_Vp");
    static STRUCT_IF_C Ul_BFu8s_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_BFu8s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu8s_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu8s_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 8, 1, "Ul_BFu8s_Vp");
    set_bf_and_test(lv, v2, 8, 0, 8, hide_ull(1LL<<7), "Ul_BFu8s_Vp");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu8s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu8s_Vp, Ul_BFu8s_Vp)
//============================================================================


struct  Ul_BFu9i  {
  __tsu64 v1;
  unsigned int v2:9;
};
//SIG(1 Ul_BFu9i) C1{ FL Fi:9}



static void Test_Ul_BFu9i()
{
  {
    init_simple_test("Ul_BFu9i");
    static STRUCT_IF_C Ul_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i, Ul_BFu9i)
//============================================================================


struct  Ul_BFu9i_BFu15i  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned int v3:15;
};
//SIG(1 Ul_BFu9i_BFu15i) C1{ FL Fi:9 Fi:15}



static void Test_Ul_BFu9i_BFu15i()
{
  {
    init_simple_test("Ul_BFu9i_BFu15i");
    static STRUCT_IF_C Ul_BFu9i_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "Ul_BFu9i_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "Ul_BFu9i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu15i, Ul_BFu9i_BFu15i)
//============================================================================


struct  Ul_BFu9i_BFu15ll  {
  __tsu64 v1;
  unsigned int v2:9;
  __tsu64 v3:15;
};
//SIG(1 Ul_BFu9i_BFu15ll) C1{ FL Fi:9 FL:15}



static void Test_Ul_BFu9i_BFu15ll()
{
  {
    init_simple_test("Ul_BFu9i_BFu15ll");
    static STRUCT_IF_C Ul_BFu9i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "Ul_BFu9i_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "Ul_BFu9i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu15ll, Ul_BFu9i_BFu15ll)
//============================================================================


struct  Ul_BFu9i_BFu15s  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned short v3:15;
};
//SIG(1 Ul_BFu9i_BFu15s) C1{ FL Fi:9 Fs:15}



static void Test_Ul_BFu9i_BFu15s()
{
  {
    init_simple_test("Ul_BFu9i_BFu15s");
    static STRUCT_IF_C Ul_BFu9i_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_BFu9i_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_BFu9i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu15s, Ul_BFu9i_BFu15s)
//============================================================================


struct  Ul_BFu9i_BFu16i  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned int v3:16;
};
//SIG(1 Ul_BFu9i_BFu16i) C1{ FL Fi:9 Fi:16}



static void Test_Ul_BFu9i_BFu16i()
{
  {
    init_simple_test("Ul_BFu9i_BFu16i");
    static STRUCT_IF_C Ul_BFu9i_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "Ul_BFu9i_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "Ul_BFu9i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu16i, Ul_BFu9i_BFu16i)
//============================================================================


struct  Ul_BFu9i_BFu16ll  {
  __tsu64 v1;
  unsigned int v2:9;
  __tsu64 v3:16;
};
//SIG(1 Ul_BFu9i_BFu16ll) C1{ FL Fi:9 FL:16}



static void Test_Ul_BFu9i_BFu16ll()
{
  {
    init_simple_test("Ul_BFu9i_BFu16ll");
    static STRUCT_IF_C Ul_BFu9i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "Ul_BFu9i_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "Ul_BFu9i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu16ll, Ul_BFu9i_BFu16ll)
//============================================================================


struct  Ul_BFu9i_BFu16s  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned short v3:16;
};
//SIG(1 Ul_BFu9i_BFu16s) C1{ FL Fi:9 Fs:16}



static void Test_Ul_BFu9i_BFu16s()
{
  {
    init_simple_test("Ul_BFu9i_BFu16s");
    static STRUCT_IF_C Ul_BFu9i_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_BFu9i_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_BFu9i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu16s, Ul_BFu9i_BFu16s)
//============================================================================


struct  Ul_BFu9i_BFu17i  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned int v3:17;
};
//SIG(1 Ul_BFu9i_BFu17i) C1{ FL Fi:9 Fi:17}



static void Test_Ul_BFu9i_BFu17i()
{
  {
    init_simple_test("Ul_BFu9i_BFu17i");
    static STRUCT_IF_C Ul_BFu9i_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "Ul_BFu9i_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "Ul_BFu9i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu17i, Ul_BFu9i_BFu17i)
//============================================================================


struct  Ul_BFu9i_BFu17ll  {
  __tsu64 v1;
  unsigned int v2:9;
  __tsu64 v3:17;
};
//SIG(1 Ul_BFu9i_BFu17ll) C1{ FL Fi:9 FL:17}



static void Test_Ul_BFu9i_BFu17ll()
{
  {
    init_simple_test("Ul_BFu9i_BFu17ll");
    static STRUCT_IF_C Ul_BFu9i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "Ul_BFu9i_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "Ul_BFu9i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu17ll, Ul_BFu9i_BFu17ll)
//============================================================================


struct  Ul_BFu9i_BFu1c  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned char v3:1;
};
//SIG(1 Ul_BFu9i_BFu1c) C1{ FL Fi:9 Fc:1}



static void Test_Ul_BFu9i_BFu1c()
{
  {
    init_simple_test("Ul_BFu9i_BFu1c");
    static STRUCT_IF_C Ul_BFu9i_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu1c");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "Ul_BFu9i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu1c, Ul_BFu9i_BFu1c)
//============================================================================


struct  Ul_BFu9i_BFu1i  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned int v3:1;
};
//SIG(1 Ul_BFu9i_BFu1i) C1{ FL Fi:9 Fi:1}



static void Test_Ul_BFu9i_BFu1i()
{
  {
    init_simple_test("Ul_BFu9i_BFu1i");
    static STRUCT_IF_C Ul_BFu9i_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu1i");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "Ul_BFu9i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu1i, Ul_BFu9i_BFu1i)
//============================================================================


struct  Ul_BFu9i_BFu1ll  {
  __tsu64 v1;
  unsigned int v2:9;
  __tsu64 v3:1;
};
//SIG(1 Ul_BFu9i_BFu1ll) C1{ FL Fi:9 FL:1}



static void Test_Ul_BFu9i_BFu1ll()
{
  {
    init_simple_test("Ul_BFu9i_BFu1ll");
    static STRUCT_IF_C Ul_BFu9i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu1ll");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "Ul_BFu9i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu1ll, Ul_BFu9i_BFu1ll)
//============================================================================


struct  Ul_BFu9i_BFu1s  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned short v3:1;
};
//SIG(1 Ul_BFu9i_BFu1s) C1{ FL Fi:9 Fs:1}



static void Test_Ul_BFu9i_BFu1s()
{
  {
    init_simple_test("Ul_BFu9i_BFu1s");
    static STRUCT_IF_C Ul_BFu9i_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu1s");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "Ul_BFu9i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu1s, Ul_BFu9i_BFu1s)
//============================================================================


struct  Ul_BFu9i_BFu31i  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned int v3:31;
};
//SIG(1 Ul_BFu9i_BFu31i) C1{ FL Fi:9 Fi:31}



static void Test_Ul_BFu9i_BFu31i()
{
  {
    init_simple_test("Ul_BFu9i_BFu31i");
    static STRUCT_IF_C Ul_BFu9i_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9i_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "Ul_BFu9i_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "Ul_BFu9i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu31i, Ul_BFu9i_BFu31i)
//============================================================================


struct  Ul_BFu9i_BFu31ll  {
  __tsu64 v1;
  unsigned int v2:9;
  __tsu64 v3:31;
};
//SIG(1 Ul_BFu9i_BFu31ll) C1{ FL Fi:9 FL:31}



static void Test_Ul_BFu9i_BFu31ll()
{
  {
    init_simple_test("Ul_BFu9i_BFu31ll");
    static STRUCT_IF_C Ul_BFu9i_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "Ul_BFu9i_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "Ul_BFu9i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu31ll, Ul_BFu9i_BFu31ll)
//============================================================================


struct  Ul_BFu9i_BFu32i  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned int v3:32;
};
//SIG(1 Ul_BFu9i_BFu32i) C1{ FL Fi:9 Fi:32}



static void Test_Ul_BFu9i_BFu32i()
{
  {
    init_simple_test("Ul_BFu9i_BFu32i");
    static STRUCT_IF_C Ul_BFu9i_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9i_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_BFu9i_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_BFu9i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu32i, Ul_BFu9i_BFu32i)
//============================================================================


struct  Ul_BFu9i_BFu32ll  {
  __tsu64 v1;
  unsigned int v2:9;
  __tsu64 v3:32;
};
//SIG(1 Ul_BFu9i_BFu32ll) C1{ FL Fi:9 FL:32}



static void Test_Ul_BFu9i_BFu32ll()
{
  {
    init_simple_test("Ul_BFu9i_BFu32ll");
    static STRUCT_IF_C Ul_BFu9i_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "Ul_BFu9i_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "Ul_BFu9i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu32ll, Ul_BFu9i_BFu32ll)
//============================================================================


struct  Ul_BFu9i_BFu33  {
  __tsu64 v1;
  unsigned int v2:9;
  __tsu64 v3:33;
};
//SIG(1 Ul_BFu9i_BFu33) C1{ FL Fi:9 FL:33}



static void Test_Ul_BFu9i_BFu33()
{
  {
    init_simple_test("Ul_BFu9i_BFu33");
    static STRUCT_IF_C Ul_BFu9i_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, 1, "Ul_BFu9i_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, hide_ull(1LL<<32), "Ul_BFu9i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu33, Ul_BFu9i_BFu33)
//============================================================================


struct  Ul_BFu9i_BFu7c  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned char v3:7;
};
//SIG(1 Ul_BFu9i_BFu7c) C1{ FL Fi:9 Fc:7}



static void Test_Ul_BFu9i_BFu7c()
{
  {
    init_simple_test("Ul_BFu9i_BFu7c");
    static STRUCT_IF_C Ul_BFu9i_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "Ul_BFu9i_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "Ul_BFu9i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu7c, Ul_BFu9i_BFu7c)
//============================================================================


struct  Ul_BFu9i_BFu7i  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned int v3:7;
};
//SIG(1 Ul_BFu9i_BFu7i) C1{ FL Fi:9 Fi:7}



static void Test_Ul_BFu9i_BFu7i()
{
  {
    init_simple_test("Ul_BFu9i_BFu7i");
    static STRUCT_IF_C Ul_BFu9i_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "Ul_BFu9i_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "Ul_BFu9i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu7i, Ul_BFu9i_BFu7i)
//============================================================================


struct  Ul_BFu9i_BFu7ll  {
  __tsu64 v1;
  unsigned int v2:9;
  __tsu64 v3:7;
};
//SIG(1 Ul_BFu9i_BFu7ll) C1{ FL Fi:9 FL:7}



static void Test_Ul_BFu9i_BFu7ll()
{
  {
    init_simple_test("Ul_BFu9i_BFu7ll");
    static STRUCT_IF_C Ul_BFu9i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "Ul_BFu9i_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "Ul_BFu9i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu7ll, Ul_BFu9i_BFu7ll)
//============================================================================


struct  Ul_BFu9i_BFu7s  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned short v3:7;
};
//SIG(1 Ul_BFu9i_BFu7s) C1{ FL Fi:9 Fs:7}



static void Test_Ul_BFu9i_BFu7s()
{
  {
    init_simple_test("Ul_BFu9i_BFu7s");
    static STRUCT_IF_C Ul_BFu9i_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "Ul_BFu9i_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "Ul_BFu9i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu7s, Ul_BFu9i_BFu7s)
//============================================================================


struct  Ul_BFu9i_BFu8c  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned char v3:8;
};
//SIG(1 Ul_BFu9i_BFu8c) C1{ FL Fi:9 Fc:8}



static void Test_Ul_BFu9i_BFu8c()
{
  {
    init_simple_test("Ul_BFu9i_BFu8c");
    static STRUCT_IF_C Ul_BFu9i_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_BFu9i_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_BFu9i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu8c, Ul_BFu9i_BFu8c)
//============================================================================


struct  Ul_BFu9i_BFu8i  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned int v3:8;
};
//SIG(1 Ul_BFu9i_BFu8i) C1{ FL Fi:9 Fi:8}



static void Test_Ul_BFu9i_BFu8i()
{
  {
    init_simple_test("Ul_BFu9i_BFu8i");
    static STRUCT_IF_C Ul_BFu9i_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "Ul_BFu9i_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "Ul_BFu9i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu8i, Ul_BFu9i_BFu8i)
//============================================================================


struct  Ul_BFu9i_BFu8ll  {
  __tsu64 v1;
  unsigned int v2:9;
  __tsu64 v3:8;
};
//SIG(1 Ul_BFu9i_BFu8ll) C1{ FL Fi:9 FL:8}



static void Test_Ul_BFu9i_BFu8ll()
{
  {
    init_simple_test("Ul_BFu9i_BFu8ll");
    static STRUCT_IF_C Ul_BFu9i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "Ul_BFu9i_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "Ul_BFu9i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu8ll, Ul_BFu9i_BFu8ll)
//============================================================================


struct  Ul_BFu9i_BFu8s  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned short v3:8;
};
//SIG(1 Ul_BFu9i_BFu8s) C1{ FL Fi:9 Fs:8}



static void Test_Ul_BFu9i_BFu8s()
{
  {
    init_simple_test("Ul_BFu9i_BFu8s");
    static STRUCT_IF_C Ul_BFu9i_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_BFu9i_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_BFu9i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu8s, Ul_BFu9i_BFu8s)
//============================================================================


struct  Ul_BFu9i_BFu9i  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned int v3:9;
};
//SIG(1 Ul_BFu9i_BFu9i) C1{ FL Fi:9 Fi:9}



static void Test_Ul_BFu9i_BFu9i()
{
  {
    init_simple_test("Ul_BFu9i_BFu9i");
    static STRUCT_IF_C Ul_BFu9i_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "Ul_BFu9i_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu9i, Ul_BFu9i_BFu9i)
//============================================================================


struct  Ul_BFu9i_BFu9ll  {
  __tsu64 v1;
  unsigned int v2:9;
  __tsu64 v3:9;
};
//SIG(1 Ul_BFu9i_BFu9ll) C1{ FL Fi:9 FL:9}



static void Test_Ul_BFu9i_BFu9ll()
{
  {
    init_simple_test("Ul_BFu9i_BFu9ll");
    static STRUCT_IF_C Ul_BFu9i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "Ul_BFu9i_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu9ll, Ul_BFu9i_BFu9ll)
//============================================================================


struct  Ul_BFu9i_BFu9s  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned short v3:9;
};
//SIG(1 Ul_BFu9i_BFu9s) C1{ FL Fi:9 Fs:9}



static void Test_Ul_BFu9i_BFu9s()
{
  {
    init_simple_test("Ul_BFu9i_BFu9s");
    static STRUCT_IF_C Ul_BFu9i_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_BFu9i_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_BFu9s, Ul_BFu9i_BFu9s)
//============================================================================


struct  Ul_BFu9i_C  {
  __tsu64 v1;
  unsigned int v2:9;
  char v3;
};
//SIG(1 Ul_BFu9i_C) C1{ FL Fi:9 Fc}



static void Test_Ul_BFu9i_C()
{
  {
    init_simple_test("Ul_BFu9i_C");
    static STRUCT_IF_C Ul_BFu9i_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_C");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_C");
    check_field_offset(lv, v3, 10, "Ul_BFu9i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_C, Ul_BFu9i_C)
//============================================================================


struct  Ul_BFu9i_D  {
  __tsu64 v1;
  unsigned int v2:9;
  double v3;
};
//SIG(1 Ul_BFu9i_D) C1{ FL Fi:9 FL}



static void Test_Ul_BFu9i_D()
{
  {
    init_simple_test("Ul_BFu9i_D");
    static STRUCT_IF_C Ul_BFu9i_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_BFu9i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_D");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_D");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu9i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_D, Ul_BFu9i_D)
//============================================================================


struct  Ul_BFu9i_F  {
  __tsu64 v1;
  unsigned int v2:9;
  float v3;
};
//SIG(1 Ul_BFu9i_F) C1{ FL Fi:9 Fi}



static void Test_Ul_BFu9i_F()
{
  {
    init_simple_test("Ul_BFu9i_F");
    static STRUCT_IF_C Ul_BFu9i_F lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9i_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_F");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_F");
    check_field_offset(lv, v3, 12, "Ul_BFu9i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_F, Ul_BFu9i_F)
//============================================================================


struct  Ul_BFu9i_I  {
  __tsu64 v1;
  unsigned int v2:9;
  int v3;
};
//SIG(1 Ul_BFu9i_I) C1{ FL Fi:9 Fi}



static void Test_Ul_BFu9i_I()
{
  {
    init_simple_test("Ul_BFu9i_I");
    static STRUCT_IF_C Ul_BFu9i_I lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9i_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_I");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_I");
    check_field_offset(lv, v3, 12, "Ul_BFu9i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_I, Ul_BFu9i_I)
//============================================================================


struct  Ul_BFu9i_Ip  {
  __tsu64 v1;
  unsigned int v2:9;
  int *v3;
};
//SIG(1 Ul_BFu9i_Ip) C1{ FL Fi:9 Fp}



static void Test_Ul_BFu9i_Ip()
{
  {
    init_simple_test("Ul_BFu9i_Ip");
    static STRUCT_IF_C Ul_BFu9i_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_BFu9i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_Ip");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_Ip");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu9i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_Ip, Ul_BFu9i_Ip)
//============================================================================


struct  Ul_BFu9i_L  {
  __tsu64 v1;
  unsigned int v2:9;
  __tsi64 v3;
};
//SIG(1 Ul_BFu9i_L) C1{ FL Fi:9 FL}



static void Test_Ul_BFu9i_L()
{
  {
    init_simple_test("Ul_BFu9i_L");
    static STRUCT_IF_C Ul_BFu9i_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_BFu9i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_L");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_L");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu9i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_L, Ul_BFu9i_L)
//============================================================================


struct  Ul_BFu9i_S  {
  __tsu64 v1;
  unsigned int v2:9;
  short v3;
};
//SIG(1 Ul_BFu9i_S) C1{ FL Fi:9 Fs}



static void Test_Ul_BFu9i_S()
{
  {
    init_simple_test("Ul_BFu9i_S");
    static STRUCT_IF_C Ul_BFu9i_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_S");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_S");
    check_field_offset(lv, v3, 10, "Ul_BFu9i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_S, Ul_BFu9i_S)
//============================================================================


struct  Ul_BFu9i_Uc  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned char v3;
};
//SIG(1 Ul_BFu9i_Uc) C1{ FL Fi:9 Fc}



static void Test_Ul_BFu9i_Uc()
{
  {
    init_simple_test("Ul_BFu9i_Uc");
    static STRUCT_IF_C Ul_BFu9i_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_Uc");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_Uc");
    check_field_offset(lv, v3, 10, "Ul_BFu9i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_Uc, Ul_BFu9i_Uc)
//============================================================================


struct  Ul_BFu9i_Ui  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned int v3;
};
//SIG(1 Ul_BFu9i_Ui) C1{ FL Fi:9 Fi}



static void Test_Ul_BFu9i_Ui()
{
  {
    init_simple_test("Ul_BFu9i_Ui");
    static STRUCT_IF_C Ul_BFu9i_Ui lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9i_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_Ui");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_Ui");
    check_field_offset(lv, v3, 12, "Ul_BFu9i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_Ui, Ul_BFu9i_Ui)
//============================================================================


struct  Ul_BFu9i_Ul  {
  __tsu64 v1;
  unsigned int v2:9;
  __tsu64 v3;
};
//SIG(1 Ul_BFu9i_Ul) C1{ FL Fi:9 FL}



static void Test_Ul_BFu9i_Ul()
{
  {
    init_simple_test("Ul_BFu9i_Ul");
    static STRUCT_IF_C Ul_BFu9i_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_BFu9i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_Ul");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_Ul");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu9i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_Ul, Ul_BFu9i_Ul)
//============================================================================


struct  Ul_BFu9i_Us  {
  __tsu64 v1;
  unsigned int v2:9;
  unsigned short v3;
};
//SIG(1 Ul_BFu9i_Us) C1{ FL Fi:9 Fs}



static void Test_Ul_BFu9i_Us()
{
  {
    init_simple_test("Ul_BFu9i_Us");
    static STRUCT_IF_C Ul_BFu9i_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9i_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_Us");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_Us");
    check_field_offset(lv, v3, 10, "Ul_BFu9i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_Us, Ul_BFu9i_Us)
//============================================================================


struct  Ul_BFu9i_Vp  {
  __tsu64 v1;
  unsigned int v2:9;
  void *v3;
};
//SIG(1 Ul_BFu9i_Vp) C1{ FL Fi:9 Fp}



static void Test_Ul_BFu9i_Vp()
{
  {
    init_simple_test("Ul_BFu9i_Vp");
    static STRUCT_IF_C Ul_BFu9i_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_BFu9i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9i_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu9i_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9i_Vp");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9i_Vp");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu9i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9i_Vp, Ul_BFu9i_Vp)
//============================================================================


struct  Ul_BFu9ll  {
  __tsu64 v1;
  __tsu64 v2:9;
};
//SIG(1 Ul_BFu9ll) C1{ FL FL:9}



static void Test_Ul_BFu9ll()
{
  {
    init_simple_test("Ul_BFu9ll");
    static STRUCT_IF_C Ul_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll, Ul_BFu9ll)
//============================================================================


struct  Ul_BFu9ll_BFu15i  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned int v3:15;
};
//SIG(1 Ul_BFu9ll_BFu15i) C1{ FL FL:9 Fi:15}



static void Test_Ul_BFu9ll_BFu15i()
{
  {
    init_simple_test("Ul_BFu9ll_BFu15i");
    static STRUCT_IF_C Ul_BFu9ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "Ul_BFu9ll_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "Ul_BFu9ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu15i, Ul_BFu9ll_BFu15i)
//============================================================================


struct  Ul_BFu9ll_BFu15ll  {
  __tsu64 v1;
  __tsu64 v2:9;
  __tsu64 v3:15;
};
//SIG(1 Ul_BFu9ll_BFu15ll) C1{ FL FL:9 FL:15}



static void Test_Ul_BFu9ll_BFu15ll()
{
  {
    init_simple_test("Ul_BFu9ll_BFu15ll");
    static STRUCT_IF_C Ul_BFu9ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "Ul_BFu9ll_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "Ul_BFu9ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu15ll, Ul_BFu9ll_BFu15ll)
//============================================================================


struct  Ul_BFu9ll_BFu15s  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned short v3:15;
};
//SIG(1 Ul_BFu9ll_BFu15s) C1{ FL FL:9 Fs:15}



static void Test_Ul_BFu9ll_BFu15s()
{
  {
    init_simple_test("Ul_BFu9ll_BFu15s");
    static STRUCT_IF_C Ul_BFu9ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_BFu9ll_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_BFu9ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu15s, Ul_BFu9ll_BFu15s)
//============================================================================


struct  Ul_BFu9ll_BFu16i  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned int v3:16;
};
//SIG(1 Ul_BFu9ll_BFu16i) C1{ FL FL:9 Fi:16}



static void Test_Ul_BFu9ll_BFu16i()
{
  {
    init_simple_test("Ul_BFu9ll_BFu16i");
    static STRUCT_IF_C Ul_BFu9ll_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "Ul_BFu9ll_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "Ul_BFu9ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu16i, Ul_BFu9ll_BFu16i)
//============================================================================


struct  Ul_BFu9ll_BFu16ll  {
  __tsu64 v1;
  __tsu64 v2:9;
  __tsu64 v3:16;
};
//SIG(1 Ul_BFu9ll_BFu16ll) C1{ FL FL:9 FL:16}



static void Test_Ul_BFu9ll_BFu16ll()
{
  {
    init_simple_test("Ul_BFu9ll_BFu16ll");
    static STRUCT_IF_C Ul_BFu9ll_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "Ul_BFu9ll_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "Ul_BFu9ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu16ll, Ul_BFu9ll_BFu16ll)
//============================================================================


struct  Ul_BFu9ll_BFu16s  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned short v3:16;
};
//SIG(1 Ul_BFu9ll_BFu16s) C1{ FL FL:9 Fs:16}



static void Test_Ul_BFu9ll_BFu16s()
{
  {
    init_simple_test("Ul_BFu9ll_BFu16s");
    static STRUCT_IF_C Ul_BFu9ll_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_BFu9ll_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_BFu9ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu16s, Ul_BFu9ll_BFu16s)
//============================================================================


struct  Ul_BFu9ll_BFu17i  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned int v3:17;
};
//SIG(1 Ul_BFu9ll_BFu17i) C1{ FL FL:9 Fi:17}



static void Test_Ul_BFu9ll_BFu17i()
{
  {
    init_simple_test("Ul_BFu9ll_BFu17i");
    static STRUCT_IF_C Ul_BFu9ll_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "Ul_BFu9ll_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "Ul_BFu9ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu17i, Ul_BFu9ll_BFu17i)
//============================================================================


struct  Ul_BFu9ll_BFu17ll  {
  __tsu64 v1;
  __tsu64 v2:9;
  __tsu64 v3:17;
};
//SIG(1 Ul_BFu9ll_BFu17ll) C1{ FL FL:9 FL:17}



static void Test_Ul_BFu9ll_BFu17ll()
{
  {
    init_simple_test("Ul_BFu9ll_BFu17ll");
    static STRUCT_IF_C Ul_BFu9ll_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "Ul_BFu9ll_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "Ul_BFu9ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu17ll, Ul_BFu9ll_BFu17ll)
//============================================================================


struct  Ul_BFu9ll_BFu1c  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned char v3:1;
};
//SIG(1 Ul_BFu9ll_BFu1c) C1{ FL FL:9 Fc:1}



static void Test_Ul_BFu9ll_BFu1c()
{
  {
    init_simple_test("Ul_BFu9ll_BFu1c");
    static STRUCT_IF_C Ul_BFu9ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu1c");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "Ul_BFu9ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu1c, Ul_BFu9ll_BFu1c)
//============================================================================


struct  Ul_BFu9ll_BFu1i  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned int v3:1;
};
//SIG(1 Ul_BFu9ll_BFu1i) C1{ FL FL:9 Fi:1}



static void Test_Ul_BFu9ll_BFu1i()
{
  {
    init_simple_test("Ul_BFu9ll_BFu1i");
    static STRUCT_IF_C Ul_BFu9ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu1i");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "Ul_BFu9ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu1i, Ul_BFu9ll_BFu1i)
//============================================================================


struct  Ul_BFu9ll_BFu1ll  {
  __tsu64 v1;
  __tsu64 v2:9;
  __tsu64 v3:1;
};
//SIG(1 Ul_BFu9ll_BFu1ll) C1{ FL FL:9 FL:1}



static void Test_Ul_BFu9ll_BFu1ll()
{
  {
    init_simple_test("Ul_BFu9ll_BFu1ll");
    static STRUCT_IF_C Ul_BFu9ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu1ll");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "Ul_BFu9ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu1ll, Ul_BFu9ll_BFu1ll)
//============================================================================


struct  Ul_BFu9ll_BFu1s  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned short v3:1;
};
//SIG(1 Ul_BFu9ll_BFu1s) C1{ FL FL:9 Fs:1}



static void Test_Ul_BFu9ll_BFu1s()
{
  {
    init_simple_test("Ul_BFu9ll_BFu1s");
    static STRUCT_IF_C Ul_BFu9ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu1s");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "Ul_BFu9ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu1s, Ul_BFu9ll_BFu1s)
//============================================================================


struct  Ul_BFu9ll_BFu31i  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned int v3:31;
};
//SIG(1 Ul_BFu9ll_BFu31i) C1{ FL FL:9 Fi:31}



static void Test_Ul_BFu9ll_BFu31i()
{
  {
    init_simple_test("Ul_BFu9ll_BFu31i");
    static STRUCT_IF_C Ul_BFu9ll_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "Ul_BFu9ll_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "Ul_BFu9ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu31i, Ul_BFu9ll_BFu31i)
//============================================================================


struct  Ul_BFu9ll_BFu31ll  {
  __tsu64 v1;
  __tsu64 v2:9;
  __tsu64 v3:31;
};
//SIG(1 Ul_BFu9ll_BFu31ll) C1{ FL FL:9 FL:31}



static void Test_Ul_BFu9ll_BFu31ll()
{
  {
    init_simple_test("Ul_BFu9ll_BFu31ll");
    static STRUCT_IF_C Ul_BFu9ll_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "Ul_BFu9ll_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "Ul_BFu9ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu31ll, Ul_BFu9ll_BFu31ll)
//============================================================================


struct  Ul_BFu9ll_BFu32i  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned int v3:32;
};
//SIG(1 Ul_BFu9ll_BFu32i) C1{ FL FL:9 Fi:32}



static void Test_Ul_BFu9ll_BFu32i()
{
  {
    init_simple_test("Ul_BFu9ll_BFu32i");
    static STRUCT_IF_C Ul_BFu9ll_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_BFu9ll_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_BFu9ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu32i, Ul_BFu9ll_BFu32i)
//============================================================================


struct  Ul_BFu9ll_BFu32ll  {
  __tsu64 v1;
  __tsu64 v2:9;
  __tsu64 v3:32;
};
//SIG(1 Ul_BFu9ll_BFu32ll) C1{ FL FL:9 FL:32}



static void Test_Ul_BFu9ll_BFu32ll()
{
  {
    init_simple_test("Ul_BFu9ll_BFu32ll");
    static STRUCT_IF_C Ul_BFu9ll_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "Ul_BFu9ll_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "Ul_BFu9ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu32ll, Ul_BFu9ll_BFu32ll)
//============================================================================


struct  Ul_BFu9ll_BFu33  {
  __tsu64 v1;
  __tsu64 v2:9;
  __tsu64 v3:33;
};
//SIG(1 Ul_BFu9ll_BFu33) C1{ FL FL:9 FL:33}



static void Test_Ul_BFu9ll_BFu33()
{
  {
    init_simple_test("Ul_BFu9ll_BFu33");
    static STRUCT_IF_C Ul_BFu9ll_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, 1, "Ul_BFu9ll_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, hide_ull(1LL<<32), "Ul_BFu9ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu33, Ul_BFu9ll_BFu33)
//============================================================================


struct  Ul_BFu9ll_BFu7c  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned char v3:7;
};
//SIG(1 Ul_BFu9ll_BFu7c) C1{ FL FL:9 Fc:7}



static void Test_Ul_BFu9ll_BFu7c()
{
  {
    init_simple_test("Ul_BFu9ll_BFu7c");
    static STRUCT_IF_C Ul_BFu9ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "Ul_BFu9ll_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "Ul_BFu9ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu7c, Ul_BFu9ll_BFu7c)
//============================================================================


struct  Ul_BFu9ll_BFu7i  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned int v3:7;
};
//SIG(1 Ul_BFu9ll_BFu7i) C1{ FL FL:9 Fi:7}



static void Test_Ul_BFu9ll_BFu7i()
{
  {
    init_simple_test("Ul_BFu9ll_BFu7i");
    static STRUCT_IF_C Ul_BFu9ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "Ul_BFu9ll_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "Ul_BFu9ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu7i, Ul_BFu9ll_BFu7i)
//============================================================================


struct  Ul_BFu9ll_BFu7ll  {
  __tsu64 v1;
  __tsu64 v2:9;
  __tsu64 v3:7;
};
//SIG(1 Ul_BFu9ll_BFu7ll) C1{ FL FL:9 FL:7}



static void Test_Ul_BFu9ll_BFu7ll()
{
  {
    init_simple_test("Ul_BFu9ll_BFu7ll");
    static STRUCT_IF_C Ul_BFu9ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "Ul_BFu9ll_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "Ul_BFu9ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu7ll, Ul_BFu9ll_BFu7ll)
//============================================================================


struct  Ul_BFu9ll_BFu7s  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned short v3:7;
};
//SIG(1 Ul_BFu9ll_BFu7s) C1{ FL FL:9 Fs:7}



static void Test_Ul_BFu9ll_BFu7s()
{
  {
    init_simple_test("Ul_BFu9ll_BFu7s");
    static STRUCT_IF_C Ul_BFu9ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "Ul_BFu9ll_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "Ul_BFu9ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu7s, Ul_BFu9ll_BFu7s)
//============================================================================


struct  Ul_BFu9ll_BFu8c  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned char v3:8;
};
//SIG(1 Ul_BFu9ll_BFu8c) C1{ FL FL:9 Fc:8}



static void Test_Ul_BFu9ll_BFu8c()
{
  {
    init_simple_test("Ul_BFu9ll_BFu8c");
    static STRUCT_IF_C Ul_BFu9ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_BFu9ll_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_BFu9ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu8c, Ul_BFu9ll_BFu8c)
//============================================================================


struct  Ul_BFu9ll_BFu8i  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned int v3:8;
};
//SIG(1 Ul_BFu9ll_BFu8i) C1{ FL FL:9 Fi:8}



static void Test_Ul_BFu9ll_BFu8i()
{
  {
    init_simple_test("Ul_BFu9ll_BFu8i");
    static STRUCT_IF_C Ul_BFu9ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "Ul_BFu9ll_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "Ul_BFu9ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu8i, Ul_BFu9ll_BFu8i)
//============================================================================


struct  Ul_BFu9ll_BFu8ll  {
  __tsu64 v1;
  __tsu64 v2:9;
  __tsu64 v3:8;
};
//SIG(1 Ul_BFu9ll_BFu8ll) C1{ FL FL:9 FL:8}



static void Test_Ul_BFu9ll_BFu8ll()
{
  {
    init_simple_test("Ul_BFu9ll_BFu8ll");
    static STRUCT_IF_C Ul_BFu9ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "Ul_BFu9ll_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "Ul_BFu9ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu8ll, Ul_BFu9ll_BFu8ll)
//============================================================================


struct  Ul_BFu9ll_BFu8s  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned short v3:8;
};
//SIG(1 Ul_BFu9ll_BFu8s) C1{ FL FL:9 Fs:8}



static void Test_Ul_BFu9ll_BFu8s()
{
  {
    init_simple_test("Ul_BFu9ll_BFu8s");
    static STRUCT_IF_C Ul_BFu9ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_BFu9ll_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_BFu9ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu8s, Ul_BFu9ll_BFu8s)
//============================================================================


struct  Ul_BFu9ll_BFu9i  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned int v3:9;
};
//SIG(1 Ul_BFu9ll_BFu9i) C1{ FL FL:9 Fi:9}



static void Test_Ul_BFu9ll_BFu9i()
{
  {
    init_simple_test("Ul_BFu9ll_BFu9i");
    static STRUCT_IF_C Ul_BFu9ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "Ul_BFu9ll_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu9i, Ul_BFu9ll_BFu9i)
//============================================================================


struct  Ul_BFu9ll_BFu9ll  {
  __tsu64 v1;
  __tsu64 v2:9;
  __tsu64 v3:9;
};
//SIG(1 Ul_BFu9ll_BFu9ll) C1{ FL FL:9 FL:9}



static void Test_Ul_BFu9ll_BFu9ll()
{
  {
    init_simple_test("Ul_BFu9ll_BFu9ll");
    static STRUCT_IF_C Ul_BFu9ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "Ul_BFu9ll_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu9ll, Ul_BFu9ll_BFu9ll)
//============================================================================


struct  Ul_BFu9ll_BFu9s  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned short v3:9;
};
//SIG(1 Ul_BFu9ll_BFu9s) C1{ FL FL:9 Fs:9}



static void Test_Ul_BFu9ll_BFu9s()
{
  {
    init_simple_test("Ul_BFu9ll_BFu9s");
    static STRUCT_IF_C Ul_BFu9ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_BFu9ll_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_BFu9s, Ul_BFu9ll_BFu9s)
//============================================================================


struct  Ul_BFu9ll_C  {
  __tsu64 v1;
  __tsu64 v2:9;
  char v3;
};
//SIG(1 Ul_BFu9ll_C) C1{ FL FL:9 Fc}



static void Test_Ul_BFu9ll_C()
{
  {
    init_simple_test("Ul_BFu9ll_C");
    static STRUCT_IF_C Ul_BFu9ll_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_C");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_C");
    check_field_offset(lv, v3, 10, "Ul_BFu9ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_C, Ul_BFu9ll_C)
//============================================================================


struct  Ul_BFu9ll_D  {
  __tsu64 v1;
  __tsu64 v2:9;
  double v3;
};
//SIG(1 Ul_BFu9ll_D) C1{ FL FL:9 FL}



static void Test_Ul_BFu9ll_D()
{
  {
    init_simple_test("Ul_BFu9ll_D");
    static STRUCT_IF_C Ul_BFu9ll_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_BFu9ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_D");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_D");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu9ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_D, Ul_BFu9ll_D)
//============================================================================


struct  Ul_BFu9ll_F  {
  __tsu64 v1;
  __tsu64 v2:9;
  float v3;
};
//SIG(1 Ul_BFu9ll_F) C1{ FL FL:9 Fi}



static void Test_Ul_BFu9ll_F()
{
  {
    init_simple_test("Ul_BFu9ll_F");
    static STRUCT_IF_C Ul_BFu9ll_F lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_F");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_F");
    check_field_offset(lv, v3, 12, "Ul_BFu9ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_F, Ul_BFu9ll_F)
//============================================================================


struct  Ul_BFu9ll_I  {
  __tsu64 v1;
  __tsu64 v2:9;
  int v3;
};
//SIG(1 Ul_BFu9ll_I) C1{ FL FL:9 Fi}



static void Test_Ul_BFu9ll_I()
{
  {
    init_simple_test("Ul_BFu9ll_I");
    static STRUCT_IF_C Ul_BFu9ll_I lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_I");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_I");
    check_field_offset(lv, v3, 12, "Ul_BFu9ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_I, Ul_BFu9ll_I)
//============================================================================


struct  Ul_BFu9ll_Ip  {
  __tsu64 v1;
  __tsu64 v2:9;
  int *v3;
};
//SIG(1 Ul_BFu9ll_Ip) C1{ FL FL:9 Fp}



static void Test_Ul_BFu9ll_Ip()
{
  {
    init_simple_test("Ul_BFu9ll_Ip");
    static STRUCT_IF_C Ul_BFu9ll_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_BFu9ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_Ip");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_Ip");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu9ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_Ip, Ul_BFu9ll_Ip)
//============================================================================


struct  Ul_BFu9ll_L  {
  __tsu64 v1;
  __tsu64 v2:9;
  __tsi64 v3;
};
//SIG(1 Ul_BFu9ll_L) C1{ FL FL:9 FL}



static void Test_Ul_BFu9ll_L()
{
  {
    init_simple_test("Ul_BFu9ll_L");
    static STRUCT_IF_C Ul_BFu9ll_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_BFu9ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_L");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_L");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu9ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_L, Ul_BFu9ll_L)
//============================================================================


struct  Ul_BFu9ll_S  {
  __tsu64 v1;
  __tsu64 v2:9;
  short v3;
};
//SIG(1 Ul_BFu9ll_S) C1{ FL FL:9 Fs}



static void Test_Ul_BFu9ll_S()
{
  {
    init_simple_test("Ul_BFu9ll_S");
    static STRUCT_IF_C Ul_BFu9ll_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_S");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_S");
    check_field_offset(lv, v3, 10, "Ul_BFu9ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_S, Ul_BFu9ll_S)
//============================================================================


struct  Ul_BFu9ll_Uc  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned char v3;
};
//SIG(1 Ul_BFu9ll_Uc) C1{ FL FL:9 Fc}



static void Test_Ul_BFu9ll_Uc()
{
  {
    init_simple_test("Ul_BFu9ll_Uc");
    static STRUCT_IF_C Ul_BFu9ll_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_Uc");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_Uc");
    check_field_offset(lv, v3, 10, "Ul_BFu9ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_Uc, Ul_BFu9ll_Uc)
//============================================================================


struct  Ul_BFu9ll_Ui  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned int v3;
};
//SIG(1 Ul_BFu9ll_Ui) C1{ FL FL:9 Fi}



static void Test_Ul_BFu9ll_Ui()
{
  {
    init_simple_test("Ul_BFu9ll_Ui");
    static STRUCT_IF_C Ul_BFu9ll_Ui lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_Ui");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_Ui");
    check_field_offset(lv, v3, 12, "Ul_BFu9ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_Ui, Ul_BFu9ll_Ui)
//============================================================================


struct  Ul_BFu9ll_Ul  {
  __tsu64 v1;
  __tsu64 v2:9;
  __tsu64 v3;
};
//SIG(1 Ul_BFu9ll_Ul) C1{ FL FL:9 FL}



static void Test_Ul_BFu9ll_Ul()
{
  {
    init_simple_test("Ul_BFu9ll_Ul");
    static STRUCT_IF_C Ul_BFu9ll_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_BFu9ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_Ul");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_Ul");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu9ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_Ul, Ul_BFu9ll_Ul)
//============================================================================


struct  Ul_BFu9ll_Us  {
  __tsu64 v1;
  __tsu64 v2:9;
  unsigned short v3;
};
//SIG(1 Ul_BFu9ll_Us) C1{ FL FL:9 Fs}



static void Test_Ul_BFu9ll_Us()
{
  {
    init_simple_test("Ul_BFu9ll_Us");
    static STRUCT_IF_C Ul_BFu9ll_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_Us");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_Us");
    check_field_offset(lv, v3, 10, "Ul_BFu9ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_Us, Ul_BFu9ll_Us)
//============================================================================


struct  Ul_BFu9ll_Vp  {
  __tsu64 v1;
  __tsu64 v2:9;
  void *v3;
};
//SIG(1 Ul_BFu9ll_Vp) C1{ FL FL:9 Fp}



static void Test_Ul_BFu9ll_Vp()
{
  {
    init_simple_test("Ul_BFu9ll_Vp");
    static STRUCT_IF_C Ul_BFu9ll_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_BFu9ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9ll_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu9ll_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9ll_Vp");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9ll_Vp");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu9ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9ll_Vp, Ul_BFu9ll_Vp)
//============================================================================


struct  Ul_BFu9s  {
  __tsu64 v1;
  unsigned short v2:9;
};
//SIG(1 Ul_BFu9s) C1{ FL Fs:9}



static void Test_Ul_BFu9s()
{
  {
    init_simple_test("Ul_BFu9s");
    static STRUCT_IF_C Ul_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s, Ul_BFu9s)
//============================================================================


struct  Ul_BFu9s_BFu15i  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned int v3:15;
};
//SIG(1 Ul_BFu9s_BFu15i) C1{ FL Fs:9 Fi:15}



static void Test_Ul_BFu9s_BFu15i()
{
  {
    init_simple_test("Ul_BFu9s_BFu15i");
    static STRUCT_IF_C Ul_BFu9s_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu15i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu15i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "Ul_BFu9s_BFu15i");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "Ul_BFu9s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu15i, Ul_BFu9s_BFu15i)
//============================================================================


struct  Ul_BFu9s_BFu15ll  {
  __tsu64 v1;
  unsigned short v2:9;
  __tsu64 v3:15;
};
//SIG(1 Ul_BFu9s_BFu15ll) C1{ FL Fs:9 FL:15}



static void Test_Ul_BFu9s_BFu15ll()
{
  {
    init_simple_test("Ul_BFu9s_BFu15ll");
    static STRUCT_IF_C Ul_BFu9s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu15ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, 1, "Ul_BFu9s_BFu15ll");
    set_bf_and_test(lv, v3, 9, 1, 15, hide_ull(1LL<<14), "Ul_BFu9s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu15ll, Ul_BFu9s_BFu15ll)
//============================================================================


struct  Ul_BFu9s_BFu15s  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned short v3:15;
};
//SIG(1 Ul_BFu9s_BFu15s) C1{ FL Fs:9 Fs:15}



static void Test_Ul_BFu9s_BFu15s()
{
  {
    init_simple_test("Ul_BFu9s_BFu15s");
    static STRUCT_IF_C Ul_BFu9s_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu15s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu15s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_BFu9s_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_BFu9s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu15s, Ul_BFu9s_BFu15s)
//============================================================================


struct  Ul_BFu9s_BFu16i  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned int v3:16;
};
//SIG(1 Ul_BFu9s_BFu16i) C1{ FL Fs:9 Fi:16}



static void Test_Ul_BFu9s_BFu16i()
{
  {
    init_simple_test("Ul_BFu9s_BFu16i");
    static STRUCT_IF_C Ul_BFu9s_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu16i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu16i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "Ul_BFu9s_BFu16i");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "Ul_BFu9s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu16i, Ul_BFu9s_BFu16i)
//============================================================================


struct  Ul_BFu9s_BFu16ll  {
  __tsu64 v1;
  unsigned short v2:9;
  __tsu64 v3:16;
};
//SIG(1 Ul_BFu9s_BFu16ll) C1{ FL Fs:9 FL:16}



static void Test_Ul_BFu9s_BFu16ll()
{
  {
    init_simple_test("Ul_BFu9s_BFu16ll");
    static STRUCT_IF_C Ul_BFu9s_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu16ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, 1, "Ul_BFu9s_BFu16ll");
    set_bf_and_test(lv, v3, 9, 1, 16, hide_ull(1LL<<15), "Ul_BFu9s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu16ll, Ul_BFu9s_BFu16ll)
//============================================================================


struct  Ul_BFu9s_BFu16s  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned short v3:16;
};
//SIG(1 Ul_BFu9s_BFu16s) C1{ FL Fs:9 Fs:16}



static void Test_Ul_BFu9s_BFu16s()
{
  {
    init_simple_test("Ul_BFu9s_BFu16s");
    static STRUCT_IF_C Ul_BFu9s_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu16s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu16s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_BFu9s_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_BFu9s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu16s, Ul_BFu9s_BFu16s)
//============================================================================


struct  Ul_BFu9s_BFu17i  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned int v3:17;
};
//SIG(1 Ul_BFu9s_BFu17i) C1{ FL Fs:9 Fi:17}



static void Test_Ul_BFu9s_BFu17i()
{
  {
    init_simple_test("Ul_BFu9s_BFu17i");
    static STRUCT_IF_C Ul_BFu9s_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu17i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu17i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "Ul_BFu9s_BFu17i");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "Ul_BFu9s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu17i, Ul_BFu9s_BFu17i)
//============================================================================


struct  Ul_BFu9s_BFu17ll  {
  __tsu64 v1;
  unsigned short v2:9;
  __tsu64 v3:17;
};
//SIG(1 Ul_BFu9s_BFu17ll) C1{ FL Fs:9 FL:17}



static void Test_Ul_BFu9s_BFu17ll()
{
  {
    init_simple_test("Ul_BFu9s_BFu17ll");
    static STRUCT_IF_C Ul_BFu9s_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu17ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, 1, "Ul_BFu9s_BFu17ll");
    set_bf_and_test(lv, v3, 9, 1, 17, hide_ull(1LL<<16), "Ul_BFu9s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu17ll, Ul_BFu9s_BFu17ll)
//============================================================================


struct  Ul_BFu9s_BFu1c  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned char v3:1;
};
//SIG(1 Ul_BFu9s_BFu1c) C1{ FL Fs:9 Fc:1}



static void Test_Ul_BFu9s_BFu1c()
{
  {
    init_simple_test("Ul_BFu9s_BFu1c");
    static STRUCT_IF_C Ul_BFu9s_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu1c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu1c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu1c");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "Ul_BFu9s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu1c, Ul_BFu9s_BFu1c)
//============================================================================


struct  Ul_BFu9s_BFu1i  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned int v3:1;
};
//SIG(1 Ul_BFu9s_BFu1i) C1{ FL Fs:9 Fi:1}



static void Test_Ul_BFu9s_BFu1i()
{
  {
    init_simple_test("Ul_BFu9s_BFu1i");
    static STRUCT_IF_C Ul_BFu9s_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu1i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu1i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu1i");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "Ul_BFu9s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu1i, Ul_BFu9s_BFu1i)
//============================================================================


struct  Ul_BFu9s_BFu1ll  {
  __tsu64 v1;
  unsigned short v2:9;
  __tsu64 v3:1;
};
//SIG(1 Ul_BFu9s_BFu1ll) C1{ FL Fs:9 FL:1}



static void Test_Ul_BFu9s_BFu1ll()
{
  {
    init_simple_test("Ul_BFu9s_BFu1ll");
    static STRUCT_IF_C Ul_BFu9s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu1ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu1ll");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "Ul_BFu9s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu1ll, Ul_BFu9s_BFu1ll)
//============================================================================


struct  Ul_BFu9s_BFu1s  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned short v3:1;
};
//SIG(1 Ul_BFu9s_BFu1s) C1{ FL Fs:9 Fs:1}



static void Test_Ul_BFu9s_BFu1s()
{
  {
    init_simple_test("Ul_BFu9s_BFu1s");
    static STRUCT_IF_C Ul_BFu9s_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu1s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu1s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu1s");
    set_bf_and_test(lv, v3, 9, 1, 1, 1, "Ul_BFu9s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu1s, Ul_BFu9s_BFu1s)
//============================================================================


struct  Ul_BFu9s_BFu31i  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned int v3:31;
};
//SIG(1 Ul_BFu9s_BFu31i) C1{ FL Fs:9 Fi:31}



static void Test_Ul_BFu9s_BFu31i()
{
  {
    init_simple_test("Ul_BFu9s_BFu31i");
    static STRUCT_IF_C Ul_BFu9s_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9s_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu31i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu31i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "Ul_BFu9s_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "Ul_BFu9s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu31i, Ul_BFu9s_BFu31i)
//============================================================================


struct  Ul_BFu9s_BFu31ll  {
  __tsu64 v1;
  unsigned short v2:9;
  __tsu64 v3:31;
};
//SIG(1 Ul_BFu9s_BFu31ll) C1{ FL Fs:9 FL:31}



static void Test_Ul_BFu9s_BFu31ll()
{
  {
    init_simple_test("Ul_BFu9s_BFu31ll");
    static STRUCT_IF_C Ul_BFu9s_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu31ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, 1, "Ul_BFu9s_BFu31ll");
    set_bf_and_test(lv, v3, 9, 1, 31, hide_ull(1LL<<30), "Ul_BFu9s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu31ll, Ul_BFu9s_BFu31ll)
//============================================================================


struct  Ul_BFu9s_BFu32i  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned int v3:32;
};
//SIG(1 Ul_BFu9s_BFu32i) C1{ FL Fs:9 Fi:32}



static void Test_Ul_BFu9s_BFu32i()
{
  {
    init_simple_test("Ul_BFu9s_BFu32i");
    static STRUCT_IF_C Ul_BFu9s_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9s_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu32i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu32i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_BFu9s_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_BFu9s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu32i, Ul_BFu9s_BFu32i)
//============================================================================


struct  Ul_BFu9s_BFu32ll  {
  __tsu64 v1;
  unsigned short v2:9;
  __tsu64 v3:32;
};
//SIG(1 Ul_BFu9s_BFu32ll) C1{ FL Fs:9 FL:32}



static void Test_Ul_BFu9s_BFu32ll()
{
  {
    init_simple_test("Ul_BFu9s_BFu32ll");
    static STRUCT_IF_C Ul_BFu9s_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu32ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, 1, "Ul_BFu9s_BFu32ll");
    set_bf_and_test(lv, v3, 9, 1, 32, hide_ull(1LL<<31), "Ul_BFu9s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu32ll, Ul_BFu9s_BFu32ll)
//============================================================================


struct  Ul_BFu9s_BFu33  {
  __tsu64 v1;
  unsigned short v2:9;
  __tsu64 v3:33;
};
//SIG(1 Ul_BFu9s_BFu33) C1{ FL Fs:9 FL:33}



static void Test_Ul_BFu9s_BFu33()
{
  {
    init_simple_test("Ul_BFu9s_BFu33");
    static STRUCT_IF_C Ul_BFu9s_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu33.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu33");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, 1, "Ul_BFu9s_BFu33");
    set_bf_and_test(lv, v3, 9, 1, 33, hide_ull(1LL<<32), "Ul_BFu9s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu33, Ul_BFu9s_BFu33)
//============================================================================


struct  Ul_BFu9s_BFu7c  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned char v3:7;
};
//SIG(1 Ul_BFu9s_BFu7c) C1{ FL Fs:9 Fc:7}



static void Test_Ul_BFu9s_BFu7c()
{
  {
    init_simple_test("Ul_BFu9s_BFu7c");
    static STRUCT_IF_C Ul_BFu9s_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu7c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu7c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "Ul_BFu9s_BFu7c");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "Ul_BFu9s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu7c, Ul_BFu9s_BFu7c)
//============================================================================


struct  Ul_BFu9s_BFu7i  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned int v3:7;
};
//SIG(1 Ul_BFu9s_BFu7i) C1{ FL Fs:9 Fi:7}



static void Test_Ul_BFu9s_BFu7i()
{
  {
    init_simple_test("Ul_BFu9s_BFu7i");
    static STRUCT_IF_C Ul_BFu9s_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu7i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu7i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "Ul_BFu9s_BFu7i");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "Ul_BFu9s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu7i, Ul_BFu9s_BFu7i)
//============================================================================


struct  Ul_BFu9s_BFu7ll  {
  __tsu64 v1;
  unsigned short v2:9;
  __tsu64 v3:7;
};
//SIG(1 Ul_BFu9s_BFu7ll) C1{ FL Fs:9 FL:7}



static void Test_Ul_BFu9s_BFu7ll()
{
  {
    init_simple_test("Ul_BFu9s_BFu7ll");
    static STRUCT_IF_C Ul_BFu9s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu7ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "Ul_BFu9s_BFu7ll");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "Ul_BFu9s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu7ll, Ul_BFu9s_BFu7ll)
//============================================================================


struct  Ul_BFu9s_BFu7s  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned short v3:7;
};
//SIG(1 Ul_BFu9s_BFu7s) C1{ FL Fs:9 Fs:7}



static void Test_Ul_BFu9s_BFu7s()
{
  {
    init_simple_test("Ul_BFu9s_BFu7s");
    static STRUCT_IF_C Ul_BFu9s_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu7s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu7s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, 1, "Ul_BFu9s_BFu7s");
    set_bf_and_test(lv, v3, 9, 1, 7, hide_ull(1LL<<6), "Ul_BFu9s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu7s, Ul_BFu9s_BFu7s)
//============================================================================


struct  Ul_BFu9s_BFu8c  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned char v3:8;
};
//SIG(1 Ul_BFu9s_BFu8c) C1{ FL Fs:9 Fc:8}



static void Test_Ul_BFu9s_BFu8c()
{
  {
    init_simple_test("Ul_BFu9s_BFu8c");
    static STRUCT_IF_C Ul_BFu9s_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu8c.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu8c");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_BFu9s_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_BFu9s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu8c, Ul_BFu9s_BFu8c)
//============================================================================


struct  Ul_BFu9s_BFu8i  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned int v3:8;
};
//SIG(1 Ul_BFu9s_BFu8i) C1{ FL Fs:9 Fi:8}



static void Test_Ul_BFu9s_BFu8i()
{
  {
    init_simple_test("Ul_BFu9s_BFu8i");
    static STRUCT_IF_C Ul_BFu9s_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu8i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu8i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "Ul_BFu9s_BFu8i");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "Ul_BFu9s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu8i, Ul_BFu9s_BFu8i)
//============================================================================


struct  Ul_BFu9s_BFu8ll  {
  __tsu64 v1;
  unsigned short v2:9;
  __tsu64 v3:8;
};
//SIG(1 Ul_BFu9s_BFu8ll) C1{ FL Fs:9 FL:8}



static void Test_Ul_BFu9s_BFu8ll()
{
  {
    init_simple_test("Ul_BFu9s_BFu8ll");
    static STRUCT_IF_C Ul_BFu9s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu8ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, 1, "Ul_BFu9s_BFu8ll");
    set_bf_and_test(lv, v3, 9, 1, 8, hide_ull(1LL<<7), "Ul_BFu9s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu8ll, Ul_BFu9s_BFu8ll)
//============================================================================


struct  Ul_BFu9s_BFu8s  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned short v3:8;
};
//SIG(1 Ul_BFu9s_BFu8s) C1{ FL Fs:9 Fs:8}



static void Test_Ul_BFu9s_BFu8s()
{
  {
    init_simple_test("Ul_BFu9s_BFu8s");
    static STRUCT_IF_C Ul_BFu9s_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu8s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu8s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_BFu9s_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_BFu9s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu8s, Ul_BFu9s_BFu8s)
//============================================================================


struct  Ul_BFu9s_BFu9i  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned int v3:9;
};
//SIG(1 Ul_BFu9s_BFu9i) C1{ FL Fs:9 Fi:9}



static void Test_Ul_BFu9s_BFu9i()
{
  {
    init_simple_test("Ul_BFu9s_BFu9i");
    static STRUCT_IF_C Ul_BFu9s_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu9i.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu9i");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "Ul_BFu9s_BFu9i");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu9i, Ul_BFu9s_BFu9i)
//============================================================================


struct  Ul_BFu9s_BFu9ll  {
  __tsu64 v1;
  unsigned short v2:9;
  __tsu64 v3:9;
};
//SIG(1 Ul_BFu9s_BFu9ll) C1{ FL Fs:9 FL:9}



static void Test_Ul_BFu9s_BFu9ll()
{
  {
    init_simple_test("Ul_BFu9s_BFu9ll");
    static STRUCT_IF_C Ul_BFu9s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu9ll");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, 1, "Ul_BFu9s_BFu9ll");
    set_bf_and_test(lv, v3, 9, 1, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu9ll, Ul_BFu9s_BFu9ll)
//============================================================================


struct  Ul_BFu9s_BFu9s  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned short v3:9;
};
//SIG(1 Ul_BFu9s_BFu9s) C1{ FL Fs:9 Fs:9}



static void Test_Ul_BFu9s_BFu9s()
{
  {
    init_simple_test("Ul_BFu9s_BFu9s");
    static STRUCT_IF_C Ul_BFu9s_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_BFu9s.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_BFu9s");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_BFu9s_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_BFu9s, Ul_BFu9s_BFu9s)
//============================================================================


struct  Ul_BFu9s_C  {
  __tsu64 v1;
  unsigned short v2:9;
  char v3;
};
//SIG(1 Ul_BFu9s_C) C1{ FL Fs:9 Fc}



static void Test_Ul_BFu9s_C()
{
  {
    init_simple_test("Ul_BFu9s_C");
    static STRUCT_IF_C Ul_BFu9s_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_C)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_C.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_C");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_C");
    check_field_offset(lv, v3, 10, "Ul_BFu9s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_C, Ul_BFu9s_C)
//============================================================================


struct  Ul_BFu9s_D  {
  __tsu64 v1;
  unsigned short v2:9;
  double v3;
};
//SIG(1 Ul_BFu9s_D) C1{ FL Fs:9 FL}



static void Test_Ul_BFu9s_D()
{
  {
    init_simple_test("Ul_BFu9s_D");
    static STRUCT_IF_C Ul_BFu9s_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_BFu9s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_D)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_D.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_D");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_D");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu9s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_D, Ul_BFu9s_D)
//============================================================================


struct  Ul_BFu9s_F  {
  __tsu64 v1;
  unsigned short v2:9;
  float v3;
};
//SIG(1 Ul_BFu9s_F) C1{ FL Fs:9 Fi}



static void Test_Ul_BFu9s_F()
{
  {
    init_simple_test("Ul_BFu9s_F");
    static STRUCT_IF_C Ul_BFu9s_F lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9s_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_F)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_F.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_F");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_F");
    check_field_offset(lv, v3, 12, "Ul_BFu9s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_F, Ul_BFu9s_F)
//============================================================================


struct  Ul_BFu9s_I  {
  __tsu64 v1;
  unsigned short v2:9;
  int v3;
};
//SIG(1 Ul_BFu9s_I) C1{ FL Fs:9 Fi}



static void Test_Ul_BFu9s_I()
{
  {
    init_simple_test("Ul_BFu9s_I");
    static STRUCT_IF_C Ul_BFu9s_I lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9s_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_I)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_I.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_I");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_I");
    check_field_offset(lv, v3, 12, "Ul_BFu9s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_I, Ul_BFu9s_I)
//============================================================================


struct  Ul_BFu9s_Ip  {
  __tsu64 v1;
  unsigned short v2:9;
  int *v3;
};
//SIG(1 Ul_BFu9s_Ip) C1{ FL Fs:9 Fp}



static void Test_Ul_BFu9s_Ip()
{
  {
    init_simple_test("Ul_BFu9s_Ip");
    static STRUCT_IF_C Ul_BFu9s_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_BFu9s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_Ip)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_Ip.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_Ip");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_Ip");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu9s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_Ip, Ul_BFu9s_Ip)
//============================================================================


struct  Ul_BFu9s_L  {
  __tsu64 v1;
  unsigned short v2:9;
  __tsi64 v3;
};
//SIG(1 Ul_BFu9s_L) C1{ FL Fs:9 FL}



static void Test_Ul_BFu9s_L()
{
  {
    init_simple_test("Ul_BFu9s_L");
    static STRUCT_IF_C Ul_BFu9s_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_BFu9s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_L)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_L.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_L");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_L");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu9s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_L, Ul_BFu9s_L)
//============================================================================


struct  Ul_BFu9s_S  {
  __tsu64 v1;
  unsigned short v2:9;
  short v3;
};
//SIG(1 Ul_BFu9s_S) C1{ FL Fs:9 Fs}



static void Test_Ul_BFu9s_S()
{
  {
    init_simple_test("Ul_BFu9s_S");
    static STRUCT_IF_C Ul_BFu9s_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_S)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_S.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_S");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_S");
    check_field_offset(lv, v3, 10, "Ul_BFu9s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_S, Ul_BFu9s_S)
//============================================================================


struct  Ul_BFu9s_Uc  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned char v3;
};
//SIG(1 Ul_BFu9s_Uc) C1{ FL Fs:9 Fc}



static void Test_Ul_BFu9s_Uc()
{
  {
    init_simple_test("Ul_BFu9s_Uc");
    static STRUCT_IF_C Ul_BFu9s_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_Uc)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_Uc.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_Uc");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_Uc");
    check_field_offset(lv, v3, 10, "Ul_BFu9s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_Uc, Ul_BFu9s_Uc)
//============================================================================


struct  Ul_BFu9s_Ui  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned int v3;
};
//SIG(1 Ul_BFu9s_Ui) C1{ FL Fs:9 Fi}



static void Test_Ul_BFu9s_Ui()
{
  {
    init_simple_test("Ul_BFu9s_Ui");
    static STRUCT_IF_C Ul_BFu9s_Ui lv;
    check2(sizeof(lv), 16, "sizeof(Ul_BFu9s_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_Ui)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_Ui.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_Ui");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_Ui");
    check_field_offset(lv, v3, 12, "Ul_BFu9s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_Ui, Ul_BFu9s_Ui)
//============================================================================


struct  Ul_BFu9s_Ul  {
  __tsu64 v1;
  unsigned short v2:9;
  __tsu64 v3;
};
//SIG(1 Ul_BFu9s_Ul) C1{ FL Fs:9 FL}



static void Test_Ul_BFu9s_Ul()
{
  {
    init_simple_test("Ul_BFu9s_Ul");
    static STRUCT_IF_C Ul_BFu9s_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_BFu9s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_Ul)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_Ul.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_Ul");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_Ul");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu9s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_Ul, Ul_BFu9s_Ul)
//============================================================================


struct  Ul_BFu9s_Us  {
  __tsu64 v1;
  unsigned short v2:9;
  unsigned short v3;
};
//SIG(1 Ul_BFu9s_Us) C1{ FL Fs:9 Fs}



static void Test_Ul_BFu9s_Us()
{
  {
    init_simple_test("Ul_BFu9s_Us");
    static STRUCT_IF_C Ul_BFu9s_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_BFu9s_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_Us)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_Us.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_Us");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_Us");
    check_field_offset(lv, v3, 10, "Ul_BFu9s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_Us, Ul_BFu9s_Us)
//============================================================================


struct  Ul_BFu9s_Vp  {
  __tsu64 v1;
  unsigned short v2:9;
  void *v3;
};
//SIG(1 Ul_BFu9s_Vp) C1{ FL Fs:9 Fp}



static void Test_Ul_BFu9s_Vp()
{
  {
    init_simple_test("Ul_BFu9s_Vp");
    static STRUCT_IF_C Ul_BFu9s_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_BFu9s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_BFu9s_Vp)");
    check_field_offset(lv, v1, 0, "Ul_BFu9s_Vp.v1");
    set_bf_and_test(lv, v2, 8, 0, 9, 1, "Ul_BFu9s_Vp");
    set_bf_and_test(lv, v2, 8, 0, 9, hide_ull(1LL<<8), "Ul_BFu9s_Vp");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_BFu9s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_BFu9s_Vp, Ul_BFu9s_Vp)
//============================================================================


struct  Ul_C  {
  __tsu64 v1;
  char v2;
};
//SIG(1 Ul_C) C1{ FL Fc}



static void Test_Ul_C()
{
  {
    init_simple_test("Ul_C");
    STRUCT_IF_C Ul_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C)");
    check_field_offset(lv, v1, 0, "Ul_C.v1");
    check_field_offset(lv, v2, 8, "Ul_C.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C, Ul_C)
//============================================================================


struct  Ul_C_BFu15i  {
  __tsu64 v1;
  char v2;
  unsigned int v3:15;
};
//SIG(1 Ul_C_BFu15i) C1{ FL Fc Fi:15}



static void Test_Ul_C_BFu15i()
{
  {
    init_simple_test("Ul_C_BFu15i");
    static STRUCT_IF_C Ul_C_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu15i.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_C_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_C_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu15i, Ul_C_BFu15i)
//============================================================================


struct  Ul_C_BFu15ll  {
  __tsu64 v1;
  char v2;
  __tsu64 v3:15;
};
//SIG(1 Ul_C_BFu15ll) C1{ FL Fc FL:15}



static void Test_Ul_C_BFu15ll()
{
  {
    init_simple_test("Ul_C_BFu15ll");
    static STRUCT_IF_C Ul_C_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_C_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_C_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu15ll, Ul_C_BFu15ll)
//============================================================================


struct  Ul_C_BFu15s  {
  __tsu64 v1;
  char v2;
  unsigned short v3:15;
};
//SIG(1 Ul_C_BFu15s) C1{ FL Fc Fs:15}



static void Test_Ul_C_BFu15s()
{
  {
    init_simple_test("Ul_C_BFu15s");
    static STRUCT_IF_C Ul_C_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu15s.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_C_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_C_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu15s, Ul_C_BFu15s)
//============================================================================


struct  Ul_C_BFu16i  {
  __tsu64 v1;
  char v2;
  unsigned int v3:16;
};
//SIG(1 Ul_C_BFu16i) C1{ FL Fc Fi:16}



static void Test_Ul_C_BFu16i()
{
  {
    init_simple_test("Ul_C_BFu16i");
    static STRUCT_IF_C Ul_C_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu16i.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_C_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_C_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu16i, Ul_C_BFu16i)
//============================================================================


struct  Ul_C_BFu16ll  {
  __tsu64 v1;
  char v2;
  __tsu64 v3:16;
};
//SIG(1 Ul_C_BFu16ll) C1{ FL Fc FL:16}



static void Test_Ul_C_BFu16ll()
{
  {
    init_simple_test("Ul_C_BFu16ll");
    static STRUCT_IF_C Ul_C_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_C_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_C_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu16ll, Ul_C_BFu16ll)
//============================================================================


struct  Ul_C_BFu16s  {
  __tsu64 v1;
  char v2;
  unsigned short v3:16;
};
//SIG(1 Ul_C_BFu16s) C1{ FL Fc Fs:16}



static void Test_Ul_C_BFu16s()
{
  {
    init_simple_test("Ul_C_BFu16s");
    static STRUCT_IF_C Ul_C_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu16s.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_C_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_C_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu16s, Ul_C_BFu16s)
//============================================================================


struct  Ul_C_BFu17i  {
  __tsu64 v1;
  char v2;
  unsigned int v3:17;
};
//SIG(1 Ul_C_BFu17i) C1{ FL Fc Fi:17}



static void Test_Ul_C_BFu17i()
{
  {
    init_simple_test("Ul_C_BFu17i");
    static STRUCT_IF_C Ul_C_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu17i.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Ul_C_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Ul_C_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu17i, Ul_C_BFu17i)
//============================================================================


struct  Ul_C_BFu17ll  {
  __tsu64 v1;
  char v2;
  __tsu64 v3:17;
};
//SIG(1 Ul_C_BFu17ll) C1{ FL Fc FL:17}



static void Test_Ul_C_BFu17ll()
{
  {
    init_simple_test("Ul_C_BFu17ll");
    static STRUCT_IF_C Ul_C_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Ul_C_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Ul_C_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu17ll, Ul_C_BFu17ll)
//============================================================================


struct  Ul_C_BFu1c  {
  __tsu64 v1;
  char v2;
  unsigned char v3:1;
};
//SIG(1 Ul_C_BFu1c) C1{ FL Fc Fc:1}



static void Test_Ul_C_BFu1c()
{
  {
    init_simple_test("Ul_C_BFu1c");
    static STRUCT_IF_C Ul_C_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu1c.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_C_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu1c, Ul_C_BFu1c)
//============================================================================


struct  Ul_C_BFu1i  {
  __tsu64 v1;
  char v2;
  unsigned int v3:1;
};
//SIG(1 Ul_C_BFu1i) C1{ FL Fc Fi:1}



static void Test_Ul_C_BFu1i()
{
  {
    init_simple_test("Ul_C_BFu1i");
    static STRUCT_IF_C Ul_C_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu1i.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_C_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu1i, Ul_C_BFu1i)
//============================================================================


struct  Ul_C_BFu1ll  {
  __tsu64 v1;
  char v2;
  __tsu64 v3:1;
};
//SIG(1 Ul_C_BFu1ll) C1{ FL Fc FL:1}



static void Test_Ul_C_BFu1ll()
{
  {
    init_simple_test("Ul_C_BFu1ll");
    static STRUCT_IF_C Ul_C_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_C_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu1ll, Ul_C_BFu1ll)
//============================================================================


struct  Ul_C_BFu1s  {
  __tsu64 v1;
  char v2;
  unsigned short v3:1;
};
//SIG(1 Ul_C_BFu1s) C1{ FL Fc Fs:1}



static void Test_Ul_C_BFu1s()
{
  {
    init_simple_test("Ul_C_BFu1s");
    static STRUCT_IF_C Ul_C_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu1s.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_C_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu1s, Ul_C_BFu1s)
//============================================================================


struct  Ul_C_BFu31i  {
  __tsu64 v1;
  char v2;
  unsigned int v3:31;
};
//SIG(1 Ul_C_BFu31i) C1{ FL Fc Fi:31}



static void Test_Ul_C_BFu31i()
{
  {
    init_simple_test("Ul_C_BFu31i");
    static STRUCT_IF_C Ul_C_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_C_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu31i.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "Ul_C_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "Ul_C_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu31i, Ul_C_BFu31i)
//============================================================================


struct  Ul_C_BFu31ll  {
  __tsu64 v1;
  char v2;
  __tsu64 v3:31;
};
//SIG(1 Ul_C_BFu31ll) C1{ FL Fc FL:31}



static void Test_Ul_C_BFu31ll()
{
  {
    init_simple_test("Ul_C_BFu31ll");
    static STRUCT_IF_C Ul_C_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_C_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "Ul_C_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "Ul_C_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu31ll, Ul_C_BFu31ll)
//============================================================================


struct  Ul_C_BFu32i  {
  __tsu64 v1;
  char v2;
  unsigned int v3:32;
};
//SIG(1 Ul_C_BFu32i) C1{ FL Fc Fi:32}



static void Test_Ul_C_BFu32i()
{
  {
    init_simple_test("Ul_C_BFu32i");
    static STRUCT_IF_C Ul_C_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_C_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu32i.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_C_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_C_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu32i, Ul_C_BFu32i)
//============================================================================


struct  Ul_C_BFu32ll  {
  __tsu64 v1;
  char v2;
  __tsu64 v3:32;
};
//SIG(1 Ul_C_BFu32ll) C1{ FL Fc FL:32}



static void Test_Ul_C_BFu32ll()
{
  {
    init_simple_test("Ul_C_BFu32ll");
    static STRUCT_IF_C Ul_C_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_C_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "Ul_C_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "Ul_C_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu32ll, Ul_C_BFu32ll)
//============================================================================


struct  Ul_C_BFu33  {
  __tsu64 v1;
  char v2;
  __tsu64 v3:33;
};
//SIG(1 Ul_C_BFu33) C1{ FL Fc FL:33}



static void Test_Ul_C_BFu33()
{
  {
    init_simple_test("Ul_C_BFu33");
    static STRUCT_IF_C Ul_C_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Ul_C_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu33.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "Ul_C_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "Ul_C_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu33, Ul_C_BFu33)
//============================================================================


struct  Ul_C_BFu7c  {
  __tsu64 v1;
  char v2;
  unsigned char v3:7;
};
//SIG(1 Ul_C_BFu7c) C1{ FL Fc Fc:7}



static void Test_Ul_C_BFu7c()
{
  {
    init_simple_test("Ul_C_BFu7c");
    static STRUCT_IF_C Ul_C_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu7c.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_C_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_C_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu7c, Ul_C_BFu7c)
//============================================================================


struct  Ul_C_BFu7i  {
  __tsu64 v1;
  char v2;
  unsigned int v3:7;
};
//SIG(1 Ul_C_BFu7i) C1{ FL Fc Fi:7}



static void Test_Ul_C_BFu7i()
{
  {
    init_simple_test("Ul_C_BFu7i");
    static STRUCT_IF_C Ul_C_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu7i.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_C_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_C_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu7i, Ul_C_BFu7i)
//============================================================================


struct  Ul_C_BFu7ll  {
  __tsu64 v1;
  char v2;
  __tsu64 v3:7;
};
//SIG(1 Ul_C_BFu7ll) C1{ FL Fc FL:7}



static void Test_Ul_C_BFu7ll()
{
  {
    init_simple_test("Ul_C_BFu7ll");
    static STRUCT_IF_C Ul_C_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_C_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_C_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu7ll, Ul_C_BFu7ll)
//============================================================================


struct  Ul_C_BFu7s  {
  __tsu64 v1;
  char v2;
  unsigned short v3:7;
};
//SIG(1 Ul_C_BFu7s) C1{ FL Fc Fs:7}



static void Test_Ul_C_BFu7s()
{
  {
    init_simple_test("Ul_C_BFu7s");
    static STRUCT_IF_C Ul_C_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu7s.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_C_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_C_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu7s, Ul_C_BFu7s)
//============================================================================


struct  Ul_C_BFu8c  {
  __tsu64 v1;
  char v2;
  unsigned char v3:8;
};
//SIG(1 Ul_C_BFu8c) C1{ FL Fc Fc:8}



static void Test_Ul_C_BFu8c()
{
  {
    init_simple_test("Ul_C_BFu8c");
    static STRUCT_IF_C Ul_C_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu8c.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_C_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_C_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu8c, Ul_C_BFu8c)
//============================================================================


struct  Ul_C_BFu8i  {
  __tsu64 v1;
  char v2;
  unsigned int v3:8;
};
//SIG(1 Ul_C_BFu8i) C1{ FL Fc Fi:8}



static void Test_Ul_C_BFu8i()
{
  {
    init_simple_test("Ul_C_BFu8i");
    static STRUCT_IF_C Ul_C_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu8i.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_C_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_C_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu8i, Ul_C_BFu8i)
//============================================================================


struct  Ul_C_BFu8ll  {
  __tsu64 v1;
  char v2;
  __tsu64 v3:8;
};
//SIG(1 Ul_C_BFu8ll) C1{ FL Fc FL:8}



static void Test_Ul_C_BFu8ll()
{
  {
    init_simple_test("Ul_C_BFu8ll");
    static STRUCT_IF_C Ul_C_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_C_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_C_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu8ll, Ul_C_BFu8ll)
//============================================================================


struct  Ul_C_BFu8s  {
  __tsu64 v1;
  char v2;
  unsigned short v3:8;
};
//SIG(1 Ul_C_BFu8s) C1{ FL Fc Fs:8}



static void Test_Ul_C_BFu8s()
{
  {
    init_simple_test("Ul_C_BFu8s");
    static STRUCT_IF_C Ul_C_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu8s.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_C_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_C_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu8s, Ul_C_BFu8s)
//============================================================================


struct  Ul_C_BFu9i  {
  __tsu64 v1;
  char v2;
  unsigned int v3:9;
};
//SIG(1 Ul_C_BFu9i) C1{ FL Fc Fi:9}



static void Test_Ul_C_BFu9i()
{
  {
    init_simple_test("Ul_C_BFu9i");
    static STRUCT_IF_C Ul_C_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu9i.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_C_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_C_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu9i, Ul_C_BFu9i)
//============================================================================


struct  Ul_C_BFu9ll  {
  __tsu64 v1;
  char v2;
  __tsu64 v3:9;
};
//SIG(1 Ul_C_BFu9ll) C1{ FL Fc FL:9}



static void Test_Ul_C_BFu9ll()
{
  {
    init_simple_test("Ul_C_BFu9ll");
    static STRUCT_IF_C Ul_C_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_C_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_C_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu9ll, Ul_C_BFu9ll)
//============================================================================


struct  Ul_C_BFu9s  {
  __tsu64 v1;
  char v2;
  unsigned short v3:9;
};
//SIG(1 Ul_C_BFu9s) C1{ FL Fc Fs:9}



static void Test_Ul_C_BFu9s()
{
  {
    init_simple_test("Ul_C_BFu9s");
    static STRUCT_IF_C Ul_C_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_C_BFu9s.v1");
    check_field_offset(lv, v2, 8, "Ul_C_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_C_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_C_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_BFu9s, Ul_C_BFu9s)
//============================================================================


struct  Ul_C_C  {
  __tsu64 v1;
  char v2;
  char v3;
};
//SIG(1 Ul_C_C) C1{ FL Fc[2]}



static void Test_Ul_C_C()
{
  {
    init_simple_test("Ul_C_C");
    STRUCT_IF_C Ul_C_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_C)");
    check_field_offset(lv, v1, 0, "Ul_C_C.v1");
    check_field_offset(lv, v2, 8, "Ul_C_C.v2");
    check_field_offset(lv, v3, 9, "Ul_C_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_C, Ul_C_C)
//============================================================================


struct  Ul_C_D  {
  __tsu64 v1;
  char v2;
  double v3;
};
//SIG(1 Ul_C_D) C1{ FL Fc FL}



static void Test_Ul_C_D()
{
  {
    init_simple_test("Ul_C_D");
    STRUCT_IF_C Ul_C_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_C_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_D)");
    check_field_offset(lv, v1, 0, "Ul_C_D.v1");
    check_field_offset(lv, v2, 8, "Ul_C_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_C_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_D, Ul_C_D)
//============================================================================


struct  Ul_C_F  {
  __tsu64 v1;
  char v2;
  float v3;
};
//SIG(1 Ul_C_F) C1{ FL Fc Fi}



static void Test_Ul_C_F()
{
  {
    init_simple_test("Ul_C_F");
    STRUCT_IF_C Ul_C_F lv;
    check2(sizeof(lv), 16, "sizeof(Ul_C_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_F)");
    check_field_offset(lv, v1, 0, "Ul_C_F.v1");
    check_field_offset(lv, v2, 8, "Ul_C_F.v2");
    check_field_offset(lv, v3, 12, "Ul_C_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_F, Ul_C_F)
//============================================================================


struct  Ul_C_I  {
  __tsu64 v1;
  char v2;
  int v3;
};
//SIG(1 Ul_C_I) C1{ FL Fc Fi}



static void Test_Ul_C_I()
{
  {
    init_simple_test("Ul_C_I");
    STRUCT_IF_C Ul_C_I lv;
    check2(sizeof(lv), 16, "sizeof(Ul_C_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_I)");
    check_field_offset(lv, v1, 0, "Ul_C_I.v1");
    check_field_offset(lv, v2, 8, "Ul_C_I.v2");
    check_field_offset(lv, v3, 12, "Ul_C_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_I, Ul_C_I)
//============================================================================


struct  Ul_C_Ip  {
  __tsu64 v1;
  char v2;
  int *v3;
};
//SIG(1 Ul_C_Ip) C1{ FL Fc Fp}



static void Test_Ul_C_Ip()
{
  {
    init_simple_test("Ul_C_Ip");
    STRUCT_IF_C Ul_C_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_C_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_Ip)");
    check_field_offset(lv, v1, 0, "Ul_C_Ip.v1");
    check_field_offset(lv, v2, 8, "Ul_C_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_C_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_Ip, Ul_C_Ip)
//============================================================================


struct  Ul_C_L  {
  __tsu64 v1;
  char v2;
  __tsi64 v3;
};
//SIG(1 Ul_C_L) C1{ FL Fc FL}



static void Test_Ul_C_L()
{
  {
    init_simple_test("Ul_C_L");
    STRUCT_IF_C Ul_C_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_C_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_L)");
    check_field_offset(lv, v1, 0, "Ul_C_L.v1");
    check_field_offset(lv, v2, 8, "Ul_C_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_C_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_L, Ul_C_L)
//============================================================================


struct  Ul_C_S  {
  __tsu64 v1;
  char v2;
  short v3;
};
//SIG(1 Ul_C_S) C1{ FL Fc Fs}



static void Test_Ul_C_S()
{
  {
    init_simple_test("Ul_C_S");
    STRUCT_IF_C Ul_C_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_S)");
    check_field_offset(lv, v1, 0, "Ul_C_S.v1");
    check_field_offset(lv, v2, 8, "Ul_C_S.v2");
    check_field_offset(lv, v3, 10, "Ul_C_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_S, Ul_C_S)
//============================================================================


struct  Ul_C_Uc  {
  __tsu64 v1;
  char v2;
  unsigned char v3;
};
//SIG(1 Ul_C_Uc) C1{ FL Fc[2]}



static void Test_Ul_C_Uc()
{
  {
    init_simple_test("Ul_C_Uc");
    STRUCT_IF_C Ul_C_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_Uc)");
    check_field_offset(lv, v1, 0, "Ul_C_Uc.v1");
    check_field_offset(lv, v2, 8, "Ul_C_Uc.v2");
    check_field_offset(lv, v3, 9, "Ul_C_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_Uc, Ul_C_Uc)
//============================================================================


struct  Ul_C_Ui  {
  __tsu64 v1;
  char v2;
  unsigned int v3;
};
//SIG(1 Ul_C_Ui) C1{ FL Fc Fi}



static void Test_Ul_C_Ui()
{
  {
    init_simple_test("Ul_C_Ui");
    STRUCT_IF_C Ul_C_Ui lv;
    check2(sizeof(lv), 16, "sizeof(Ul_C_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_Ui)");
    check_field_offset(lv, v1, 0, "Ul_C_Ui.v1");
    check_field_offset(lv, v2, 8, "Ul_C_Ui.v2");
    check_field_offset(lv, v3, 12, "Ul_C_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_Ui, Ul_C_Ui)
//============================================================================


struct  Ul_C_Ul  {
  __tsu64 v1;
  char v2;
  __tsu64 v3;
};
//SIG(1 Ul_C_Ul) C1{ FL Fc FL}



static void Test_Ul_C_Ul()
{
  {
    init_simple_test("Ul_C_Ul");
    STRUCT_IF_C Ul_C_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_C_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_Ul)");
    check_field_offset(lv, v1, 0, "Ul_C_Ul.v1");
    check_field_offset(lv, v2, 8, "Ul_C_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_C_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_Ul, Ul_C_Ul)
//============================================================================


struct  Ul_C_Us  {
  __tsu64 v1;
  char v2;
  unsigned short v3;
};
//SIG(1 Ul_C_Us) C1{ FL Fc Fs}



static void Test_Ul_C_Us()
{
  {
    init_simple_test("Ul_C_Us");
    STRUCT_IF_C Ul_C_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_C_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_Us)");
    check_field_offset(lv, v1, 0, "Ul_C_Us.v1");
    check_field_offset(lv, v2, 8, "Ul_C_Us.v2");
    check_field_offset(lv, v3, 10, "Ul_C_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_Us, Ul_C_Us)
//============================================================================


struct  Ul_C_Vp  {
  __tsu64 v1;
  char v2;
  void *v3;
};
//SIG(1 Ul_C_Vp) C1{ FL Fc Fp}



static void Test_Ul_C_Vp()
{
  {
    init_simple_test("Ul_C_Vp");
    STRUCT_IF_C Ul_C_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_C_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_C_Vp)");
    check_field_offset(lv, v1, 0, "Ul_C_Vp.v1");
    check_field_offset(lv, v2, 8, "Ul_C_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_C_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_C_Vp, Ul_C_Vp)
//============================================================================


struct  Ul_D  {
  __tsu64 v1;
  double v2;
};
//SIG(1 Ul_D) C1{ FL[2]}



static void Test_Ul_D()
{
  {
    init_simple_test("Ul_D");
    STRUCT_IF_C Ul_D lv;
    check2(sizeof(lv), 16, "sizeof(Ul_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D)");
    check_field_offset(lv, v1, 0, "Ul_D.v1");
    check_field_offset(lv, v2, 8, "Ul_D.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D, Ul_D)
//============================================================================


struct  Ul_D_BFu15i  {
  __tsu64 v1;
  double v2;
  unsigned int v3:15;
};
//SIG(1 Ul_D_BFu15i) C1{ FL[2] Fi:15}



static void Test_Ul_D_BFu15i()
{
  {
    init_simple_test("Ul_D_BFu15i");
    static STRUCT_IF_C Ul_D_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu15i.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu15i.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "Ul_D_BFu15i");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "Ul_D_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu15i, Ul_D_BFu15i)
//============================================================================


struct  Ul_D_BFu15ll  {
  __tsu64 v1;
  double v2;
  __tsu64 v3:15;
};
//SIG(1 Ul_D_BFu15ll) C1{ FL[2] FL:15}



static void Test_Ul_D_BFu15ll()
{
  {
    init_simple_test("Ul_D_BFu15ll");
    static STRUCT_IF_C Ul_D_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu15ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "Ul_D_BFu15ll");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "Ul_D_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu15ll, Ul_D_BFu15ll)
//============================================================================


struct  Ul_D_BFu15s  {
  __tsu64 v1;
  double v2;
  unsigned short v3:15;
};
//SIG(1 Ul_D_BFu15s) C1{ FL[2] Fs:15}



static void Test_Ul_D_BFu15s()
{
  {
    init_simple_test("Ul_D_BFu15s");
    static STRUCT_IF_C Ul_D_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu15s.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu15s.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "Ul_D_BFu15s");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "Ul_D_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu15s, Ul_D_BFu15s)
//============================================================================


struct  Ul_D_BFu16i  {
  __tsu64 v1;
  double v2;
  unsigned int v3:16;
};
//SIG(1 Ul_D_BFu16i) C1{ FL[2] Fi:16}



static void Test_Ul_D_BFu16i()
{
  {
    init_simple_test("Ul_D_BFu16i");
    static STRUCT_IF_C Ul_D_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu16i.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu16i.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "Ul_D_BFu16i");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "Ul_D_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu16i, Ul_D_BFu16i)
//============================================================================


struct  Ul_D_BFu16ll  {
  __tsu64 v1;
  double v2;
  __tsu64 v3:16;
};
//SIG(1 Ul_D_BFu16ll) C1{ FL[2] FL:16}



static void Test_Ul_D_BFu16ll()
{
  {
    init_simple_test("Ul_D_BFu16ll");
    static STRUCT_IF_C Ul_D_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu16ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "Ul_D_BFu16ll");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "Ul_D_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu16ll, Ul_D_BFu16ll)
//============================================================================


struct  Ul_D_BFu16s  {
  __tsu64 v1;
  double v2;
  unsigned short v3:16;
};
//SIG(1 Ul_D_BFu16s) C1{ FL[2] Fs:16}



static void Test_Ul_D_BFu16s()
{
  {
    init_simple_test("Ul_D_BFu16s");
    static STRUCT_IF_C Ul_D_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu16s.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu16s.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "Ul_D_BFu16s");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "Ul_D_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu16s, Ul_D_BFu16s)
//============================================================================


struct  Ul_D_BFu17i  {
  __tsu64 v1;
  double v2;
  unsigned int v3:17;
};
//SIG(1 Ul_D_BFu17i) C1{ FL[2] Fi:17}



static void Test_Ul_D_BFu17i()
{
  {
    init_simple_test("Ul_D_BFu17i");
    static STRUCT_IF_C Ul_D_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu17i.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu17i.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "Ul_D_BFu17i");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "Ul_D_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu17i, Ul_D_BFu17i)
//============================================================================


struct  Ul_D_BFu17ll  {
  __tsu64 v1;
  double v2;
  __tsu64 v3:17;
};
//SIG(1 Ul_D_BFu17ll) C1{ FL[2] FL:17}



static void Test_Ul_D_BFu17ll()
{
  {
    init_simple_test("Ul_D_BFu17ll");
    static STRUCT_IF_C Ul_D_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu17ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "Ul_D_BFu17ll");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "Ul_D_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu17ll, Ul_D_BFu17ll)
//============================================================================


struct  Ul_D_BFu1c  {
  __tsu64 v1;
  double v2;
  unsigned char v3:1;
};
//SIG(1 Ul_D_BFu1c) C1{ FL[2] Fc:1}



static void Test_Ul_D_BFu1c()
{
  {
    init_simple_test("Ul_D_BFu1c");
    static STRUCT_IF_C Ul_D_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu1c.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu1c.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "Ul_D_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu1c, Ul_D_BFu1c)
//============================================================================


struct  Ul_D_BFu1i  {
  __tsu64 v1;
  double v2;
  unsigned int v3:1;
};
//SIG(1 Ul_D_BFu1i) C1{ FL[2] Fi:1}



static void Test_Ul_D_BFu1i()
{
  {
    init_simple_test("Ul_D_BFu1i");
    static STRUCT_IF_C Ul_D_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu1i.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu1i.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "Ul_D_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu1i, Ul_D_BFu1i)
//============================================================================


struct  Ul_D_BFu1ll  {
  __tsu64 v1;
  double v2;
  __tsu64 v3:1;
};
//SIG(1 Ul_D_BFu1ll) C1{ FL[2] FL:1}



static void Test_Ul_D_BFu1ll()
{
  {
    init_simple_test("Ul_D_BFu1ll");
    static STRUCT_IF_C Ul_D_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu1ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "Ul_D_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu1ll, Ul_D_BFu1ll)
//============================================================================


struct  Ul_D_BFu1s  {
  __tsu64 v1;
  double v2;
  unsigned short v3:1;
};
//SIG(1 Ul_D_BFu1s) C1{ FL[2] Fs:1}



static void Test_Ul_D_BFu1s()
{
  {
    init_simple_test("Ul_D_BFu1s");
    static STRUCT_IF_C Ul_D_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu1s.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu1s.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "Ul_D_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu1s, Ul_D_BFu1s)
//============================================================================


struct  Ul_D_BFu31i  {
  __tsu64 v1;
  double v2;
  unsigned int v3:31;
};
//SIG(1 Ul_D_BFu31i) C1{ FL[2] Fi:31}



static void Test_Ul_D_BFu31i()
{
  {
    init_simple_test("Ul_D_BFu31i");
    static STRUCT_IF_C Ul_D_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu31i.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu31i.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "Ul_D_BFu31i");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "Ul_D_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu31i, Ul_D_BFu31i)
//============================================================================


struct  Ul_D_BFu31ll  {
  __tsu64 v1;
  double v2;
  __tsu64 v3:31;
};
//SIG(1 Ul_D_BFu31ll) C1{ FL[2] FL:31}



static void Test_Ul_D_BFu31ll()
{
  {
    init_simple_test("Ul_D_BFu31ll");
    static STRUCT_IF_C Ul_D_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu31ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "Ul_D_BFu31ll");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "Ul_D_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu31ll, Ul_D_BFu31ll)
//============================================================================


struct  Ul_D_BFu32i  {
  __tsu64 v1;
  double v2;
  unsigned int v3:32;
};
//SIG(1 Ul_D_BFu32i) C1{ FL[2] Fi:32}



static void Test_Ul_D_BFu32i()
{
  {
    init_simple_test("Ul_D_BFu32i");
    static STRUCT_IF_C Ul_D_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu32i.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu32i.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "Ul_D_BFu32i");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "Ul_D_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu32i, Ul_D_BFu32i)
//============================================================================


struct  Ul_D_BFu32ll  {
  __tsu64 v1;
  double v2;
  __tsu64 v3:32;
};
//SIG(1 Ul_D_BFu32ll) C1{ FL[2] FL:32}



static void Test_Ul_D_BFu32ll()
{
  {
    init_simple_test("Ul_D_BFu32ll");
    static STRUCT_IF_C Ul_D_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu32ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "Ul_D_BFu32ll");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "Ul_D_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu32ll, Ul_D_BFu32ll)
//============================================================================


struct  Ul_D_BFu33  {
  __tsu64 v1;
  double v2;
  __tsu64 v3:33;
};
//SIG(1 Ul_D_BFu33) C1{ FL[2] FL:33}



static void Test_Ul_D_BFu33()
{
  {
    init_simple_test("Ul_D_BFu33");
    static STRUCT_IF_C Ul_D_BFu33 lv;
    check2(sizeof(lv), 24, "sizeof(Ul_D_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu33.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu33.v2");
    set_bf_and_test(lv, v3, 16, 0, 33, 1, "Ul_D_BFu33");
    set_bf_and_test(lv, v3, 16, 0, 33, hide_ull(1LL<<32), "Ul_D_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu33, Ul_D_BFu33)
//============================================================================


struct  Ul_D_BFu7c  {
  __tsu64 v1;
  double v2;
  unsigned char v3:7;
};
//SIG(1 Ul_D_BFu7c) C1{ FL[2] Fc:7}



static void Test_Ul_D_BFu7c()
{
  {
    init_simple_test("Ul_D_BFu7c");
    static STRUCT_IF_C Ul_D_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu7c.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu7c.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "Ul_D_BFu7c");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "Ul_D_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu7c, Ul_D_BFu7c)
//============================================================================


struct  Ul_D_BFu7i  {
  __tsu64 v1;
  double v2;
  unsigned int v3:7;
};
//SIG(1 Ul_D_BFu7i) C1{ FL[2] Fi:7}



static void Test_Ul_D_BFu7i()
{
  {
    init_simple_test("Ul_D_BFu7i");
    static STRUCT_IF_C Ul_D_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu7i.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu7i.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "Ul_D_BFu7i");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "Ul_D_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu7i, Ul_D_BFu7i)
//============================================================================


struct  Ul_D_BFu7ll  {
  __tsu64 v1;
  double v2;
  __tsu64 v3:7;
};
//SIG(1 Ul_D_BFu7ll) C1{ FL[2] FL:7}



static void Test_Ul_D_BFu7ll()
{
  {
    init_simple_test("Ul_D_BFu7ll");
    static STRUCT_IF_C Ul_D_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu7ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "Ul_D_BFu7ll");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "Ul_D_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu7ll, Ul_D_BFu7ll)
//============================================================================


struct  Ul_D_BFu7s  {
  __tsu64 v1;
  double v2;
  unsigned short v3:7;
};
//SIG(1 Ul_D_BFu7s) C1{ FL[2] Fs:7}



static void Test_Ul_D_BFu7s()
{
  {
    init_simple_test("Ul_D_BFu7s");
    static STRUCT_IF_C Ul_D_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu7s.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu7s.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "Ul_D_BFu7s");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "Ul_D_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu7s, Ul_D_BFu7s)
//============================================================================


struct  Ul_D_BFu8c  {
  __tsu64 v1;
  double v2;
  unsigned char v3:8;
};
//SIG(1 Ul_D_BFu8c) C1{ FL[2] Fc:8}



static void Test_Ul_D_BFu8c()
{
  {
    init_simple_test("Ul_D_BFu8c");
    static STRUCT_IF_C Ul_D_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu8c.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu8c.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "Ul_D_BFu8c");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "Ul_D_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu8c, Ul_D_BFu8c)
//============================================================================


struct  Ul_D_BFu8i  {
  __tsu64 v1;
  double v2;
  unsigned int v3:8;
};
//SIG(1 Ul_D_BFu8i) C1{ FL[2] Fi:8}



static void Test_Ul_D_BFu8i()
{
  {
    init_simple_test("Ul_D_BFu8i");
    static STRUCT_IF_C Ul_D_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu8i.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu8i.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "Ul_D_BFu8i");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "Ul_D_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu8i, Ul_D_BFu8i)
//============================================================================


struct  Ul_D_BFu8ll  {
  __tsu64 v1;
  double v2;
  __tsu64 v3:8;
};
//SIG(1 Ul_D_BFu8ll) C1{ FL[2] FL:8}



static void Test_Ul_D_BFu8ll()
{
  {
    init_simple_test("Ul_D_BFu8ll");
    static STRUCT_IF_C Ul_D_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu8ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "Ul_D_BFu8ll");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "Ul_D_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu8ll, Ul_D_BFu8ll)
//============================================================================


struct  Ul_D_BFu8s  {
  __tsu64 v1;
  double v2;
  unsigned short v3:8;
};
//SIG(1 Ul_D_BFu8s) C1{ FL[2] Fs:8}



static void Test_Ul_D_BFu8s()
{
  {
    init_simple_test("Ul_D_BFu8s");
    static STRUCT_IF_C Ul_D_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu8s.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu8s.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "Ul_D_BFu8s");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "Ul_D_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu8s, Ul_D_BFu8s)
//============================================================================


struct  Ul_D_BFu9i  {
  __tsu64 v1;
  double v2;
  unsigned int v3:9;
};
//SIG(1 Ul_D_BFu9i) C1{ FL[2] Fi:9}



static void Test_Ul_D_BFu9i()
{
  {
    init_simple_test("Ul_D_BFu9i");
    static STRUCT_IF_C Ul_D_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu9i.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu9i.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "Ul_D_BFu9i");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "Ul_D_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu9i, Ul_D_BFu9i)
//============================================================================


struct  Ul_D_BFu9ll  {
  __tsu64 v1;
  double v2;
  __tsu64 v3:9;
};
//SIG(1 Ul_D_BFu9ll) C1{ FL[2] FL:9}



static void Test_Ul_D_BFu9ll()
{
  {
    init_simple_test("Ul_D_BFu9ll");
    static STRUCT_IF_C Ul_D_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu9ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "Ul_D_BFu9ll");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "Ul_D_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu9ll, Ul_D_BFu9ll)
//============================================================================


struct  Ul_D_BFu9s  {
  __tsu64 v1;
  double v2;
  unsigned short v3:9;
};
//SIG(1 Ul_D_BFu9s) C1{ FL[2] Fs:9}



static void Test_Ul_D_BFu9s()
{
  {
    init_simple_test("Ul_D_BFu9s");
    static STRUCT_IF_C Ul_D_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_D_BFu9s.v1");
    check_field_offset(lv, v2, 8, "Ul_D_BFu9s.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "Ul_D_BFu9s");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "Ul_D_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_BFu9s, Ul_D_BFu9s)
//============================================================================


struct  Ul_D_C  {
  __tsu64 v1;
  double v2;
  char v3;
};
//SIG(1 Ul_D_C) C1{ FL[2] Fc}



static void Test_Ul_D_C()
{
  {
    init_simple_test("Ul_D_C");
    STRUCT_IF_C Ul_D_C lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_C)");
    check_field_offset(lv, v1, 0, "Ul_D_C.v1");
    check_field_offset(lv, v2, 8, "Ul_D_C.v2");
    check_field_offset(lv, v3, 16, "Ul_D_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_C, Ul_D_C)
//============================================================================


struct  Ul_D_D  {
  __tsu64 v1;
  double v2;
  double v3;
};
//SIG(1 Ul_D_D) C1{ FL[3]}



static void Test_Ul_D_D()
{
  {
    init_simple_test("Ul_D_D");
    STRUCT_IF_C Ul_D_D lv;
    check2(sizeof(lv), 24, "sizeof(Ul_D_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_D)");
    check_field_offset(lv, v1, 0, "Ul_D_D.v1");
    check_field_offset(lv, v2, 8, "Ul_D_D.v2");
    check_field_offset(lv, v3, 16, "Ul_D_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_D, Ul_D_D)
//============================================================================


struct  Ul_D_F  {
  __tsu64 v1;
  double v2;
  float v3;
};
//SIG(1 Ul_D_F) C1{ FL[2] Fi}



static void Test_Ul_D_F()
{
  {
    init_simple_test("Ul_D_F");
    STRUCT_IF_C Ul_D_F lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_F)");
    check_field_offset(lv, v1, 0, "Ul_D_F.v1");
    check_field_offset(lv, v2, 8, "Ul_D_F.v2");
    check_field_offset(lv, v3, 16, "Ul_D_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_F, Ul_D_F)
//============================================================================


struct  Ul_D_I  {
  __tsu64 v1;
  double v2;
  int v3;
};
//SIG(1 Ul_D_I) C1{ FL[2] Fi}



static void Test_Ul_D_I()
{
  {
    init_simple_test("Ul_D_I");
    STRUCT_IF_C Ul_D_I lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_I)");
    check_field_offset(lv, v1, 0, "Ul_D_I.v1");
    check_field_offset(lv, v2, 8, "Ul_D_I.v2");
    check_field_offset(lv, v3, 16, "Ul_D_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_I, Ul_D_I)
//============================================================================


struct  Ul_D_Ip  {
  __tsu64 v1;
  double v2;
  int *v3;
};
//SIG(1 Ul_D_Ip) C1{ FL[2] Fp}



static void Test_Ul_D_Ip()
{
  {
    init_simple_test("Ul_D_Ip");
    STRUCT_IF_C Ul_D_Ip lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_Ip)");
    check_field_offset(lv, v1, 0, "Ul_D_Ip.v1");
    check_field_offset(lv, v2, 8, "Ul_D_Ip.v2");
    check_field_offset(lv, v3, 16, "Ul_D_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_Ip, Ul_D_Ip)
//============================================================================


struct  Ul_D_L  {
  __tsu64 v1;
  double v2;
  __tsi64 v3;
};
//SIG(1 Ul_D_L) C1{ FL[3]}



static void Test_Ul_D_L()
{
  {
    init_simple_test("Ul_D_L");
    STRUCT_IF_C Ul_D_L lv;
    check2(sizeof(lv), 24, "sizeof(Ul_D_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_L)");
    check_field_offset(lv, v1, 0, "Ul_D_L.v1");
    check_field_offset(lv, v2, 8, "Ul_D_L.v2");
    check_field_offset(lv, v3, 16, "Ul_D_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_L, Ul_D_L)
//============================================================================


struct  Ul_D_S  {
  __tsu64 v1;
  double v2;
  short v3;
};
//SIG(1 Ul_D_S) C1{ FL[2] Fs}



static void Test_Ul_D_S()
{
  {
    init_simple_test("Ul_D_S");
    STRUCT_IF_C Ul_D_S lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_S)");
    check_field_offset(lv, v1, 0, "Ul_D_S.v1");
    check_field_offset(lv, v2, 8, "Ul_D_S.v2");
    check_field_offset(lv, v3, 16, "Ul_D_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_S, Ul_D_S)
//============================================================================


struct  Ul_D_Uc  {
  __tsu64 v1;
  double v2;
  unsigned char v3;
};
//SIG(1 Ul_D_Uc) C1{ FL[2] Fc}



static void Test_Ul_D_Uc()
{
  {
    init_simple_test("Ul_D_Uc");
    STRUCT_IF_C Ul_D_Uc lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_Uc)");
    check_field_offset(lv, v1, 0, "Ul_D_Uc.v1");
    check_field_offset(lv, v2, 8, "Ul_D_Uc.v2");
    check_field_offset(lv, v3, 16, "Ul_D_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_Uc, Ul_D_Uc)
//============================================================================


struct  Ul_D_Ui  {
  __tsu64 v1;
  double v2;
  unsigned int v3;
};
//SIG(1 Ul_D_Ui) C1{ FL[2] Fi}



static void Test_Ul_D_Ui()
{
  {
    init_simple_test("Ul_D_Ui");
    STRUCT_IF_C Ul_D_Ui lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_Ui)");
    check_field_offset(lv, v1, 0, "Ul_D_Ui.v1");
    check_field_offset(lv, v2, 8, "Ul_D_Ui.v2");
    check_field_offset(lv, v3, 16, "Ul_D_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_Ui, Ul_D_Ui)
//============================================================================


struct  Ul_D_Ul  {
  __tsu64 v1;
  double v2;
  __tsu64 v3;
};
//SIG(1 Ul_D_Ul) C1{ FL[3]}



static void Test_Ul_D_Ul()
{
  {
    init_simple_test("Ul_D_Ul");
    STRUCT_IF_C Ul_D_Ul lv;
    check2(sizeof(lv), 24, "sizeof(Ul_D_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_Ul)");
    check_field_offset(lv, v1, 0, "Ul_D_Ul.v1");
    check_field_offset(lv, v2, 8, "Ul_D_Ul.v2");
    check_field_offset(lv, v3, 16, "Ul_D_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_Ul, Ul_D_Ul)
//============================================================================


struct  Ul_D_Us  {
  __tsu64 v1;
  double v2;
  unsigned short v3;
};
//SIG(1 Ul_D_Us) C1{ FL[2] Fs}



static void Test_Ul_D_Us()
{
  {
    init_simple_test("Ul_D_Us");
    STRUCT_IF_C Ul_D_Us lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_Us)");
    check_field_offset(lv, v1, 0, "Ul_D_Us.v1");
    check_field_offset(lv, v2, 8, "Ul_D_Us.v2");
    check_field_offset(lv, v3, 16, "Ul_D_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_Us, Ul_D_Us)
//============================================================================


struct  Ul_D_Vp  {
  __tsu64 v1;
  double v2;
  void *v3;
};
//SIG(1 Ul_D_Vp) C1{ FL[2] Fp}



static void Test_Ul_D_Vp()
{
  {
    init_simple_test("Ul_D_Vp");
    STRUCT_IF_C Ul_D_Vp lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_D_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_D_Vp)");
    check_field_offset(lv, v1, 0, "Ul_D_Vp.v1");
    check_field_offset(lv, v2, 8, "Ul_D_Vp.v2");
    check_field_offset(lv, v3, 16, "Ul_D_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_D_Vp, Ul_D_Vp)
//============================================================================


struct  Ul_F  {
  __tsu64 v1;
  float v2;
};
//SIG(1 Ul_F) C1{ FL Fi}



static void Test_Ul_F()
{
  {
    init_simple_test("Ul_F");
    STRUCT_IF_C Ul_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F)");
    check_field_offset(lv, v1, 0, "Ul_F.v1");
    check_field_offset(lv, v2, 8, "Ul_F.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F, Ul_F)
//============================================================================


struct  Ul_F_BFu15i  {
  __tsu64 v1;
  float v2;
  unsigned int v3:15;
};
//SIG(1 Ul_F_BFu15i) C1{ FL Fi Fi:15}



static void Test_Ul_F_BFu15i()
{
  {
    init_simple_test("Ul_F_BFu15i");
    static STRUCT_IF_C Ul_F_BFu15i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu15i.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu15i.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "Ul_F_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "Ul_F_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu15i, Ul_F_BFu15i)
//============================================================================


struct  Ul_F_BFu15ll  {
  __tsu64 v1;
  float v2;
  __tsu64 v3:15;
};
//SIG(1 Ul_F_BFu15ll) C1{ FL Fi FL:15}



static void Test_Ul_F_BFu15ll()
{
  {
    init_simple_test("Ul_F_BFu15ll");
    static STRUCT_IF_C Ul_F_BFu15ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu15ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "Ul_F_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "Ul_F_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu15ll, Ul_F_BFu15ll)
//============================================================================


struct  Ul_F_BFu15s  {
  __tsu64 v1;
  float v2;
  unsigned short v3:15;
};
//SIG(1 Ul_F_BFu15s) C1{ FL Fi Fs:15}



static void Test_Ul_F_BFu15s()
{
  {
    init_simple_test("Ul_F_BFu15s");
    static STRUCT_IF_C Ul_F_BFu15s lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu15s.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu15s.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "Ul_F_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "Ul_F_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu15s, Ul_F_BFu15s)
//============================================================================


struct  Ul_F_BFu16i  {
  __tsu64 v1;
  float v2;
  unsigned int v3:16;
};
//SIG(1 Ul_F_BFu16i) C1{ FL Fi Fi:16}



static void Test_Ul_F_BFu16i()
{
  {
    init_simple_test("Ul_F_BFu16i");
    static STRUCT_IF_C Ul_F_BFu16i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu16i.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu16i.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "Ul_F_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "Ul_F_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu16i, Ul_F_BFu16i)
//============================================================================


struct  Ul_F_BFu16ll  {
  __tsu64 v1;
  float v2;
  __tsu64 v3:16;
};
//SIG(1 Ul_F_BFu16ll) C1{ FL Fi FL:16}



static void Test_Ul_F_BFu16ll()
{
  {
    init_simple_test("Ul_F_BFu16ll");
    static STRUCT_IF_C Ul_F_BFu16ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu16ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "Ul_F_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "Ul_F_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu16ll, Ul_F_BFu16ll)
//============================================================================


struct  Ul_F_BFu16s  {
  __tsu64 v1;
  float v2;
  unsigned short v3:16;
};
//SIG(1 Ul_F_BFu16s) C1{ FL Fi Fs:16}



static void Test_Ul_F_BFu16s()
{
  {
    init_simple_test("Ul_F_BFu16s");
    static STRUCT_IF_C Ul_F_BFu16s lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu16s.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu16s.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "Ul_F_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "Ul_F_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu16s, Ul_F_BFu16s)
//============================================================================


struct  Ul_F_BFu17i  {
  __tsu64 v1;
  float v2;
  unsigned int v3:17;
};
//SIG(1 Ul_F_BFu17i) C1{ FL Fi Fi:17}



static void Test_Ul_F_BFu17i()
{
  {
    init_simple_test("Ul_F_BFu17i");
    static STRUCT_IF_C Ul_F_BFu17i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu17i.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "Ul_F_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "Ul_F_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu17i, Ul_F_BFu17i)
//============================================================================


struct  Ul_F_BFu17ll  {
  __tsu64 v1;
  float v2;
  __tsu64 v3:17;
};
//SIG(1 Ul_F_BFu17ll) C1{ FL Fi FL:17}



static void Test_Ul_F_BFu17ll()
{
  {
    init_simple_test("Ul_F_BFu17ll");
    static STRUCT_IF_C Ul_F_BFu17ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu17ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "Ul_F_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "Ul_F_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu17ll, Ul_F_BFu17ll)
//============================================================================


struct  Ul_F_BFu1c  {
  __tsu64 v1;
  float v2;
  unsigned char v3:1;
};
//SIG(1 Ul_F_BFu1c) C1{ FL Fi Fc:1}



static void Test_Ul_F_BFu1c()
{
  {
    init_simple_test("Ul_F_BFu1c");
    static STRUCT_IF_C Ul_F_BFu1c lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu1c.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu1c.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_F_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu1c, Ul_F_BFu1c)
//============================================================================


struct  Ul_F_BFu1i  {
  __tsu64 v1;
  float v2;
  unsigned int v3:1;
};
//SIG(1 Ul_F_BFu1i) C1{ FL Fi Fi:1}



static void Test_Ul_F_BFu1i()
{
  {
    init_simple_test("Ul_F_BFu1i");
    static STRUCT_IF_C Ul_F_BFu1i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu1i.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu1i.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_F_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu1i, Ul_F_BFu1i)
//============================================================================


struct  Ul_F_BFu1ll  {
  __tsu64 v1;
  float v2;
  __tsu64 v3:1;
};
//SIG(1 Ul_F_BFu1ll) C1{ FL Fi FL:1}



static void Test_Ul_F_BFu1ll()
{
  {
    init_simple_test("Ul_F_BFu1ll");
    static STRUCT_IF_C Ul_F_BFu1ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu1ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_F_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu1ll, Ul_F_BFu1ll)
//============================================================================


struct  Ul_F_BFu1s  {
  __tsu64 v1;
  float v2;
  unsigned short v3:1;
};
//SIG(1 Ul_F_BFu1s) C1{ FL Fi Fs:1}



static void Test_Ul_F_BFu1s()
{
  {
    init_simple_test("Ul_F_BFu1s");
    static STRUCT_IF_C Ul_F_BFu1s lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu1s.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu1s.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_F_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu1s, Ul_F_BFu1s)
//============================================================================


struct  Ul_F_BFu31i  {
  __tsu64 v1;
  float v2;
  unsigned int v3:31;
};
//SIG(1 Ul_F_BFu31i) C1{ FL Fi Fi:31}



static void Test_Ul_F_BFu31i()
{
  {
    init_simple_test("Ul_F_BFu31i");
    static STRUCT_IF_C Ul_F_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu31i.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "Ul_F_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "Ul_F_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu31i, Ul_F_BFu31i)
//============================================================================


struct  Ul_F_BFu31ll  {
  __tsu64 v1;
  float v2;
  __tsu64 v3:31;
};
//SIG(1 Ul_F_BFu31ll) C1{ FL Fi FL:31}



static void Test_Ul_F_BFu31ll()
{
  {
    init_simple_test("Ul_F_BFu31ll");
    static STRUCT_IF_C Ul_F_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu31ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "Ul_F_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "Ul_F_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu31ll, Ul_F_BFu31ll)
//============================================================================


struct  Ul_F_BFu32i  {
  __tsu64 v1;
  float v2;
  unsigned int v3:32;
};
//SIG(1 Ul_F_BFu32i) C1{ FL Fi Fi:32}



static void Test_Ul_F_BFu32i()
{
  {
    init_simple_test("Ul_F_BFu32i");
    static STRUCT_IF_C Ul_F_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu32i.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_F_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_F_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu32i, Ul_F_BFu32i)
//============================================================================


struct  Ul_F_BFu32ll  {
  __tsu64 v1;
  float v2;
  __tsu64 v3:32;
};
//SIG(1 Ul_F_BFu32ll) C1{ FL Fi FL:32}



static void Test_Ul_F_BFu32ll()
{
  {
    init_simple_test("Ul_F_BFu32ll");
    static STRUCT_IF_C Ul_F_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu32ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_F_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_F_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu32ll, Ul_F_BFu32ll)
//============================================================================


struct  Ul_F_BFu33  {
  __tsu64 v1;
  float v2;
  __tsu64 v3:33;
};
//SIG(1 Ul_F_BFu33) C1{ FL Fi FL:33}



static void Test_Ul_F_BFu33()
{
  {
    init_simple_test("Ul_F_BFu33");
    static STRUCT_IF_C Ul_F_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_F_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu33.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "Ul_F_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "Ul_F_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu33, Ul_F_BFu33)
//============================================================================


struct  Ul_F_BFu7c  {
  __tsu64 v1;
  float v2;
  unsigned char v3:7;
};
//SIG(1 Ul_F_BFu7c) C1{ FL Fi Fc:7}



static void Test_Ul_F_BFu7c()
{
  {
    init_simple_test("Ul_F_BFu7c");
    static STRUCT_IF_C Ul_F_BFu7c lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu7c.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu7c.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_F_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_F_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu7c, Ul_F_BFu7c)
//============================================================================


struct  Ul_F_BFu7i  {
  __tsu64 v1;
  float v2;
  unsigned int v3:7;
};
//SIG(1 Ul_F_BFu7i) C1{ FL Fi Fi:7}



static void Test_Ul_F_BFu7i()
{
  {
    init_simple_test("Ul_F_BFu7i");
    static STRUCT_IF_C Ul_F_BFu7i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu7i.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu7i.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_F_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_F_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu7i, Ul_F_BFu7i)
//============================================================================


struct  Ul_F_BFu7ll  {
  __tsu64 v1;
  float v2;
  __tsu64 v3:7;
};
//SIG(1 Ul_F_BFu7ll) C1{ FL Fi FL:7}



static void Test_Ul_F_BFu7ll()
{
  {
    init_simple_test("Ul_F_BFu7ll");
    static STRUCT_IF_C Ul_F_BFu7ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu7ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_F_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_F_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu7ll, Ul_F_BFu7ll)
//============================================================================


struct  Ul_F_BFu7s  {
  __tsu64 v1;
  float v2;
  unsigned short v3:7;
};
//SIG(1 Ul_F_BFu7s) C1{ FL Fi Fs:7}



static void Test_Ul_F_BFu7s()
{
  {
    init_simple_test("Ul_F_BFu7s");
    static STRUCT_IF_C Ul_F_BFu7s lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu7s.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu7s.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_F_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_F_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu7s, Ul_F_BFu7s)
//============================================================================


struct  Ul_F_BFu8c  {
  __tsu64 v1;
  float v2;
  unsigned char v3:8;
};
//SIG(1 Ul_F_BFu8c) C1{ FL Fi Fc:8}



static void Test_Ul_F_BFu8c()
{
  {
    init_simple_test("Ul_F_BFu8c");
    static STRUCT_IF_C Ul_F_BFu8c lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu8c.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu8c.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_F_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_F_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu8c, Ul_F_BFu8c)
//============================================================================


struct  Ul_F_BFu8i  {
  __tsu64 v1;
  float v2;
  unsigned int v3:8;
};
//SIG(1 Ul_F_BFu8i) C1{ FL Fi Fi:8}



static void Test_Ul_F_BFu8i()
{
  {
    init_simple_test("Ul_F_BFu8i");
    static STRUCT_IF_C Ul_F_BFu8i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu8i.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu8i.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_F_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_F_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu8i, Ul_F_BFu8i)
//============================================================================


struct  Ul_F_BFu8ll  {
  __tsu64 v1;
  float v2;
  __tsu64 v3:8;
};
//SIG(1 Ul_F_BFu8ll) C1{ FL Fi FL:8}



static void Test_Ul_F_BFu8ll()
{
  {
    init_simple_test("Ul_F_BFu8ll");
    static STRUCT_IF_C Ul_F_BFu8ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu8ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_F_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_F_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu8ll, Ul_F_BFu8ll)
//============================================================================


struct  Ul_F_BFu8s  {
  __tsu64 v1;
  float v2;
  unsigned short v3:8;
};
//SIG(1 Ul_F_BFu8s) C1{ FL Fi Fs:8}



static void Test_Ul_F_BFu8s()
{
  {
    init_simple_test("Ul_F_BFu8s");
    static STRUCT_IF_C Ul_F_BFu8s lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu8s.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu8s.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_F_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_F_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu8s, Ul_F_BFu8s)
//============================================================================


struct  Ul_F_BFu9i  {
  __tsu64 v1;
  float v2;
  unsigned int v3:9;
};
//SIG(1 Ul_F_BFu9i) C1{ FL Fi Fi:9}



static void Test_Ul_F_BFu9i()
{
  {
    init_simple_test("Ul_F_BFu9i");
    static STRUCT_IF_C Ul_F_BFu9i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu9i.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu9i.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "Ul_F_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "Ul_F_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu9i, Ul_F_BFu9i)
//============================================================================


struct  Ul_F_BFu9ll  {
  __tsu64 v1;
  float v2;
  __tsu64 v3:9;
};
//SIG(1 Ul_F_BFu9ll) C1{ FL Fi FL:9}



static void Test_Ul_F_BFu9ll()
{
  {
    init_simple_test("Ul_F_BFu9ll");
    static STRUCT_IF_C Ul_F_BFu9ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu9ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "Ul_F_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "Ul_F_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu9ll, Ul_F_BFu9ll)
//============================================================================


struct  Ul_F_BFu9s  {
  __tsu64 v1;
  float v2;
  unsigned short v3:9;
};
//SIG(1 Ul_F_BFu9s) C1{ FL Fi Fs:9}



static void Test_Ul_F_BFu9s()
{
  {
    init_simple_test("Ul_F_BFu9s");
    static STRUCT_IF_C Ul_F_BFu9s lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_F_BFu9s.v1");
    check_field_offset(lv, v2, 8, "Ul_F_BFu9s.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "Ul_F_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "Ul_F_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_BFu9s, Ul_F_BFu9s)
//============================================================================


struct  Ul_F_C  {
  __tsu64 v1;
  float v2;
  char v3;
};
//SIG(1 Ul_F_C) C1{ FL Fi Fc}



static void Test_Ul_F_C()
{
  {
    init_simple_test("Ul_F_C");
    STRUCT_IF_C Ul_F_C lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_C)");
    check_field_offset(lv, v1, 0, "Ul_F_C.v1");
    check_field_offset(lv, v2, 8, "Ul_F_C.v2");
    check_field_offset(lv, v3, 12, "Ul_F_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_C, Ul_F_C)
//============================================================================


struct  Ul_F_D  {
  __tsu64 v1;
  float v2;
  double v3;
};
//SIG(1 Ul_F_D) C1{ FL Fi FL}



static void Test_Ul_F_D()
{
  {
    init_simple_test("Ul_F_D");
    STRUCT_IF_C Ul_F_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_F_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_D)");
    check_field_offset(lv, v1, 0, "Ul_F_D.v1");
    check_field_offset(lv, v2, 8, "Ul_F_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_F_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_D, Ul_F_D)
//============================================================================


struct  Ul_F_F  {
  __tsu64 v1;
  float v2;
  float v3;
};
//SIG(1 Ul_F_F) C1{ FL Fi[2]}



static void Test_Ul_F_F()
{
  {
    init_simple_test("Ul_F_F");
    STRUCT_IF_C Ul_F_F lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_F)");
    check_field_offset(lv, v1, 0, "Ul_F_F.v1");
    check_field_offset(lv, v2, 8, "Ul_F_F.v2");
    check_field_offset(lv, v3, 12, "Ul_F_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_F, Ul_F_F)
//============================================================================


struct  Ul_F_I  {
  __tsu64 v1;
  float v2;
  int v3;
};
//SIG(1 Ul_F_I) C1{ FL Fi[2]}



static void Test_Ul_F_I()
{
  {
    init_simple_test("Ul_F_I");
    STRUCT_IF_C Ul_F_I lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_I)");
    check_field_offset(lv, v1, 0, "Ul_F_I.v1");
    check_field_offset(lv, v2, 8, "Ul_F_I.v2");
    check_field_offset(lv, v3, 12, "Ul_F_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_I, Ul_F_I)
//============================================================================


struct  Ul_F_Ip  {
  __tsu64 v1;
  float v2;
  int *v3;
};
//SIG(1 Ul_F_Ip) C1{ FL Fi Fp}



static void Test_Ul_F_Ip()
{
  {
    init_simple_test("Ul_F_Ip");
    STRUCT_IF_C Ul_F_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_F_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_Ip)");
    check_field_offset(lv, v1, 0, "Ul_F_Ip.v1");
    check_field_offset(lv, v2, 8, "Ul_F_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_F_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_Ip, Ul_F_Ip)
//============================================================================


struct  Ul_F_L  {
  __tsu64 v1;
  float v2;
  __tsi64 v3;
};
//SIG(1 Ul_F_L) C1{ FL Fi FL}



static void Test_Ul_F_L()
{
  {
    init_simple_test("Ul_F_L");
    STRUCT_IF_C Ul_F_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_F_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_L)");
    check_field_offset(lv, v1, 0, "Ul_F_L.v1");
    check_field_offset(lv, v2, 8, "Ul_F_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_F_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_L, Ul_F_L)
//============================================================================


struct  Ul_F_S  {
  __tsu64 v1;
  float v2;
  short v3;
};
//SIG(1 Ul_F_S) C1{ FL Fi Fs}



static void Test_Ul_F_S()
{
  {
    init_simple_test("Ul_F_S");
    STRUCT_IF_C Ul_F_S lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_S)");
    check_field_offset(lv, v1, 0, "Ul_F_S.v1");
    check_field_offset(lv, v2, 8, "Ul_F_S.v2");
    check_field_offset(lv, v3, 12, "Ul_F_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_S, Ul_F_S)
//============================================================================


struct  Ul_F_Uc  {
  __tsu64 v1;
  float v2;
  unsigned char v3;
};
//SIG(1 Ul_F_Uc) C1{ FL Fi Fc}



static void Test_Ul_F_Uc()
{
  {
    init_simple_test("Ul_F_Uc");
    STRUCT_IF_C Ul_F_Uc lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_Uc)");
    check_field_offset(lv, v1, 0, "Ul_F_Uc.v1");
    check_field_offset(lv, v2, 8, "Ul_F_Uc.v2");
    check_field_offset(lv, v3, 12, "Ul_F_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_Uc, Ul_F_Uc)
//============================================================================


struct  Ul_F_Ui  {
  __tsu64 v1;
  float v2;
  unsigned int v3;
};
//SIG(1 Ul_F_Ui) C1{ FL Fi[2]}



static void Test_Ul_F_Ui()
{
  {
    init_simple_test("Ul_F_Ui");
    STRUCT_IF_C Ul_F_Ui lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_Ui)");
    check_field_offset(lv, v1, 0, "Ul_F_Ui.v1");
    check_field_offset(lv, v2, 8, "Ul_F_Ui.v2");
    check_field_offset(lv, v3, 12, "Ul_F_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_Ui, Ul_F_Ui)
//============================================================================


struct  Ul_F_Ul  {
  __tsu64 v1;
  float v2;
  __tsu64 v3;
};
//SIG(1 Ul_F_Ul) C1{ FL Fi FL}



static void Test_Ul_F_Ul()
{
  {
    init_simple_test("Ul_F_Ul");
    STRUCT_IF_C Ul_F_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_F_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_Ul)");
    check_field_offset(lv, v1, 0, "Ul_F_Ul.v1");
    check_field_offset(lv, v2, 8, "Ul_F_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_F_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_Ul, Ul_F_Ul)
//============================================================================


struct  Ul_F_Us  {
  __tsu64 v1;
  float v2;
  unsigned short v3;
};
//SIG(1 Ul_F_Us) C1{ FL Fi Fs}



static void Test_Ul_F_Us()
{
  {
    init_simple_test("Ul_F_Us");
    STRUCT_IF_C Ul_F_Us lv;
    check2(sizeof(lv), 16, "sizeof(Ul_F_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_Us)");
    check_field_offset(lv, v1, 0, "Ul_F_Us.v1");
    check_field_offset(lv, v2, 8, "Ul_F_Us.v2");
    check_field_offset(lv, v3, 12, "Ul_F_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_Us, Ul_F_Us)
//============================================================================


struct  Ul_F_Vp  {
  __tsu64 v1;
  float v2;
  void *v3;
};
//SIG(1 Ul_F_Vp) C1{ FL Fi Fp}



static void Test_Ul_F_Vp()
{
  {
    init_simple_test("Ul_F_Vp");
    STRUCT_IF_C Ul_F_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_F_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_F_Vp)");
    check_field_offset(lv, v1, 0, "Ul_F_Vp.v1");
    check_field_offset(lv, v2, 8, "Ul_F_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_F_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_F_Vp, Ul_F_Vp)
//============================================================================


struct  Ul_I  {
  __tsu64 v1;
  int v2;
};
//SIG(1 Ul_I) C1{ FL Fi}



static void Test_Ul_I()
{
  {
    init_simple_test("Ul_I");
    STRUCT_IF_C Ul_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I)");
    check_field_offset(lv, v1, 0, "Ul_I.v1");
    check_field_offset(lv, v2, 8, "Ul_I.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I, Ul_I)
//============================================================================


struct  Ul_I_BFu15i  {
  __tsu64 v1;
  int v2;
  unsigned int v3:15;
};
//SIG(1 Ul_I_BFu15i) C1{ FL Fi Fi:15}



static void Test_Ul_I_BFu15i()
{
  {
    init_simple_test("Ul_I_BFu15i");
    static STRUCT_IF_C Ul_I_BFu15i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu15i.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu15i.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "Ul_I_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "Ul_I_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu15i, Ul_I_BFu15i)
//============================================================================


struct  Ul_I_BFu15ll  {
  __tsu64 v1;
  int v2;
  __tsu64 v3:15;
};
//SIG(1 Ul_I_BFu15ll) C1{ FL Fi FL:15}



static void Test_Ul_I_BFu15ll()
{
  {
    init_simple_test("Ul_I_BFu15ll");
    static STRUCT_IF_C Ul_I_BFu15ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu15ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "Ul_I_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "Ul_I_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu15ll, Ul_I_BFu15ll)
//============================================================================


struct  Ul_I_BFu15s  {
  __tsu64 v1;
  int v2;
  unsigned short v3:15;
};
//SIG(1 Ul_I_BFu15s) C1{ FL Fi Fs:15}



static void Test_Ul_I_BFu15s()
{
  {
    init_simple_test("Ul_I_BFu15s");
    static STRUCT_IF_C Ul_I_BFu15s lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu15s.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu15s.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "Ul_I_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "Ul_I_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu15s, Ul_I_BFu15s)
//============================================================================


struct  Ul_I_BFu16i  {
  __tsu64 v1;
  int v2;
  unsigned int v3:16;
};
//SIG(1 Ul_I_BFu16i) C1{ FL Fi Fi:16}



static void Test_Ul_I_BFu16i()
{
  {
    init_simple_test("Ul_I_BFu16i");
    static STRUCT_IF_C Ul_I_BFu16i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu16i.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu16i.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "Ul_I_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "Ul_I_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu16i, Ul_I_BFu16i)
//============================================================================


struct  Ul_I_BFu16ll  {
  __tsu64 v1;
  int v2;
  __tsu64 v3:16;
};
//SIG(1 Ul_I_BFu16ll) C1{ FL Fi FL:16}



static void Test_Ul_I_BFu16ll()
{
  {
    init_simple_test("Ul_I_BFu16ll");
    static STRUCT_IF_C Ul_I_BFu16ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu16ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "Ul_I_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "Ul_I_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu16ll, Ul_I_BFu16ll)
//============================================================================


struct  Ul_I_BFu16s  {
  __tsu64 v1;
  int v2;
  unsigned short v3:16;
};
//SIG(1 Ul_I_BFu16s) C1{ FL Fi Fs:16}



static void Test_Ul_I_BFu16s()
{
  {
    init_simple_test("Ul_I_BFu16s");
    static STRUCT_IF_C Ul_I_BFu16s lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu16s.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu16s.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "Ul_I_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "Ul_I_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu16s, Ul_I_BFu16s)
//============================================================================


struct  Ul_I_BFu17i  {
  __tsu64 v1;
  int v2;
  unsigned int v3:17;
};
//SIG(1 Ul_I_BFu17i) C1{ FL Fi Fi:17}



static void Test_Ul_I_BFu17i()
{
  {
    init_simple_test("Ul_I_BFu17i");
    static STRUCT_IF_C Ul_I_BFu17i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu17i.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "Ul_I_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "Ul_I_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu17i, Ul_I_BFu17i)
//============================================================================


struct  Ul_I_BFu17ll  {
  __tsu64 v1;
  int v2;
  __tsu64 v3:17;
};
//SIG(1 Ul_I_BFu17ll) C1{ FL Fi FL:17}



static void Test_Ul_I_BFu17ll()
{
  {
    init_simple_test("Ul_I_BFu17ll");
    static STRUCT_IF_C Ul_I_BFu17ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu17ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "Ul_I_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "Ul_I_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu17ll, Ul_I_BFu17ll)
//============================================================================


struct  Ul_I_BFu1c  {
  __tsu64 v1;
  int v2;
  unsigned char v3:1;
};
//SIG(1 Ul_I_BFu1c) C1{ FL Fi Fc:1}



static void Test_Ul_I_BFu1c()
{
  {
    init_simple_test("Ul_I_BFu1c");
    static STRUCT_IF_C Ul_I_BFu1c lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu1c.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu1c.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_I_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu1c, Ul_I_BFu1c)
//============================================================================


struct  Ul_I_BFu1i  {
  __tsu64 v1;
  int v2;
  unsigned int v3:1;
};
//SIG(1 Ul_I_BFu1i) C1{ FL Fi Fi:1}



static void Test_Ul_I_BFu1i()
{
  {
    init_simple_test("Ul_I_BFu1i");
    static STRUCT_IF_C Ul_I_BFu1i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu1i.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu1i.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_I_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu1i, Ul_I_BFu1i)
//============================================================================


struct  Ul_I_BFu1ll  {
  __tsu64 v1;
  int v2;
  __tsu64 v3:1;
};
//SIG(1 Ul_I_BFu1ll) C1{ FL Fi FL:1}



static void Test_Ul_I_BFu1ll()
{
  {
    init_simple_test("Ul_I_BFu1ll");
    static STRUCT_IF_C Ul_I_BFu1ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu1ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_I_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu1ll, Ul_I_BFu1ll)
//============================================================================


struct  Ul_I_BFu1s  {
  __tsu64 v1;
  int v2;
  unsigned short v3:1;
};
//SIG(1 Ul_I_BFu1s) C1{ FL Fi Fs:1}



static void Test_Ul_I_BFu1s()
{
  {
    init_simple_test("Ul_I_BFu1s");
    static STRUCT_IF_C Ul_I_BFu1s lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu1s.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu1s.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_I_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu1s, Ul_I_BFu1s)
//============================================================================


struct  Ul_I_BFu31i  {
  __tsu64 v1;
  int v2;
  unsigned int v3:31;
};
//SIG(1 Ul_I_BFu31i) C1{ FL Fi Fi:31}



static void Test_Ul_I_BFu31i()
{
  {
    init_simple_test("Ul_I_BFu31i");
    static STRUCT_IF_C Ul_I_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu31i.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "Ul_I_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "Ul_I_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu31i, Ul_I_BFu31i)
//============================================================================


struct  Ul_I_BFu31ll  {
  __tsu64 v1;
  int v2;
  __tsu64 v3:31;
};
//SIG(1 Ul_I_BFu31ll) C1{ FL Fi FL:31}



static void Test_Ul_I_BFu31ll()
{
  {
    init_simple_test("Ul_I_BFu31ll");
    static STRUCT_IF_C Ul_I_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu31ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "Ul_I_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "Ul_I_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu31ll, Ul_I_BFu31ll)
//============================================================================


struct  Ul_I_BFu32i  {
  __tsu64 v1;
  int v2;
  unsigned int v3:32;
};
//SIG(1 Ul_I_BFu32i) C1{ FL Fi Fi:32}



static void Test_Ul_I_BFu32i()
{
  {
    init_simple_test("Ul_I_BFu32i");
    static STRUCT_IF_C Ul_I_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu32i.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_I_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_I_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu32i, Ul_I_BFu32i)
//============================================================================


struct  Ul_I_BFu32ll  {
  __tsu64 v1;
  int v2;
  __tsu64 v3:32;
};
//SIG(1 Ul_I_BFu32ll) C1{ FL Fi FL:32}



static void Test_Ul_I_BFu32ll()
{
  {
    init_simple_test("Ul_I_BFu32ll");
    static STRUCT_IF_C Ul_I_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu32ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_I_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_I_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu32ll, Ul_I_BFu32ll)
//============================================================================


struct  Ul_I_BFu33  {
  __tsu64 v1;
  int v2;
  __tsu64 v3:33;
};
//SIG(1 Ul_I_BFu33) C1{ FL Fi FL:33}



static void Test_Ul_I_BFu33()
{
  {
    init_simple_test("Ul_I_BFu33");
    static STRUCT_IF_C Ul_I_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_I_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu33.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "Ul_I_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "Ul_I_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu33, Ul_I_BFu33)
//============================================================================


struct  Ul_I_BFu7c  {
  __tsu64 v1;
  int v2;
  unsigned char v3:7;
};
//SIG(1 Ul_I_BFu7c) C1{ FL Fi Fc:7}



static void Test_Ul_I_BFu7c()
{
  {
    init_simple_test("Ul_I_BFu7c");
    static STRUCT_IF_C Ul_I_BFu7c lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu7c.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu7c.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_I_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_I_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu7c, Ul_I_BFu7c)
//============================================================================


struct  Ul_I_BFu7i  {
  __tsu64 v1;
  int v2;
  unsigned int v3:7;
};
//SIG(1 Ul_I_BFu7i) C1{ FL Fi Fi:7}



static void Test_Ul_I_BFu7i()
{
  {
    init_simple_test("Ul_I_BFu7i");
    static STRUCT_IF_C Ul_I_BFu7i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu7i.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu7i.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_I_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_I_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu7i, Ul_I_BFu7i)
//============================================================================


struct  Ul_I_BFu7ll  {
  __tsu64 v1;
  int v2;
  __tsu64 v3:7;
};
//SIG(1 Ul_I_BFu7ll) C1{ FL Fi FL:7}



static void Test_Ul_I_BFu7ll()
{
  {
    init_simple_test("Ul_I_BFu7ll");
    static STRUCT_IF_C Ul_I_BFu7ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu7ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_I_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_I_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu7ll, Ul_I_BFu7ll)
//============================================================================


struct  Ul_I_BFu7s  {
  __tsu64 v1;
  int v2;
  unsigned short v3:7;
};
//SIG(1 Ul_I_BFu7s) C1{ FL Fi Fs:7}



static void Test_Ul_I_BFu7s()
{
  {
    init_simple_test("Ul_I_BFu7s");
    static STRUCT_IF_C Ul_I_BFu7s lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu7s.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu7s.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_I_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_I_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu7s, Ul_I_BFu7s)
//============================================================================


struct  Ul_I_BFu8c  {
  __tsu64 v1;
  int v2;
  unsigned char v3:8;
};
//SIG(1 Ul_I_BFu8c) C1{ FL Fi Fc:8}



static void Test_Ul_I_BFu8c()
{
  {
    init_simple_test("Ul_I_BFu8c");
    static STRUCT_IF_C Ul_I_BFu8c lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu8c.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu8c.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_I_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_I_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu8c, Ul_I_BFu8c)
//============================================================================


struct  Ul_I_BFu8i  {
  __tsu64 v1;
  int v2;
  unsigned int v3:8;
};
//SIG(1 Ul_I_BFu8i) C1{ FL Fi Fi:8}



static void Test_Ul_I_BFu8i()
{
  {
    init_simple_test("Ul_I_BFu8i");
    static STRUCT_IF_C Ul_I_BFu8i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu8i.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu8i.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_I_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_I_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu8i, Ul_I_BFu8i)
//============================================================================


struct  Ul_I_BFu8ll  {
  __tsu64 v1;
  int v2;
  __tsu64 v3:8;
};
//SIG(1 Ul_I_BFu8ll) C1{ FL Fi FL:8}



static void Test_Ul_I_BFu8ll()
{
  {
    init_simple_test("Ul_I_BFu8ll");
    static STRUCT_IF_C Ul_I_BFu8ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu8ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_I_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_I_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu8ll, Ul_I_BFu8ll)
//============================================================================


struct  Ul_I_BFu8s  {
  __tsu64 v1;
  int v2;
  unsigned short v3:8;
};
//SIG(1 Ul_I_BFu8s) C1{ FL Fi Fs:8}



static void Test_Ul_I_BFu8s()
{
  {
    init_simple_test("Ul_I_BFu8s");
    static STRUCT_IF_C Ul_I_BFu8s lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu8s.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu8s.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_I_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_I_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu8s, Ul_I_BFu8s)
//============================================================================


struct  Ul_I_BFu9i  {
  __tsu64 v1;
  int v2;
  unsigned int v3:9;
};
//SIG(1 Ul_I_BFu9i) C1{ FL Fi Fi:9}



static void Test_Ul_I_BFu9i()
{
  {
    init_simple_test("Ul_I_BFu9i");
    static STRUCT_IF_C Ul_I_BFu9i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu9i.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu9i.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "Ul_I_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "Ul_I_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu9i, Ul_I_BFu9i)
//============================================================================


struct  Ul_I_BFu9ll  {
  __tsu64 v1;
  int v2;
  __tsu64 v3:9;
};
//SIG(1 Ul_I_BFu9ll) C1{ FL Fi FL:9}



static void Test_Ul_I_BFu9ll()
{
  {
    init_simple_test("Ul_I_BFu9ll");
    static STRUCT_IF_C Ul_I_BFu9ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu9ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "Ul_I_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "Ul_I_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu9ll, Ul_I_BFu9ll)
//============================================================================


struct  Ul_I_BFu9s  {
  __tsu64 v1;
  int v2;
  unsigned short v3:9;
};
//SIG(1 Ul_I_BFu9s) C1{ FL Fi Fs:9}



static void Test_Ul_I_BFu9s()
{
  {
    init_simple_test("Ul_I_BFu9s");
    static STRUCT_IF_C Ul_I_BFu9s lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_I_BFu9s.v1");
    check_field_offset(lv, v2, 8, "Ul_I_BFu9s.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "Ul_I_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "Ul_I_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_BFu9s, Ul_I_BFu9s)
//============================================================================


struct  Ul_I_C  {
  __tsu64 v1;
  int v2;
  char v3;
};
//SIG(1 Ul_I_C) C1{ FL Fi Fc}



static void Test_Ul_I_C()
{
  {
    init_simple_test("Ul_I_C");
    STRUCT_IF_C Ul_I_C lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_C)");
    check_field_offset(lv, v1, 0, "Ul_I_C.v1");
    check_field_offset(lv, v2, 8, "Ul_I_C.v2");
    check_field_offset(lv, v3, 12, "Ul_I_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_C, Ul_I_C)
//============================================================================


struct  Ul_I_D  {
  __tsu64 v1;
  int v2;
  double v3;
};
//SIG(1 Ul_I_D) C1{ FL Fi FL}



static void Test_Ul_I_D()
{
  {
    init_simple_test("Ul_I_D");
    STRUCT_IF_C Ul_I_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_I_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_D)");
    check_field_offset(lv, v1, 0, "Ul_I_D.v1");
    check_field_offset(lv, v2, 8, "Ul_I_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_I_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_D, Ul_I_D)
//============================================================================


struct  Ul_I_F  {
  __tsu64 v1;
  int v2;
  float v3;
};
//SIG(1 Ul_I_F) C1{ FL Fi[2]}



static void Test_Ul_I_F()
{
  {
    init_simple_test("Ul_I_F");
    STRUCT_IF_C Ul_I_F lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_F)");
    check_field_offset(lv, v1, 0, "Ul_I_F.v1");
    check_field_offset(lv, v2, 8, "Ul_I_F.v2");
    check_field_offset(lv, v3, 12, "Ul_I_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_F, Ul_I_F)
//============================================================================


struct  Ul_I_I  {
  __tsu64 v1;
  int v2;
  int v3;
};
//SIG(1 Ul_I_I) C1{ FL Fi[2]}



static void Test_Ul_I_I()
{
  {
    init_simple_test("Ul_I_I");
    STRUCT_IF_C Ul_I_I lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_I)");
    check_field_offset(lv, v1, 0, "Ul_I_I.v1");
    check_field_offset(lv, v2, 8, "Ul_I_I.v2");
    check_field_offset(lv, v3, 12, "Ul_I_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_I, Ul_I_I)
//============================================================================


struct  Ul_I_Ip  {
  __tsu64 v1;
  int v2;
  int *v3;
};
//SIG(1 Ul_I_Ip) C1{ FL Fi Fp}



static void Test_Ul_I_Ip()
{
  {
    init_simple_test("Ul_I_Ip");
    STRUCT_IF_C Ul_I_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_I_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_Ip)");
    check_field_offset(lv, v1, 0, "Ul_I_Ip.v1");
    check_field_offset(lv, v2, 8, "Ul_I_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_I_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_Ip, Ul_I_Ip)
//============================================================================


struct  Ul_I_L  {
  __tsu64 v1;
  int v2;
  __tsi64 v3;
};
//SIG(1 Ul_I_L) C1{ FL Fi FL}



static void Test_Ul_I_L()
{
  {
    init_simple_test("Ul_I_L");
    STRUCT_IF_C Ul_I_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_I_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_L)");
    check_field_offset(lv, v1, 0, "Ul_I_L.v1");
    check_field_offset(lv, v2, 8, "Ul_I_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_I_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_L, Ul_I_L)
//============================================================================


struct  Ul_I_S  {
  __tsu64 v1;
  int v2;
  short v3;
};
//SIG(1 Ul_I_S) C1{ FL Fi Fs}



static void Test_Ul_I_S()
{
  {
    init_simple_test("Ul_I_S");
    STRUCT_IF_C Ul_I_S lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_S)");
    check_field_offset(lv, v1, 0, "Ul_I_S.v1");
    check_field_offset(lv, v2, 8, "Ul_I_S.v2");
    check_field_offset(lv, v3, 12, "Ul_I_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_S, Ul_I_S)
//============================================================================


struct  Ul_I_Uc  {
  __tsu64 v1;
  int v2;
  unsigned char v3;
};
//SIG(1 Ul_I_Uc) C1{ FL Fi Fc}



static void Test_Ul_I_Uc()
{
  {
    init_simple_test("Ul_I_Uc");
    STRUCT_IF_C Ul_I_Uc lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_Uc)");
    check_field_offset(lv, v1, 0, "Ul_I_Uc.v1");
    check_field_offset(lv, v2, 8, "Ul_I_Uc.v2");
    check_field_offset(lv, v3, 12, "Ul_I_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_Uc, Ul_I_Uc)
//============================================================================


struct  Ul_I_Ui  {
  __tsu64 v1;
  int v2;
  unsigned int v3;
};
//SIG(1 Ul_I_Ui) C1{ FL Fi[2]}



static void Test_Ul_I_Ui()
{
  {
    init_simple_test("Ul_I_Ui");
    STRUCT_IF_C Ul_I_Ui lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_Ui)");
    check_field_offset(lv, v1, 0, "Ul_I_Ui.v1");
    check_field_offset(lv, v2, 8, "Ul_I_Ui.v2");
    check_field_offset(lv, v3, 12, "Ul_I_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_Ui, Ul_I_Ui)
//============================================================================


struct  Ul_I_Ul  {
  __tsu64 v1;
  int v2;
  __tsu64 v3;
};
//SIG(1 Ul_I_Ul) C1{ FL Fi FL}



static void Test_Ul_I_Ul()
{
  {
    init_simple_test("Ul_I_Ul");
    STRUCT_IF_C Ul_I_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_I_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_Ul)");
    check_field_offset(lv, v1, 0, "Ul_I_Ul.v1");
    check_field_offset(lv, v2, 8, "Ul_I_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_I_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_Ul, Ul_I_Ul)
//============================================================================


struct  Ul_I_Us  {
  __tsu64 v1;
  int v2;
  unsigned short v3;
};
//SIG(1 Ul_I_Us) C1{ FL Fi Fs}



static void Test_Ul_I_Us()
{
  {
    init_simple_test("Ul_I_Us");
    STRUCT_IF_C Ul_I_Us lv;
    check2(sizeof(lv), 16, "sizeof(Ul_I_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_Us)");
    check_field_offset(lv, v1, 0, "Ul_I_Us.v1");
    check_field_offset(lv, v2, 8, "Ul_I_Us.v2");
    check_field_offset(lv, v3, 12, "Ul_I_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_Us, Ul_I_Us)
//============================================================================


struct  Ul_I_Vp  {
  __tsu64 v1;
  int v2;
  void *v3;
};
//SIG(1 Ul_I_Vp) C1{ FL Fi Fp}



static void Test_Ul_I_Vp()
{
  {
    init_simple_test("Ul_I_Vp");
    STRUCT_IF_C Ul_I_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_I_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_I_Vp)");
    check_field_offset(lv, v1, 0, "Ul_I_Vp.v1");
    check_field_offset(lv, v2, 8, "Ul_I_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_I_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_I_Vp, Ul_I_Vp)
//============================================================================


struct  Ul_Ip  {
  __tsu64 v1;
  int *v2;
};
//SIG(1 Ul_Ip) C1{ FL Fp}



static void Test_Ul_Ip()
{
  {
    init_simple_test("Ul_Ip");
    STRUCT_IF_C Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip)");
    check_field_offset(lv, v1, 0, "Ul_Ip.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip, Ul_Ip)
//============================================================================


struct  Ul_Ip_BFu15i  {
  __tsu64 v1;
  int *v2;
  unsigned int v3:15;
};
//SIG(1 Ul_Ip_BFu15i) C1{ FL Fp Fi:15}



static void Test_Ul_Ip_BFu15i()
{
  {
    init_simple_test("Ul_Ip_BFu15i");
    static STRUCT_IF_C Ul_Ip_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu15i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "Ul_Ip_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "Ul_Ip_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu15i, Ul_Ip_BFu15i)
//============================================================================


struct  Ul_Ip_BFu15ll  {
  __tsu64 v1;
  int *v2;
  __tsu64 v3:15;
};
//SIG(1 Ul_Ip_BFu15ll) C1{ FL Fp FL:15}



static void Test_Ul_Ip_BFu15ll()
{
  {
    init_simple_test("Ul_Ip_BFu15ll");
    static STRUCT_IF_C Ul_Ip_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "Ul_Ip_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "Ul_Ip_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu15ll, Ul_Ip_BFu15ll)
//============================================================================


struct  Ul_Ip_BFu15s  {
  __tsu64 v1;
  int *v2;
  unsigned short v3:15;
};
//SIG(1 Ul_Ip_BFu15s) C1{ FL Fp Fs:15}



static void Test_Ul_Ip_BFu15s()
{
  {
    init_simple_test("Ul_Ip_BFu15s");
    static STRUCT_IF_C Ul_Ip_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu15s.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "Ul_Ip_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "Ul_Ip_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu15s, Ul_Ip_BFu15s)
//============================================================================


struct  Ul_Ip_BFu16i  {
  __tsu64 v1;
  int *v2;
  unsigned int v3:16;
};
//SIG(1 Ul_Ip_BFu16i) C1{ FL Fp Fi:16}



static void Test_Ul_Ip_BFu16i()
{
  {
    init_simple_test("Ul_Ip_BFu16i");
    static STRUCT_IF_C Ul_Ip_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu16i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "Ul_Ip_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "Ul_Ip_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu16i, Ul_Ip_BFu16i)
//============================================================================


struct  Ul_Ip_BFu16ll  {
  __tsu64 v1;
  int *v2;
  __tsu64 v3:16;
};
//SIG(1 Ul_Ip_BFu16ll) C1{ FL Fp FL:16}



static void Test_Ul_Ip_BFu16ll()
{
  {
    init_simple_test("Ul_Ip_BFu16ll");
    static STRUCT_IF_C Ul_Ip_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "Ul_Ip_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "Ul_Ip_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu16ll, Ul_Ip_BFu16ll)
//============================================================================


struct  Ul_Ip_BFu16s  {
  __tsu64 v1;
  int *v2;
  unsigned short v3:16;
};
//SIG(1 Ul_Ip_BFu16s) C1{ FL Fp Fs:16}



static void Test_Ul_Ip_BFu16s()
{
  {
    init_simple_test("Ul_Ip_BFu16s");
    static STRUCT_IF_C Ul_Ip_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu16s.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "Ul_Ip_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "Ul_Ip_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu16s, Ul_Ip_BFu16s)
//============================================================================


struct  Ul_Ip_BFu17i  {
  __tsu64 v1;
  int *v2;
  unsigned int v3:17;
};
//SIG(1 Ul_Ip_BFu17i) C1{ FL Fp Fi:17}



static void Test_Ul_Ip_BFu17i()
{
  {
    init_simple_test("Ul_Ip_BFu17i");
    static STRUCT_IF_C Ul_Ip_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu17i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "Ul_Ip_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "Ul_Ip_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu17i, Ul_Ip_BFu17i)
//============================================================================


struct  Ul_Ip_BFu17ll  {
  __tsu64 v1;
  int *v2;
  __tsu64 v3:17;
};
//SIG(1 Ul_Ip_BFu17ll) C1{ FL Fp FL:17}



static void Test_Ul_Ip_BFu17ll()
{
  {
    init_simple_test("Ul_Ip_BFu17ll");
    static STRUCT_IF_C Ul_Ip_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "Ul_Ip_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "Ul_Ip_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu17ll, Ul_Ip_BFu17ll)
//============================================================================


struct  Ul_Ip_BFu1c  {
  __tsu64 v1;
  int *v2;
  unsigned char v3:1;
};
//SIG(1 Ul_Ip_BFu1c) C1{ FL Fp Fc:1}



static void Test_Ul_Ip_BFu1c()
{
  {
    init_simple_test("Ul_Ip_BFu1c");
    static STRUCT_IF_C Ul_Ip_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu1c.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Ul_Ip_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu1c, Ul_Ip_BFu1c)
//============================================================================


struct  Ul_Ip_BFu1i  {
  __tsu64 v1;
  int *v2;
  unsigned int v3:1;
};
//SIG(1 Ul_Ip_BFu1i) C1{ FL Fp Fi:1}



static void Test_Ul_Ip_BFu1i()
{
  {
    init_simple_test("Ul_Ip_BFu1i");
    static STRUCT_IF_C Ul_Ip_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu1i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Ul_Ip_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu1i, Ul_Ip_BFu1i)
//============================================================================


struct  Ul_Ip_BFu1ll  {
  __tsu64 v1;
  int *v2;
  __tsu64 v3:1;
};
//SIG(1 Ul_Ip_BFu1ll) C1{ FL Fp FL:1}



static void Test_Ul_Ip_BFu1ll()
{
  {
    init_simple_test("Ul_Ip_BFu1ll");
    static STRUCT_IF_C Ul_Ip_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Ul_Ip_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu1ll, Ul_Ip_BFu1ll)
//============================================================================


struct  Ul_Ip_BFu1s  {
  __tsu64 v1;
  int *v2;
  unsigned short v3:1;
};
//SIG(1 Ul_Ip_BFu1s) C1{ FL Fp Fs:1}



static void Test_Ul_Ip_BFu1s()
{
  {
    init_simple_test("Ul_Ip_BFu1s");
    static STRUCT_IF_C Ul_Ip_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu1s.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Ul_Ip_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu1s, Ul_Ip_BFu1s)
//============================================================================


struct  Ul_Ip_BFu31i  {
  __tsu64 v1;
  int *v2;
  unsigned int v3:31;
};
//SIG(1 Ul_Ip_BFu31i) C1{ FL Fp Fi:31}



static void Test_Ul_Ip_BFu31i()
{
  {
    init_simple_test("Ul_Ip_BFu31i");
    static STRUCT_IF_C Ul_Ip_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu31i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "Ul_Ip_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "Ul_Ip_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu31i, Ul_Ip_BFu31i)
//============================================================================


struct  Ul_Ip_BFu31ll  {
  __tsu64 v1;
  int *v2;
  __tsu64 v3:31;
};
//SIG(1 Ul_Ip_BFu31ll) C1{ FL Fp FL:31}



static void Test_Ul_Ip_BFu31ll()
{
  {
    init_simple_test("Ul_Ip_BFu31ll");
    static STRUCT_IF_C Ul_Ip_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "Ul_Ip_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "Ul_Ip_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu31ll, Ul_Ip_BFu31ll)
//============================================================================


struct  Ul_Ip_BFu32i  {
  __tsu64 v1;
  int *v2;
  unsigned int v3:32;
};
//SIG(1 Ul_Ip_BFu32i) C1{ FL Fp Fi:32}



static void Test_Ul_Ip_BFu32i()
{
  {
    init_simple_test("Ul_Ip_BFu32i");
    static STRUCT_IF_C Ul_Ip_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu32i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "Ul_Ip_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "Ul_Ip_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu32i, Ul_Ip_BFu32i)
//============================================================================


struct  Ul_Ip_BFu32ll  {
  __tsu64 v1;
  int *v2;
  __tsu64 v3:32;
};
//SIG(1 Ul_Ip_BFu32ll) C1{ FL Fp FL:32}



static void Test_Ul_Ip_BFu32ll()
{
  {
    init_simple_test("Ul_Ip_BFu32ll");
    static STRUCT_IF_C Ul_Ip_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "Ul_Ip_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "Ul_Ip_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu32ll, Ul_Ip_BFu32ll)
//============================================================================


struct  Ul_Ip_BFu33  {
  __tsu64 v1;
  int *v2;
  __tsu64 v3:33;
};
//SIG(1 Ul_Ip_BFu33) C1{ FL Fp FL:33}



static void Test_Ul_Ip_BFu33()
{
  {
    init_simple_test("Ul_Ip_BFu33");
    static STRUCT_IF_C Ul_Ip_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ip_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu33.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "Ul_Ip_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "Ul_Ip_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu33, Ul_Ip_BFu33)
//============================================================================


struct  Ul_Ip_BFu7c  {
  __tsu64 v1;
  int *v2;
  unsigned char v3:7;
};
//SIG(1 Ul_Ip_BFu7c) C1{ FL Fp Fc:7}



static void Test_Ul_Ip_BFu7c()
{
  {
    init_simple_test("Ul_Ip_BFu7c");
    static STRUCT_IF_C Ul_Ip_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu7c.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Ul_Ip_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Ul_Ip_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu7c, Ul_Ip_BFu7c)
//============================================================================


struct  Ul_Ip_BFu7i  {
  __tsu64 v1;
  int *v2;
  unsigned int v3:7;
};
//SIG(1 Ul_Ip_BFu7i) C1{ FL Fp Fi:7}



static void Test_Ul_Ip_BFu7i()
{
  {
    init_simple_test("Ul_Ip_BFu7i");
    static STRUCT_IF_C Ul_Ip_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu7i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Ul_Ip_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Ul_Ip_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu7i, Ul_Ip_BFu7i)
//============================================================================


struct  Ul_Ip_BFu7ll  {
  __tsu64 v1;
  int *v2;
  __tsu64 v3:7;
};
//SIG(1 Ul_Ip_BFu7ll) C1{ FL Fp FL:7}



static void Test_Ul_Ip_BFu7ll()
{
  {
    init_simple_test("Ul_Ip_BFu7ll");
    static STRUCT_IF_C Ul_Ip_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Ul_Ip_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Ul_Ip_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu7ll, Ul_Ip_BFu7ll)
//============================================================================


struct  Ul_Ip_BFu7s  {
  __tsu64 v1;
  int *v2;
  unsigned short v3:7;
};
//SIG(1 Ul_Ip_BFu7s) C1{ FL Fp Fs:7}



static void Test_Ul_Ip_BFu7s()
{
  {
    init_simple_test("Ul_Ip_BFu7s");
    static STRUCT_IF_C Ul_Ip_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu7s.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Ul_Ip_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Ul_Ip_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu7s, Ul_Ip_BFu7s)
//============================================================================


struct  Ul_Ip_BFu8c  {
  __tsu64 v1;
  int *v2;
  unsigned char v3:8;
};
//SIG(1 Ul_Ip_BFu8c) C1{ FL Fp Fc:8}



static void Test_Ul_Ip_BFu8c()
{
  {
    init_simple_test("Ul_Ip_BFu8c");
    static STRUCT_IF_C Ul_Ip_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu8c.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Ul_Ip_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Ul_Ip_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu8c, Ul_Ip_BFu8c)
//============================================================================


struct  Ul_Ip_BFu8i  {
  __tsu64 v1;
  int *v2;
  unsigned int v3:8;
};
//SIG(1 Ul_Ip_BFu8i) C1{ FL Fp Fi:8}



static void Test_Ul_Ip_BFu8i()
{
  {
    init_simple_test("Ul_Ip_BFu8i");
    static STRUCT_IF_C Ul_Ip_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu8i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Ul_Ip_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Ul_Ip_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu8i, Ul_Ip_BFu8i)
//============================================================================


struct  Ul_Ip_BFu8ll  {
  __tsu64 v1;
  int *v2;
  __tsu64 v3:8;
};
//SIG(1 Ul_Ip_BFu8ll) C1{ FL Fp FL:8}



static void Test_Ul_Ip_BFu8ll()
{
  {
    init_simple_test("Ul_Ip_BFu8ll");
    static STRUCT_IF_C Ul_Ip_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Ul_Ip_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Ul_Ip_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu8ll, Ul_Ip_BFu8ll)
//============================================================================


struct  Ul_Ip_BFu8s  {
  __tsu64 v1;
  int *v2;
  unsigned short v3:8;
};
//SIG(1 Ul_Ip_BFu8s) C1{ FL Fp Fs:8}



static void Test_Ul_Ip_BFu8s()
{
  {
    init_simple_test("Ul_Ip_BFu8s");
    static STRUCT_IF_C Ul_Ip_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu8s.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Ul_Ip_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Ul_Ip_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu8s, Ul_Ip_BFu8s)
//============================================================================


struct  Ul_Ip_BFu9i  {
  __tsu64 v1;
  int *v2;
  unsigned int v3:9;
};
//SIG(1 Ul_Ip_BFu9i) C1{ FL Fp Fi:9}



static void Test_Ul_Ip_BFu9i()
{
  {
    init_simple_test("Ul_Ip_BFu9i");
    static STRUCT_IF_C Ul_Ip_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu9i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Ul_Ip_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Ul_Ip_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu9i, Ul_Ip_BFu9i)
//============================================================================


struct  Ul_Ip_BFu9ll  {
  __tsu64 v1;
  int *v2;
  __tsu64 v3:9;
};
//SIG(1 Ul_Ip_BFu9ll) C1{ FL Fp FL:9}



static void Test_Ul_Ip_BFu9ll()
{
  {
    init_simple_test("Ul_Ip_BFu9ll");
    static STRUCT_IF_C Ul_Ip_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Ul_Ip_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Ul_Ip_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu9ll, Ul_Ip_BFu9ll)
//============================================================================


struct  Ul_Ip_BFu9s  {
  __tsu64 v1;
  int *v2;
  unsigned short v3:9;
};
//SIG(1 Ul_Ip_BFu9s) C1{ FL Fp Fs:9}



static void Test_Ul_Ip_BFu9s()
{
  {
    init_simple_test("Ul_Ip_BFu9s");
    static STRUCT_IF_C Ul_Ip_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_Ip_BFu9s.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Ul_Ip_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Ul_Ip_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_BFu9s, Ul_Ip_BFu9s)
//============================================================================


struct  Ul_Ip_C  {
  __tsu64 v1;
  int *v2;
  char v3;
};
//SIG(1 Ul_Ip_C) C1{ FL Fp Fc}



static void Test_Ul_Ip_C()
{
  {
    init_simple_test("Ul_Ip_C");
    STRUCT_IF_C Ul_Ip_C lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_C)");
    check_field_offset(lv, v1, 0, "Ul_Ip_C.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Ip_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_C, Ul_Ip_C)
//============================================================================


struct  Ul_Ip_D  {
  __tsu64 v1;
  int *v2;
  double v3;
};
//SIG(1 Ul_Ip_D) C1{ FL Fp FL}



static void Test_Ul_Ip_D()
{
  {
    init_simple_test("Ul_Ip_D");
    STRUCT_IF_C Ul_Ip_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ip_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_D)");
    check_field_offset(lv, v1, 0, "Ul_Ip_D.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Ip_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_D, Ul_Ip_D)
//============================================================================


struct  Ul_Ip_F  {
  __tsu64 v1;
  int *v2;
  float v3;
};
//SIG(1 Ul_Ip_F) C1{ FL Fp Fi}



static void Test_Ul_Ip_F()
{
  {
    init_simple_test("Ul_Ip_F");
    STRUCT_IF_C Ul_Ip_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_F)");
    check_field_offset(lv, v1, 0, "Ul_Ip_F.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Ip_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_F, Ul_Ip_F)
//============================================================================


struct  Ul_Ip_I  {
  __tsu64 v1;
  int *v2;
  int v3;
};
//SIG(1 Ul_Ip_I) C1{ FL Fp Fi}



static void Test_Ul_Ip_I()
{
  {
    init_simple_test("Ul_Ip_I");
    STRUCT_IF_C Ul_Ip_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_I)");
    check_field_offset(lv, v1, 0, "Ul_Ip_I.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Ip_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_I, Ul_Ip_I)
//============================================================================


struct  Ul_Ip_Ip  {
  __tsu64 v1;
  int *v2;
  int *v3;
};
//SIG(1 Ul_Ip_Ip) C1{ FL Fp[2]}



static void Test_Ul_Ip_Ip()
{
  {
    init_simple_test("Ul_Ip_Ip");
    STRUCT_IF_C Ul_Ip_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_Ip)");
    check_field_offset(lv, v1, 0, "Ul_Ip_Ip.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Ip_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_Ip, Ul_Ip_Ip)
//============================================================================


struct  Ul_Ip_L  {
  __tsu64 v1;
  int *v2;
  __tsi64 v3;
};
//SIG(1 Ul_Ip_L) C1{ FL Fp FL}



static void Test_Ul_Ip_L()
{
  {
    init_simple_test("Ul_Ip_L");
    STRUCT_IF_C Ul_Ip_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ip_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_L)");
    check_field_offset(lv, v1, 0, "Ul_Ip_L.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Ip_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_L, Ul_Ip_L)
//============================================================================


struct  Ul_Ip_S  {
  __tsu64 v1;
  int *v2;
  short v3;
};
//SIG(1 Ul_Ip_S) C1{ FL Fp Fs}



static void Test_Ul_Ip_S()
{
  {
    init_simple_test("Ul_Ip_S");
    STRUCT_IF_C Ul_Ip_S lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_S)");
    check_field_offset(lv, v1, 0, "Ul_Ip_S.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Ip_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_S, Ul_Ip_S)
//============================================================================


struct  Ul_Ip_Uc  {
  __tsu64 v1;
  int *v2;
  unsigned char v3;
};
//SIG(1 Ul_Ip_Uc) C1{ FL Fp Fc}



static void Test_Ul_Ip_Uc()
{
  {
    init_simple_test("Ul_Ip_Uc");
    STRUCT_IF_C Ul_Ip_Uc lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_Uc)");
    check_field_offset(lv, v1, 0, "Ul_Ip_Uc.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Ip_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_Uc, Ul_Ip_Uc)
//============================================================================


struct  Ul_Ip_Ui  {
  __tsu64 v1;
  int *v2;
  unsigned int v3;
};
//SIG(1 Ul_Ip_Ui) C1{ FL Fp Fi}



static void Test_Ul_Ip_Ui()
{
  {
    init_simple_test("Ul_Ip_Ui");
    STRUCT_IF_C Ul_Ip_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_Ui)");
    check_field_offset(lv, v1, 0, "Ul_Ip_Ui.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Ip_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_Ui, Ul_Ip_Ui)
//============================================================================


struct  Ul_Ip_Ul  {
  __tsu64 v1;
  int *v2;
  __tsu64 v3;
};
//SIG(1 Ul_Ip_Ul) C1{ FL Fp FL}



static void Test_Ul_Ip_Ul()
{
  {
    init_simple_test("Ul_Ip_Ul");
    STRUCT_IF_C Ul_Ip_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ip_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_Ul)");
    check_field_offset(lv, v1, 0, "Ul_Ip_Ul.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Ip_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_Ul, Ul_Ip_Ul)
//============================================================================


struct  Ul_Ip_Us  {
  __tsu64 v1;
  int *v2;
  unsigned short v3;
};
//SIG(1 Ul_Ip_Us) C1{ FL Fp Fs}



static void Test_Ul_Ip_Us()
{
  {
    init_simple_test("Ul_Ip_Us");
    STRUCT_IF_C Ul_Ip_Us lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_Us)");
    check_field_offset(lv, v1, 0, "Ul_Ip_Us.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Ip_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_Us, Ul_Ip_Us)
//============================================================================


struct  Ul_Ip_Vp  {
  __tsu64 v1;
  int *v2;
  void *v3;
};
//SIG(1 Ul_Ip_Vp) C1{ FL Fp[2]}



static void Test_Ul_Ip_Vp()
{
  {
    init_simple_test("Ul_Ip_Vp");
    STRUCT_IF_C Ul_Ip_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ip_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ip_Vp)");
    check_field_offset(lv, v1, 0, "Ul_Ip_Vp.v1");
    check_field_offset(lv, v2, 8, "Ul_Ip_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Ip_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ip_Vp, Ul_Ip_Vp)
//============================================================================


struct  Ul_L  {
  __tsu64 v1;
  __tsi64 v2;
};
//SIG(1 Ul_L) C1{ FL[2]}



static void Test_Ul_L()
{
  {
    init_simple_test("Ul_L");
    STRUCT_IF_C Ul_L lv;
    check2(sizeof(lv), 16, "sizeof(Ul_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L)");
    check_field_offset(lv, v1, 0, "Ul_L.v1");
    check_field_offset(lv, v2, 8, "Ul_L.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L, Ul_L)
//============================================================================


struct  Ul_L_BFu15i  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned int v3:15;
};
//SIG(1 Ul_L_BFu15i) C1{ FL[2] Fi:15}



static void Test_Ul_L_BFu15i()
{
  {
    init_simple_test("Ul_L_BFu15i");
    static STRUCT_IF_C Ul_L_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu15i.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu15i.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "Ul_L_BFu15i");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "Ul_L_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu15i, Ul_L_BFu15i)
//============================================================================


struct  Ul_L_BFu15ll  {
  __tsu64 v1;
  __tsi64 v2;
  __tsu64 v3:15;
};
//SIG(1 Ul_L_BFu15ll) C1{ FL[2] FL:15}



static void Test_Ul_L_BFu15ll()
{
  {
    init_simple_test("Ul_L_BFu15ll");
    static STRUCT_IF_C Ul_L_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu15ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "Ul_L_BFu15ll");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "Ul_L_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu15ll, Ul_L_BFu15ll)
//============================================================================


struct  Ul_L_BFu15s  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned short v3:15;
};
//SIG(1 Ul_L_BFu15s) C1{ FL[2] Fs:15}



static void Test_Ul_L_BFu15s()
{
  {
    init_simple_test("Ul_L_BFu15s");
    static STRUCT_IF_C Ul_L_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu15s.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu15s.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "Ul_L_BFu15s");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "Ul_L_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu15s, Ul_L_BFu15s)
//============================================================================


struct  Ul_L_BFu16i  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned int v3:16;
};
//SIG(1 Ul_L_BFu16i) C1{ FL[2] Fi:16}



static void Test_Ul_L_BFu16i()
{
  {
    init_simple_test("Ul_L_BFu16i");
    static STRUCT_IF_C Ul_L_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu16i.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu16i.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "Ul_L_BFu16i");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "Ul_L_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu16i, Ul_L_BFu16i)
//============================================================================


struct  Ul_L_BFu16ll  {
  __tsu64 v1;
  __tsi64 v2;
  __tsu64 v3:16;
};
//SIG(1 Ul_L_BFu16ll) C1{ FL[2] FL:16}



static void Test_Ul_L_BFu16ll()
{
  {
    init_simple_test("Ul_L_BFu16ll");
    static STRUCT_IF_C Ul_L_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu16ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "Ul_L_BFu16ll");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "Ul_L_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu16ll, Ul_L_BFu16ll)
//============================================================================


struct  Ul_L_BFu16s  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned short v3:16;
};
//SIG(1 Ul_L_BFu16s) C1{ FL[2] Fs:16}



static void Test_Ul_L_BFu16s()
{
  {
    init_simple_test("Ul_L_BFu16s");
    static STRUCT_IF_C Ul_L_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu16s.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu16s.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "Ul_L_BFu16s");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "Ul_L_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu16s, Ul_L_BFu16s)
//============================================================================


struct  Ul_L_BFu17i  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned int v3:17;
};
//SIG(1 Ul_L_BFu17i) C1{ FL[2] Fi:17}



static void Test_Ul_L_BFu17i()
{
  {
    init_simple_test("Ul_L_BFu17i");
    static STRUCT_IF_C Ul_L_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu17i.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu17i.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "Ul_L_BFu17i");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "Ul_L_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu17i, Ul_L_BFu17i)
//============================================================================


struct  Ul_L_BFu17ll  {
  __tsu64 v1;
  __tsi64 v2;
  __tsu64 v3:17;
};
//SIG(1 Ul_L_BFu17ll) C1{ FL[2] FL:17}



static void Test_Ul_L_BFu17ll()
{
  {
    init_simple_test("Ul_L_BFu17ll");
    static STRUCT_IF_C Ul_L_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu17ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "Ul_L_BFu17ll");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "Ul_L_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu17ll, Ul_L_BFu17ll)
//============================================================================


struct  Ul_L_BFu1c  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned char v3:1;
};
//SIG(1 Ul_L_BFu1c) C1{ FL[2] Fc:1}



static void Test_Ul_L_BFu1c()
{
  {
    init_simple_test("Ul_L_BFu1c");
    static STRUCT_IF_C Ul_L_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu1c.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu1c.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "Ul_L_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu1c, Ul_L_BFu1c)
//============================================================================


struct  Ul_L_BFu1i  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned int v3:1;
};
//SIG(1 Ul_L_BFu1i) C1{ FL[2] Fi:1}



static void Test_Ul_L_BFu1i()
{
  {
    init_simple_test("Ul_L_BFu1i");
    static STRUCT_IF_C Ul_L_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu1i.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu1i.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "Ul_L_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu1i, Ul_L_BFu1i)
//============================================================================


struct  Ul_L_BFu1ll  {
  __tsu64 v1;
  __tsi64 v2;
  __tsu64 v3:1;
};
//SIG(1 Ul_L_BFu1ll) C1{ FL[2] FL:1}



static void Test_Ul_L_BFu1ll()
{
  {
    init_simple_test("Ul_L_BFu1ll");
    static STRUCT_IF_C Ul_L_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu1ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "Ul_L_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu1ll, Ul_L_BFu1ll)
//============================================================================


struct  Ul_L_BFu1s  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned short v3:1;
};
//SIG(1 Ul_L_BFu1s) C1{ FL[2] Fs:1}



static void Test_Ul_L_BFu1s()
{
  {
    init_simple_test("Ul_L_BFu1s");
    static STRUCT_IF_C Ul_L_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu1s.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu1s.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "Ul_L_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu1s, Ul_L_BFu1s)
//============================================================================


struct  Ul_L_BFu31i  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned int v3:31;
};
//SIG(1 Ul_L_BFu31i) C1{ FL[2] Fi:31}



static void Test_Ul_L_BFu31i()
{
  {
    init_simple_test("Ul_L_BFu31i");
    static STRUCT_IF_C Ul_L_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu31i.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu31i.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "Ul_L_BFu31i");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "Ul_L_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu31i, Ul_L_BFu31i)
//============================================================================


struct  Ul_L_BFu31ll  {
  __tsu64 v1;
  __tsi64 v2;
  __tsu64 v3:31;
};
//SIG(1 Ul_L_BFu31ll) C1{ FL[2] FL:31}



static void Test_Ul_L_BFu31ll()
{
  {
    init_simple_test("Ul_L_BFu31ll");
    static STRUCT_IF_C Ul_L_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu31ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "Ul_L_BFu31ll");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "Ul_L_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu31ll, Ul_L_BFu31ll)
//============================================================================


struct  Ul_L_BFu32i  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned int v3:32;
};
//SIG(1 Ul_L_BFu32i) C1{ FL[2] Fi:32}



static void Test_Ul_L_BFu32i()
{
  {
    init_simple_test("Ul_L_BFu32i");
    static STRUCT_IF_C Ul_L_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu32i.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu32i.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "Ul_L_BFu32i");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "Ul_L_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu32i, Ul_L_BFu32i)
//============================================================================


struct  Ul_L_BFu32ll  {
  __tsu64 v1;
  __tsi64 v2;
  __tsu64 v3:32;
};
//SIG(1 Ul_L_BFu32ll) C1{ FL[2] FL:32}



static void Test_Ul_L_BFu32ll()
{
  {
    init_simple_test("Ul_L_BFu32ll");
    static STRUCT_IF_C Ul_L_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu32ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "Ul_L_BFu32ll");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "Ul_L_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu32ll, Ul_L_BFu32ll)
//============================================================================


struct  Ul_L_BFu33  {
  __tsu64 v1;
  __tsi64 v2;
  __tsu64 v3:33;
};
//SIG(1 Ul_L_BFu33) C1{ FL[2] FL:33}



static void Test_Ul_L_BFu33()
{
  {
    init_simple_test("Ul_L_BFu33");
    static STRUCT_IF_C Ul_L_BFu33 lv;
    check2(sizeof(lv), 24, "sizeof(Ul_L_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu33.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu33.v2");
    set_bf_and_test(lv, v3, 16, 0, 33, 1, "Ul_L_BFu33");
    set_bf_and_test(lv, v3, 16, 0, 33, hide_ull(1LL<<32), "Ul_L_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu33, Ul_L_BFu33)
//============================================================================


struct  Ul_L_BFu7c  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned char v3:7;
};
//SIG(1 Ul_L_BFu7c) C1{ FL[2] Fc:7}



static void Test_Ul_L_BFu7c()
{
  {
    init_simple_test("Ul_L_BFu7c");
    static STRUCT_IF_C Ul_L_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu7c.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu7c.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "Ul_L_BFu7c");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "Ul_L_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu7c, Ul_L_BFu7c)
//============================================================================


struct  Ul_L_BFu7i  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned int v3:7;
};
//SIG(1 Ul_L_BFu7i) C1{ FL[2] Fi:7}



static void Test_Ul_L_BFu7i()
{
  {
    init_simple_test("Ul_L_BFu7i");
    static STRUCT_IF_C Ul_L_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu7i.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu7i.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "Ul_L_BFu7i");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "Ul_L_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu7i, Ul_L_BFu7i)
//============================================================================


struct  Ul_L_BFu7ll  {
  __tsu64 v1;
  __tsi64 v2;
  __tsu64 v3:7;
};
//SIG(1 Ul_L_BFu7ll) C1{ FL[2] FL:7}



static void Test_Ul_L_BFu7ll()
{
  {
    init_simple_test("Ul_L_BFu7ll");
    static STRUCT_IF_C Ul_L_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu7ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "Ul_L_BFu7ll");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "Ul_L_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu7ll, Ul_L_BFu7ll)
//============================================================================


struct  Ul_L_BFu7s  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned short v3:7;
};
//SIG(1 Ul_L_BFu7s) C1{ FL[2] Fs:7}



static void Test_Ul_L_BFu7s()
{
  {
    init_simple_test("Ul_L_BFu7s");
    static STRUCT_IF_C Ul_L_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu7s.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu7s.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "Ul_L_BFu7s");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "Ul_L_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu7s, Ul_L_BFu7s)
//============================================================================


struct  Ul_L_BFu8c  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned char v3:8;
};
//SIG(1 Ul_L_BFu8c) C1{ FL[2] Fc:8}



static void Test_Ul_L_BFu8c()
{
  {
    init_simple_test("Ul_L_BFu8c");
    static STRUCT_IF_C Ul_L_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu8c.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu8c.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "Ul_L_BFu8c");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "Ul_L_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu8c, Ul_L_BFu8c)
//============================================================================


struct  Ul_L_BFu8i  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned int v3:8;
};
//SIG(1 Ul_L_BFu8i) C1{ FL[2] Fi:8}



static void Test_Ul_L_BFu8i()
{
  {
    init_simple_test("Ul_L_BFu8i");
    static STRUCT_IF_C Ul_L_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu8i.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu8i.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "Ul_L_BFu8i");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "Ul_L_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu8i, Ul_L_BFu8i)
//============================================================================


struct  Ul_L_BFu8ll  {
  __tsu64 v1;
  __tsi64 v2;
  __tsu64 v3:8;
};
//SIG(1 Ul_L_BFu8ll) C1{ FL[2] FL:8}



static void Test_Ul_L_BFu8ll()
{
  {
    init_simple_test("Ul_L_BFu8ll");
    static STRUCT_IF_C Ul_L_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu8ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "Ul_L_BFu8ll");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "Ul_L_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu8ll, Ul_L_BFu8ll)
//============================================================================


struct  Ul_L_BFu8s  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned short v3:8;
};
//SIG(1 Ul_L_BFu8s) C1{ FL[2] Fs:8}



static void Test_Ul_L_BFu8s()
{
  {
    init_simple_test("Ul_L_BFu8s");
    static STRUCT_IF_C Ul_L_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu8s.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu8s.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "Ul_L_BFu8s");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "Ul_L_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu8s, Ul_L_BFu8s)
//============================================================================


struct  Ul_L_BFu9i  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned int v3:9;
};
//SIG(1 Ul_L_BFu9i) C1{ FL[2] Fi:9}



static void Test_Ul_L_BFu9i()
{
  {
    init_simple_test("Ul_L_BFu9i");
    static STRUCT_IF_C Ul_L_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu9i.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu9i.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "Ul_L_BFu9i");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "Ul_L_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu9i, Ul_L_BFu9i)
//============================================================================


struct  Ul_L_BFu9ll  {
  __tsu64 v1;
  __tsi64 v2;
  __tsu64 v3:9;
};
//SIG(1 Ul_L_BFu9ll) C1{ FL[2] FL:9}



static void Test_Ul_L_BFu9ll()
{
  {
    init_simple_test("Ul_L_BFu9ll");
    static STRUCT_IF_C Ul_L_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu9ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "Ul_L_BFu9ll");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "Ul_L_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu9ll, Ul_L_BFu9ll)
//============================================================================


struct  Ul_L_BFu9s  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned short v3:9;
};
//SIG(1 Ul_L_BFu9s) C1{ FL[2] Fs:9}



static void Test_Ul_L_BFu9s()
{
  {
    init_simple_test("Ul_L_BFu9s");
    static STRUCT_IF_C Ul_L_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_L_BFu9s.v1");
    check_field_offset(lv, v2, 8, "Ul_L_BFu9s.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "Ul_L_BFu9s");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "Ul_L_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_BFu9s, Ul_L_BFu9s)
//============================================================================


struct  Ul_L_C  {
  __tsu64 v1;
  __tsi64 v2;
  char v3;
};
//SIG(1 Ul_L_C) C1{ FL[2] Fc}



static void Test_Ul_L_C()
{
  {
    init_simple_test("Ul_L_C");
    STRUCT_IF_C Ul_L_C lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_C)");
    check_field_offset(lv, v1, 0, "Ul_L_C.v1");
    check_field_offset(lv, v2, 8, "Ul_L_C.v2");
    check_field_offset(lv, v3, 16, "Ul_L_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_C, Ul_L_C)
//============================================================================


struct  Ul_L_D  {
  __tsu64 v1;
  __tsi64 v2;
  double v3;
};
//SIG(1 Ul_L_D) C1{ FL[3]}



static void Test_Ul_L_D()
{
  {
    init_simple_test("Ul_L_D");
    STRUCT_IF_C Ul_L_D lv;
    check2(sizeof(lv), 24, "sizeof(Ul_L_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_D)");
    check_field_offset(lv, v1, 0, "Ul_L_D.v1");
    check_field_offset(lv, v2, 8, "Ul_L_D.v2");
    check_field_offset(lv, v3, 16, "Ul_L_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_D, Ul_L_D)
//============================================================================


struct  Ul_L_F  {
  __tsu64 v1;
  __tsi64 v2;
  float v3;
};
//SIG(1 Ul_L_F) C1{ FL[2] Fi}



static void Test_Ul_L_F()
{
  {
    init_simple_test("Ul_L_F");
    STRUCT_IF_C Ul_L_F lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_F)");
    check_field_offset(lv, v1, 0, "Ul_L_F.v1");
    check_field_offset(lv, v2, 8, "Ul_L_F.v2");
    check_field_offset(lv, v3, 16, "Ul_L_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_F, Ul_L_F)
//============================================================================


struct  Ul_L_I  {
  __tsu64 v1;
  __tsi64 v2;
  int v3;
};
//SIG(1 Ul_L_I) C1{ FL[2] Fi}



static void Test_Ul_L_I()
{
  {
    init_simple_test("Ul_L_I");
    STRUCT_IF_C Ul_L_I lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_I)");
    check_field_offset(lv, v1, 0, "Ul_L_I.v1");
    check_field_offset(lv, v2, 8, "Ul_L_I.v2");
    check_field_offset(lv, v3, 16, "Ul_L_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_I, Ul_L_I)
//============================================================================


struct  Ul_L_Ip  {
  __tsu64 v1;
  __tsi64 v2;
  int *v3;
};
//SIG(1 Ul_L_Ip) C1{ FL[2] Fp}



static void Test_Ul_L_Ip()
{
  {
    init_simple_test("Ul_L_Ip");
    STRUCT_IF_C Ul_L_Ip lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_Ip)");
    check_field_offset(lv, v1, 0, "Ul_L_Ip.v1");
    check_field_offset(lv, v2, 8, "Ul_L_Ip.v2");
    check_field_offset(lv, v3, 16, "Ul_L_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_Ip, Ul_L_Ip)
//============================================================================


struct  Ul_L_L  {
  __tsu64 v1;
  __tsi64 v2;
  __tsi64 v3;
};
//SIG(1 Ul_L_L) C1{ FL[3]}



static void Test_Ul_L_L()
{
  {
    init_simple_test("Ul_L_L");
    STRUCT_IF_C Ul_L_L lv;
    check2(sizeof(lv), 24, "sizeof(Ul_L_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_L)");
    check_field_offset(lv, v1, 0, "Ul_L_L.v1");
    check_field_offset(lv, v2, 8, "Ul_L_L.v2");
    check_field_offset(lv, v3, 16, "Ul_L_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_L, Ul_L_L)
//============================================================================


struct  Ul_L_S  {
  __tsu64 v1;
  __tsi64 v2;
  short v3;
};
//SIG(1 Ul_L_S) C1{ FL[2] Fs}



static void Test_Ul_L_S()
{
  {
    init_simple_test("Ul_L_S");
    STRUCT_IF_C Ul_L_S lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_S)");
    check_field_offset(lv, v1, 0, "Ul_L_S.v1");
    check_field_offset(lv, v2, 8, "Ul_L_S.v2");
    check_field_offset(lv, v3, 16, "Ul_L_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_S, Ul_L_S)
//============================================================================


struct  Ul_L_Uc  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned char v3;
};
//SIG(1 Ul_L_Uc) C1{ FL[2] Fc}



static void Test_Ul_L_Uc()
{
  {
    init_simple_test("Ul_L_Uc");
    STRUCT_IF_C Ul_L_Uc lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_Uc)");
    check_field_offset(lv, v1, 0, "Ul_L_Uc.v1");
    check_field_offset(lv, v2, 8, "Ul_L_Uc.v2");
    check_field_offset(lv, v3, 16, "Ul_L_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_Uc, Ul_L_Uc)
//============================================================================


struct  Ul_L_Ui  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned int v3;
};
//SIG(1 Ul_L_Ui) C1{ FL[2] Fi}



static void Test_Ul_L_Ui()
{
  {
    init_simple_test("Ul_L_Ui");
    STRUCT_IF_C Ul_L_Ui lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_Ui)");
    check_field_offset(lv, v1, 0, "Ul_L_Ui.v1");
    check_field_offset(lv, v2, 8, "Ul_L_Ui.v2");
    check_field_offset(lv, v3, 16, "Ul_L_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_Ui, Ul_L_Ui)
//============================================================================


struct  Ul_L_Ul  {
  __tsu64 v1;
  __tsi64 v2;
  __tsu64 v3;
};
//SIG(1 Ul_L_Ul) C1{ FL[3]}



static void Test_Ul_L_Ul()
{
  {
    init_simple_test("Ul_L_Ul");
    STRUCT_IF_C Ul_L_Ul lv;
    check2(sizeof(lv), 24, "sizeof(Ul_L_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_Ul)");
    check_field_offset(lv, v1, 0, "Ul_L_Ul.v1");
    check_field_offset(lv, v2, 8, "Ul_L_Ul.v2");
    check_field_offset(lv, v3, 16, "Ul_L_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_Ul, Ul_L_Ul)
//============================================================================


struct  Ul_L_Us  {
  __tsu64 v1;
  __tsi64 v2;
  unsigned short v3;
};
//SIG(1 Ul_L_Us) C1{ FL[2] Fs}



static void Test_Ul_L_Us()
{
  {
    init_simple_test("Ul_L_Us");
    STRUCT_IF_C Ul_L_Us lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_Us)");
    check_field_offset(lv, v1, 0, "Ul_L_Us.v1");
    check_field_offset(lv, v2, 8, "Ul_L_Us.v2");
    check_field_offset(lv, v3, 16, "Ul_L_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_Us, Ul_L_Us)
//============================================================================


struct  Ul_L_Vp  {
  __tsu64 v1;
  __tsi64 v2;
  void *v3;
};
//SIG(1 Ul_L_Vp) C1{ FL[2] Fp}



static void Test_Ul_L_Vp()
{
  {
    init_simple_test("Ul_L_Vp");
    STRUCT_IF_C Ul_L_Vp lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_L_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_L_Vp)");
    check_field_offset(lv, v1, 0, "Ul_L_Vp.v1");
    check_field_offset(lv, v2, 8, "Ul_L_Vp.v2");
    check_field_offset(lv, v3, 16, "Ul_L_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_L_Vp, Ul_L_Vp)
//============================================================================


struct  Ul_S  {
  __tsu64 v1;
  short v2;
};
//SIG(1 Ul_S) C1{ FL Fs}



static void Test_Ul_S()
{
  {
    init_simple_test("Ul_S");
    STRUCT_IF_C Ul_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S)");
    check_field_offset(lv, v1, 0, "Ul_S.v1");
    check_field_offset(lv, v2, 8, "Ul_S.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S, Ul_S)
//============================================================================


struct  Ul_S_BFu15i  {
  __tsu64 v1;
  short v2;
  unsigned int v3:15;
};
//SIG(1 Ul_S_BFu15i) C1{ FL Fs Fi:15}



static void Test_Ul_S_BFu15i()
{
  {
    init_simple_test("Ul_S_BFu15i");
    static STRUCT_IF_C Ul_S_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu15i.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu15i.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_S_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_S_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu15i, Ul_S_BFu15i)
//============================================================================


struct  Ul_S_BFu15ll  {
  __tsu64 v1;
  short v2;
  __tsu64 v3:15;
};
//SIG(1 Ul_S_BFu15ll) C1{ FL Fs FL:15}



static void Test_Ul_S_BFu15ll()
{
  {
    init_simple_test("Ul_S_BFu15ll");
    static STRUCT_IF_C Ul_S_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu15ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_S_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_S_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu15ll, Ul_S_BFu15ll)
//============================================================================


struct  Ul_S_BFu15s  {
  __tsu64 v1;
  short v2;
  unsigned short v3:15;
};
//SIG(1 Ul_S_BFu15s) C1{ FL Fs Fs:15}



static void Test_Ul_S_BFu15s()
{
  {
    init_simple_test("Ul_S_BFu15s");
    static STRUCT_IF_C Ul_S_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu15s.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_S_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_S_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu15s, Ul_S_BFu15s)
//============================================================================


struct  Ul_S_BFu16i  {
  __tsu64 v1;
  short v2;
  unsigned int v3:16;
};
//SIG(1 Ul_S_BFu16i) C1{ FL Fs Fi:16}



static void Test_Ul_S_BFu16i()
{
  {
    init_simple_test("Ul_S_BFu16i");
    static STRUCT_IF_C Ul_S_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu16i.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu16i.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_S_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_S_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu16i, Ul_S_BFu16i)
//============================================================================


struct  Ul_S_BFu16ll  {
  __tsu64 v1;
  short v2;
  __tsu64 v3:16;
};
//SIG(1 Ul_S_BFu16ll) C1{ FL Fs FL:16}



static void Test_Ul_S_BFu16ll()
{
  {
    init_simple_test("Ul_S_BFu16ll");
    static STRUCT_IF_C Ul_S_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu16ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_S_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_S_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu16ll, Ul_S_BFu16ll)
//============================================================================


struct  Ul_S_BFu16s  {
  __tsu64 v1;
  short v2;
  unsigned short v3:16;
};
//SIG(1 Ul_S_BFu16s) C1{ FL Fs Fs:16}



static void Test_Ul_S_BFu16s()
{
  {
    init_simple_test("Ul_S_BFu16s");
    static STRUCT_IF_C Ul_S_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu16s.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_S_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_S_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu16s, Ul_S_BFu16s)
//============================================================================


struct  Ul_S_BFu17i  {
  __tsu64 v1;
  short v2;
  unsigned int v3:17;
};
//SIG(1 Ul_S_BFu17i) C1{ FL Fs Fi:17}



static void Test_Ul_S_BFu17i()
{
  {
    init_simple_test("Ul_S_BFu17i");
    static STRUCT_IF_C Ul_S_BFu17i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_S_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu17i.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "Ul_S_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "Ul_S_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu17i, Ul_S_BFu17i)
//============================================================================


struct  Ul_S_BFu17ll  {
  __tsu64 v1;
  short v2;
  __tsu64 v3:17;
};
//SIG(1 Ul_S_BFu17ll) C1{ FL Fs FL:17}



static void Test_Ul_S_BFu17ll()
{
  {
    init_simple_test("Ul_S_BFu17ll");
    static STRUCT_IF_C Ul_S_BFu17ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_S_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu17ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "Ul_S_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "Ul_S_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu17ll, Ul_S_BFu17ll)
//============================================================================


struct  Ul_S_BFu1c  {
  __tsu64 v1;
  short v2;
  unsigned char v3:1;
};
//SIG(1 Ul_S_BFu1c) C1{ FL Fs Fc:1}



static void Test_Ul_S_BFu1c()
{
  {
    init_simple_test("Ul_S_BFu1c");
    static STRUCT_IF_C Ul_S_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu1c.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu1c.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_S_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu1c, Ul_S_BFu1c)
//============================================================================


struct  Ul_S_BFu1i  {
  __tsu64 v1;
  short v2;
  unsigned int v3:1;
};
//SIG(1 Ul_S_BFu1i) C1{ FL Fs Fi:1}



static void Test_Ul_S_BFu1i()
{
  {
    init_simple_test("Ul_S_BFu1i");
    static STRUCT_IF_C Ul_S_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu1i.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu1i.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_S_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu1i, Ul_S_BFu1i)
//============================================================================


struct  Ul_S_BFu1ll  {
  __tsu64 v1;
  short v2;
  __tsu64 v3:1;
};
//SIG(1 Ul_S_BFu1ll) C1{ FL Fs FL:1}



static void Test_Ul_S_BFu1ll()
{
  {
    init_simple_test("Ul_S_BFu1ll");
    static STRUCT_IF_C Ul_S_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu1ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_S_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu1ll, Ul_S_BFu1ll)
//============================================================================


struct  Ul_S_BFu1s  {
  __tsu64 v1;
  short v2;
  unsigned short v3:1;
};
//SIG(1 Ul_S_BFu1s) C1{ FL Fs Fs:1}



static void Test_Ul_S_BFu1s()
{
  {
    init_simple_test("Ul_S_BFu1s");
    static STRUCT_IF_C Ul_S_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu1s.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu1s.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_S_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu1s, Ul_S_BFu1s)
//============================================================================


struct  Ul_S_BFu31i  {
  __tsu64 v1;
  short v2;
  unsigned int v3:31;
};
//SIG(1 Ul_S_BFu31i) C1{ FL Fs Fi:31}



static void Test_Ul_S_BFu31i()
{
  {
    init_simple_test("Ul_S_BFu31i");
    static STRUCT_IF_C Ul_S_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_S_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu31i.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "Ul_S_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "Ul_S_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu31i, Ul_S_BFu31i)
//============================================================================


struct  Ul_S_BFu31ll  {
  __tsu64 v1;
  short v2;
  __tsu64 v3:31;
};
//SIG(1 Ul_S_BFu31ll) C1{ FL Fs FL:31}



static void Test_Ul_S_BFu31ll()
{
  {
    init_simple_test("Ul_S_BFu31ll");
    static STRUCT_IF_C Ul_S_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_S_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu31ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "Ul_S_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "Ul_S_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu31ll, Ul_S_BFu31ll)
//============================================================================


struct  Ul_S_BFu32i  {
  __tsu64 v1;
  short v2;
  unsigned int v3:32;
};
//SIG(1 Ul_S_BFu32i) C1{ FL Fs Fi:32}



static void Test_Ul_S_BFu32i()
{
  {
    init_simple_test("Ul_S_BFu32i");
    static STRUCT_IF_C Ul_S_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_S_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu32i.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_S_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_S_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu32i, Ul_S_BFu32i)
//============================================================================


struct  Ul_S_BFu32ll  {
  __tsu64 v1;
  short v2;
  __tsu64 v3:32;
};
//SIG(1 Ul_S_BFu32ll) C1{ FL Fs FL:32}



static void Test_Ul_S_BFu32ll()
{
  {
    init_simple_test("Ul_S_BFu32ll");
    static STRUCT_IF_C Ul_S_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_S_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu32ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "Ul_S_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "Ul_S_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu32ll, Ul_S_BFu32ll)
//============================================================================


struct  Ul_S_BFu33  {
  __tsu64 v1;
  short v2;
  __tsu64 v3:33;
};
//SIG(1 Ul_S_BFu33) C1{ FL Fs FL:33}



static void Test_Ul_S_BFu33()
{
  {
    init_simple_test("Ul_S_BFu33");
    static STRUCT_IF_C Ul_S_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Ul_S_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu33.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu33.v2");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "Ul_S_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "Ul_S_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu33, Ul_S_BFu33)
//============================================================================


struct  Ul_S_BFu7c  {
  __tsu64 v1;
  short v2;
  unsigned char v3:7;
};
//SIG(1 Ul_S_BFu7c) C1{ FL Fs Fc:7}



static void Test_Ul_S_BFu7c()
{
  {
    init_simple_test("Ul_S_BFu7c");
    static STRUCT_IF_C Ul_S_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu7c.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu7c.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_S_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_S_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu7c, Ul_S_BFu7c)
//============================================================================


struct  Ul_S_BFu7i  {
  __tsu64 v1;
  short v2;
  unsigned int v3:7;
};
//SIG(1 Ul_S_BFu7i) C1{ FL Fs Fi:7}



static void Test_Ul_S_BFu7i()
{
  {
    init_simple_test("Ul_S_BFu7i");
    static STRUCT_IF_C Ul_S_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu7i.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu7i.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_S_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_S_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu7i, Ul_S_BFu7i)
//============================================================================


struct  Ul_S_BFu7ll  {
  __tsu64 v1;
  short v2;
  __tsu64 v3:7;
};
//SIG(1 Ul_S_BFu7ll) C1{ FL Fs FL:7}



static void Test_Ul_S_BFu7ll()
{
  {
    init_simple_test("Ul_S_BFu7ll");
    static STRUCT_IF_C Ul_S_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu7ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_S_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_S_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu7ll, Ul_S_BFu7ll)
//============================================================================


struct  Ul_S_BFu7s  {
  __tsu64 v1;
  short v2;
  unsigned short v3:7;
};
//SIG(1 Ul_S_BFu7s) C1{ FL Fs Fs:7}



static void Test_Ul_S_BFu7s()
{
  {
    init_simple_test("Ul_S_BFu7s");
    static STRUCT_IF_C Ul_S_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu7s.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu7s.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_S_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_S_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu7s, Ul_S_BFu7s)
//============================================================================


struct  Ul_S_BFu8c  {
  __tsu64 v1;
  short v2;
  unsigned char v3:8;
};
//SIG(1 Ul_S_BFu8c) C1{ FL Fs Fc:8}



static void Test_Ul_S_BFu8c()
{
  {
    init_simple_test("Ul_S_BFu8c");
    static STRUCT_IF_C Ul_S_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu8c.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu8c.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_S_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_S_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu8c, Ul_S_BFu8c)
//============================================================================


struct  Ul_S_BFu8i  {
  __tsu64 v1;
  short v2;
  unsigned int v3:8;
};
//SIG(1 Ul_S_BFu8i) C1{ FL Fs Fi:8}



static void Test_Ul_S_BFu8i()
{
  {
    init_simple_test("Ul_S_BFu8i");
    static STRUCT_IF_C Ul_S_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu8i.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu8i.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_S_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_S_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu8i, Ul_S_BFu8i)
//============================================================================


struct  Ul_S_BFu8ll  {
  __tsu64 v1;
  short v2;
  __tsu64 v3:8;
};
//SIG(1 Ul_S_BFu8ll) C1{ FL Fs FL:8}



static void Test_Ul_S_BFu8ll()
{
  {
    init_simple_test("Ul_S_BFu8ll");
    static STRUCT_IF_C Ul_S_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu8ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_S_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_S_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu8ll, Ul_S_BFu8ll)
//============================================================================


struct  Ul_S_BFu8s  {
  __tsu64 v1;
  short v2;
  unsigned short v3:8;
};
//SIG(1 Ul_S_BFu8s) C1{ FL Fs Fs:8}



static void Test_Ul_S_BFu8s()
{
  {
    init_simple_test("Ul_S_BFu8s");
    static STRUCT_IF_C Ul_S_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu8s.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu8s.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_S_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_S_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu8s, Ul_S_BFu8s)
//============================================================================


struct  Ul_S_BFu9i  {
  __tsu64 v1;
  short v2;
  unsigned int v3:9;
};
//SIG(1 Ul_S_BFu9i) C1{ FL Fs Fi:9}



static void Test_Ul_S_BFu9i()
{
  {
    init_simple_test("Ul_S_BFu9i");
    static STRUCT_IF_C Ul_S_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu9i.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu9i.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_S_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_S_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu9i, Ul_S_BFu9i)
//============================================================================


struct  Ul_S_BFu9ll  {
  __tsu64 v1;
  short v2;
  __tsu64 v3:9;
};
//SIG(1 Ul_S_BFu9ll) C1{ FL Fs FL:9}



static void Test_Ul_S_BFu9ll()
{
  {
    init_simple_test("Ul_S_BFu9ll");
    static STRUCT_IF_C Ul_S_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu9ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_S_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_S_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu9ll, Ul_S_BFu9ll)
//============================================================================


struct  Ul_S_BFu9s  {
  __tsu64 v1;
  short v2;
  unsigned short v3:9;
};
//SIG(1 Ul_S_BFu9s) C1{ FL Fs Fs:9}



static void Test_Ul_S_BFu9s()
{
  {
    init_simple_test("Ul_S_BFu9s");
    static STRUCT_IF_C Ul_S_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_S_BFu9s.v1");
    check_field_offset(lv, v2, 8, "Ul_S_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_S_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_S_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_BFu9s, Ul_S_BFu9s)
//============================================================================


struct  Ul_S_C  {
  __tsu64 v1;
  short v2;
  char v3;
};
//SIG(1 Ul_S_C) C1{ FL Fs Fc}



static void Test_Ul_S_C()
{
  {
    init_simple_test("Ul_S_C");
    STRUCT_IF_C Ul_S_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_C)");
    check_field_offset(lv, v1, 0, "Ul_S_C.v1");
    check_field_offset(lv, v2, 8, "Ul_S_C.v2");
    check_field_offset(lv, v3, 10, "Ul_S_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_C, Ul_S_C)
//============================================================================


struct  Ul_S_D  {
  __tsu64 v1;
  short v2;
  double v3;
};
//SIG(1 Ul_S_D) C1{ FL Fs FL}



static void Test_Ul_S_D()
{
  {
    init_simple_test("Ul_S_D");
    STRUCT_IF_C Ul_S_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_S_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_D)");
    check_field_offset(lv, v1, 0, "Ul_S_D.v1");
    check_field_offset(lv, v2, 8, "Ul_S_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_S_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_D, Ul_S_D)
//============================================================================


struct  Ul_S_F  {
  __tsu64 v1;
  short v2;
  float v3;
};
//SIG(1 Ul_S_F) C1{ FL Fs Fi}



static void Test_Ul_S_F()
{
  {
    init_simple_test("Ul_S_F");
    STRUCT_IF_C Ul_S_F lv;
    check2(sizeof(lv), 16, "sizeof(Ul_S_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_F)");
    check_field_offset(lv, v1, 0, "Ul_S_F.v1");
    check_field_offset(lv, v2, 8, "Ul_S_F.v2");
    check_field_offset(lv, v3, 12, "Ul_S_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_F, Ul_S_F)
//============================================================================


struct  Ul_S_I  {
  __tsu64 v1;
  short v2;
  int v3;
};
//SIG(1 Ul_S_I) C1{ FL Fs Fi}



static void Test_Ul_S_I()
{
  {
    init_simple_test("Ul_S_I");
    STRUCT_IF_C Ul_S_I lv;
    check2(sizeof(lv), 16, "sizeof(Ul_S_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_I)");
    check_field_offset(lv, v1, 0, "Ul_S_I.v1");
    check_field_offset(lv, v2, 8, "Ul_S_I.v2");
    check_field_offset(lv, v3, 12, "Ul_S_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_I, Ul_S_I)
//============================================================================


struct  Ul_S_Ip  {
  __tsu64 v1;
  short v2;
  int *v3;
};
//SIG(1 Ul_S_Ip) C1{ FL Fs Fp}



static void Test_Ul_S_Ip()
{
  {
    init_simple_test("Ul_S_Ip");
    STRUCT_IF_C Ul_S_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_S_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_Ip)");
    check_field_offset(lv, v1, 0, "Ul_S_Ip.v1");
    check_field_offset(lv, v2, 8, "Ul_S_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_S_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_Ip, Ul_S_Ip)
//============================================================================


struct  Ul_S_L  {
  __tsu64 v1;
  short v2;
  __tsi64 v3;
};
//SIG(1 Ul_S_L) C1{ FL Fs FL}



static void Test_Ul_S_L()
{
  {
    init_simple_test("Ul_S_L");
    STRUCT_IF_C Ul_S_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_S_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_L)");
    check_field_offset(lv, v1, 0, "Ul_S_L.v1");
    check_field_offset(lv, v2, 8, "Ul_S_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_S_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_L, Ul_S_L)
//============================================================================


struct  Ul_S_S  {
  __tsu64 v1;
  short v2;
  short v3;
};
//SIG(1 Ul_S_S) C1{ FL Fs[2]}



static void Test_Ul_S_S()
{
  {
    init_simple_test("Ul_S_S");
    STRUCT_IF_C Ul_S_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_S)");
    check_field_offset(lv, v1, 0, "Ul_S_S.v1");
    check_field_offset(lv, v2, 8, "Ul_S_S.v2");
    check_field_offset(lv, v3, 10, "Ul_S_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_S, Ul_S_S)
//============================================================================


struct  Ul_S_Uc  {
  __tsu64 v1;
  short v2;
  unsigned char v3;
};
//SIG(1 Ul_S_Uc) C1{ FL Fs Fc}



static void Test_Ul_S_Uc()
{
  {
    init_simple_test("Ul_S_Uc");
    STRUCT_IF_C Ul_S_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_Uc)");
    check_field_offset(lv, v1, 0, "Ul_S_Uc.v1");
    check_field_offset(lv, v2, 8, "Ul_S_Uc.v2");
    check_field_offset(lv, v3, 10, "Ul_S_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_Uc, Ul_S_Uc)
//============================================================================


struct  Ul_S_Ui  {
  __tsu64 v1;
  short v2;
  unsigned int v3;
};
//SIG(1 Ul_S_Ui) C1{ FL Fs Fi}



static void Test_Ul_S_Ui()
{
  {
    init_simple_test("Ul_S_Ui");
    STRUCT_IF_C Ul_S_Ui lv;
    check2(sizeof(lv), 16, "sizeof(Ul_S_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_Ui)");
    check_field_offset(lv, v1, 0, "Ul_S_Ui.v1");
    check_field_offset(lv, v2, 8, "Ul_S_Ui.v2");
    check_field_offset(lv, v3, 12, "Ul_S_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_Ui, Ul_S_Ui)
//============================================================================


struct  Ul_S_Ul  {
  __tsu64 v1;
  short v2;
  __tsu64 v3;
};
//SIG(1 Ul_S_Ul) C1{ FL Fs FL}



static void Test_Ul_S_Ul()
{
  {
    init_simple_test("Ul_S_Ul");
    STRUCT_IF_C Ul_S_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_S_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_Ul)");
    check_field_offset(lv, v1, 0, "Ul_S_Ul.v1");
    check_field_offset(lv, v2, 8, "Ul_S_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_S_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_Ul, Ul_S_Ul)
//============================================================================


struct  Ul_S_Us  {
  __tsu64 v1;
  short v2;
  unsigned short v3;
};
//SIG(1 Ul_S_Us) C1{ FL Fs[2]}



static void Test_Ul_S_Us()
{
  {
    init_simple_test("Ul_S_Us");
    STRUCT_IF_C Ul_S_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_S_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_Us)");
    check_field_offset(lv, v1, 0, "Ul_S_Us.v1");
    check_field_offset(lv, v2, 8, "Ul_S_Us.v2");
    check_field_offset(lv, v3, 10, "Ul_S_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_Us, Ul_S_Us)
//============================================================================


struct  Ul_S_Vp  {
  __tsu64 v1;
  short v2;
  void *v3;
};
//SIG(1 Ul_S_Vp) C1{ FL Fs Fp}



static void Test_Ul_S_Vp()
{
  {
    init_simple_test("Ul_S_Vp");
    STRUCT_IF_C Ul_S_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_S_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_S_Vp)");
    check_field_offset(lv, v1, 0, "Ul_S_Vp.v1");
    check_field_offset(lv, v2, 8, "Ul_S_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_S_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_S_Vp, Ul_S_Vp)
//============================================================================


struct  Ul_Uc  {
  __tsu64 v1;
  unsigned char v2;
};
//SIG(1 Ul_Uc) C1{ FL Fc}



static void Test_Ul_Uc()
{
  {
    init_simple_test("Ul_Uc");
    STRUCT_IF_C Ul_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc)");
    check_field_offset(lv, v1, 0, "Ul_Uc.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc, Ul_Uc)
//============================================================================


struct  Ul_Uc_BFu15i  {
  __tsu64 v1;
  unsigned char v2;
  unsigned int v3:15;
};
//SIG(1 Ul_Uc_BFu15i) C1{ FL Fc Fi:15}



static void Test_Ul_Uc_BFu15i()
{
  {
    init_simple_test("Ul_Uc_BFu15i");
    static STRUCT_IF_C Ul_Uc_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu15i.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu15i.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_Uc_BFu15i");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_Uc_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu15i, Ul_Uc_BFu15i)
//============================================================================


struct  Ul_Uc_BFu15ll  {
  __tsu64 v1;
  unsigned char v2;
  __tsu64 v3:15;
};
//SIG(1 Ul_Uc_BFu15ll) C1{ FL Fc FL:15}



static void Test_Ul_Uc_BFu15ll()
{
  {
    init_simple_test("Ul_Uc_BFu15ll");
    static STRUCT_IF_C Ul_Uc_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu15ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 15, 1, "Ul_Uc_BFu15ll");
    set_bf_and_test(lv, v3, 9, 0, 15, hide_ull(1LL<<14), "Ul_Uc_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu15ll, Ul_Uc_BFu15ll)
//============================================================================


struct  Ul_Uc_BFu15s  {
  __tsu64 v1;
  unsigned char v2;
  unsigned short v3:15;
};
//SIG(1 Ul_Uc_BFu15s) C1{ FL Fc Fs:15}



static void Test_Ul_Uc_BFu15s()
{
  {
    init_simple_test("Ul_Uc_BFu15s");
    static STRUCT_IF_C Ul_Uc_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu15s.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_Uc_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_Uc_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu15s, Ul_Uc_BFu15s)
//============================================================================


struct  Ul_Uc_BFu16i  {
  __tsu64 v1;
  unsigned char v2;
  unsigned int v3:16;
};
//SIG(1 Ul_Uc_BFu16i) C1{ FL Fc Fi:16}



static void Test_Ul_Uc_BFu16i()
{
  {
    init_simple_test("Ul_Uc_BFu16i");
    static STRUCT_IF_C Ul_Uc_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu16i.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu16i.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_Uc_BFu16i");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_Uc_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu16i, Ul_Uc_BFu16i)
//============================================================================


struct  Ul_Uc_BFu16ll  {
  __tsu64 v1;
  unsigned char v2;
  __tsu64 v3:16;
};
//SIG(1 Ul_Uc_BFu16ll) C1{ FL Fc FL:16}



static void Test_Ul_Uc_BFu16ll()
{
  {
    init_simple_test("Ul_Uc_BFu16ll");
    static STRUCT_IF_C Ul_Uc_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu16ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 16, 1, "Ul_Uc_BFu16ll");
    set_bf_and_test(lv, v3, 9, 0, 16, hide_ull(1LL<<15), "Ul_Uc_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu16ll, Ul_Uc_BFu16ll)
//============================================================================


struct  Ul_Uc_BFu16s  {
  __tsu64 v1;
  unsigned char v2;
  unsigned short v3:16;
};
//SIG(1 Ul_Uc_BFu16s) C1{ FL Fc Fs:16}



static void Test_Ul_Uc_BFu16s()
{
  {
    init_simple_test("Ul_Uc_BFu16s");
    static STRUCT_IF_C Ul_Uc_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu16s.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_Uc_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_Uc_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu16s, Ul_Uc_BFu16s)
//============================================================================


struct  Ul_Uc_BFu17i  {
  __tsu64 v1;
  unsigned char v2;
  unsigned int v3:17;
};
//SIG(1 Ul_Uc_BFu17i) C1{ FL Fc Fi:17}



static void Test_Ul_Uc_BFu17i()
{
  {
    init_simple_test("Ul_Uc_BFu17i");
    static STRUCT_IF_C Ul_Uc_BFu17i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu17i.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu17i.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Ul_Uc_BFu17i");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Ul_Uc_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu17i, Ul_Uc_BFu17i)
//============================================================================


struct  Ul_Uc_BFu17ll  {
  __tsu64 v1;
  unsigned char v2;
  __tsu64 v3:17;
};
//SIG(1 Ul_Uc_BFu17ll) C1{ FL Fc FL:17}



static void Test_Ul_Uc_BFu17ll()
{
  {
    init_simple_test("Ul_Uc_BFu17ll");
    static STRUCT_IF_C Ul_Uc_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu17ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 17, 1, "Ul_Uc_BFu17ll");
    set_bf_and_test(lv, v3, 9, 0, 17, hide_ull(1LL<<16), "Ul_Uc_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu17ll, Ul_Uc_BFu17ll)
//============================================================================


struct  Ul_Uc_BFu1c  {
  __tsu64 v1;
  unsigned char v2;
  unsigned char v3:1;
};
//SIG(1 Ul_Uc_BFu1c) C1{ FL Fc Fc:1}



static void Test_Ul_Uc_BFu1c()
{
  {
    init_simple_test("Ul_Uc_BFu1c");
    static STRUCT_IF_C Ul_Uc_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu1c.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu1c.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_Uc_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu1c, Ul_Uc_BFu1c)
//============================================================================


struct  Ul_Uc_BFu1i  {
  __tsu64 v1;
  unsigned char v2;
  unsigned int v3:1;
};
//SIG(1 Ul_Uc_BFu1i) C1{ FL Fc Fi:1}



static void Test_Ul_Uc_BFu1i()
{
  {
    init_simple_test("Ul_Uc_BFu1i");
    static STRUCT_IF_C Ul_Uc_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu1i.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu1i.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_Uc_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu1i, Ul_Uc_BFu1i)
//============================================================================


struct  Ul_Uc_BFu1ll  {
  __tsu64 v1;
  unsigned char v2;
  __tsu64 v3:1;
};
//SIG(1 Ul_Uc_BFu1ll) C1{ FL Fc FL:1}



static void Test_Ul_Uc_BFu1ll()
{
  {
    init_simple_test("Ul_Uc_BFu1ll");
    static STRUCT_IF_C Ul_Uc_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu1ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_Uc_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu1ll, Ul_Uc_BFu1ll)
//============================================================================


struct  Ul_Uc_BFu1s  {
  __tsu64 v1;
  unsigned char v2;
  unsigned short v3:1;
};
//SIG(1 Ul_Uc_BFu1s) C1{ FL Fc Fs:1}



static void Test_Ul_Uc_BFu1s()
{
  {
    init_simple_test("Ul_Uc_BFu1s");
    static STRUCT_IF_C Ul_Uc_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu1s.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu1s.v2");
    set_bf_and_test(lv, v3, 9, 0, 1, 1, "Ul_Uc_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu1s, Ul_Uc_BFu1s)
//============================================================================


struct  Ul_Uc_BFu31i  {
  __tsu64 v1;
  unsigned char v2;
  unsigned int v3:31;
};
//SIG(1 Ul_Uc_BFu31i) C1{ FL Fc Fi:31}



static void Test_Ul_Uc_BFu31i()
{
  {
    init_simple_test("Ul_Uc_BFu31i");
    static STRUCT_IF_C Ul_Uc_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Uc_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu31i.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "Ul_Uc_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "Ul_Uc_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu31i, Ul_Uc_BFu31i)
//============================================================================


struct  Ul_Uc_BFu31ll  {
  __tsu64 v1;
  unsigned char v2;
  __tsu64 v3:31;
};
//SIG(1 Ul_Uc_BFu31ll) C1{ FL Fc FL:31}



static void Test_Ul_Uc_BFu31ll()
{
  {
    init_simple_test("Ul_Uc_BFu31ll");
    static STRUCT_IF_C Ul_Uc_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Uc_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu31ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 31, 1, "Ul_Uc_BFu31ll");
    set_bf_and_test(lv, v3, 9, 0, 31, hide_ull(1LL<<30), "Ul_Uc_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu31ll, Ul_Uc_BFu31ll)
//============================================================================


struct  Ul_Uc_BFu32i  {
  __tsu64 v1;
  unsigned char v2;
  unsigned int v3:32;
};
//SIG(1 Ul_Uc_BFu32i) C1{ FL Fc Fi:32}



static void Test_Ul_Uc_BFu32i()
{
  {
    init_simple_test("Ul_Uc_BFu32i");
    static STRUCT_IF_C Ul_Uc_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Uc_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu32i.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_Uc_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_Uc_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu32i, Ul_Uc_BFu32i)
//============================================================================


struct  Ul_Uc_BFu32ll  {
  __tsu64 v1;
  unsigned char v2;
  __tsu64 v3:32;
};
//SIG(1 Ul_Uc_BFu32ll) C1{ FL Fc FL:32}



static void Test_Ul_Uc_BFu32ll()
{
  {
    init_simple_test("Ul_Uc_BFu32ll");
    static STRUCT_IF_C Ul_Uc_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Uc_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu32ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 32, 1, "Ul_Uc_BFu32ll");
    set_bf_and_test(lv, v3, 9, 0, 32, hide_ull(1LL<<31), "Ul_Uc_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu32ll, Ul_Uc_BFu32ll)
//============================================================================


struct  Ul_Uc_BFu33  {
  __tsu64 v1;
  unsigned char v2;
  __tsu64 v3:33;
};
//SIG(1 Ul_Uc_BFu33) C1{ FL Fc FL:33}



static void Test_Ul_Uc_BFu33()
{
  {
    init_simple_test("Ul_Uc_BFu33");
    static STRUCT_IF_C Ul_Uc_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Uc_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu33.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu33.v2");
    set_bf_and_test(lv, v3, 9, 0, 33, 1, "Ul_Uc_BFu33");
    set_bf_and_test(lv, v3, 9, 0, 33, hide_ull(1LL<<32), "Ul_Uc_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu33, Ul_Uc_BFu33)
//============================================================================


struct  Ul_Uc_BFu7c  {
  __tsu64 v1;
  unsigned char v2;
  unsigned char v3:7;
};
//SIG(1 Ul_Uc_BFu7c) C1{ FL Fc Fc:7}



static void Test_Ul_Uc_BFu7c()
{
  {
    init_simple_test("Ul_Uc_BFu7c");
    static STRUCT_IF_C Ul_Uc_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu7c.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu7c.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_Uc_BFu7c");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_Uc_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu7c, Ul_Uc_BFu7c)
//============================================================================


struct  Ul_Uc_BFu7i  {
  __tsu64 v1;
  unsigned char v2;
  unsigned int v3:7;
};
//SIG(1 Ul_Uc_BFu7i) C1{ FL Fc Fi:7}



static void Test_Ul_Uc_BFu7i()
{
  {
    init_simple_test("Ul_Uc_BFu7i");
    static STRUCT_IF_C Ul_Uc_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu7i.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu7i.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_Uc_BFu7i");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_Uc_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu7i, Ul_Uc_BFu7i)
//============================================================================


struct  Ul_Uc_BFu7ll  {
  __tsu64 v1;
  unsigned char v2;
  __tsu64 v3:7;
};
//SIG(1 Ul_Uc_BFu7ll) C1{ FL Fc FL:7}



static void Test_Ul_Uc_BFu7ll()
{
  {
    init_simple_test("Ul_Uc_BFu7ll");
    static STRUCT_IF_C Ul_Uc_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu7ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_Uc_BFu7ll");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_Uc_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu7ll, Ul_Uc_BFu7ll)
//============================================================================


struct  Ul_Uc_BFu7s  {
  __tsu64 v1;
  unsigned char v2;
  unsigned short v3:7;
};
//SIG(1 Ul_Uc_BFu7s) C1{ FL Fc Fs:7}



static void Test_Ul_Uc_BFu7s()
{
  {
    init_simple_test("Ul_Uc_BFu7s");
    static STRUCT_IF_C Ul_Uc_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu7s.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu7s.v2");
    set_bf_and_test(lv, v3, 9, 0, 7, 1, "Ul_Uc_BFu7s");
    set_bf_and_test(lv, v3, 9, 0, 7, hide_ull(1LL<<6), "Ul_Uc_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu7s, Ul_Uc_BFu7s)
//============================================================================


struct  Ul_Uc_BFu8c  {
  __tsu64 v1;
  unsigned char v2;
  unsigned char v3:8;
};
//SIG(1 Ul_Uc_BFu8c) C1{ FL Fc Fc:8}



static void Test_Ul_Uc_BFu8c()
{
  {
    init_simple_test("Ul_Uc_BFu8c");
    static STRUCT_IF_C Ul_Uc_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu8c.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu8c.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_Uc_BFu8c");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_Uc_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu8c, Ul_Uc_BFu8c)
//============================================================================


struct  Ul_Uc_BFu8i  {
  __tsu64 v1;
  unsigned char v2;
  unsigned int v3:8;
};
//SIG(1 Ul_Uc_BFu8i) C1{ FL Fc Fi:8}



static void Test_Ul_Uc_BFu8i()
{
  {
    init_simple_test("Ul_Uc_BFu8i");
    static STRUCT_IF_C Ul_Uc_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu8i.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu8i.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_Uc_BFu8i");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_Uc_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu8i, Ul_Uc_BFu8i)
//============================================================================


struct  Ul_Uc_BFu8ll  {
  __tsu64 v1;
  unsigned char v2;
  __tsu64 v3:8;
};
//SIG(1 Ul_Uc_BFu8ll) C1{ FL Fc FL:8}



static void Test_Ul_Uc_BFu8ll()
{
  {
    init_simple_test("Ul_Uc_BFu8ll");
    static STRUCT_IF_C Ul_Uc_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu8ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_Uc_BFu8ll");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_Uc_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu8ll, Ul_Uc_BFu8ll)
//============================================================================


struct  Ul_Uc_BFu8s  {
  __tsu64 v1;
  unsigned char v2;
  unsigned short v3:8;
};
//SIG(1 Ul_Uc_BFu8s) C1{ FL Fc Fs:8}



static void Test_Ul_Uc_BFu8s()
{
  {
    init_simple_test("Ul_Uc_BFu8s");
    static STRUCT_IF_C Ul_Uc_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu8s.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu8s.v2");
    set_bf_and_test(lv, v3, 9, 0, 8, 1, "Ul_Uc_BFu8s");
    set_bf_and_test(lv, v3, 9, 0, 8, hide_ull(1LL<<7), "Ul_Uc_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu8s, Ul_Uc_BFu8s)
//============================================================================


struct  Ul_Uc_BFu9i  {
  __tsu64 v1;
  unsigned char v2;
  unsigned int v3:9;
};
//SIG(1 Ul_Uc_BFu9i) C1{ FL Fc Fi:9}



static void Test_Ul_Uc_BFu9i()
{
  {
    init_simple_test("Ul_Uc_BFu9i");
    static STRUCT_IF_C Ul_Uc_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu9i.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu9i.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_Uc_BFu9i");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_Uc_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu9i, Ul_Uc_BFu9i)
//============================================================================


struct  Ul_Uc_BFu9ll  {
  __tsu64 v1;
  unsigned char v2;
  __tsu64 v3:9;
};
//SIG(1 Ul_Uc_BFu9ll) C1{ FL Fc FL:9}



static void Test_Ul_Uc_BFu9ll()
{
  {
    init_simple_test("Ul_Uc_BFu9ll");
    static STRUCT_IF_C Ul_Uc_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu9ll.v2");
    set_bf_and_test(lv, v3, 9, 0, 9, 1, "Ul_Uc_BFu9ll");
    set_bf_and_test(lv, v3, 9, 0, 9, hide_ull(1LL<<8), "Ul_Uc_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu9ll, Ul_Uc_BFu9ll)
//============================================================================


struct  Ul_Uc_BFu9s  {
  __tsu64 v1;
  unsigned char v2;
  unsigned short v3:9;
};
//SIG(1 Ul_Uc_BFu9s) C1{ FL Fc Fs:9}



static void Test_Ul_Uc_BFu9s()
{
  {
    init_simple_test("Ul_Uc_BFu9s");
    static STRUCT_IF_C Ul_Uc_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_Uc_BFu9s.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_Uc_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_Uc_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_BFu9s, Ul_Uc_BFu9s)
//============================================================================


struct  Ul_Uc_C  {
  __tsu64 v1;
  unsigned char v2;
  char v3;
};
//SIG(1 Ul_Uc_C) C1{ FL Fc[2]}



static void Test_Ul_Uc_C()
{
  {
    init_simple_test("Ul_Uc_C");
    STRUCT_IF_C Ul_Uc_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_C)");
    check_field_offset(lv, v1, 0, "Ul_Uc_C.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_C.v2");
    check_field_offset(lv, v3, 9, "Ul_Uc_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_C, Ul_Uc_C)
//============================================================================


struct  Ul_Uc_D  {
  __tsu64 v1;
  unsigned char v2;
  double v3;
};
//SIG(1 Ul_Uc_D) C1{ FL Fc FL}



static void Test_Ul_Uc_D()
{
  {
    init_simple_test("Ul_Uc_D");
    STRUCT_IF_C Ul_Uc_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Uc_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_D)");
    check_field_offset(lv, v1, 0, "Ul_Uc_D.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Uc_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_D, Ul_Uc_D)
//============================================================================


struct  Ul_Uc_F  {
  __tsu64 v1;
  unsigned char v2;
  float v3;
};
//SIG(1 Ul_Uc_F) C1{ FL Fc Fi}



static void Test_Ul_Uc_F()
{
  {
    init_simple_test("Ul_Uc_F");
    STRUCT_IF_C Ul_Uc_F lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Uc_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_F)");
    check_field_offset(lv, v1, 0, "Ul_Uc_F.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_F.v2");
    check_field_offset(lv, v3, 12, "Ul_Uc_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_F, Ul_Uc_F)
//============================================================================


struct  Ul_Uc_I  {
  __tsu64 v1;
  unsigned char v2;
  int v3;
};
//SIG(1 Ul_Uc_I) C1{ FL Fc Fi}



static void Test_Ul_Uc_I()
{
  {
    init_simple_test("Ul_Uc_I");
    STRUCT_IF_C Ul_Uc_I lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Uc_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_I)");
    check_field_offset(lv, v1, 0, "Ul_Uc_I.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_I.v2");
    check_field_offset(lv, v3, 12, "Ul_Uc_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_I, Ul_Uc_I)
//============================================================================


struct  Ul_Uc_Ip  {
  __tsu64 v1;
  unsigned char v2;
  int *v3;
};
//SIG(1 Ul_Uc_Ip) C1{ FL Fc Fp}



static void Test_Ul_Uc_Ip()
{
  {
    init_simple_test("Ul_Uc_Ip");
    STRUCT_IF_C Ul_Uc_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Uc_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_Ip)");
    check_field_offset(lv, v1, 0, "Ul_Uc_Ip.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Uc_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_Ip, Ul_Uc_Ip)
//============================================================================


struct  Ul_Uc_L  {
  __tsu64 v1;
  unsigned char v2;
  __tsi64 v3;
};
//SIG(1 Ul_Uc_L) C1{ FL Fc FL}



static void Test_Ul_Uc_L()
{
  {
    init_simple_test("Ul_Uc_L");
    STRUCT_IF_C Ul_Uc_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Uc_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_L)");
    check_field_offset(lv, v1, 0, "Ul_Uc_L.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Uc_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_L, Ul_Uc_L)
//============================================================================


struct  Ul_Uc_S  {
  __tsu64 v1;
  unsigned char v2;
  short v3;
};
//SIG(1 Ul_Uc_S) C1{ FL Fc Fs}



static void Test_Ul_Uc_S()
{
  {
    init_simple_test("Ul_Uc_S");
    STRUCT_IF_C Ul_Uc_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_S)");
    check_field_offset(lv, v1, 0, "Ul_Uc_S.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_S.v2");
    check_field_offset(lv, v3, 10, "Ul_Uc_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_S, Ul_Uc_S)
//============================================================================


struct  Ul_Uc_Uc  {
  __tsu64 v1;
  unsigned char v2;
  unsigned char v3;
};
//SIG(1 Ul_Uc_Uc) C1{ FL Fc[2]}



static void Test_Ul_Uc_Uc()
{
  {
    init_simple_test("Ul_Uc_Uc");
    STRUCT_IF_C Ul_Uc_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_Uc)");
    check_field_offset(lv, v1, 0, "Ul_Uc_Uc.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_Uc.v2");
    check_field_offset(lv, v3, 9, "Ul_Uc_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_Uc, Ul_Uc_Uc)
//============================================================================


struct  Ul_Uc_Ui  {
  __tsu64 v1;
  unsigned char v2;
  unsigned int v3;
};
//SIG(1 Ul_Uc_Ui) C1{ FL Fc Fi}



static void Test_Ul_Uc_Ui()
{
  {
    init_simple_test("Ul_Uc_Ui");
    STRUCT_IF_C Ul_Uc_Ui lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Uc_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_Ui)");
    check_field_offset(lv, v1, 0, "Ul_Uc_Ui.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_Ui.v2");
    check_field_offset(lv, v3, 12, "Ul_Uc_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_Ui, Ul_Uc_Ui)
//============================================================================


struct  Ul_Uc_Ul  {
  __tsu64 v1;
  unsigned char v2;
  __tsu64 v3;
};
//SIG(1 Ul_Uc_Ul) C1{ FL Fc FL}



static void Test_Ul_Uc_Ul()
{
  {
    init_simple_test("Ul_Uc_Ul");
    STRUCT_IF_C Ul_Uc_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Uc_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_Ul)");
    check_field_offset(lv, v1, 0, "Ul_Uc_Ul.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Uc_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_Ul, Ul_Uc_Ul)
//============================================================================


struct  Ul_Uc_Us  {
  __tsu64 v1;
  unsigned char v2;
  unsigned short v3;
};
//SIG(1 Ul_Uc_Us) C1{ FL Fc Fs}



static void Test_Ul_Uc_Us()
{
  {
    init_simple_test("Ul_Uc_Us");
    STRUCT_IF_C Ul_Uc_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Uc_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_Us)");
    check_field_offset(lv, v1, 0, "Ul_Uc_Us.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_Us.v2");
    check_field_offset(lv, v3, 10, "Ul_Uc_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_Us, Ul_Uc_Us)
//============================================================================


struct  Ul_Uc_Vp  {
  __tsu64 v1;
  unsigned char v2;
  void *v3;
};
//SIG(1 Ul_Uc_Vp) C1{ FL Fc Fp}



static void Test_Ul_Uc_Vp()
{
  {
    init_simple_test("Ul_Uc_Vp");
    STRUCT_IF_C Ul_Uc_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Uc_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Uc_Vp)");
    check_field_offset(lv, v1, 0, "Ul_Uc_Vp.v1");
    check_field_offset(lv, v2, 8, "Ul_Uc_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Uc_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Uc_Vp, Ul_Uc_Vp)
//============================================================================


struct  Ul_Ui  {
  __tsu64 v1;
  unsigned int v2;
};
//SIG(1 Ul_Ui) C1{ FL Fi}



static void Test_Ul_Ui()
{
  {
    init_simple_test("Ul_Ui");
    STRUCT_IF_C Ul_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui)");
    check_field_offset(lv, v1, 0, "Ul_Ui.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui, Ul_Ui)
//============================================================================


struct  Ul_Ui_BFu15i  {
  __tsu64 v1;
  unsigned int v2;
  unsigned int v3:15;
};
//SIG(1 Ul_Ui_BFu15i) C1{ FL Fi Fi:15}



static void Test_Ul_Ui_BFu15i()
{
  {
    init_simple_test("Ul_Ui_BFu15i");
    static STRUCT_IF_C Ul_Ui_BFu15i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu15i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu15i.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "Ul_Ui_BFu15i");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "Ul_Ui_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu15i, Ul_Ui_BFu15i)
//============================================================================


struct  Ul_Ui_BFu15ll  {
  __tsu64 v1;
  unsigned int v2;
  __tsu64 v3:15;
};
//SIG(1 Ul_Ui_BFu15ll) C1{ FL Fi FL:15}



static void Test_Ul_Ui_BFu15ll()
{
  {
    init_simple_test("Ul_Ui_BFu15ll");
    static STRUCT_IF_C Ul_Ui_BFu15ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu15ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "Ul_Ui_BFu15ll");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "Ul_Ui_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu15ll, Ul_Ui_BFu15ll)
//============================================================================


struct  Ul_Ui_BFu15s  {
  __tsu64 v1;
  unsigned int v2;
  unsigned short v3:15;
};
//SIG(1 Ul_Ui_BFu15s) C1{ FL Fi Fs:15}



static void Test_Ul_Ui_BFu15s()
{
  {
    init_simple_test("Ul_Ui_BFu15s");
    static STRUCT_IF_C Ul_Ui_BFu15s lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu15s.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu15s.v2");
    set_bf_and_test(lv, v3, 12, 0, 15, 1, "Ul_Ui_BFu15s");
    set_bf_and_test(lv, v3, 12, 0, 15, hide_ull(1LL<<14), "Ul_Ui_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu15s, Ul_Ui_BFu15s)
//============================================================================


struct  Ul_Ui_BFu16i  {
  __tsu64 v1;
  unsigned int v2;
  unsigned int v3:16;
};
//SIG(1 Ul_Ui_BFu16i) C1{ FL Fi Fi:16}



static void Test_Ul_Ui_BFu16i()
{
  {
    init_simple_test("Ul_Ui_BFu16i");
    static STRUCT_IF_C Ul_Ui_BFu16i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu16i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu16i.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "Ul_Ui_BFu16i");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "Ul_Ui_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu16i, Ul_Ui_BFu16i)
//============================================================================


struct  Ul_Ui_BFu16ll  {
  __tsu64 v1;
  unsigned int v2;
  __tsu64 v3:16;
};
//SIG(1 Ul_Ui_BFu16ll) C1{ FL Fi FL:16}



static void Test_Ul_Ui_BFu16ll()
{
  {
    init_simple_test("Ul_Ui_BFu16ll");
    static STRUCT_IF_C Ul_Ui_BFu16ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu16ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "Ul_Ui_BFu16ll");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "Ul_Ui_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu16ll, Ul_Ui_BFu16ll)
//============================================================================


struct  Ul_Ui_BFu16s  {
  __tsu64 v1;
  unsigned int v2;
  unsigned short v3:16;
};
//SIG(1 Ul_Ui_BFu16s) C1{ FL Fi Fs:16}



static void Test_Ul_Ui_BFu16s()
{
  {
    init_simple_test("Ul_Ui_BFu16s");
    static STRUCT_IF_C Ul_Ui_BFu16s lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu16s.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu16s.v2");
    set_bf_and_test(lv, v3, 12, 0, 16, 1, "Ul_Ui_BFu16s");
    set_bf_and_test(lv, v3, 12, 0, 16, hide_ull(1LL<<15), "Ul_Ui_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu16s, Ul_Ui_BFu16s)
//============================================================================


struct  Ul_Ui_BFu17i  {
  __tsu64 v1;
  unsigned int v2;
  unsigned int v3:17;
};
//SIG(1 Ul_Ui_BFu17i) C1{ FL Fi Fi:17}



static void Test_Ul_Ui_BFu17i()
{
  {
    init_simple_test("Ul_Ui_BFu17i");
    static STRUCT_IF_C Ul_Ui_BFu17i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu17i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "Ul_Ui_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "Ul_Ui_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu17i, Ul_Ui_BFu17i)
//============================================================================


struct  Ul_Ui_BFu17ll  {
  __tsu64 v1;
  unsigned int v2;
  __tsu64 v3:17;
};
//SIG(1 Ul_Ui_BFu17ll) C1{ FL Fi FL:17}



static void Test_Ul_Ui_BFu17ll()
{
  {
    init_simple_test("Ul_Ui_BFu17ll");
    static STRUCT_IF_C Ul_Ui_BFu17ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu17ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "Ul_Ui_BFu17ll");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "Ul_Ui_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu17ll, Ul_Ui_BFu17ll)
//============================================================================


struct  Ul_Ui_BFu1c  {
  __tsu64 v1;
  unsigned int v2;
  unsigned char v3:1;
};
//SIG(1 Ul_Ui_BFu1c) C1{ FL Fi Fc:1}



static void Test_Ul_Ui_BFu1c()
{
  {
    init_simple_test("Ul_Ui_BFu1c");
    static STRUCT_IF_C Ul_Ui_BFu1c lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu1c.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu1c.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_Ui_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu1c, Ul_Ui_BFu1c)
//============================================================================


struct  Ul_Ui_BFu1i  {
  __tsu64 v1;
  unsigned int v2;
  unsigned int v3:1;
};
//SIG(1 Ul_Ui_BFu1i) C1{ FL Fi Fi:1}



static void Test_Ul_Ui_BFu1i()
{
  {
    init_simple_test("Ul_Ui_BFu1i");
    static STRUCT_IF_C Ul_Ui_BFu1i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu1i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu1i.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_Ui_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu1i, Ul_Ui_BFu1i)
//============================================================================


struct  Ul_Ui_BFu1ll  {
  __tsu64 v1;
  unsigned int v2;
  __tsu64 v3:1;
};
//SIG(1 Ul_Ui_BFu1ll) C1{ FL Fi FL:1}



static void Test_Ul_Ui_BFu1ll()
{
  {
    init_simple_test("Ul_Ui_BFu1ll");
    static STRUCT_IF_C Ul_Ui_BFu1ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu1ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_Ui_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu1ll, Ul_Ui_BFu1ll)
//============================================================================


struct  Ul_Ui_BFu1s  {
  __tsu64 v1;
  unsigned int v2;
  unsigned short v3:1;
};
//SIG(1 Ul_Ui_BFu1s) C1{ FL Fi Fs:1}



static void Test_Ul_Ui_BFu1s()
{
  {
    init_simple_test("Ul_Ui_BFu1s");
    static STRUCT_IF_C Ul_Ui_BFu1s lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu1s.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu1s.v2");
    set_bf_and_test(lv, v3, 12, 0, 1, 1, "Ul_Ui_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu1s, Ul_Ui_BFu1s)
//============================================================================


struct  Ul_Ui_BFu31i  {
  __tsu64 v1;
  unsigned int v2;
  unsigned int v3:31;
};
//SIG(1 Ul_Ui_BFu31i) C1{ FL Fi Fi:31}



static void Test_Ul_Ui_BFu31i()
{
  {
    init_simple_test("Ul_Ui_BFu31i");
    static STRUCT_IF_C Ul_Ui_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu31i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "Ul_Ui_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "Ul_Ui_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu31i, Ul_Ui_BFu31i)
//============================================================================


struct  Ul_Ui_BFu31ll  {
  __tsu64 v1;
  unsigned int v2;
  __tsu64 v3:31;
};
//SIG(1 Ul_Ui_BFu31ll) C1{ FL Fi FL:31}



static void Test_Ul_Ui_BFu31ll()
{
  {
    init_simple_test("Ul_Ui_BFu31ll");
    static STRUCT_IF_C Ul_Ui_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu31ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "Ul_Ui_BFu31ll");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "Ul_Ui_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu31ll, Ul_Ui_BFu31ll)
//============================================================================


struct  Ul_Ui_BFu32i  {
  __tsu64 v1;
  unsigned int v2;
  unsigned int v3:32;
};
//SIG(1 Ul_Ui_BFu32i) C1{ FL Fi Fi:32}



static void Test_Ul_Ui_BFu32i()
{
  {
    init_simple_test("Ul_Ui_BFu32i");
    static STRUCT_IF_C Ul_Ui_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu32i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_Ui_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_Ui_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu32i, Ul_Ui_BFu32i)
//============================================================================


struct  Ul_Ui_BFu32ll  {
  __tsu64 v1;
  unsigned int v2;
  __tsu64 v3:32;
};
//SIG(1 Ul_Ui_BFu32ll) C1{ FL Fi FL:32}



static void Test_Ul_Ui_BFu32ll()
{
  {
    init_simple_test("Ul_Ui_BFu32ll");
    static STRUCT_IF_C Ul_Ui_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu32ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_Ui_BFu32ll");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_Ui_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu32ll, Ul_Ui_BFu32ll)
//============================================================================


struct  Ul_Ui_BFu33  {
  __tsu64 v1;
  unsigned int v2;
  __tsu64 v3:33;
};
//SIG(1 Ul_Ui_BFu33) C1{ FL Fi FL:33}



static void Test_Ul_Ui_BFu33()
{
  {
    init_simple_test("Ul_Ui_BFu33");
    static STRUCT_IF_C Ul_Ui_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ui_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu33.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "Ul_Ui_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "Ul_Ui_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu33, Ul_Ui_BFu33)
//============================================================================


struct  Ul_Ui_BFu7c  {
  __tsu64 v1;
  unsigned int v2;
  unsigned char v3:7;
};
//SIG(1 Ul_Ui_BFu7c) C1{ FL Fi Fc:7}



static void Test_Ul_Ui_BFu7c()
{
  {
    init_simple_test("Ul_Ui_BFu7c");
    static STRUCT_IF_C Ul_Ui_BFu7c lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu7c.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu7c.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_Ui_BFu7c");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_Ui_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu7c, Ul_Ui_BFu7c)
//============================================================================


struct  Ul_Ui_BFu7i  {
  __tsu64 v1;
  unsigned int v2;
  unsigned int v3:7;
};
//SIG(1 Ul_Ui_BFu7i) C1{ FL Fi Fi:7}



static void Test_Ul_Ui_BFu7i()
{
  {
    init_simple_test("Ul_Ui_BFu7i");
    static STRUCT_IF_C Ul_Ui_BFu7i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu7i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu7i.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_Ui_BFu7i");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_Ui_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu7i, Ul_Ui_BFu7i)
//============================================================================


struct  Ul_Ui_BFu7ll  {
  __tsu64 v1;
  unsigned int v2;
  __tsu64 v3:7;
};
//SIG(1 Ul_Ui_BFu7ll) C1{ FL Fi FL:7}



static void Test_Ul_Ui_BFu7ll()
{
  {
    init_simple_test("Ul_Ui_BFu7ll");
    static STRUCT_IF_C Ul_Ui_BFu7ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu7ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_Ui_BFu7ll");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_Ui_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu7ll, Ul_Ui_BFu7ll)
//============================================================================


struct  Ul_Ui_BFu7s  {
  __tsu64 v1;
  unsigned int v2;
  unsigned short v3:7;
};
//SIG(1 Ul_Ui_BFu7s) C1{ FL Fi Fs:7}



static void Test_Ul_Ui_BFu7s()
{
  {
    init_simple_test("Ul_Ui_BFu7s");
    static STRUCT_IF_C Ul_Ui_BFu7s lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu7s.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu7s.v2");
    set_bf_and_test(lv, v3, 12, 0, 7, 1, "Ul_Ui_BFu7s");
    set_bf_and_test(lv, v3, 12, 0, 7, hide_ull(1LL<<6), "Ul_Ui_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu7s, Ul_Ui_BFu7s)
//============================================================================


struct  Ul_Ui_BFu8c  {
  __tsu64 v1;
  unsigned int v2;
  unsigned char v3:8;
};
//SIG(1 Ul_Ui_BFu8c) C1{ FL Fi Fc:8}



static void Test_Ul_Ui_BFu8c()
{
  {
    init_simple_test("Ul_Ui_BFu8c");
    static STRUCT_IF_C Ul_Ui_BFu8c lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu8c.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu8c.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_Ui_BFu8c");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_Ui_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu8c, Ul_Ui_BFu8c)
//============================================================================


struct  Ul_Ui_BFu8i  {
  __tsu64 v1;
  unsigned int v2;
  unsigned int v3:8;
};
//SIG(1 Ul_Ui_BFu8i) C1{ FL Fi Fi:8}



static void Test_Ul_Ui_BFu8i()
{
  {
    init_simple_test("Ul_Ui_BFu8i");
    static STRUCT_IF_C Ul_Ui_BFu8i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu8i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu8i.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_Ui_BFu8i");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_Ui_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu8i, Ul_Ui_BFu8i)
//============================================================================


struct  Ul_Ui_BFu8ll  {
  __tsu64 v1;
  unsigned int v2;
  __tsu64 v3:8;
};
//SIG(1 Ul_Ui_BFu8ll) C1{ FL Fi FL:8}



static void Test_Ul_Ui_BFu8ll()
{
  {
    init_simple_test("Ul_Ui_BFu8ll");
    static STRUCT_IF_C Ul_Ui_BFu8ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu8ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_Ui_BFu8ll");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_Ui_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu8ll, Ul_Ui_BFu8ll)
//============================================================================


struct  Ul_Ui_BFu8s  {
  __tsu64 v1;
  unsigned int v2;
  unsigned short v3:8;
};
//SIG(1 Ul_Ui_BFu8s) C1{ FL Fi Fs:8}



static void Test_Ul_Ui_BFu8s()
{
  {
    init_simple_test("Ul_Ui_BFu8s");
    static STRUCT_IF_C Ul_Ui_BFu8s lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu8s.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu8s.v2");
    set_bf_and_test(lv, v3, 12, 0, 8, 1, "Ul_Ui_BFu8s");
    set_bf_and_test(lv, v3, 12, 0, 8, hide_ull(1LL<<7), "Ul_Ui_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu8s, Ul_Ui_BFu8s)
//============================================================================


struct  Ul_Ui_BFu9i  {
  __tsu64 v1;
  unsigned int v2;
  unsigned int v3:9;
};
//SIG(1 Ul_Ui_BFu9i) C1{ FL Fi Fi:9}



static void Test_Ul_Ui_BFu9i()
{
  {
    init_simple_test("Ul_Ui_BFu9i");
    static STRUCT_IF_C Ul_Ui_BFu9i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu9i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu9i.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "Ul_Ui_BFu9i");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "Ul_Ui_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu9i, Ul_Ui_BFu9i)
//============================================================================


struct  Ul_Ui_BFu9ll  {
  __tsu64 v1;
  unsigned int v2;
  __tsu64 v3:9;
};
//SIG(1 Ul_Ui_BFu9ll) C1{ FL Fi FL:9}



static void Test_Ul_Ui_BFu9ll()
{
  {
    init_simple_test("Ul_Ui_BFu9ll");
    static STRUCT_IF_C Ul_Ui_BFu9ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu9ll.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "Ul_Ui_BFu9ll");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "Ul_Ui_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu9ll, Ul_Ui_BFu9ll)
//============================================================================


struct  Ul_Ui_BFu9s  {
  __tsu64 v1;
  unsigned int v2;
  unsigned short v3:9;
};
//SIG(1 Ul_Ui_BFu9s) C1{ FL Fi Fs:9}



static void Test_Ul_Ui_BFu9s()
{
  {
    init_simple_test("Ul_Ui_BFu9s");
    static STRUCT_IF_C Ul_Ui_BFu9s lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_Ui_BFu9s.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_BFu9s.v2");
    set_bf_and_test(lv, v3, 12, 0, 9, 1, "Ul_Ui_BFu9s");
    set_bf_and_test(lv, v3, 12, 0, 9, hide_ull(1LL<<8), "Ul_Ui_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_BFu9s, Ul_Ui_BFu9s)
//============================================================================


struct  Ul_Ui_C  {
  __tsu64 v1;
  unsigned int v2;
  char v3;
};
//SIG(1 Ul_Ui_C) C1{ FL Fi Fc}



static void Test_Ul_Ui_C()
{
  {
    init_simple_test("Ul_Ui_C");
    STRUCT_IF_C Ul_Ui_C lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_C)");
    check_field_offset(lv, v1, 0, "Ul_Ui_C.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_C.v2");
    check_field_offset(lv, v3, 12, "Ul_Ui_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_C, Ul_Ui_C)
//============================================================================


struct  Ul_Ui_D  {
  __tsu64 v1;
  unsigned int v2;
  double v3;
};
//SIG(1 Ul_Ui_D) C1{ FL Fi FL}



static void Test_Ul_Ui_D()
{
  {
    init_simple_test("Ul_Ui_D");
    STRUCT_IF_C Ul_Ui_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ui_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_D)");
    check_field_offset(lv, v1, 0, "Ul_Ui_D.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Ui_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_D, Ul_Ui_D)
//============================================================================


struct  Ul_Ui_F  {
  __tsu64 v1;
  unsigned int v2;
  float v3;
};
//SIG(1 Ul_Ui_F) C1{ FL Fi[2]}



static void Test_Ul_Ui_F()
{
  {
    init_simple_test("Ul_Ui_F");
    STRUCT_IF_C Ul_Ui_F lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_F)");
    check_field_offset(lv, v1, 0, "Ul_Ui_F.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_F.v2");
    check_field_offset(lv, v3, 12, "Ul_Ui_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_F, Ul_Ui_F)
//============================================================================


struct  Ul_Ui_I  {
  __tsu64 v1;
  unsigned int v2;
  int v3;
};
//SIG(1 Ul_Ui_I) C1{ FL Fi[2]}



static void Test_Ul_Ui_I()
{
  {
    init_simple_test("Ul_Ui_I");
    STRUCT_IF_C Ul_Ui_I lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_I)");
    check_field_offset(lv, v1, 0, "Ul_Ui_I.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_I.v2");
    check_field_offset(lv, v3, 12, "Ul_Ui_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_I, Ul_Ui_I)
//============================================================================


struct  Ul_Ui_Ip  {
  __tsu64 v1;
  unsigned int v2;
  int *v3;
};
//SIG(1 Ul_Ui_Ip) C1{ FL Fi Fp}



static void Test_Ul_Ui_Ip()
{
  {
    init_simple_test("Ul_Ui_Ip");
    STRUCT_IF_C Ul_Ui_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ui_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_Ip)");
    check_field_offset(lv, v1, 0, "Ul_Ui_Ip.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Ui_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_Ip, Ul_Ui_Ip)
//============================================================================


struct  Ul_Ui_L  {
  __tsu64 v1;
  unsigned int v2;
  __tsi64 v3;
};
//SIG(1 Ul_Ui_L) C1{ FL Fi FL}



static void Test_Ul_Ui_L()
{
  {
    init_simple_test("Ul_Ui_L");
    STRUCT_IF_C Ul_Ui_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ui_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_L)");
    check_field_offset(lv, v1, 0, "Ul_Ui_L.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Ui_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_L, Ul_Ui_L)
//============================================================================


struct  Ul_Ui_S  {
  __tsu64 v1;
  unsigned int v2;
  short v3;
};
//SIG(1 Ul_Ui_S) C1{ FL Fi Fs}



static void Test_Ul_Ui_S()
{
  {
    init_simple_test("Ul_Ui_S");
    STRUCT_IF_C Ul_Ui_S lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_S)");
    check_field_offset(lv, v1, 0, "Ul_Ui_S.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_S.v2");
    check_field_offset(lv, v3, 12, "Ul_Ui_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_S, Ul_Ui_S)
//============================================================================


struct  Ul_Ui_Uc  {
  __tsu64 v1;
  unsigned int v2;
  unsigned char v3;
};
//SIG(1 Ul_Ui_Uc) C1{ FL Fi Fc}



static void Test_Ul_Ui_Uc()
{
  {
    init_simple_test("Ul_Ui_Uc");
    STRUCT_IF_C Ul_Ui_Uc lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_Uc)");
    check_field_offset(lv, v1, 0, "Ul_Ui_Uc.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_Uc.v2");
    check_field_offset(lv, v3, 12, "Ul_Ui_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_Uc, Ul_Ui_Uc)
//============================================================================


struct  Ul_Ui_Ui  {
  __tsu64 v1;
  unsigned int v2;
  unsigned int v3;
};
//SIG(1 Ul_Ui_Ui) C1{ FL Fi[2]}



static void Test_Ul_Ui_Ui()
{
  {
    init_simple_test("Ul_Ui_Ui");
    STRUCT_IF_C Ul_Ui_Ui lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_Ui)");
    check_field_offset(lv, v1, 0, "Ul_Ui_Ui.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_Ui.v2");
    check_field_offset(lv, v3, 12, "Ul_Ui_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_Ui, Ul_Ui_Ui)
//============================================================================


struct  Ul_Ui_Ul  {
  __tsu64 v1;
  unsigned int v2;
  __tsu64 v3;
};
//SIG(1 Ul_Ui_Ul) C1{ FL Fi FL}



static void Test_Ul_Ui_Ul()
{
  {
    init_simple_test("Ul_Ui_Ul");
    STRUCT_IF_C Ul_Ui_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ui_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_Ul)");
    check_field_offset(lv, v1, 0, "Ul_Ui_Ul.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Ui_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_Ul, Ul_Ui_Ul)
//============================================================================


struct  Ul_Ui_Us  {
  __tsu64 v1;
  unsigned int v2;
  unsigned short v3;
};
//SIG(1 Ul_Ui_Us) C1{ FL Fi Fs}



static void Test_Ul_Ui_Us()
{
  {
    init_simple_test("Ul_Ui_Us");
    STRUCT_IF_C Ul_Ui_Us lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ui_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_Us)");
    check_field_offset(lv, v1, 0, "Ul_Ui_Us.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_Us.v2");
    check_field_offset(lv, v3, 12, "Ul_Ui_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_Us, Ul_Ui_Us)
//============================================================================


struct  Ul_Ui_Vp  {
  __tsu64 v1;
  unsigned int v2;
  void *v3;
};
//SIG(1 Ul_Ui_Vp) C1{ FL Fi Fp}



static void Test_Ul_Ui_Vp()
{
  {
    init_simple_test("Ul_Ui_Vp");
    STRUCT_IF_C Ul_Ui_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Ui_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ui_Vp)");
    check_field_offset(lv, v1, 0, "Ul_Ui_Vp.v1");
    check_field_offset(lv, v2, 8, "Ul_Ui_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Ui_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ui_Vp, Ul_Ui_Vp)
//============================================================================


struct  Ul_Ul  {
  __tsu64 v1;
  __tsu64 v2;
};
//SIG(1 Ul_Ul) C1{ FL[2]}



static void Test_Ul_Ul()
{
  {
    init_simple_test("Ul_Ul");
    STRUCT_IF_C Ul_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul)");
    check_field_offset(lv, v1, 0, "Ul_Ul.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul, Ul_Ul)
//============================================================================


struct  Ul_Ul_BFu15i  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned int v3:15;
};
//SIG(1 Ul_Ul_BFu15i) C1{ FL[2] Fi:15}



static void Test_Ul_Ul_BFu15i()
{
  {
    init_simple_test("Ul_Ul_BFu15i");
    static STRUCT_IF_C Ul_Ul_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu15i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu15i.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "Ul_Ul_BFu15i");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "Ul_Ul_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu15i, Ul_Ul_BFu15i)
//============================================================================


struct  Ul_Ul_BFu15ll  {
  __tsu64 v1;
  __tsu64 v2;
  __tsu64 v3:15;
};
//SIG(1 Ul_Ul_BFu15ll) C1{ FL[2] FL:15}



static void Test_Ul_Ul_BFu15ll()
{
  {
    init_simple_test("Ul_Ul_BFu15ll");
    static STRUCT_IF_C Ul_Ul_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu15ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "Ul_Ul_BFu15ll");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "Ul_Ul_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu15ll, Ul_Ul_BFu15ll)
//============================================================================


struct  Ul_Ul_BFu15s  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned short v3:15;
};
//SIG(1 Ul_Ul_BFu15s) C1{ FL[2] Fs:15}



static void Test_Ul_Ul_BFu15s()
{
  {
    init_simple_test("Ul_Ul_BFu15s");
    static STRUCT_IF_C Ul_Ul_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu15s.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu15s.v2");
    set_bf_and_test(lv, v3, 16, 0, 15, 1, "Ul_Ul_BFu15s");
    set_bf_and_test(lv, v3, 16, 0, 15, hide_ull(1LL<<14), "Ul_Ul_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu15s, Ul_Ul_BFu15s)
//============================================================================


struct  Ul_Ul_BFu16i  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned int v3:16;
};
//SIG(1 Ul_Ul_BFu16i) C1{ FL[2] Fi:16}



static void Test_Ul_Ul_BFu16i()
{
  {
    init_simple_test("Ul_Ul_BFu16i");
    static STRUCT_IF_C Ul_Ul_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu16i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu16i.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "Ul_Ul_BFu16i");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "Ul_Ul_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu16i, Ul_Ul_BFu16i)
//============================================================================


struct  Ul_Ul_BFu16ll  {
  __tsu64 v1;
  __tsu64 v2;
  __tsu64 v3:16;
};
//SIG(1 Ul_Ul_BFu16ll) C1{ FL[2] FL:16}



static void Test_Ul_Ul_BFu16ll()
{
  {
    init_simple_test("Ul_Ul_BFu16ll");
    static STRUCT_IF_C Ul_Ul_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu16ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "Ul_Ul_BFu16ll");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "Ul_Ul_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu16ll, Ul_Ul_BFu16ll)
//============================================================================


struct  Ul_Ul_BFu16s  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned short v3:16;
};
//SIG(1 Ul_Ul_BFu16s) C1{ FL[2] Fs:16}



static void Test_Ul_Ul_BFu16s()
{
  {
    init_simple_test("Ul_Ul_BFu16s");
    static STRUCT_IF_C Ul_Ul_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu16s.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu16s.v2");
    set_bf_and_test(lv, v3, 16, 0, 16, 1, "Ul_Ul_BFu16s");
    set_bf_and_test(lv, v3, 16, 0, 16, hide_ull(1LL<<15), "Ul_Ul_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu16s, Ul_Ul_BFu16s)
//============================================================================


struct  Ul_Ul_BFu17i  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned int v3:17;
};
//SIG(1 Ul_Ul_BFu17i) C1{ FL[2] Fi:17}



static void Test_Ul_Ul_BFu17i()
{
  {
    init_simple_test("Ul_Ul_BFu17i");
    static STRUCT_IF_C Ul_Ul_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu17i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu17i.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "Ul_Ul_BFu17i");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "Ul_Ul_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu17i, Ul_Ul_BFu17i)
//============================================================================


struct  Ul_Ul_BFu17ll  {
  __tsu64 v1;
  __tsu64 v2;
  __tsu64 v3:17;
};
//SIG(1 Ul_Ul_BFu17ll) C1{ FL[2] FL:17}



static void Test_Ul_Ul_BFu17ll()
{
  {
    init_simple_test("Ul_Ul_BFu17ll");
    static STRUCT_IF_C Ul_Ul_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu17ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 17, 1, "Ul_Ul_BFu17ll");
    set_bf_and_test(lv, v3, 16, 0, 17, hide_ull(1LL<<16), "Ul_Ul_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu17ll, Ul_Ul_BFu17ll)
//============================================================================


struct  Ul_Ul_BFu1c  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned char v3:1;
};
//SIG(1 Ul_Ul_BFu1c) C1{ FL[2] Fc:1}



static void Test_Ul_Ul_BFu1c()
{
  {
    init_simple_test("Ul_Ul_BFu1c");
    static STRUCT_IF_C Ul_Ul_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu1c.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu1c.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "Ul_Ul_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu1c, Ul_Ul_BFu1c)
//============================================================================


struct  Ul_Ul_BFu1i  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned int v3:1;
};
//SIG(1 Ul_Ul_BFu1i) C1{ FL[2] Fi:1}



static void Test_Ul_Ul_BFu1i()
{
  {
    init_simple_test("Ul_Ul_BFu1i");
    static STRUCT_IF_C Ul_Ul_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu1i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu1i.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "Ul_Ul_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu1i, Ul_Ul_BFu1i)
//============================================================================


struct  Ul_Ul_BFu1ll  {
  __tsu64 v1;
  __tsu64 v2;
  __tsu64 v3:1;
};
//SIG(1 Ul_Ul_BFu1ll) C1{ FL[2] FL:1}



static void Test_Ul_Ul_BFu1ll()
{
  {
    init_simple_test("Ul_Ul_BFu1ll");
    static STRUCT_IF_C Ul_Ul_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu1ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "Ul_Ul_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu1ll, Ul_Ul_BFu1ll)
//============================================================================


struct  Ul_Ul_BFu1s  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned short v3:1;
};
//SIG(1 Ul_Ul_BFu1s) C1{ FL[2] Fs:1}



static void Test_Ul_Ul_BFu1s()
{
  {
    init_simple_test("Ul_Ul_BFu1s");
    static STRUCT_IF_C Ul_Ul_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu1s.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu1s.v2");
    set_bf_and_test(lv, v3, 16, 0, 1, 1, "Ul_Ul_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu1s, Ul_Ul_BFu1s)
//============================================================================


struct  Ul_Ul_BFu31i  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned int v3:31;
};
//SIG(1 Ul_Ul_BFu31i) C1{ FL[2] Fi:31}



static void Test_Ul_Ul_BFu31i()
{
  {
    init_simple_test("Ul_Ul_BFu31i");
    static STRUCT_IF_C Ul_Ul_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu31i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu31i.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "Ul_Ul_BFu31i");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "Ul_Ul_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu31i, Ul_Ul_BFu31i)
//============================================================================


struct  Ul_Ul_BFu31ll  {
  __tsu64 v1;
  __tsu64 v2;
  __tsu64 v3:31;
};
//SIG(1 Ul_Ul_BFu31ll) C1{ FL[2] FL:31}



static void Test_Ul_Ul_BFu31ll()
{
  {
    init_simple_test("Ul_Ul_BFu31ll");
    static STRUCT_IF_C Ul_Ul_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu31ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 31, 1, "Ul_Ul_BFu31ll");
    set_bf_and_test(lv, v3, 16, 0, 31, hide_ull(1LL<<30), "Ul_Ul_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu31ll, Ul_Ul_BFu31ll)
//============================================================================


struct  Ul_Ul_BFu32i  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned int v3:32;
};
//SIG(1 Ul_Ul_BFu32i) C1{ FL[2] Fi:32}



static void Test_Ul_Ul_BFu32i()
{
  {
    init_simple_test("Ul_Ul_BFu32i");
    static STRUCT_IF_C Ul_Ul_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu32i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu32i.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "Ul_Ul_BFu32i");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "Ul_Ul_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu32i, Ul_Ul_BFu32i)
//============================================================================


struct  Ul_Ul_BFu32ll  {
  __tsu64 v1;
  __tsu64 v2;
  __tsu64 v3:32;
};
//SIG(1 Ul_Ul_BFu32ll) C1{ FL[2] FL:32}



static void Test_Ul_Ul_BFu32ll()
{
  {
    init_simple_test("Ul_Ul_BFu32ll");
    static STRUCT_IF_C Ul_Ul_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu32ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 32, 1, "Ul_Ul_BFu32ll");
    set_bf_and_test(lv, v3, 16, 0, 32, hide_ull(1LL<<31), "Ul_Ul_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu32ll, Ul_Ul_BFu32ll)
//============================================================================


struct  Ul_Ul_BFu33  {
  __tsu64 v1;
  __tsu64 v2;
  __tsu64 v3:33;
};
//SIG(1 Ul_Ul_BFu33) C1{ FL[2] FL:33}



static void Test_Ul_Ul_BFu33()
{
  {
    init_simple_test("Ul_Ul_BFu33");
    static STRUCT_IF_C Ul_Ul_BFu33 lv;
    check2(sizeof(lv), 24, "sizeof(Ul_Ul_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu33.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu33.v2");
    set_bf_and_test(lv, v3, 16, 0, 33, 1, "Ul_Ul_BFu33");
    set_bf_and_test(lv, v3, 16, 0, 33, hide_ull(1LL<<32), "Ul_Ul_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu33, Ul_Ul_BFu33)
//============================================================================


struct  Ul_Ul_BFu7c  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned char v3:7;
};
//SIG(1 Ul_Ul_BFu7c) C1{ FL[2] Fc:7}



static void Test_Ul_Ul_BFu7c()
{
  {
    init_simple_test("Ul_Ul_BFu7c");
    static STRUCT_IF_C Ul_Ul_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu7c.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu7c.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "Ul_Ul_BFu7c");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "Ul_Ul_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu7c, Ul_Ul_BFu7c)
//============================================================================


struct  Ul_Ul_BFu7i  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned int v3:7;
};
//SIG(1 Ul_Ul_BFu7i) C1{ FL[2] Fi:7}



static void Test_Ul_Ul_BFu7i()
{
  {
    init_simple_test("Ul_Ul_BFu7i");
    static STRUCT_IF_C Ul_Ul_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu7i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu7i.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "Ul_Ul_BFu7i");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "Ul_Ul_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu7i, Ul_Ul_BFu7i)
//============================================================================


struct  Ul_Ul_BFu7ll  {
  __tsu64 v1;
  __tsu64 v2;
  __tsu64 v3:7;
};
//SIG(1 Ul_Ul_BFu7ll) C1{ FL[2] FL:7}



static void Test_Ul_Ul_BFu7ll()
{
  {
    init_simple_test("Ul_Ul_BFu7ll");
    static STRUCT_IF_C Ul_Ul_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu7ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "Ul_Ul_BFu7ll");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "Ul_Ul_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu7ll, Ul_Ul_BFu7ll)
//============================================================================


struct  Ul_Ul_BFu7s  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned short v3:7;
};
//SIG(1 Ul_Ul_BFu7s) C1{ FL[2] Fs:7}



static void Test_Ul_Ul_BFu7s()
{
  {
    init_simple_test("Ul_Ul_BFu7s");
    static STRUCT_IF_C Ul_Ul_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu7s.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu7s.v2");
    set_bf_and_test(lv, v3, 16, 0, 7, 1, "Ul_Ul_BFu7s");
    set_bf_and_test(lv, v3, 16, 0, 7, hide_ull(1LL<<6), "Ul_Ul_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu7s, Ul_Ul_BFu7s)
//============================================================================


struct  Ul_Ul_BFu8c  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned char v3:8;
};
//SIG(1 Ul_Ul_BFu8c) C1{ FL[2] Fc:8}



static void Test_Ul_Ul_BFu8c()
{
  {
    init_simple_test("Ul_Ul_BFu8c");
    static STRUCT_IF_C Ul_Ul_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu8c.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu8c.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "Ul_Ul_BFu8c");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "Ul_Ul_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu8c, Ul_Ul_BFu8c)
//============================================================================


struct  Ul_Ul_BFu8i  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned int v3:8;
};
//SIG(1 Ul_Ul_BFu8i) C1{ FL[2] Fi:8}



static void Test_Ul_Ul_BFu8i()
{
  {
    init_simple_test("Ul_Ul_BFu8i");
    static STRUCT_IF_C Ul_Ul_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu8i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu8i.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "Ul_Ul_BFu8i");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "Ul_Ul_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu8i, Ul_Ul_BFu8i)
//============================================================================


struct  Ul_Ul_BFu8ll  {
  __tsu64 v1;
  __tsu64 v2;
  __tsu64 v3:8;
};
//SIG(1 Ul_Ul_BFu8ll) C1{ FL[2] FL:8}



static void Test_Ul_Ul_BFu8ll()
{
  {
    init_simple_test("Ul_Ul_BFu8ll");
    static STRUCT_IF_C Ul_Ul_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu8ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "Ul_Ul_BFu8ll");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "Ul_Ul_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu8ll, Ul_Ul_BFu8ll)
//============================================================================


struct  Ul_Ul_BFu8s  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned short v3:8;
};
//SIG(1 Ul_Ul_BFu8s) C1{ FL[2] Fs:8}



static void Test_Ul_Ul_BFu8s()
{
  {
    init_simple_test("Ul_Ul_BFu8s");
    static STRUCT_IF_C Ul_Ul_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu8s.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu8s.v2");
    set_bf_and_test(lv, v3, 16, 0, 8, 1, "Ul_Ul_BFu8s");
    set_bf_and_test(lv, v3, 16, 0, 8, hide_ull(1LL<<7), "Ul_Ul_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu8s, Ul_Ul_BFu8s)
//============================================================================


struct  Ul_Ul_BFu9i  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned int v3:9;
};
//SIG(1 Ul_Ul_BFu9i) C1{ FL[2] Fi:9}



static void Test_Ul_Ul_BFu9i()
{
  {
    init_simple_test("Ul_Ul_BFu9i");
    static STRUCT_IF_C Ul_Ul_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu9i.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu9i.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "Ul_Ul_BFu9i");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "Ul_Ul_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu9i, Ul_Ul_BFu9i)
//============================================================================


struct  Ul_Ul_BFu9ll  {
  __tsu64 v1;
  __tsu64 v2;
  __tsu64 v3:9;
};
//SIG(1 Ul_Ul_BFu9ll) C1{ FL[2] FL:9}



static void Test_Ul_Ul_BFu9ll()
{
  {
    init_simple_test("Ul_Ul_BFu9ll");
    static STRUCT_IF_C Ul_Ul_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu9ll.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "Ul_Ul_BFu9ll");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "Ul_Ul_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu9ll, Ul_Ul_BFu9ll)
//============================================================================


struct  Ul_Ul_BFu9s  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned short v3:9;
};
//SIG(1 Ul_Ul_BFu9s) C1{ FL[2] Fs:9}



static void Test_Ul_Ul_BFu9s()
{
  {
    init_simple_test("Ul_Ul_BFu9s");
    static STRUCT_IF_C Ul_Ul_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_Ul_BFu9s.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_BFu9s.v2");
    set_bf_and_test(lv, v3, 16, 0, 9, 1, "Ul_Ul_BFu9s");
    set_bf_and_test(lv, v3, 16, 0, 9, hide_ull(1LL<<8), "Ul_Ul_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_BFu9s, Ul_Ul_BFu9s)
//============================================================================


struct  Ul_Ul_C  {
  __tsu64 v1;
  __tsu64 v2;
  char v3;
};
//SIG(1 Ul_Ul_C) C1{ FL[2] Fc}



static void Test_Ul_Ul_C()
{
  {
    init_simple_test("Ul_Ul_C");
    STRUCT_IF_C Ul_Ul_C lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_C)");
    check_field_offset(lv, v1, 0, "Ul_Ul_C.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_C.v2");
    check_field_offset(lv, v3, 16, "Ul_Ul_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_C, Ul_Ul_C)
//============================================================================


struct  Ul_Ul_D  {
  __tsu64 v1;
  __tsu64 v2;
  double v3;
};
//SIG(1 Ul_Ul_D) C1{ FL[3]}



static void Test_Ul_Ul_D()
{
  {
    init_simple_test("Ul_Ul_D");
    STRUCT_IF_C Ul_Ul_D lv;
    check2(sizeof(lv), 24, "sizeof(Ul_Ul_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_D)");
    check_field_offset(lv, v1, 0, "Ul_Ul_D.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_D.v2");
    check_field_offset(lv, v3, 16, "Ul_Ul_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_D, Ul_Ul_D)
//============================================================================


struct  Ul_Ul_F  {
  __tsu64 v1;
  __tsu64 v2;
  float v3;
};
//SIG(1 Ul_Ul_F) C1{ FL[2] Fi}



static void Test_Ul_Ul_F()
{
  {
    init_simple_test("Ul_Ul_F");
    STRUCT_IF_C Ul_Ul_F lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_F)");
    check_field_offset(lv, v1, 0, "Ul_Ul_F.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_F.v2");
    check_field_offset(lv, v3, 16, "Ul_Ul_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_F, Ul_Ul_F)
//============================================================================


struct  Ul_Ul_I  {
  __tsu64 v1;
  __tsu64 v2;
  int v3;
};
//SIG(1 Ul_Ul_I) C1{ FL[2] Fi}



static void Test_Ul_Ul_I()
{
  {
    init_simple_test("Ul_Ul_I");
    STRUCT_IF_C Ul_Ul_I lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_I)");
    check_field_offset(lv, v1, 0, "Ul_Ul_I.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_I.v2");
    check_field_offset(lv, v3, 16, "Ul_Ul_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_I, Ul_Ul_I)
//============================================================================


struct  Ul_Ul_Ip  {
  __tsu64 v1;
  __tsu64 v2;
  int *v3;
};
//SIG(1 Ul_Ul_Ip) C1{ FL[2] Fp}



static void Test_Ul_Ul_Ip()
{
  {
    init_simple_test("Ul_Ul_Ip");
    STRUCT_IF_C Ul_Ul_Ip lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_Ip)");
    check_field_offset(lv, v1, 0, "Ul_Ul_Ip.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_Ip.v2");
    check_field_offset(lv, v3, 16, "Ul_Ul_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_Ip, Ul_Ul_Ip)
//============================================================================


struct  Ul_Ul_L  {
  __tsu64 v1;
  __tsu64 v2;
  __tsi64 v3;
};
//SIG(1 Ul_Ul_L) C1{ FL[3]}



static void Test_Ul_Ul_L()
{
  {
    init_simple_test("Ul_Ul_L");
    STRUCT_IF_C Ul_Ul_L lv;
    check2(sizeof(lv), 24, "sizeof(Ul_Ul_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_L)");
    check_field_offset(lv, v1, 0, "Ul_Ul_L.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_L.v2");
    check_field_offset(lv, v3, 16, "Ul_Ul_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_L, Ul_Ul_L)
//============================================================================


struct  Ul_Ul_S  {
  __tsu64 v1;
  __tsu64 v2;
  short v3;
};
//SIG(1 Ul_Ul_S) C1{ FL[2] Fs}



static void Test_Ul_Ul_S()
{
  {
    init_simple_test("Ul_Ul_S");
    STRUCT_IF_C Ul_Ul_S lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_S)");
    check_field_offset(lv, v1, 0, "Ul_Ul_S.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_S.v2");
    check_field_offset(lv, v3, 16, "Ul_Ul_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_S, Ul_Ul_S)
//============================================================================


struct  Ul_Ul_Uc  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned char v3;
};
//SIG(1 Ul_Ul_Uc) C1{ FL[2] Fc}



static void Test_Ul_Ul_Uc()
{
  {
    init_simple_test("Ul_Ul_Uc");
    STRUCT_IF_C Ul_Ul_Uc lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_Uc)");
    check_field_offset(lv, v1, 0, "Ul_Ul_Uc.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_Uc.v2");
    check_field_offset(lv, v3, 16, "Ul_Ul_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_Uc, Ul_Ul_Uc)
//============================================================================


struct  Ul_Ul_Ui  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned int v3;
};
//SIG(1 Ul_Ul_Ui) C1{ FL[2] Fi}



static void Test_Ul_Ul_Ui()
{
  {
    init_simple_test("Ul_Ul_Ui");
    STRUCT_IF_C Ul_Ul_Ui lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_Ui)");
    check_field_offset(lv, v1, 0, "Ul_Ul_Ui.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_Ui.v2");
    check_field_offset(lv, v3, 16, "Ul_Ul_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_Ui, Ul_Ul_Ui)
//============================================================================


struct  Ul_Ul_Ul  {
  __tsu64 v1;
  __tsu64 v2;
  __tsu64 v3;
};
//SIG(1 Ul_Ul_Ul) C1{ FL[3]}



static void Test_Ul_Ul_Ul()
{
  {
    init_simple_test("Ul_Ul_Ul");
    STRUCT_IF_C Ul_Ul_Ul lv;
    check2(sizeof(lv), 24, "sizeof(Ul_Ul_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_Ul)");
    check_field_offset(lv, v1, 0, "Ul_Ul_Ul.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_Ul.v2");
    check_field_offset(lv, v3, 16, "Ul_Ul_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_Ul, Ul_Ul_Ul)
//============================================================================


struct  Ul_Ul_Us  {
  __tsu64 v1;
  __tsu64 v2;
  unsigned short v3;
};
//SIG(1 Ul_Ul_Us) C1{ FL[2] Fs}



static void Test_Ul_Ul_Us()
{
  {
    init_simple_test("Ul_Ul_Us");
    STRUCT_IF_C Ul_Ul_Us lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_Us)");
    check_field_offset(lv, v1, 0, "Ul_Ul_Us.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_Us.v2");
    check_field_offset(lv, v3, 16, "Ul_Ul_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_Us, Ul_Ul_Us)
//============================================================================


struct  Ul_Ul_Vp  {
  __tsu64 v1;
  __tsu64 v2;
  void *v3;
};
//SIG(1 Ul_Ul_Vp) C1{ FL[2] Fp}



static void Test_Ul_Ul_Vp()
{
  {
    init_simple_test("Ul_Ul_Vp");
    STRUCT_IF_C Ul_Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Ul_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Ul_Vp)");
    check_field_offset(lv, v1, 0, "Ul_Ul_Vp.v1");
    check_field_offset(lv, v2, 8, "Ul_Ul_Vp.v2");
    check_field_offset(lv, v3, 16, "Ul_Ul_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Ul_Vp, Ul_Ul_Vp)
//============================================================================


struct  Ul_Us  {
  __tsu64 v1;
  unsigned short v2;
};
//SIG(1 Ul_Us) C1{ FL Fs}



static void Test_Ul_Us()
{
  {
    init_simple_test("Ul_Us");
    STRUCT_IF_C Ul_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us)");
    check_field_offset(lv, v1, 0, "Ul_Us.v1");
    check_field_offset(lv, v2, 8, "Ul_Us.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us, Ul_Us)
//============================================================================


struct  Ul_Us_BFu15i  {
  __tsu64 v1;
  unsigned short v2;
  unsigned int v3:15;
};
//SIG(1 Ul_Us_BFu15i) C1{ FL Fs Fi:15}



static void Test_Ul_Us_BFu15i()
{
  {
    init_simple_test("Ul_Us_BFu15i");
    static STRUCT_IF_C Ul_Us_BFu15i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu15i.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu15i.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_Us_BFu15i");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu15i, Ul_Us_BFu15i)
//============================================================================


struct  Ul_Us_BFu15ll  {
  __tsu64 v1;
  unsigned short v2;
  __tsu64 v3:15;
};
//SIG(1 Ul_Us_BFu15ll) C1{ FL Fs FL:15}



static void Test_Ul_Us_BFu15ll()
{
  {
    init_simple_test("Ul_Us_BFu15ll");
    static STRUCT_IF_C Ul_Us_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu15ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_Us_BFu15ll");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu15ll, Ul_Us_BFu15ll)
//============================================================================


struct  Ul_Us_BFu15s  {
  __tsu64 v1;
  unsigned short v2;
  unsigned short v3:15;
};
//SIG(1 Ul_Us_BFu15s) C1{ FL Fs Fs:15}



static void Test_Ul_Us_BFu15s()
{
  {
    init_simple_test("Ul_Us_BFu15s");
    static STRUCT_IF_C Ul_Us_BFu15s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu15s.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu15s.v2");
    set_bf_and_test(lv, v3, 10, 0, 15, 1, "Ul_Us_BFu15s");
    set_bf_and_test(lv, v3, 10, 0, 15, hide_ull(1LL<<14), "Ul_Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu15s, Ul_Us_BFu15s)
//============================================================================


struct  Ul_Us_BFu16i  {
  __tsu64 v1;
  unsigned short v2;
  unsigned int v3:16;
};
//SIG(1 Ul_Us_BFu16i) C1{ FL Fs Fi:16}



static void Test_Ul_Us_BFu16i()
{
  {
    init_simple_test("Ul_Us_BFu16i");
    static STRUCT_IF_C Ul_Us_BFu16i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu16i.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu16i.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_Us_BFu16i");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu16i, Ul_Us_BFu16i)
//============================================================================


struct  Ul_Us_BFu16ll  {
  __tsu64 v1;
  unsigned short v2;
  __tsu64 v3:16;
};
//SIG(1 Ul_Us_BFu16ll) C1{ FL Fs FL:16}



static void Test_Ul_Us_BFu16ll()
{
  {
    init_simple_test("Ul_Us_BFu16ll");
    static STRUCT_IF_C Ul_Us_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu16ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_Us_BFu16ll");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu16ll, Ul_Us_BFu16ll)
//============================================================================


struct  Ul_Us_BFu16s  {
  __tsu64 v1;
  unsigned short v2;
  unsigned short v3:16;
};
//SIG(1 Ul_Us_BFu16s) C1{ FL Fs Fs:16}



static void Test_Ul_Us_BFu16s()
{
  {
    init_simple_test("Ul_Us_BFu16s");
    static STRUCT_IF_C Ul_Us_BFu16s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu16s.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu16s.v2");
    set_bf_and_test(lv, v3, 10, 0, 16, 1, "Ul_Us_BFu16s");
    set_bf_and_test(lv, v3, 10, 0, 16, hide_ull(1LL<<15), "Ul_Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu16s, Ul_Us_BFu16s)
//============================================================================


struct  Ul_Us_BFu17i  {
  __tsu64 v1;
  unsigned short v2;
  unsigned int v3:17;
};
//SIG(1 Ul_Us_BFu17i) C1{ FL Fs Fi:17}



static void Test_Ul_Us_BFu17i()
{
  {
    init_simple_test("Ul_Us_BFu17i");
    static STRUCT_IF_C Ul_Us_BFu17i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Us_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu17i.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu17i.v2");
    set_bf_and_test(lv, v3, 12, 0, 17, 1, "Ul_Us_BFu17i");
    set_bf_and_test(lv, v3, 12, 0, 17, hide_ull(1LL<<16), "Ul_Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu17i, Ul_Us_BFu17i)
//============================================================================


struct  Ul_Us_BFu17ll  {
  __tsu64 v1;
  unsigned short v2;
  __tsu64 v3:17;
};
//SIG(1 Ul_Us_BFu17ll) C1{ FL Fs FL:17}



static void Test_Ul_Us_BFu17ll()
{
  {
    init_simple_test("Ul_Us_BFu17ll");
    static STRUCT_IF_C Ul_Us_BFu17ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Us_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu17ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 17, 1, "Ul_Us_BFu17ll");
    set_bf_and_test(lv, v3, 10, 0, 17, hide_ull(1LL<<16), "Ul_Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu17ll, Ul_Us_BFu17ll)
//============================================================================


struct  Ul_Us_BFu1c  {
  __tsu64 v1;
  unsigned short v2;
  unsigned char v3:1;
};
//SIG(1 Ul_Us_BFu1c) C1{ FL Fs Fc:1}



static void Test_Ul_Us_BFu1c()
{
  {
    init_simple_test("Ul_Us_BFu1c");
    static STRUCT_IF_C Ul_Us_BFu1c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu1c.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu1c.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu1c, Ul_Us_BFu1c)
//============================================================================


struct  Ul_Us_BFu1i  {
  __tsu64 v1;
  unsigned short v2;
  unsigned int v3:1;
};
//SIG(1 Ul_Us_BFu1i) C1{ FL Fs Fi:1}



static void Test_Ul_Us_BFu1i()
{
  {
    init_simple_test("Ul_Us_BFu1i");
    static STRUCT_IF_C Ul_Us_BFu1i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu1i.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu1i.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu1i, Ul_Us_BFu1i)
//============================================================================


struct  Ul_Us_BFu1ll  {
  __tsu64 v1;
  unsigned short v2;
  __tsu64 v3:1;
};
//SIG(1 Ul_Us_BFu1ll) C1{ FL Fs FL:1}



static void Test_Ul_Us_BFu1ll()
{
  {
    init_simple_test("Ul_Us_BFu1ll");
    static STRUCT_IF_C Ul_Us_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu1ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu1ll, Ul_Us_BFu1ll)
//============================================================================


struct  Ul_Us_BFu1s  {
  __tsu64 v1;
  unsigned short v2;
  unsigned short v3:1;
};
//SIG(1 Ul_Us_BFu1s) C1{ FL Fs Fs:1}



static void Test_Ul_Us_BFu1s()
{
  {
    init_simple_test("Ul_Us_BFu1s");
    static STRUCT_IF_C Ul_Us_BFu1s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu1s.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu1s.v2");
    set_bf_and_test(lv, v3, 10, 0, 1, 1, "Ul_Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu1s, Ul_Us_BFu1s)
//============================================================================


struct  Ul_Us_BFu31i  {
  __tsu64 v1;
  unsigned short v2;
  unsigned int v3:31;
};
//SIG(1 Ul_Us_BFu31i) C1{ FL Fs Fi:31}



static void Test_Ul_Us_BFu31i()
{
  {
    init_simple_test("Ul_Us_BFu31i");
    static STRUCT_IF_C Ul_Us_BFu31i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Us_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu31i.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu31i.v2");
    set_bf_and_test(lv, v3, 12, 0, 31, 1, "Ul_Us_BFu31i");
    set_bf_and_test(lv, v3, 12, 0, 31, hide_ull(1LL<<30), "Ul_Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu31i, Ul_Us_BFu31i)
//============================================================================


struct  Ul_Us_BFu31ll  {
  __tsu64 v1;
  unsigned short v2;
  __tsu64 v3:31;
};
//SIG(1 Ul_Us_BFu31ll) C1{ FL Fs FL:31}



static void Test_Ul_Us_BFu31ll()
{
  {
    init_simple_test("Ul_Us_BFu31ll");
    static STRUCT_IF_C Ul_Us_BFu31ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Us_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu31ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 31, 1, "Ul_Us_BFu31ll");
    set_bf_and_test(lv, v3, 10, 0, 31, hide_ull(1LL<<30), "Ul_Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu31ll, Ul_Us_BFu31ll)
//============================================================================


struct  Ul_Us_BFu32i  {
  __tsu64 v1;
  unsigned short v2;
  unsigned int v3:32;
};
//SIG(1 Ul_Us_BFu32i) C1{ FL Fs Fi:32}



static void Test_Ul_Us_BFu32i()
{
  {
    init_simple_test("Ul_Us_BFu32i");
    static STRUCT_IF_C Ul_Us_BFu32i lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Us_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu32i.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu32i.v2");
    set_bf_and_test(lv, v3, 12, 0, 32, 1, "Ul_Us_BFu32i");
    set_bf_and_test(lv, v3, 12, 0, 32, hide_ull(1LL<<31), "Ul_Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu32i, Ul_Us_BFu32i)
//============================================================================


struct  Ul_Us_BFu32ll  {
  __tsu64 v1;
  unsigned short v2;
  __tsu64 v3:32;
};
//SIG(1 Ul_Us_BFu32ll) C1{ FL Fs FL:32}



static void Test_Ul_Us_BFu32ll()
{
  {
    init_simple_test("Ul_Us_BFu32ll");
    static STRUCT_IF_C Ul_Us_BFu32ll lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Us_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu32ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 32, 1, "Ul_Us_BFu32ll");
    set_bf_and_test(lv, v3, 10, 0, 32, hide_ull(1LL<<31), "Ul_Us_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu32ll, Ul_Us_BFu32ll)
//============================================================================


struct  Ul_Us_BFu33  {
  __tsu64 v1;
  unsigned short v2;
  __tsu64 v3:33;
};
//SIG(1 Ul_Us_BFu33) C1{ FL Fs FL:33}



static void Test_Ul_Us_BFu33()
{
  {
    init_simple_test("Ul_Us_BFu33");
    static STRUCT_IF_C Ul_Us_BFu33 lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Us_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu33.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu33.v2");
    set_bf_and_test(lv, v3, 10, 0, 33, 1, "Ul_Us_BFu33");
    set_bf_and_test(lv, v3, 10, 0, 33, hide_ull(1LL<<32), "Ul_Us_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu33, Ul_Us_BFu33)
//============================================================================


struct  Ul_Us_BFu7c  {
  __tsu64 v1;
  unsigned short v2;
  unsigned char v3:7;
};
//SIG(1 Ul_Us_BFu7c) C1{ FL Fs Fc:7}



static void Test_Ul_Us_BFu7c()
{
  {
    init_simple_test("Ul_Us_BFu7c");
    static STRUCT_IF_C Ul_Us_BFu7c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu7c.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu7c.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_Us_BFu7c");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_Us_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu7c, Ul_Us_BFu7c)
//============================================================================


struct  Ul_Us_BFu7i  {
  __tsu64 v1;
  unsigned short v2;
  unsigned int v3:7;
};
//SIG(1 Ul_Us_BFu7i) C1{ FL Fs Fi:7}



static void Test_Ul_Us_BFu7i()
{
  {
    init_simple_test("Ul_Us_BFu7i");
    static STRUCT_IF_C Ul_Us_BFu7i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu7i.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu7i.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_Us_BFu7i");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_Us_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu7i, Ul_Us_BFu7i)
//============================================================================


struct  Ul_Us_BFu7ll  {
  __tsu64 v1;
  unsigned short v2;
  __tsu64 v3:7;
};
//SIG(1 Ul_Us_BFu7ll) C1{ FL Fs FL:7}



static void Test_Ul_Us_BFu7ll()
{
  {
    init_simple_test("Ul_Us_BFu7ll");
    static STRUCT_IF_C Ul_Us_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu7ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_Us_BFu7ll");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_Us_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu7ll, Ul_Us_BFu7ll)
//============================================================================


struct  Ul_Us_BFu7s  {
  __tsu64 v1;
  unsigned short v2;
  unsigned short v3:7;
};
//SIG(1 Ul_Us_BFu7s) C1{ FL Fs Fs:7}



static void Test_Ul_Us_BFu7s()
{
  {
    init_simple_test("Ul_Us_BFu7s");
    static STRUCT_IF_C Ul_Us_BFu7s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu7s.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu7s.v2");
    set_bf_and_test(lv, v3, 10, 0, 7, 1, "Ul_Us_BFu7s");
    set_bf_and_test(lv, v3, 10, 0, 7, hide_ull(1LL<<6), "Ul_Us_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu7s, Ul_Us_BFu7s)
//============================================================================


struct  Ul_Us_BFu8c  {
  __tsu64 v1;
  unsigned short v2;
  unsigned char v3:8;
};
//SIG(1 Ul_Us_BFu8c) C1{ FL Fs Fc:8}



static void Test_Ul_Us_BFu8c()
{
  {
    init_simple_test("Ul_Us_BFu8c");
    static STRUCT_IF_C Ul_Us_BFu8c lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu8c.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu8c.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_Us_BFu8c");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_Us_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu8c, Ul_Us_BFu8c)
//============================================================================


struct  Ul_Us_BFu8i  {
  __tsu64 v1;
  unsigned short v2;
  unsigned int v3:8;
};
//SIG(1 Ul_Us_BFu8i) C1{ FL Fs Fi:8}



static void Test_Ul_Us_BFu8i()
{
  {
    init_simple_test("Ul_Us_BFu8i");
    static STRUCT_IF_C Ul_Us_BFu8i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu8i.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu8i.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_Us_BFu8i");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_Us_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu8i, Ul_Us_BFu8i)
//============================================================================


struct  Ul_Us_BFu8ll  {
  __tsu64 v1;
  unsigned short v2;
  __tsu64 v3:8;
};
//SIG(1 Ul_Us_BFu8ll) C1{ FL Fs FL:8}



static void Test_Ul_Us_BFu8ll()
{
  {
    init_simple_test("Ul_Us_BFu8ll");
    static STRUCT_IF_C Ul_Us_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu8ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_Us_BFu8ll");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_Us_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu8ll, Ul_Us_BFu8ll)
//============================================================================


struct  Ul_Us_BFu8s  {
  __tsu64 v1;
  unsigned short v2;
  unsigned short v3:8;
};
//SIG(1 Ul_Us_BFu8s) C1{ FL Fs Fs:8}



static void Test_Ul_Us_BFu8s()
{
  {
    init_simple_test("Ul_Us_BFu8s");
    static STRUCT_IF_C Ul_Us_BFu8s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu8s.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu8s.v2");
    set_bf_and_test(lv, v3, 10, 0, 8, 1, "Ul_Us_BFu8s");
    set_bf_and_test(lv, v3, 10, 0, 8, hide_ull(1LL<<7), "Ul_Us_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu8s, Ul_Us_BFu8s)
//============================================================================


struct  Ul_Us_BFu9i  {
  __tsu64 v1;
  unsigned short v2;
  unsigned int v3:9;
};
//SIG(1 Ul_Us_BFu9i) C1{ FL Fs Fi:9}



static void Test_Ul_Us_BFu9i()
{
  {
    init_simple_test("Ul_Us_BFu9i");
    static STRUCT_IF_C Ul_Us_BFu9i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu9i.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu9i.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_Us_BFu9i");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_Us_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu9i, Ul_Us_BFu9i)
//============================================================================


struct  Ul_Us_BFu9ll  {
  __tsu64 v1;
  unsigned short v2;
  __tsu64 v3:9;
};
//SIG(1 Ul_Us_BFu9ll) C1{ FL Fs FL:9}



static void Test_Ul_Us_BFu9ll()
{
  {
    init_simple_test("Ul_Us_BFu9ll");
    static STRUCT_IF_C Ul_Us_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu9ll.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_Us_BFu9ll");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_Us_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu9ll, Ul_Us_BFu9ll)
//============================================================================


struct  Ul_Us_BFu9s  {
  __tsu64 v1;
  unsigned short v2;
  unsigned short v3:9;
};
//SIG(1 Ul_Us_BFu9s) C1{ FL Fs Fs:9}



static void Test_Ul_Us_BFu9s()
{
  {
    init_simple_test("Ul_Us_BFu9s");
    static STRUCT_IF_C Ul_Us_BFu9s lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_Us_BFu9s.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_BFu9s.v2");
    set_bf_and_test(lv, v3, 10, 0, 9, 1, "Ul_Us_BFu9s");
    set_bf_and_test(lv, v3, 10, 0, 9, hide_ull(1LL<<8), "Ul_Us_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_BFu9s, Ul_Us_BFu9s)
//============================================================================


struct  Ul_Us_C  {
  __tsu64 v1;
  unsigned short v2;
  char v3;
};
//SIG(1 Ul_Us_C) C1{ FL Fs Fc}



static void Test_Ul_Us_C()
{
  {
    init_simple_test("Ul_Us_C");
    STRUCT_IF_C Ul_Us_C lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_C)");
    check_field_offset(lv, v1, 0, "Ul_Us_C.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_C.v2");
    check_field_offset(lv, v3, 10, "Ul_Us_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_C, Ul_Us_C)
//============================================================================


struct  Ul_Us_D  {
  __tsu64 v1;
  unsigned short v2;
  double v3;
};
//SIG(1 Ul_Us_D) C1{ FL Fs FL}



static void Test_Ul_Us_D()
{
  {
    init_simple_test("Ul_Us_D");
    STRUCT_IF_C Ul_Us_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Us_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_D)");
    check_field_offset(lv, v1, 0, "Ul_Us_D.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Us_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_D, Ul_Us_D)
//============================================================================


struct  Ul_Us_F  {
  __tsu64 v1;
  unsigned short v2;
  float v3;
};
//SIG(1 Ul_Us_F) C1{ FL Fs Fi}



static void Test_Ul_Us_F()
{
  {
    init_simple_test("Ul_Us_F");
    STRUCT_IF_C Ul_Us_F lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Us_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_F)");
    check_field_offset(lv, v1, 0, "Ul_Us_F.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_F.v2");
    check_field_offset(lv, v3, 12, "Ul_Us_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_F, Ul_Us_F)
//============================================================================


struct  Ul_Us_I  {
  __tsu64 v1;
  unsigned short v2;
  int v3;
};
//SIG(1 Ul_Us_I) C1{ FL Fs Fi}



static void Test_Ul_Us_I()
{
  {
    init_simple_test("Ul_Us_I");
    STRUCT_IF_C Ul_Us_I lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Us_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_I)");
    check_field_offset(lv, v1, 0, "Ul_Us_I.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_I.v2");
    check_field_offset(lv, v3, 12, "Ul_Us_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_I, Ul_Us_I)
//============================================================================


struct  Ul_Us_Ip  {
  __tsu64 v1;
  unsigned short v2;
  int *v3;
};
//SIG(1 Ul_Us_Ip) C1{ FL Fs Fp}



static void Test_Ul_Us_Ip()
{
  {
    init_simple_test("Ul_Us_Ip");
    STRUCT_IF_C Ul_Us_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Us_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_Ip)");
    check_field_offset(lv, v1, 0, "Ul_Us_Ip.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Us_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_Ip, Ul_Us_Ip)
//============================================================================


struct  Ul_Us_L  {
  __tsu64 v1;
  unsigned short v2;
  __tsi64 v3;
};
//SIG(1 Ul_Us_L) C1{ FL Fs FL}



static void Test_Ul_Us_L()
{
  {
    init_simple_test("Ul_Us_L");
    STRUCT_IF_C Ul_Us_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Us_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_L)");
    check_field_offset(lv, v1, 0, "Ul_Us_L.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Us_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_L, Ul_Us_L)
//============================================================================


struct  Ul_Us_S  {
  __tsu64 v1;
  unsigned short v2;
  short v3;
};
//SIG(1 Ul_Us_S) C1{ FL Fs[2]}



static void Test_Ul_Us_S()
{
  {
    init_simple_test("Ul_Us_S");
    STRUCT_IF_C Ul_Us_S lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_S)");
    check_field_offset(lv, v1, 0, "Ul_Us_S.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_S.v2");
    check_field_offset(lv, v3, 10, "Ul_Us_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_S, Ul_Us_S)
//============================================================================


struct  Ul_Us_Uc  {
  __tsu64 v1;
  unsigned short v2;
  unsigned char v3;
};
//SIG(1 Ul_Us_Uc) C1{ FL Fs Fc}



static void Test_Ul_Us_Uc()
{
  {
    init_simple_test("Ul_Us_Uc");
    STRUCT_IF_C Ul_Us_Uc lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_Uc)");
    check_field_offset(lv, v1, 0, "Ul_Us_Uc.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_Uc.v2");
    check_field_offset(lv, v3, 10, "Ul_Us_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_Uc, Ul_Us_Uc)
//============================================================================


struct  Ul_Us_Ui  {
  __tsu64 v1;
  unsigned short v2;
  unsigned int v3;
};
//SIG(1 Ul_Us_Ui) C1{ FL Fs Fi}



static void Test_Ul_Us_Ui()
{
  {
    init_simple_test("Ul_Us_Ui");
    STRUCT_IF_C Ul_Us_Ui lv;
    check2(sizeof(lv), 16, "sizeof(Ul_Us_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_Ui)");
    check_field_offset(lv, v1, 0, "Ul_Us_Ui.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_Ui.v2");
    check_field_offset(lv, v3, 12, "Ul_Us_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_Ui, Ul_Us_Ui)
//============================================================================


struct  Ul_Us_Ul  {
  __tsu64 v1;
  unsigned short v2;
  __tsu64 v3;
};
//SIG(1 Ul_Us_Ul) C1{ FL Fs FL}



static void Test_Ul_Us_Ul()
{
  {
    init_simple_test("Ul_Us_Ul");
    STRUCT_IF_C Ul_Us_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Us_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_Ul)");
    check_field_offset(lv, v1, 0, "Ul_Us_Ul.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Us_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_Ul, Ul_Us_Ul)
//============================================================================


struct  Ul_Us_Us  {
  __tsu64 v1;
  unsigned short v2;
  unsigned short v3;
};
//SIG(1 Ul_Us_Us) C1{ FL Fs[2]}



static void Test_Ul_Us_Us()
{
  {
    init_simple_test("Ul_Us_Us");
    STRUCT_IF_C Ul_Us_Us lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Us_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_Us)");
    check_field_offset(lv, v1, 0, "Ul_Us_Us.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_Us.v2");
    check_field_offset(lv, v3, 10, "Ul_Us_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_Us, Ul_Us_Us)
//============================================================================


struct  Ul_Us_Vp  {
  __tsu64 v1;
  unsigned short v2;
  void *v3;
};
//SIG(1 Ul_Us_Vp) C1{ FL Fs Fp}



static void Test_Ul_Us_Vp()
{
  {
    init_simple_test("Ul_Us_Vp");
    STRUCT_IF_C Ul_Us_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Us_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Us_Vp)");
    check_field_offset(lv, v1, 0, "Ul_Us_Vp.v1");
    check_field_offset(lv, v2, 8, "Ul_Us_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Us_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Us_Vp, Ul_Us_Vp)
//============================================================================


struct  Ul_Vp  {
  __tsu64 v1;
  void *v2;
};
//SIG(1 Ul_Vp) C1{ FL Fp}



static void Test_Ul_Vp()
{
  {
    init_simple_test("Ul_Vp");
    STRUCT_IF_C Ul_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Ul_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp)");
    check_field_offset(lv, v1, 0, "Ul_Vp.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp.v2");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp, Ul_Vp)
//============================================================================


struct  Ul_Vp_BFu15i  {
  __tsu64 v1;
  void *v2;
  unsigned int v3:15;
};
//SIG(1 Ul_Vp_BFu15i) C1{ FL Fp Fi:15}



static void Test_Ul_Vp_BFu15i()
{
  {
    init_simple_test("Ul_Vp_BFu15i");
    static STRUCT_IF_C Ul_Vp_BFu15i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu15i)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu15i.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu15i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "Ul_Vp_BFu15i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "Ul_Vp_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu15i, Ul_Vp_BFu15i)
//============================================================================


struct  Ul_Vp_BFu15ll  {
  __tsu64 v1;
  void *v2;
  __tsu64 v3:15;
};
//SIG(1 Ul_Vp_BFu15ll) C1{ FL Fp FL:15}



static void Test_Ul_Vp_BFu15ll()
{
  {
    init_simple_test("Ul_Vp_BFu15ll");
    static STRUCT_IF_C Ul_Vp_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu15ll)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu15ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu15ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "Ul_Vp_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "Ul_Vp_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu15ll, Ul_Vp_BFu15ll)
//============================================================================


struct  Ul_Vp_BFu15s  {
  __tsu64 v1;
  void *v2;
  unsigned short v3:15;
};
//SIG(1 Ul_Vp_BFu15s) C1{ FL Fp Fs:15}



static void Test_Ul_Vp_BFu15s()
{
  {
    init_simple_test("Ul_Vp_BFu15s");
    static STRUCT_IF_C Ul_Vp_BFu15s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu15s)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu15s.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu15s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, 1, "Ul_Vp_BFu15s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 15, hide_ull(1LL<<14), "Ul_Vp_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu15s, Ul_Vp_BFu15s)
//============================================================================


struct  Ul_Vp_BFu16i  {
  __tsu64 v1;
  void *v2;
  unsigned int v3:16;
};
//SIG(1 Ul_Vp_BFu16i) C1{ FL Fp Fi:16}



static void Test_Ul_Vp_BFu16i()
{
  {
    init_simple_test("Ul_Vp_BFu16i");
    static STRUCT_IF_C Ul_Vp_BFu16i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu16i)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu16i.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu16i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "Ul_Vp_BFu16i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "Ul_Vp_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu16i, Ul_Vp_BFu16i)
//============================================================================


struct  Ul_Vp_BFu16ll  {
  __tsu64 v1;
  void *v2;
  __tsu64 v3:16;
};
//SIG(1 Ul_Vp_BFu16ll) C1{ FL Fp FL:16}



static void Test_Ul_Vp_BFu16ll()
{
  {
    init_simple_test("Ul_Vp_BFu16ll");
    static STRUCT_IF_C Ul_Vp_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu16ll)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu16ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu16ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "Ul_Vp_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "Ul_Vp_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu16ll, Ul_Vp_BFu16ll)
//============================================================================


struct  Ul_Vp_BFu16s  {
  __tsu64 v1;
  void *v2;
  unsigned short v3:16;
};
//SIG(1 Ul_Vp_BFu16s) C1{ FL Fp Fs:16}



static void Test_Ul_Vp_BFu16s()
{
  {
    init_simple_test("Ul_Vp_BFu16s");
    static STRUCT_IF_C Ul_Vp_BFu16s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu16s)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu16s.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu16s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, 1, "Ul_Vp_BFu16s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 16, hide_ull(1LL<<15), "Ul_Vp_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu16s, Ul_Vp_BFu16s)
//============================================================================


struct  Ul_Vp_BFu17i  {
  __tsu64 v1;
  void *v2;
  unsigned int v3:17;
};
//SIG(1 Ul_Vp_BFu17i) C1{ FL Fp Fi:17}



static void Test_Ul_Vp_BFu17i()
{
  {
    init_simple_test("Ul_Vp_BFu17i");
    static STRUCT_IF_C Ul_Vp_BFu17i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu17i)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu17i.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu17i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "Ul_Vp_BFu17i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "Ul_Vp_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu17i, Ul_Vp_BFu17i)
//============================================================================


struct  Ul_Vp_BFu17ll  {
  __tsu64 v1;
  void *v2;
  __tsu64 v3:17;
};
//SIG(1 Ul_Vp_BFu17ll) C1{ FL Fp FL:17}



static void Test_Ul_Vp_BFu17ll()
{
  {
    init_simple_test("Ul_Vp_BFu17ll");
    static STRUCT_IF_C Ul_Vp_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu17ll)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu17ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu17ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, 1, "Ul_Vp_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 17, hide_ull(1LL<<16), "Ul_Vp_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu17ll, Ul_Vp_BFu17ll)
//============================================================================


struct  Ul_Vp_BFu1c  {
  __tsu64 v1;
  void *v2;
  unsigned char v3:1;
};
//SIG(1 Ul_Vp_BFu1c) C1{ FL Fp Fc:1}



static void Test_Ul_Vp_BFu1c()
{
  {
    init_simple_test("Ul_Vp_BFu1c");
    static STRUCT_IF_C Ul_Vp_BFu1c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu1c)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu1c.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu1c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Ul_Vp_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu1c, Ul_Vp_BFu1c)
//============================================================================


struct  Ul_Vp_BFu1i  {
  __tsu64 v1;
  void *v2;
  unsigned int v3:1;
};
//SIG(1 Ul_Vp_BFu1i) C1{ FL Fp Fi:1}



static void Test_Ul_Vp_BFu1i()
{
  {
    init_simple_test("Ul_Vp_BFu1i");
    static STRUCT_IF_C Ul_Vp_BFu1i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu1i)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu1i.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu1i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Ul_Vp_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu1i, Ul_Vp_BFu1i)
//============================================================================


struct  Ul_Vp_BFu1ll  {
  __tsu64 v1;
  void *v2;
  __tsu64 v3:1;
};
//SIG(1 Ul_Vp_BFu1ll) C1{ FL Fp FL:1}



static void Test_Ul_Vp_BFu1ll()
{
  {
    init_simple_test("Ul_Vp_BFu1ll");
    static STRUCT_IF_C Ul_Vp_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu1ll)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu1ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu1ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Ul_Vp_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu1ll, Ul_Vp_BFu1ll)
//============================================================================


struct  Ul_Vp_BFu1s  {
  __tsu64 v1;
  void *v2;
  unsigned short v3:1;
};
//SIG(1 Ul_Vp_BFu1s) C1{ FL Fp Fs:1}



static void Test_Ul_Vp_BFu1s()
{
  {
    init_simple_test("Ul_Vp_BFu1s");
    static STRUCT_IF_C Ul_Vp_BFu1s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu1s)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu1s.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu1s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 1, 1, "Ul_Vp_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu1s, Ul_Vp_BFu1s)
//============================================================================


struct  Ul_Vp_BFu31i  {
  __tsu64 v1;
  void *v2;
  unsigned int v3:31;
};
//SIG(1 Ul_Vp_BFu31i) C1{ FL Fp Fi:31}



static void Test_Ul_Vp_BFu31i()
{
  {
    init_simple_test("Ul_Vp_BFu31i");
    static STRUCT_IF_C Ul_Vp_BFu31i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu31i)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu31i.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu31i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "Ul_Vp_BFu31i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "Ul_Vp_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu31i, Ul_Vp_BFu31i)
//============================================================================


struct  Ul_Vp_BFu31ll  {
  __tsu64 v1;
  void *v2;
  __tsu64 v3:31;
};
//SIG(1 Ul_Vp_BFu31ll) C1{ FL Fp FL:31}



static void Test_Ul_Vp_BFu31ll()
{
  {
    init_simple_test("Ul_Vp_BFu31ll");
    static STRUCT_IF_C Ul_Vp_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu31ll)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu31ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu31ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, 1, "Ul_Vp_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 31, hide_ull(1LL<<30), "Ul_Vp_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu31ll, Ul_Vp_BFu31ll)
//============================================================================


struct  Ul_Vp_BFu32i  {
  __tsu64 v1;
  void *v2;
  unsigned int v3:32;
};
//SIG(1 Ul_Vp_BFu32i) C1{ FL Fp Fi:32}



static void Test_Ul_Vp_BFu32i()
{
  {
    init_simple_test("Ul_Vp_BFu32i");
    static STRUCT_IF_C Ul_Vp_BFu32i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu32i)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu32i.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu32i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "Ul_Vp_BFu32i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "Ul_Vp_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu32i, Ul_Vp_BFu32i)
//============================================================================


struct  Ul_Vp_BFu32ll  {
  __tsu64 v1;
  void *v2;
  __tsu64 v3:32;
};
//SIG(1 Ul_Vp_BFu32ll) C1{ FL Fp FL:32}



static void Test_Ul_Vp_BFu32ll()
{
  {
    init_simple_test("Ul_Vp_BFu32ll");
    static STRUCT_IF_C Ul_Vp_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu32ll)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu32ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu32ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, 1, "Ul_Vp_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 32, hide_ull(1LL<<31), "Ul_Vp_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu32ll, Ul_Vp_BFu32ll)
//============================================================================


struct  Ul_Vp_BFu33  {
  __tsu64 v1;
  void *v2;
  __tsu64 v3:33;
};
//SIG(1 Ul_Vp_BFu33) C1{ FL Fp FL:33}



static void Test_Ul_Vp_BFu33()
{
  {
    init_simple_test("Ul_Vp_BFu33");
    static STRUCT_IF_C Ul_Vp_BFu33 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Vp_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu33)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu33.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu33.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, 1, "Ul_Vp_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 33, hide_ull(1LL<<32), "Ul_Vp_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu33, Ul_Vp_BFu33)
//============================================================================


struct  Ul_Vp_BFu7c  {
  __tsu64 v1;
  void *v2;
  unsigned char v3:7;
};
//SIG(1 Ul_Vp_BFu7c) C1{ FL Fp Fc:7}



static void Test_Ul_Vp_BFu7c()
{
  {
    init_simple_test("Ul_Vp_BFu7c");
    static STRUCT_IF_C Ul_Vp_BFu7c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu7c)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu7c.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu7c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Ul_Vp_BFu7c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Ul_Vp_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu7c, Ul_Vp_BFu7c)
//============================================================================


struct  Ul_Vp_BFu7i  {
  __tsu64 v1;
  void *v2;
  unsigned int v3:7;
};
//SIG(1 Ul_Vp_BFu7i) C1{ FL Fp Fi:7}



static void Test_Ul_Vp_BFu7i()
{
  {
    init_simple_test("Ul_Vp_BFu7i");
    static STRUCT_IF_C Ul_Vp_BFu7i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu7i)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu7i.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu7i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Ul_Vp_BFu7i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Ul_Vp_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu7i, Ul_Vp_BFu7i)
//============================================================================


struct  Ul_Vp_BFu7ll  {
  __tsu64 v1;
  void *v2;
  __tsu64 v3:7;
};
//SIG(1 Ul_Vp_BFu7ll) C1{ FL Fp FL:7}



static void Test_Ul_Vp_BFu7ll()
{
  {
    init_simple_test("Ul_Vp_BFu7ll");
    static STRUCT_IF_C Ul_Vp_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu7ll)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu7ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu7ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Ul_Vp_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Ul_Vp_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu7ll, Ul_Vp_BFu7ll)
//============================================================================


struct  Ul_Vp_BFu7s  {
  __tsu64 v1;
  void *v2;
  unsigned short v3:7;
};
//SIG(1 Ul_Vp_BFu7s) C1{ FL Fp Fs:7}



static void Test_Ul_Vp_BFu7s()
{
  {
    init_simple_test("Ul_Vp_BFu7s");
    static STRUCT_IF_C Ul_Vp_BFu7s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu7s)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu7s.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu7s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, 1, "Ul_Vp_BFu7s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 7, hide_ull(1LL<<6), "Ul_Vp_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu7s, Ul_Vp_BFu7s)
//============================================================================


struct  Ul_Vp_BFu8c  {
  __tsu64 v1;
  void *v2;
  unsigned char v3:8;
};
//SIG(1 Ul_Vp_BFu8c) C1{ FL Fp Fc:8}



static void Test_Ul_Vp_BFu8c()
{
  {
    init_simple_test("Ul_Vp_BFu8c");
    static STRUCT_IF_C Ul_Vp_BFu8c lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu8c)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu8c.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu8c.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Ul_Vp_BFu8c");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Ul_Vp_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu8c, Ul_Vp_BFu8c)
//============================================================================


struct  Ul_Vp_BFu8i  {
  __tsu64 v1;
  void *v2;
  unsigned int v3:8;
};
//SIG(1 Ul_Vp_BFu8i) C1{ FL Fp Fi:8}



static void Test_Ul_Vp_BFu8i()
{
  {
    init_simple_test("Ul_Vp_BFu8i");
    static STRUCT_IF_C Ul_Vp_BFu8i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu8i)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu8i.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu8i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Ul_Vp_BFu8i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Ul_Vp_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu8i, Ul_Vp_BFu8i)
//============================================================================


struct  Ul_Vp_BFu8ll  {
  __tsu64 v1;
  void *v2;
  __tsu64 v3:8;
};
//SIG(1 Ul_Vp_BFu8ll) C1{ FL Fp FL:8}



static void Test_Ul_Vp_BFu8ll()
{
  {
    init_simple_test("Ul_Vp_BFu8ll");
    static STRUCT_IF_C Ul_Vp_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu8ll)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu8ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu8ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Ul_Vp_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Ul_Vp_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu8ll, Ul_Vp_BFu8ll)
//============================================================================


struct  Ul_Vp_BFu8s  {
  __tsu64 v1;
  void *v2;
  unsigned short v3:8;
};
//SIG(1 Ul_Vp_BFu8s) C1{ FL Fp Fs:8}



static void Test_Ul_Vp_BFu8s()
{
  {
    init_simple_test("Ul_Vp_BFu8s");
    static STRUCT_IF_C Ul_Vp_BFu8s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu8s)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu8s.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu8s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, 1, "Ul_Vp_BFu8s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 8, hide_ull(1LL<<7), "Ul_Vp_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu8s, Ul_Vp_BFu8s)
//============================================================================


struct  Ul_Vp_BFu9i  {
  __tsu64 v1;
  void *v2;
  unsigned int v3:9;
};
//SIG(1 Ul_Vp_BFu9i) C1{ FL Fp Fi:9}



static void Test_Ul_Vp_BFu9i()
{
  {
    init_simple_test("Ul_Vp_BFu9i");
    static STRUCT_IF_C Ul_Vp_BFu9i lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu9i)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu9i.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu9i.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Ul_Vp_BFu9i");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Ul_Vp_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu9i, Ul_Vp_BFu9i)
//============================================================================


struct  Ul_Vp_BFu9ll  {
  __tsu64 v1;
  void *v2;
  __tsu64 v3:9;
};
//SIG(1 Ul_Vp_BFu9ll) C1{ FL Fp FL:9}



static void Test_Ul_Vp_BFu9ll()
{
  {
    init_simple_test("Ul_Vp_BFu9ll");
    static STRUCT_IF_C Ul_Vp_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu9ll)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu9ll.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu9ll.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Ul_Vp_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Ul_Vp_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu9ll, Ul_Vp_BFu9ll)
//============================================================================


struct  Ul_Vp_BFu9s  {
  __tsu64 v1;
  void *v2;
  unsigned short v3:9;
};
//SIG(1 Ul_Vp_BFu9s) C1{ FL Fp Fs:9}



static void Test_Ul_Vp_BFu9s()
{
  {
    init_simple_test("Ul_Vp_BFu9s");
    static STRUCT_IF_C Ul_Vp_BFu9s lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_BFu9s)");
    check_field_offset(lv, v1, 0, "Ul_Vp_BFu9s.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_BFu9s.v2");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, 1, "Ul_Vp_BFu9s");
    set_bf_and_test(lv, v3, ABISELECT(16,12), 0, 9, hide_ull(1LL<<8), "Ul_Vp_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_BFu9s, Ul_Vp_BFu9s)
//============================================================================


struct  Ul_Vp_C  {
  __tsu64 v1;
  void *v2;
  char v3;
};
//SIG(1 Ul_Vp_C) C1{ FL Fp Fc}



static void Test_Ul_Vp_C()
{
  {
    init_simple_test("Ul_Vp_C");
    STRUCT_IF_C Ul_Vp_C lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_C)");
    check_field_offset(lv, v1, 0, "Ul_Vp_C.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_C.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Vp_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_C, Ul_Vp_C)
//============================================================================


struct  Ul_Vp_D  {
  __tsu64 v1;
  void *v2;
  double v3;
};
//SIG(1 Ul_Vp_D) C1{ FL Fp FL}



static void Test_Ul_Vp_D()
{
  {
    init_simple_test("Ul_Vp_D");
    STRUCT_IF_C Ul_Vp_D lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Vp_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_D)");
    check_field_offset(lv, v1, 0, "Ul_Vp_D.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_D.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Vp_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_D, Ul_Vp_D)
//============================================================================


struct  Ul_Vp_F  {
  __tsu64 v1;
  void *v2;
  float v3;
};
//SIG(1 Ul_Vp_F) C1{ FL Fp Fi}



static void Test_Ul_Vp_F()
{
  {
    init_simple_test("Ul_Vp_F");
    STRUCT_IF_C Ul_Vp_F lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_F)");
    check_field_offset(lv, v1, 0, "Ul_Vp_F.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_F.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Vp_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_F, Ul_Vp_F)
//============================================================================


struct  Ul_Vp_I  {
  __tsu64 v1;
  void *v2;
  int v3;
};
//SIG(1 Ul_Vp_I) C1{ FL Fp Fi}



static void Test_Ul_Vp_I()
{
  {
    init_simple_test("Ul_Vp_I");
    STRUCT_IF_C Ul_Vp_I lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_I)");
    check_field_offset(lv, v1, 0, "Ul_Vp_I.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_I.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Vp_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_I, Ul_Vp_I)
//============================================================================


struct  Ul_Vp_Ip  {
  __tsu64 v1;
  void *v2;
  int *v3;
};
//SIG(1 Ul_Vp_Ip) C1{ FL Fp[2]}



static void Test_Ul_Vp_Ip()
{
  {
    init_simple_test("Ul_Vp_Ip");
    STRUCT_IF_C Ul_Vp_Ip lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_Ip)");
    check_field_offset(lv, v1, 0, "Ul_Vp_Ip.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_Ip.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Vp_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_Ip, Ul_Vp_Ip)
//============================================================================


struct  Ul_Vp_L  {
  __tsu64 v1;
  void *v2;
  __tsi64 v3;
};
//SIG(1 Ul_Vp_L) C1{ FL Fp FL}



static void Test_Ul_Vp_L()
{
  {
    init_simple_test("Ul_Vp_L");
    STRUCT_IF_C Ul_Vp_L lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Vp_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_L)");
    check_field_offset(lv, v1, 0, "Ul_Vp_L.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_L.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Vp_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_L, Ul_Vp_L)
//============================================================================


struct  Ul_Vp_S  {
  __tsu64 v1;
  void *v2;
  short v3;
};
//SIG(1 Ul_Vp_S) C1{ FL Fp Fs}



static void Test_Ul_Vp_S()
{
  {
    init_simple_test("Ul_Vp_S");
    STRUCT_IF_C Ul_Vp_S lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_S)");
    check_field_offset(lv, v1, 0, "Ul_Vp_S.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_S.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Vp_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_S, Ul_Vp_S)
//============================================================================


struct  Ul_Vp_Uc  {
  __tsu64 v1;
  void *v2;
  unsigned char v3;
};
//SIG(1 Ul_Vp_Uc) C1{ FL Fp Fc}



static void Test_Ul_Vp_Uc()
{
  {
    init_simple_test("Ul_Vp_Uc");
    STRUCT_IF_C Ul_Vp_Uc lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_Uc)");
    check_field_offset(lv, v1, 0, "Ul_Vp_Uc.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_Uc.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Vp_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_Uc, Ul_Vp_Uc)
//============================================================================


struct  Ul_Vp_Ui  {
  __tsu64 v1;
  void *v2;
  unsigned int v3;
};
//SIG(1 Ul_Vp_Ui) C1{ FL Fp Fi}



static void Test_Ul_Vp_Ui()
{
  {
    init_simple_test("Ul_Vp_Ui");
    STRUCT_IF_C Ul_Vp_Ui lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_Ui)");
    check_field_offset(lv, v1, 0, "Ul_Vp_Ui.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_Ui.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Vp_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_Ui, Ul_Vp_Ui)
//============================================================================


struct  Ul_Vp_Ul  {
  __tsu64 v1;
  void *v2;
  __tsu64 v3;
};
//SIG(1 Ul_Vp_Ul) C1{ FL Fp FL}



static void Test_Ul_Vp_Ul()
{
  {
    init_simple_test("Ul_Vp_Ul");
    STRUCT_IF_C Ul_Vp_Ul lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(Ul_Vp_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_Ul)");
    check_field_offset(lv, v1, 0, "Ul_Vp_Ul.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_Ul.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Vp_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_Ul, Ul_Vp_Ul)
//============================================================================


struct  Ul_Vp_Us  {
  __tsu64 v1;
  void *v2;
  unsigned short v3;
};
//SIG(1 Ul_Vp_Us) C1{ FL Fp Fs}



static void Test_Ul_Vp_Us()
{
  {
    init_simple_test("Ul_Vp_Us");
    STRUCT_IF_C Ul_Vp_Us lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_Us)");
    check_field_offset(lv, v1, 0, "Ul_Vp_Us.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_Us.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Vp_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_Us, Ul_Vp_Us)
//============================================================================


struct  Ul_Vp_Vp  {
  __tsu64 v1;
  void *v2;
  void *v3;
};
//SIG(1 Ul_Vp_Vp) C1{ FL Fp[2]}



static void Test_Ul_Vp_Vp()
{
  {
    init_simple_test("Ul_Vp_Vp");
    STRUCT_IF_C Ul_Vp_Vp lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(Ul_Vp_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Ul_Vp_Vp)");
    check_field_offset(lv, v1, 0, "Ul_Vp_Vp.v1");
    check_field_offset(lv, v2, 8, "Ul_Vp_Vp.v2");
    check_field_offset(lv, v3, ABISELECT(16,12), "Ul_Vp_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Ul_Vp_Vp, Ul_Vp_Vp)
//============================================================================


struct  Us  {
  unsigned short v1;
};
//SIG(1 Us) C1{ Fs}



static void Test_Us()
{
  {
    init_simple_test("Us");
    STRUCT_IF_C Us lv;
    check2(sizeof(lv), 2, "sizeof(Us)");
    check2(__alignof__(lv), 2, "__alignof__(Us)");
    check_field_offset(lv, v1, 0, "Us.v1");
  }
}
ARRANGE_TO_CALL_ME(Test_Us, Us)
//============================================================================


struct  Us_BFu15i  {
  unsigned short v1;
  unsigned int v2:15;
};
//SIG(1 Us_BFu15i) C1{ Fs Fi:15}



static void Test_Us_BFu15i()
{
  {
    init_simple_test("Us_BFu15i");
    static STRUCT_IF_C Us_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i, Us_BFu15i)
//============================================================================


struct  Us_BFu15i_BFu15i  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned int v3:15;
};
//SIG(1 Us_BFu15i_BFu15i) C1{ Fs Fi:15 Fi:15}



static void Test_Us_BFu15i_BFu15i()
{
  {
    init_simple_test("Us_BFu15i_BFu15i");
    static STRUCT_IF_C Us_BFu15i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_BFu15i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu15i, Us_BFu15i_BFu15i)
//============================================================================


struct  Us_BFu15i_BFu15ll  {
  unsigned short v1;
  unsigned int v2:15;
  __tsu64 v3:15;
};
//SIG(1 Us_BFu15i_BFu15ll) C1{ Fs Fi:15 FL:15}



static void Test_Us_BFu15i_BFu15ll()
{
  {
    init_simple_test("Us_BFu15i_BFu15ll");
    static STRUCT_IF_C Us_BFu15i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "Us_BFu15i_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu15ll, Us_BFu15i_BFu15ll)
//============================================================================


struct  Us_BFu15i_BFu15s  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned short v3:15;
};
//SIG(1 Us_BFu15i_BFu15s) C1{ Fs Fi:15 Fs:15}



static void Test_Us_BFu15i_BFu15s()
{
  {
    init_simple_test("Us_BFu15i_BFu15s");
    static STRUCT_IF_C Us_BFu15i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_BFu15i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu15s, Us_BFu15i_BFu15s)
//============================================================================


struct  Us_BFu15i_BFu16i  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned int v3:16;
};
//SIG(1 Us_BFu15i_BFu16i) C1{ Fs Fi:15 Fi:16}



static void Test_Us_BFu15i_BFu16i()
{
  {
    init_simple_test("Us_BFu15i_BFu16i");
    static STRUCT_IF_C Us_BFu15i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu15i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu15i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu16i, Us_BFu15i_BFu16i)
//============================================================================


struct  Us_BFu15i_BFu16ll  {
  unsigned short v1;
  unsigned int v2:15;
  __tsu64 v3:16;
};
//SIG(1 Us_BFu15i_BFu16ll) C1{ Fs Fi:15 FL:16}



static void Test_Us_BFu15i_BFu16ll()
{
  {
    init_simple_test("Us_BFu15i_BFu16ll");
    static STRUCT_IF_C Us_BFu15i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "Us_BFu15i_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "Us_BFu15i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu16ll, Us_BFu15i_BFu16ll)
//============================================================================


struct  Us_BFu15i_BFu16s  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned short v3:16;
};
//SIG(1 Us_BFu15i_BFu16s) C1{ Fs Fi:15 Fs:16}



static void Test_Us_BFu15i_BFu16s()
{
  {
    init_simple_test("Us_BFu15i_BFu16s");
    static STRUCT_IF_C Us_BFu15i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu15i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu15i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu16s, Us_BFu15i_BFu16s)
//============================================================================


struct  Us_BFu15i_BFu17i  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned int v3:17;
};
//SIG(1 Us_BFu15i_BFu17i) C1{ Fs Fi:15 Fi:17}



static void Test_Us_BFu15i_BFu17i()
{
  {
    init_simple_test("Us_BFu15i_BFu17i");
    static STRUCT_IF_C Us_BFu15i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Us_BFu15i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu15i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu17i, Us_BFu15i_BFu17i)
//============================================================================


struct  Us_BFu15i_BFu17ll  {
  unsigned short v1;
  unsigned int v2:15;
  __tsu64 v3:17;
};
//SIG(1 Us_BFu15i_BFu17ll) C1{ Fs Fi:15 FL:17}



static void Test_Us_BFu15i_BFu17ll()
{
  {
    init_simple_test("Us_BFu15i_BFu17ll");
    static STRUCT_IF_C Us_BFu15i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "Us_BFu15i_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "Us_BFu15i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu17ll, Us_BFu15i_BFu17ll)
//============================================================================


struct  Us_BFu15i_BFu1c  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned char v3:1;
};
//SIG(1 Us_BFu15i_BFu1c) C1{ Fs Fi:15 Fc:1}



static void Test_Us_BFu15i_BFu1c()
{
  {
    init_simple_test("Us_BFu15i_BFu1c");
    static STRUCT_IF_C Us_BFu15i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu15i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu1c");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "Us_BFu15i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu1c, Us_BFu15i_BFu1c)
//============================================================================


struct  Us_BFu15i_BFu1i  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned int v3:1;
};
//SIG(1 Us_BFu15i_BFu1i) C1{ Fs Fi:15 Fi:1}



static void Test_Us_BFu15i_BFu1i()
{
  {
    init_simple_test("Us_BFu15i_BFu1i");
    static STRUCT_IF_C Us_BFu15i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu15i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu1i");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "Us_BFu15i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu1i, Us_BFu15i_BFu1i)
//============================================================================


struct  Us_BFu15i_BFu1ll  {
  unsigned short v1;
  unsigned int v2:15;
  __tsu64 v3:1;
};
//SIG(1 Us_BFu15i_BFu1ll) C1{ Fs Fi:15 FL:1}



static void Test_Us_BFu15i_BFu1ll()
{
  {
    init_simple_test("Us_BFu15i_BFu1ll");
    static STRUCT_IF_C Us_BFu15i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu15i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu1ll");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "Us_BFu15i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu1ll, Us_BFu15i_BFu1ll)
//============================================================================


struct  Us_BFu15i_BFu1s  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned short v3:1;
};
//SIG(1 Us_BFu15i_BFu1s) C1{ Fs Fi:15 Fs:1}



static void Test_Us_BFu15i_BFu1s()
{
  {
    init_simple_test("Us_BFu15i_BFu1s");
    static STRUCT_IF_C Us_BFu15i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu15i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu1s");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "Us_BFu15i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu1s, Us_BFu15i_BFu1s)
//============================================================================


struct  Us_BFu15i_BFu31i  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned int v3:31;
};
//SIG(1 Us_BFu15i_BFu31i) C1{ Fs Fi:15 Fi:31}



static void Test_Us_BFu15i_BFu31i()
{
  {
    init_simple_test("Us_BFu15i_BFu31i");
    static STRUCT_IF_C Us_BFu15i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Us_BFu15i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu15i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu31i, Us_BFu15i_BFu31i)
//============================================================================


struct  Us_BFu15i_BFu31ll  {
  unsigned short v1;
  unsigned int v2:15;
  __tsu64 v3:31;
};
//SIG(1 Us_BFu15i_BFu31ll) C1{ Fs Fi:15 FL:31}



static void Test_Us_BFu15i_BFu31ll()
{
  {
    init_simple_test("Us_BFu15i_BFu31ll");
    static STRUCT_IF_C Us_BFu15i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "Us_BFu15i_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "Us_BFu15i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu31ll, Us_BFu15i_BFu31ll)
//============================================================================


struct  Us_BFu15i_BFu32i  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned int v3:32;
};
//SIG(1 Us_BFu15i_BFu32i) C1{ Fs Fi:15 Fi:32}



static void Test_Us_BFu15i_BFu32i()
{
  {
    init_simple_test("Us_BFu15i_BFu32i");
    static STRUCT_IF_C Us_BFu15i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Us_BFu15i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu15i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu32i, Us_BFu15i_BFu32i)
//============================================================================


struct  Us_BFu15i_BFu32ll  {
  unsigned short v1;
  unsigned int v2:15;
  __tsu64 v3:32;
};
//SIG(1 Us_BFu15i_BFu32ll) C1{ Fs Fi:15 FL:32}



static void Test_Us_BFu15i_BFu32ll()
{
  {
    init_simple_test("Us_BFu15i_BFu32ll");
    static STRUCT_IF_C Us_BFu15i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "Us_BFu15i_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "Us_BFu15i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu32ll, Us_BFu15i_BFu32ll)
//============================================================================


struct  Us_BFu15i_BFu33  {
  unsigned short v1;
  unsigned int v2:15;
  __tsu64 v3:33;
};
//SIG(1 Us_BFu15i_BFu33) C1{ Fs Fi:15 FL:33}



static void Test_Us_BFu15i_BFu33()
{
  {
    init_simple_test("Us_BFu15i_BFu33");
    static STRUCT_IF_C Us_BFu15i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15i_BFu33)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, 1, "Us_BFu15i_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, hide_ull(1LL<<32), "Us_BFu15i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu33, Us_BFu15i_BFu33)
//============================================================================


struct  Us_BFu15i_BFu7c  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned char v3:7;
};
//SIG(1 Us_BFu15i_BFu7c) C1{ Fs Fi:15 Fc:7}



static void Test_Us_BFu15i_BFu7c()
{
  {
    init_simple_test("Us_BFu15i_BFu7c");
    static STRUCT_IF_C Us_BFu15i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu15i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu15i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu7c, Us_BFu15i_BFu7c)
//============================================================================


struct  Us_BFu15i_BFu7i  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned int v3:7;
};
//SIG(1 Us_BFu15i_BFu7i) C1{ Fs Fi:15 Fi:7}



static void Test_Us_BFu15i_BFu7i()
{
  {
    init_simple_test("Us_BFu15i_BFu7i");
    static STRUCT_IF_C Us_BFu15i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu15i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu15i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu7i, Us_BFu15i_BFu7i)
//============================================================================


struct  Us_BFu15i_BFu7ll  {
  unsigned short v1;
  unsigned int v2:15;
  __tsu64 v3:7;
};
//SIG(1 Us_BFu15i_BFu7ll) C1{ Fs Fi:15 FL:7}



static void Test_Us_BFu15i_BFu7ll()
{
  {
    init_simple_test("Us_BFu15i_BFu7ll");
    static STRUCT_IF_C Us_BFu15i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "Us_BFu15i_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "Us_BFu15i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu7ll, Us_BFu15i_BFu7ll)
//============================================================================


struct  Us_BFu15i_BFu7s  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned short v3:7;
};
//SIG(1 Us_BFu15i_BFu7s) C1{ Fs Fi:15 Fs:7}



static void Test_Us_BFu15i_BFu7s()
{
  {
    init_simple_test("Us_BFu15i_BFu7s");
    static STRUCT_IF_C Us_BFu15i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu15i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu15i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu7s, Us_BFu15i_BFu7s)
//============================================================================


struct  Us_BFu15i_BFu8c  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned char v3:8;
};
//SIG(1 Us_BFu15i_BFu8c) C1{ Fs Fi:15 Fc:8}



static void Test_Us_BFu15i_BFu8c()
{
  {
    init_simple_test("Us_BFu15i_BFu8c");
    static STRUCT_IF_C Us_BFu15i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu15i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu15i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu8c, Us_BFu15i_BFu8c)
//============================================================================


struct  Us_BFu15i_BFu8i  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned int v3:8;
};
//SIG(1 Us_BFu15i_BFu8i) C1{ Fs Fi:15 Fi:8}



static void Test_Us_BFu15i_BFu8i()
{
  {
    init_simple_test("Us_BFu15i_BFu8i");
    static STRUCT_IF_C Us_BFu15i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu15i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu15i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu8i, Us_BFu15i_BFu8i)
//============================================================================


struct  Us_BFu15i_BFu8ll  {
  unsigned short v1;
  unsigned int v2:15;
  __tsu64 v3:8;
};
//SIG(1 Us_BFu15i_BFu8ll) C1{ Fs Fi:15 FL:8}



static void Test_Us_BFu15i_BFu8ll()
{
  {
    init_simple_test("Us_BFu15i_BFu8ll");
    static STRUCT_IF_C Us_BFu15i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "Us_BFu15i_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "Us_BFu15i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu8ll, Us_BFu15i_BFu8ll)
//============================================================================


struct  Us_BFu15i_BFu8s  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned short v3:8;
};
//SIG(1 Us_BFu15i_BFu8s) C1{ Fs Fi:15 Fs:8}



static void Test_Us_BFu15i_BFu8s()
{
  {
    init_simple_test("Us_BFu15i_BFu8s");
    static STRUCT_IF_C Us_BFu15i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu15i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu15i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu8s, Us_BFu15i_BFu8s)
//============================================================================


struct  Us_BFu15i_BFu9i  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned int v3:9;
};
//SIG(1 Us_BFu15i_BFu9i) C1{ Fs Fi:15 Fi:9}



static void Test_Us_BFu15i_BFu9i()
{
  {
    init_simple_test("Us_BFu15i_BFu9i");
    static STRUCT_IF_C Us_BFu15i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_BFu15i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_BFu15i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu9i, Us_BFu15i_BFu9i)
//============================================================================


struct  Us_BFu15i_BFu9ll  {
  unsigned short v1;
  unsigned int v2:15;
  __tsu64 v3:9;
};
//SIG(1 Us_BFu15i_BFu9ll) C1{ Fs Fi:15 FL:9}



static void Test_Us_BFu15i_BFu9ll()
{
  {
    init_simple_test("Us_BFu15i_BFu9ll");
    static STRUCT_IF_C Us_BFu15i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "Us_BFu15i_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "Us_BFu15i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu9ll, Us_BFu15i_BFu9ll)
//============================================================================


struct  Us_BFu15i_BFu9s  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned short v3:9;
};
//SIG(1 Us_BFu15i_BFu9s) C1{ Fs Fi:15 Fs:9}



static void Test_Us_BFu15i_BFu9s()
{
  {
    init_simple_test("Us_BFu15i_BFu9s");
    static STRUCT_IF_C Us_BFu15i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_BFu15i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_BFu15i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_BFu9s, Us_BFu15i_BFu9s)
//============================================================================


struct  Us_BFu15i_C  {
  unsigned short v1;
  unsigned int v2:15;
  char v3;
};
//SIG(1 Us_BFu15i_C) C1{ Fs Fi:15 Fc}



static void Test_Us_BFu15i_C()
{
  {
    init_simple_test("Us_BFu15i_C");
    static STRUCT_IF_C Us_BFu15i_C lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_C)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_C");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_C");
    check_field_offset(lv, v3, 4, "Us_BFu15i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_C, Us_BFu15i_C)
//============================================================================


struct  Us_BFu15i_D  {
  unsigned short v1;
  unsigned int v2:15;
  double v3;
};
//SIG(1 Us_BFu15i_D) C1{ Fs Fi:15 FL}



static void Test_Us_BFu15i_D()
{
  {
    init_simple_test("Us_BFu15i_D");
    static STRUCT_IF_C Us_BFu15i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu15i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15i_D)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_D");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu15i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_D, Us_BFu15i_D)
//============================================================================


struct  Us_BFu15i_F  {
  unsigned short v1;
  unsigned int v2:15;
  float v3;
};
//SIG(1 Us_BFu15i_F) C1{ Fs Fi:15 Fi}



static void Test_Us_BFu15i_F()
{
  {
    init_simple_test("Us_BFu15i_F");
    static STRUCT_IF_C Us_BFu15i_F lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_F)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_F");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_F");
    check_field_offset(lv, v3, 4, "Us_BFu15i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_F, Us_BFu15i_F)
//============================================================================


struct  Us_BFu15i_I  {
  unsigned short v1;
  unsigned int v2:15;
  int v3;
};
//SIG(1 Us_BFu15i_I) C1{ Fs Fi:15 Fi}



static void Test_Us_BFu15i_I()
{
  {
    init_simple_test("Us_BFu15i_I");
    static STRUCT_IF_C Us_BFu15i_I lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_I)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_I");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_I");
    check_field_offset(lv, v3, 4, "Us_BFu15i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_I, Us_BFu15i_I)
//============================================================================


struct  Us_BFu15i_Ip  {
  unsigned short v1;
  unsigned int v2:15;
  int *v3;
};
//SIG(1 Us_BFu15i_Ip) C1{ Fs Fi:15 Fp}



static void Test_Us_BFu15i_Ip()
{
  {
    init_simple_test("Us_BFu15i_Ip");
    static STRUCT_IF_C Us_BFu15i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu15i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15i_Ip)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu15i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_Ip, Us_BFu15i_Ip)
//============================================================================


struct  Us_BFu15i_L  {
  unsigned short v1;
  unsigned int v2:15;
  __tsi64 v3;
};
//SIG(1 Us_BFu15i_L) C1{ Fs Fi:15 FL}



static void Test_Us_BFu15i_L()
{
  {
    init_simple_test("Us_BFu15i_L");
    static STRUCT_IF_C Us_BFu15i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu15i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15i_L)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_L");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu15i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_L, Us_BFu15i_L)
//============================================================================


struct  Us_BFu15i_S  {
  unsigned short v1;
  unsigned int v2:15;
  short v3;
};
//SIG(1 Us_BFu15i_S) C1{ Fs Fi:15 Fs}



static void Test_Us_BFu15i_S()
{
  {
    init_simple_test("Us_BFu15i_S");
    static STRUCT_IF_C Us_BFu15i_S lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_S)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_S");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_S");
    check_field_offset(lv, v3, 4, "Us_BFu15i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_S, Us_BFu15i_S)
//============================================================================


struct  Us_BFu15i_Uc  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned char v3;
};
//SIG(1 Us_BFu15i_Uc) C1{ Fs Fi:15 Fc}



static void Test_Us_BFu15i_Uc()
{
  {
    init_simple_test("Us_BFu15i_Uc");
    static STRUCT_IF_C Us_BFu15i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_Uc)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_Uc");
    check_field_offset(lv, v3, 4, "Us_BFu15i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_Uc, Us_BFu15i_Uc)
//============================================================================


struct  Us_BFu15i_Ui  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned int v3;
};
//SIG(1 Us_BFu15i_Ui) C1{ Fs Fi:15 Fi}



static void Test_Us_BFu15i_Ui()
{
  {
    init_simple_test("Us_BFu15i_Ui");
    static STRUCT_IF_C Us_BFu15i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_Ui)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_Ui");
    check_field_offset(lv, v3, 4, "Us_BFu15i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_Ui, Us_BFu15i_Ui)
//============================================================================


struct  Us_BFu15i_Ul  {
  unsigned short v1;
  unsigned int v2:15;
  __tsu64 v3;
};
//SIG(1 Us_BFu15i_Ul) C1{ Fs Fi:15 FL}



static void Test_Us_BFu15i_Ul()
{
  {
    init_simple_test("Us_BFu15i_Ul");
    static STRUCT_IF_C Us_BFu15i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu15i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15i_Ul)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu15i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_Ul, Us_BFu15i_Ul)
//============================================================================


struct  Us_BFu15i_Us  {
  unsigned short v1;
  unsigned int v2:15;
  unsigned short v3;
};
//SIG(1 Us_BFu15i_Us) C1{ Fs Fi:15 Fs}



static void Test_Us_BFu15i_Us()
{
  {
    init_simple_test("Us_BFu15i_Us");
    static STRUCT_IF_C Us_BFu15i_Us lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15i_Us)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_Us");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_Us");
    check_field_offset(lv, v3, 4, "Us_BFu15i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_Us, Us_BFu15i_Us)
//============================================================================


struct  Us_BFu15i_Vp  {
  unsigned short v1;
  unsigned int v2:15;
  void *v3;
};
//SIG(1 Us_BFu15i_Vp) C1{ Fs Fi:15 Fp}



static void Test_Us_BFu15i_Vp()
{
  {
    init_simple_test("Us_BFu15i_Vp");
    static STRUCT_IF_C Us_BFu15i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu15i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15i_Vp)");
    check_field_offset(lv, v1, 0, "Us_BFu15i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu15i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15i_Vp, Us_BFu15i_Vp)
//============================================================================


struct  Us_BFu15ll  {
  unsigned short v1;
  __tsu64 v2:15;
};
//SIG(1 Us_BFu15ll) C1{ Fs FL:15}



static void Test_Us_BFu15ll()
{
  {
    init_simple_test("Us_BFu15ll");
    static STRUCT_IF_C Us_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll, Us_BFu15ll)
//============================================================================


struct  Us_BFu15ll_BFu15i  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned int v3:15;
};
//SIG(1 Us_BFu15ll_BFu15i) C1{ Fs FL:15 Fi:15}



static void Test_Us_BFu15ll_BFu15i()
{
  {
    init_simple_test("Us_BFu15ll_BFu15i");
    static STRUCT_IF_C Us_BFu15ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_BFu15ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu15i, Us_BFu15ll_BFu15i)
//============================================================================


struct  Us_BFu15ll_BFu15ll  {
  unsigned short v1;
  __tsu64 v2:15;
  __tsu64 v3:15;
};
//SIG(1 Us_BFu15ll_BFu15ll) C1{ Fs FL:15 FL:15}



static void Test_Us_BFu15ll_BFu15ll()
{
  {
    init_simple_test("Us_BFu15ll_BFu15ll");
    static STRUCT_IF_C Us_BFu15ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "Us_BFu15ll_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu15ll, Us_BFu15ll_BFu15ll)
//============================================================================


struct  Us_BFu15ll_BFu15s  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned short v3:15;
};
//SIG(1 Us_BFu15ll_BFu15s) C1{ Fs FL:15 Fs:15}



static void Test_Us_BFu15ll_BFu15s()
{
  {
    init_simple_test("Us_BFu15ll_BFu15s");
    static STRUCT_IF_C Us_BFu15ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_BFu15ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu15s, Us_BFu15ll_BFu15s)
//============================================================================


struct  Us_BFu15ll_BFu16i  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned int v3:16;
};
//SIG(1 Us_BFu15ll_BFu16i) C1{ Fs FL:15 Fi:16}



static void Test_Us_BFu15ll_BFu16i()
{
  {
    init_simple_test("Us_BFu15ll_BFu16i");
    static STRUCT_IF_C Us_BFu15ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu15ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu15ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu16i, Us_BFu15ll_BFu16i)
//============================================================================


struct  Us_BFu15ll_BFu16ll  {
  unsigned short v1;
  __tsu64 v2:15;
  __tsu64 v3:16;
};
//SIG(1 Us_BFu15ll_BFu16ll) C1{ Fs FL:15 FL:16}



static void Test_Us_BFu15ll_BFu16ll()
{
  {
    init_simple_test("Us_BFu15ll_BFu16ll");
    static STRUCT_IF_C Us_BFu15ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "Us_BFu15ll_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "Us_BFu15ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu16ll, Us_BFu15ll_BFu16ll)
//============================================================================


struct  Us_BFu15ll_BFu16s  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned short v3:16;
};
//SIG(1 Us_BFu15ll_BFu16s) C1{ Fs FL:15 Fs:16}



static void Test_Us_BFu15ll_BFu16s()
{
  {
    init_simple_test("Us_BFu15ll_BFu16s");
    static STRUCT_IF_C Us_BFu15ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu15ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu15ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu16s, Us_BFu15ll_BFu16s)
//============================================================================


struct  Us_BFu15ll_BFu17i  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned int v3:17;
};
//SIG(1 Us_BFu15ll_BFu17i) C1{ Fs FL:15 Fi:17}



static void Test_Us_BFu15ll_BFu17i()
{
  {
    init_simple_test("Us_BFu15ll_BFu17i");
    static STRUCT_IF_C Us_BFu15ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Us_BFu15ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu15ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu17i, Us_BFu15ll_BFu17i)
//============================================================================


struct  Us_BFu15ll_BFu17ll  {
  unsigned short v1;
  __tsu64 v2:15;
  __tsu64 v3:17;
};
//SIG(1 Us_BFu15ll_BFu17ll) C1{ Fs FL:15 FL:17}



static void Test_Us_BFu15ll_BFu17ll()
{
  {
    init_simple_test("Us_BFu15ll_BFu17ll");
    static STRUCT_IF_C Us_BFu15ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "Us_BFu15ll_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "Us_BFu15ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu17ll, Us_BFu15ll_BFu17ll)
//============================================================================


struct  Us_BFu15ll_BFu1c  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned char v3:1;
};
//SIG(1 Us_BFu15ll_BFu1c) C1{ Fs FL:15 Fc:1}



static void Test_Us_BFu15ll_BFu1c()
{
  {
    init_simple_test("Us_BFu15ll_BFu1c");
    static STRUCT_IF_C Us_BFu15ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu15ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu1c");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "Us_BFu15ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu1c, Us_BFu15ll_BFu1c)
//============================================================================


struct  Us_BFu15ll_BFu1i  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned int v3:1;
};
//SIG(1 Us_BFu15ll_BFu1i) C1{ Fs FL:15 Fi:1}



static void Test_Us_BFu15ll_BFu1i()
{
  {
    init_simple_test("Us_BFu15ll_BFu1i");
    static STRUCT_IF_C Us_BFu15ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu15ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu1i");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "Us_BFu15ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu1i, Us_BFu15ll_BFu1i)
//============================================================================


struct  Us_BFu15ll_BFu1ll  {
  unsigned short v1;
  __tsu64 v2:15;
  __tsu64 v3:1;
};
//SIG(1 Us_BFu15ll_BFu1ll) C1{ Fs FL:15 FL:1}



static void Test_Us_BFu15ll_BFu1ll()
{
  {
    init_simple_test("Us_BFu15ll_BFu1ll");
    static STRUCT_IF_C Us_BFu15ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu15ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu1ll");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "Us_BFu15ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu1ll, Us_BFu15ll_BFu1ll)
//============================================================================


struct  Us_BFu15ll_BFu1s  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned short v3:1;
};
//SIG(1 Us_BFu15ll_BFu1s) C1{ Fs FL:15 Fs:1}



static void Test_Us_BFu15ll_BFu1s()
{
  {
    init_simple_test("Us_BFu15ll_BFu1s");
    static STRUCT_IF_C Us_BFu15ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu15ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu1s");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "Us_BFu15ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu1s, Us_BFu15ll_BFu1s)
//============================================================================


struct  Us_BFu15ll_BFu31i  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned int v3:31;
};
//SIG(1 Us_BFu15ll_BFu31i) C1{ Fs FL:15 Fi:31}



static void Test_Us_BFu15ll_BFu31i()
{
  {
    init_simple_test("Us_BFu15ll_BFu31i");
    static STRUCT_IF_C Us_BFu15ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Us_BFu15ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu15ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu31i, Us_BFu15ll_BFu31i)
//============================================================================


struct  Us_BFu15ll_BFu31ll  {
  unsigned short v1;
  __tsu64 v2:15;
  __tsu64 v3:31;
};
//SIG(1 Us_BFu15ll_BFu31ll) C1{ Fs FL:15 FL:31}



static void Test_Us_BFu15ll_BFu31ll()
{
  {
    init_simple_test("Us_BFu15ll_BFu31ll");
    static STRUCT_IF_C Us_BFu15ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "Us_BFu15ll_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "Us_BFu15ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu31ll, Us_BFu15ll_BFu31ll)
//============================================================================


struct  Us_BFu15ll_BFu32i  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned int v3:32;
};
//SIG(1 Us_BFu15ll_BFu32i) C1{ Fs FL:15 Fi:32}



static void Test_Us_BFu15ll_BFu32i()
{
  {
    init_simple_test("Us_BFu15ll_BFu32i");
    static STRUCT_IF_C Us_BFu15ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Us_BFu15ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu15ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu32i, Us_BFu15ll_BFu32i)
//============================================================================


struct  Us_BFu15ll_BFu32ll  {
  unsigned short v1;
  __tsu64 v2:15;
  __tsu64 v3:32;
};
//SIG(1 Us_BFu15ll_BFu32ll) C1{ Fs FL:15 FL:32}



static void Test_Us_BFu15ll_BFu32ll()
{
  {
    init_simple_test("Us_BFu15ll_BFu32ll");
    static STRUCT_IF_C Us_BFu15ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "Us_BFu15ll_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "Us_BFu15ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu32ll, Us_BFu15ll_BFu32ll)
//============================================================================


struct  Us_BFu15ll_BFu33  {
  unsigned short v1;
  __tsu64 v2:15;
  __tsu64 v3:33;
};
//SIG(1 Us_BFu15ll_BFu33) C1{ Fs FL:15 FL:33}



static void Test_Us_BFu15ll_BFu33()
{
  {
    init_simple_test("Us_BFu15ll_BFu33");
    static STRUCT_IF_C Us_BFu15ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu33)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, 1, "Us_BFu15ll_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, hide_ull(1LL<<32), "Us_BFu15ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu33, Us_BFu15ll_BFu33)
//============================================================================


struct  Us_BFu15ll_BFu7c  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned char v3:7;
};
//SIG(1 Us_BFu15ll_BFu7c) C1{ Fs FL:15 Fc:7}



static void Test_Us_BFu15ll_BFu7c()
{
  {
    init_simple_test("Us_BFu15ll_BFu7c");
    static STRUCT_IF_C Us_BFu15ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu15ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu15ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu7c, Us_BFu15ll_BFu7c)
//============================================================================


struct  Us_BFu15ll_BFu7i  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned int v3:7;
};
//SIG(1 Us_BFu15ll_BFu7i) C1{ Fs FL:15 Fi:7}



static void Test_Us_BFu15ll_BFu7i()
{
  {
    init_simple_test("Us_BFu15ll_BFu7i");
    static STRUCT_IF_C Us_BFu15ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu15ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu15ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu7i, Us_BFu15ll_BFu7i)
//============================================================================


struct  Us_BFu15ll_BFu7ll  {
  unsigned short v1;
  __tsu64 v2:15;
  __tsu64 v3:7;
};
//SIG(1 Us_BFu15ll_BFu7ll) C1{ Fs FL:15 FL:7}



static void Test_Us_BFu15ll_BFu7ll()
{
  {
    init_simple_test("Us_BFu15ll_BFu7ll");
    static STRUCT_IF_C Us_BFu15ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "Us_BFu15ll_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "Us_BFu15ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu7ll, Us_BFu15ll_BFu7ll)
//============================================================================


struct  Us_BFu15ll_BFu7s  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned short v3:7;
};
//SIG(1 Us_BFu15ll_BFu7s) C1{ Fs FL:15 Fs:7}



static void Test_Us_BFu15ll_BFu7s()
{
  {
    init_simple_test("Us_BFu15ll_BFu7s");
    static STRUCT_IF_C Us_BFu15ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu15ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu15ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu7s, Us_BFu15ll_BFu7s)
//============================================================================


struct  Us_BFu15ll_BFu8c  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned char v3:8;
};
//SIG(1 Us_BFu15ll_BFu8c) C1{ Fs FL:15 Fc:8}



static void Test_Us_BFu15ll_BFu8c()
{
  {
    init_simple_test("Us_BFu15ll_BFu8c");
    static STRUCT_IF_C Us_BFu15ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu15ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu15ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu8c, Us_BFu15ll_BFu8c)
//============================================================================


struct  Us_BFu15ll_BFu8i  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned int v3:8;
};
//SIG(1 Us_BFu15ll_BFu8i) C1{ Fs FL:15 Fi:8}



static void Test_Us_BFu15ll_BFu8i()
{
  {
    init_simple_test("Us_BFu15ll_BFu8i");
    static STRUCT_IF_C Us_BFu15ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu15ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu15ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu8i, Us_BFu15ll_BFu8i)
//============================================================================


struct  Us_BFu15ll_BFu8ll  {
  unsigned short v1;
  __tsu64 v2:15;
  __tsu64 v3:8;
};
//SIG(1 Us_BFu15ll_BFu8ll) C1{ Fs FL:15 FL:8}



static void Test_Us_BFu15ll_BFu8ll()
{
  {
    init_simple_test("Us_BFu15ll_BFu8ll");
    static STRUCT_IF_C Us_BFu15ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "Us_BFu15ll_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "Us_BFu15ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu8ll, Us_BFu15ll_BFu8ll)
//============================================================================


struct  Us_BFu15ll_BFu8s  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned short v3:8;
};
//SIG(1 Us_BFu15ll_BFu8s) C1{ Fs FL:15 Fs:8}



static void Test_Us_BFu15ll_BFu8s()
{
  {
    init_simple_test("Us_BFu15ll_BFu8s");
    static STRUCT_IF_C Us_BFu15ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu15ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu15ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu8s, Us_BFu15ll_BFu8s)
//============================================================================


struct  Us_BFu15ll_BFu9i  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned int v3:9;
};
//SIG(1 Us_BFu15ll_BFu9i) C1{ Fs FL:15 Fi:9}



static void Test_Us_BFu15ll_BFu9i()
{
  {
    init_simple_test("Us_BFu15ll_BFu9i");
    static STRUCT_IF_C Us_BFu15ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_BFu15ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_BFu15ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu9i, Us_BFu15ll_BFu9i)
//============================================================================


struct  Us_BFu15ll_BFu9ll  {
  unsigned short v1;
  __tsu64 v2:15;
  __tsu64 v3:9;
};
//SIG(1 Us_BFu15ll_BFu9ll) C1{ Fs FL:15 FL:9}



static void Test_Us_BFu15ll_BFu9ll()
{
  {
    init_simple_test("Us_BFu15ll_BFu9ll");
    static STRUCT_IF_C Us_BFu15ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "Us_BFu15ll_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "Us_BFu15ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu9ll, Us_BFu15ll_BFu9ll)
//============================================================================


struct  Us_BFu15ll_BFu9s  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned short v3:9;
};
//SIG(1 Us_BFu15ll_BFu9s) C1{ Fs FL:15 Fs:9}



static void Test_Us_BFu15ll_BFu9s()
{
  {
    init_simple_test("Us_BFu15ll_BFu9s");
    static STRUCT_IF_C Us_BFu15ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_BFu15ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_BFu15ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_BFu9s, Us_BFu15ll_BFu9s)
//============================================================================


struct  Us_BFu15ll_C  {
  unsigned short v1;
  __tsu64 v2:15;
  char v3;
};
//SIG(1 Us_BFu15ll_C) C1{ Fs FL:15 Fc}



static void Test_Us_BFu15ll_C()
{
  {
    init_simple_test("Us_BFu15ll_C");
    static STRUCT_IF_C Us_BFu15ll_C lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_C)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_C");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_C");
    check_field_offset(lv, v3, 4, "Us_BFu15ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_C, Us_BFu15ll_C)
//============================================================================


struct  Us_BFu15ll_D  {
  unsigned short v1;
  __tsu64 v2:15;
  double v3;
};
//SIG(1 Us_BFu15ll_D) C1{ Fs FL:15 FL}



static void Test_Us_BFu15ll_D()
{
  {
    init_simple_test("Us_BFu15ll_D");
    static STRUCT_IF_C Us_BFu15ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu15ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_D)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_D");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu15ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_D, Us_BFu15ll_D)
//============================================================================


struct  Us_BFu15ll_F  {
  unsigned short v1;
  __tsu64 v2:15;
  float v3;
};
//SIG(1 Us_BFu15ll_F) C1{ Fs FL:15 Fi}



static void Test_Us_BFu15ll_F()
{
  {
    init_simple_test("Us_BFu15ll_F");
    static STRUCT_IF_C Us_BFu15ll_F lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_F)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_F");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_F");
    check_field_offset(lv, v3, 4, "Us_BFu15ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_F, Us_BFu15ll_F)
//============================================================================


struct  Us_BFu15ll_I  {
  unsigned short v1;
  __tsu64 v2:15;
  int v3;
};
//SIG(1 Us_BFu15ll_I) C1{ Fs FL:15 Fi}



static void Test_Us_BFu15ll_I()
{
  {
    init_simple_test("Us_BFu15ll_I");
    static STRUCT_IF_C Us_BFu15ll_I lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_I)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_I");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_I");
    check_field_offset(lv, v3, 4, "Us_BFu15ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_I, Us_BFu15ll_I)
//============================================================================


struct  Us_BFu15ll_Ip  {
  unsigned short v1;
  __tsu64 v2:15;
  int *v3;
};
//SIG(1 Us_BFu15ll_Ip) C1{ Fs FL:15 Fp}



static void Test_Us_BFu15ll_Ip()
{
  {
    init_simple_test("Us_BFu15ll_Ip");
    static STRUCT_IF_C Us_BFu15ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu15ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_Ip)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu15ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_Ip, Us_BFu15ll_Ip)
//============================================================================


struct  Us_BFu15ll_L  {
  unsigned short v1;
  __tsu64 v2:15;
  __tsi64 v3;
};
//SIG(1 Us_BFu15ll_L) C1{ Fs FL:15 FL}



static void Test_Us_BFu15ll_L()
{
  {
    init_simple_test("Us_BFu15ll_L");
    static STRUCT_IF_C Us_BFu15ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu15ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_L)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_L");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu15ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_L, Us_BFu15ll_L)
//============================================================================


struct  Us_BFu15ll_S  {
  unsigned short v1;
  __tsu64 v2:15;
  short v3;
};
//SIG(1 Us_BFu15ll_S) C1{ Fs FL:15 Fs}



static void Test_Us_BFu15ll_S()
{
  {
    init_simple_test("Us_BFu15ll_S");
    static STRUCT_IF_C Us_BFu15ll_S lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_S)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_S");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_S");
    check_field_offset(lv, v3, 4, "Us_BFu15ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_S, Us_BFu15ll_S)
//============================================================================


struct  Us_BFu15ll_Uc  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned char v3;
};
//SIG(1 Us_BFu15ll_Uc) C1{ Fs FL:15 Fc}



static void Test_Us_BFu15ll_Uc()
{
  {
    init_simple_test("Us_BFu15ll_Uc");
    static STRUCT_IF_C Us_BFu15ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_Uc)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_Uc");
    check_field_offset(lv, v3, 4, "Us_BFu15ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_Uc, Us_BFu15ll_Uc)
//============================================================================


struct  Us_BFu15ll_Ui  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned int v3;
};
//SIG(1 Us_BFu15ll_Ui) C1{ Fs FL:15 Fi}



static void Test_Us_BFu15ll_Ui()
{
  {
    init_simple_test("Us_BFu15ll_Ui");
    static STRUCT_IF_C Us_BFu15ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_Ui)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_Ui");
    check_field_offset(lv, v3, 4, "Us_BFu15ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_Ui, Us_BFu15ll_Ui)
//============================================================================


struct  Us_BFu15ll_Ul  {
  unsigned short v1;
  __tsu64 v2:15;
  __tsu64 v3;
};
//SIG(1 Us_BFu15ll_Ul) C1{ Fs FL:15 FL}



static void Test_Us_BFu15ll_Ul()
{
  {
    init_simple_test("Us_BFu15ll_Ul");
    static STRUCT_IF_C Us_BFu15ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu15ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_Ul)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu15ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_Ul, Us_BFu15ll_Ul)
//============================================================================


struct  Us_BFu15ll_Us  {
  unsigned short v1;
  __tsu64 v2:15;
  unsigned short v3;
};
//SIG(1 Us_BFu15ll_Us) C1{ Fs FL:15 Fs}



static void Test_Us_BFu15ll_Us()
{
  {
    init_simple_test("Us_BFu15ll_Us");
    static STRUCT_IF_C Us_BFu15ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_Us)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_Us");
    check_field_offset(lv, v3, 4, "Us_BFu15ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_Us, Us_BFu15ll_Us)
//============================================================================


struct  Us_BFu15ll_Vp  {
  unsigned short v1;
  __tsu64 v2:15;
  void *v3;
};
//SIG(1 Us_BFu15ll_Vp) C1{ Fs FL:15 Fp}



static void Test_Us_BFu15ll_Vp()
{
  {
    init_simple_test("Us_BFu15ll_Vp");
    static STRUCT_IF_C Us_BFu15ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu15ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15ll_Vp)");
    check_field_offset(lv, v1, 0, "Us_BFu15ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu15ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15ll_Vp, Us_BFu15ll_Vp)
//============================================================================


struct  Us_BFu15s  {
  unsigned short v1;
  unsigned short v2:15;
};
//SIG(1 Us_BFu15s) C1{ Fs Fs:15}



static void Test_Us_BFu15s()
{
  {
    init_simple_test("Us_BFu15s");
    static STRUCT_IF_C Us_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s, Us_BFu15s)
//============================================================================


struct  Us_BFu15s_BFu15i  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned int v3:15;
};
//SIG(1 Us_BFu15s_BFu15i) C1{ Fs Fs:15 Fi:15}



static void Test_Us_BFu15s_BFu15i()
{
  {
    init_simple_test("Us_BFu15s_BFu15i");
    static STRUCT_IF_C Us_BFu15s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15s_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_BFu15s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu15i, Us_BFu15s_BFu15i)
//============================================================================


struct  Us_BFu15s_BFu15ll  {
  unsigned short v1;
  unsigned short v2:15;
  __tsu64 v3:15;
};
//SIG(1 Us_BFu15s_BFu15ll) C1{ Fs Fs:15 FL:15}



static void Test_Us_BFu15s_BFu15ll()
{
  {
    init_simple_test("Us_BFu15s_BFu15ll");
    static STRUCT_IF_C Us_BFu15s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, 1, "Us_BFu15s_BFu15ll");
    set_bf_and_test(lv, v3, 3, 7, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu15ll, Us_BFu15s_BFu15ll)
//============================================================================


struct  Us_BFu15s_BFu15s  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned short v3:15;
};
//SIG(1 Us_BFu15s_BFu15s) C1{ Fs Fs:15 Fs:15}



static void Test_Us_BFu15s_BFu15s()
{
  {
    init_simple_test("Us_BFu15s_BFu15s");
    static STRUCT_IF_C Us_BFu15s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu15s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu15s_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_BFu15s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu15s, Us_BFu15s_BFu15s)
//============================================================================


struct  Us_BFu15s_BFu16i  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned int v3:16;
};
//SIG(1 Us_BFu15s_BFu16i) C1{ Fs Fs:15 Fi:16}



static void Test_Us_BFu15s_BFu16i()
{
  {
    init_simple_test("Us_BFu15s_BFu16i");
    static STRUCT_IF_C Us_BFu15s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15s_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu15s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu15s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu16i, Us_BFu15s_BFu16i)
//============================================================================


struct  Us_BFu15s_BFu16ll  {
  unsigned short v1;
  unsigned short v2:15;
  __tsu64 v3:16;
};
//SIG(1 Us_BFu15s_BFu16ll) C1{ Fs Fs:15 FL:16}



static void Test_Us_BFu15s_BFu16ll()
{
  {
    init_simple_test("Us_BFu15s_BFu16ll");
    static STRUCT_IF_C Us_BFu15s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, 1, "Us_BFu15s_BFu16ll");
    set_bf_and_test(lv, v3, 3, 7, 16, hide_ull(1LL<<15), "Us_BFu15s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu16ll, Us_BFu15s_BFu16ll)
//============================================================================


struct  Us_BFu15s_BFu16s  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned short v3:16;
};
//SIG(1 Us_BFu15s_BFu16s) C1{ Fs Fs:15 Fs:16}



static void Test_Us_BFu15s_BFu16s()
{
  {
    init_simple_test("Us_BFu15s_BFu16s");
    static STRUCT_IF_C Us_BFu15s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu15s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu15s_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu15s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu15s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu16s, Us_BFu15s_BFu16s)
//============================================================================


struct  Us_BFu15s_BFu17i  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned int v3:17;
};
//SIG(1 Us_BFu15s_BFu17i) C1{ Fs Fs:15 Fi:17}



static void Test_Us_BFu15s_BFu17i()
{
  {
    init_simple_test("Us_BFu15s_BFu17i");
    static STRUCT_IF_C Us_BFu15s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15s_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Us_BFu15s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu15s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu17i, Us_BFu15s_BFu17i)
//============================================================================


struct  Us_BFu15s_BFu17ll  {
  unsigned short v1;
  unsigned short v2:15;
  __tsu64 v3:17;
};
//SIG(1 Us_BFu15s_BFu17ll) C1{ Fs Fs:15 FL:17}



static void Test_Us_BFu15s_BFu17ll()
{
  {
    init_simple_test("Us_BFu15s_BFu17ll");
    static STRUCT_IF_C Us_BFu15s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, 1, "Us_BFu15s_BFu17ll");
    set_bf_and_test(lv, v3, 3, 7, 17, hide_ull(1LL<<16), "Us_BFu15s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu17ll, Us_BFu15s_BFu17ll)
//============================================================================


struct  Us_BFu15s_BFu1c  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned char v3:1;
};
//SIG(1 Us_BFu15s_BFu1c) C1{ Fs Fs:15 Fc:1}



static void Test_Us_BFu15s_BFu1c()
{
  {
    init_simple_test("Us_BFu15s_BFu1c");
    static STRUCT_IF_C Us_BFu15s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu15s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu15s_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu1c");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "Us_BFu15s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu1c, Us_BFu15s_BFu1c)
//============================================================================


struct  Us_BFu15s_BFu1i  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned int v3:1;
};
//SIG(1 Us_BFu15s_BFu1i) C1{ Fs Fs:15 Fi:1}



static void Test_Us_BFu15s_BFu1i()
{
  {
    init_simple_test("Us_BFu15s_BFu1i");
    static STRUCT_IF_C Us_BFu15s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu15s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15s_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu1i");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "Us_BFu15s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu1i, Us_BFu15s_BFu1i)
//============================================================================


struct  Us_BFu15s_BFu1ll  {
  unsigned short v1;
  unsigned short v2:15;
  __tsu64 v3:1;
};
//SIG(1 Us_BFu15s_BFu1ll) C1{ Fs Fs:15 FL:1}



static void Test_Us_BFu15s_BFu1ll()
{
  {
    init_simple_test("Us_BFu15s_BFu1ll");
    static STRUCT_IF_C Us_BFu15s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu15s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu1ll");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "Us_BFu15s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu1ll, Us_BFu15s_BFu1ll)
//============================================================================


struct  Us_BFu15s_BFu1s  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned short v3:1;
};
//SIG(1 Us_BFu15s_BFu1s) C1{ Fs Fs:15 Fs:1}



static void Test_Us_BFu15s_BFu1s()
{
  {
    init_simple_test("Us_BFu15s_BFu1s");
    static STRUCT_IF_C Us_BFu15s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu15s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu15s_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu1s");
    set_bf_and_test(lv, v3, 3, 7, 1, 1, "Us_BFu15s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu1s, Us_BFu15s_BFu1s)
//============================================================================


struct  Us_BFu15s_BFu31i  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned int v3:31;
};
//SIG(1 Us_BFu15s_BFu31i) C1{ Fs Fs:15 Fi:31}



static void Test_Us_BFu15s_BFu31i()
{
  {
    init_simple_test("Us_BFu15s_BFu31i");
    static STRUCT_IF_C Us_BFu15s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15s_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Us_BFu15s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu15s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu31i, Us_BFu15s_BFu31i)
//============================================================================


struct  Us_BFu15s_BFu31ll  {
  unsigned short v1;
  unsigned short v2:15;
  __tsu64 v3:31;
};
//SIG(1 Us_BFu15s_BFu31ll) C1{ Fs Fs:15 FL:31}



static void Test_Us_BFu15s_BFu31ll()
{
  {
    init_simple_test("Us_BFu15s_BFu31ll");
    static STRUCT_IF_C Us_BFu15s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, 1, "Us_BFu15s_BFu31ll");
    set_bf_and_test(lv, v3, 3, 7, 31, hide_ull(1LL<<30), "Us_BFu15s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu31ll, Us_BFu15s_BFu31ll)
//============================================================================


struct  Us_BFu15s_BFu32i  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned int v3:32;
};
//SIG(1 Us_BFu15s_BFu32i) C1{ Fs Fs:15 Fi:32}



static void Test_Us_BFu15s_BFu32i()
{
  {
    init_simple_test("Us_BFu15s_BFu32i");
    static STRUCT_IF_C Us_BFu15s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15s_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Us_BFu15s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu15s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu32i, Us_BFu15s_BFu32i)
//============================================================================


struct  Us_BFu15s_BFu32ll  {
  unsigned short v1;
  unsigned short v2:15;
  __tsu64 v3:32;
};
//SIG(1 Us_BFu15s_BFu32ll) C1{ Fs Fs:15 FL:32}



static void Test_Us_BFu15s_BFu32ll()
{
  {
    init_simple_test("Us_BFu15s_BFu32ll");
    static STRUCT_IF_C Us_BFu15s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, 1, "Us_BFu15s_BFu32ll");
    set_bf_and_test(lv, v3, 3, 7, 32, hide_ull(1LL<<31), "Us_BFu15s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu32ll, Us_BFu15s_BFu32ll)
//============================================================================


struct  Us_BFu15s_BFu33  {
  unsigned short v1;
  unsigned short v2:15;
  __tsu64 v3:33;
};
//SIG(1 Us_BFu15s_BFu33) C1{ Fs Fs:15 FL:33}



static void Test_Us_BFu15s_BFu33()
{
  {
    init_simple_test("Us_BFu15s_BFu33");
    static STRUCT_IF_C Us_BFu15s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15s_BFu33)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, 1, "Us_BFu15s_BFu33");
    set_bf_and_test(lv, v3, 3, 7, 33, hide_ull(1LL<<32), "Us_BFu15s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu33, Us_BFu15s_BFu33)
//============================================================================


struct  Us_BFu15s_BFu7c  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned char v3:7;
};
//SIG(1 Us_BFu15s_BFu7c) C1{ Fs Fs:15 Fc:7}



static void Test_Us_BFu15s_BFu7c()
{
  {
    init_simple_test("Us_BFu15s_BFu7c");
    static STRUCT_IF_C Us_BFu15s_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu15s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu15s_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu15s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu15s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu7c, Us_BFu15s_BFu7c)
//============================================================================


struct  Us_BFu15s_BFu7i  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned int v3:7;
};
//SIG(1 Us_BFu15s_BFu7i) C1{ Fs Fs:15 Fi:7}



static void Test_Us_BFu15s_BFu7i()
{
  {
    init_simple_test("Us_BFu15s_BFu7i");
    static STRUCT_IF_C Us_BFu15s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15s_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu15s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu15s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu7i, Us_BFu15s_BFu7i)
//============================================================================


struct  Us_BFu15s_BFu7ll  {
  unsigned short v1;
  unsigned short v2:15;
  __tsu64 v3:7;
};
//SIG(1 Us_BFu15s_BFu7ll) C1{ Fs Fs:15 FL:7}



static void Test_Us_BFu15s_BFu7ll()
{
  {
    init_simple_test("Us_BFu15s_BFu7ll");
    static STRUCT_IF_C Us_BFu15s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, 1, "Us_BFu15s_BFu7ll");
    set_bf_and_test(lv, v3, 3, 7, 7, hide_ull(1LL<<6), "Us_BFu15s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu7ll, Us_BFu15s_BFu7ll)
//============================================================================


struct  Us_BFu15s_BFu7s  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned short v3:7;
};
//SIG(1 Us_BFu15s_BFu7s) C1{ Fs Fs:15 Fs:7}



static void Test_Us_BFu15s_BFu7s()
{
  {
    init_simple_test("Us_BFu15s_BFu7s");
    static STRUCT_IF_C Us_BFu15s_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu15s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu15s_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu15s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu15s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu7s, Us_BFu15s_BFu7s)
//============================================================================


struct  Us_BFu15s_BFu8c  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned char v3:8;
};
//SIG(1 Us_BFu15s_BFu8c) C1{ Fs Fs:15 Fc:8}



static void Test_Us_BFu15s_BFu8c()
{
  {
    init_simple_test("Us_BFu15s_BFu8c");
    static STRUCT_IF_C Us_BFu15s_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu15s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu15s_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu15s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu15s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu8c, Us_BFu15s_BFu8c)
//============================================================================


struct  Us_BFu15s_BFu8i  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned int v3:8;
};
//SIG(1 Us_BFu15s_BFu8i) C1{ Fs Fs:15 Fi:8}



static void Test_Us_BFu15s_BFu8i()
{
  {
    init_simple_test("Us_BFu15s_BFu8i");
    static STRUCT_IF_C Us_BFu15s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15s_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu15s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu15s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu8i, Us_BFu15s_BFu8i)
//============================================================================


struct  Us_BFu15s_BFu8ll  {
  unsigned short v1;
  unsigned short v2:15;
  __tsu64 v3:8;
};
//SIG(1 Us_BFu15s_BFu8ll) C1{ Fs Fs:15 FL:8}



static void Test_Us_BFu15s_BFu8ll()
{
  {
    init_simple_test("Us_BFu15s_BFu8ll");
    static STRUCT_IF_C Us_BFu15s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, 1, "Us_BFu15s_BFu8ll");
    set_bf_and_test(lv, v3, 3, 7, 8, hide_ull(1LL<<7), "Us_BFu15s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu8ll, Us_BFu15s_BFu8ll)
//============================================================================


struct  Us_BFu15s_BFu8s  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned short v3:8;
};
//SIG(1 Us_BFu15s_BFu8s) C1{ Fs Fs:15 Fs:8}



static void Test_Us_BFu15s_BFu8s()
{
  {
    init_simple_test("Us_BFu15s_BFu8s");
    static STRUCT_IF_C Us_BFu15s_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu15s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu15s_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu15s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu15s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu8s, Us_BFu15s_BFu8s)
//============================================================================


struct  Us_BFu15s_BFu9i  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned int v3:9;
};
//SIG(1 Us_BFu15s_BFu9i) C1{ Fs Fs:15 Fi:9}



static void Test_Us_BFu15s_BFu9i()
{
  {
    init_simple_test("Us_BFu15s_BFu9i");
    static STRUCT_IF_C Us_BFu15s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15s_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_BFu15s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_BFu15s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu9i, Us_BFu15s_BFu9i)
//============================================================================


struct  Us_BFu15s_BFu9ll  {
  unsigned short v1;
  unsigned short v2:15;
  __tsu64 v3:9;
};
//SIG(1 Us_BFu15s_BFu9ll) C1{ Fs Fs:15 FL:9}



static void Test_Us_BFu15s_BFu9ll()
{
  {
    init_simple_test("Us_BFu15s_BFu9ll");
    static STRUCT_IF_C Us_BFu15s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, 1, "Us_BFu15s_BFu9ll");
    set_bf_and_test(lv, v3, 3, 7, 9, hide_ull(1LL<<8), "Us_BFu15s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu9ll, Us_BFu15s_BFu9ll)
//============================================================================


struct  Us_BFu15s_BFu9s  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned short v3:9;
};
//SIG(1 Us_BFu15s_BFu9s) C1{ Fs Fs:15 Fs:9}



static void Test_Us_BFu15s_BFu9s()
{
  {
    init_simple_test("Us_BFu15s_BFu9s");
    static STRUCT_IF_C Us_BFu15s_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu15s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu15s_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_BFu15s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_BFu15s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_BFu9s, Us_BFu15s_BFu9s)
//============================================================================


struct  Us_BFu15s_C  {
  unsigned short v1;
  unsigned short v2:15;
  char v3;
};
//SIG(1 Us_BFu15s_C) C1{ Fs Fs:15 Fc}



static void Test_Us_BFu15s_C()
{
  {
    init_simple_test("Us_BFu15s_C");
    static STRUCT_IF_C Us_BFu15s_C lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu15s_C)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu15s_C)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_C");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_C");
    check_field_offset(lv, v3, 4, "Us_BFu15s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_C, Us_BFu15s_C)
//============================================================================


struct  Us_BFu15s_D  {
  unsigned short v1;
  unsigned short v2:15;
  double v3;
};
//SIG(1 Us_BFu15s_D) C1{ Fs Fs:15 FL}



static void Test_Us_BFu15s_D()
{
  {
    init_simple_test("Us_BFu15s_D");
    static STRUCT_IF_C Us_BFu15s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu15s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15s_D)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_D");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu15s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_D, Us_BFu15s_D)
//============================================================================


struct  Us_BFu15s_F  {
  unsigned short v1;
  unsigned short v2:15;
  float v3;
};
//SIG(1 Us_BFu15s_F) C1{ Fs Fs:15 Fi}



static void Test_Us_BFu15s_F()
{
  {
    init_simple_test("Us_BFu15s_F");
    static STRUCT_IF_C Us_BFu15s_F lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_F)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15s_F)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_F");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_F");
    check_field_offset(lv, v3, 4, "Us_BFu15s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_F, Us_BFu15s_F)
//============================================================================


struct  Us_BFu15s_I  {
  unsigned short v1;
  unsigned short v2:15;
  int v3;
};
//SIG(1 Us_BFu15s_I) C1{ Fs Fs:15 Fi}



static void Test_Us_BFu15s_I()
{
  {
    init_simple_test("Us_BFu15s_I");
    static STRUCT_IF_C Us_BFu15s_I lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_I)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15s_I)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_I");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_I");
    check_field_offset(lv, v3, 4, "Us_BFu15s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_I, Us_BFu15s_I)
//============================================================================


struct  Us_BFu15s_Ip  {
  unsigned short v1;
  unsigned short v2:15;
  int *v3;
};
//SIG(1 Us_BFu15s_Ip) C1{ Fs Fs:15 Fp}



static void Test_Us_BFu15s_Ip()
{
  {
    init_simple_test("Us_BFu15s_Ip");
    static STRUCT_IF_C Us_BFu15s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu15s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15s_Ip)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu15s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_Ip, Us_BFu15s_Ip)
//============================================================================


struct  Us_BFu15s_L  {
  unsigned short v1;
  unsigned short v2:15;
  __tsi64 v3;
};
//SIG(1 Us_BFu15s_L) C1{ Fs Fs:15 FL}



static void Test_Us_BFu15s_L()
{
  {
    init_simple_test("Us_BFu15s_L");
    static STRUCT_IF_C Us_BFu15s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu15s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15s_L)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_L");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu15s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_L, Us_BFu15s_L)
//============================================================================


struct  Us_BFu15s_S  {
  unsigned short v1;
  unsigned short v2:15;
  short v3;
};
//SIG(1 Us_BFu15s_S) C1{ Fs Fs:15 Fs}



static void Test_Us_BFu15s_S()
{
  {
    init_simple_test("Us_BFu15s_S");
    static STRUCT_IF_C Us_BFu15s_S lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu15s_S)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu15s_S)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_S");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_S");
    check_field_offset(lv, v3, 4, "Us_BFu15s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_S, Us_BFu15s_S)
//============================================================================


struct  Us_BFu15s_Uc  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned char v3;
};
//SIG(1 Us_BFu15s_Uc) C1{ Fs Fs:15 Fc}



static void Test_Us_BFu15s_Uc()
{
  {
    init_simple_test("Us_BFu15s_Uc");
    static STRUCT_IF_C Us_BFu15s_Uc lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu15s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu15s_Uc)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_Uc");
    check_field_offset(lv, v3, 4, "Us_BFu15s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_Uc, Us_BFu15s_Uc)
//============================================================================


struct  Us_BFu15s_Ui  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned int v3;
};
//SIG(1 Us_BFu15s_Ui) C1{ Fs Fs:15 Fi}



static void Test_Us_BFu15s_Ui()
{
  {
    init_simple_test("Us_BFu15s_Ui");
    static STRUCT_IF_C Us_BFu15s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu15s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu15s_Ui)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_Ui");
    check_field_offset(lv, v3, 4, "Us_BFu15s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_Ui, Us_BFu15s_Ui)
//============================================================================


struct  Us_BFu15s_Ul  {
  unsigned short v1;
  unsigned short v2:15;
  __tsu64 v3;
};
//SIG(1 Us_BFu15s_Ul) C1{ Fs Fs:15 FL}



static void Test_Us_BFu15s_Ul()
{
  {
    init_simple_test("Us_BFu15s_Ul");
    static STRUCT_IF_C Us_BFu15s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu15s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15s_Ul)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu15s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_Ul, Us_BFu15s_Ul)
//============================================================================


struct  Us_BFu15s_Us  {
  unsigned short v1;
  unsigned short v2:15;
  unsigned short v3;
};
//SIG(1 Us_BFu15s_Us) C1{ Fs Fs:15 Fs}



static void Test_Us_BFu15s_Us()
{
  {
    init_simple_test("Us_BFu15s_Us");
    static STRUCT_IF_C Us_BFu15s_Us lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu15s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu15s_Us)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_Us");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_Us");
    check_field_offset(lv, v3, 4, "Us_BFu15s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_Us, Us_BFu15s_Us)
//============================================================================


struct  Us_BFu15s_Vp  {
  unsigned short v1;
  unsigned short v2:15;
  void *v3;
};
//SIG(1 Us_BFu15s_Vp) C1{ Fs Fs:15 Fp}



static void Test_Us_BFu15s_Vp()
{
  {
    init_simple_test("Us_BFu15s_Vp");
    static STRUCT_IF_C Us_BFu15s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu15s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu15s_Vp)");
    check_field_offset(lv, v1, 0, "Us_BFu15s_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 15, 1, "Us_BFu15s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 15, hide_ull(1LL<<14), "Us_BFu15s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu15s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu15s_Vp, Us_BFu15s_Vp)
//============================================================================


struct  Us_BFu16i  {
  unsigned short v1;
  unsigned int v2:16;
};
//SIG(1 Us_BFu16i) C1{ Fs Fi:16}



static void Test_Us_BFu16i()
{
  {
    init_simple_test("Us_BFu16i");
    static STRUCT_IF_C Us_BFu16i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i, Us_BFu16i)
//============================================================================


struct  Us_BFu16i_BFu15i  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned int v3:15;
};
//SIG(1 Us_BFu16i_BFu15i) C1{ Fs Fi:16 Fi:15}



static void Test_Us_BFu16i_BFu15i()
{
  {
    init_simple_test("Us_BFu16i_BFu15i");
    static STRUCT_IF_C Us_BFu16i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_BFu16i_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_BFu16i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu15i, Us_BFu16i_BFu15i)
//============================================================================


struct  Us_BFu16i_BFu15ll  {
  unsigned short v1;
  unsigned int v2:16;
  __tsu64 v3:15;
};
//SIG(1 Us_BFu16i_BFu15ll) C1{ Fs Fi:16 FL:15}



static void Test_Us_BFu16i_BFu15ll()
{
  {
    init_simple_test("Us_BFu16i_BFu15ll");
    static STRUCT_IF_C Us_BFu16i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_BFu16i_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_BFu16i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu15ll, Us_BFu16i_BFu15ll)
//============================================================================


struct  Us_BFu16i_BFu15s  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned short v3:15;
};
//SIG(1 Us_BFu16i_BFu15s) C1{ Fs Fi:16 Fs:15}



static void Test_Us_BFu16i_BFu15s()
{
  {
    init_simple_test("Us_BFu16i_BFu15s");
    static STRUCT_IF_C Us_BFu16i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_BFu16i_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_BFu16i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu15s, Us_BFu16i_BFu15s)
//============================================================================


struct  Us_BFu16i_BFu16i  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned int v3:16;
};
//SIG(1 Us_BFu16i_BFu16i) C1{ Fs Fi:16 Fi:16}



static void Test_Us_BFu16i_BFu16i()
{
  {
    init_simple_test("Us_BFu16i_BFu16i");
    static STRUCT_IF_C Us_BFu16i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu16i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu16i, Us_BFu16i_BFu16i)
//============================================================================


struct  Us_BFu16i_BFu16ll  {
  unsigned short v1;
  unsigned int v2:16;
  __tsu64 v3:16;
};
//SIG(1 Us_BFu16i_BFu16ll) C1{ Fs Fi:16 FL:16}



static void Test_Us_BFu16i_BFu16ll()
{
  {
    init_simple_test("Us_BFu16i_BFu16ll");
    static STRUCT_IF_C Us_BFu16i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu16i_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu16ll, Us_BFu16i_BFu16ll)
//============================================================================


struct  Us_BFu16i_BFu16s  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned short v3:16;
};
//SIG(1 Us_BFu16i_BFu16s) C1{ Fs Fi:16 Fs:16}



static void Test_Us_BFu16i_BFu16s()
{
  {
    init_simple_test("Us_BFu16i_BFu16s");
    static STRUCT_IF_C Us_BFu16i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu16i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu16s, Us_BFu16i_BFu16s)
//============================================================================


struct  Us_BFu16i_BFu17i  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned int v3:17;
};
//SIG(1 Us_BFu16i_BFu17i) C1{ Fs Fi:16 Fi:17}



static void Test_Us_BFu16i_BFu17i()
{
  {
    init_simple_test("Us_BFu16i_BFu17i");
    static STRUCT_IF_C Us_BFu16i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Us_BFu16i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu16i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu17i, Us_BFu16i_BFu17i)
//============================================================================


struct  Us_BFu16i_BFu17ll  {
  unsigned short v1;
  unsigned int v2:16;
  __tsu64 v3:17;
};
//SIG(1 Us_BFu16i_BFu17ll) C1{ Fs Fi:16 FL:17}



static void Test_Us_BFu16i_BFu17ll()
{
  {
    init_simple_test("Us_BFu16i_BFu17ll");
    static STRUCT_IF_C Us_BFu16i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Us_BFu16i_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu16i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu17ll, Us_BFu16i_BFu17ll)
//============================================================================


struct  Us_BFu16i_BFu1c  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned char v3:1;
};
//SIG(1 Us_BFu16i_BFu1c) C1{ Fs Fi:16 Fc:1}



static void Test_Us_BFu16i_BFu1c()
{
  {
    init_simple_test("Us_BFu16i_BFu1c");
    static STRUCT_IF_C Us_BFu16i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_BFu16i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu1c, Us_BFu16i_BFu1c)
//============================================================================


struct  Us_BFu16i_BFu1i  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned int v3:1;
};
//SIG(1 Us_BFu16i_BFu1i) C1{ Fs Fi:16 Fi:1}



static void Test_Us_BFu16i_BFu1i()
{
  {
    init_simple_test("Us_BFu16i_BFu1i");
    static STRUCT_IF_C Us_BFu16i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_BFu16i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu1i, Us_BFu16i_BFu1i)
//============================================================================


struct  Us_BFu16i_BFu1ll  {
  unsigned short v1;
  unsigned int v2:16;
  __tsu64 v3:1;
};
//SIG(1 Us_BFu16i_BFu1ll) C1{ Fs Fi:16 FL:1}



static void Test_Us_BFu16i_BFu1ll()
{
  {
    init_simple_test("Us_BFu16i_BFu1ll");
    static STRUCT_IF_C Us_BFu16i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_BFu16i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu1ll, Us_BFu16i_BFu1ll)
//============================================================================


struct  Us_BFu16i_BFu1s  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned short v3:1;
};
//SIG(1 Us_BFu16i_BFu1s) C1{ Fs Fi:16 Fs:1}



static void Test_Us_BFu16i_BFu1s()
{
  {
    init_simple_test("Us_BFu16i_BFu1s");
    static STRUCT_IF_C Us_BFu16i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_BFu16i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu1s, Us_BFu16i_BFu1s)
//============================================================================


struct  Us_BFu16i_BFu31i  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned int v3:31;
};
//SIG(1 Us_BFu16i_BFu31i) C1{ Fs Fi:16 Fi:31}



static void Test_Us_BFu16i_BFu31i()
{
  {
    init_simple_test("Us_BFu16i_BFu31i");
    static STRUCT_IF_C Us_BFu16i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Us_BFu16i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu16i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu31i, Us_BFu16i_BFu31i)
//============================================================================


struct  Us_BFu16i_BFu31ll  {
  unsigned short v1;
  unsigned int v2:16;
  __tsu64 v3:31;
};
//SIG(1 Us_BFu16i_BFu31ll) C1{ Fs Fi:16 FL:31}



static void Test_Us_BFu16i_BFu31ll()
{
  {
    init_simple_test("Us_BFu16i_BFu31ll");
    static STRUCT_IF_C Us_BFu16i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Us_BFu16i_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu16i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu31ll, Us_BFu16i_BFu31ll)
//============================================================================


struct  Us_BFu16i_BFu32i  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned int v3:32;
};
//SIG(1 Us_BFu16i_BFu32i) C1{ Fs Fi:16 Fi:32}



static void Test_Us_BFu16i_BFu32i()
{
  {
    init_simple_test("Us_BFu16i_BFu32i");
    static STRUCT_IF_C Us_BFu16i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Us_BFu16i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu16i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu32i, Us_BFu16i_BFu32i)
//============================================================================


struct  Us_BFu16i_BFu32ll  {
  unsigned short v1;
  unsigned int v2:16;
  __tsu64 v3:32;
};
//SIG(1 Us_BFu16i_BFu32ll) C1{ Fs Fi:16 FL:32}



static void Test_Us_BFu16i_BFu32ll()
{
  {
    init_simple_test("Us_BFu16i_BFu32ll");
    static STRUCT_IF_C Us_BFu16i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Us_BFu16i_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu16i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu32ll, Us_BFu16i_BFu32ll)
//============================================================================


struct  Us_BFu16i_BFu33  {
  unsigned short v1;
  unsigned int v2:16;
  __tsu64 v3:33;
};
//SIG(1 Us_BFu16i_BFu33) C1{ Fs Fi:16 FL:33}



static void Test_Us_BFu16i_BFu33()
{
  {
    init_simple_test("Us_BFu16i_BFu33");
    static STRUCT_IF_C Us_BFu16i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu16i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16i_BFu33)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "Us_BFu16i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Us_BFu16i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu33, Us_BFu16i_BFu33)
//============================================================================


struct  Us_BFu16i_BFu7c  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned char v3:7;
};
//SIG(1 Us_BFu16i_BFu7c) C1{ Fs Fi:16 Fc:7}



static void Test_Us_BFu16i_BFu7c()
{
  {
    init_simple_test("Us_BFu16i_BFu7c");
    static STRUCT_IF_C Us_BFu16i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu16i_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu16i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu7c, Us_BFu16i_BFu7c)
//============================================================================


struct  Us_BFu16i_BFu7i  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned int v3:7;
};
//SIG(1 Us_BFu16i_BFu7i) C1{ Fs Fi:16 Fi:7}



static void Test_Us_BFu16i_BFu7i()
{
  {
    init_simple_test("Us_BFu16i_BFu7i");
    static STRUCT_IF_C Us_BFu16i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu16i_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu16i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu7i, Us_BFu16i_BFu7i)
//============================================================================


struct  Us_BFu16i_BFu7ll  {
  unsigned short v1;
  unsigned int v2:16;
  __tsu64 v3:7;
};
//SIG(1 Us_BFu16i_BFu7ll) C1{ Fs Fi:16 FL:7}



static void Test_Us_BFu16i_BFu7ll()
{
  {
    init_simple_test("Us_BFu16i_BFu7ll");
    static STRUCT_IF_C Us_BFu16i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu16i_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu16i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu7ll, Us_BFu16i_BFu7ll)
//============================================================================


struct  Us_BFu16i_BFu7s  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned short v3:7;
};
//SIG(1 Us_BFu16i_BFu7s) C1{ Fs Fi:16 Fs:7}



static void Test_Us_BFu16i_BFu7s()
{
  {
    init_simple_test("Us_BFu16i_BFu7s");
    static STRUCT_IF_C Us_BFu16i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu16i_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu16i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu7s, Us_BFu16i_BFu7s)
//============================================================================


struct  Us_BFu16i_BFu8c  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned char v3:8;
};
//SIG(1 Us_BFu16i_BFu8c) C1{ Fs Fi:16 Fc:8}



static void Test_Us_BFu16i_BFu8c()
{
  {
    init_simple_test("Us_BFu16i_BFu8c");
    static STRUCT_IF_C Us_BFu16i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu16i_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu16i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu8c, Us_BFu16i_BFu8c)
//============================================================================


struct  Us_BFu16i_BFu8i  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned int v3:8;
};
//SIG(1 Us_BFu16i_BFu8i) C1{ Fs Fi:16 Fi:8}



static void Test_Us_BFu16i_BFu8i()
{
  {
    init_simple_test("Us_BFu16i_BFu8i");
    static STRUCT_IF_C Us_BFu16i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu16i_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu16i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu8i, Us_BFu16i_BFu8i)
//============================================================================


struct  Us_BFu16i_BFu8ll  {
  unsigned short v1;
  unsigned int v2:16;
  __tsu64 v3:8;
};
//SIG(1 Us_BFu16i_BFu8ll) C1{ Fs Fi:16 FL:8}



static void Test_Us_BFu16i_BFu8ll()
{
  {
    init_simple_test("Us_BFu16i_BFu8ll");
    static STRUCT_IF_C Us_BFu16i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu16i_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu16i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu8ll, Us_BFu16i_BFu8ll)
//============================================================================


struct  Us_BFu16i_BFu8s  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned short v3:8;
};
//SIG(1 Us_BFu16i_BFu8s) C1{ Fs Fi:16 Fs:8}



static void Test_Us_BFu16i_BFu8s()
{
  {
    init_simple_test("Us_BFu16i_BFu8s");
    static STRUCT_IF_C Us_BFu16i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu16i_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu16i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu8s, Us_BFu16i_BFu8s)
//============================================================================


struct  Us_BFu16i_BFu9i  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned int v3:9;
};
//SIG(1 Us_BFu16i_BFu9i) C1{ Fs Fi:16 Fi:9}



static void Test_Us_BFu16i_BFu9i()
{
  {
    init_simple_test("Us_BFu16i_BFu9i");
    static STRUCT_IF_C Us_BFu16i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_BFu16i_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_BFu16i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu9i, Us_BFu16i_BFu9i)
//============================================================================


struct  Us_BFu16i_BFu9ll  {
  unsigned short v1;
  unsigned int v2:16;
  __tsu64 v3:9;
};
//SIG(1 Us_BFu16i_BFu9ll) C1{ Fs Fi:16 FL:9}



static void Test_Us_BFu16i_BFu9ll()
{
  {
    init_simple_test("Us_BFu16i_BFu9ll");
    static STRUCT_IF_C Us_BFu16i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_BFu16i_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_BFu16i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu9ll, Us_BFu16i_BFu9ll)
//============================================================================


struct  Us_BFu16i_BFu9s  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned short v3:9;
};
//SIG(1 Us_BFu16i_BFu9s) C1{ Fs Fi:16 Fs:9}



static void Test_Us_BFu16i_BFu9s()
{
  {
    init_simple_test("Us_BFu16i_BFu9s");
    static STRUCT_IF_C Us_BFu16i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_BFu16i_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_BFu16i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_BFu9s, Us_BFu16i_BFu9s)
//============================================================================


struct  Us_BFu16i_C  {
  unsigned short v1;
  unsigned int v2:16;
  char v3;
};
//SIG(1 Us_BFu16i_C) C1{ Fs Fi:16 Fc}



static void Test_Us_BFu16i_C()
{
  {
    init_simple_test("Us_BFu16i_C");
    static STRUCT_IF_C Us_BFu16i_C lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_C)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_C");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_C");
    check_field_offset(lv, v3, 4, "Us_BFu16i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_C, Us_BFu16i_C)
//============================================================================


struct  Us_BFu16i_D  {
  unsigned short v1;
  unsigned int v2:16;
  double v3;
};
//SIG(1 Us_BFu16i_D) C1{ Fs Fi:16 FL}



static void Test_Us_BFu16i_D()
{
  {
    init_simple_test("Us_BFu16i_D");
    static STRUCT_IF_C Us_BFu16i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu16i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16i_D)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_D");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu16i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_D, Us_BFu16i_D)
//============================================================================


struct  Us_BFu16i_F  {
  unsigned short v1;
  unsigned int v2:16;
  float v3;
};
//SIG(1 Us_BFu16i_F) C1{ Fs Fi:16 Fi}



static void Test_Us_BFu16i_F()
{
  {
    init_simple_test("Us_BFu16i_F");
    static STRUCT_IF_C Us_BFu16i_F lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_F)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_F");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_F");
    check_field_offset(lv, v3, 4, "Us_BFu16i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_F, Us_BFu16i_F)
//============================================================================


struct  Us_BFu16i_I  {
  unsigned short v1;
  unsigned int v2:16;
  int v3;
};
//SIG(1 Us_BFu16i_I) C1{ Fs Fi:16 Fi}



static void Test_Us_BFu16i_I()
{
  {
    init_simple_test("Us_BFu16i_I");
    static STRUCT_IF_C Us_BFu16i_I lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_I)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_I");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_I");
    check_field_offset(lv, v3, 4, "Us_BFu16i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_I, Us_BFu16i_I)
//============================================================================


struct  Us_BFu16i_Ip  {
  unsigned short v1;
  unsigned int v2:16;
  int *v3;
};
//SIG(1 Us_BFu16i_Ip) C1{ Fs Fi:16 Fp}



static void Test_Us_BFu16i_Ip()
{
  {
    init_simple_test("Us_BFu16i_Ip");
    static STRUCT_IF_C Us_BFu16i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu16i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16i_Ip)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_Ip");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu16i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_Ip, Us_BFu16i_Ip)
//============================================================================


struct  Us_BFu16i_L  {
  unsigned short v1;
  unsigned int v2:16;
  __tsi64 v3;
};
//SIG(1 Us_BFu16i_L) C1{ Fs Fi:16 FL}



static void Test_Us_BFu16i_L()
{
  {
    init_simple_test("Us_BFu16i_L");
    static STRUCT_IF_C Us_BFu16i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu16i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16i_L)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_L");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu16i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_L, Us_BFu16i_L)
//============================================================================


struct  Us_BFu16i_S  {
  unsigned short v1;
  unsigned int v2:16;
  short v3;
};
//SIG(1 Us_BFu16i_S) C1{ Fs Fi:16 Fs}



static void Test_Us_BFu16i_S()
{
  {
    init_simple_test("Us_BFu16i_S");
    static STRUCT_IF_C Us_BFu16i_S lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_S)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_S");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_S");
    check_field_offset(lv, v3, 4, "Us_BFu16i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_S, Us_BFu16i_S)
//============================================================================


struct  Us_BFu16i_Uc  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned char v3;
};
//SIG(1 Us_BFu16i_Uc) C1{ Fs Fi:16 Fc}



static void Test_Us_BFu16i_Uc()
{
  {
    init_simple_test("Us_BFu16i_Uc");
    static STRUCT_IF_C Us_BFu16i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_Uc)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_Uc");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_Uc");
    check_field_offset(lv, v3, 4, "Us_BFu16i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_Uc, Us_BFu16i_Uc)
//============================================================================


struct  Us_BFu16i_Ui  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned int v3;
};
//SIG(1 Us_BFu16i_Ui) C1{ Fs Fi:16 Fi}



static void Test_Us_BFu16i_Ui()
{
  {
    init_simple_test("Us_BFu16i_Ui");
    static STRUCT_IF_C Us_BFu16i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_Ui)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_Ui");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_Ui");
    check_field_offset(lv, v3, 4, "Us_BFu16i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_Ui, Us_BFu16i_Ui)
//============================================================================


struct  Us_BFu16i_Ul  {
  unsigned short v1;
  unsigned int v2:16;
  __tsu64 v3;
};
//SIG(1 Us_BFu16i_Ul) C1{ Fs Fi:16 FL}



static void Test_Us_BFu16i_Ul()
{
  {
    init_simple_test("Us_BFu16i_Ul");
    static STRUCT_IF_C Us_BFu16i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu16i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16i_Ul)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_Ul");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu16i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_Ul, Us_BFu16i_Ul)
//============================================================================


struct  Us_BFu16i_Us  {
  unsigned short v1;
  unsigned int v2:16;
  unsigned short v3;
};
//SIG(1 Us_BFu16i_Us) C1{ Fs Fi:16 Fs}



static void Test_Us_BFu16i_Us()
{
  {
    init_simple_test("Us_BFu16i_Us");
    static STRUCT_IF_C Us_BFu16i_Us lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16i_Us)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_Us");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_Us");
    check_field_offset(lv, v3, 4, "Us_BFu16i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_Us, Us_BFu16i_Us)
//============================================================================


struct  Us_BFu16i_Vp  {
  unsigned short v1;
  unsigned int v2:16;
  void *v3;
};
//SIG(1 Us_BFu16i_Vp) C1{ Fs Fi:16 Fp}



static void Test_Us_BFu16i_Vp()
{
  {
    init_simple_test("Us_BFu16i_Vp");
    static STRUCT_IF_C Us_BFu16i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu16i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16i_Vp)");
    check_field_offset(lv, v1, 0, "Us_BFu16i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16i_Vp");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu16i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16i_Vp, Us_BFu16i_Vp)
//============================================================================


struct  Us_BFu16ll  {
  unsigned short v1;
  __tsu64 v2:16;
};
//SIG(1 Us_BFu16ll) C1{ Fs FL:16}



static void Test_Us_BFu16ll()
{
  {
    init_simple_test("Us_BFu16ll");
    static STRUCT_IF_C Us_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll, Us_BFu16ll)
//============================================================================


struct  Us_BFu16ll_BFu15i  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned int v3:15;
};
//SIG(1 Us_BFu16ll_BFu15i) C1{ Fs FL:16 Fi:15}



static void Test_Us_BFu16ll_BFu15i()
{
  {
    init_simple_test("Us_BFu16ll_BFu15i");
    static STRUCT_IF_C Us_BFu16ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_BFu16ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_BFu16ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu15i, Us_BFu16ll_BFu15i)
//============================================================================


struct  Us_BFu16ll_BFu15ll  {
  unsigned short v1;
  __tsu64 v2:16;
  __tsu64 v3:15;
};
//SIG(1 Us_BFu16ll_BFu15ll) C1{ Fs FL:16 FL:15}



static void Test_Us_BFu16ll_BFu15ll()
{
  {
    init_simple_test("Us_BFu16ll_BFu15ll");
    static STRUCT_IF_C Us_BFu16ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_BFu16ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_BFu16ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu15ll, Us_BFu16ll_BFu15ll)
//============================================================================


struct  Us_BFu16ll_BFu15s  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned short v3:15;
};
//SIG(1 Us_BFu16ll_BFu15s) C1{ Fs FL:16 Fs:15}



static void Test_Us_BFu16ll_BFu15s()
{
  {
    init_simple_test("Us_BFu16ll_BFu15s");
    static STRUCT_IF_C Us_BFu16ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_BFu16ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_BFu16ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu15s, Us_BFu16ll_BFu15s)
//============================================================================


struct  Us_BFu16ll_BFu16i  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned int v3:16;
};
//SIG(1 Us_BFu16ll_BFu16i) C1{ Fs FL:16 Fi:16}



static void Test_Us_BFu16ll_BFu16i()
{
  {
    init_simple_test("Us_BFu16ll_BFu16i");
    static STRUCT_IF_C Us_BFu16ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu16ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu16i, Us_BFu16ll_BFu16i)
//============================================================================


struct  Us_BFu16ll_BFu16ll  {
  unsigned short v1;
  __tsu64 v2:16;
  __tsu64 v3:16;
};
//SIG(1 Us_BFu16ll_BFu16ll) C1{ Fs FL:16 FL:16}



static void Test_Us_BFu16ll_BFu16ll()
{
  {
    init_simple_test("Us_BFu16ll_BFu16ll");
    static STRUCT_IF_C Us_BFu16ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu16ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu16ll, Us_BFu16ll_BFu16ll)
//============================================================================


struct  Us_BFu16ll_BFu16s  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned short v3:16;
};
//SIG(1 Us_BFu16ll_BFu16s) C1{ Fs FL:16 Fs:16}



static void Test_Us_BFu16ll_BFu16s()
{
  {
    init_simple_test("Us_BFu16ll_BFu16s");
    static STRUCT_IF_C Us_BFu16ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu16ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu16s, Us_BFu16ll_BFu16s)
//============================================================================


struct  Us_BFu16ll_BFu17i  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned int v3:17;
};
//SIG(1 Us_BFu16ll_BFu17i) C1{ Fs FL:16 Fi:17}



static void Test_Us_BFu16ll_BFu17i()
{
  {
    init_simple_test("Us_BFu16ll_BFu17i");
    static STRUCT_IF_C Us_BFu16ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Us_BFu16ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu16ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu17i, Us_BFu16ll_BFu17i)
//============================================================================


struct  Us_BFu16ll_BFu17ll  {
  unsigned short v1;
  __tsu64 v2:16;
  __tsu64 v3:17;
};
//SIG(1 Us_BFu16ll_BFu17ll) C1{ Fs FL:16 FL:17}



static void Test_Us_BFu16ll_BFu17ll()
{
  {
    init_simple_test("Us_BFu16ll_BFu17ll");
    static STRUCT_IF_C Us_BFu16ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Us_BFu16ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu16ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu17ll, Us_BFu16ll_BFu17ll)
//============================================================================


struct  Us_BFu16ll_BFu1c  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned char v3:1;
};
//SIG(1 Us_BFu16ll_BFu1c) C1{ Fs FL:16 Fc:1}



static void Test_Us_BFu16ll_BFu1c()
{
  {
    init_simple_test("Us_BFu16ll_BFu1c");
    static STRUCT_IF_C Us_BFu16ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_BFu16ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu1c, Us_BFu16ll_BFu1c)
//============================================================================


struct  Us_BFu16ll_BFu1i  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned int v3:1;
};
//SIG(1 Us_BFu16ll_BFu1i) C1{ Fs FL:16 Fi:1}



static void Test_Us_BFu16ll_BFu1i()
{
  {
    init_simple_test("Us_BFu16ll_BFu1i");
    static STRUCT_IF_C Us_BFu16ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_BFu16ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu1i, Us_BFu16ll_BFu1i)
//============================================================================


struct  Us_BFu16ll_BFu1ll  {
  unsigned short v1;
  __tsu64 v2:16;
  __tsu64 v3:1;
};
//SIG(1 Us_BFu16ll_BFu1ll) C1{ Fs FL:16 FL:1}



static void Test_Us_BFu16ll_BFu1ll()
{
  {
    init_simple_test("Us_BFu16ll_BFu1ll");
    static STRUCT_IF_C Us_BFu16ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_BFu16ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu1ll, Us_BFu16ll_BFu1ll)
//============================================================================


struct  Us_BFu16ll_BFu1s  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned short v3:1;
};
//SIG(1 Us_BFu16ll_BFu1s) C1{ Fs FL:16 Fs:1}



static void Test_Us_BFu16ll_BFu1s()
{
  {
    init_simple_test("Us_BFu16ll_BFu1s");
    static STRUCT_IF_C Us_BFu16ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_BFu16ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu1s, Us_BFu16ll_BFu1s)
//============================================================================


struct  Us_BFu16ll_BFu31i  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned int v3:31;
};
//SIG(1 Us_BFu16ll_BFu31i) C1{ Fs FL:16 Fi:31}



static void Test_Us_BFu16ll_BFu31i()
{
  {
    init_simple_test("Us_BFu16ll_BFu31i");
    static STRUCT_IF_C Us_BFu16ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Us_BFu16ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu16ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu31i, Us_BFu16ll_BFu31i)
//============================================================================


struct  Us_BFu16ll_BFu31ll  {
  unsigned short v1;
  __tsu64 v2:16;
  __tsu64 v3:31;
};
//SIG(1 Us_BFu16ll_BFu31ll) C1{ Fs FL:16 FL:31}



static void Test_Us_BFu16ll_BFu31ll()
{
  {
    init_simple_test("Us_BFu16ll_BFu31ll");
    static STRUCT_IF_C Us_BFu16ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Us_BFu16ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu16ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu31ll, Us_BFu16ll_BFu31ll)
//============================================================================


struct  Us_BFu16ll_BFu32i  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned int v3:32;
};
//SIG(1 Us_BFu16ll_BFu32i) C1{ Fs FL:16 Fi:32}



static void Test_Us_BFu16ll_BFu32i()
{
  {
    init_simple_test("Us_BFu16ll_BFu32i");
    static STRUCT_IF_C Us_BFu16ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Us_BFu16ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu16ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu32i, Us_BFu16ll_BFu32i)
//============================================================================


struct  Us_BFu16ll_BFu32ll  {
  unsigned short v1;
  __tsu64 v2:16;
  __tsu64 v3:32;
};
//SIG(1 Us_BFu16ll_BFu32ll) C1{ Fs FL:16 FL:32}



static void Test_Us_BFu16ll_BFu32ll()
{
  {
    init_simple_test("Us_BFu16ll_BFu32ll");
    static STRUCT_IF_C Us_BFu16ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Us_BFu16ll_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu16ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu32ll, Us_BFu16ll_BFu32ll)
//============================================================================


struct  Us_BFu16ll_BFu33  {
  unsigned short v1;
  __tsu64 v2:16;
  __tsu64 v3:33;
};
//SIG(1 Us_BFu16ll_BFu33) C1{ Fs FL:16 FL:33}



static void Test_Us_BFu16ll_BFu33()
{
  {
    init_simple_test("Us_BFu16ll_BFu33");
    static STRUCT_IF_C Us_BFu16ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu16ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu33)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "Us_BFu16ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Us_BFu16ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu33, Us_BFu16ll_BFu33)
//============================================================================


struct  Us_BFu16ll_BFu7c  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned char v3:7;
};
//SIG(1 Us_BFu16ll_BFu7c) C1{ Fs FL:16 Fc:7}



static void Test_Us_BFu16ll_BFu7c()
{
  {
    init_simple_test("Us_BFu16ll_BFu7c");
    static STRUCT_IF_C Us_BFu16ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu16ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu16ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu7c, Us_BFu16ll_BFu7c)
//============================================================================


struct  Us_BFu16ll_BFu7i  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned int v3:7;
};
//SIG(1 Us_BFu16ll_BFu7i) C1{ Fs FL:16 Fi:7}



static void Test_Us_BFu16ll_BFu7i()
{
  {
    init_simple_test("Us_BFu16ll_BFu7i");
    static STRUCT_IF_C Us_BFu16ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu16ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu16ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu7i, Us_BFu16ll_BFu7i)
//============================================================================


struct  Us_BFu16ll_BFu7ll  {
  unsigned short v1;
  __tsu64 v2:16;
  __tsu64 v3:7;
};
//SIG(1 Us_BFu16ll_BFu7ll) C1{ Fs FL:16 FL:7}



static void Test_Us_BFu16ll_BFu7ll()
{
  {
    init_simple_test("Us_BFu16ll_BFu7ll");
    static STRUCT_IF_C Us_BFu16ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu16ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu16ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu7ll, Us_BFu16ll_BFu7ll)
//============================================================================


struct  Us_BFu16ll_BFu7s  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned short v3:7;
};
//SIG(1 Us_BFu16ll_BFu7s) C1{ Fs FL:16 Fs:7}



static void Test_Us_BFu16ll_BFu7s()
{
  {
    init_simple_test("Us_BFu16ll_BFu7s");
    static STRUCT_IF_C Us_BFu16ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu16ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu16ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu7s, Us_BFu16ll_BFu7s)
//============================================================================


struct  Us_BFu16ll_BFu8c  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned char v3:8;
};
//SIG(1 Us_BFu16ll_BFu8c) C1{ Fs FL:16 Fc:8}



static void Test_Us_BFu16ll_BFu8c()
{
  {
    init_simple_test("Us_BFu16ll_BFu8c");
    static STRUCT_IF_C Us_BFu16ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu16ll_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu16ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu8c, Us_BFu16ll_BFu8c)
//============================================================================


struct  Us_BFu16ll_BFu8i  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned int v3:8;
};
//SIG(1 Us_BFu16ll_BFu8i) C1{ Fs FL:16 Fi:8}



static void Test_Us_BFu16ll_BFu8i()
{
  {
    init_simple_test("Us_BFu16ll_BFu8i");
    static STRUCT_IF_C Us_BFu16ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu16ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu16ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu8i, Us_BFu16ll_BFu8i)
//============================================================================


struct  Us_BFu16ll_BFu8ll  {
  unsigned short v1;
  __tsu64 v2:16;
  __tsu64 v3:8;
};
//SIG(1 Us_BFu16ll_BFu8ll) C1{ Fs FL:16 FL:8}



static void Test_Us_BFu16ll_BFu8ll()
{
  {
    init_simple_test("Us_BFu16ll_BFu8ll");
    static STRUCT_IF_C Us_BFu16ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu16ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu16ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu8ll, Us_BFu16ll_BFu8ll)
//============================================================================


struct  Us_BFu16ll_BFu8s  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned short v3:8;
};
//SIG(1 Us_BFu16ll_BFu8s) C1{ Fs FL:16 Fs:8}



static void Test_Us_BFu16ll_BFu8s()
{
  {
    init_simple_test("Us_BFu16ll_BFu8s");
    static STRUCT_IF_C Us_BFu16ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu16ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu16ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu8s, Us_BFu16ll_BFu8s)
//============================================================================


struct  Us_BFu16ll_BFu9i  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned int v3:9;
};
//SIG(1 Us_BFu16ll_BFu9i) C1{ Fs FL:16 Fi:9}



static void Test_Us_BFu16ll_BFu9i()
{
  {
    init_simple_test("Us_BFu16ll_BFu9i");
    static STRUCT_IF_C Us_BFu16ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_BFu16ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_BFu16ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu9i, Us_BFu16ll_BFu9i)
//============================================================================


struct  Us_BFu16ll_BFu9ll  {
  unsigned short v1;
  __tsu64 v2:16;
  __tsu64 v3:9;
};
//SIG(1 Us_BFu16ll_BFu9ll) C1{ Fs FL:16 FL:9}



static void Test_Us_BFu16ll_BFu9ll()
{
  {
    init_simple_test("Us_BFu16ll_BFu9ll");
    static STRUCT_IF_C Us_BFu16ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_BFu16ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_BFu16ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu9ll, Us_BFu16ll_BFu9ll)
//============================================================================


struct  Us_BFu16ll_BFu9s  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned short v3:9;
};
//SIG(1 Us_BFu16ll_BFu9s) C1{ Fs FL:16 Fs:9}



static void Test_Us_BFu16ll_BFu9s()
{
  {
    init_simple_test("Us_BFu16ll_BFu9s");
    static STRUCT_IF_C Us_BFu16ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_BFu16ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_BFu16ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_BFu9s, Us_BFu16ll_BFu9s)
//============================================================================


struct  Us_BFu16ll_C  {
  unsigned short v1;
  __tsu64 v2:16;
  char v3;
};
//SIG(1 Us_BFu16ll_C) C1{ Fs FL:16 Fc}



static void Test_Us_BFu16ll_C()
{
  {
    init_simple_test("Us_BFu16ll_C");
    static STRUCT_IF_C Us_BFu16ll_C lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_C)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_C");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_C");
    check_field_offset(lv, v3, 4, "Us_BFu16ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_C, Us_BFu16ll_C)
//============================================================================


struct  Us_BFu16ll_D  {
  unsigned short v1;
  __tsu64 v2:16;
  double v3;
};
//SIG(1 Us_BFu16ll_D) C1{ Fs FL:16 FL}



static void Test_Us_BFu16ll_D()
{
  {
    init_simple_test("Us_BFu16ll_D");
    static STRUCT_IF_C Us_BFu16ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu16ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_D)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_D");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu16ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_D, Us_BFu16ll_D)
//============================================================================


struct  Us_BFu16ll_F  {
  unsigned short v1;
  __tsu64 v2:16;
  float v3;
};
//SIG(1 Us_BFu16ll_F) C1{ Fs FL:16 Fi}



static void Test_Us_BFu16ll_F()
{
  {
    init_simple_test("Us_BFu16ll_F");
    static STRUCT_IF_C Us_BFu16ll_F lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_F)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_F");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_F");
    check_field_offset(lv, v3, 4, "Us_BFu16ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_F, Us_BFu16ll_F)
//============================================================================


struct  Us_BFu16ll_I  {
  unsigned short v1;
  __tsu64 v2:16;
  int v3;
};
//SIG(1 Us_BFu16ll_I) C1{ Fs FL:16 Fi}



static void Test_Us_BFu16ll_I()
{
  {
    init_simple_test("Us_BFu16ll_I");
    static STRUCT_IF_C Us_BFu16ll_I lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_I)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_I");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_I");
    check_field_offset(lv, v3, 4, "Us_BFu16ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_I, Us_BFu16ll_I)
//============================================================================


struct  Us_BFu16ll_Ip  {
  unsigned short v1;
  __tsu64 v2:16;
  int *v3;
};
//SIG(1 Us_BFu16ll_Ip) C1{ Fs FL:16 Fp}



static void Test_Us_BFu16ll_Ip()
{
  {
    init_simple_test("Us_BFu16ll_Ip");
    static STRUCT_IF_C Us_BFu16ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu16ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_Ip)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu16ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_Ip, Us_BFu16ll_Ip)
//============================================================================


struct  Us_BFu16ll_L  {
  unsigned short v1;
  __tsu64 v2:16;
  __tsi64 v3;
};
//SIG(1 Us_BFu16ll_L) C1{ Fs FL:16 FL}



static void Test_Us_BFu16ll_L()
{
  {
    init_simple_test("Us_BFu16ll_L");
    static STRUCT_IF_C Us_BFu16ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu16ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_L)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_L");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu16ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_L, Us_BFu16ll_L)
//============================================================================


struct  Us_BFu16ll_S  {
  unsigned short v1;
  __tsu64 v2:16;
  short v3;
};
//SIG(1 Us_BFu16ll_S) C1{ Fs FL:16 Fs}



static void Test_Us_BFu16ll_S()
{
  {
    init_simple_test("Us_BFu16ll_S");
    static STRUCT_IF_C Us_BFu16ll_S lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_S)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_S");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_S");
    check_field_offset(lv, v3, 4, "Us_BFu16ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_S, Us_BFu16ll_S)
//============================================================================


struct  Us_BFu16ll_Uc  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned char v3;
};
//SIG(1 Us_BFu16ll_Uc) C1{ Fs FL:16 Fc}



static void Test_Us_BFu16ll_Uc()
{
  {
    init_simple_test("Us_BFu16ll_Uc");
    static STRUCT_IF_C Us_BFu16ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_Uc)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_Uc");
    check_field_offset(lv, v3, 4, "Us_BFu16ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_Uc, Us_BFu16ll_Uc)
//============================================================================


struct  Us_BFu16ll_Ui  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned int v3;
};
//SIG(1 Us_BFu16ll_Ui) C1{ Fs FL:16 Fi}



static void Test_Us_BFu16ll_Ui()
{
  {
    init_simple_test("Us_BFu16ll_Ui");
    static STRUCT_IF_C Us_BFu16ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_Ui)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_Ui");
    check_field_offset(lv, v3, 4, "Us_BFu16ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_Ui, Us_BFu16ll_Ui)
//============================================================================


struct  Us_BFu16ll_Ul  {
  unsigned short v1;
  __tsu64 v2:16;
  __tsu64 v3;
};
//SIG(1 Us_BFu16ll_Ul) C1{ Fs FL:16 FL}



static void Test_Us_BFu16ll_Ul()
{
  {
    init_simple_test("Us_BFu16ll_Ul");
    static STRUCT_IF_C Us_BFu16ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu16ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_Ul)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu16ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_Ul, Us_BFu16ll_Ul)
//============================================================================


struct  Us_BFu16ll_Us  {
  unsigned short v1;
  __tsu64 v2:16;
  unsigned short v3;
};
//SIG(1 Us_BFu16ll_Us) C1{ Fs FL:16 Fs}



static void Test_Us_BFu16ll_Us()
{
  {
    init_simple_test("Us_BFu16ll_Us");
    static STRUCT_IF_C Us_BFu16ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_Us)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_Us");
    check_field_offset(lv, v3, 4, "Us_BFu16ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_Us, Us_BFu16ll_Us)
//============================================================================


struct  Us_BFu16ll_Vp  {
  unsigned short v1;
  __tsu64 v2:16;
  void *v3;
};
//SIG(1 Us_BFu16ll_Vp) C1{ Fs FL:16 Fp}



static void Test_Us_BFu16ll_Vp()
{
  {
    init_simple_test("Us_BFu16ll_Vp");
    static STRUCT_IF_C Us_BFu16ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu16ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16ll_Vp)");
    check_field_offset(lv, v1, 0, "Us_BFu16ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu16ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16ll_Vp, Us_BFu16ll_Vp)
//============================================================================


struct  Us_BFu16s  {
  unsigned short v1;
  unsigned short v2:16;
};
//SIG(1 Us_BFu16s) C1{ Fs Fs:16}



static void Test_Us_BFu16s()
{
  {
    init_simple_test("Us_BFu16s");
    static STRUCT_IF_C Us_BFu16s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s, Us_BFu16s)
//============================================================================


struct  Us_BFu16s_BFu15i  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned int v3:15;
};
//SIG(1 Us_BFu16s_BFu15i) C1{ Fs Fs:16 Fi:15}



static void Test_Us_BFu16s_BFu15i()
{
  {
    init_simple_test("Us_BFu16s_BFu15i");
    static STRUCT_IF_C Us_BFu16s_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16s_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_BFu16s_BFu15i");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_BFu16s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu15i, Us_BFu16s_BFu15i)
//============================================================================


struct  Us_BFu16s_BFu15ll  {
  unsigned short v1;
  unsigned short v2:16;
  __tsu64 v3:15;
};
//SIG(1 Us_BFu16s_BFu15ll) C1{ Fs Fs:16 FL:15}



static void Test_Us_BFu16s_BFu15ll()
{
  {
    init_simple_test("Us_BFu16s_BFu15ll");
    static STRUCT_IF_C Us_BFu16s_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_BFu16s_BFu15ll");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_BFu16s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu15ll, Us_BFu16s_BFu15ll)
//============================================================================


struct  Us_BFu16s_BFu15s  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned short v3:15;
};
//SIG(1 Us_BFu16s_BFu15s) C1{ Fs Fs:16 Fs:15}



static void Test_Us_BFu16s_BFu15s()
{
  {
    init_simple_test("Us_BFu16s_BFu15s");
    static STRUCT_IF_C Us_BFu16s_BFu15s lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu16s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu16s_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, 1, "Us_BFu16s_BFu15s");
    set_bf_and_test(lv, v3, 4, 0, 15, hide_ull(1LL<<14), "Us_BFu16s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu15s, Us_BFu16s_BFu15s)
//============================================================================


struct  Us_BFu16s_BFu16i  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned int v3:16;
};
//SIG(1 Us_BFu16s_BFu16i) C1{ Fs Fs:16 Fi:16}



static void Test_Us_BFu16s_BFu16i()
{
  {
    init_simple_test("Us_BFu16s_BFu16i");
    static STRUCT_IF_C Us_BFu16s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16s_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu16s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu16i, Us_BFu16s_BFu16i)
//============================================================================


struct  Us_BFu16s_BFu16ll  {
  unsigned short v1;
  unsigned short v2:16;
  __tsu64 v3:16;
};
//SIG(1 Us_BFu16s_BFu16ll) C1{ Fs Fs:16 FL:16}



static void Test_Us_BFu16s_BFu16ll()
{
  {
    init_simple_test("Us_BFu16s_BFu16ll");
    static STRUCT_IF_C Us_BFu16s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu16s_BFu16ll");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu16ll, Us_BFu16s_BFu16ll)
//============================================================================


struct  Us_BFu16s_BFu16s  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned short v3:16;
};
//SIG(1 Us_BFu16s_BFu16s) C1{ Fs Fs:16 Fs:16}



static void Test_Us_BFu16s_BFu16s()
{
  {
    init_simple_test("Us_BFu16s_BFu16s");
    static STRUCT_IF_C Us_BFu16s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu16s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu16s_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu16s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu16s, Us_BFu16s_BFu16s)
//============================================================================


struct  Us_BFu16s_BFu17i  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned int v3:17;
};
//SIG(1 Us_BFu16s_BFu17i) C1{ Fs Fs:16 Fi:17}



static void Test_Us_BFu16s_BFu17i()
{
  {
    init_simple_test("Us_BFu16s_BFu17i");
    static STRUCT_IF_C Us_BFu16s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16s_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Us_BFu16s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu16s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu17i, Us_BFu16s_BFu17i)
//============================================================================


struct  Us_BFu16s_BFu17ll  {
  unsigned short v1;
  unsigned short v2:16;
  __tsu64 v3:17;
};
//SIG(1 Us_BFu16s_BFu17ll) C1{ Fs Fs:16 FL:17}



static void Test_Us_BFu16s_BFu17ll()
{
  {
    init_simple_test("Us_BFu16s_BFu17ll");
    static STRUCT_IF_C Us_BFu16s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Us_BFu16s_BFu17ll");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu16s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu17ll, Us_BFu16s_BFu17ll)
//============================================================================


struct  Us_BFu16s_BFu1c  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned char v3:1;
};
//SIG(1 Us_BFu16s_BFu1c) C1{ Fs Fs:16 Fc:1}



static void Test_Us_BFu16s_BFu1c()
{
  {
    init_simple_test("Us_BFu16s_BFu1c");
    static STRUCT_IF_C Us_BFu16s_BFu1c lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu16s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu16s_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu1c");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_BFu16s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu1c, Us_BFu16s_BFu1c)
//============================================================================


struct  Us_BFu16s_BFu1i  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned int v3:1;
};
//SIG(1 Us_BFu16s_BFu1i) C1{ Fs Fs:16 Fi:1}



static void Test_Us_BFu16s_BFu1i()
{
  {
    init_simple_test("Us_BFu16s_BFu1i");
    static STRUCT_IF_C Us_BFu16s_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16s_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu1i");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_BFu16s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu1i, Us_BFu16s_BFu1i)
//============================================================================


struct  Us_BFu16s_BFu1ll  {
  unsigned short v1;
  unsigned short v2:16;
  __tsu64 v3:1;
};
//SIG(1 Us_BFu16s_BFu1ll) C1{ Fs Fs:16 FL:1}



static void Test_Us_BFu16s_BFu1ll()
{
  {
    init_simple_test("Us_BFu16s_BFu1ll");
    static STRUCT_IF_C Us_BFu16s_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu1ll");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_BFu16s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu1ll, Us_BFu16s_BFu1ll)
//============================================================================


struct  Us_BFu16s_BFu1s  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned short v3:1;
};
//SIG(1 Us_BFu16s_BFu1s) C1{ Fs Fs:16 Fs:1}



static void Test_Us_BFu16s_BFu1s()
{
  {
    init_simple_test("Us_BFu16s_BFu1s");
    static STRUCT_IF_C Us_BFu16s_BFu1s lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu16s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu16s_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu1s");
    set_bf_and_test(lv, v3, 4, 0, 1, 1, "Us_BFu16s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu1s, Us_BFu16s_BFu1s)
//============================================================================


struct  Us_BFu16s_BFu31i  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned int v3:31;
};
//SIG(1 Us_BFu16s_BFu31i) C1{ Fs Fs:16 Fi:31}



static void Test_Us_BFu16s_BFu31i()
{
  {
    init_simple_test("Us_BFu16s_BFu31i");
    static STRUCT_IF_C Us_BFu16s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16s_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Us_BFu16s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu16s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu31i, Us_BFu16s_BFu31i)
//============================================================================


struct  Us_BFu16s_BFu31ll  {
  unsigned short v1;
  unsigned short v2:16;
  __tsu64 v3:31;
};
//SIG(1 Us_BFu16s_BFu31ll) C1{ Fs Fs:16 FL:31}



static void Test_Us_BFu16s_BFu31ll()
{
  {
    init_simple_test("Us_BFu16s_BFu31ll");
    static STRUCT_IF_C Us_BFu16s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Us_BFu16s_BFu31ll");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu16s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu31ll, Us_BFu16s_BFu31ll)
//============================================================================


struct  Us_BFu16s_BFu32i  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned int v3:32;
};
//SIG(1 Us_BFu16s_BFu32i) C1{ Fs Fs:16 Fi:32}



static void Test_Us_BFu16s_BFu32i()
{
  {
    init_simple_test("Us_BFu16s_BFu32i");
    static STRUCT_IF_C Us_BFu16s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16s_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Us_BFu16s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu16s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu32i, Us_BFu16s_BFu32i)
//============================================================================


struct  Us_BFu16s_BFu32ll  {
  unsigned short v1;
  unsigned short v2:16;
  __tsu64 v3:32;
};
//SIG(1 Us_BFu16s_BFu32ll) C1{ Fs Fs:16 FL:32}



static void Test_Us_BFu16s_BFu32ll()
{
  {
    init_simple_test("Us_BFu16s_BFu32ll");
    static STRUCT_IF_C Us_BFu16s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Us_BFu16s_BFu32ll");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu16s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu32ll, Us_BFu16s_BFu32ll)
//============================================================================


struct  Us_BFu16s_BFu33  {
  unsigned short v1;
  unsigned short v2:16;
  __tsu64 v3:33;
};
//SIG(1 Us_BFu16s_BFu33) C1{ Fs Fs:16 FL:33}



static void Test_Us_BFu16s_BFu33()
{
  {
    init_simple_test("Us_BFu16s_BFu33");
    static STRUCT_IF_C Us_BFu16s_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu16s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16s_BFu33)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, 1, "Us_BFu16s_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), 0, 33, hide_ull(1LL<<32), "Us_BFu16s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu33, Us_BFu16s_BFu33)
//============================================================================


struct  Us_BFu16s_BFu7c  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned char v3:7;
};
//SIG(1 Us_BFu16s_BFu7c) C1{ Fs Fs:16 Fc:7}



static void Test_Us_BFu16s_BFu7c()
{
  {
    init_simple_test("Us_BFu16s_BFu7c");
    static STRUCT_IF_C Us_BFu16s_BFu7c lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu16s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu16s_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu16s_BFu7c");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu16s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu7c, Us_BFu16s_BFu7c)
//============================================================================


struct  Us_BFu16s_BFu7i  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned int v3:7;
};
//SIG(1 Us_BFu16s_BFu7i) C1{ Fs Fs:16 Fi:7}



static void Test_Us_BFu16s_BFu7i()
{
  {
    init_simple_test("Us_BFu16s_BFu7i");
    static STRUCT_IF_C Us_BFu16s_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16s_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu16s_BFu7i");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu16s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu7i, Us_BFu16s_BFu7i)
//============================================================================


struct  Us_BFu16s_BFu7ll  {
  unsigned short v1;
  unsigned short v2:16;
  __tsu64 v3:7;
};
//SIG(1 Us_BFu16s_BFu7ll) C1{ Fs Fs:16 FL:7}



static void Test_Us_BFu16s_BFu7ll()
{
  {
    init_simple_test("Us_BFu16s_BFu7ll");
    static STRUCT_IF_C Us_BFu16s_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu16s_BFu7ll");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu16s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu7ll, Us_BFu16s_BFu7ll)
//============================================================================


struct  Us_BFu16s_BFu7s  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned short v3:7;
};
//SIG(1 Us_BFu16s_BFu7s) C1{ Fs Fs:16 Fs:7}



static void Test_Us_BFu16s_BFu7s()
{
  {
    init_simple_test("Us_BFu16s_BFu7s");
    static STRUCT_IF_C Us_BFu16s_BFu7s lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu16s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu16s_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, 1, "Us_BFu16s_BFu7s");
    set_bf_and_test(lv, v3, 4, 0, 7, hide_ull(1LL<<6), "Us_BFu16s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu7s, Us_BFu16s_BFu7s)
//============================================================================


struct  Us_BFu16s_BFu8c  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned char v3:8;
};
//SIG(1 Us_BFu16s_BFu8c) C1{ Fs Fs:16 Fc:8}



static void Test_Us_BFu16s_BFu8c()
{
  {
    init_simple_test("Us_BFu16s_BFu8c");
    static STRUCT_IF_C Us_BFu16s_BFu8c lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu16s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu16s_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu16s_BFu8c");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu16s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu8c, Us_BFu16s_BFu8c)
//============================================================================


struct  Us_BFu16s_BFu8i  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned int v3:8;
};
//SIG(1 Us_BFu16s_BFu8i) C1{ Fs Fs:16 Fi:8}



static void Test_Us_BFu16s_BFu8i()
{
  {
    init_simple_test("Us_BFu16s_BFu8i");
    static STRUCT_IF_C Us_BFu16s_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16s_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu16s_BFu8i");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu16s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu8i, Us_BFu16s_BFu8i)
//============================================================================


struct  Us_BFu16s_BFu8ll  {
  unsigned short v1;
  unsigned short v2:16;
  __tsu64 v3:8;
};
//SIG(1 Us_BFu16s_BFu8ll) C1{ Fs Fs:16 FL:8}



static void Test_Us_BFu16s_BFu8ll()
{
  {
    init_simple_test("Us_BFu16s_BFu8ll");
    static STRUCT_IF_C Us_BFu16s_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu16s_BFu8ll");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu16s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu8ll, Us_BFu16s_BFu8ll)
//============================================================================


struct  Us_BFu16s_BFu8s  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned short v3:8;
};
//SIG(1 Us_BFu16s_BFu8s) C1{ Fs Fs:16 Fs:8}



static void Test_Us_BFu16s_BFu8s()
{
  {
    init_simple_test("Us_BFu16s_BFu8s");
    static STRUCT_IF_C Us_BFu16s_BFu8s lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu16s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu16s_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, 1, "Us_BFu16s_BFu8s");
    set_bf_and_test(lv, v3, 4, 0, 8, hide_ull(1LL<<7), "Us_BFu16s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu8s, Us_BFu16s_BFu8s)
//============================================================================


struct  Us_BFu16s_BFu9i  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned int v3:9;
};
//SIG(1 Us_BFu16s_BFu9i) C1{ Fs Fs:16 Fi:9}



static void Test_Us_BFu16s_BFu9i()
{
  {
    init_simple_test("Us_BFu16s_BFu9i");
    static STRUCT_IF_C Us_BFu16s_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16s_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_BFu16s_BFu9i");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_BFu16s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu9i, Us_BFu16s_BFu9i)
//============================================================================


struct  Us_BFu16s_BFu9ll  {
  unsigned short v1;
  unsigned short v2:16;
  __tsu64 v3:9;
};
//SIG(1 Us_BFu16s_BFu9ll) C1{ Fs Fs:16 FL:9}



static void Test_Us_BFu16s_BFu9ll()
{
  {
    init_simple_test("Us_BFu16s_BFu9ll");
    static STRUCT_IF_C Us_BFu16s_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_BFu16s_BFu9ll");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_BFu16s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu9ll, Us_BFu16s_BFu9ll)
//============================================================================


struct  Us_BFu16s_BFu9s  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned short v3:9;
};
//SIG(1 Us_BFu16s_BFu9s) C1{ Fs Fs:16 Fs:9}



static void Test_Us_BFu16s_BFu9s()
{
  {
    init_simple_test("Us_BFu16s_BFu9s");
    static STRUCT_IF_C Us_BFu16s_BFu9s lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu16s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu16s_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, 1, "Us_BFu16s_BFu9s");
    set_bf_and_test(lv, v3, 4, 0, 9, hide_ull(1LL<<8), "Us_BFu16s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_BFu9s, Us_BFu16s_BFu9s)
//============================================================================


struct  Us_BFu16s_C  {
  unsigned short v1;
  unsigned short v2:16;
  char v3;
};
//SIG(1 Us_BFu16s_C) C1{ Fs Fs:16 Fc}



static void Test_Us_BFu16s_C()
{
  {
    init_simple_test("Us_BFu16s_C");
    static STRUCT_IF_C Us_BFu16s_C lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu16s_C)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu16s_C)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_C");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_C");
    check_field_offset(lv, v3, 4, "Us_BFu16s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_C, Us_BFu16s_C)
//============================================================================


struct  Us_BFu16s_D  {
  unsigned short v1;
  unsigned short v2:16;
  double v3;
};
//SIG(1 Us_BFu16s_D) C1{ Fs Fs:16 FL}



static void Test_Us_BFu16s_D()
{
  {
    init_simple_test("Us_BFu16s_D");
    static STRUCT_IF_C Us_BFu16s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu16s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16s_D)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_D");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu16s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_D, Us_BFu16s_D)
//============================================================================


struct  Us_BFu16s_F  {
  unsigned short v1;
  unsigned short v2:16;
  float v3;
};
//SIG(1 Us_BFu16s_F) C1{ Fs Fs:16 Fi}



static void Test_Us_BFu16s_F()
{
  {
    init_simple_test("Us_BFu16s_F");
    static STRUCT_IF_C Us_BFu16s_F lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_F)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16s_F)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_F");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_F");
    check_field_offset(lv, v3, 4, "Us_BFu16s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_F, Us_BFu16s_F)
//============================================================================


struct  Us_BFu16s_I  {
  unsigned short v1;
  unsigned short v2:16;
  int v3;
};
//SIG(1 Us_BFu16s_I) C1{ Fs Fs:16 Fi}



static void Test_Us_BFu16s_I()
{
  {
    init_simple_test("Us_BFu16s_I");
    static STRUCT_IF_C Us_BFu16s_I lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_I)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16s_I)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_I");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_I");
    check_field_offset(lv, v3, 4, "Us_BFu16s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_I, Us_BFu16s_I)
//============================================================================


struct  Us_BFu16s_Ip  {
  unsigned short v1;
  unsigned short v2:16;
  int *v3;
};
//SIG(1 Us_BFu16s_Ip) C1{ Fs Fs:16 Fp}



static void Test_Us_BFu16s_Ip()
{
  {
    init_simple_test("Us_BFu16s_Ip");
    static STRUCT_IF_C Us_BFu16s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu16s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16s_Ip)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_Ip");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu16s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_Ip, Us_BFu16s_Ip)
//============================================================================


struct  Us_BFu16s_L  {
  unsigned short v1;
  unsigned short v2:16;
  __tsi64 v3;
};
//SIG(1 Us_BFu16s_L) C1{ Fs Fs:16 FL}



static void Test_Us_BFu16s_L()
{
  {
    init_simple_test("Us_BFu16s_L");
    static STRUCT_IF_C Us_BFu16s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu16s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16s_L)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_L");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu16s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_L, Us_BFu16s_L)
//============================================================================


struct  Us_BFu16s_S  {
  unsigned short v1;
  unsigned short v2:16;
  short v3;
};
//SIG(1 Us_BFu16s_S) C1{ Fs Fs:16 Fs}



static void Test_Us_BFu16s_S()
{
  {
    init_simple_test("Us_BFu16s_S");
    static STRUCT_IF_C Us_BFu16s_S lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu16s_S)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu16s_S)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_S");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_S");
    check_field_offset(lv, v3, 4, "Us_BFu16s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_S, Us_BFu16s_S)
//============================================================================


struct  Us_BFu16s_Uc  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned char v3;
};
//SIG(1 Us_BFu16s_Uc) C1{ Fs Fs:16 Fc}



static void Test_Us_BFu16s_Uc()
{
  {
    init_simple_test("Us_BFu16s_Uc");
    static STRUCT_IF_C Us_BFu16s_Uc lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu16s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu16s_Uc)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_Uc");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_Uc");
    check_field_offset(lv, v3, 4, "Us_BFu16s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_Uc, Us_BFu16s_Uc)
//============================================================================


struct  Us_BFu16s_Ui  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned int v3;
};
//SIG(1 Us_BFu16s_Ui) C1{ Fs Fs:16 Fi}



static void Test_Us_BFu16s_Ui()
{
  {
    init_simple_test("Us_BFu16s_Ui");
    static STRUCT_IF_C Us_BFu16s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu16s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu16s_Ui)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_Ui");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_Ui");
    check_field_offset(lv, v3, 4, "Us_BFu16s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_Ui, Us_BFu16s_Ui)
//============================================================================


struct  Us_BFu16s_Ul  {
  unsigned short v1;
  unsigned short v2:16;
  __tsu64 v3;
};
//SIG(1 Us_BFu16s_Ul) C1{ Fs Fs:16 FL}



static void Test_Us_BFu16s_Ul()
{
  {
    init_simple_test("Us_BFu16s_Ul");
    static STRUCT_IF_C Us_BFu16s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu16s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16s_Ul)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_Ul");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu16s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_Ul, Us_BFu16s_Ul)
//============================================================================


struct  Us_BFu16s_Us  {
  unsigned short v1;
  unsigned short v2:16;
  unsigned short v3;
};
//SIG(1 Us_BFu16s_Us) C1{ Fs Fs:16 Fs}



static void Test_Us_BFu16s_Us()
{
  {
    init_simple_test("Us_BFu16s_Us");
    static STRUCT_IF_C Us_BFu16s_Us lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu16s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu16s_Us)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_Us");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_Us");
    check_field_offset(lv, v3, 4, "Us_BFu16s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_Us, Us_BFu16s_Us)
//============================================================================


struct  Us_BFu16s_Vp  {
  unsigned short v1;
  unsigned short v2:16;
  void *v3;
};
//SIG(1 Us_BFu16s_Vp) C1{ Fs Fs:16 Fp}



static void Test_Us_BFu16s_Vp()
{
  {
    init_simple_test("Us_BFu16s_Vp");
    static STRUCT_IF_C Us_BFu16s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu16s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu16s_Vp)");
    check_field_offset(lv, v1, 0, "Us_BFu16s_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 16, 1, "Us_BFu16s_Vp");
    set_bf_and_test(lv, v2, 2, 0, 16, hide_ull(1LL<<15), "Us_BFu16s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu16s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu16s_Vp, Us_BFu16s_Vp)
//============================================================================


struct  Us_BFu17i  {
  unsigned short v1;
  unsigned int v2:17;
};
//SIG(1 Us_BFu17i) C1{ Fs Fi:17}



static void Test_Us_BFu17i()
{
  {
    init_simple_test("Us_BFu17i");
    static STRUCT_IF_C Us_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i, Us_BFu17i)
//============================================================================


struct  Us_BFu17i_BFu15i  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned int v3:15;
};
//SIG(1 Us_BFu17i_BFu15i) C1{ Fs Fi:17 Fi:15}



static void Test_Us_BFu17i_BFu15i()
{
  {
    init_simple_test("Us_BFu17i_BFu15i");
    static STRUCT_IF_C Us_BFu17i_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "Us_BFu17i_BFu15i");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "Us_BFu17i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu15i, Us_BFu17i_BFu15i)
//============================================================================


struct  Us_BFu17i_BFu15ll  {
  unsigned short v1;
  unsigned int v2:17;
  __tsu64 v3:15;
};
//SIG(1 Us_BFu17i_BFu15ll) C1{ Fs Fi:17 FL:15}



static void Test_Us_BFu17i_BFu15ll()
{
  {
    init_simple_test("Us_BFu17i_BFu15ll");
    static STRUCT_IF_C Us_BFu17i_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "Us_BFu17i_BFu15ll");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "Us_BFu17i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu15ll, Us_BFu17i_BFu15ll)
//============================================================================


struct  Us_BFu17i_BFu15s  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned short v3:15;
};
//SIG(1 Us_BFu17i_BFu15s) C1{ Fs Fi:17 Fs:15}



static void Test_Us_BFu17i_BFu15s()
{
  {
    init_simple_test("Us_BFu17i_BFu15s");
    static STRUCT_IF_C Us_BFu17i_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, 1, "Us_BFu17i_BFu15s");
    set_bf_and_test(lv, v3, 6, 1, 15, hide_ull(1LL<<14), "Us_BFu17i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu15s, Us_BFu17i_BFu15s)
//============================================================================


struct  Us_BFu17i_BFu16i  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned int v3:16;
};
//SIG(1 Us_BFu17i_BFu16i) C1{ Fs Fi:17 Fi:16}



static void Test_Us_BFu17i_BFu16i()
{
  {
    init_simple_test("Us_BFu17i_BFu16i");
    static STRUCT_IF_C Us_BFu17i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu17i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Us_BFu17i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Us_BFu17i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu16i, Us_BFu17i_BFu16i)
//============================================================================


struct  Us_BFu17i_BFu16ll  {
  unsigned short v1;
  unsigned int v2:17;
  __tsu64 v3:16;
};
//SIG(1 Us_BFu17i_BFu16ll) C1{ Fs Fi:17 FL:16}



static void Test_Us_BFu17i_BFu16ll()
{
  {
    init_simple_test("Us_BFu17i_BFu16ll");
    static STRUCT_IF_C Us_BFu17i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu17i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 16, 1, "Us_BFu17i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 16, hide_ull(1LL<<15), "Us_BFu17i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu16ll, Us_BFu17i_BFu16ll)
//============================================================================


struct  Us_BFu17i_BFu16s  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned short v3:16;
};
//SIG(1 Us_BFu17i_BFu16s) C1{ Fs Fi:17 Fs:16}



static void Test_Us_BFu17i_BFu16s()
{
  {
    init_simple_test("Us_BFu17i_BFu16s");
    static STRUCT_IF_C Us_BFu17i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu17i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Us_BFu17i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Us_BFu17i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu16s, Us_BFu17i_BFu16s)
//============================================================================


struct  Us_BFu17i_BFu17i  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned int v3:17;
};
//SIG(1 Us_BFu17i_BFu17i) C1{ Fs Fi:17 Fi:17}



static void Test_Us_BFu17i_BFu17i()
{
  {
    init_simple_test("Us_BFu17i_BFu17i");
    static STRUCT_IF_C Us_BFu17i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu17i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Us_BFu17i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu17i, Us_BFu17i_BFu17i)
//============================================================================


struct  Us_BFu17i_BFu17ll  {
  unsigned short v1;
  unsigned int v2:17;
  __tsu64 v3:17;
};
//SIG(1 Us_BFu17i_BFu17ll) C1{ Fs Fi:17 FL:17}



static void Test_Us_BFu17i_BFu17ll()
{
  {
    init_simple_test("Us_BFu17i_BFu17ll");
    static STRUCT_IF_C Us_BFu17i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu17i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 17, 1, "Us_BFu17i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 17, hide_ull(1LL<<16), "Us_BFu17i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu17ll, Us_BFu17i_BFu17ll)
//============================================================================


struct  Us_BFu17i_BFu1c  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned char v3:1;
};
//SIG(1 Us_BFu17i_BFu1c) C1{ Fs Fi:17 Fc:1}



static void Test_Us_BFu17i_BFu1c()
{
  {
    init_simple_test("Us_BFu17i_BFu1c");
    static STRUCT_IF_C Us_BFu17i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu1c");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "Us_BFu17i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu1c, Us_BFu17i_BFu1c)
//============================================================================


struct  Us_BFu17i_BFu1i  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned int v3:1;
};
//SIG(1 Us_BFu17i_BFu1i) C1{ Fs Fi:17 Fi:1}



static void Test_Us_BFu17i_BFu1i()
{
  {
    init_simple_test("Us_BFu17i_BFu1i");
    static STRUCT_IF_C Us_BFu17i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu1i");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "Us_BFu17i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu1i, Us_BFu17i_BFu1i)
//============================================================================


struct  Us_BFu17i_BFu1ll  {
  unsigned short v1;
  unsigned int v2:17;
  __tsu64 v3:1;
};
//SIG(1 Us_BFu17i_BFu1ll) C1{ Fs Fi:17 FL:1}



static void Test_Us_BFu17i_BFu1ll()
{
  {
    init_simple_test("Us_BFu17i_BFu1ll");
    static STRUCT_IF_C Us_BFu17i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu1ll");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "Us_BFu17i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu1ll, Us_BFu17i_BFu1ll)
//============================================================================


struct  Us_BFu17i_BFu1s  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned short v3:1;
};
//SIG(1 Us_BFu17i_BFu1s) C1{ Fs Fi:17 Fs:1}



static void Test_Us_BFu17i_BFu1s()
{
  {
    init_simple_test("Us_BFu17i_BFu1s");
    static STRUCT_IF_C Us_BFu17i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu1s");
    set_bf_and_test(lv, v3, 6, 1, 1, 1, "Us_BFu17i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu1s, Us_BFu17i_BFu1s)
//============================================================================


struct  Us_BFu17i_BFu31i  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned int v3:31;
};
//SIG(1 Us_BFu17i_BFu31i) C1{ Fs Fi:17 Fi:31}



static void Test_Us_BFu17i_BFu31i()
{
  {
    init_simple_test("Us_BFu17i_BFu31i");
    static STRUCT_IF_C Us_BFu17i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu17i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Us_BFu17i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Us_BFu17i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu31i, Us_BFu17i_BFu31i)
//============================================================================


struct  Us_BFu17i_BFu31ll  {
  unsigned short v1;
  unsigned int v2:17;
  __tsu64 v3:31;
};
//SIG(1 Us_BFu17i_BFu31ll) C1{ Fs Fi:17 FL:31}



static void Test_Us_BFu17i_BFu31ll()
{
  {
    init_simple_test("Us_BFu17i_BFu31ll");
    static STRUCT_IF_C Us_BFu17i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu17i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 31, 1, "Us_BFu17i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 31, hide_ull(1LL<<30), "Us_BFu17i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu31ll, Us_BFu17i_BFu31ll)
//============================================================================


struct  Us_BFu17i_BFu32i  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned int v3:32;
};
//SIG(1 Us_BFu17i_BFu32i) C1{ Fs Fi:17 Fi:32}



static void Test_Us_BFu17i_BFu32i()
{
  {
    init_simple_test("Us_BFu17i_BFu32i");
    static STRUCT_IF_C Us_BFu17i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu17i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Us_BFu17i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Us_BFu17i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu32i, Us_BFu17i_BFu32i)
//============================================================================


struct  Us_BFu17i_BFu32ll  {
  unsigned short v1;
  unsigned int v2:17;
  __tsu64 v3:32;
};
//SIG(1 Us_BFu17i_BFu32ll) C1{ Fs Fi:17 FL:32}



static void Test_Us_BFu17i_BFu32ll()
{
  {
    init_simple_test("Us_BFu17i_BFu32ll");
    static STRUCT_IF_C Us_BFu17i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu17i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 32, 1, "Us_BFu17i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 32, hide_ull(1LL<<31), "Us_BFu17i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu32ll, Us_BFu17i_BFu32ll)
//============================================================================


struct  Us_BFu17i_BFu33  {
  unsigned short v1;
  unsigned int v2:17;
  __tsu64 v3:33;
};
//SIG(1 Us_BFu17i_BFu33) C1{ Fs Fi:17 FL:33}



static void Test_Us_BFu17i_BFu33()
{
  {
    init_simple_test("Us_BFu17i_BFu33");
    static STRUCT_IF_C Us_BFu17i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu17i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17i_BFu33)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 33, 1, "Us_BFu17i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,6), ABISELECT(0,1), 33, hide_ull(1LL<<32), "Us_BFu17i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu33, Us_BFu17i_BFu33)
//============================================================================


struct  Us_BFu17i_BFu7c  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned char v3:7;
};
//SIG(1 Us_BFu17i_BFu7c) C1{ Fs Fi:17 Fc:7}



static void Test_Us_BFu17i_BFu7c()
{
  {
    init_simple_test("Us_BFu17i_BFu7c");
    static STRUCT_IF_C Us_BFu17i_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "Us_BFu17i_BFu7c");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "Us_BFu17i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu7c, Us_BFu17i_BFu7c)
//============================================================================


struct  Us_BFu17i_BFu7i  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned int v3:7;
};
//SIG(1 Us_BFu17i_BFu7i) C1{ Fs Fi:17 Fi:7}



static void Test_Us_BFu17i_BFu7i()
{
  {
    init_simple_test("Us_BFu17i_BFu7i");
    static STRUCT_IF_C Us_BFu17i_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "Us_BFu17i_BFu7i");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "Us_BFu17i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu7i, Us_BFu17i_BFu7i)
//============================================================================


struct  Us_BFu17i_BFu7ll  {
  unsigned short v1;
  unsigned int v2:17;
  __tsu64 v3:7;
};
//SIG(1 Us_BFu17i_BFu7ll) C1{ Fs Fi:17 FL:7}



static void Test_Us_BFu17i_BFu7ll()
{
  {
    init_simple_test("Us_BFu17i_BFu7ll");
    static STRUCT_IF_C Us_BFu17i_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "Us_BFu17i_BFu7ll");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "Us_BFu17i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu7ll, Us_BFu17i_BFu7ll)
//============================================================================


struct  Us_BFu17i_BFu7s  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned short v3:7;
};
//SIG(1 Us_BFu17i_BFu7s) C1{ Fs Fi:17 Fs:7}



static void Test_Us_BFu17i_BFu7s()
{
  {
    init_simple_test("Us_BFu17i_BFu7s");
    static STRUCT_IF_C Us_BFu17i_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, 1, "Us_BFu17i_BFu7s");
    set_bf_and_test(lv, v3, 6, 1, 7, hide_ull(1LL<<6), "Us_BFu17i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu7s, Us_BFu17i_BFu7s)
//============================================================================


struct  Us_BFu17i_BFu8c  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned char v3:8;
};
//SIG(1 Us_BFu17i_BFu8c) C1{ Fs Fi:17 Fc:8}



static void Test_Us_BFu17i_BFu8c()
{
  {
    init_simple_test("Us_BFu17i_BFu8c");
    static STRUCT_IF_C Us_BFu17i_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 7, 0, 8, 1, "Us_BFu17i_BFu8c");
    set_bf_and_test(lv, v3, 7, 0, 8, hide_ull(1LL<<7), "Us_BFu17i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu8c, Us_BFu17i_BFu8c)
//============================================================================


struct  Us_BFu17i_BFu8i  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned int v3:8;
};
//SIG(1 Us_BFu17i_BFu8i) C1{ Fs Fi:17 Fi:8}



static void Test_Us_BFu17i_BFu8i()
{
  {
    init_simple_test("Us_BFu17i_BFu8i");
    static STRUCT_IF_C Us_BFu17i_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "Us_BFu17i_BFu8i");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "Us_BFu17i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu8i, Us_BFu17i_BFu8i)
//============================================================================


struct  Us_BFu17i_BFu8ll  {
  unsigned short v1;
  unsigned int v2:17;
  __tsu64 v3:8;
};
//SIG(1 Us_BFu17i_BFu8ll) C1{ Fs Fi:17 FL:8}



static void Test_Us_BFu17i_BFu8ll()
{
  {
    init_simple_test("Us_BFu17i_BFu8ll");
    static STRUCT_IF_C Us_BFu17i_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "Us_BFu17i_BFu8ll");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "Us_BFu17i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu8ll, Us_BFu17i_BFu8ll)
//============================================================================


struct  Us_BFu17i_BFu8s  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned short v3:8;
};
//SIG(1 Us_BFu17i_BFu8s) C1{ Fs Fi:17 Fs:8}



static void Test_Us_BFu17i_BFu8s()
{
  {
    init_simple_test("Us_BFu17i_BFu8s");
    static STRUCT_IF_C Us_BFu17i_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, 1, "Us_BFu17i_BFu8s");
    set_bf_and_test(lv, v3, 6, 1, 8, hide_ull(1LL<<7), "Us_BFu17i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu8s, Us_BFu17i_BFu8s)
//============================================================================


struct  Us_BFu17i_BFu9i  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned int v3:9;
};
//SIG(1 Us_BFu17i_BFu9i) C1{ Fs Fi:17 Fi:9}



static void Test_Us_BFu17i_BFu9i()
{
  {
    init_simple_test("Us_BFu17i_BFu9i");
    static STRUCT_IF_C Us_BFu17i_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "Us_BFu17i_BFu9i");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "Us_BFu17i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu9i, Us_BFu17i_BFu9i)
//============================================================================


struct  Us_BFu17i_BFu9ll  {
  unsigned short v1;
  unsigned int v2:17;
  __tsu64 v3:9;
};
//SIG(1 Us_BFu17i_BFu9ll) C1{ Fs Fi:17 FL:9}



static void Test_Us_BFu17i_BFu9ll()
{
  {
    init_simple_test("Us_BFu17i_BFu9ll");
    static STRUCT_IF_C Us_BFu17i_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "Us_BFu17i_BFu9ll");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "Us_BFu17i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu9ll, Us_BFu17i_BFu9ll)
//============================================================================


struct  Us_BFu17i_BFu9s  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned short v3:9;
};
//SIG(1 Us_BFu17i_BFu9s) C1{ Fs Fi:17 Fs:9}



static void Test_Us_BFu17i_BFu9s()
{
  {
    init_simple_test("Us_BFu17i_BFu9s");
    static STRUCT_IF_C Us_BFu17i_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, 1, "Us_BFu17i_BFu9s");
    set_bf_and_test(lv, v3, 6, 1, 9, hide_ull(1LL<<8), "Us_BFu17i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_BFu9s, Us_BFu17i_BFu9s)
//============================================================================


struct  Us_BFu17i_C  {
  unsigned short v1;
  unsigned int v2:17;
  char v3;
};
//SIG(1 Us_BFu17i_C) C1{ Fs Fi:17 Fc}



static void Test_Us_BFu17i_C()
{
  {
    init_simple_test("Us_BFu17i_C");
    static STRUCT_IF_C Us_BFu17i_C lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_C)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_C");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_C");
    check_field_offset(lv, v3, 7, "Us_BFu17i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_C, Us_BFu17i_C)
//============================================================================


struct  Us_BFu17i_D  {
  unsigned short v1;
  unsigned int v2:17;
  double v3;
};
//SIG(1 Us_BFu17i_D) C1{ Fs Fi:17 FL}



static void Test_Us_BFu17i_D()
{
  {
    init_simple_test("Us_BFu17i_D");
    static STRUCT_IF_C Us_BFu17i_D lv;
    check2(sizeof(lv), 16, "sizeof(Us_BFu17i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17i_D)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_D");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_D");
    check_field_offset(lv, v3, 8, "Us_BFu17i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_D, Us_BFu17i_D)
//============================================================================


struct  Us_BFu17i_F  {
  unsigned short v1;
  unsigned int v2:17;
  float v3;
};
//SIG(1 Us_BFu17i_F) C1{ Fs Fi:17 Fi}



static void Test_Us_BFu17i_F()
{
  {
    init_simple_test("Us_BFu17i_F");
    static STRUCT_IF_C Us_BFu17i_F lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu17i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_F)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_F");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_F");
    check_field_offset(lv, v3, 8, "Us_BFu17i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_F, Us_BFu17i_F)
//============================================================================


struct  Us_BFu17i_I  {
  unsigned short v1;
  unsigned int v2:17;
  int v3;
};
//SIG(1 Us_BFu17i_I) C1{ Fs Fi:17 Fi}



static void Test_Us_BFu17i_I()
{
  {
    init_simple_test("Us_BFu17i_I");
    static STRUCT_IF_C Us_BFu17i_I lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu17i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_I)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_I");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_I");
    check_field_offset(lv, v3, 8, "Us_BFu17i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_I, Us_BFu17i_I)
//============================================================================


struct  Us_BFu17i_Ip  {
  unsigned short v1;
  unsigned int v2:17;
  int *v3;
};
//SIG(1 Us_BFu17i_Ip) C1{ Fs Fi:17 Fp}



static void Test_Us_BFu17i_Ip()
{
  {
    init_simple_test("Us_BFu17i_Ip");
    static STRUCT_IF_C Us_BFu17i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu17i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17i_Ip)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_Ip");
    check_field_offset(lv, v3, 8, "Us_BFu17i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_Ip, Us_BFu17i_Ip)
//============================================================================


struct  Us_BFu17i_L  {
  unsigned short v1;
  unsigned int v2:17;
  __tsi64 v3;
};
//SIG(1 Us_BFu17i_L) C1{ Fs Fi:17 FL}



static void Test_Us_BFu17i_L()
{
  {
    init_simple_test("Us_BFu17i_L");
    static STRUCT_IF_C Us_BFu17i_L lv;
    check2(sizeof(lv), 16, "sizeof(Us_BFu17i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17i_L)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_L");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_L");
    check_field_offset(lv, v3, 8, "Us_BFu17i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_L, Us_BFu17i_L)
//============================================================================


struct  Us_BFu17i_S  {
  unsigned short v1;
  unsigned int v2:17;
  short v3;
};
//SIG(1 Us_BFu17i_S) C1{ Fs Fi:17 Fs}



static void Test_Us_BFu17i_S()
{
  {
    init_simple_test("Us_BFu17i_S");
    static STRUCT_IF_C Us_BFu17i_S lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu17i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_S)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_S");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_S");
    check_field_offset(lv, v3, 8, "Us_BFu17i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_S, Us_BFu17i_S)
//============================================================================


struct  Us_BFu17i_Uc  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned char v3;
};
//SIG(1 Us_BFu17i_Uc) C1{ Fs Fi:17 Fc}



static void Test_Us_BFu17i_Uc()
{
  {
    init_simple_test("Us_BFu17i_Uc");
    static STRUCT_IF_C Us_BFu17i_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_Uc)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_Uc");
    check_field_offset(lv, v3, 7, "Us_BFu17i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_Uc, Us_BFu17i_Uc)
//============================================================================


struct  Us_BFu17i_Ui  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned int v3;
};
//SIG(1 Us_BFu17i_Ui) C1{ Fs Fi:17 Fi}



static void Test_Us_BFu17i_Ui()
{
  {
    init_simple_test("Us_BFu17i_Ui");
    static STRUCT_IF_C Us_BFu17i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu17i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_Ui)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_Ui");
    check_field_offset(lv, v3, 8, "Us_BFu17i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_Ui, Us_BFu17i_Ui)
//============================================================================


struct  Us_BFu17i_Ul  {
  unsigned short v1;
  unsigned int v2:17;
  __tsu64 v3;
};
//SIG(1 Us_BFu17i_Ul) C1{ Fs Fi:17 FL}



static void Test_Us_BFu17i_Ul()
{
  {
    init_simple_test("Us_BFu17i_Ul");
    static STRUCT_IF_C Us_BFu17i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Us_BFu17i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17i_Ul)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_Ul");
    check_field_offset(lv, v3, 8, "Us_BFu17i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_Ul, Us_BFu17i_Ul)
//============================================================================


struct  Us_BFu17i_Us  {
  unsigned short v1;
  unsigned int v2:17;
  unsigned short v3;
};
//SIG(1 Us_BFu17i_Us) C1{ Fs Fi:17 Fs}



static void Test_Us_BFu17i_Us()
{
  {
    init_simple_test("Us_BFu17i_Us");
    static STRUCT_IF_C Us_BFu17i_Us lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu17i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu17i_Us)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_Us");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_Us");
    check_field_offset(lv, v3, 8, "Us_BFu17i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_Us, Us_BFu17i_Us)
//============================================================================


struct  Us_BFu17i_Vp  {
  unsigned short v1;
  unsigned int v2:17;
  void *v3;
};
//SIG(1 Us_BFu17i_Vp) C1{ Fs Fi:17 Fp}



static void Test_Us_BFu17i_Vp()
{
  {
    init_simple_test("Us_BFu17i_Vp");
    static STRUCT_IF_C Us_BFu17i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu17i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17i_Vp)");
    check_field_offset(lv, v1, 0, "Us_BFu17i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 17, 1, "Us_BFu17i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu17i_Vp");
    check_field_offset(lv, v3, 8, "Us_BFu17i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17i_Vp, Us_BFu17i_Vp)
//============================================================================


struct  Us_BFu17ll  {
  unsigned short v1;
  __tsu64 v2:17;
};
//SIG(1 Us_BFu17ll) C1{ Fs FL:17}



static void Test_Us_BFu17ll()
{
  {
    init_simple_test("Us_BFu17ll");
    static STRUCT_IF_C Us_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll, Us_BFu17ll)
//============================================================================


struct  Us_BFu17ll_BFu15i  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned int v3:15;
};
//SIG(1 Us_BFu17ll_BFu15i) C1{ Fs FL:17 Fi:15}



static void Test_Us_BFu17ll_BFu15i()
{
  {
    init_simple_test("Us_BFu17ll_BFu15i");
    static STRUCT_IF_C Us_BFu17ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "Us_BFu17ll_BFu15i");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "Us_BFu17ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu15i, Us_BFu17ll_BFu15i)
//============================================================================


struct  Us_BFu17ll_BFu15ll  {
  unsigned short v1;
  __tsu64 v2:17;
  __tsu64 v3:15;
};
//SIG(1 Us_BFu17ll_BFu15ll) C1{ Fs FL:17 FL:15}



static void Test_Us_BFu17ll_BFu15ll()
{
  {
    init_simple_test("Us_BFu17ll_BFu15ll");
    static STRUCT_IF_C Us_BFu17ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "Us_BFu17ll_BFu15ll");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "Us_BFu17ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu15ll, Us_BFu17ll_BFu15ll)
//============================================================================


struct  Us_BFu17ll_BFu15s  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned short v3:15;
};
//SIG(1 Us_BFu17ll_BFu15s) C1{ Fs FL:17 Fs:15}



static void Test_Us_BFu17ll_BFu15s()
{
  {
    init_simple_test("Us_BFu17ll_BFu15s");
    static STRUCT_IF_C Us_BFu17ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, 1, "Us_BFu17ll_BFu15s");
    set_bf_and_test(lv, v3, 4, 1, 15, hide_ull(1LL<<14), "Us_BFu17ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu15s, Us_BFu17ll_BFu15s)
//============================================================================


struct  Us_BFu17ll_BFu16i  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned int v3:16;
};
//SIG(1 Us_BFu17ll_BFu16i) C1{ Fs FL:17 Fi:16}



static void Test_Us_BFu17ll_BFu16i()
{
  {
    init_simple_test("Us_BFu17ll_BFu16i");
    static STRUCT_IF_C Us_BFu17ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "Us_BFu17ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "Us_BFu17ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu16i, Us_BFu17ll_BFu16i)
//============================================================================


struct  Us_BFu17ll_BFu16ll  {
  unsigned short v1;
  __tsu64 v2:17;
  __tsu64 v3:16;
};
//SIG(1 Us_BFu17ll_BFu16ll) C1{ Fs FL:17 FL:16}



static void Test_Us_BFu17ll_BFu16ll()
{
  {
    init_simple_test("Us_BFu17ll_BFu16ll");
    static STRUCT_IF_C Us_BFu17ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, 1, "Us_BFu17ll_BFu16ll");
    set_bf_and_test(lv, v3, 4, 1, 16, hide_ull(1LL<<15), "Us_BFu17ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu16ll, Us_BFu17ll_BFu16ll)
//============================================================================


struct  Us_BFu17ll_BFu16s  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned short v3:16;
};
//SIG(1 Us_BFu17ll_BFu16s) C1{ Fs FL:17 Fs:16}



static void Test_Us_BFu17ll_BFu16s()
{
  {
    init_simple_test("Us_BFu17ll_BFu16s");
    static STRUCT_IF_C Us_BFu17ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Us_BFu17ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Us_BFu17ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu16s, Us_BFu17ll_BFu16s)
//============================================================================


struct  Us_BFu17ll_BFu17i  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned int v3:17;
};
//SIG(1 Us_BFu17ll_BFu17i) C1{ Fs FL:17 Fi:17}



static void Test_Us_BFu17ll_BFu17i()
{
  {
    init_simple_test("Us_BFu17ll_BFu17i");
    static STRUCT_IF_C Us_BFu17ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "Us_BFu17ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu17i, Us_BFu17ll_BFu17i)
//============================================================================


struct  Us_BFu17ll_BFu17ll  {
  unsigned short v1;
  __tsu64 v2:17;
  __tsu64 v3:17;
};
//SIG(1 Us_BFu17ll_BFu17ll) C1{ Fs FL:17 FL:17}



static void Test_Us_BFu17ll_BFu17ll()
{
  {
    init_simple_test("Us_BFu17ll_BFu17ll");
    static STRUCT_IF_C Us_BFu17ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, 1, "Us_BFu17ll_BFu17ll");
    set_bf_and_test(lv, v3, 4, 1, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu17ll, Us_BFu17ll_BFu17ll)
//============================================================================


struct  Us_BFu17ll_BFu1c  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned char v3:1;
};
//SIG(1 Us_BFu17ll_BFu1c) C1{ Fs FL:17 Fc:1}



static void Test_Us_BFu17ll_BFu1c()
{
  {
    init_simple_test("Us_BFu17ll_BFu1c");
    static STRUCT_IF_C Us_BFu17ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu1c");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Us_BFu17ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu1c, Us_BFu17ll_BFu1c)
//============================================================================


struct  Us_BFu17ll_BFu1i  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned int v3:1;
};
//SIG(1 Us_BFu17ll_BFu1i) C1{ Fs FL:17 Fi:1}



static void Test_Us_BFu17ll_BFu1i()
{
  {
    init_simple_test("Us_BFu17ll_BFu1i");
    static STRUCT_IF_C Us_BFu17ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu1i");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Us_BFu17ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu1i, Us_BFu17ll_BFu1i)
//============================================================================


struct  Us_BFu17ll_BFu1ll  {
  unsigned short v1;
  __tsu64 v2:17;
  __tsu64 v3:1;
};
//SIG(1 Us_BFu17ll_BFu1ll) C1{ Fs FL:17 FL:1}



static void Test_Us_BFu17ll_BFu1ll()
{
  {
    init_simple_test("Us_BFu17ll_BFu1ll");
    static STRUCT_IF_C Us_BFu17ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu1ll");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Us_BFu17ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu1ll, Us_BFu17ll_BFu1ll)
//============================================================================


struct  Us_BFu17ll_BFu1s  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned short v3:1;
};
//SIG(1 Us_BFu17ll_BFu1s) C1{ Fs FL:17 Fs:1}



static void Test_Us_BFu17ll_BFu1s()
{
  {
    init_simple_test("Us_BFu17ll_BFu1s");
    static STRUCT_IF_C Us_BFu17ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu1s");
    set_bf_and_test(lv, v3, 4, 1, 1, 1, "Us_BFu17ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu1s, Us_BFu17ll_BFu1s)
//============================================================================


struct  Us_BFu17ll_BFu31i  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned int v3:31;
};
//SIG(1 Us_BFu17ll_BFu31i) C1{ Fs FL:17 Fi:31}



static void Test_Us_BFu17ll_BFu31i()
{
  {
    init_simple_test("Us_BFu17ll_BFu31i");
    static STRUCT_IF_C Us_BFu17ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "Us_BFu17ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "Us_BFu17ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu31i, Us_BFu17ll_BFu31i)
//============================================================================


struct  Us_BFu17ll_BFu31ll  {
  unsigned short v1;
  __tsu64 v2:17;
  __tsu64 v3:31;
};
//SIG(1 Us_BFu17ll_BFu31ll) C1{ Fs FL:17 FL:31}



static void Test_Us_BFu17ll_BFu31ll()
{
  {
    init_simple_test("Us_BFu17ll_BFu31ll");
    static STRUCT_IF_C Us_BFu17ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, 1, "Us_BFu17ll_BFu31ll");
    set_bf_and_test(lv, v3, 4, 1, 31, hide_ull(1LL<<30), "Us_BFu17ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu31ll, Us_BFu17ll_BFu31ll)
//============================================================================


struct  Us_BFu17ll_BFu32i  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned int v3:32;
};
//SIG(1 Us_BFu17ll_BFu32i) C1{ Fs FL:17 Fi:32}



static void Test_Us_BFu17ll_BFu32i()
{
  {
    init_simple_test("Us_BFu17ll_BFu32i");
    static STRUCT_IF_C Us_BFu17ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu17ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Us_BFu17ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Us_BFu17ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu32i, Us_BFu17ll_BFu32i)
//============================================================================


struct  Us_BFu17ll_BFu32ll  {
  unsigned short v1;
  __tsu64 v2:17;
  __tsu64 v3:32;
};
//SIG(1 Us_BFu17ll_BFu32ll) C1{ Fs FL:17 FL:32}



static void Test_Us_BFu17ll_BFu32ll()
{
  {
    init_simple_test("Us_BFu17ll_BFu32ll");
    static STRUCT_IF_C Us_BFu17ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu17ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 32, 1, "Us_BFu17ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 32, hide_ull(1LL<<31), "Us_BFu17ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu32ll, Us_BFu17ll_BFu32ll)
//============================================================================


struct  Us_BFu17ll_BFu33  {
  unsigned short v1;
  __tsu64 v2:17;
  __tsu64 v3:33;
};
//SIG(1 Us_BFu17ll_BFu33) C1{ Fs FL:17 FL:33}



static void Test_Us_BFu17ll_BFu33()
{
  {
    init_simple_test("Us_BFu17ll_BFu33");
    static STRUCT_IF_C Us_BFu17ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu17ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu33)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 33, 1, "Us_BFu17ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,4), ABISELECT(0,1), 33, hide_ull(1LL<<32), "Us_BFu17ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu33, Us_BFu17ll_BFu33)
//============================================================================


struct  Us_BFu17ll_BFu7c  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned char v3:7;
};
//SIG(1 Us_BFu17ll_BFu7c) C1{ Fs FL:17 Fc:7}



static void Test_Us_BFu17ll_BFu7c()
{
  {
    init_simple_test("Us_BFu17ll_BFu7c");
    static STRUCT_IF_C Us_BFu17ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Us_BFu17ll_BFu7c");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Us_BFu17ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu7c, Us_BFu17ll_BFu7c)
//============================================================================


struct  Us_BFu17ll_BFu7i  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned int v3:7;
};
//SIG(1 Us_BFu17ll_BFu7i) C1{ Fs FL:17 Fi:7}



static void Test_Us_BFu17ll_BFu7i()
{
  {
    init_simple_test("Us_BFu17ll_BFu7i");
    static STRUCT_IF_C Us_BFu17ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Us_BFu17ll_BFu7i");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Us_BFu17ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu7i, Us_BFu17ll_BFu7i)
//============================================================================


struct  Us_BFu17ll_BFu7ll  {
  unsigned short v1;
  __tsu64 v2:17;
  __tsu64 v3:7;
};
//SIG(1 Us_BFu17ll_BFu7ll) C1{ Fs FL:17 FL:7}



static void Test_Us_BFu17ll_BFu7ll()
{
  {
    init_simple_test("Us_BFu17ll_BFu7ll");
    static STRUCT_IF_C Us_BFu17ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Us_BFu17ll_BFu7ll");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Us_BFu17ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu7ll, Us_BFu17ll_BFu7ll)
//============================================================================


struct  Us_BFu17ll_BFu7s  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned short v3:7;
};
//SIG(1 Us_BFu17ll_BFu7s) C1{ Fs FL:17 Fs:7}



static void Test_Us_BFu17ll_BFu7s()
{
  {
    init_simple_test("Us_BFu17ll_BFu7s");
    static STRUCT_IF_C Us_BFu17ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, 1, "Us_BFu17ll_BFu7s");
    set_bf_and_test(lv, v3, 4, 1, 7, hide_ull(1LL<<6), "Us_BFu17ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu7s, Us_BFu17ll_BFu7s)
//============================================================================


struct  Us_BFu17ll_BFu8c  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned char v3:8;
};
//SIG(1 Us_BFu17ll_BFu8c) C1{ Fs FL:17 Fc:8}



static void Test_Us_BFu17ll_BFu8c()
{
  {
    init_simple_test("Us_BFu17ll_BFu8c");
    static STRUCT_IF_C Us_BFu17ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, 1, "Us_BFu17ll_BFu8c");
    set_bf_and_test(lv, v3, 5, 0, 8, hide_ull(1LL<<7), "Us_BFu17ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu8c, Us_BFu17ll_BFu8c)
//============================================================================


struct  Us_BFu17ll_BFu8i  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned int v3:8;
};
//SIG(1 Us_BFu17ll_BFu8i) C1{ Fs FL:17 Fi:8}



static void Test_Us_BFu17ll_BFu8i()
{
  {
    init_simple_test("Us_BFu17ll_BFu8i");
    static STRUCT_IF_C Us_BFu17ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "Us_BFu17ll_BFu8i");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "Us_BFu17ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu8i, Us_BFu17ll_BFu8i)
//============================================================================


struct  Us_BFu17ll_BFu8ll  {
  unsigned short v1;
  __tsu64 v2:17;
  __tsu64 v3:8;
};
//SIG(1 Us_BFu17ll_BFu8ll) C1{ Fs FL:17 FL:8}



static void Test_Us_BFu17ll_BFu8ll()
{
  {
    init_simple_test("Us_BFu17ll_BFu8ll");
    static STRUCT_IF_C Us_BFu17ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "Us_BFu17ll_BFu8ll");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "Us_BFu17ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu8ll, Us_BFu17ll_BFu8ll)
//============================================================================


struct  Us_BFu17ll_BFu8s  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned short v3:8;
};
//SIG(1 Us_BFu17ll_BFu8s) C1{ Fs FL:17 Fs:8}



static void Test_Us_BFu17ll_BFu8s()
{
  {
    init_simple_test("Us_BFu17ll_BFu8s");
    static STRUCT_IF_C Us_BFu17ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, 1, "Us_BFu17ll_BFu8s");
    set_bf_and_test(lv, v3, 4, 1, 8, hide_ull(1LL<<7), "Us_BFu17ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu8s, Us_BFu17ll_BFu8s)
//============================================================================


struct  Us_BFu17ll_BFu9i  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned int v3:9;
};
//SIG(1 Us_BFu17ll_BFu9i) C1{ Fs FL:17 Fi:9}



static void Test_Us_BFu17ll_BFu9i()
{
  {
    init_simple_test("Us_BFu17ll_BFu9i");
    static STRUCT_IF_C Us_BFu17ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "Us_BFu17ll_BFu9i");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "Us_BFu17ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu9i, Us_BFu17ll_BFu9i)
//============================================================================


struct  Us_BFu17ll_BFu9ll  {
  unsigned short v1;
  __tsu64 v2:17;
  __tsu64 v3:9;
};
//SIG(1 Us_BFu17ll_BFu9ll) C1{ Fs FL:17 FL:9}



static void Test_Us_BFu17ll_BFu9ll()
{
  {
    init_simple_test("Us_BFu17ll_BFu9ll");
    static STRUCT_IF_C Us_BFu17ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "Us_BFu17ll_BFu9ll");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "Us_BFu17ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu9ll, Us_BFu17ll_BFu9ll)
//============================================================================


struct  Us_BFu17ll_BFu9s  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned short v3:9;
};
//SIG(1 Us_BFu17ll_BFu9s) C1{ Fs FL:17 Fs:9}



static void Test_Us_BFu17ll_BFu9s()
{
  {
    init_simple_test("Us_BFu17ll_BFu9s");
    static STRUCT_IF_C Us_BFu17ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, 1, "Us_BFu17ll_BFu9s");
    set_bf_and_test(lv, v3, 4, 1, 9, hide_ull(1LL<<8), "Us_BFu17ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_BFu9s, Us_BFu17ll_BFu9s)
//============================================================================


struct  Us_BFu17ll_C  {
  unsigned short v1;
  __tsu64 v2:17;
  char v3;
};
//SIG(1 Us_BFu17ll_C) C1{ Fs FL:17 Fc}



static void Test_Us_BFu17ll_C()
{
  {
    init_simple_test("Us_BFu17ll_C");
    static STRUCT_IF_C Us_BFu17ll_C lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_C)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_C");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_C");
    check_field_offset(lv, v3, 5, "Us_BFu17ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_C, Us_BFu17ll_C)
//============================================================================


struct  Us_BFu17ll_D  {
  unsigned short v1;
  __tsu64 v2:17;
  double v3;
};
//SIG(1 Us_BFu17ll_D) C1{ Fs FL:17 FL}



static void Test_Us_BFu17ll_D()
{
  {
    init_simple_test("Us_BFu17ll_D");
    static STRUCT_IF_C Us_BFu17ll_D lv;
    check2(sizeof(lv), 16, "sizeof(Us_BFu17ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_D)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_D");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_D");
    check_field_offset(lv, v3, 8, "Us_BFu17ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_D, Us_BFu17ll_D)
//============================================================================


struct  Us_BFu17ll_F  {
  unsigned short v1;
  __tsu64 v2:17;
  float v3;
};
//SIG(1 Us_BFu17ll_F) C1{ Fs FL:17 Fi}



static void Test_Us_BFu17ll_F()
{
  {
    init_simple_test("Us_BFu17ll_F");
    static STRUCT_IF_C Us_BFu17ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu17ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_F)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_F");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_F");
    check_field_offset(lv, v3, 8, "Us_BFu17ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_F, Us_BFu17ll_F)
//============================================================================


struct  Us_BFu17ll_I  {
  unsigned short v1;
  __tsu64 v2:17;
  int v3;
};
//SIG(1 Us_BFu17ll_I) C1{ Fs FL:17 Fi}



static void Test_Us_BFu17ll_I()
{
  {
    init_simple_test("Us_BFu17ll_I");
    static STRUCT_IF_C Us_BFu17ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu17ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_I)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_I");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_I");
    check_field_offset(lv, v3, 8, "Us_BFu17ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_I, Us_BFu17ll_I)
//============================================================================


struct  Us_BFu17ll_Ip  {
  unsigned short v1;
  __tsu64 v2:17;
  int *v3;
};
//SIG(1 Us_BFu17ll_Ip) C1{ Fs FL:17 Fp}



static void Test_Us_BFu17ll_Ip()
{
  {
    init_simple_test("Us_BFu17ll_Ip");
    static STRUCT_IF_C Us_BFu17ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu17ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_Ip)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_Ip");
    check_field_offset(lv, v3, 8, "Us_BFu17ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_Ip, Us_BFu17ll_Ip)
//============================================================================


struct  Us_BFu17ll_L  {
  unsigned short v1;
  __tsu64 v2:17;
  __tsi64 v3;
};
//SIG(1 Us_BFu17ll_L) C1{ Fs FL:17 FL}



static void Test_Us_BFu17ll_L()
{
  {
    init_simple_test("Us_BFu17ll_L");
    static STRUCT_IF_C Us_BFu17ll_L lv;
    check2(sizeof(lv), 16, "sizeof(Us_BFu17ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_L)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_L");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_L");
    check_field_offset(lv, v3, 8, "Us_BFu17ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_L, Us_BFu17ll_L)
//============================================================================


struct  Us_BFu17ll_S  {
  unsigned short v1;
  __tsu64 v2:17;
  short v3;
};
//SIG(1 Us_BFu17ll_S) C1{ Fs FL:17 Fs}



static void Test_Us_BFu17ll_S()
{
  {
    init_simple_test("Us_BFu17ll_S");
    static STRUCT_IF_C Us_BFu17ll_S lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_S)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_S");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_S");
    check_field_offset(lv, v3, 6, "Us_BFu17ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_S, Us_BFu17ll_S)
//============================================================================


struct  Us_BFu17ll_Uc  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned char v3;
};
//SIG(1 Us_BFu17ll_Uc) C1{ Fs FL:17 Fc}



static void Test_Us_BFu17ll_Uc()
{
  {
    init_simple_test("Us_BFu17ll_Uc");
    static STRUCT_IF_C Us_BFu17ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_Uc)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_Uc");
    check_field_offset(lv, v3, 5, "Us_BFu17ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_Uc, Us_BFu17ll_Uc)
//============================================================================


struct  Us_BFu17ll_Ui  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned int v3;
};
//SIG(1 Us_BFu17ll_Ui) C1{ Fs FL:17 Fi}



static void Test_Us_BFu17ll_Ui()
{
  {
    init_simple_test("Us_BFu17ll_Ui");
    static STRUCT_IF_C Us_BFu17ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu17ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_Ui)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_Ui");
    check_field_offset(lv, v3, 8, "Us_BFu17ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_Ui, Us_BFu17ll_Ui)
//============================================================================


struct  Us_BFu17ll_Ul  {
  unsigned short v1;
  __tsu64 v2:17;
  __tsu64 v3;
};
//SIG(1 Us_BFu17ll_Ul) C1{ Fs FL:17 FL}



static void Test_Us_BFu17ll_Ul()
{
  {
    init_simple_test("Us_BFu17ll_Ul");
    static STRUCT_IF_C Us_BFu17ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Us_BFu17ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_Ul)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_Ul");
    check_field_offset(lv, v3, 8, "Us_BFu17ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_Ul, Us_BFu17ll_Ul)
//============================================================================


struct  Us_BFu17ll_Us  {
  unsigned short v1;
  __tsu64 v2:17;
  unsigned short v3;
};
//SIG(1 Us_BFu17ll_Us) C1{ Fs FL:17 Fs}



static void Test_Us_BFu17ll_Us()
{
  {
    init_simple_test("Us_BFu17ll_Us");
    static STRUCT_IF_C Us_BFu17ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu17ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_Us)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_Us");
    check_field_offset(lv, v3, 6, "Us_BFu17ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_Us, Us_BFu17ll_Us)
//============================================================================


struct  Us_BFu17ll_Vp  {
  unsigned short v1;
  __tsu64 v2:17;
  void *v3;
};
//SIG(1 Us_BFu17ll_Vp) C1{ Fs FL:17 Fp}



static void Test_Us_BFu17ll_Vp()
{
  {
    init_simple_test("Us_BFu17ll_Vp");
    static STRUCT_IF_C Us_BFu17ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu17ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu17ll_Vp)");
    check_field_offset(lv, v1, 0, "Us_BFu17ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 17, 1, "Us_BFu17ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 17, hide_ull(1LL<<16), "Us_BFu17ll_Vp");
    check_field_offset(lv, v3, 8, "Us_BFu17ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu17ll_Vp, Us_BFu17ll_Vp)
//============================================================================


struct  Us_BFu1c  {
  unsigned short v1;
  unsigned char v2:1;
};
//SIG(1 Us_BFu1c) C1{ Fs Fc:1}



static void Test_Us_BFu1c()
{
  {
    init_simple_test("Us_BFu1c");
    static STRUCT_IF_C Us_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c, Us_BFu1c)
//============================================================================


struct  Us_BFu1c_BFu15i  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned int v3:15;
};
//SIG(1 Us_BFu1c_BFu15i) C1{ Fs Fc:1 Fi:15}



static void Test_Us_BFu1c_BFu15i()
{
  {
    init_simple_test("Us_BFu1c_BFu15i");
    static STRUCT_IF_C Us_BFu1c_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1c_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1c_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Us_BFu1c_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Us_BFu1c_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu15i, Us_BFu1c_BFu15i)
//============================================================================


struct  Us_BFu1c_BFu15ll  {
  unsigned short v1;
  unsigned char v2:1;
  __tsu64 v3:15;
};
//SIG(1 Us_BFu1c_BFu15ll) C1{ Fs Fc:1 FL:15}



static void Test_Us_BFu1c_BFu15ll()
{
  {
    init_simple_test("Us_BFu1c_BFu15ll");
    static STRUCT_IF_C Us_BFu1c_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1c_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1c_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Us_BFu1c_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Us_BFu1c_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu15ll, Us_BFu1c_BFu15ll)
//============================================================================


struct  Us_BFu1c_BFu15s  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned short v3:15;
};
//SIG(1 Us_BFu1c_BFu15s) C1{ Fs Fc:1 Fs:15}



static void Test_Us_BFu1c_BFu15s()
{
  {
    init_simple_test("Us_BFu1c_BFu15s");
    static STRUCT_IF_C Us_BFu1c_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1c_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1c_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Us_BFu1c_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Us_BFu1c_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu15s, Us_BFu1c_BFu15s)
//============================================================================


struct  Us_BFu1c_BFu16i  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned int v3:16;
};
//SIG(1 Us_BFu1c_BFu16i) C1{ Fs Fc:1 Fi:16}



static void Test_Us_BFu1c_BFu16i()
{
  {
    init_simple_test("Us_BFu1c_BFu16i");
    static STRUCT_IF_C Us_BFu1c_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1c_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1c_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu1c_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu1c_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu16i, Us_BFu1c_BFu16i)
//============================================================================


struct  Us_BFu1c_BFu16ll  {
  unsigned short v1;
  unsigned char v2:1;
  __tsu64 v3:16;
};
//SIG(1 Us_BFu1c_BFu16ll) C1{ Fs Fc:1 FL:16}



static void Test_Us_BFu1c_BFu16ll()
{
  {
    init_simple_test("Us_BFu1c_BFu16ll");
    static STRUCT_IF_C Us_BFu1c_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1c_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1c_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "Us_BFu1c_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "Us_BFu1c_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu16ll, Us_BFu1c_BFu16ll)
//============================================================================


struct  Us_BFu1c_BFu16s  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned short v3:16;
};
//SIG(1 Us_BFu1c_BFu16s) C1{ Fs Fc:1 Fs:16}



static void Test_Us_BFu1c_BFu16s()
{
  {
    init_simple_test("Us_BFu1c_BFu16s");
    static STRUCT_IF_C Us_BFu1c_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu1c_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1c_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu1c_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu1c_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu16s, Us_BFu1c_BFu16s)
//============================================================================


struct  Us_BFu1c_BFu17i  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned int v3:17;
};
//SIG(1 Us_BFu1c_BFu17i) C1{ Fs Fc:1 Fi:17}



static void Test_Us_BFu1c_BFu17i()
{
  {
    init_simple_test("Us_BFu1c_BFu17i");
    static STRUCT_IF_C Us_BFu1c_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1c_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1c_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Us_BFu1c_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu1c_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu17i, Us_BFu1c_BFu17i)
//============================================================================


struct  Us_BFu1c_BFu17ll  {
  unsigned short v1;
  unsigned char v2:1;
  __tsu64 v3:17;
};
//SIG(1 Us_BFu1c_BFu17ll) C1{ Fs Fc:1 FL:17}



static void Test_Us_BFu1c_BFu17ll()
{
  {
    init_simple_test("Us_BFu1c_BFu17ll");
    static STRUCT_IF_C Us_BFu1c_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1c_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1c_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "Us_BFu1c_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "Us_BFu1c_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu17ll, Us_BFu1c_BFu17ll)
//============================================================================


struct  Us_BFu1c_BFu1c  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned char v3:1;
};
//SIG(1 Us_BFu1c_BFu1c) C1{ Fs Fc:1 Fc:1}



static void Test_Us_BFu1c_BFu1c()
{
  {
    init_simple_test("Us_BFu1c_BFu1c");
    static STRUCT_IF_C Us_BFu1c_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1c_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1c_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Us_BFu1c_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu1c, Us_BFu1c_BFu1c)
//============================================================================


struct  Us_BFu1c_BFu1i  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned int v3:1;
};
//SIG(1 Us_BFu1c_BFu1i) C1{ Fs Fc:1 Fi:1}



static void Test_Us_BFu1c_BFu1i()
{
  {
    init_simple_test("Us_BFu1c_BFu1i");
    static STRUCT_IF_C Us_BFu1c_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1c_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1c_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Us_BFu1c_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu1i, Us_BFu1c_BFu1i)
//============================================================================


struct  Us_BFu1c_BFu1ll  {
  unsigned short v1;
  unsigned char v2:1;
  __tsu64 v3:1;
};
//SIG(1 Us_BFu1c_BFu1ll) C1{ Fs Fc:1 FL:1}



static void Test_Us_BFu1c_BFu1ll()
{
  {
    init_simple_test("Us_BFu1c_BFu1ll");
    static STRUCT_IF_C Us_BFu1c_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1c_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1c_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Us_BFu1c_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu1ll, Us_BFu1c_BFu1ll)
//============================================================================


struct  Us_BFu1c_BFu1s  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned short v3:1;
};
//SIG(1 Us_BFu1c_BFu1s) C1{ Fs Fc:1 Fs:1}



static void Test_Us_BFu1c_BFu1s()
{
  {
    init_simple_test("Us_BFu1c_BFu1s");
    static STRUCT_IF_C Us_BFu1c_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1c_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1c_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Us_BFu1c_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu1s, Us_BFu1c_BFu1s)
//============================================================================


struct  Us_BFu1c_BFu31i  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned int v3:31;
};
//SIG(1 Us_BFu1c_BFu31i) C1{ Fs Fc:1 Fi:31}



static void Test_Us_BFu1c_BFu31i()
{
  {
    init_simple_test("Us_BFu1c_BFu31i");
    static STRUCT_IF_C Us_BFu1c_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1c_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1c_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Us_BFu1c_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu1c_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu31i, Us_BFu1c_BFu31i)
//============================================================================


struct  Us_BFu1c_BFu31ll  {
  unsigned short v1;
  unsigned char v2:1;
  __tsu64 v3:31;
};
//SIG(1 Us_BFu1c_BFu31ll) C1{ Fs Fc:1 FL:31}



static void Test_Us_BFu1c_BFu31ll()
{
  {
    init_simple_test("Us_BFu1c_BFu31ll");
    static STRUCT_IF_C Us_BFu1c_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1c_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1c_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "Us_BFu1c_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "Us_BFu1c_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu31ll, Us_BFu1c_BFu31ll)
//============================================================================


struct  Us_BFu1c_BFu32i  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned int v3:32;
};
//SIG(1 Us_BFu1c_BFu32i) C1{ Fs Fc:1 Fi:32}



static void Test_Us_BFu1c_BFu32i()
{
  {
    init_simple_test("Us_BFu1c_BFu32i");
    static STRUCT_IF_C Us_BFu1c_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1c_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1c_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Us_BFu1c_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu1c_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu32i, Us_BFu1c_BFu32i)
//============================================================================


struct  Us_BFu1c_BFu32ll  {
  unsigned short v1;
  unsigned char v2:1;
  __tsu64 v3:32;
};
//SIG(1 Us_BFu1c_BFu32ll) C1{ Fs Fc:1 FL:32}



static void Test_Us_BFu1c_BFu32ll()
{
  {
    init_simple_test("Us_BFu1c_BFu32ll");
    static STRUCT_IF_C Us_BFu1c_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1c_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1c_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "Us_BFu1c_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "Us_BFu1c_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu32ll, Us_BFu1c_BFu32ll)
//============================================================================


struct  Us_BFu1c_BFu33  {
  unsigned short v1;
  unsigned char v2:1;
  __tsu64 v3:33;
};
//SIG(1 Us_BFu1c_BFu33) C1{ Fs Fc:1 FL:33}



static void Test_Us_BFu1c_BFu33()
{
  {
    init_simple_test("Us_BFu1c_BFu33");
    static STRUCT_IF_C Us_BFu1c_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1c_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1c_BFu33)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "Us_BFu1c_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "Us_BFu1c_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu33, Us_BFu1c_BFu33)
//============================================================================


struct  Us_BFu1c_BFu7c  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned char v3:7;
};
//SIG(1 Us_BFu1c_BFu7c) C1{ Fs Fc:1 Fc:7}



static void Test_Us_BFu1c_BFu7c()
{
  {
    init_simple_test("Us_BFu1c_BFu7c");
    static STRUCT_IF_C Us_BFu1c_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1c_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1c_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Us_BFu1c_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Us_BFu1c_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu7c, Us_BFu1c_BFu7c)
//============================================================================


struct  Us_BFu1c_BFu7i  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned int v3:7;
};
//SIG(1 Us_BFu1c_BFu7i) C1{ Fs Fc:1 Fi:7}



static void Test_Us_BFu1c_BFu7i()
{
  {
    init_simple_test("Us_BFu1c_BFu7i");
    static STRUCT_IF_C Us_BFu1c_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1c_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1c_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Us_BFu1c_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Us_BFu1c_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu7i, Us_BFu1c_BFu7i)
//============================================================================


struct  Us_BFu1c_BFu7ll  {
  unsigned short v1;
  unsigned char v2:1;
  __tsu64 v3:7;
};
//SIG(1 Us_BFu1c_BFu7ll) C1{ Fs Fc:1 FL:7}



static void Test_Us_BFu1c_BFu7ll()
{
  {
    init_simple_test("Us_BFu1c_BFu7ll");
    static STRUCT_IF_C Us_BFu1c_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1c_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1c_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Us_BFu1c_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Us_BFu1c_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu7ll, Us_BFu1c_BFu7ll)
//============================================================================


struct  Us_BFu1c_BFu7s  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned short v3:7;
};
//SIG(1 Us_BFu1c_BFu7s) C1{ Fs Fc:1 Fs:7}



static void Test_Us_BFu1c_BFu7s()
{
  {
    init_simple_test("Us_BFu1c_BFu7s");
    static STRUCT_IF_C Us_BFu1c_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1c_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1c_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Us_BFu1c_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Us_BFu1c_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu7s, Us_BFu1c_BFu7s)
//============================================================================


struct  Us_BFu1c_BFu8c  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned char v3:8;
};
//SIG(1 Us_BFu1c_BFu8c) C1{ Fs Fc:1 Fc:8}



static void Test_Us_BFu1c_BFu8c()
{
  {
    init_simple_test("Us_BFu1c_BFu8c");
    static STRUCT_IF_C Us_BFu1c_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1c_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1c_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Us_BFu1c_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Us_BFu1c_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu8c, Us_BFu1c_BFu8c)
//============================================================================


struct  Us_BFu1c_BFu8i  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned int v3:8;
};
//SIG(1 Us_BFu1c_BFu8i) C1{ Fs Fc:1 Fi:8}



static void Test_Us_BFu1c_BFu8i()
{
  {
    init_simple_test("Us_BFu1c_BFu8i");
    static STRUCT_IF_C Us_BFu1c_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1c_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1c_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Us_BFu1c_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Us_BFu1c_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu8i, Us_BFu1c_BFu8i)
//============================================================================


struct  Us_BFu1c_BFu8ll  {
  unsigned short v1;
  unsigned char v2:1;
  __tsu64 v3:8;
};
//SIG(1 Us_BFu1c_BFu8ll) C1{ Fs Fc:1 FL:8}



static void Test_Us_BFu1c_BFu8ll()
{
  {
    init_simple_test("Us_BFu1c_BFu8ll");
    static STRUCT_IF_C Us_BFu1c_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1c_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1c_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Us_BFu1c_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Us_BFu1c_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu8ll, Us_BFu1c_BFu8ll)
//============================================================================


struct  Us_BFu1c_BFu8s  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned short v3:8;
};
//SIG(1 Us_BFu1c_BFu8s) C1{ Fs Fc:1 Fs:8}



static void Test_Us_BFu1c_BFu8s()
{
  {
    init_simple_test("Us_BFu1c_BFu8s");
    static STRUCT_IF_C Us_BFu1c_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1c_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1c_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Us_BFu1c_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Us_BFu1c_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu8s, Us_BFu1c_BFu8s)
//============================================================================


struct  Us_BFu1c_BFu9i  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned int v3:9;
};
//SIG(1 Us_BFu1c_BFu9i) C1{ Fs Fc:1 Fi:9}



static void Test_Us_BFu1c_BFu9i()
{
  {
    init_simple_test("Us_BFu1c_BFu9i");
    static STRUCT_IF_C Us_BFu1c_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1c_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1c_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Us_BFu1c_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Us_BFu1c_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu9i, Us_BFu1c_BFu9i)
//============================================================================


struct  Us_BFu1c_BFu9ll  {
  unsigned short v1;
  unsigned char v2:1;
  __tsu64 v3:9;
};
//SIG(1 Us_BFu1c_BFu9ll) C1{ Fs Fc:1 FL:9}



static void Test_Us_BFu1c_BFu9ll()
{
  {
    init_simple_test("Us_BFu1c_BFu9ll");
    static STRUCT_IF_C Us_BFu1c_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1c_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1c_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Us_BFu1c_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Us_BFu1c_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu9ll, Us_BFu1c_BFu9ll)
//============================================================================


struct  Us_BFu1c_BFu9s  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned short v3:9;
};
//SIG(1 Us_BFu1c_BFu9s) C1{ Fs Fc:1 Fs:9}



static void Test_Us_BFu1c_BFu9s()
{
  {
    init_simple_test("Us_BFu1c_BFu9s");
    static STRUCT_IF_C Us_BFu1c_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1c_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1c_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Us_BFu1c_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Us_BFu1c_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_BFu9s, Us_BFu1c_BFu9s)
//============================================================================


struct  Us_BFu1c_C  {
  unsigned short v1;
  unsigned char v2:1;
  char v3;
};
//SIG(1 Us_BFu1c_C) C1{ Fs Fc:1 Fc}



static void Test_Us_BFu1c_C()
{
  {
    init_simple_test("Us_BFu1c_C");
    static STRUCT_IF_C Us_BFu1c_C lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1c_C)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1c_C)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_C");
    check_field_offset(lv, v3, 3, "Us_BFu1c_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_C, Us_BFu1c_C)
//============================================================================


struct  Us_BFu1c_D  {
  unsigned short v1;
  unsigned char v2:1;
  double v3;
};
//SIG(1 Us_BFu1c_D) C1{ Fs Fc:1 FL}



static void Test_Us_BFu1c_D()
{
  {
    init_simple_test("Us_BFu1c_D");
    static STRUCT_IF_C Us_BFu1c_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu1c_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1c_D)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1c_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_D, Us_BFu1c_D)
//============================================================================


struct  Us_BFu1c_F  {
  unsigned short v1;
  unsigned char v2:1;
  float v3;
};
//SIG(1 Us_BFu1c_F) C1{ Fs Fc:1 Fi}



static void Test_Us_BFu1c_F()
{
  {
    init_simple_test("Us_BFu1c_F");
    static STRUCT_IF_C Us_BFu1c_F lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1c_F)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1c_F)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_F");
    check_field_offset(lv, v3, 4, "Us_BFu1c_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_F, Us_BFu1c_F)
//============================================================================


struct  Us_BFu1c_I  {
  unsigned short v1;
  unsigned char v2:1;
  int v3;
};
//SIG(1 Us_BFu1c_I) C1{ Fs Fc:1 Fi}



static void Test_Us_BFu1c_I()
{
  {
    init_simple_test("Us_BFu1c_I");
    static STRUCT_IF_C Us_BFu1c_I lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1c_I)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1c_I)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_I");
    check_field_offset(lv, v3, 4, "Us_BFu1c_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_I, Us_BFu1c_I)
//============================================================================


struct  Us_BFu1c_Ip  {
  unsigned short v1;
  unsigned char v2:1;
  int *v3;
};
//SIG(1 Us_BFu1c_Ip) C1{ Fs Fc:1 Fp}



static void Test_Us_BFu1c_Ip()
{
  {
    init_simple_test("Us_BFu1c_Ip");
    static STRUCT_IF_C Us_BFu1c_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu1c_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1c_Ip)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1c_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_Ip, Us_BFu1c_Ip)
//============================================================================


struct  Us_BFu1c_L  {
  unsigned short v1;
  unsigned char v2:1;
  __tsi64 v3;
};
//SIG(1 Us_BFu1c_L) C1{ Fs Fc:1 FL}



static void Test_Us_BFu1c_L()
{
  {
    init_simple_test("Us_BFu1c_L");
    static STRUCT_IF_C Us_BFu1c_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu1c_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1c_L)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1c_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_L, Us_BFu1c_L)
//============================================================================


struct  Us_BFu1c_S  {
  unsigned short v1;
  unsigned char v2:1;
  short v3;
};
//SIG(1 Us_BFu1c_S) C1{ Fs Fc:1 Fs}



static void Test_Us_BFu1c_S()
{
  {
    init_simple_test("Us_BFu1c_S");
    static STRUCT_IF_C Us_BFu1c_S lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu1c_S)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1c_S)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_S");
    check_field_offset(lv, v3, 4, "Us_BFu1c_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_S, Us_BFu1c_S)
//============================================================================


struct  Us_BFu1c_Uc  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned char v3;
};
//SIG(1 Us_BFu1c_Uc) C1{ Fs Fc:1 Fc}



static void Test_Us_BFu1c_Uc()
{
  {
    init_simple_test("Us_BFu1c_Uc");
    static STRUCT_IF_C Us_BFu1c_Uc lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1c_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1c_Uc)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_Uc");
    check_field_offset(lv, v3, 3, "Us_BFu1c_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_Uc, Us_BFu1c_Uc)
//============================================================================


struct  Us_BFu1c_Ui  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned int v3;
};
//SIG(1 Us_BFu1c_Ui) C1{ Fs Fc:1 Fi}



static void Test_Us_BFu1c_Ui()
{
  {
    init_simple_test("Us_BFu1c_Ui");
    static STRUCT_IF_C Us_BFu1c_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1c_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1c_Ui)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_Ui");
    check_field_offset(lv, v3, 4, "Us_BFu1c_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_Ui, Us_BFu1c_Ui)
//============================================================================


struct  Us_BFu1c_Ul  {
  unsigned short v1;
  unsigned char v2:1;
  __tsu64 v3;
};
//SIG(1 Us_BFu1c_Ul) C1{ Fs Fc:1 FL}



static void Test_Us_BFu1c_Ul()
{
  {
    init_simple_test("Us_BFu1c_Ul");
    static STRUCT_IF_C Us_BFu1c_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu1c_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1c_Ul)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1c_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_Ul, Us_BFu1c_Ul)
//============================================================================


struct  Us_BFu1c_Us  {
  unsigned short v1;
  unsigned char v2:1;
  unsigned short v3;
};
//SIG(1 Us_BFu1c_Us) C1{ Fs Fc:1 Fs}



static void Test_Us_BFu1c_Us()
{
  {
    init_simple_test("Us_BFu1c_Us");
    static STRUCT_IF_C Us_BFu1c_Us lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu1c_Us)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1c_Us)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_Us");
    check_field_offset(lv, v3, 4, "Us_BFu1c_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_Us, Us_BFu1c_Us)
//============================================================================


struct  Us_BFu1c_Vp  {
  unsigned short v1;
  unsigned char v2:1;
  void *v3;
};
//SIG(1 Us_BFu1c_Vp) C1{ Fs Fc:1 Fp}



static void Test_Us_BFu1c_Vp()
{
  {
    init_simple_test("Us_BFu1c_Vp");
    static STRUCT_IF_C Us_BFu1c_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu1c_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1c_Vp)");
    check_field_offset(lv, v1, 0, "Us_BFu1c_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1c_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1c_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1c_Vp, Us_BFu1c_Vp)
//============================================================================


struct  Us_BFu1i  {
  unsigned short v1;
  unsigned int v2:1;
};
//SIG(1 Us_BFu1i) C1{ Fs Fi:1}



static void Test_Us_BFu1i()
{
  {
    init_simple_test("Us_BFu1i");
    static STRUCT_IF_C Us_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i, Us_BFu1i)
//============================================================================


struct  Us_BFu1i_BFu15i  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned int v3:15;
};
//SIG(1 Us_BFu1i_BFu15i) C1{ Fs Fi:1 Fi:15}



static void Test_Us_BFu1i_BFu15i()
{
  {
    init_simple_test("Us_BFu1i_BFu15i");
    static STRUCT_IF_C Us_BFu1i_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Us_BFu1i_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Us_BFu1i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu15i, Us_BFu1i_BFu15i)
//============================================================================


struct  Us_BFu1i_BFu15ll  {
  unsigned short v1;
  unsigned int v2:1;
  __tsu64 v3:15;
};
//SIG(1 Us_BFu1i_BFu15ll) C1{ Fs Fi:1 FL:15}



static void Test_Us_BFu1i_BFu15ll()
{
  {
    init_simple_test("Us_BFu1i_BFu15ll");
    static STRUCT_IF_C Us_BFu1i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Us_BFu1i_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Us_BFu1i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu15ll, Us_BFu1i_BFu15ll)
//============================================================================


struct  Us_BFu1i_BFu15s  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned short v3:15;
};
//SIG(1 Us_BFu1i_BFu15s) C1{ Fs Fi:1 Fs:15}



static void Test_Us_BFu1i_BFu15s()
{
  {
    init_simple_test("Us_BFu1i_BFu15s");
    static STRUCT_IF_C Us_BFu1i_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Us_BFu1i_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Us_BFu1i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu15s, Us_BFu1i_BFu15s)
//============================================================================


struct  Us_BFu1i_BFu16i  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned int v3:16;
};
//SIG(1 Us_BFu1i_BFu16i) C1{ Fs Fi:1 Fi:16}



static void Test_Us_BFu1i_BFu16i()
{
  {
    init_simple_test("Us_BFu1i_BFu16i");
    static STRUCT_IF_C Us_BFu1i_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu1i_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu1i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu16i, Us_BFu1i_BFu16i)
//============================================================================


struct  Us_BFu1i_BFu16ll  {
  unsigned short v1;
  unsigned int v2:1;
  __tsu64 v3:16;
};
//SIG(1 Us_BFu1i_BFu16ll) C1{ Fs Fi:1 FL:16}



static void Test_Us_BFu1i_BFu16ll()
{
  {
    init_simple_test("Us_BFu1i_BFu16ll");
    static STRUCT_IF_C Us_BFu1i_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "Us_BFu1i_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "Us_BFu1i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu16ll, Us_BFu1i_BFu16ll)
//============================================================================


struct  Us_BFu1i_BFu16s  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned short v3:16;
};
//SIG(1 Us_BFu1i_BFu16s) C1{ Fs Fi:1 Fs:16}



static void Test_Us_BFu1i_BFu16s()
{
  {
    init_simple_test("Us_BFu1i_BFu16s");
    static STRUCT_IF_C Us_BFu1i_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu1i_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu1i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu16s, Us_BFu1i_BFu16s)
//============================================================================


struct  Us_BFu1i_BFu17i  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned int v3:17;
};
//SIG(1 Us_BFu1i_BFu17i) C1{ Fs Fi:1 Fi:17}



static void Test_Us_BFu1i_BFu17i()
{
  {
    init_simple_test("Us_BFu1i_BFu17i");
    static STRUCT_IF_C Us_BFu1i_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Us_BFu1i_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu1i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu17i, Us_BFu1i_BFu17i)
//============================================================================


struct  Us_BFu1i_BFu17ll  {
  unsigned short v1;
  unsigned int v2:1;
  __tsu64 v3:17;
};
//SIG(1 Us_BFu1i_BFu17ll) C1{ Fs Fi:1 FL:17}



static void Test_Us_BFu1i_BFu17ll()
{
  {
    init_simple_test("Us_BFu1i_BFu17ll");
    static STRUCT_IF_C Us_BFu1i_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "Us_BFu1i_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "Us_BFu1i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu17ll, Us_BFu1i_BFu17ll)
//============================================================================


struct  Us_BFu1i_BFu1c  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned char v3:1;
};
//SIG(1 Us_BFu1i_BFu1c) C1{ Fs Fi:1 Fc:1}



static void Test_Us_BFu1i_BFu1c()
{
  {
    init_simple_test("Us_BFu1i_BFu1c");
    static STRUCT_IF_C Us_BFu1i_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Us_BFu1i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu1c, Us_BFu1i_BFu1c)
//============================================================================


struct  Us_BFu1i_BFu1i  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned int v3:1;
};
//SIG(1 Us_BFu1i_BFu1i) C1{ Fs Fi:1 Fi:1}



static void Test_Us_BFu1i_BFu1i()
{
  {
    init_simple_test("Us_BFu1i_BFu1i");
    static STRUCT_IF_C Us_BFu1i_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Us_BFu1i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu1i, Us_BFu1i_BFu1i)
//============================================================================


struct  Us_BFu1i_BFu1ll  {
  unsigned short v1;
  unsigned int v2:1;
  __tsu64 v3:1;
};
//SIG(1 Us_BFu1i_BFu1ll) C1{ Fs Fi:1 FL:1}



static void Test_Us_BFu1i_BFu1ll()
{
  {
    init_simple_test("Us_BFu1i_BFu1ll");
    static STRUCT_IF_C Us_BFu1i_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Us_BFu1i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu1ll, Us_BFu1i_BFu1ll)
//============================================================================


struct  Us_BFu1i_BFu1s  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned short v3:1;
};
//SIG(1 Us_BFu1i_BFu1s) C1{ Fs Fi:1 Fs:1}



static void Test_Us_BFu1i_BFu1s()
{
  {
    init_simple_test("Us_BFu1i_BFu1s");
    static STRUCT_IF_C Us_BFu1i_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Us_BFu1i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu1s, Us_BFu1i_BFu1s)
//============================================================================


struct  Us_BFu1i_BFu31i  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned int v3:31;
};
//SIG(1 Us_BFu1i_BFu31i) C1{ Fs Fi:1 Fi:31}



static void Test_Us_BFu1i_BFu31i()
{
  {
    init_simple_test("Us_BFu1i_BFu31i");
    static STRUCT_IF_C Us_BFu1i_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Us_BFu1i_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu1i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu31i, Us_BFu1i_BFu31i)
//============================================================================


struct  Us_BFu1i_BFu31ll  {
  unsigned short v1;
  unsigned int v2:1;
  __tsu64 v3:31;
};
//SIG(1 Us_BFu1i_BFu31ll) C1{ Fs Fi:1 FL:31}



static void Test_Us_BFu1i_BFu31ll()
{
  {
    init_simple_test("Us_BFu1i_BFu31ll");
    static STRUCT_IF_C Us_BFu1i_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "Us_BFu1i_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "Us_BFu1i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu31ll, Us_BFu1i_BFu31ll)
//============================================================================


struct  Us_BFu1i_BFu32i  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned int v3:32;
};
//SIG(1 Us_BFu1i_BFu32i) C1{ Fs Fi:1 Fi:32}



static void Test_Us_BFu1i_BFu32i()
{
  {
    init_simple_test("Us_BFu1i_BFu32i");
    static STRUCT_IF_C Us_BFu1i_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Us_BFu1i_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu1i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu32i, Us_BFu1i_BFu32i)
//============================================================================


struct  Us_BFu1i_BFu32ll  {
  unsigned short v1;
  unsigned int v2:1;
  __tsu64 v3:32;
};
//SIG(1 Us_BFu1i_BFu32ll) C1{ Fs Fi:1 FL:32}



static void Test_Us_BFu1i_BFu32ll()
{
  {
    init_simple_test("Us_BFu1i_BFu32ll");
    static STRUCT_IF_C Us_BFu1i_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "Us_BFu1i_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "Us_BFu1i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu32ll, Us_BFu1i_BFu32ll)
//============================================================================


struct  Us_BFu1i_BFu33  {
  unsigned short v1;
  unsigned int v2:1;
  __tsu64 v3:33;
};
//SIG(1 Us_BFu1i_BFu33) C1{ Fs Fi:1 FL:33}



static void Test_Us_BFu1i_BFu33()
{
  {
    init_simple_test("Us_BFu1i_BFu33");
    static STRUCT_IF_C Us_BFu1i_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1i_BFu33)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "Us_BFu1i_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "Us_BFu1i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu33, Us_BFu1i_BFu33)
//============================================================================


struct  Us_BFu1i_BFu7c  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned char v3:7;
};
//SIG(1 Us_BFu1i_BFu7c) C1{ Fs Fi:1 Fc:7}



static void Test_Us_BFu1i_BFu7c()
{
  {
    init_simple_test("Us_BFu1i_BFu7c");
    static STRUCT_IF_C Us_BFu1i_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Us_BFu1i_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Us_BFu1i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu7c, Us_BFu1i_BFu7c)
//============================================================================


struct  Us_BFu1i_BFu7i  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned int v3:7;
};
//SIG(1 Us_BFu1i_BFu7i) C1{ Fs Fi:1 Fi:7}



static void Test_Us_BFu1i_BFu7i()
{
  {
    init_simple_test("Us_BFu1i_BFu7i");
    static STRUCT_IF_C Us_BFu1i_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Us_BFu1i_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Us_BFu1i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu7i, Us_BFu1i_BFu7i)
//============================================================================


struct  Us_BFu1i_BFu7ll  {
  unsigned short v1;
  unsigned int v2:1;
  __tsu64 v3:7;
};
//SIG(1 Us_BFu1i_BFu7ll) C1{ Fs Fi:1 FL:7}



static void Test_Us_BFu1i_BFu7ll()
{
  {
    init_simple_test("Us_BFu1i_BFu7ll");
    static STRUCT_IF_C Us_BFu1i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Us_BFu1i_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Us_BFu1i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu7ll, Us_BFu1i_BFu7ll)
//============================================================================


struct  Us_BFu1i_BFu7s  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned short v3:7;
};
//SIG(1 Us_BFu1i_BFu7s) C1{ Fs Fi:1 Fs:7}



static void Test_Us_BFu1i_BFu7s()
{
  {
    init_simple_test("Us_BFu1i_BFu7s");
    static STRUCT_IF_C Us_BFu1i_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Us_BFu1i_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Us_BFu1i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu7s, Us_BFu1i_BFu7s)
//============================================================================


struct  Us_BFu1i_BFu8c  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned char v3:8;
};
//SIG(1 Us_BFu1i_BFu8c) C1{ Fs Fi:1 Fc:8}



static void Test_Us_BFu1i_BFu8c()
{
  {
    init_simple_test("Us_BFu1i_BFu8c");
    static STRUCT_IF_C Us_BFu1i_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Us_BFu1i_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Us_BFu1i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu8c, Us_BFu1i_BFu8c)
//============================================================================


struct  Us_BFu1i_BFu8i  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned int v3:8;
};
//SIG(1 Us_BFu1i_BFu8i) C1{ Fs Fi:1 Fi:8}



static void Test_Us_BFu1i_BFu8i()
{
  {
    init_simple_test("Us_BFu1i_BFu8i");
    static STRUCT_IF_C Us_BFu1i_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Us_BFu1i_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Us_BFu1i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu8i, Us_BFu1i_BFu8i)
//============================================================================


struct  Us_BFu1i_BFu8ll  {
  unsigned short v1;
  unsigned int v2:1;
  __tsu64 v3:8;
};
//SIG(1 Us_BFu1i_BFu8ll) C1{ Fs Fi:1 FL:8}



static void Test_Us_BFu1i_BFu8ll()
{
  {
    init_simple_test("Us_BFu1i_BFu8ll");
    static STRUCT_IF_C Us_BFu1i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Us_BFu1i_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Us_BFu1i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu8ll, Us_BFu1i_BFu8ll)
//============================================================================


struct  Us_BFu1i_BFu8s  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned short v3:8;
};
//SIG(1 Us_BFu1i_BFu8s) C1{ Fs Fi:1 Fs:8}



static void Test_Us_BFu1i_BFu8s()
{
  {
    init_simple_test("Us_BFu1i_BFu8s");
    static STRUCT_IF_C Us_BFu1i_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Us_BFu1i_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Us_BFu1i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu8s, Us_BFu1i_BFu8s)
//============================================================================


struct  Us_BFu1i_BFu9i  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned int v3:9;
};
//SIG(1 Us_BFu1i_BFu9i) C1{ Fs Fi:1 Fi:9}



static void Test_Us_BFu1i_BFu9i()
{
  {
    init_simple_test("Us_BFu1i_BFu9i");
    static STRUCT_IF_C Us_BFu1i_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Us_BFu1i_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Us_BFu1i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu9i, Us_BFu1i_BFu9i)
//============================================================================


struct  Us_BFu1i_BFu9ll  {
  unsigned short v1;
  unsigned int v2:1;
  __tsu64 v3:9;
};
//SIG(1 Us_BFu1i_BFu9ll) C1{ Fs Fi:1 FL:9}



static void Test_Us_BFu1i_BFu9ll()
{
  {
    init_simple_test("Us_BFu1i_BFu9ll");
    static STRUCT_IF_C Us_BFu1i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Us_BFu1i_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Us_BFu1i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu9ll, Us_BFu1i_BFu9ll)
//============================================================================


struct  Us_BFu1i_BFu9s  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned short v3:9;
};
//SIG(1 Us_BFu1i_BFu9s) C1{ Fs Fi:1 Fs:9}



static void Test_Us_BFu1i_BFu9s()
{
  {
    init_simple_test("Us_BFu1i_BFu9s");
    static STRUCT_IF_C Us_BFu1i_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Us_BFu1i_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Us_BFu1i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_BFu9s, Us_BFu1i_BFu9s)
//============================================================================


struct  Us_BFu1i_C  {
  unsigned short v1;
  unsigned int v2:1;
  char v3;
};
//SIG(1 Us_BFu1i_C) C1{ Fs Fi:1 Fc}



static void Test_Us_BFu1i_C()
{
  {
    init_simple_test("Us_BFu1i_C");
    static STRUCT_IF_C Us_BFu1i_C lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_C)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_C");
    check_field_offset(lv, v3, 3, "Us_BFu1i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_C, Us_BFu1i_C)
//============================================================================


struct  Us_BFu1i_D  {
  unsigned short v1;
  unsigned int v2:1;
  double v3;
};
//SIG(1 Us_BFu1i_D) C1{ Fs Fi:1 FL}



static void Test_Us_BFu1i_D()
{
  {
    init_simple_test("Us_BFu1i_D");
    static STRUCT_IF_C Us_BFu1i_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu1i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1i_D)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_D, Us_BFu1i_D)
//============================================================================


struct  Us_BFu1i_F  {
  unsigned short v1;
  unsigned int v2:1;
  float v3;
};
//SIG(1 Us_BFu1i_F) C1{ Fs Fi:1 Fi}



static void Test_Us_BFu1i_F()
{
  {
    init_simple_test("Us_BFu1i_F");
    static STRUCT_IF_C Us_BFu1i_F lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_F)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_F");
    check_field_offset(lv, v3, 4, "Us_BFu1i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_F, Us_BFu1i_F)
//============================================================================


struct  Us_BFu1i_I  {
  unsigned short v1;
  unsigned int v2:1;
  int v3;
};
//SIG(1 Us_BFu1i_I) C1{ Fs Fi:1 Fi}



static void Test_Us_BFu1i_I()
{
  {
    init_simple_test("Us_BFu1i_I");
    static STRUCT_IF_C Us_BFu1i_I lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_I)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_I");
    check_field_offset(lv, v3, 4, "Us_BFu1i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_I, Us_BFu1i_I)
//============================================================================


struct  Us_BFu1i_Ip  {
  unsigned short v1;
  unsigned int v2:1;
  int *v3;
};
//SIG(1 Us_BFu1i_Ip) C1{ Fs Fi:1 Fp}



static void Test_Us_BFu1i_Ip()
{
  {
    init_simple_test("Us_BFu1i_Ip");
    static STRUCT_IF_C Us_BFu1i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu1i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1i_Ip)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_Ip, Us_BFu1i_Ip)
//============================================================================


struct  Us_BFu1i_L  {
  unsigned short v1;
  unsigned int v2:1;
  __tsi64 v3;
};
//SIG(1 Us_BFu1i_L) C1{ Fs Fi:1 FL}



static void Test_Us_BFu1i_L()
{
  {
    init_simple_test("Us_BFu1i_L");
    static STRUCT_IF_C Us_BFu1i_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu1i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1i_L)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_L, Us_BFu1i_L)
//============================================================================


struct  Us_BFu1i_S  {
  unsigned short v1;
  unsigned int v2:1;
  short v3;
};
//SIG(1 Us_BFu1i_S) C1{ Fs Fi:1 Fs}



static void Test_Us_BFu1i_S()
{
  {
    init_simple_test("Us_BFu1i_S");
    static STRUCT_IF_C Us_BFu1i_S lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_S)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_S");
    check_field_offset(lv, v3, 4, "Us_BFu1i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_S, Us_BFu1i_S)
//============================================================================


struct  Us_BFu1i_Uc  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned char v3;
};
//SIG(1 Us_BFu1i_Uc) C1{ Fs Fi:1 Fc}



static void Test_Us_BFu1i_Uc()
{
  {
    init_simple_test("Us_BFu1i_Uc");
    static STRUCT_IF_C Us_BFu1i_Uc lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_Uc)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_Uc");
    check_field_offset(lv, v3, 3, "Us_BFu1i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_Uc, Us_BFu1i_Uc)
//============================================================================


struct  Us_BFu1i_Ui  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned int v3;
};
//SIG(1 Us_BFu1i_Ui) C1{ Fs Fi:1 Fi}



static void Test_Us_BFu1i_Ui()
{
  {
    init_simple_test("Us_BFu1i_Ui");
    static STRUCT_IF_C Us_BFu1i_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_Ui)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_Ui");
    check_field_offset(lv, v3, 4, "Us_BFu1i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_Ui, Us_BFu1i_Ui)
//============================================================================


struct  Us_BFu1i_Ul  {
  unsigned short v1;
  unsigned int v2:1;
  __tsu64 v3;
};
//SIG(1 Us_BFu1i_Ul) C1{ Fs Fi:1 FL}



static void Test_Us_BFu1i_Ul()
{
  {
    init_simple_test("Us_BFu1i_Ul");
    static STRUCT_IF_C Us_BFu1i_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu1i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1i_Ul)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_Ul, Us_BFu1i_Ul)
//============================================================================


struct  Us_BFu1i_Us  {
  unsigned short v1;
  unsigned int v2:1;
  unsigned short v3;
};
//SIG(1 Us_BFu1i_Us) C1{ Fs Fi:1 Fs}



static void Test_Us_BFu1i_Us()
{
  {
    init_simple_test("Us_BFu1i_Us");
    static STRUCT_IF_C Us_BFu1i_Us lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1i_Us)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_Us");
    check_field_offset(lv, v3, 4, "Us_BFu1i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_Us, Us_BFu1i_Us)
//============================================================================


struct  Us_BFu1i_Vp  {
  unsigned short v1;
  unsigned int v2:1;
  void *v3;
};
//SIG(1 Us_BFu1i_Vp) C1{ Fs Fi:1 Fp}



static void Test_Us_BFu1i_Vp()
{
  {
    init_simple_test("Us_BFu1i_Vp");
    static STRUCT_IF_C Us_BFu1i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu1i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1i_Vp)");
    check_field_offset(lv, v1, 0, "Us_BFu1i_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1i_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1i_Vp, Us_BFu1i_Vp)
//============================================================================


struct  Us_BFu1ll  {
  unsigned short v1;
  __tsu64 v2:1;
};
//SIG(1 Us_BFu1ll) C1{ Fs FL:1}



static void Test_Us_BFu1ll()
{
  {
    init_simple_test("Us_BFu1ll");
    static STRUCT_IF_C Us_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll, Us_BFu1ll)
//============================================================================


struct  Us_BFu1ll_BFu15i  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned int v3:15;
};
//SIG(1 Us_BFu1ll_BFu15i) C1{ Fs FL:1 Fi:15}



static void Test_Us_BFu1ll_BFu15i()
{
  {
    init_simple_test("Us_BFu1ll_BFu15i");
    static STRUCT_IF_C Us_BFu1ll_BFu15i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Us_BFu1ll_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Us_BFu1ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu15i, Us_BFu1ll_BFu15i)
//============================================================================


struct  Us_BFu1ll_BFu15ll  {
  unsigned short v1;
  __tsu64 v2:1;
  __tsu64 v3:15;
};
//SIG(1 Us_BFu1ll_BFu15ll) C1{ Fs FL:1 FL:15}



static void Test_Us_BFu1ll_BFu15ll()
{
  {
    init_simple_test("Us_BFu1ll_BFu15ll");
    static STRUCT_IF_C Us_BFu1ll_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Us_BFu1ll_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Us_BFu1ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu15ll, Us_BFu1ll_BFu15ll)
//============================================================================


struct  Us_BFu1ll_BFu15s  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned short v3:15;
};
//SIG(1 Us_BFu1ll_BFu15s) C1{ Fs FL:1 Fs:15}



static void Test_Us_BFu1ll_BFu15s()
{
  {
    init_simple_test("Us_BFu1ll_BFu15s");
    static STRUCT_IF_C Us_BFu1ll_BFu15s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Us_BFu1ll_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Us_BFu1ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu15s, Us_BFu1ll_BFu15s)
//============================================================================


struct  Us_BFu1ll_BFu16i  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned int v3:16;
};
//SIG(1 Us_BFu1ll_BFu16i) C1{ Fs FL:1 Fi:16}



static void Test_Us_BFu1ll_BFu16i()
{
  {
    init_simple_test("Us_BFu1ll_BFu16i");
    static STRUCT_IF_C Us_BFu1ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu1ll_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu1ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu16i, Us_BFu1ll_BFu16i)
//============================================================================


struct  Us_BFu1ll_BFu16ll  {
  unsigned short v1;
  __tsu64 v2:1;
  __tsu64 v3:16;
};
//SIG(1 Us_BFu1ll_BFu16ll) C1{ Fs FL:1 FL:16}



static void Test_Us_BFu1ll_BFu16ll()
{
  {
    init_simple_test("Us_BFu1ll_BFu16ll");
    static STRUCT_IF_C Us_BFu1ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "Us_BFu1ll_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "Us_BFu1ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu16ll, Us_BFu1ll_BFu16ll)
//============================================================================


struct  Us_BFu1ll_BFu16s  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned short v3:16;
};
//SIG(1 Us_BFu1ll_BFu16s) C1{ Fs FL:1 Fs:16}



static void Test_Us_BFu1ll_BFu16s()
{
  {
    init_simple_test("Us_BFu1ll_BFu16s");
    static STRUCT_IF_C Us_BFu1ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu1ll_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu1ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu16s, Us_BFu1ll_BFu16s)
//============================================================================


struct  Us_BFu1ll_BFu17i  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned int v3:17;
};
//SIG(1 Us_BFu1ll_BFu17i) C1{ Fs FL:1 Fi:17}



static void Test_Us_BFu1ll_BFu17i()
{
  {
    init_simple_test("Us_BFu1ll_BFu17i");
    static STRUCT_IF_C Us_BFu1ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Us_BFu1ll_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu1ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu17i, Us_BFu1ll_BFu17i)
//============================================================================


struct  Us_BFu1ll_BFu17ll  {
  unsigned short v1;
  __tsu64 v2:1;
  __tsu64 v3:17;
};
//SIG(1 Us_BFu1ll_BFu17ll) C1{ Fs FL:1 FL:17}



static void Test_Us_BFu1ll_BFu17ll()
{
  {
    init_simple_test("Us_BFu1ll_BFu17ll");
    static STRUCT_IF_C Us_BFu1ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "Us_BFu1ll_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "Us_BFu1ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu17ll, Us_BFu1ll_BFu17ll)
//============================================================================


struct  Us_BFu1ll_BFu1c  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned char v3:1;
};
//SIG(1 Us_BFu1ll_BFu1c) C1{ Fs FL:1 Fc:1}



static void Test_Us_BFu1ll_BFu1c()
{
  {
    init_simple_test("Us_BFu1ll_BFu1c");
    static STRUCT_IF_C Us_BFu1ll_BFu1c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Us_BFu1ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu1c, Us_BFu1ll_BFu1c)
//============================================================================


struct  Us_BFu1ll_BFu1i  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned int v3:1;
};
//SIG(1 Us_BFu1ll_BFu1i) C1{ Fs FL:1 Fi:1}



static void Test_Us_BFu1ll_BFu1i()
{
  {
    init_simple_test("Us_BFu1ll_BFu1i");
    static STRUCT_IF_C Us_BFu1ll_BFu1i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Us_BFu1ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu1i, Us_BFu1ll_BFu1i)
//============================================================================


struct  Us_BFu1ll_BFu1ll  {
  unsigned short v1;
  __tsu64 v2:1;
  __tsu64 v3:1;
};
//SIG(1 Us_BFu1ll_BFu1ll) C1{ Fs FL:1 FL:1}



static void Test_Us_BFu1ll_BFu1ll()
{
  {
    init_simple_test("Us_BFu1ll_BFu1ll");
    static STRUCT_IF_C Us_BFu1ll_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Us_BFu1ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu1ll, Us_BFu1ll_BFu1ll)
//============================================================================


struct  Us_BFu1ll_BFu1s  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned short v3:1;
};
//SIG(1 Us_BFu1ll_BFu1s) C1{ Fs FL:1 Fs:1}



static void Test_Us_BFu1ll_BFu1s()
{
  {
    init_simple_test("Us_BFu1ll_BFu1s");
    static STRUCT_IF_C Us_BFu1ll_BFu1s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Us_BFu1ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu1s, Us_BFu1ll_BFu1s)
//============================================================================


struct  Us_BFu1ll_BFu31i  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned int v3:31;
};
//SIG(1 Us_BFu1ll_BFu31i) C1{ Fs FL:1 Fi:31}



static void Test_Us_BFu1ll_BFu31i()
{
  {
    init_simple_test("Us_BFu1ll_BFu31i");
    static STRUCT_IF_C Us_BFu1ll_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Us_BFu1ll_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu1ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu31i, Us_BFu1ll_BFu31i)
//============================================================================


struct  Us_BFu1ll_BFu31ll  {
  unsigned short v1;
  __tsu64 v2:1;
  __tsu64 v3:31;
};
//SIG(1 Us_BFu1ll_BFu31ll) C1{ Fs FL:1 FL:31}



static void Test_Us_BFu1ll_BFu31ll()
{
  {
    init_simple_test("Us_BFu1ll_BFu31ll");
    static STRUCT_IF_C Us_BFu1ll_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "Us_BFu1ll_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "Us_BFu1ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu31ll, Us_BFu1ll_BFu31ll)
//============================================================================


struct  Us_BFu1ll_BFu32i  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned int v3:32;
};
//SIG(1 Us_BFu1ll_BFu32i) C1{ Fs FL:1 Fi:32}



static void Test_Us_BFu1ll_BFu32i()
{
  {
    init_simple_test("Us_BFu1ll_BFu32i");
    static STRUCT_IF_C Us_BFu1ll_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Us_BFu1ll_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu1ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu32i, Us_BFu1ll_BFu32i)
//============================================================================


struct  Us_BFu1ll_BFu32ll  {
  unsigned short v1;
  __tsu64 v2:1;
  __tsu64 v3:32;
};
//SIG(1 Us_BFu1ll_BFu32ll) C1{ Fs FL:1 FL:32}



static void Test_Us_BFu1ll_BFu32ll()
{
  {
    init_simple_test("Us_BFu1ll_BFu32ll");
    static STRUCT_IF_C Us_BFu1ll_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "Us_BFu1ll_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "Us_BFu1ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu32ll, Us_BFu1ll_BFu32ll)
//============================================================================


struct  Us_BFu1ll_BFu33  {
  unsigned short v1;
  __tsu64 v2:1;
  __tsu64 v3:33;
};
//SIG(1 Us_BFu1ll_BFu33) C1{ Fs FL:1 FL:33}



static void Test_Us_BFu1ll_BFu33()
{
  {
    init_simple_test("Us_BFu1ll_BFu33");
    static STRUCT_IF_C Us_BFu1ll_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu33)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "Us_BFu1ll_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "Us_BFu1ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu33, Us_BFu1ll_BFu33)
//============================================================================


struct  Us_BFu1ll_BFu7c  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned char v3:7;
};
//SIG(1 Us_BFu1ll_BFu7c) C1{ Fs FL:1 Fc:7}



static void Test_Us_BFu1ll_BFu7c()
{
  {
    init_simple_test("Us_BFu1ll_BFu7c");
    static STRUCT_IF_C Us_BFu1ll_BFu7c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Us_BFu1ll_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Us_BFu1ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu7c, Us_BFu1ll_BFu7c)
//============================================================================


struct  Us_BFu1ll_BFu7i  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned int v3:7;
};
//SIG(1 Us_BFu1ll_BFu7i) C1{ Fs FL:1 Fi:7}



static void Test_Us_BFu1ll_BFu7i()
{
  {
    init_simple_test("Us_BFu1ll_BFu7i");
    static STRUCT_IF_C Us_BFu1ll_BFu7i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Us_BFu1ll_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Us_BFu1ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu7i, Us_BFu1ll_BFu7i)
//============================================================================


struct  Us_BFu1ll_BFu7ll  {
  unsigned short v1;
  __tsu64 v2:1;
  __tsu64 v3:7;
};
//SIG(1 Us_BFu1ll_BFu7ll) C1{ Fs FL:1 FL:7}



static void Test_Us_BFu1ll_BFu7ll()
{
  {
    init_simple_test("Us_BFu1ll_BFu7ll");
    static STRUCT_IF_C Us_BFu1ll_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Us_BFu1ll_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Us_BFu1ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu7ll, Us_BFu1ll_BFu7ll)
//============================================================================


struct  Us_BFu1ll_BFu7s  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned short v3:7;
};
//SIG(1 Us_BFu1ll_BFu7s) C1{ Fs FL:1 Fs:7}



static void Test_Us_BFu1ll_BFu7s()
{
  {
    init_simple_test("Us_BFu1ll_BFu7s");
    static STRUCT_IF_C Us_BFu1ll_BFu7s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Us_BFu1ll_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Us_BFu1ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu7s, Us_BFu1ll_BFu7s)
//============================================================================


struct  Us_BFu1ll_BFu8c  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned char v3:8;
};
//SIG(1 Us_BFu1ll_BFu8c) C1{ Fs FL:1 Fc:8}



static void Test_Us_BFu1ll_BFu8c()
{
  {
    init_simple_test("Us_BFu1ll_BFu8c");
    static STRUCT_IF_C Us_BFu1ll_BFu8c lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Us_BFu1ll_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Us_BFu1ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu8c, Us_BFu1ll_BFu8c)
//============================================================================


struct  Us_BFu1ll_BFu8i  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned int v3:8;
};
//SIG(1 Us_BFu1ll_BFu8i) C1{ Fs FL:1 Fi:8}



static void Test_Us_BFu1ll_BFu8i()
{
  {
    init_simple_test("Us_BFu1ll_BFu8i");
    static STRUCT_IF_C Us_BFu1ll_BFu8i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Us_BFu1ll_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Us_BFu1ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu8i, Us_BFu1ll_BFu8i)
//============================================================================


struct  Us_BFu1ll_BFu8ll  {
  unsigned short v1;
  __tsu64 v2:1;
  __tsu64 v3:8;
};
//SIG(1 Us_BFu1ll_BFu8ll) C1{ Fs FL:1 FL:8}



static void Test_Us_BFu1ll_BFu8ll()
{
  {
    init_simple_test("Us_BFu1ll_BFu8ll");
    static STRUCT_IF_C Us_BFu1ll_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Us_BFu1ll_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Us_BFu1ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu8ll, Us_BFu1ll_BFu8ll)
//============================================================================


struct  Us_BFu1ll_BFu8s  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned short v3:8;
};
//SIG(1 Us_BFu1ll_BFu8s) C1{ Fs FL:1 Fs:8}



static void Test_Us_BFu1ll_BFu8s()
{
  {
    init_simple_test("Us_BFu1ll_BFu8s");
    static STRUCT_IF_C Us_BFu1ll_BFu8s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Us_BFu1ll_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Us_BFu1ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu8s, Us_BFu1ll_BFu8s)
//============================================================================


struct  Us_BFu1ll_BFu9i  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned int v3:9;
};
//SIG(1 Us_BFu1ll_BFu9i) C1{ Fs FL:1 Fi:9}



static void Test_Us_BFu1ll_BFu9i()
{
  {
    init_simple_test("Us_BFu1ll_BFu9i");
    static STRUCT_IF_C Us_BFu1ll_BFu9i lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Us_BFu1ll_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Us_BFu1ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu9i, Us_BFu1ll_BFu9i)
//============================================================================


struct  Us_BFu1ll_BFu9ll  {
  unsigned short v1;
  __tsu64 v2:1;
  __tsu64 v3:9;
};
//SIG(1 Us_BFu1ll_BFu9ll) C1{ Fs FL:1 FL:9}



static void Test_Us_BFu1ll_BFu9ll()
{
  {
    init_simple_test("Us_BFu1ll_BFu9ll");
    static STRUCT_IF_C Us_BFu1ll_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Us_BFu1ll_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Us_BFu1ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu9ll, Us_BFu1ll_BFu9ll)
//============================================================================


struct  Us_BFu1ll_BFu9s  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned short v3:9;
};
//SIG(1 Us_BFu1ll_BFu9s) C1{ Fs FL:1 Fs:9}



static void Test_Us_BFu1ll_BFu9s()
{
  {
    init_simple_test("Us_BFu1ll_BFu9s");
    static STRUCT_IF_C Us_BFu1ll_BFu9s lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Us_BFu1ll_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Us_BFu1ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_BFu9s, Us_BFu1ll_BFu9s)
//============================================================================


struct  Us_BFu1ll_C  {
  unsigned short v1;
  __tsu64 v2:1;
  char v3;
};
//SIG(1 Us_BFu1ll_C) C1{ Fs FL:1 Fc}



static void Test_Us_BFu1ll_C()
{
  {
    init_simple_test("Us_BFu1ll_C");
    static STRUCT_IF_C Us_BFu1ll_C lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_C)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_C");
    check_field_offset(lv, v3, 3, "Us_BFu1ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_C, Us_BFu1ll_C)
//============================================================================


struct  Us_BFu1ll_D  {
  unsigned short v1;
  __tsu64 v2:1;
  double v3;
};
//SIG(1 Us_BFu1ll_D) C1{ Fs FL:1 FL}



static void Test_Us_BFu1ll_D()
{
  {
    init_simple_test("Us_BFu1ll_D");
    static STRUCT_IF_C Us_BFu1ll_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu1ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_D)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_D, Us_BFu1ll_D)
//============================================================================


struct  Us_BFu1ll_F  {
  unsigned short v1;
  __tsu64 v2:1;
  float v3;
};
//SIG(1 Us_BFu1ll_F) C1{ Fs FL:1 Fi}



static void Test_Us_BFu1ll_F()
{
  {
    init_simple_test("Us_BFu1ll_F");
    static STRUCT_IF_C Us_BFu1ll_F lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_F)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_F");
    check_field_offset(lv, v3, 4, "Us_BFu1ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_F, Us_BFu1ll_F)
//============================================================================


struct  Us_BFu1ll_I  {
  unsigned short v1;
  __tsu64 v2:1;
  int v3;
};
//SIG(1 Us_BFu1ll_I) C1{ Fs FL:1 Fi}



static void Test_Us_BFu1ll_I()
{
  {
    init_simple_test("Us_BFu1ll_I");
    static STRUCT_IF_C Us_BFu1ll_I lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_I)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_I");
    check_field_offset(lv, v3, 4, "Us_BFu1ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_I, Us_BFu1ll_I)
//============================================================================


struct  Us_BFu1ll_Ip  {
  unsigned short v1;
  __tsu64 v2:1;
  int *v3;
};
//SIG(1 Us_BFu1ll_Ip) C1{ Fs FL:1 Fp}



static void Test_Us_BFu1ll_Ip()
{
  {
    init_simple_test("Us_BFu1ll_Ip");
    static STRUCT_IF_C Us_BFu1ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu1ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_Ip)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_Ip, Us_BFu1ll_Ip)
//============================================================================


struct  Us_BFu1ll_L  {
  unsigned short v1;
  __tsu64 v2:1;
  __tsi64 v3;
};
//SIG(1 Us_BFu1ll_L) C1{ Fs FL:1 FL}



static void Test_Us_BFu1ll_L()
{
  {
    init_simple_test("Us_BFu1ll_L");
    static STRUCT_IF_C Us_BFu1ll_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu1ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_L)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_L, Us_BFu1ll_L)
//============================================================================


struct  Us_BFu1ll_S  {
  unsigned short v1;
  __tsu64 v2:1;
  short v3;
};
//SIG(1 Us_BFu1ll_S) C1{ Fs FL:1 Fs}



static void Test_Us_BFu1ll_S()
{
  {
    init_simple_test("Us_BFu1ll_S");
    static STRUCT_IF_C Us_BFu1ll_S lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_S)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_S");
    check_field_offset(lv, v3, 4, "Us_BFu1ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_S, Us_BFu1ll_S)
//============================================================================


struct  Us_BFu1ll_Uc  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned char v3;
};
//SIG(1 Us_BFu1ll_Uc) C1{ Fs FL:1 Fc}



static void Test_Us_BFu1ll_Uc()
{
  {
    init_simple_test("Us_BFu1ll_Uc");
    static STRUCT_IF_C Us_BFu1ll_Uc lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_Uc)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_Uc");
    check_field_offset(lv, v3, 3, "Us_BFu1ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_Uc, Us_BFu1ll_Uc)
//============================================================================


struct  Us_BFu1ll_Ui  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned int v3;
};
//SIG(1 Us_BFu1ll_Ui) C1{ Fs FL:1 Fi}



static void Test_Us_BFu1ll_Ui()
{
  {
    init_simple_test("Us_BFu1ll_Ui");
    static STRUCT_IF_C Us_BFu1ll_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_Ui)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_Ui");
    check_field_offset(lv, v3, 4, "Us_BFu1ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_Ui, Us_BFu1ll_Ui)
//============================================================================


struct  Us_BFu1ll_Ul  {
  unsigned short v1;
  __tsu64 v2:1;
  __tsu64 v3;
};
//SIG(1 Us_BFu1ll_Ul) C1{ Fs FL:1 FL}



static void Test_Us_BFu1ll_Ul()
{
  {
    init_simple_test("Us_BFu1ll_Ul");
    static STRUCT_IF_C Us_BFu1ll_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu1ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_Ul)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_Ul, Us_BFu1ll_Ul)
//============================================================================


struct  Us_BFu1ll_Us  {
  unsigned short v1;
  __tsu64 v2:1;
  unsigned short v3;
};
//SIG(1 Us_BFu1ll_Us) C1{ Fs FL:1 Fs}



static void Test_Us_BFu1ll_Us()
{
  {
    init_simple_test("Us_BFu1ll_Us");
    static STRUCT_IF_C Us_BFu1ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_Us)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_Us");
    check_field_offset(lv, v3, 4, "Us_BFu1ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_Us, Us_BFu1ll_Us)
//============================================================================


struct  Us_BFu1ll_Vp  {
  unsigned short v1;
  __tsu64 v2:1;
  void *v3;
};
//SIG(1 Us_BFu1ll_Vp) C1{ Fs FL:1 Fp}



static void Test_Us_BFu1ll_Vp()
{
  {
    init_simple_test("Us_BFu1ll_Vp");
    static STRUCT_IF_C Us_BFu1ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu1ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1ll_Vp)");
    check_field_offset(lv, v1, 0, "Us_BFu1ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1ll_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1ll_Vp, Us_BFu1ll_Vp)
//============================================================================


struct  Us_BFu1s  {
  unsigned short v1;
  unsigned short v2:1;
};
//SIG(1 Us_BFu1s) C1{ Fs Fs:1}



static void Test_Us_BFu1s()
{
  {
    init_simple_test("Us_BFu1s");
    static STRUCT_IF_C Us_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s, Us_BFu1s)
//============================================================================


struct  Us_BFu1s_BFu15i  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned int v3:15;
};
//SIG(1 Us_BFu1s_BFu15i) C1{ Fs Fs:1 Fi:15}



static void Test_Us_BFu1s_BFu15i()
{
  {
    init_simple_test("Us_BFu1s_BFu15i");
    static STRUCT_IF_C Us_BFu1s_BFu15i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1s_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1s_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Us_BFu1s_BFu15i");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Us_BFu1s_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu15i, Us_BFu1s_BFu15i)
//============================================================================


struct  Us_BFu1s_BFu15ll  {
  unsigned short v1;
  unsigned short v2:1;
  __tsu64 v3:15;
};
//SIG(1 Us_BFu1s_BFu15ll) C1{ Fs Fs:1 FL:15}



static void Test_Us_BFu1s_BFu15ll()
{
  {
    init_simple_test("Us_BFu1s_BFu15ll");
    static STRUCT_IF_C Us_BFu1s_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1s_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1s_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Us_BFu1s_BFu15ll");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Us_BFu1s_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu15ll, Us_BFu1s_BFu15ll)
//============================================================================


struct  Us_BFu1s_BFu15s  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned short v3:15;
};
//SIG(1 Us_BFu1s_BFu15s) C1{ Fs Fs:1 Fs:15}



static void Test_Us_BFu1s_BFu15s()
{
  {
    init_simple_test("Us_BFu1s_BFu15s");
    static STRUCT_IF_C Us_BFu1s_BFu15s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1s_BFu15s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1s_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, 1, "Us_BFu1s_BFu15s");
    set_bf_and_test(lv, v3, 2, 1, 15, hide_ull(1LL<<14), "Us_BFu1s_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu15s, Us_BFu1s_BFu15s)
//============================================================================


struct  Us_BFu1s_BFu16i  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned int v3:16;
};
//SIG(1 Us_BFu1s_BFu16i) C1{ Fs Fs:1 Fi:16}



static void Test_Us_BFu1s_BFu16i()
{
  {
    init_simple_test("Us_BFu1s_BFu16i");
    static STRUCT_IF_C Us_BFu1s_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1s_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1s_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu1s_BFu16i");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu1s_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu16i, Us_BFu1s_BFu16i)
//============================================================================


struct  Us_BFu1s_BFu16ll  {
  unsigned short v1;
  unsigned short v2:1;
  __tsu64 v3:16;
};
//SIG(1 Us_BFu1s_BFu16ll) C1{ Fs Fs:1 FL:16}



static void Test_Us_BFu1s_BFu16ll()
{
  {
    init_simple_test("Us_BFu1s_BFu16ll");
    static STRUCT_IF_C Us_BFu1s_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1s_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1s_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, 1, "Us_BFu1s_BFu16ll");
    set_bf_and_test(lv, v3, 2, 1, 16, hide_ull(1LL<<15), "Us_BFu1s_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu16ll, Us_BFu1s_BFu16ll)
//============================================================================


struct  Us_BFu1s_BFu16s  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned short v3:16;
};
//SIG(1 Us_BFu1s_BFu16s) C1{ Fs Fs:1 Fs:16}



static void Test_Us_BFu1s_BFu16s()
{
  {
    init_simple_test("Us_BFu1s_BFu16s");
    static STRUCT_IF_C Us_BFu1s_BFu16s lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu1s_BFu16s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1s_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, 1, "Us_BFu1s_BFu16s");
    set_bf_and_test(lv, v3, 4, 0, 16, hide_ull(1LL<<15), "Us_BFu1s_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu16s, Us_BFu1s_BFu16s)
//============================================================================


struct  Us_BFu1s_BFu17i  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned int v3:17;
};
//SIG(1 Us_BFu1s_BFu17i) C1{ Fs Fs:1 Fi:17}



static void Test_Us_BFu1s_BFu17i()
{
  {
    init_simple_test("Us_BFu1s_BFu17i");
    static STRUCT_IF_C Us_BFu1s_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1s_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1s_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, 1, "Us_BFu1s_BFu17i");
    set_bf_and_test(lv, v3, 4, 0, 17, hide_ull(1LL<<16), "Us_BFu1s_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu17i, Us_BFu1s_BFu17i)
//============================================================================


struct  Us_BFu1s_BFu17ll  {
  unsigned short v1;
  unsigned short v2:1;
  __tsu64 v3:17;
};
//SIG(1 Us_BFu1s_BFu17ll) C1{ Fs Fs:1 FL:17}



static void Test_Us_BFu1s_BFu17ll()
{
  {
    init_simple_test("Us_BFu1s_BFu17ll");
    static STRUCT_IF_C Us_BFu1s_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1s_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1s_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, 1, "Us_BFu1s_BFu17ll");
    set_bf_and_test(lv, v3, 2, 1, 17, hide_ull(1LL<<16), "Us_BFu1s_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu17ll, Us_BFu1s_BFu17ll)
//============================================================================


struct  Us_BFu1s_BFu1c  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned char v3:1;
};
//SIG(1 Us_BFu1s_BFu1c) C1{ Fs Fs:1 Fc:1}



static void Test_Us_BFu1s_BFu1c()
{
  {
    init_simple_test("Us_BFu1s_BFu1c");
    static STRUCT_IF_C Us_BFu1s_BFu1c lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1s_BFu1c)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1s_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu1c");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Us_BFu1s_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu1c, Us_BFu1s_BFu1c)
//============================================================================


struct  Us_BFu1s_BFu1i  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned int v3:1;
};
//SIG(1 Us_BFu1s_BFu1i) C1{ Fs Fs:1 Fi:1}



static void Test_Us_BFu1s_BFu1i()
{
  {
    init_simple_test("Us_BFu1s_BFu1i");
    static STRUCT_IF_C Us_BFu1s_BFu1i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1s_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1s_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu1i");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Us_BFu1s_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu1i, Us_BFu1s_BFu1i)
//============================================================================


struct  Us_BFu1s_BFu1ll  {
  unsigned short v1;
  unsigned short v2:1;
  __tsu64 v3:1;
};
//SIG(1 Us_BFu1s_BFu1ll) C1{ Fs Fs:1 FL:1}



static void Test_Us_BFu1s_BFu1ll()
{
  {
    init_simple_test("Us_BFu1s_BFu1ll");
    static STRUCT_IF_C Us_BFu1s_BFu1ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1s_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1s_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu1ll");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Us_BFu1s_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu1ll, Us_BFu1s_BFu1ll)
//============================================================================


struct  Us_BFu1s_BFu1s  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned short v3:1;
};
//SIG(1 Us_BFu1s_BFu1s) C1{ Fs Fs:1 Fs:1}



static void Test_Us_BFu1s_BFu1s()
{
  {
    init_simple_test("Us_BFu1s_BFu1s");
    static STRUCT_IF_C Us_BFu1s_BFu1s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1s_BFu1s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1s_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu1s");
    set_bf_and_test(lv, v3, 2, 1, 1, 1, "Us_BFu1s_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu1s, Us_BFu1s_BFu1s)
//============================================================================


struct  Us_BFu1s_BFu31i  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned int v3:31;
};
//SIG(1 Us_BFu1s_BFu31i) C1{ Fs Fs:1 Fi:31}



static void Test_Us_BFu1s_BFu31i()
{
  {
    init_simple_test("Us_BFu1s_BFu31i");
    static STRUCT_IF_C Us_BFu1s_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1s_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1s_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, 1, "Us_BFu1s_BFu31i");
    set_bf_and_test(lv, v3, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu1s_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu31i, Us_BFu1s_BFu31i)
//============================================================================


struct  Us_BFu1s_BFu31ll  {
  unsigned short v1;
  unsigned short v2:1;
  __tsu64 v3:31;
};
//SIG(1 Us_BFu1s_BFu31ll) C1{ Fs Fs:1 FL:31}



static void Test_Us_BFu1s_BFu31ll()
{
  {
    init_simple_test("Us_BFu1s_BFu31ll");
    static STRUCT_IF_C Us_BFu1s_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1s_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1s_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, 1, "Us_BFu1s_BFu31ll");
    set_bf_and_test(lv, v3, 2, 1, 31, hide_ull(1LL<<30), "Us_BFu1s_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu31ll, Us_BFu1s_BFu31ll)
//============================================================================


struct  Us_BFu1s_BFu32i  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned int v3:32;
};
//SIG(1 Us_BFu1s_BFu32i) C1{ Fs Fs:1 Fi:32}



static void Test_Us_BFu1s_BFu32i()
{
  {
    init_simple_test("Us_BFu1s_BFu32i");
    static STRUCT_IF_C Us_BFu1s_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1s_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1s_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, 1, "Us_BFu1s_BFu32i");
    set_bf_and_test(lv, v3, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu1s_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu32i, Us_BFu1s_BFu32i)
//============================================================================


struct  Us_BFu1s_BFu32ll  {
  unsigned short v1;
  unsigned short v2:1;
  __tsu64 v3:32;
};
//SIG(1 Us_BFu1s_BFu32ll) C1{ Fs Fs:1 FL:32}



static void Test_Us_BFu1s_BFu32ll()
{
  {
    init_simple_test("Us_BFu1s_BFu32ll");
    static STRUCT_IF_C Us_BFu1s_BFu32ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1s_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1s_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, 1, "Us_BFu1s_BFu32ll");
    set_bf_and_test(lv, v3, 2, 1, 32, hide_ull(1LL<<31), "Us_BFu1s_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu32ll, Us_BFu1s_BFu32ll)
//============================================================================


struct  Us_BFu1s_BFu33  {
  unsigned short v1;
  unsigned short v2:1;
  __tsu64 v3:33;
};
//SIG(1 Us_BFu1s_BFu33) C1{ Fs Fs:1 FL:33}



static void Test_Us_BFu1s_BFu33()
{
  {
    init_simple_test("Us_BFu1s_BFu33");
    static STRUCT_IF_C Us_BFu1s_BFu33 lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1s_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1s_BFu33)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, 1, "Us_BFu1s_BFu33");
    set_bf_and_test(lv, v3, 2, 1, 33, hide_ull(1LL<<32), "Us_BFu1s_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu33, Us_BFu1s_BFu33)
//============================================================================


struct  Us_BFu1s_BFu7c  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned char v3:7;
};
//SIG(1 Us_BFu1s_BFu7c) C1{ Fs Fs:1 Fc:7}



static void Test_Us_BFu1s_BFu7c()
{
  {
    init_simple_test("Us_BFu1s_BFu7c");
    static STRUCT_IF_C Us_BFu1s_BFu7c lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1s_BFu7c)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1s_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Us_BFu1s_BFu7c");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Us_BFu1s_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu7c, Us_BFu1s_BFu7c)
//============================================================================


struct  Us_BFu1s_BFu7i  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned int v3:7;
};
//SIG(1 Us_BFu1s_BFu7i) C1{ Fs Fs:1 Fi:7}



static void Test_Us_BFu1s_BFu7i()
{
  {
    init_simple_test("Us_BFu1s_BFu7i");
    static STRUCT_IF_C Us_BFu1s_BFu7i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1s_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1s_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Us_BFu1s_BFu7i");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Us_BFu1s_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu7i, Us_BFu1s_BFu7i)
//============================================================================


struct  Us_BFu1s_BFu7ll  {
  unsigned short v1;
  unsigned short v2:1;
  __tsu64 v3:7;
};
//SIG(1 Us_BFu1s_BFu7ll) C1{ Fs Fs:1 FL:7}



static void Test_Us_BFu1s_BFu7ll()
{
  {
    init_simple_test("Us_BFu1s_BFu7ll");
    static STRUCT_IF_C Us_BFu1s_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1s_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1s_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Us_BFu1s_BFu7ll");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Us_BFu1s_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu7ll, Us_BFu1s_BFu7ll)
//============================================================================


struct  Us_BFu1s_BFu7s  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned short v3:7;
};
//SIG(1 Us_BFu1s_BFu7s) C1{ Fs Fs:1 Fs:7}



static void Test_Us_BFu1s_BFu7s()
{
  {
    init_simple_test("Us_BFu1s_BFu7s");
    static STRUCT_IF_C Us_BFu1s_BFu7s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1s_BFu7s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1s_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, 1, "Us_BFu1s_BFu7s");
    set_bf_and_test(lv, v3, 2, 1, 7, hide_ull(1LL<<6), "Us_BFu1s_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu7s, Us_BFu1s_BFu7s)
//============================================================================


struct  Us_BFu1s_BFu8c  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned char v3:8;
};
//SIG(1 Us_BFu1s_BFu8c) C1{ Fs Fs:1 Fc:8}



static void Test_Us_BFu1s_BFu8c()
{
  {
    init_simple_test("Us_BFu1s_BFu8c");
    static STRUCT_IF_C Us_BFu1s_BFu8c lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1s_BFu8c)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1s_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, 1, "Us_BFu1s_BFu8c");
    set_bf_and_test(lv, v3, 3, 0, 8, hide_ull(1LL<<7), "Us_BFu1s_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu8c, Us_BFu1s_BFu8c)
//============================================================================


struct  Us_BFu1s_BFu8i  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned int v3:8;
};
//SIG(1 Us_BFu1s_BFu8i) C1{ Fs Fs:1 Fi:8}



static void Test_Us_BFu1s_BFu8i()
{
  {
    init_simple_test("Us_BFu1s_BFu8i");
    static STRUCT_IF_C Us_BFu1s_BFu8i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1s_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1s_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Us_BFu1s_BFu8i");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Us_BFu1s_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu8i, Us_BFu1s_BFu8i)
//============================================================================


struct  Us_BFu1s_BFu8ll  {
  unsigned short v1;
  unsigned short v2:1;
  __tsu64 v3:8;
};
//SIG(1 Us_BFu1s_BFu8ll) C1{ Fs Fs:1 FL:8}



static void Test_Us_BFu1s_BFu8ll()
{
  {
    init_simple_test("Us_BFu1s_BFu8ll");
    static STRUCT_IF_C Us_BFu1s_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1s_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1s_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Us_BFu1s_BFu8ll");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Us_BFu1s_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu8ll, Us_BFu1s_BFu8ll)
//============================================================================


struct  Us_BFu1s_BFu8s  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned short v3:8;
};
//SIG(1 Us_BFu1s_BFu8s) C1{ Fs Fs:1 Fs:8}



static void Test_Us_BFu1s_BFu8s()
{
  {
    init_simple_test("Us_BFu1s_BFu8s");
    static STRUCT_IF_C Us_BFu1s_BFu8s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1s_BFu8s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1s_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, 1, "Us_BFu1s_BFu8s");
    set_bf_and_test(lv, v3, 2, 1, 8, hide_ull(1LL<<7), "Us_BFu1s_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu8s, Us_BFu1s_BFu8s)
//============================================================================


struct  Us_BFu1s_BFu9i  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned int v3:9;
};
//SIG(1 Us_BFu1s_BFu9i) C1{ Fs Fs:1 Fi:9}



static void Test_Us_BFu1s_BFu9i()
{
  {
    init_simple_test("Us_BFu1s_BFu9i");
    static STRUCT_IF_C Us_BFu1s_BFu9i lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1s_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1s_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Us_BFu1s_BFu9i");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Us_BFu1s_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu9i, Us_BFu1s_BFu9i)
//============================================================================


struct  Us_BFu1s_BFu9ll  {
  unsigned short v1;
  unsigned short v2:1;
  __tsu64 v3:9;
};
//SIG(1 Us_BFu1s_BFu9ll) C1{ Fs Fs:1 FL:9}



static void Test_Us_BFu1s_BFu9ll()
{
  {
    init_simple_test("Us_BFu1s_BFu9ll");
    static STRUCT_IF_C Us_BFu1s_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(Us_BFu1s_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1s_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Us_BFu1s_BFu9ll");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Us_BFu1s_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu9ll, Us_BFu1s_BFu9ll)
//============================================================================


struct  Us_BFu1s_BFu9s  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned short v3:9;
};
//SIG(1 Us_BFu1s_BFu9s) C1{ Fs Fs:1 Fs:9}



static void Test_Us_BFu1s_BFu9s()
{
  {
    init_simple_test("Us_BFu1s_BFu9s");
    static STRUCT_IF_C Us_BFu1s_BFu9s lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1s_BFu9s)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1s_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, 1, "Us_BFu1s_BFu9s");
    set_bf_and_test(lv, v3, 2, 1, 9, hide_ull(1LL<<8), "Us_BFu1s_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_BFu9s, Us_BFu1s_BFu9s)
//============================================================================


struct  Us_BFu1s_C  {
  unsigned short v1;
  unsigned short v2:1;
  char v3;
};
//SIG(1 Us_BFu1s_C) C1{ Fs Fs:1 Fc}



static void Test_Us_BFu1s_C()
{
  {
    init_simple_test("Us_BFu1s_C");
    static STRUCT_IF_C Us_BFu1s_C lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1s_C)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1s_C)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_C");
    check_field_offset(lv, v3, 3, "Us_BFu1s_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_C, Us_BFu1s_C)
//============================================================================


struct  Us_BFu1s_D  {
  unsigned short v1;
  unsigned short v2:1;
  double v3;
};
//SIG(1 Us_BFu1s_D) C1{ Fs Fs:1 FL}



static void Test_Us_BFu1s_D()
{
  {
    init_simple_test("Us_BFu1s_D");
    static STRUCT_IF_C Us_BFu1s_D lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu1s_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1s_D)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_D");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1s_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_D, Us_BFu1s_D)
//============================================================================


struct  Us_BFu1s_F  {
  unsigned short v1;
  unsigned short v2:1;
  float v3;
};
//SIG(1 Us_BFu1s_F) C1{ Fs Fs:1 Fi}



static void Test_Us_BFu1s_F()
{
  {
    init_simple_test("Us_BFu1s_F");
    static STRUCT_IF_C Us_BFu1s_F lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1s_F)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1s_F)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_F");
    check_field_offset(lv, v3, 4, "Us_BFu1s_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_F, Us_BFu1s_F)
//============================================================================


struct  Us_BFu1s_I  {
  unsigned short v1;
  unsigned short v2:1;
  int v3;
};
//SIG(1 Us_BFu1s_I) C1{ Fs Fs:1 Fi}



static void Test_Us_BFu1s_I()
{
  {
    init_simple_test("Us_BFu1s_I");
    static STRUCT_IF_C Us_BFu1s_I lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1s_I)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1s_I)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_I");
    check_field_offset(lv, v3, 4, "Us_BFu1s_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_I, Us_BFu1s_I)
//============================================================================


struct  Us_BFu1s_Ip  {
  unsigned short v1;
  unsigned short v2:1;
  int *v3;
};
//SIG(1 Us_BFu1s_Ip) C1{ Fs Fs:1 Fp}



static void Test_Us_BFu1s_Ip()
{
  {
    init_simple_test("Us_BFu1s_Ip");
    static STRUCT_IF_C Us_BFu1s_Ip lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu1s_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1s_Ip)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_Ip");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1s_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_Ip, Us_BFu1s_Ip)
//============================================================================


struct  Us_BFu1s_L  {
  unsigned short v1;
  unsigned short v2:1;
  __tsi64 v3;
};
//SIG(1 Us_BFu1s_L) C1{ Fs Fs:1 FL}



static void Test_Us_BFu1s_L()
{
  {
    init_simple_test("Us_BFu1s_L");
    static STRUCT_IF_C Us_BFu1s_L lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu1s_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1s_L)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_L");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1s_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_L, Us_BFu1s_L)
//============================================================================


struct  Us_BFu1s_S  {
  unsigned short v1;
  unsigned short v2:1;
  short v3;
};
//SIG(1 Us_BFu1s_S) C1{ Fs Fs:1 Fs}



static void Test_Us_BFu1s_S()
{
  {
    init_simple_test("Us_BFu1s_S");
    static STRUCT_IF_C Us_BFu1s_S lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu1s_S)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1s_S)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_S");
    check_field_offset(lv, v3, 4, "Us_BFu1s_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_S, Us_BFu1s_S)
//============================================================================


struct  Us_BFu1s_Uc  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned char v3;
};
//SIG(1 Us_BFu1s_Uc) C1{ Fs Fs:1 Fc}



static void Test_Us_BFu1s_Uc()
{
  {
    init_simple_test("Us_BFu1s_Uc");
    static STRUCT_IF_C Us_BFu1s_Uc lv;
    check2(sizeof(lv), 4, "sizeof(Us_BFu1s_Uc)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1s_Uc)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_Uc");
    check_field_offset(lv, v3, 3, "Us_BFu1s_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_Uc, Us_BFu1s_Uc)
//============================================================================


struct  Us_BFu1s_Ui  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned int v3;
};
//SIG(1 Us_BFu1s_Ui) C1{ Fs Fs:1 Fi}



static void Test_Us_BFu1s_Ui()
{
  {
    init_simple_test("Us_BFu1s_Ui");
    static STRUCT_IF_C Us_BFu1s_Ui lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu1s_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu1s_Ui)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_Ui");
    check_field_offset(lv, v3, 4, "Us_BFu1s_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_Ui, Us_BFu1s_Ui)
//============================================================================


struct  Us_BFu1s_Ul  {
  unsigned short v1;
  unsigned short v2:1;
  __tsu64 v3;
};
//SIG(1 Us_BFu1s_Ul) C1{ Fs Fs:1 FL}



static void Test_Us_BFu1s_Ul()
{
  {
    init_simple_test("Us_BFu1s_Ul");
    static STRUCT_IF_C Us_BFu1s_Ul lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu1s_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1s_Ul)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_Ul");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1s_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_Ul, Us_BFu1s_Ul)
//============================================================================


struct  Us_BFu1s_Us  {
  unsigned short v1;
  unsigned short v2:1;
  unsigned short v3;
};
//SIG(1 Us_BFu1s_Us) C1{ Fs Fs:1 Fs}



static void Test_Us_BFu1s_Us()
{
  {
    init_simple_test("Us_BFu1s_Us");
    static STRUCT_IF_C Us_BFu1s_Us lv;
    check2(sizeof(lv), 6, "sizeof(Us_BFu1s_Us)");
    check2(__alignof__(lv), 2, "__alignof__(Us_BFu1s_Us)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_Us");
    check_field_offset(lv, v3, 4, "Us_BFu1s_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_Us, Us_BFu1s_Us)
//============================================================================


struct  Us_BFu1s_Vp  {
  unsigned short v1;
  unsigned short v2:1;
  void *v3;
};
//SIG(1 Us_BFu1s_Vp) C1{ Fs Fs:1 Fp}



static void Test_Us_BFu1s_Vp()
{
  {
    init_simple_test("Us_BFu1s_Vp");
    static STRUCT_IF_C Us_BFu1s_Vp lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(Us_BFu1s_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu1s_Vp)");
    check_field_offset(lv, v1, 0, "Us_BFu1s_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 1, 1, "Us_BFu1s_Vp");
    check_field_offset(lv, v3, ABISELECT(8,4), "Us_BFu1s_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu1s_Vp, Us_BFu1s_Vp)
//============================================================================


struct  Us_BFu31i  {
  unsigned short v1;
  unsigned int v2:31;
};
//SIG(1 Us_BFu31i) C1{ Fs Fi:31}



static void Test_Us_BFu31i()
{
  {
    init_simple_test("Us_BFu31i");
    static STRUCT_IF_C Us_BFu31i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i, Us_BFu31i)
//============================================================================


struct  Us_BFu31i_BFu15i  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned int v3:15;
};
//SIG(1 Us_BFu31i_BFu15i) C1{ Fs Fi:31 Fi:15}



static void Test_Us_BFu31i_BFu15i()
{
  {
    init_simple_test("Us_BFu31i_BFu15i");
    static STRUCT_IF_C Us_BFu31i_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Us_BFu31i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Us_BFu31i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu15i, Us_BFu31i_BFu15i)
//============================================================================


struct  Us_BFu31i_BFu15ll  {
  unsigned short v1;
  unsigned int v2:31;
  __tsu64 v3:15;
};
//SIG(1 Us_BFu31i_BFu15ll) C1{ Fs Fi:31 FL:15}



static void Test_Us_BFu31i_BFu15ll()
{
  {
    init_simple_test("Us_BFu31i_BFu15ll");
    static STRUCT_IF_C Us_BFu31i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 15, 1, "Us_BFu31i_BFu15ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 15, hide_ull(1LL<<14), "Us_BFu31i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu15ll, Us_BFu31i_BFu15ll)
//============================================================================


struct  Us_BFu31i_BFu15s  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned short v3:15;
};
//SIG(1 Us_BFu31i_BFu15s) C1{ Fs Fi:31 Fs:15}



static void Test_Us_BFu31i_BFu15s()
{
  {
    init_simple_test("Us_BFu31i_BFu15s");
    static STRUCT_IF_C Us_BFu31i_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Us_BFu31i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Us_BFu31i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu15s, Us_BFu31i_BFu15s)
//============================================================================


struct  Us_BFu31i_BFu16i  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned int v3:16;
};
//SIG(1 Us_BFu31i_BFu16i) C1{ Fs Fi:31 Fi:16}



static void Test_Us_BFu31i_BFu16i()
{
  {
    init_simple_test("Us_BFu31i_BFu16i");
    static STRUCT_IF_C Us_BFu31i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Us_BFu31i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Us_BFu31i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu16i, Us_BFu31i_BFu16i)
//============================================================================


struct  Us_BFu31i_BFu16ll  {
  unsigned short v1;
  unsigned int v2:31;
  __tsu64 v3:16;
};
//SIG(1 Us_BFu31i_BFu16ll) C1{ Fs Fi:31 FL:16}



static void Test_Us_BFu31i_BFu16ll()
{
  {
    init_simple_test("Us_BFu31i_BFu16ll");
    static STRUCT_IF_C Us_BFu31i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 16, 1, "Us_BFu31i_BFu16ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 16, hide_ull(1LL<<15), "Us_BFu31i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu16ll, Us_BFu31i_BFu16ll)
//============================================================================


struct  Us_BFu31i_BFu16s  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned short v3:16;
};
//SIG(1 Us_BFu31i_BFu16s) C1{ Fs Fi:31 Fs:16}



static void Test_Us_BFu31i_BFu16s()
{
  {
    init_simple_test("Us_BFu31i_BFu16s");
    static STRUCT_IF_C Us_BFu31i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Us_BFu31i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Us_BFu31i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu16s, Us_BFu31i_BFu16s)
//============================================================================


struct  Us_BFu31i_BFu17i  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned int v3:17;
};
//SIG(1 Us_BFu31i_BFu17i) C1{ Fs Fi:31 Fi:17}



static void Test_Us_BFu31i_BFu17i()
{
  {
    init_simple_test("Us_BFu31i_BFu17i");
    static STRUCT_IF_C Us_BFu31i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Us_BFu31i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Us_BFu31i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu17i, Us_BFu31i_BFu17i)
//============================================================================


struct  Us_BFu31i_BFu17ll  {
  unsigned short v1;
  unsigned int v2:31;
  __tsu64 v3:17;
};
//SIG(1 Us_BFu31i_BFu17ll) C1{ Fs Fi:31 FL:17}



static void Test_Us_BFu31i_BFu17ll()
{
  {
    init_simple_test("Us_BFu31i_BFu17ll");
    static STRUCT_IF_C Us_BFu31i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 17, 1, "Us_BFu31i_BFu17ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 17, hide_ull(1LL<<16), "Us_BFu31i_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu17ll, Us_BFu31i_BFu17ll)
//============================================================================


struct  Us_BFu31i_BFu1c  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned char v3:1;
};
//SIG(1 Us_BFu31i_BFu1c) C1{ Fs Fi:31 Fc:1}



static void Test_Us_BFu31i_BFu1c()
{
  {
    init_simple_test("Us_BFu31i_BFu1c");
    static STRUCT_IF_C Us_BFu31i_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31i_BFu1c)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu1c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu1c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu1c");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "Us_BFu31i_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu1c, Us_BFu31i_BFu1c)
//============================================================================


struct  Us_BFu31i_BFu1i  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned int v3:1;
};
//SIG(1 Us_BFu31i_BFu1i) C1{ Fs Fi:31 Fi:1}



static void Test_Us_BFu31i_BFu1i()
{
  {
    init_simple_test("Us_BFu31i_BFu1i");
    static STRUCT_IF_C Us_BFu31i_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31i_BFu1i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu1i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu1i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu1i");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "Us_BFu31i_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu1i, Us_BFu31i_BFu1i)
//============================================================================


struct  Us_BFu31i_BFu1ll  {
  unsigned short v1;
  unsigned int v2:31;
  __tsu64 v3:1;
};
//SIG(1 Us_BFu31i_BFu1ll) C1{ Fs Fi:31 FL:1}



static void Test_Us_BFu31i_BFu1ll()
{
  {
    init_simple_test("Us_BFu31i_BFu1ll");
    static STRUCT_IF_C Us_BFu31i_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31i_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31i_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu1ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu1ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu1ll");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "Us_BFu31i_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu1ll, Us_BFu31i_BFu1ll)
//============================================================================


struct  Us_BFu31i_BFu1s  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned short v3:1;
};
//SIG(1 Us_BFu31i_BFu1s) C1{ Fs Fi:31 Fs:1}



static void Test_Us_BFu31i_BFu1s()
{
  {
    init_simple_test("Us_BFu31i_BFu1s");
    static STRUCT_IF_C Us_BFu31i_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31i_BFu1s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu1s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu1s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu1s");
    set_bf_and_test(lv, v3, 7, 7, 1, 1, "Us_BFu31i_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu1s, Us_BFu31i_BFu1s)
//============================================================================


struct  Us_BFu31i_BFu31i  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned int v3:31;
};
//SIG(1 Us_BFu31i_BFu31i) C1{ Fs Fi:31 Fi:31}



static void Test_Us_BFu31i_BFu31i()
{
  {
    init_simple_test("Us_BFu31i_BFu31i");
    static STRUCT_IF_C Us_BFu31i_BFu31i lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_BFu31i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu31i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu31i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Us_BFu31i_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu31i, Us_BFu31i_BFu31i)
//============================================================================


struct  Us_BFu31i_BFu31ll  {
  unsigned short v1;
  unsigned int v2:31;
  __tsu64 v3:31;
};
//SIG(1 Us_BFu31i_BFu31ll) C1{ Fs Fi:31 FL:31}



static void Test_Us_BFu31i_BFu31ll()
{
  {
    init_simple_test("Us_BFu31i_BFu31ll");
    static STRUCT_IF_C Us_BFu31i_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31i_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31i_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu31ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu31ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, 1, "Us_BFu31i_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 31, hide_ull(1LL<<30), "Us_BFu31i_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu31ll, Us_BFu31i_BFu31ll)
//============================================================================


struct  Us_BFu31i_BFu32i  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned int v3:32;
};
//SIG(1 Us_BFu31i_BFu32i) C1{ Fs Fi:31 Fi:32}



static void Test_Us_BFu31i_BFu32i()
{
  {
    init_simple_test("Us_BFu31i_BFu32i");
    static STRUCT_IF_C Us_BFu31i_BFu32i lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Us_BFu31i_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Us_BFu31i_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu32i, Us_BFu31i_BFu32i)
//============================================================================


struct  Us_BFu31i_BFu32ll  {
  unsigned short v1;
  unsigned int v2:31;
  __tsu64 v3:32;
};
//SIG(1 Us_BFu31i_BFu32ll) C1{ Fs Fi:31 FL:32}



static void Test_Us_BFu31i_BFu32ll()
{
  {
    init_simple_test("Us_BFu31i_BFu32ll");
    static STRUCT_IF_C Us_BFu31i_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31i_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31i_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu32ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu32ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 32, 1, "Us_BFu31i_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 32, hide_ull(1LL<<31), "Us_BFu31i_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu32ll, Us_BFu31i_BFu32ll)
//============================================================================


struct  Us_BFu31i_BFu33  {
  unsigned short v1;
  unsigned int v2:31;
  __tsu64 v3:33;
};
//SIG(1 Us_BFu31i_BFu33) C1{ Fs Fi:31 FL:33}



static void Test_Us_BFu31i_BFu33()
{
  {
    init_simple_test("Us_BFu31i_BFu33");
    static STRUCT_IF_C Us_BFu31i_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31i_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31i_BFu33)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu33.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu33");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 33, 1, "Us_BFu31i_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 33, hide_ull(1LL<<32), "Us_BFu31i_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu33, Us_BFu31i_BFu33)
//============================================================================


struct  Us_BFu31i_BFu7c  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned char v3:7;
};
//SIG(1 Us_BFu31i_BFu7c) C1{ Fs Fi:31 Fc:7}



static void Test_Us_BFu31i_BFu7c()
{
  {
    init_simple_test("Us_BFu31i_BFu7c");
    static STRUCT_IF_C Us_BFu31i_BFu7c lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_BFu7c)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu7c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu7c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Us_BFu31i_BFu7c");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Us_BFu31i_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu7c, Us_BFu31i_BFu7c)
//============================================================================


struct  Us_BFu31i_BFu7i  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned int v3:7;
};
//SIG(1 Us_BFu31i_BFu7i) C1{ Fs Fi:31 Fi:7}



static void Test_Us_BFu31i_BFu7i()
{
  {
    init_simple_test("Us_BFu31i_BFu7i");
    static STRUCT_IF_C Us_BFu31i_BFu7i lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_BFu7i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu7i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu7i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Us_BFu31i_BFu7i");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Us_BFu31i_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu7i, Us_BFu31i_BFu7i)
//============================================================================


struct  Us_BFu31i_BFu7ll  {
  unsigned short v1;
  unsigned int v2:31;
  __tsu64 v3:7;
};
//SIG(1 Us_BFu31i_BFu7ll) C1{ Fs Fi:31 FL:7}



static void Test_Us_BFu31i_BFu7ll()
{
  {
    init_simple_test("Us_BFu31i_BFu7ll");
    static STRUCT_IF_C Us_BFu31i_BFu7ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31i_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31i_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu7ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu7ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 7, 1, "Us_BFu31i_BFu7ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 7, hide_ull(1LL<<6), "Us_BFu31i_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu7ll, Us_BFu31i_BFu7ll)
//============================================================================


struct  Us_BFu31i_BFu7s  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned short v3:7;
};
//SIG(1 Us_BFu31i_BFu7s) C1{ Fs Fi:31 Fs:7}



static void Test_Us_BFu31i_BFu7s()
{
  {
    init_simple_test("Us_BFu31i_BFu7s");
    static STRUCT_IF_C Us_BFu31i_BFu7s lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_BFu7s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu7s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu7s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, 1, "Us_BFu31i_BFu7s");
    set_bf_and_test(lv, v3, 8, 0, 7, hide_ull(1LL<<6), "Us_BFu31i_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu7s, Us_BFu31i_BFu7s)
//============================================================================


struct  Us_BFu31i_BFu8c  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned char v3:8;
};
//SIG(1 Us_BFu31i_BFu8c) C1{ Fs Fi:31 Fc:8}



static void Test_Us_BFu31i_BFu8c()
{
  {
    init_simple_test("Us_BFu31i_BFu8c");
    static STRUCT_IF_C Us_BFu31i_BFu8c lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_BFu8c)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu8c.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu8c");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Us_BFu31i_BFu8c");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Us_BFu31i_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu8c, Us_BFu31i_BFu8c)
//============================================================================


struct  Us_BFu31i_BFu8i  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned int v3:8;
};
//SIG(1 Us_BFu31i_BFu8i) C1{ Fs Fi:31 Fi:8}



static void Test_Us_BFu31i_BFu8i()
{
  {
    init_simple_test("Us_BFu31i_BFu8i");
    static STRUCT_IF_C Us_BFu31i_BFu8i lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_BFu8i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu8i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu8i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Us_BFu31i_BFu8i");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Us_BFu31i_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu8i, Us_BFu31i_BFu8i)
//============================================================================


struct  Us_BFu31i_BFu8ll  {
  unsigned short v1;
  unsigned int v2:31;
  __tsu64 v3:8;
};
//SIG(1 Us_BFu31i_BFu8ll) C1{ Fs Fi:31 FL:8}



static void Test_Us_BFu31i_BFu8ll()
{
  {
    init_simple_test("Us_BFu31i_BFu8ll");
    static STRUCT_IF_C Us_BFu31i_BFu8ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31i_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31i_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu8ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu8ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 8, 1, "Us_BFu31i_BFu8ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 8, hide_ull(1LL<<7), "Us_BFu31i_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu8ll, Us_BFu31i_BFu8ll)
//============================================================================


struct  Us_BFu31i_BFu8s  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned short v3:8;
};
//SIG(1 Us_BFu31i_BFu8s) C1{ Fs Fi:31 Fs:8}



static void Test_Us_BFu31i_BFu8s()
{
  {
    init_simple_test("Us_BFu31i_BFu8s");
    static STRUCT_IF_C Us_BFu31i_BFu8s lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_BFu8s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu8s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu8s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, 1, "Us_BFu31i_BFu8s");
    set_bf_and_test(lv, v3, 8, 0, 8, hide_ull(1LL<<7), "Us_BFu31i_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu8s, Us_BFu31i_BFu8s)
//============================================================================


struct  Us_BFu31i_BFu9i  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned int v3:9;
};
//SIG(1 Us_BFu31i_BFu9i) C1{ Fs Fi:31 Fi:9}



static void Test_Us_BFu31i_BFu9i()
{
  {
    init_simple_test("Us_BFu31i_BFu9i");
    static STRUCT_IF_C Us_BFu31i_BFu9i lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_BFu9i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu9i.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu9i");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Us_BFu31i_BFu9i");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Us_BFu31i_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu9i, Us_BFu31i_BFu9i)
//============================================================================


struct  Us_BFu31i_BFu9ll  {
  unsigned short v1;
  unsigned int v2:31;
  __tsu64 v3:9;
};
//SIG(1 Us_BFu31i_BFu9ll) C1{ Fs Fi:31 FL:9}



static void Test_Us_BFu31i_BFu9ll()
{
  {
    init_simple_test("Us_BFu31i_BFu9ll");
    static STRUCT_IF_C Us_BFu31i_BFu9ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31i_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31i_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu9ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu9ll");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 9, 1, "Us_BFu31i_BFu9ll");
    set_bf_and_test(lv, v3, ABISELECT(8,7), ABISELECT(0,7), 9, hide_ull(1LL<<8), "Us_BFu31i_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu9ll, Us_BFu31i_BFu9ll)
//============================================================================


struct  Us_BFu31i_BFu9s  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned short v3:9;
};
//SIG(1 Us_BFu31i_BFu9s) C1{ Fs Fi:31 Fs:9}



static void Test_Us_BFu31i_BFu9s()
{
  {
    init_simple_test("Us_BFu31i_BFu9s");
    static STRUCT_IF_C Us_BFu31i_BFu9s lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_BFu9s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_BFu9s.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_BFu9s");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, 1, "Us_BFu31i_BFu9s");
    set_bf_and_test(lv, v3, 8, 0, 9, hide_ull(1LL<<8), "Us_BFu31i_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_BFu9s, Us_BFu31i_BFu9s)
//============================================================================


struct  Us_BFu31i_C  {
  unsigned short v1;
  unsigned int v2:31;
  char v3;
};
//SIG(1 Us_BFu31i_C) C1{ Fs Fi:31 Fc}



static void Test_Us_BFu31i_C()
{
  {
    init_simple_test("Us_BFu31i_C");
    static STRUCT_IF_C Us_BFu31i_C lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_C)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_C)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_C.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_C");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_C");
    check_field_offset(lv, v3, 8, "Us_BFu31i_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_C, Us_BFu31i_C)
//============================================================================


struct  Us_BFu31i_D  {
  unsigned short v1;
  unsigned int v2:31;
  double v3;
};
//SIG(1 Us_BFu31i_D) C1{ Fs Fi:31 FL}



static void Test_Us_BFu31i_D()
{
  {
    init_simple_test("Us_BFu31i_D");
    static STRUCT_IF_C Us_BFu31i_D lv;
    check2(sizeof(lv), 16, "sizeof(Us_BFu31i_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31i_D)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_D.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_D");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_D");
    check_field_offset(lv, v3, 8, "Us_BFu31i_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_D, Us_BFu31i_D)
//============================================================================


struct  Us_BFu31i_F  {
  unsigned short v1;
  unsigned int v2:31;
  float v3;
};
//SIG(1 Us_BFu31i_F) C1{ Fs Fi:31 Fi}



static void Test_Us_BFu31i_F()
{
  {
    init_simple_test("Us_BFu31i_F");
    static STRUCT_IF_C Us_BFu31i_F lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_F)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_F)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_F.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_F");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_F");
    check_field_offset(lv, v3, 8, "Us_BFu31i_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_F, Us_BFu31i_F)
//============================================================================


struct  Us_BFu31i_I  {
  unsigned short v1;
  unsigned int v2:31;
  int v3;
};
//SIG(1 Us_BFu31i_I) C1{ Fs Fi:31 Fi}



static void Test_Us_BFu31i_I()
{
  {
    init_simple_test("Us_BFu31i_I");
    static STRUCT_IF_C Us_BFu31i_I lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_I)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_I)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_I.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_I");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_I");
    check_field_offset(lv, v3, 8, "Us_BFu31i_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_I, Us_BFu31i_I)
//============================================================================


struct  Us_BFu31i_Ip  {
  unsigned short v1;
  unsigned int v2:31;
  int *v3;
};
//SIG(1 Us_BFu31i_Ip) C1{ Fs Fi:31 Fp}



static void Test_Us_BFu31i_Ip()
{
  {
    init_simple_test("Us_BFu31i_Ip");
    static STRUCT_IF_C Us_BFu31i_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31i_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31i_Ip)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_Ip.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_Ip");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_Ip");
    check_field_offset(lv, v3, 8, "Us_BFu31i_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_Ip, Us_BFu31i_Ip)
//============================================================================


struct  Us_BFu31i_L  {
  unsigned short v1;
  unsigned int v2:31;
  __tsi64 v3;
};
//SIG(1 Us_BFu31i_L) C1{ Fs Fi:31 FL}



static void Test_Us_BFu31i_L()
{
  {
    init_simple_test("Us_BFu31i_L");
    static STRUCT_IF_C Us_BFu31i_L lv;
    check2(sizeof(lv), 16, "sizeof(Us_BFu31i_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31i_L)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_L.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_L");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_L");
    check_field_offset(lv, v3, 8, "Us_BFu31i_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_L, Us_BFu31i_L)
//============================================================================


struct  Us_BFu31i_S  {
  unsigned short v1;
  unsigned int v2:31;
  short v3;
};
//SIG(1 Us_BFu31i_S) C1{ Fs Fi:31 Fs}



static void Test_Us_BFu31i_S()
{
  {
    init_simple_test("Us_BFu31i_S");
    static STRUCT_IF_C Us_BFu31i_S lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_S)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_S)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_S.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_S");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_S");
    check_field_offset(lv, v3, 8, "Us_BFu31i_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_S, Us_BFu31i_S)
//============================================================================


struct  Us_BFu31i_Uc  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned char v3;
};
//SIG(1 Us_BFu31i_Uc) C1{ Fs Fi:31 Fc}



static void Test_Us_BFu31i_Uc()
{
  {
    init_simple_test("Us_BFu31i_Uc");
    static STRUCT_IF_C Us_BFu31i_Uc lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_Uc)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_Uc)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_Uc.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_Uc");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_Uc");
    check_field_offset(lv, v3, 8, "Us_BFu31i_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_Uc, Us_BFu31i_Uc)
//============================================================================


struct  Us_BFu31i_Ui  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned int v3;
};
//SIG(1 Us_BFu31i_Ui) C1{ Fs Fi:31 Fi}



static void Test_Us_BFu31i_Ui()
{
  {
    init_simple_test("Us_BFu31i_Ui");
    static STRUCT_IF_C Us_BFu31i_Ui lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_Ui)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_Ui)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_Ui.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_Ui");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_Ui");
    check_field_offset(lv, v3, 8, "Us_BFu31i_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_Ui, Us_BFu31i_Ui)
//============================================================================


struct  Us_BFu31i_Ul  {
  unsigned short v1;
  unsigned int v2:31;
  __tsu64 v3;
};
//SIG(1 Us_BFu31i_Ul) C1{ Fs Fi:31 FL}



static void Test_Us_BFu31i_Ul()
{
  {
    init_simple_test("Us_BFu31i_Ul");
    static STRUCT_IF_C Us_BFu31i_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Us_BFu31i_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31i_Ul)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_Ul.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_Ul");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_Ul");
    check_field_offset(lv, v3, 8, "Us_BFu31i_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_Ul, Us_BFu31i_Ul)
//============================================================================


struct  Us_BFu31i_Us  {
  unsigned short v1;
  unsigned int v2:31;
  unsigned short v3;
};
//SIG(1 Us_BFu31i_Us) C1{ Fs Fi:31 Fs}



static void Test_Us_BFu31i_Us()
{
  {
    init_simple_test("Us_BFu31i_Us");
    static STRUCT_IF_C Us_BFu31i_Us lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu31i_Us)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu31i_Us)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_Us.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_Us");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_Us");
    check_field_offset(lv, v3, 8, "Us_BFu31i_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_Us, Us_BFu31i_Us)
//============================================================================


struct  Us_BFu31i_Vp  {
  unsigned short v1;
  unsigned int v2:31;
  void *v3;
};
//SIG(1 Us_BFu31i_Vp) C1{ Fs Fi:31 Fp}



static void Test_Us_BFu31i_Vp()
{
  {
    init_simple_test("Us_BFu31i_Vp");
    static STRUCT_IF_C Us_BFu31i_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31i_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31i_Vp)");
    check_field_offset(lv, v1, 0, "Us_BFu31i_Vp.v1");
    set_bf_and_test(lv, v2, 4, 0, 31, 1, "Us_BFu31i_Vp");
    set_bf_and_test(lv, v2, 4, 0, 31, hide_ull(1LL<<30), "Us_BFu31i_Vp");
    check_field_offset(lv, v3, 8, "Us_BFu31i_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31i_Vp, Us_BFu31i_Vp)
//============================================================================


struct  Us_BFu31ll  {
  unsigned short v1;
  __tsu64 v2:31;
};
//SIG(1 Us_BFu31ll) C1{ Fs FL:31}



static void Test_Us_BFu31ll()
{
  {
    init_simple_test("Us_BFu31ll");
    static STRUCT_IF_C Us_BFu31ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll, Us_BFu31ll)
//============================================================================


struct  Us_BFu31ll_BFu15i  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned int v3:15;
};
//SIG(1 Us_BFu31ll_BFu15i) C1{ Fs FL:31 Fi:15}



static void Test_Us_BFu31ll_BFu15i()
{
  {
    init_simple_test("Us_BFu31ll_BFu15i");
    static STRUCT_IF_C Us_BFu31ll_BFu15i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu15i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu15i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu15i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "Us_BFu31ll_BFu15i");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "Us_BFu31ll_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu15i, Us_BFu31ll_BFu15i)
//============================================================================


struct  Us_BFu31ll_BFu15ll  {
  unsigned short v1;
  __tsu64 v2:31;
  __tsu64 v3:15;
};
//SIG(1 Us_BFu31ll_BFu15ll) C1{ Fs FL:31 FL:15}



static void Test_Us_BFu31ll_BFu15ll()
{
  {
    init_simple_test("Us_BFu31ll_BFu15ll");
    static STRUCT_IF_C Us_BFu31ll_BFu15ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu15ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, 1, "Us_BFu31ll_BFu15ll");
    set_bf_and_test(lv, v3, 5, 7, 15, hide_ull(1LL<<14), "Us_BFu31ll_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu15ll, Us_BFu31ll_BFu15ll)
//============================================================================


struct  Us_BFu31ll_BFu15s  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned short v3:15;
};
//SIG(1 Us_BFu31ll_BFu15s) C1{ Fs FL:31 Fs:15}



static void Test_Us_BFu31ll_BFu15s()
{
  {
    init_simple_test("Us_BFu31ll_BFu15s");
    static STRUCT_IF_C Us_BFu31ll_BFu15s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu15s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu15s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu15s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, 1, "Us_BFu31ll_BFu15s");
    set_bf_and_test(lv, v3, 6, 0, 15, hide_ull(1LL<<14), "Us_BFu31ll_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu15s, Us_BFu31ll_BFu15s)
//============================================================================


struct  Us_BFu31ll_BFu16i  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned int v3:16;
};
//SIG(1 Us_BFu31ll_BFu16i) C1{ Fs FL:31 Fi:16}



static void Test_Us_BFu31ll_BFu16i()
{
  {
    init_simple_test("Us_BFu31ll_BFu16i");
    static STRUCT_IF_C Us_BFu31ll_BFu16i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu16i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu16i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu16i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "Us_BFu31ll_BFu16i");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "Us_BFu31ll_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu16i, Us_BFu31ll_BFu16i)
//============================================================================


struct  Us_BFu31ll_BFu16ll  {
  unsigned short v1;
  __tsu64 v2:31;
  __tsu64 v3:16;
};
//SIG(1 Us_BFu31ll_BFu16ll) C1{ Fs FL:31 FL:16}



static void Test_Us_BFu31ll_BFu16ll()
{
  {
    init_simple_test("Us_BFu31ll_BFu16ll");
    static STRUCT_IF_C Us_BFu31ll_BFu16ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu16ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, 1, "Us_BFu31ll_BFu16ll");
    set_bf_and_test(lv, v3, 5, 7, 16, hide_ull(1LL<<15), "Us_BFu31ll_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu16ll, Us_BFu31ll_BFu16ll)
//============================================================================


struct  Us_BFu31ll_BFu16s  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned short v3:16;
};
//SIG(1 Us_BFu31ll_BFu16s) C1{ Fs FL:31 Fs:16}



static void Test_Us_BFu31ll_BFu16s()
{
  {
    init_simple_test("Us_BFu31ll_BFu16s");
    static STRUCT_IF_C Us_BFu31ll_BFu16s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu16s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu16s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu16s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, 1, "Us_BFu31ll_BFu16s");
    set_bf_and_test(lv, v3, 6, 0, 16, hide_ull(1LL<<15), "Us_BFu31ll_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu16s, Us_BFu31ll_BFu16s)
//============================================================================


struct  Us_BFu31ll_BFu17i  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned int v3:17;
};
//SIG(1 Us_BFu31ll_BFu17i) C1{ Fs FL:31 Fi:17}



static void Test_Us_BFu31ll_BFu17i()
{
  {
    init_simple_test("Us_BFu31ll_BFu17i");
    static STRUCT_IF_C Us_BFu31ll_BFu17i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu17i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu17i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu17i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "Us_BFu31ll_BFu17i");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "Us_BFu31ll_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu17i, Us_BFu31ll_BFu17i)
//============================================================================


struct  Us_BFu31ll_BFu17ll  {
  unsigned short v1;
  __tsu64 v2:31;
  __tsu64 v3:17;
};
//SIG(1 Us_BFu31ll_BFu17ll) C1{ Fs FL:31 FL:17}



static void Test_Us_BFu31ll_BFu17ll()
{
  {
    init_simple_test("Us_BFu31ll_BFu17ll");
    static STRUCT_IF_C Us_BFu31ll_BFu17ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu17ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, 1, "Us_BFu31ll_BFu17ll");
    set_bf_and_test(lv, v3, 5, 7, 17, hide_ull(1LL<<16), "Us_BFu31ll_BFu17ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu17ll, Us_BFu31ll_BFu17ll)
//============================================================================


struct  Us_BFu31ll_BFu1c  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned char v3:1;
};
//SIG(1 Us_BFu31ll_BFu1c) C1{ Fs FL:31 Fc:1}



static void Test_Us_BFu31ll_BFu1c()
{
  {
    init_simple_test("Us_BFu31ll_BFu1c");
    static STRUCT_IF_C Us_BFu31ll_BFu1c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu1c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu1c)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu1c.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu1c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu1c");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "Us_BFu31ll_BFu1c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu1c, Us_BFu31ll_BFu1c)
//============================================================================


struct  Us_BFu31ll_BFu1i  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned int v3:1;
};
//SIG(1 Us_BFu31ll_BFu1i) C1{ Fs FL:31 Fi:1}



static void Test_Us_BFu31ll_BFu1i()
{
  {
    init_simple_test("Us_BFu31ll_BFu1i");
    static STRUCT_IF_C Us_BFu31ll_BFu1i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu1i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu1i)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu1i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu1i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu1i");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "Us_BFu31ll_BFu1i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu1i, Us_BFu31ll_BFu1i)
//============================================================================


struct  Us_BFu31ll_BFu1ll  {
  unsigned short v1;
  __tsu64 v2:31;
  __tsu64 v3:1;
};
//SIG(1 Us_BFu31ll_BFu1ll) C1{ Fs FL:31 FL:1}



static void Test_Us_BFu31ll_BFu1ll()
{
  {
    init_simple_test("Us_BFu31ll_BFu1ll");
    static STRUCT_IF_C Us_BFu31ll_BFu1ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu1ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu1ll)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu1ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu1ll");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "Us_BFu31ll_BFu1ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu1ll, Us_BFu31ll_BFu1ll)
//============================================================================


struct  Us_BFu31ll_BFu1s  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned short v3:1;
};
//SIG(1 Us_BFu31ll_BFu1s) C1{ Fs FL:31 Fs:1}



static void Test_Us_BFu31ll_BFu1s()
{
  {
    init_simple_test("Us_BFu31ll_BFu1s");
    static STRUCT_IF_C Us_BFu31ll_BFu1s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu1s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu1s)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu1s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu1s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu1s");
    set_bf_and_test(lv, v3, 5, 7, 1, 1, "Us_BFu31ll_BFu1s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu1s, Us_BFu31ll_BFu1s)
//============================================================================


struct  Us_BFu31ll_BFu31i  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned int v3:31;
};
//SIG(1 Us_BFu31ll_BFu31i) C1{ Fs FL:31 Fi:31}



static void Test_Us_BFu31ll_BFu31i()
{
  {
    init_simple_test("Us_BFu31ll_BFu31i");
    static STRUCT_IF_C Us_BFu31ll_BFu31i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31ll_BFu31i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu31i)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu31i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu31i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, 1, "Us_BFu31ll_BFu31i");
    set_bf_and_test(lv, v3, 8, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu31i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu31i, Us_BFu31ll_BFu31i)
//============================================================================


struct  Us_BFu31ll_BFu31ll  {
  unsigned short v1;
  __tsu64 v2:31;
  __tsu64 v3:31;
};
//SIG(1 Us_BFu31ll_BFu31ll) C1{ Fs FL:31 FL:31}



static void Test_Us_BFu31ll_BFu31ll()
{
  {
    init_simple_test("Us_BFu31ll_BFu31ll");
    static STRUCT_IF_C Us_BFu31ll_BFu31ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31ll_BFu31ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu31ll)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu31ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 31, 1, "Us_BFu31ll_BFu31ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu31ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu31ll, Us_BFu31ll_BFu31ll)
//============================================================================


struct  Us_BFu31ll_BFu32i  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned int v3:32;
};
//SIG(1 Us_BFu31ll_BFu32i) C1{ Fs FL:31 Fi:32}



static void Test_Us_BFu31ll_BFu32i()
{
  {
    init_simple_test("Us_BFu31ll_BFu32i");
    static STRUCT_IF_C Us_BFu31ll_BFu32i lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31ll_BFu32i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu32i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu32i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, 1, "Us_BFu31ll_BFu32i");
    set_bf_and_test(lv, v3, 8, 0, 32, hide_ull(1LL<<31), "Us_BFu31ll_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu32i, Us_BFu31ll_BFu32i)
//============================================================================


struct  Us_BFu31ll_BFu32ll  {
  unsigned short v1;
  __tsu64 v2:31;
  __tsu64 v3:32;
};
//SIG(1 Us_BFu31ll_BFu32ll) C1{ Fs FL:31 FL:32}



static void Test_Us_BFu31ll_BFu32ll()
{
  {
    init_simple_test("Us_BFu31ll_BFu32ll");
    static STRUCT_IF_C Us_BFu31ll_BFu32ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31ll_BFu32ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu32ll)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu32ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 32, 1, "Us_BFu31ll_BFu32ll");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 32, hide_ull(1LL<<31), "Us_BFu31ll_BFu32ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu32ll, Us_BFu31ll_BFu32ll)
//============================================================================


struct  Us_BFu31ll_BFu33  {
  unsigned short v1;
  __tsu64 v2:31;
  __tsu64 v3:33;
};
//SIG(1 Us_BFu31ll_BFu33) C1{ Fs FL:31 FL:33}



static void Test_Us_BFu31ll_BFu33()
{
  {
    init_simple_test("Us_BFu31ll_BFu33");
    static STRUCT_IF_C Us_BFu31ll_BFu33 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31ll_BFu33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu33)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu33.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu33");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 33, 1, "Us_BFu31ll_BFu33");
    set_bf_and_test(lv, v3, ABISELECT(8,5), ABISELECT(0,7), 33, hide_ull(1LL<<32), "Us_BFu31ll_BFu33");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu33, Us_BFu31ll_BFu33)
//============================================================================


struct  Us_BFu31ll_BFu7c  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned char v3:7;
};
//SIG(1 Us_BFu31ll_BFu7c) C1{ Fs FL:31 Fc:7}



static void Test_Us_BFu31ll_BFu7c()
{
  {
    init_simple_test("Us_BFu31ll_BFu7c");
    static STRUCT_IF_C Us_BFu31ll_BFu7c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu7c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu7c)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu7c.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu7c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Us_BFu31ll_BFu7c");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Us_BFu31ll_BFu7c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu7c, Us_BFu31ll_BFu7c)
//============================================================================


struct  Us_BFu31ll_BFu7i  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned int v3:7;
};
//SIG(1 Us_BFu31ll_BFu7i) C1{ Fs FL:31 Fi:7}



static void Test_Us_BFu31ll_BFu7i()
{
  {
    init_simple_test("Us_BFu31ll_BFu7i");
    static STRUCT_IF_C Us_BFu31ll_BFu7i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu7i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu7i)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu7i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu7i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "Us_BFu31ll_BFu7i");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "Us_BFu31ll_BFu7i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu7i, Us_BFu31ll_BFu7i)
//============================================================================


struct  Us_BFu31ll_BFu7ll  {
  unsigned short v1;
  __tsu64 v2:31;
  __tsu64 v3:7;
};
//SIG(1 Us_BFu31ll_BFu7ll) C1{ Fs FL:31 FL:7}



static void Test_Us_BFu31ll_BFu7ll()
{
  {
    init_simple_test("Us_BFu31ll_BFu7ll");
    static STRUCT_IF_C Us_BFu31ll_BFu7ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu7ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu7ll)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu7ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, 1, "Us_BFu31ll_BFu7ll");
    set_bf_and_test(lv, v3, 5, 7, 7, hide_ull(1LL<<6), "Us_BFu31ll_BFu7ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu7ll, Us_BFu31ll_BFu7ll)
//============================================================================


struct  Us_BFu31ll_BFu7s  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned short v3:7;
};
//SIG(1 Us_BFu31ll_BFu7s) C1{ Fs FL:31 Fs:7}



static void Test_Us_BFu31ll_BFu7s()
{
  {
    init_simple_test("Us_BFu31ll_BFu7s");
    static STRUCT_IF_C Us_BFu31ll_BFu7s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu7s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu7s)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu7s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu7s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, 1, "Us_BFu31ll_BFu7s");
    set_bf_and_test(lv, v3, 6, 0, 7, hide_ull(1LL<<6), "Us_BFu31ll_BFu7s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu7s, Us_BFu31ll_BFu7s)
//============================================================================


struct  Us_BFu31ll_BFu8c  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned char v3:8;
};
//SIG(1 Us_BFu31ll_BFu8c) C1{ Fs FL:31 Fc:8}



static void Test_Us_BFu31ll_BFu8c()
{
  {
    init_simple_test("Us_BFu31ll_BFu8c");
    static STRUCT_IF_C Us_BFu31ll_BFu8c lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu8c)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu8c)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu8c.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu8c");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Us_BFu31ll_BFu8c");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Us_BFu31ll_BFu8c");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu8c, Us_BFu31ll_BFu8c)
//============================================================================


struct  Us_BFu31ll_BFu8i  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned int v3:8;
};
//SIG(1 Us_BFu31ll_BFu8i) C1{ Fs FL:31 Fi:8}



static void Test_Us_BFu31ll_BFu8i()
{
  {
    init_simple_test("Us_BFu31ll_BFu8i");
    static STRUCT_IF_C Us_BFu31ll_BFu8i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu8i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu8i)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu8i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu8i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "Us_BFu31ll_BFu8i");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "Us_BFu31ll_BFu8i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu8i, Us_BFu31ll_BFu8i)
//============================================================================


struct  Us_BFu31ll_BFu8ll  {
  unsigned short v1;
  __tsu64 v2:31;
  __tsu64 v3:8;
};
//SIG(1 Us_BFu31ll_BFu8ll) C1{ Fs FL:31 FL:8}



static void Test_Us_BFu31ll_BFu8ll()
{
  {
    init_simple_test("Us_BFu31ll_BFu8ll");
    static STRUCT_IF_C Us_BFu31ll_BFu8ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu8ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu8ll)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu8ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, 1, "Us_BFu31ll_BFu8ll");
    set_bf_and_test(lv, v3, 5, 7, 8, hide_ull(1LL<<7), "Us_BFu31ll_BFu8ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu8ll, Us_BFu31ll_BFu8ll)
//============================================================================


struct  Us_BFu31ll_BFu8s  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned short v3:8;
};
//SIG(1 Us_BFu31ll_BFu8s) C1{ Fs FL:31 Fs:8}



static void Test_Us_BFu31ll_BFu8s()
{
  {
    init_simple_test("Us_BFu31ll_BFu8s");
    static STRUCT_IF_C Us_BFu31ll_BFu8s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu8s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu8s)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu8s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu8s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, 1, "Us_BFu31ll_BFu8s");
    set_bf_and_test(lv, v3, 6, 0, 8, hide_ull(1LL<<7), "Us_BFu31ll_BFu8s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu8s, Us_BFu31ll_BFu8s)
//============================================================================


struct  Us_BFu31ll_BFu9i  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned int v3:9;
};
//SIG(1 Us_BFu31ll_BFu9i) C1{ Fs FL:31 Fi:9}



static void Test_Us_BFu31ll_BFu9i()
{
  {
    init_simple_test("Us_BFu31ll_BFu9i");
    static STRUCT_IF_C Us_BFu31ll_BFu9i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu9i)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu9i)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu9i.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu9i");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "Us_BFu31ll_BFu9i");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "Us_BFu31ll_BFu9i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu9i, Us_BFu31ll_BFu9i)
//============================================================================


struct  Us_BFu31ll_BFu9ll  {
  unsigned short v1;
  __tsu64 v2:31;
  __tsu64 v3:9;
};
//SIG(1 Us_BFu31ll_BFu9ll) C1{ Fs FL:31 FL:9}



static void Test_Us_BFu31ll_BFu9ll()
{
  {
    init_simple_test("Us_BFu31ll_BFu9ll");
    static STRUCT_IF_C Us_BFu31ll_BFu9ll lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu9ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu9ll)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu9ll.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, 1, "Us_BFu31ll_BFu9ll");
    set_bf_and_test(lv, v3, 5, 7, 9, hide_ull(1LL<<8), "Us_BFu31ll_BFu9ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu9ll, Us_BFu31ll_BFu9ll)
//============================================================================


struct  Us_BFu31ll_BFu9s  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned short v3:9;
};
//SIG(1 Us_BFu31ll_BFu9s) C1{ Fs FL:31 Fs:9}



static void Test_Us_BFu31ll_BFu9s()
{
  {
    init_simple_test("Us_BFu31ll_BFu9s");
    static STRUCT_IF_C Us_BFu31ll_BFu9s lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_BFu9s)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_BFu9s)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_BFu9s.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_BFu9s");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, 1, "Us_BFu31ll_BFu9s");
    set_bf_and_test(lv, v3, 6, 0, 9, hide_ull(1LL<<8), "Us_BFu31ll_BFu9s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_BFu9s, Us_BFu31ll_BFu9s)
//============================================================================


struct  Us_BFu31ll_C  {
  unsigned short v1;
  __tsu64 v2:31;
  char v3;
};
//SIG(1 Us_BFu31ll_C) C1{ Fs FL:31 Fc}



static void Test_Us_BFu31ll_C()
{
  {
    init_simple_test("Us_BFu31ll_C");
    static STRUCT_IF_C Us_BFu31ll_C lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_C)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_C)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_C.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_C");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_C");
    check_field_offset(lv, v3, 6, "Us_BFu31ll_C.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_C, Us_BFu31ll_C)
//============================================================================


struct  Us_BFu31ll_D  {
  unsigned short v1;
  __tsu64 v2:31;
  double v3;
};
//SIG(1 Us_BFu31ll_D) C1{ Fs FL:31 FL}



static void Test_Us_BFu31ll_D()
{
  {
    init_simple_test("Us_BFu31ll_D");
    static STRUCT_IF_C Us_BFu31ll_D lv;
    check2(sizeof(lv), 16, "sizeof(Us_BFu31ll_D)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_D)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_D.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_D");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_D");
    check_field_offset(lv, v3, 8, "Us_BFu31ll_D.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_D, Us_BFu31ll_D)
//============================================================================


struct  Us_BFu31ll_F  {
  unsigned short v1;
  __tsu64 v2:31;
  float v3;
};
//SIG(1 Us_BFu31ll_F) C1{ Fs FL:31 Fi}



static void Test_Us_BFu31ll_F()
{
  {
    init_simple_test("Us_BFu31ll_F");
    static STRUCT_IF_C Us_BFu31ll_F lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31ll_F)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_F)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_F.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_F");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_F");
    check_field_offset(lv, v3, 8, "Us_BFu31ll_F.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_F, Us_BFu31ll_F)
//============================================================================


struct  Us_BFu31ll_I  {
  unsigned short v1;
  __tsu64 v2:31;
  int v3;
};
//SIG(1 Us_BFu31ll_I) C1{ Fs FL:31 Fi}



static void Test_Us_BFu31ll_I()
{
  {
    init_simple_test("Us_BFu31ll_I");
    static STRUCT_IF_C Us_BFu31ll_I lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31ll_I)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_I)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_I.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_I");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_I");
    check_field_offset(lv, v3, 8, "Us_BFu31ll_I.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_I, Us_BFu31ll_I)
//============================================================================


struct  Us_BFu31ll_Ip  {
  unsigned short v1;
  __tsu64 v2:31;
  int *v3;
};
//SIG(1 Us_BFu31ll_Ip) C1{ Fs FL:31 Fp}



static void Test_Us_BFu31ll_Ip()
{
  {
    init_simple_test("Us_BFu31ll_Ip");
    static STRUCT_IF_C Us_BFu31ll_Ip lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31ll_Ip)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_Ip)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_Ip.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_Ip");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_Ip");
    check_field_offset(lv, v3, 8, "Us_BFu31ll_Ip.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_Ip, Us_BFu31ll_Ip)
//============================================================================


struct  Us_BFu31ll_L  {
  unsigned short v1;
  __tsu64 v2:31;
  __tsi64 v3;
};
//SIG(1 Us_BFu31ll_L) C1{ Fs FL:31 FL}



static void Test_Us_BFu31ll_L()
{
  {
    init_simple_test("Us_BFu31ll_L");
    static STRUCT_IF_C Us_BFu31ll_L lv;
    check2(sizeof(lv), 16, "sizeof(Us_BFu31ll_L)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_L)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_L.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_L");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_L");
    check_field_offset(lv, v3, 8, "Us_BFu31ll_L.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_L, Us_BFu31ll_L)
//============================================================================


struct  Us_BFu31ll_S  {
  unsigned short v1;
  __tsu64 v2:31;
  short v3;
};
//SIG(1 Us_BFu31ll_S) C1{ Fs FL:31 Fs}



static void Test_Us_BFu31ll_S()
{
  {
    init_simple_test("Us_BFu31ll_S");
    static STRUCT_IF_C Us_BFu31ll_S lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_S)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_S)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_S.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_S");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_S");
    check_field_offset(lv, v3, 6, "Us_BFu31ll_S.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_S, Us_BFu31ll_S)
//============================================================================


struct  Us_BFu31ll_Uc  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned char v3;
};
//SIG(1 Us_BFu31ll_Uc) C1{ Fs FL:31 Fc}



static void Test_Us_BFu31ll_Uc()
{
  {
    init_simple_test("Us_BFu31ll_Uc");
    static STRUCT_IF_C Us_BFu31ll_Uc lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_Uc)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_Uc)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_Uc.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_Uc");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_Uc");
    check_field_offset(lv, v3, 6, "Us_BFu31ll_Uc.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_Uc, Us_BFu31ll_Uc)
//============================================================================


struct  Us_BFu31ll_Ui  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned int v3;
};
//SIG(1 Us_BFu31ll_Ui) C1{ Fs FL:31 Fi}



static void Test_Us_BFu31ll_Ui()
{
  {
    init_simple_test("Us_BFu31ll_Ui");
    static STRUCT_IF_C Us_BFu31ll_Ui lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31ll_Ui)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_Ui)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_Ui.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_Ui");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_Ui");
    check_field_offset(lv, v3, 8, "Us_BFu31ll_Ui.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_Ui, Us_BFu31ll_Ui)
//============================================================================


struct  Us_BFu31ll_Ul  {
  unsigned short v1;
  __tsu64 v2:31;
  __tsu64 v3;
};
//SIG(1 Us_BFu31ll_Ul) C1{ Fs FL:31 FL}



static void Test_Us_BFu31ll_Ul()
{
  {
    init_simple_test("Us_BFu31ll_Ul");
    static STRUCT_IF_C Us_BFu31ll_Ul lv;
    check2(sizeof(lv), 16, "sizeof(Us_BFu31ll_Ul)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_Ul)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_Ul.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_Ul");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_Ul");
    check_field_offset(lv, v3, 8, "Us_BFu31ll_Ul.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_Ul, Us_BFu31ll_Ul)
//============================================================================


struct  Us_BFu31ll_Us  {
  unsigned short v1;
  __tsu64 v2:31;
  unsigned short v3;
};
//SIG(1 Us_BFu31ll_Us) C1{ Fs FL:31 Fs}



static void Test_Us_BFu31ll_Us()
{
  {
    init_simple_test("Us_BFu31ll_Us");
    static STRUCT_IF_C Us_BFu31ll_Us lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu31ll_Us)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_Us)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_Us.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_Us");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_Us");
    check_field_offset(lv, v3, 6, "Us_BFu31ll_Us.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_Us, Us_BFu31ll_Us)
//============================================================================


struct  Us_BFu31ll_Vp  {
  unsigned short v1;
  __tsu64 v2:31;
  void *v3;
};
//SIG(1 Us_BFu31ll_Vp) C1{ Fs FL:31 Fp}



static void Test_Us_BFu31ll_Vp()
{
  {
    init_simple_test("Us_BFu31ll_Vp");
    static STRUCT_IF_C Us_BFu31ll_Vp lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu31ll_Vp)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu31ll_Vp)");
    check_field_offset(lv, v1, 0, "Us_BFu31ll_Vp.v1");
    set_bf_and_test(lv, v2, 2, 0, 31, 1, "Us_BFu31ll_Vp");
    set_bf_and_test(lv, v2, 2, 0, 31, hide_ull(1LL<<30), "Us_BFu31ll_Vp");
    check_field_offset(lv, v3, 8, "Us_BFu31ll_Vp.v3");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu31ll_Vp, Us_BFu31ll_Vp)
//============================================================================


struct  Us_BFu32i  {
  unsigned short v1;
  unsigned int v2:32;
};
//SIG(1 Us_BFu32i) C1{ Fs Fi:32}



static void Test_Us_BFu32i()
{
  {
    init_simple_test("Us_BFu32i");
    static STRUCT_IF_C Us_BFu32i lv;
    check2(sizeof(lv), 8, "sizeof(Us_BFu32i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu32i)");
    check_field_offset(lv, v1, 0, "Us_BFu32i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Us_BFu32i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu32i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu32i, Us_BFu32i)
//============================================================================


struct  Us_BFu32i_BFu15i  {
  unsigned short v1;
  unsigned int v2:32;
  unsigned int v3:15;
};
//SIG(1 Us_BFu32i_BFu15i) C1{ Fs Fi:32 Fi:15}



static void Test_Us_BFu32i_BFu15i()
{
  {
    init_simple_test("Us_BFu32i_BFu15i");
    static STRUCT_IF_C Us_BFu32i_BFu15i lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu32i_BFu15i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu32i_BFu15i)");
    check_field_offset(lv, v1, 0, "Us_BFu32i_BFu15i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Us_BFu32i_BFu15i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Us_BFu32i_BFu15i");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Us_BFu32i_BFu15i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu32i_BFu15i, Us_BFu32i_BFu15i)
//============================================================================


struct  Us_BFu32i_BFu15ll  {
  unsigned short v1;
  unsigned int v2:32;
  __tsu64 v3:15;
};
//SIG(1 Us_BFu32i_BFu15ll) C1{ Fs Fi:32 FL:15}



static void Test_Us_BFu32i_BFu15ll()
{
  {
    init_simple_test("Us_BFu32i_BFu15ll");
    static STRUCT_IF_C Us_BFu32i_BFu15ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu32i_BFu15ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu32i_BFu15ll)");
    check_field_offset(lv, v1, 0, "Us_BFu32i_BFu15ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Us_BFu32i_BFu15ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Us_BFu32i_BFu15ll");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Us_BFu32i_BFu15ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu32i_BFu15ll, Us_BFu32i_BFu15ll)
//============================================================================


struct  Us_BFu32i_BFu15s  {
  unsigned short v1;
  unsigned int v2:32;
  unsigned short v3:15;
};
//SIG(1 Us_BFu32i_BFu15s) C1{ Fs Fi:32 Fs:15}



static void Test_Us_BFu32i_BFu15s()
{
  {
    init_simple_test("Us_BFu32i_BFu15s");
    static STRUCT_IF_C Us_BFu32i_BFu15s lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu32i_BFu15s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu32i_BFu15s)");
    check_field_offset(lv, v1, 0, "Us_BFu32i_BFu15s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Us_BFu32i_BFu15s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, 1, "Us_BFu32i_BFu15s");
    set_bf_and_test(lv, v3, 8, 0, 15, hide_ull(1LL<<14), "Us_BFu32i_BFu15s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu32i_BFu15s, Us_BFu32i_BFu15s)
//============================================================================


struct  Us_BFu32i_BFu16i  {
  unsigned short v1;
  unsigned int v2:32;
  unsigned int v3:16;
};
//SIG(1 Us_BFu32i_BFu16i) C1{ Fs Fi:32 Fi:16}



static void Test_Us_BFu32i_BFu16i()
{
  {
    init_simple_test("Us_BFu32i_BFu16i");
    static STRUCT_IF_C Us_BFu32i_BFu16i lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu32i_BFu16i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu32i_BFu16i)");
    check_field_offset(lv, v1, 0, "Us_BFu32i_BFu16i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Us_BFu32i_BFu16i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Us_BFu32i_BFu16i");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Us_BFu32i_BFu16i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu32i_BFu16i, Us_BFu32i_BFu16i)
//============================================================================


struct  Us_BFu32i_BFu16ll  {
  unsigned short v1;
  unsigned int v2:32;
  __tsu64 v3:16;
};
//SIG(1 Us_BFu32i_BFu16ll) C1{ Fs Fi:32 FL:16}



static void Test_Us_BFu32i_BFu16ll()
{
  {
    init_simple_test("Us_BFu32i_BFu16ll");
    static STRUCT_IF_C Us_BFu32i_BFu16ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu32i_BFu16ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu32i_BFu16ll)");
    check_field_offset(lv, v1, 0, "Us_BFu32i_BFu16ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Us_BFu32i_BFu16ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Us_BFu32i_BFu16ll");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Us_BFu32i_BFu16ll");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu32i_BFu16ll, Us_BFu32i_BFu16ll)
//============================================================================


struct  Us_BFu32i_BFu16s  {
  unsigned short v1;
  unsigned int v2:32;
  unsigned short v3:16;
};
//SIG(1 Us_BFu32i_BFu16s) C1{ Fs Fi:32 Fs:16}



static void Test_Us_BFu32i_BFu16s()
{
  {
    init_simple_test("Us_BFu32i_BFu16s");
    static STRUCT_IF_C Us_BFu32i_BFu16s lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu32i_BFu16s)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu32i_BFu16s)");
    check_field_offset(lv, v1, 0, "Us_BFu32i_BFu16s.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Us_BFu32i_BFu16s");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, 1, "Us_BFu32i_BFu16s");
    set_bf_and_test(lv, v3, 8, 0, 16, hide_ull(1LL<<15), "Us_BFu32i_BFu16s");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu32i_BFu16s, Us_BFu32i_BFu16s)
//============================================================================


struct  Us_BFu32i_BFu17i  {
  unsigned short v1;
  unsigned int v2:32;
  unsigned int v3:17;
};
//SIG(1 Us_BFu32i_BFu17i) C1{ Fs Fi:32 Fi:17}



static void Test_Us_BFu32i_BFu17i()
{
  {
    init_simple_test("Us_BFu32i_BFu17i");
    static STRUCT_IF_C Us_BFu32i_BFu17i lv;
    check2(sizeof(lv), 12, "sizeof(Us_BFu32i_BFu17i)");
    check2(__alignof__(lv), 4, "__alignof__(Us_BFu32i_BFu17i)");
    check_field_offset(lv, v1, 0, "Us_BFu32i_BFu17i.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Us_BFu32i_BFu17i");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Us_BFu32i_BFu17i");
    set_bf_and_test(lv, v3, 8, 0, 17, hide_ull(1LL<<16), "Us_BFu32i_BFu17i");
  }
}
ARRANGE_TO_CALL_ME(Test_Us_BFu32i_BFu17i, Us_BFu32i_BFu17i)
//============================================================================


struct  Us_BFu32i_BFu17ll  {
  unsigned short v1;
  unsigned int v2:32;
  __tsu64 v3:17;
};
//SIG(1 Us_BFu32i_BFu17ll) C1{ Fs Fi:32 FL:17}



static void Test_Us_BFu32i_BFu17ll()
{
  {
    init_simple_test("Us_BFu32i_BFu17ll");
    static STRUCT_IF_C Us_BFu32i_BFu17ll lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(Us_BFu32i_BFu17ll)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(Us_BFu32i_BFu17ll)");
    check_field_offset(lv, v1, 0, "Us_BFu32i_BFu17ll.v1");
    set_bf_and_test(lv, v2, 4, 0, 32, 1, "Us_BFu32i_BFu17ll");
    set_bf_and_test(lv, v2, 4, 0, 32, hide_ull(1LL<<31), "Us_BFu32i_BFu17ll");
    set_bf_and_test(lv, v3, 8, 0, 17, 1, "Us_BFu32i_BFu17ll");
    set_bf_and_test(l